/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.excel.atom;

import io.horizon.uca.log.Annal;
import org.apache.poi.ss.util.CellRangeAddress;

public class ExPos {
    private static final Annal LOGGER = Annal.get(ExPos.class);
    private final transient int rowIndex;
    private final transient int colIndex;

    private ExPos(int rowIndex, int colIndex) {
        this.rowIndex = rowIndex;
        this.colIndex = colIndex;
    }

    public static ExPos index(int rowIndex, int colIndex) {
        return new ExPos(rowIndex, colIndex);
    }

    public static ExPos index(int colIndex) {
        return new ExPos(0, colIndex);
    }

    public int rowIndex() {
        return this.rowIndex;
    }

    public int colIndex() {
        return this.colIndex;
    }

    public CellRangeAddress region(int rows, int cols) {
        int rowStart = this.rowIndex;
        int colStart = this.colIndex;
        int rowEnd = this.rowIndex + rows;
        int colEnd = this.colIndex + cols;
        if (rowStart < rowEnd) {
            --rowEnd;
        }
        if (colStart < colEnd) {
            --colEnd;
        }
        int rowAcc = rowEnd - rowStart;
        int colAcc = colEnd - colStart;
        if (0 < rowAcc || 0 < colAcc) {
            LOGGER.debug("[ \u0388\u03be\u03bf\u03b4\u03bf\u03c2 ] Region created: ( Row: {0} ~ {1}, Column: {2} ~ {3} )", new Object[]{rowStart, rowEnd, colStart, colEnd});
            return new CellRangeAddress(rowStart, rowEnd, colStart, colEnd);
        }
        return null;
    }
}

