/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.excel.ranger;

import io.horizon.uca.log.Annal;
import io.modello.atom.typed.MetaAtom;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.plugin.excel.atom.ExRecord;
import io.vertx.tp.plugin.excel.cell.ExValue;
import io.vertx.tp.plugin.excel.ranger.ExIn;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Sheet;

public abstract class AbstractExIn
implements ExIn {
    protected transient Sheet sheet;
    protected transient FormulaEvaluator evaluator;

    public AbstractExIn(Sheet sheet) {
        this.sheet = sheet;
    }

    @Override
    public ExIn bind(FormulaEvaluator evaluator) {
        this.evaluator = evaluator;
        return this;
    }

    protected Annal logger() {
        return Annal.get(this.getClass());
    }

    protected Object extractValue(Cell dataCell, Class<?> type) {
        Object result;
        try {
            result = ExValue.getValue(dataCell, type, this.evaluator);
        }
        catch (Throwable ex) {
            this.logger().fatal(ex);
            ex.printStackTrace();
            result = null;
        }
        return result;
    }

    protected void extractComplex(ConcurrentMap<String, JsonArray> complexMap, ConcurrentMap<String, JsonObject> rowMap) {
        rowMap.forEach((field, record) -> {
            JsonArray original = (JsonArray)complexMap.get(field);
            if (Objects.isNull(original)) {
                original = new JsonArray();
            }
            if (!ExRecord.isEmpty(record)) {
                original.add(record);
            }
            complexMap.put((String)field, original);
        });
        rowMap.clear();
    }

    protected BiConsumer<Cell, MetaAtom> cellConsumer(ConcurrentMap<String, JsonObject> rowMap, String field) {
        return (dataCell, shape) -> {
            String[] fields = field.split("\\.");
            String parent = fields[0];
            String child = fields[1];
            JsonObject original = (JsonObject)rowMap.get(parent);
            if (Objects.isNull(original)) {
                original = new JsonObject();
            }
            Class type = shape.type(parent, child);
            Object value = this.extractValue((Cell)dataCell, type);
            original.put(child, value);
            rowMap.put(parent, original);
        };
    }
}

