/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.excel.ranger;

import io.modello.atom.typed.MetaAtom;
import io.vertx.tp.plugin.excel.atom.ExRecord;
import io.vertx.tp.plugin.excel.atom.ExTable;
import io.vertx.tp.plugin.excel.ranger.AbstractExIn;
import io.vertx.tp.plugin.excel.ranger.ColBound;
import io.vertx.tp.plugin.excel.ranger.ExBound;
import io.vertx.tp.plugin.excel.ranger.RowBound;
import io.vertx.tp.plugin.excel.tool.ExFn;
import io.vertx.up.atom.Refer;
import java.util.Objects;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public class PureIn
extends AbstractExIn {
    public PureIn(Sheet sheet) {
        super(sheet);
    }

    @Override
    public ExBound applyTable(ExTable table, Row row, Cell cell, Integer limitation) {
        Refer hod = new Refer();
        ExFn.onRow(this.sheet, row.getRowNum() + 2, foundRow -> {
            ColBound bound = new ColBound(cell.getColumnIndex(), foundRow.getLastCellNum());
            ExFn.itRow(foundRow, bound, (foundCell, colIndex) -> table.add(foundCell.getStringCellValue()));
            hod.add((Object)new RowBound(foundRow.getRowNum() + 1, limitation));
        });
        return (ExBound)hod.get();
    }

    @Override
    public ExTable applyData(ExTable table, ExBound dataRange, Cell cell, MetaAtom metaAtom) {
        ExFn.itSheet(this.sheet, dataRange, (dataRow, rowIndex) -> {
            ColBound bound = new ColBound(cell.getColumnIndex(), cell.getColumnIndex() + table.size());
            ExRecord record = new ExRecord();
            ExFn.itRow(dataRow, bound, (dataCell, cellIndex) -> {
                String field = table.field((int)cellIndex);
                if (Objects.nonNull(field)) {
                    Class type = metaAtom.type(field);
                    Object value = this.extractValue((Cell)dataCell, type);
                    record.put(field, value);
                } else {
                    this.logger().warn("Field (index = {0}) could not be found", new Object[]{cellIndex});
                }
            });
            if (!record.isEmpty()) {
                table.add(record);
            }
        });
        return table;
    }
}

