/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.excel.tool;

import io.modello.atom.typed.MetaAtom;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.plugin.excel.atom.ExPos;
import io.vertx.tp.plugin.excel.tool.ExOut;
import io.vertx.up.fn.Fn;
import io.vertx.up.util.Ut;
import java.util.IntSummaryStatistics;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;

class ExData {
    ExData() {
    }

    static void generateAdjust(Sheet sheet, List<Integer> sizeList) {
        IntSummaryStatistics statistics = sizeList.stream().mapToInt(Integer::intValue).summaryStatistics();
        int max = statistics.getMax();
        for (int idx = 0; idx < max; ++idx) {
            sheet.autoSizeColumn(idx, true);
        }
    }

    static void generateData(Sheet sheet, Integer index, JsonArray rowData, List<Class<?>> types) {
        Row row = sheet.createRow(index.intValue());
        int size = rowData.size();
        for (int colIdx = 0; colIdx < size; ++colIdx) {
            ExPos pos = ExPos.index(index, colIdx);
            Class<?> type = colIdx < types.size() ? types.get(colIdx) : null;
            ExData.createCell(sheet, row, pos, rowData.getValue(colIdx), type);
        }
    }

    static boolean generateHeader(Sheet sheet, String identifier, JsonArray tableData, MetaAtom metaAtom) {
        Consumer<Integer> consumer = width -> {
            Row row = sheet.createRow(0);
            ExPos pos = ExPos.index(2);
            ExData.createCell(sheet, row, ExPos.index(0), "{TABLE}");
            ExData.createCell(sheet, row, ExPos.index(1), identifier);
            ExData.createCell(sheet, row, pos, null);
            CellRangeAddress region = pos.region(0, width - 1);
            if (Objects.nonNull(region)) {
                Fn.jvmAt(() -> sheet.addMergedRegion(region));
            }
        };
        if (metaAtom.isComplex()) {
            if (4 <= tableData.size()) {
                JsonArray labelHeader = Ut.valueJArray((JsonArray)tableData.getJsonArray(1));
                JsonArray fieldHeader = Ut.valueJArray((JsonArray)tableData.getJsonArray(3));
                consumer.accept(Math.max(labelHeader.size(), fieldHeader.size()));
                return true;
            }
            return false;
        }
        if (2 <= tableData.size()) {
            JsonArray labelHeader = Ut.valueJArray((JsonArray)tableData.getJsonArray(0));
            JsonArray fieldHeader = Ut.valueJArray((JsonArray)tableData.getJsonArray(1));
            consumer.accept(Math.max(labelHeader.size(), fieldHeader.size()));
            return true;
        }
        return false;
    }

    private static void createCell(Sheet sheet, Row row, ExPos pos, Object value) {
        ExData.createCell(sheet, row, pos, value, null);
    }

    private static void createCell(Sheet sheet, Row row, ExPos pos, Object value, Class<?> type) {
        if (value instanceof JsonObject) {
            JsonObject define = (JsonObject)value;
            Object input = define.getValue("value");
            ExData.createCell(row, pos.colIndex(), input, type);
            int cols = define.getInteger("cols");
            int rows = define.getInteger("rows");
            CellRangeAddress region = pos.region(rows, cols);
            if (Objects.nonNull(region)) {
                Fn.jvmAt(() -> sheet.addMergedRegion(region));
            }
        } else {
            ExData.createCell(row, pos.colIndex(), value, type);
        }
    }

    private static void createCell(Row row, Integer index, Object value, Class<?> typeDef) {
        if (Objects.isNull(value)) {
            Cell cell = row.createCell(index.intValue());
            cell.setCellValue("");
        } else {
            Class<?> type = Objects.isNull(typeDef) ? value.getClass() : typeDef;
            CellType cellType = ExOut.type(type);
            Cell cell = row.createCell(index.intValue(), cellType);
            ExOut.value(cell, type, value);
        }
    }
}

