/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.excel.tool;

import io.modello.atom.typed.MetaAtom;
import io.vertx.core.json.JsonArray;
import io.vertx.tp.plugin.excel.ranger.ExBound;
import io.vertx.tp.plugin.excel.tool.ExData;
import io.vertx.up.util.Ut;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public class ExFn {
    public static void itSheet(Sheet sheet, ExBound bound, BiConsumer<Row, Integer> consumer) {
        int start = bound.getStart();
        int end = bound.getEnd();
        for (int idx = start; idx <= end; ++idx) {
            Row row = sheet.getRow(idx);
            if (null == row) continue;
            consumer.accept(row, idx);
        }
    }

    public static void itSheet(Sheet sheet, ExBound bound, Set<Integer> indexSet, Consumer<List<Row>> consumer) {
        int start = bound.getStart();
        int end = bound.getEnd();
        ArrayList matrix = new ArrayList();
        ArrayList<Row> parameters = new ArrayList<Row>();
        for (int idx = start; idx <= end; ++idx) {
            Row row = sheet.getRow(idx);
            boolean isPrevRow = indexSet.stream().map(arg_0 -> ((Row)row).getCell(arg_0)).allMatch(cell -> {
                if (CellType.BLANK == cell.getCellType()) {
                    return true;
                }
                if (CellType.STRING == cell.getCellType()) {
                    return Ut.isNil((String)cell.getStringCellValue());
                }
                return false;
            });
            if (!isPrevRow && !parameters.isEmpty()) {
                matrix.add(new ArrayList(parameters));
                parameters.clear();
            }
            parameters.add(row);
        }
        if (!parameters.isEmpty()) {
            matrix.add(new ArrayList(parameters));
            parameters.clear();
        }
        matrix.forEach(consumer);
    }

    public static void itRow(Row row, ExBound bound, BiConsumer<Cell, Integer> consumer, Predicate<Cell> predicate) {
        int start = bound.getStart();
        int end = bound.getEnd();
        for (int idx = start; idx < end; ++idx) {
            Cell cell = row.getCell(idx);
            if (null == cell) continue;
            if (null == predicate) {
                consumer.accept(cell, idx);
                continue;
            }
            boolean tested = predicate.test(cell);
            if (!tested) continue;
            consumer.accept(cell, idx);
        }
    }

    public static void itRow(Row row, ExBound bound, BiConsumer<Cell, Integer> consumer) {
        ExFn.itRow(row, bound, consumer, null);
    }

    public static void itRowZip(Row row, Row row1, ExBound bound, BiConsumer<Cell, Cell> consumer) {
        int start = bound.getStart();
        int end = bound.getEnd();
        for (int idx = start; idx < end; ++idx) {
            Cell cell = row.getCell(idx);
            Cell cell1 = row1.getCell(idx);
            if (null == cell) continue;
            consumer.accept(cell, cell1);
        }
    }

    public static void onRow(Sheet sheet, int rowIndex, Consumer<Row> consumer, Predicate<Row> predicate) {
        Row row = sheet.getRow(rowIndex);
        if (null != row) {
            if (null == predicate) {
                consumer.accept(row);
            } else if (predicate.test(row)) {
                consumer.accept(row);
            }
        }
    }

    public static void onRow(Sheet sheet, int rowIndex, Consumer<Row> consumer) {
        ExFn.onRow(sheet, rowIndex, consumer, null);
    }

    public static void onRow(Sheet sheet, int rowIndex, int rowIndex1, BiConsumer<Row, Row> consumer) {
        ExFn.onRow(sheet, rowIndex, row -> ExFn.onRow(sheet, rowIndex1, row1 -> consumer.accept((Row)row, (Row)row1)), null);
    }

    public static void onCell(Row row, int columnIndex, Consumer<Cell> consumer, Predicate<Cell> predicate) {
        Cell cell = row.getCell(columnIndex);
        if (null != cell) {
            if (null == predicate) {
                consumer.accept(cell);
            } else if (predicate.test(cell)) {
                consumer.accept(cell);
            }
        }
    }

    public static void onCell(Row row, int columnIndex, Consumer<Cell> consumer) {
        ExFn.onCell(row, columnIndex, consumer, null);
    }

    public static void generateAdjust(Sheet sheet, List<Integer> sizeList) {
        ExData.generateAdjust(sheet, sizeList);
    }

    public static boolean generateHeader(Sheet sheet, String identifier, JsonArray tableData, MetaAtom metaAtom) {
        return ExData.generateHeader(sheet, identifier, tableData, metaAtom);
    }

    public static void generateHeader(Sheet sheet, Integer index, JsonArray rowData) {
        ExData.generateData(sheet, index, rowData, new ArrayList());
    }

    public static void generateData(Sheet sheet, Integer index, JsonArray rowData, List<Class<?>> typeArray) {
        ExData.generateData(sheet, index, rowData, typeArray);
    }
}

