/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.excel.tool;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.up.util.Ut;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;

public class ExOut {
    private static final ConcurrentMap<Class<?>, CellType> TYPE_MAP = new ConcurrentHashMap<Class<?>, CellType>(){
        private static final long serialVersionUID = 3360878434696227455L;
        {
            this.put(String.class, CellType.STRING);
            this.put(Character.TYPE, CellType.STRING);
            this.put(Instant.class, CellType.NUMERIC);
            this.put(LocalDate.class, CellType.NUMERIC);
            this.put(LocalDateTime.class, CellType.NUMERIC);
            this.put(BigDecimal.class, CellType.NUMERIC);
            this.put(Integer.class, CellType.NUMERIC);
            this.put(Integer.TYPE, CellType.NUMERIC);
            this.put(Long.class, CellType.NUMERIC);
            this.put(Long.TYPE, CellType.NUMERIC);
            this.put(Short.class, CellType.NUMERIC);
            this.put(Short.TYPE, CellType.NUMERIC);
            this.put(Boolean.TYPE, CellType.BOOLEAN);
            this.put(Boolean.class, CellType.BOOLEAN);
            this.put(JsonArray.class, CellType.STRING);
            this.put(JsonObject.class, CellType.STRING);
        }
    };
    private static final ConcurrentMap<Class<?>, BiConsumer<Cell, Object>> VALUE_MAP = new ConcurrentHashMap<Class<?>, BiConsumer<Cell, Object>>(){
        private static final long serialVersionUID = 5714357194532329854L;
        {
            this.put(String.class, ExOut::outString);
            this.put(Character.TYPE, ExOut::outString);
            this.put(Instant.class, ExOut::outDate);
            this.put(LocalDate.class, ExOut::outLocalDate);
            this.put(LocalDateTime.class, ExOut::outLocalDateTime);
            this.put(BigDecimal.class, ExOut::outBigDecimal);
            this.put(Integer.class, ExOut::outNumeric);
            this.put(Integer.TYPE, ExOut::outNumeric);
            this.put(Long.class, ExOut::outNumeric);
            this.put(Long.TYPE, ExOut::outNumeric);
            this.put(Short.class, ExOut::outNumeric);
            this.put(Short.TYPE, ExOut::outNumeric);
            this.put(Boolean.TYPE, ExOut::outBoolean);
            this.put(Boolean.class, ExOut::outBoolean);
            this.put(JsonArray.class, ExOut::outString);
            this.put(JsonObject.class, ExOut::outString);
        }
    };

    private static void outString(Cell cell, Object value) {
        cell.setCellValue(value.toString());
    }

    private static void outDate(Cell cell, Object value) {
        Date date = Ut.parseFull((String)value.toString());
        cell.setCellValue(date);
    }

    private static void outLocalDate(Cell cell, Object value) {
        LocalDate date = Ut.toDate((String)value.toString());
        cell.setCellValue(date);
    }

    private static void outLocalDateTime(Cell cell, Object value) {
        LocalDateTime dateTime = ExOut.outLocalDateTime(value.toString());
        cell.setCellValue(dateTime);
    }

    private static LocalDateTime outLocalDateTime(String value) {
        LocalDateTime dateTime = Ut.toDateTime((String)value);
        if (Objects.isNull(dateTime)) {
            return LocalDateTime.MIN;
        }
        return LocalDateTime.ofInstant(dateTime.toInstant(ZoneOffset.UTC), ZoneId.systemDefault());
    }

    private static void outBigDecimal(Cell cell, Object value) {
        String liberal = value.toString();
        if (Ut.isInteger((String)liberal) || Ut.isDecimal((String)liberal)) {
            BigDecimal decimal = new BigDecimal(value.toString());
            cell.setCellValue(decimal.doubleValue());
        } else {
            cell.setCellValue(liberal);
        }
    }

    private static void outNumeric(Cell cell, Object value) {
        String liberal = value.toString();
        if (Ut.isInteger((String)liberal) || Ut.isDecimal((String)liberal)) {
            double parsed = Double.parseDouble(liberal);
            cell.setCellValue(parsed);
        } else {
            cell.setCellValue(liberal);
        }
    }

    private static void outBoolean(Cell cell, Object value) {
        String literal = value.toString();
        if ("true".equalsIgnoreCase(literal) || "false".equalsIgnoreCase(literal)) {
            if ("true".equalsIgnoreCase(literal)) {
                cell.setCellValue(Boolean.TRUE.booleanValue());
            } else {
                cell.setCellValue(Boolean.FALSE.booleanValue());
            }
        } else {
            cell.setCellValue(literal);
        }
    }

    public static CellType type(Class<?> input) {
        return TYPE_MAP.getOrDefault(input, CellType.STRING);
    }

    static void value(Cell cell, Class<?> type, Object value) {
        if (Objects.isNull(value)) {
            cell.setCellValue("");
            return;
        }
        BiConsumer consumer = VALUE_MAP.getOrDefault(type, null);
        if (Objects.isNull(consumer)) {
            cell.setCellValue(value.toString());
        } else {
            consumer.accept(cell, value);
        }
    }
}

