/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.excel.tpl;

import io.modello.atom.typed.MetaAtom;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.tp.plugin.excel.ExTpl;
import io.vertx.tp.plugin.excel.tpl.BlueDye;
import java.util.Objects;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class BlueTpl
implements ExTpl {
    private transient BlueDye dye;

    @Override
    @Fluent
    public ExTpl bind(Workbook workbook) {
        this.dye = BlueDye.get(workbook);
        return this;
    }

    @Override
    public void applyStyle(Sheet sheet, MetaAtom metaAtom) {
        if (Objects.nonNull(sheet)) {
            Row first = sheet.getRow(0);
            this.applyFirst(first);
            if (metaAtom.isComplex()) {
                cnHeader = sheet.getRow(1);
                enHeader = sheet.getRow(3);
                this.applyHeader(cnHeader, enHeader);
                Row cnHeader1 = sheet.getRow(2);
                Row enHeader1 = sheet.getRow(4);
                this.applyHeader(cnHeader1, enHeader1);
                dataStart = 5;
            } else {
                cnHeader = sheet.getRow(1);
                enHeader = sheet.getRow(2);
                this.applyHeader(cnHeader, enHeader);
                dataStart = 3;
            }
            int num = sheet.getPhysicalNumberOfRows();
            for (int idx = dataStart; idx < num; ++idx) {
                Row data = sheet.getRow(idx);
                this.applyData(data, metaAtom);
            }
        }
    }

    private void applyFirst(Row row) {
        Cell table = row.getCell(0);
        this.dye.onTable(table);
        Cell identifier = row.getCell(1);
        this.dye.onModel(identifier);
        Cell empty = row.getCell(2);
        this.dye.onEmpty(empty);
    }

    private void applyHeader(Row cnHeader, Row enHeader) {
        int cells = cnHeader.getPhysicalNumberOfCells();
        for (int idx = 0; idx < cells; ++idx) {
            Cell cell = cnHeader.getCell(idx);
            this.dye.onCnHeader(cell);
        }
        int enCells = enHeader.getPhysicalNumberOfCells();
        for (int idx = 0; idx < enCells; ++idx) {
            Cell cell = enHeader.getCell(idx);
            this.dye.onEnHeader(cell);
        }
    }

    private void applyData(Row dataRow, MetaAtom metaAtom) {
        int enCells = dataRow.getPhysicalNumberOfCells();
        for (int idx = 0; idx < enCells; ++idx) {
            Cell cell = dataRow.getCell(idx);
            Class type = metaAtom.type(Integer.valueOf(idx));
            this.dye.onData(cell, type);
        }
    }
}

