/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.history;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.MultiMap;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.plugin.jooq.JooqInfix;
import io.vertx.up.log.Annal;
import io.vertx.up.util.Ut;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jooq.Batch;
import org.jooq.Constraint;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.InsertSetMoreStep;
import org.jooq.Name;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;

class TrashBuilder {
    private static final Annal LOGGER = Annal.get(TrashBuilder.class);
    private static ConcurrentMap<String, Field> FIELD_MAP = new ConcurrentHashMap<String, Field>(){
        {
            this.put("key", DSL.field((Name)DSL.name((String)"KEY"), String.class));
            this.put("identifier", DSL.field((Name)DSL.name((String)"IDENTIFIER"), String.class));
            this.put("record", DSL.field((Name)DSL.name((String)"RECORD"), String.class));
            this.put("sigma", DSL.field((Name)DSL.name((String)"SIGMA"), String.class));
            this.put("language", DSL.field((Name)DSL.name((String)"LANGUAGE"), String.class));
            this.put("active", DSL.field((Name)DSL.name((String)"ACTIVE"), Boolean.class));
            this.put("createdBy", DSL.field((Name)DSL.name((String)"CREATED_BY"), String.class));
            this.put("createdAt", DSL.field((Name)DSL.name((String)"CREATED_AT"), Timestamp.class));
        }
    };
    private final transient DSLContext context;
    private final transient String identifier;
    private final transient String tableName;

    TrashBuilder(String identifier) {
        this.identifier = identifier;
        String tableName = this.identifier.toUpperCase().replace('.', '_').replace('-', '_');
        this.tableName = "HIS_" + tableName;
        this.context = JooqInfix.getDSL((String)"orbit");
    }

    @Fluent
    public TrashBuilder init() {
        this.context.createTableIfNotExists(DSL.name((String)this.tableName)).column("KEY", SQLDataType.VARCHAR((int)36).nullable(false)).column("IDENTIFIER", SQLDataType.VARCHAR((int)255)).column("RECORD", SQLDataType.CLOB).column("SIGMA", SQLDataType.VARCHAR((int)255)).column("LANGUAGE", SQLDataType.VARCHAR((int)20)).column("ACTIVE", SQLDataType.BOOLEAN).column("CREATED_AT", SQLDataType.LOCALDATETIME).column("CREATED_BY", SQLDataType.VARCHAR((int)36)).constraint((Constraint)DSL.constraint((String)("PK_" + this.tableName)).primaryKey(new Name[]{DSL.name((String)"KEY")})).execute();
        LOGGER.info("[ ZERO-HIS ] The table `{0}` has been created successfully!", new Object[]{this.tableName});
        return this;
    }

    public boolean createHistory(JsonObject content, MultiMap params) {
        InsertSetMoreStep steps = this.stepInsert(content);
        steps.execute();
        return true;
    }

    private InsertSetMoreStep stepInsert(JsonObject content) {
        InsertSetMoreStep steps = (InsertSetMoreStep)this.context.insertInto(DSL.table((String)this.tableName));
        steps.set((Field)FIELD_MAP.get("key"), (Object)UUID.randomUUID().toString());
        steps.set((Field)FIELD_MAP.get("identifier"), (Object)this.identifier);
        steps.set((Field)FIELD_MAP.get("record"), (Object)content.encode());
        steps.set((Field)FIELD_MAP.get("sigma"), (Object)content.getString("sigma"));
        steps.set((Field)FIELD_MAP.get("language"), (Object)content.getString("language"));
        steps.set((Field)FIELD_MAP.get("active"), (Object)Boolean.TRUE);
        steps.set((Field)FIELD_MAP.get("createdBy"), (Object)content.getString("createdBy"));
        Date date = new Date();
        Timestamp timestamp = new Timestamp(date.getTime());
        steps.set((Field)FIELD_MAP.get("createdAt"), (Object)timestamp);
        return steps;
    }

    public boolean createHistory(JsonArray content, MultiMap params) {
        ArrayList batchOps = new ArrayList();
        Ut.itJArray((JsonArray)content).map(this::stepInsert).forEach(batchOps::add);
        Batch batch = this.context.batch(batchOps);
        batch.execute();
        return true;
    }
}

