/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.history;

import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.plugin.history.TrashBuilder;
import io.vertx.tp.plugin.history.TrashClient;
import io.vertx.up.util.Ut;

public class TrashClientImpl
implements TrashClient {
    private final transient Vertx vertxRef;
    private final transient TrashBuilder builder;

    public TrashClientImpl(Vertx vertxRef, String identifier) {
        this.vertxRef = vertxRef;
        this.builder = new TrashBuilder(identifier).init();
    }

    @Override
    public Future<JsonObject> backupAsync(JsonObject record, MultiMap params) {
        JsonObject content = Ut.valueJObject((JsonObject)record);
        if (Ut.isNotNil((JsonObject)content)) {
            this.builder.createHistory(record, params);
        }
        return Future.succeededFuture((Object)record);
    }

    @Override
    public Future<JsonArray> backupAsync(JsonArray records, MultiMap params) {
        JsonArray content = Ut.valueJArray((JsonArray)records);
        if (!content.isEmpty()) {
            this.builder.createHistory(content, params);
        }
        return Future.succeededFuture((Object)records);
    }

    @Override
    public Future<JsonObject> backupAsync(JsonObject record) {
        return this.backupAsync(record, null);
    }

    @Override
    public Future<JsonArray> backupAsync(JsonArray records) {
        return this.backupAsync(records, null);
    }

    @Override
    public Future<JsonObject> restoreAsync(JsonObject record, MultiMap params) {
        return null;
    }
}

