/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin;

import io.reactivex.Observable;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.FindOptions;
import io.vertx.ext.mongo.MongoClient;
import io.vertx.ext.mongo.MongoClientDeleteResult;
import io.vertx.tp.plugin.mongo.MongoInfix;
import io.vertx.up.fn.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.unity.Ux;
import java.util.Objects;
import java.util.function.BinaryOperator;

public class UxMongo {
    private static final MongoClient CLIENT = MongoInfix.getClient();
    private static final Annal LOGGER = Annal.get(UxMongo.class);

    public Future<Boolean> missing(String collection, JsonObject filter) {
        return Fn.thenGeneric(future -> CLIENT.findOne(collection, filter, null, res -> {
            LOGGER.debug("( Mongo -> findOne ) collection = {0}, filter = {1}, result = {2}.", new Object[]{collection, filter, res.result()});
            future.complete((Object)(null == res.result() ? 1 : 0));
        }));
    }

    public Future<Boolean> existing(String collection, JsonObject filter) {
        return Fn.thenGeneric(future -> CLIENT.findOne(collection, filter, null, res -> {
            LOGGER.debug("( Mongo -> findOne ) collection = {0}, filter = {1}, result = {2}.", new Object[]{collection, filter, res.result()});
            future.complete((Object)(null != res.result() ? 1 : 0));
        }));
    }

    public JsonObject termIn(JsonObject filter, String field, JsonArray values) {
        JsonObject terms = new JsonObject();
        if (null != filter) {
            terms.mergeIn(filter);
        }
        return terms.put(field, (Object)new JsonObject().put("$in", (Object)values));
    }

    public JsonObject termLike(JsonObject filter, String field, String value) {
        JsonObject terms = new JsonObject();
        if (null != filter) {
            terms.mergeIn(filter);
        }
        return terms.put(field, (Object)new JsonObject().put("$regex", (Object)(".*" + value + ".*")));
    }

    public Future<JsonObject> insert(String collection, JsonObject data) {
        return Fn.thenGeneric(future -> CLIENT.insert(collection, data, res -> {
            if (res.succeeded()) {
                LOGGER.debug("( Mongo -> insert ) collection = {0}, data = {1}.", new Object[]{collection, data});
                future.complete((Object)data);
            } else {
                LOGGER.debug("( Mongo -> insert ) collection = {0}, data = {1}.", new Object[]{collection, null});
                future.complete();
            }
        }));
    }

    public Future<JsonObject> findOne(String collection, JsonObject filter) {
        return Fn.thenGeneric(future -> CLIENT.findOne(collection, filter, null, res -> {
            LOGGER.debug("( Mongo -> findOne ) collection = {0}, filter = {1}, result = {2}.", new Object[]{collection, filter, res.result()});
            future.complete((Object)((JsonObject)res.result()));
        }));
    }

    public Future<JsonObject> findOne(String collection, JsonObject filter, String joinedCollection, String joinedKey, JsonObject additional, BinaryOperator<JsonObject> operatorFun) {
        JsonObject data = new JsonObject();
        return this.findOne(collection, filter).compose(result -> {
            data.mergeIn(result);
            JsonObject joinedFilter = null == additional ? new JsonObject() : additional.copy();
            joinedFilter.put(joinedKey, result.getValue("_id"));
            return this.findOne(joinedCollection, joinedFilter);
        }).compose(second -> Future.succeededFuture((Object)((JsonObject)operatorFun.apply(data, second))));
    }

    public Future<JsonObject> findOneAndReplace(String collection, JsonObject filter, JsonObject updated) {
        return Fn.thenGeneric(future -> CLIENT.findOne(collection, filter, null, handler -> {
            if (handler.succeeded()) {
                JsonObject data = ((JsonObject)handler.result()).mergeIn(updated);
                CLIENT.findOneAndReplace(collection, filter, data, result -> {
                    LOGGER.debug("( Mongo -> findOneAndReplace ) collection = {0}, filter = {1}, result = {2}.", new Object[]{collection, filter, data});
                    future.complete((Object)data);
                });
            } else {
                future.complete((Object)updated);
            }
        }));
    }

    public Future<Long> removeDocument(String collection, JsonObject filter) {
        return Fn.thenGeneric(future -> CLIENT.removeDocument(collection, filter, res -> {
            Long removed = ((MongoClientDeleteResult)res.result()).getRemovedCount();
            LOGGER.debug("( Mongo -> removeDocument ) Effected: {2} Rows. collection = {0}, filter = {1}.", new Object[]{collection, filter, removed});
            future.complete((Object)removed);
        }));
    }

    public Future<JsonArray> findWithOptions(String collection, JsonObject filter, FindOptions options) {
        return Fn.thenGeneric(future -> CLIENT.findWithOptions(collection, filter, options, res -> {
            JsonArray result = new JsonArray();
            Observable.fromIterable((Iterable)((Iterable)res.result())).filter(Objects::nonNull).subscribe(arg_0 -> ((JsonArray)result).add(arg_0)).dispose();
            LOGGER.debug("( Mongo -> findWithOptions ) collection = {0}, filter = {1}, options = {2}, result = {3}.", new Object[]{collection, filter, options.toJson(), result});
            future.complete((Object)result);
        }));
    }

    public Future<JsonArray> findWithOptions(String collection, JsonObject filter, FindOptions options, String joinedCollection, String joinedKey, JsonObject additional, BinaryOperator<JsonObject> operatorFun) {
        return Ux.thenCombine(this.findWithOptions(collection, filter, options), item -> {
            JsonObject joinedFilter = null == additional ? new JsonObject() : additional.copy();
            joinedFilter.put(joinedKey, item.getValue("_id"));
            return this.findOne(joinedCollection, joinedFilter);
        }, operatorFun);
    }
}

