/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.mongo;

import io.vertx.ext.mongo.FindOptions;
import io.vertx.up.atom.query.Pager;
import io.vertx.up.atom.query.Sorter;
import io.vertx.up.fn.Fn;

public class MongoReadOpts {
    public static FindOptions toDescLimit(String sortField, int limit) {
        return MongoReadOpts.toFull(Pager.create((Integer)1, (Integer)limit), Sorter.create((String)sortField, (Boolean)false));
    }

    public static FindOptions toAscLimit(String sortField, int limit) {
        return MongoReadOpts.toFull(Pager.create((Integer)1, (Integer)limit), Sorter.create((String)sortField, (Boolean)true));
    }

    public static FindOptions toDesc(String sortField) {
        return MongoReadOpts.toFull(null, Sorter.create((String)sortField, (Boolean)false));
    }

    public static FindOptions toAsc(String sortField) {
        return MongoReadOpts.toFull(null, Sorter.create((String)sortField, (Boolean)true));
    }

    public static FindOptions toFull(Pager pager, Sorter sorter) {
        FindOptions options = new FindOptions();
        Fn.runAt(() -> {
            options.setLimit(pager.getSize());
            options.setSkip(pager.getStart());
        }, (Object[])new Object[]{pager});
        Fn.runAt(() -> options.setSort(sorter.toJson(mode -> mode != false ? 1 : -1)), (Object[])new Object[]{sorter});
        return options;
    }
}

