/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.shell;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.tp.plugin.shell.AbstractCommander;
import io.vertx.tp.plugin.shell.ConsoleTool;
import io.vertx.tp.plugin.shell.atom.CommandAtom;
import io.vertx.tp.plugin.shell.atom.CommandInput;
import io.vertx.tp.plugin.shell.atom.Terminal;
import io.vertx.tp.plugin.shell.cv.em.TermStatus;
import io.vertx.tp.plugin.shell.refine.Sl;
import java.util.List;
import java.util.function.BiConsumer;

public class ConsoleCommander
extends AbstractCommander {
    @Override
    public Future<TermStatus> executeAsync(CommandInput args) {
        Sl.welcomeSub(this.environment, this.atom);
        Terminal terminal = Terminal.create(this.vertxRef);
        return this.run(terminal);
    }

    private Future<TermStatus> run(Terminal terminal) {
        Promise promise = Promise.promise();
        BiConsumer<Terminal, TermStatus> consumer = (terminalRef, status) -> {
            Sl.welcomeSub(this.environment, this.atom);
            this.run((Terminal)terminalRef);
            promise.complete((Object)status);
        };
        terminal.run((Handler<AsyncResult<String[]>>)((Handler)handler -> {
            if (handler.succeeded()) {
                String[] args = (String[])handler.result();
                Future<TermStatus> future = this.runAsync(args);
                future.onComplete(callback -> {
                    if (callback.succeeded()) {
                        TermStatus status = (TermStatus)((Object)((Object)((Object)callback.result())));
                        if (TermStatus.EXIT == status) {
                            promise.complete((Object)TermStatus.SUCCESS);
                        } else if (TermStatus.WAIT != status) {
                            consumer.accept(terminal, status);
                        }
                    } else {
                        consumer.accept(terminal, TermStatus.FAILURE);
                    }
                });
            } else {
                Sl.failEmpty();
                consumer.accept(terminal, TermStatus.FAILURE);
            }
        }));
        return promise.future();
    }

    private Future<TermStatus> runAsync(String[] args) {
        List<CommandAtom> commands = Sl.commands(this.atom.getCommands());
        return ConsoleTool.parseAsync(args, commands).compose(commandLine -> ConsoleTool.runAsync(commandLine, commands, commander -> commander.bind(this.environment).bind(this.vertxRef))).otherwise(Sl::failError);
    }
}

