/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.shell.refine;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.up.plugin.Infix;
import io.vertx.up.util.Ut;

class SlConfig {
    private static final JsonObject CONFIGURATION = new JsonObject();
    private static final String FIELD_COMMANDS = "commands";
    private static final String FIELD_DEFAULT = "default";
    private static final String FIELD_DEFINED = "defined";

    SlConfig() {
    }

    static void init() {
        JsonObject data = (JsonObject)Infix.init((String)"shell", config -> {
            String definedFile;
            JsonObject commands = Ut.sureJObject((JsonObject)config.getJsonObject(FIELD_COMMANDS));
            JsonObject commandsJson = new JsonObject();
            String defaultFile = commands.getString(FIELD_DEFAULT);
            if (Ut.notNil((String)defaultFile)) {
                commandsJson.put(FIELD_DEFAULT, Ut.ioJArray((String)defaultFile));
            }
            if (Ut.notNil((String)(definedFile = commands.getString(FIELD_DEFINED)))) {
                commandsJson.put(FIELD_DEFINED, Ut.ioJArray((String)definedFile));
            }
            config.put(FIELD_COMMANDS, commandsJson);
            return config;
        }, JsonObject.class);
        CONFIGURATION.mergeIn(data, true);
    }

    static JsonObject welcome() {
        return Ut.sureJObject((JsonObject)CONFIGURATION.getJsonObject("welcome"));
    }

    static boolean isDebug() {
        Boolean debug = Boolean.FALSE;
        if (CONFIGURATION.containsKey("debug")) {
            debug = CONFIGURATION.getBoolean("debug");
        }
        return debug;
    }

    static JsonObject validate() {
        return Ut.sureJObject((JsonObject)CONFIGURATION.getJsonObject("validate"));
    }

    static JsonArray commands() {
        JsonObject commands = CONFIGURATION.getJsonObject(FIELD_COMMANDS);
        return Ut.sureJArray((JsonArray)commands.getJsonArray(FIELD_DEFINED));
    }

    static JsonArray commandsDefault() {
        JsonObject commands = CONFIGURATION.getJsonObject(FIELD_COMMANDS);
        return Ut.sureJArray((JsonArray)commands.getJsonArray(FIELD_DEFAULT));
    }
}

