/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.shell.refine;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.plugin.shell.refine.SlConfig;
import io.vertx.tp.plugin.shell.refine.SlLog;
import io.vertx.up.log.Annal;
import io.vertx.up.util.Ut;
import java.util.Objects;
import java.util.Set;

class SlVerifier {
    private static final Annal LOGGER = Annal.get(SlVerifier.class);

    SlVerifier() {
    }

    static boolean validate(String[] args) {
        JsonObject input = Ut.sureJObject((JsonObject)SlConfig.validate().getJsonObject("input"));
        boolean validated = false;
        if (0 == args.length || Objects.isNull(args[0])) {
            if (input.containsKey("required")) {
                SlLog.output(input.getString("required"), new Object[0]);
            } else {
                LOGGER.warn("Input no arguments, are you sure ?", new Object[0]);
                validated = true;
            }
        } else {
            String argument = args[0];
            Set supported = Ut.toSet((JsonArray)Ut.sureJArray((JsonArray)SlConfig.validate().getJsonArray("args")));
            if (supported.contains(argument)) {
                validated = true;
            } else if (input.containsKey("existing")) {
                SlLog.output(input.getString("existing"), Ut.fromJoin((Set)supported), argument);
            } else {
                LOGGER.warn("There are {0} supported commands {1}, but you provide none ?", new Object[]{supported.size(), Ut.fromJoin((Set)supported)});
                validated = true;
            }
        }
        return validated;
    }
}

