/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.shell.refine;

import io.vertx.core.json.JsonObject;
import io.vertx.tp.plugin.shell.atom.CommandAtom;
import io.vertx.tp.plugin.shell.refine.SlConfig;
import io.vertx.tp.plugin.shell.refine.SlLog;
import io.vertx.tp.plugin.shell.refine.SlMessage;
import io.vertx.up.eon.em.Environment;
import io.vertx.up.log.Log;

class SlWelcome {
    static final JsonObject WELCOME = SlConfig.welcome();

    SlWelcome() {
    }

    static void welcome() {
        String banner = WELCOME.getString("banner");
        String version = WELCOME.getString("version");
        System.out.println("------------------------------------------------------");
        System.out.println("|                                                    |");
        System.out.println("|         " + Log.color((String)banner, (int)36, (boolean)true) + "         |");
        System.out.println("|                                                    |");
        System.out.println("------------------------------------------------------");
        System.out.println("                                   ---- Version." + version + "   ");
    }

    static void welcomeCommand(Environment environment) {
        JsonObject message = WELCOME.getJsonObject("message");
        SlLog.output("------------->>>> " + Log.color((String)"Command Begin", (int)34), new Object[0]);
        SlLog.output(Log.color((String)message.getString("environment"), (int)30, (boolean)true) + " " + message.getString("wait"), environment);
        System.out.print(">> ");
    }

    static void welcomeSub(Environment environment, CommandAtom option) {
        JsonObject message = WELCOME.getJsonObject("message");
        SlLog.outputOpt("------>>>> " + Log.color((String)"Sub System", (int)32) + ": {0}", option.getName(), option.getDescription());
        SlLog.output(Log.color((String)message.getString("environment"), (int)30, (boolean)true) + " " + message.getString("wait"), environment);
        System.out.print(">> ");
    }

    static void welcomeCommand(CommandAtom option) {
        SlLog.output(SlMessage.message("previous", () -> "Previous: name = {0}, description = {1}"), option.getSimple(), option.getDescription());
    }

    static void goodbye() {
        SlLog.output(SlMessage.message("quit", () -> "You have quit Zero Console successfully!"), new Object[0]);
    }

    static void goodbye(CommandAtom option) {
        String pattern = SlMessage.message("back", () -> "You have quit current Sub System: {0} successfully!");
        SlLog.outputOpt(pattern, option.getName(), option.getDescription());
    }
}

