/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.shell;

import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.tp.plugin.shell.Commander;
import io.vertx.tp.plugin.shell.atom.CommandAtom;
import io.vertx.tp.plugin.shell.atom.CommandInput;
import io.vertx.tp.plugin.shell.cv.em.TermStatus;
import io.vertx.tp.plugin.shell.refine.Sl;
import io.vertx.up.eon.em.Environment;
import io.vertx.up.log.Annal;
import io.vertx.up.runtime.ZeroSerializer;
import io.vertx.up.util.Ut;
import java.io.File;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;

public abstract class AbstractCommander
implements Commander {
    protected transient CommandAtom atom;
    protected transient Vertx vertxRef;
    protected transient Environment environment = Environment.Production;

    @Override
    public Commander bind(Environment environment) {
        if (Objects.nonNull(environment)) {
            this.environment = environment;
        }
        return this;
    }

    @Override
    public Commander bind(CommandAtom atom) {
        this.atom = atom;
        return this;
    }

    @Override
    public Commander bind(Vertx vertx) {
        this.vertxRef = vertx;
        return this;
    }

    @Override
    public Future<TermStatus> executeAsync(CommandInput args) {
        return Future.succeededFuture((Object)((Object)this.execute(args)));
    }

    @Override
    public TermStatus execute(CommandInput args) {
        return TermStatus.SUCCESS;
    }

    protected Annal logger() {
        return Annal.get(this.getClass());
    }

    protected String inString(CommandInput input, String name) {
        return this.inValue(input, name, String.class);
    }

    protected Integer inInteger(CommandInput input, String name) {
        return this.inValue(input, name, Integer.class);
    }

    protected Boolean inBoolean(CommandInput input, String name) {
        return this.inValue(input, name, Boolean.class);
    }

    protected String inFolder(CommandInput input, String name, Function<String, String> processor) {
        String folder = this.inValue(input, name, String.class);
        if (Objects.nonNull(processor)) {
            folder = processor.apply(folder);
        }
        return this.inFolder(folder);
    }

    protected String inFolder(CommandInput input, String name) {
        return this.inFolder(input, name, null);
    }

    protected String inFolder(String folderName) {
        File file = new File(folderName);
        if (!file.exists()) {
            boolean created = file.mkdirs();
            Sl.output("Folder does not exist, created: {0}", created);
        }
        return file.getAbsolutePath();
    }

    protected <T> T inJson(CommandInput input, String name) {
        String filename = this.inValue(input, name, String.class);
        String content = Ut.ioString((String)filename);
        if (Ut.isJArray((String)content)) {
            return (T)Ut.toJArray((String)content);
        }
        if (Ut.isJObject((String)content)) {
            return (T)Ut.toJObject((String)content);
        }
        return (T)content;
    }

    protected <T> T inValue(CommandInput input, String name, Class<T> clazzT) {
        ConcurrentMap<String, String> inputMap = input.get();
        String literal = (String)inputMap.get(name);
        if (Ut.isNil((String)literal)) {
            return this.atom.getDefault(name);
        }
        return (T)ZeroSerializer.getValue(clazzT, (String)literal);
    }
}

