/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.shell;

import io.vertx.core.Vertx;
import io.vertx.tp.error.InternalConflictException;
import io.vertx.tp.plugin.shell.ConsoleInteract;
import io.vertx.tp.plugin.shell.refine.Sl;
import io.vertx.up.eon.em.Environment;
import io.vertx.up.log.Annal;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;

public class ConsoleFramework {
    private static final Annal LOGGER = Annal.get(ConsoleFramework.class);
    private static final ConcurrentMap<String, Consumer<String>> INTERNAL = new ConcurrentHashMap<String, Consumer<String>>();
    private final transient Vertx vertxRef;

    private ConsoleFramework(Vertx vertxRef) {
        this.vertxRef = vertxRef;
        if (INTERNAL.isEmpty()) {
            INTERNAL.put("config", arg -> {
                ConsoleInteract interact;
                if ("dev".equals(arg)) {
                    interact = ConsoleInteract.start(this.vertxRef, Environment.Development);
                } else {
                    LOGGER.info("The console will go through production mode", new Object[0]);
                    interact = ConsoleInteract.start(this.vertxRef, Environment.Production);
                }
                interact.run((String)arg);
            });
        }
    }

    public static ConsoleFramework start(Vertx vertxRef) {
        return new ConsoleFramework(vertxRef);
    }

    public ConsoleFramework bind(Consumer<String> consumer) {
        if (INTERNAL.containsKey("start")) {
            LOGGER.warn("There exist 'start' consumer, you'll overwrite previous.", new Object[0]);
        }
        return this.bind("start", consumer);
    }

    public void run(String[] args) {
        if (Sl.ready(args)) {
            String input = args[0];
            Consumer consumer = (Consumer)INTERNAL.get(input);
            if (Objects.nonNull(consumer)) {
                String consumerArgs = 2 == args.length ? args[1] : null;
                consumer.accept(consumerArgs);
            } else {
                LOGGER.warn("No consumer found for argument `{0}`", new Object[]{input});
                System.exit(-1);
            }
        } else {
            System.exit(-1);
        }
    }

    public ConsoleFramework bind(String name, Consumer<String> consumer) {
        if ("config".equals(name)) {
            throw new InternalConflictException(ConsoleFramework.class);
        }
        INTERNAL.put(name, consumer);
        return this;
    }

    static {
        Sl.init();
    }
}

