/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.shell;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.tp.plugin.shell.ConsoleTool;
import io.vertx.tp.plugin.shell.atom.CommandAtom;
import io.vertx.tp.plugin.shell.atom.Terminal;
import io.vertx.tp.plugin.shell.cv.em.TermStatus;
import io.vertx.tp.plugin.shell.refine.Sl;
import io.vertx.up.eon.em.Environment;
import java.util.List;
import java.util.function.Consumer;

class ConsoleInteract {
    private final transient Environment environment;
    private final transient Vertx vertx;

    private ConsoleInteract(Vertx vertx, Environment environment) {
        this.environment = environment;
        this.vertx = vertx;
    }

    public static ConsoleInteract start(Vertx vertx, Environment environment) {
        return new ConsoleInteract(vertx, environment);
    }

    void run(String ... args) {
        Sl.welcome();
        Sl.welcomeCommand(this.environment);
        Terminal terminal = Terminal.create(this.vertx);
        this.run(terminal);
    }

    void run(Terminal terminal) {
        Consumer<Terminal> consumer = terminalRef -> {
            Sl.welcomeCommand(this.environment);
            this.run((Terminal)terminalRef);
        };
        terminal.run((Handler<AsyncResult<String[]>>)((Handler)handler -> {
            if (handler.succeeded()) {
                String[] args = (String[])handler.result();
                Future<TermStatus> future = this.runAsync(args);
                future.onComplete(callback -> {
                    if (callback.succeeded()) {
                        TermStatus status = (TermStatus)((Object)((Object)((Object)callback.result())));
                        if (TermStatus.EXIT == status) {
                            System.exit(0);
                        } else if (TermStatus.WAIT != status) {
                            consumer.accept(terminal);
                        }
                    } else {
                        consumer.accept(terminal);
                    }
                });
            } else {
                Sl.failEmpty();
                consumer.accept(terminal);
            }
        }));
    }

    private Future<TermStatus> runAsync(String[] args) {
        List<CommandAtom> commands = Sl.commands();
        return ConsoleTool.parseAsync(args, commands).compose(commandLine -> ConsoleTool.runAsync(commandLine, commands, commander -> commander.bind(this.environment).bind(this.vertx))).otherwise(Sl::failError);
    }
}

