/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.shell.commander;

import io.vertx.core.json.JsonObject;
import io.vertx.tp.plugin.shell.AbstractCommander;
import io.vertx.tp.plugin.shell.atom.CommandAtom;
import io.vertx.tp.plugin.shell.atom.CommandInput;
import io.vertx.tp.plugin.shell.cv.em.CommandType;
import io.vertx.tp.plugin.shell.cv.em.TermStatus;
import io.vertx.tp.plugin.shell.refine.Sl;
import io.vertx.up.log.Log;
import io.vertx.up.util.Ut;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.cli.HelpFormatter;

public class HelpCommander
extends AbstractCommander {
    private static final String ARG_COMMAND = "c";

    @Override
    public TermStatus execute(CommandInput args) {
        List<CommandAtom> atomList = this.getAtomList(args.atom());
        ConcurrentMap<String, String> inputMap = args.get();
        if (inputMap.containsKey(ARG_COMMAND)) {
            String commandValue = (String)inputMap.get(ARG_COMMAND);
            CommandAtom found = this.findAtom(atomList, commandValue);
            if (Objects.isNull(found)) {
                Sl.failInvalid(commandValue);
                return TermStatus.FAILURE;
            }
            this.printCommand(found);
            return TermStatus.SUCCESS;
        }
        this.printCommands(atomList);
        return TermStatus.SUCCESS;
    }

    private List<CommandAtom> getAtomList(ConcurrentMap<String, CommandAtom> atomMap) {
        TreeSet treeSet = new TreeSet(atomMap.keySet());
        ArrayList<CommandAtom> atoms = new ArrayList<CommandAtom>();
        treeSet.stream().map(atomMap::get).forEach(atoms::add);
        return atoms;
    }

    private CommandAtom findAtom(List<CommandAtom> atomList, String command) {
        return atomList.stream().filter(atom -> command.equals(atom.getName()) || command.equals(atom.getSimple())).findAny().orElse(null);
    }

    private void printCommands(List<CommandAtom> atoms) {
        JsonObject config = Ut.sureJObject((JsonObject)this.atom.getConfig().getJsonObject("header"));
        String name = config.containsKey("name") ? config.getString("name") : "Command Name";
        String simple = config.containsKey("simple") ? config.getString("simple") : "Command Simple";
        String description = config.containsKey("description") ? config.getString("description") : "Description";
        StringBuilder content = new StringBuilder();
        content.append(Sl.message("help", () -> "Command List: ")).append("\n");
        content.append("------------------------------------------------------\n");
        content.append(String.format("%-32s", " " + Log.color((String)name, (int)33, (boolean)true)));
        content.append(String.format("%-26s", Log.color((String)simple, (int)33, (boolean)true)));
        content.append(String.format("%-16s", Log.color((String)description, (int)33, (boolean)true))).append("\n");
        content.append("------------------------------------------------------\n");
        this.printContent(content, atoms, " ");
        content.append("------------------------------------------------------");
        System.out.println(content.toString());
    }

    private void printContent(StringBuilder content, List<CommandAtom> atoms, String prefix) {
        atoms.forEach(atom -> {
            content.append(String.format("%-24s", prefix + " " + atom.getName()));
            content.append(String.format("%-20s", prefix + " " + atom.getSimple()));
            content.append(String.format("%-20s", atom.getDescription())).append("\n");
            if (CommandType.SYSTEM == atom.getType()) {
                List<CommandAtom> children = atom.getCommands();
                this.printContent(content, children, prefix + " - ");
            }
        });
    }

    private void printCommand(CommandAtom atom) {
        String header = Sl.message("header", () -> "Zero Framework Console/Shell!");
        String usage = Sl.message("usage", () -> "Basic Syntax: <command> [options...]\tCommand Name: {0}, Command Type: {1}\tOptions Format: [-opt1 value1 -opt2 value2]");
        usage = MessageFormat.format(usage, Log.color((String)atom.getName(), (int)36, (boolean)true), Log.color((String)atom.getType().name(), (int)36, (boolean)true));
        HelpFormatter formatter = new HelpFormatter();
        formatter.setWidth(240);
        formatter.printHelp(usage, header, atom.options(), null);
    }
}

