/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.shell.refine;

import io.vertx.core.json.JsonObject;
import io.vertx.tp.plugin.shell.cv.em.TermStatus;
import io.vertx.tp.plugin.shell.refine.Sl;
import io.vertx.tp.plugin.shell.refine.SlConfig;
import io.vertx.up.log.Log;
import io.vertx.up.util.Ut;
import java.util.Objects;
import java.util.function.Supplier;

class SlMessage {
    static final JsonObject WELCOME = SlConfig.welcome();

    SlMessage() {
    }

    static void failEmpty() {
        Sl.output(SlMessage.message("empty", () -> "Empty arguments here for redo"), new Object[0]);
    }

    static void failInvalid(String command) {
        Sl.output(SlMessage.message("invalid", () -> "Invalid command \"{0}\", it could not be recognised"), command);
    }

    static TermStatus failError(Throwable ex) {
        String error = Objects.isNull(ex) ? "Error" : ex.getMessage();
        Sl.output(SlMessage.message("error", () -> Log.color((String)"[ ERROR ]", (int)31, (boolean)true) + " " + Log.color((String)" {0} ", (int)31)), error);
        if (SlConfig.isDebug()) {
            ex.printStackTrace();
        }
        return TermStatus.FAILURE;
    }

    static void failWarn(String message, Object ... args) {
        Sl.output(Log.color((String)"[ WARN  ]", (int)33, (boolean)true) + " " + Log.color((String)message, (int)37), args);
    }

    static String message(String key, Supplier<String> defaultSupplier) {
        JsonObject message = WELCOME.getJsonObject("message");
        String information = message.getString(key);
        if (Ut.isNil((String)information)) {
            return defaultSupplier.get();
        }
        return information;
    }
}

