/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.shell;

import io.vertx.core.Future;
import io.vertx.tp.error.CommandParseException;
import io.vertx.tp.error.CommandUnknownException;
import io.vertx.tp.error.PluginMissingException;
import io.vertx.tp.plugin.shell.Commander;
import io.vertx.tp.plugin.shell.ConsoleCommander;
import io.vertx.tp.plugin.shell.atom.CommandAtom;
import io.vertx.tp.plugin.shell.atom.CommandInput;
import io.vertx.tp.plugin.shell.cv.em.CommandType;
import io.vertx.tp.plugin.shell.cv.em.TermStatus;
import io.vertx.tp.plugin.shell.refine.Sl;
import io.vertx.up.util.Ut;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.ParseException;

class ConsoleTool {
    ConsoleTool() {
    }

    static Future<CommandLine> parseAsync(String[] args, List<CommandAtom> definition) {
        DefaultParser parser = new DefaultParser();
        String commandName = args[0];
        return ConsoleTool.findAsync(commandName, definition).compose(arg_0 -> ConsoleTool.lambda$parseAsync$0((CommandLineParser)parser, args, arg_0));
    }

    static Future<TermStatus> runAsync(CommandLine parsed, List<CommandAtom> commands, Function<Commander, Commander> binder) {
        List args = parsed.getArgList();
        return ConsoleTool.findAsync((String)args.get(0), commands).compose(command -> {
            Commander commander;
            CommandInput input = ConsoleTool.getInput(parsed).bind((CommandAtom)command).bind(commands);
            if (CommandType.SYSTEM == command.getType()) {
                commander = (Commander)Ut.instance(ConsoleCommander.class, (Object[])new Object[0]);
            } else {
                commander = (Commander)Ut.instance(command.getPlugin(), (Object[])new Object[0]);
                if (Objects.isNull(commander)) {
                    return Future.failedFuture((Throwable)((Object)new PluginMissingException(ConsoleTool.class, command.getName() + ", ( " + command.getPlugin() + " )")));
                }
            }
            Sl.welcomeCommand(command);
            return ((Commander)binder.apply(commander.bind((CommandAtom)command))).executeAsync(input);
        });
    }

    private static CommandInput getInput(CommandLine parsed) {
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        Arrays.stream(parsed.getOptions()).forEach(option -> {
            String name = option.getOpt();
            String value = parsed.getOptionValue(name);
            names.add(name);
            values.add(value);
        });
        return CommandInput.create(names, values);
    }

    private static Future<CommandAtom> findAsync(String commandName, List<CommandAtom> commands) {
        CommandAtom atom = commands.stream().filter(each -> commandName.equals(each.getSimple()) || commandName.equals(each.getName())).findAny().orElse(null);
        if (Objects.isNull(atom)) {
            return Future.failedFuture((Throwable)((Object)new CommandUnknownException(ConsoleTool.class, commandName)));
        }
        if (atom.valid()) {
            return Future.succeededFuture((Object)atom);
        }
        return Future.failedFuture((Throwable)((Object)new PluginMissingException(ConsoleTool.class, atom.getName())));
    }

    private static /* synthetic */ Future lambda$parseAsync$0(CommandLineParser parser, String[] args, CommandAtom command) {
        try {
            CommandLine parsed = parser.parse(command.options(), args);
            return Future.succeededFuture((Object)parsed);
        }
        catch (ParseException ex) {
            CommandParseException error = new CommandParseException(ConsoleTool.class, Ut.fromJoin((Object[])args), ex);
            return Future.failedFuture((Throwable)((Object)error));
        }
    }
}

