/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.shell.atom;

import io.vertx.tp.plugin.shell.atom.CommandAtom;
import io.vertx.up.util.Ut;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.cli.Options;

public class CommandInput
implements Serializable {
    protected final ConcurrentMap<String, CommandAtom> defineMap = new ConcurrentHashMap<String, CommandAtom>();
    private final ConcurrentMap<String, String> inputValue = new ConcurrentHashMap<String, String>();
    private transient Options options;

    private CommandInput(List<String> names, List<String> values) {
        if (values.size() >= names.size()) {
            Ut.itList(names, (name, index) -> {
                String value = (String)values.get((int)index);
                this.inputValue.put((String)name, value);
            });
        }
    }

    public static CommandInput create(List<String> names, List<String> values) {
        return new CommandInput(names, values);
    }

    public String get(String name) {
        return (String)this.inputValue.get(name);
    }

    public ConcurrentMap<String, String> get() {
        return this.inputValue;
    }

    public Options options() {
        return this.options;
    }

    public CommandInput bind(CommandAtom atom) {
        this.options = atom.options();
        return this;
    }

    public CommandInput bind(List<CommandAtom> atoms) {
        atoms.forEach(atom -> this.defineMap.put(atom.getSimple(), (CommandAtom)atom));
        return this;
    }

    public ConcurrentMap<String, CommandAtom> atom() {
        return this.defineMap;
    }
}

