/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.shell.refine;

import io.vertx.core.json.JsonArray;
import io.vertx.tp.plugin.shell.ConsoleCommander;
import io.vertx.tp.plugin.shell.atom.CommandAtom;
import io.vertx.tp.plugin.shell.commander.BackCommander;
import io.vertx.tp.plugin.shell.commander.HelpCommander;
import io.vertx.tp.plugin.shell.commander.QuitCommander;
import io.vertx.tp.plugin.shell.cv.em.CommandType;
import io.vertx.tp.plugin.shell.refine.Sl;
import io.vertx.tp.plugin.shell.refine.SlConfig;
import io.vertx.up.unity.Ux;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;

class SlCommand {
    private static final List<CommandAtom> commands = new ArrayList<CommandAtom>();
    private static final ConcurrentMap<String, Class<?>> COMMAND_PLUGINS = new ConcurrentHashMap<String, Class<?>>(){
        {
            this.put("h", HelpCommander.class);
            this.put("q", QuitCommander.class);
            this.put("b", BackCommander.class);
        }
    };

    SlCommand() {
    }

    public static List<CommandAtom> commands() {
        if (commands.isEmpty()) {
            List<CommandAtom> defaults = SlCommand.mountDefault("h", "q");
            commands.addAll(defaults);
            JsonArray commandJson = SlConfig.commands();
            List commandsList = Ux.fromJson((JsonArray)commandJson, CommandAtom.class);
            commandsList.stream().filter(command -> COMMAND_PLUGINS.containsKey(command.getSimple())).forEach(item -> Sl.failWarn("The command will be ignored: name = {0}, description: {1}", item.getName(), item.getDescription()));
            List<CommandAtom> filtered = commandsList.stream().filter(item -> !COMMAND_PLUGINS.containsKey(item.getSimple())).collect(Collectors.toList());
            commands.addAll(SlCommand.mountPlugin(filtered));
        }
        return commands;
    }

    public static List<CommandAtom> commands(List<CommandAtom> commands) {
        ArrayList source = Objects.isNull(commands) ? new ArrayList() : commands;
        source.stream().filter(command -> COMMAND_PLUGINS.containsKey(command.getSimple())).forEach(item -> Sl.failWarn("The command will be ignored: name = {0}, description: {1}", item.getName(), item.getDescription()));
        List<CommandAtom> normalized = source.stream().filter(command -> !COMMAND_PLUGINS.containsKey(command.getSimple())).collect(Collectors.toList());
        List<CommandAtom> defaults = SlCommand.mountDefault("h", "b");
        normalized.addAll(defaults);
        SlCommand.mountPlugin(normalized);
        return normalized;
    }

    private static List<CommandAtom> mountDefault(String ... includes) {
        JsonArray commandsDefault = SlConfig.commandsDefault();
        List commandsDefaultList = Ux.fromJson((JsonArray)commandsDefault, CommandAtom.class);
        HashSet<String> includeSet = new HashSet<String>(Arrays.asList(includes));
        return commandsDefaultList.stream().filter(command -> includeSet.contains(command.getSimple())).peek(command -> {
            command.setArgs(false);
            command.setType(CommandType.DEFAULT);
            command.setPlugin((Class)COMMAND_PLUGINS.get(command.getSimple()));
        }).collect(Collectors.toList());
    }

    private static List<CommandAtom> mountPlugin(List<CommandAtom> commands) {
        commands.stream().filter(item -> CommandType.SYSTEM == item.getType()).forEach(command -> {
            command.setArgs(false);
            command.setPlugin(ConsoleCommander.class);
        });
        return commands;
    }
}

