/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.ali.sms;

import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsRequest;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsResponse;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.error._424MessageSendException;
import io.vertx.tp.error._424ProfileEndPointException;
import io.vertx.tp.plugin.ali.sms.SmsClient;
import io.vertx.tp.plugin.ali.sms.SmsConfig;
import io.vertx.up.fn.Fn;
import io.vertx.up.log.Annal;

public class SmsClientImpl
implements SmsClient {
    private static final Annal LOGGER = Annal.get(SmsClientImpl.class);
    private final transient Vertx vertx;
    private transient SmsConfig config;
    private transient IAcsClient client;

    SmsClientImpl(Vertx vertx, SmsConfig config) {
        this.vertx = vertx;
        this.config = config;
        this.initClient();
    }

    private void initClient() {
        JsonObject params = this.config.getConfig();
        Fn.safeNull(() -> {
            String connect = params.containsKey("timeout_connect") ? params.getInteger("timeout_connect").toString() : "10000";
            String read = params.containsKey("timeout_read") ? params.getInteger("timeout_read").toString() : "10000";
            System.setProperty("sun.net.client.defaultConnectTimeout", connect);
            System.setProperty("sun.net.client.defaultReadTimeout", read);
            DefaultProfile profile = DefaultProfile.getProfile((String)"cn-hangzhou", (String)this.config.getAccessId(), (String)this.config.getAccessSecret());
            try {
                DefaultProfile.addEndpoint((String)"cn-hangzhou", (String)"cn-hangzhou", (String)"Dysmsapi", (String)this.config.getDomain());
            }
            catch (ClientException ex) {
                Fn.outWeb((boolean)true, (Annal)LOGGER, _424ProfileEndPointException.class, (Object[])new Object[]{this.getClass(), ex});
            }
            this.client = new DefaultAcsClient((IClientProfile)profile);
        }, (Object[])new Object[]{params});
    }

    @Override
    public SmsClient init(JsonObject params) {
        this.config = SmsConfig.create(params);
        this.initClient();
        return this;
    }

    @Override
    public SmsClient send(String mobile, String tplCode, JsonObject params, Handler<AsyncResult<JsonObject>> handler) {
        SendSmsRequest request = this.getRequest(mobile, this.config.getTpl(tplCode), params);
        handler.handle(this.getResponse(request));
        return this;
    }

    private Future<JsonObject> getResponse(SendSmsRequest request) {
        try {
            SendSmsResponse response = (SendSmsResponse)this.client.getAcsResponse((AcsRequest)request);
            JsonObject data = new JsonObject();
            data.put("request_id", response.getRequestId());
            data.put("business_id", response.getBizId());
            data.put("code", response.getCode());
            data.put("message", response.getMessage());
            return Future.succeededFuture((Object)data);
        }
        catch (ClientException ex) {
            Fn.outWeb((boolean)true, (Annal)LOGGER, _424MessageSendException.class, (Object[])new Object[]{this.getClass(), ex});
            return Future.failedFuture((Throwable)ex);
        }
    }

    private SendSmsRequest getRequest(String mobile, String tplCode, JsonObject params) {
        SendSmsRequest request = new SendSmsRequest();
        request.setPhoneNumbers(mobile);
        request.setSignName(this.config.getSignName());
        request.setTemplateCode(tplCode);
        request.setTemplateParam(params.encode());
        return request;
    }
}

