/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.rpc;

import io.vertx.core.AsyncResult;
import io.vertx.core.Promise;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.ipc.eon.IpcResponse;
import io.vertx.up.commune.Envelop;
import io.vertx.up.exception.WebException;
import io.vertx.up.exception.web._500UnexpectedRpcException;
import io.vertx.up.log.Annal;
import io.vertx.up.uca.micro.ipc.DataEncap;

public class RpcRepdor {
    private static final Annal LOGGER = Annal.get(RpcRepdor.class);
    private final transient Class<?> clazz;

    private RpcRepdor(Class<?> clazz) {
        this.clazz = clazz;
    }

    public static RpcRepdor create(Class<?> clazz) {
        return new RpcRepdor(clazz);
    }

    public void replyJson(Promise<JsonObject> handler, AsyncResult<IpcResponse> response) {
        if (response.succeeded()) {
            Envelop json = DataEncap.out((IpcResponse)response.result());
            JsonObject data = (JsonObject)json.data();
            LOGGER.info("( Rpc Client ) Response Json data is {0}", new Object[]{data});
            handler.complete((Object)data);
        } else {
            Throwable ex = response.cause();
            if (null != ex) {
                Envelop envelop = Envelop.failure((WebException)new _500UnexpectedRpcException(this.clazz, ex));
                handler.complete((Object)envelop.outJson());
                ex.printStackTrace();
            }
        }
    }

    public void reply(Promise<Envelop> handler, AsyncResult<IpcResponse> response) {
        if (response.succeeded()) {
            handler.complete((Object)DataEncap.out((IpcResponse)response.result()));
        } else {
            Throwable ex = response.cause();
            if (null != ex) {
                Envelop envelop = Envelop.failure((WebException)new _500UnexpectedRpcException(this.clazz, ex));
                handler.complete((Object)envelop);
                ex.printStackTrace();
            }
        }
    }
}

