/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.micro.ipc;

import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.servicediscovery.Record;
import io.vertx.tp.ipc.eon.IpcEnvelop;
import io.vertx.tp.ipc.eon.IpcRequest;
import io.vertx.tp.ipc.eon.IpcResponse;
import io.vertx.tp.ipc.eon.em.Format;
import io.vertx.up.atom.rpc.IpcData;
import io.vertx.up.commune.Envelop;
import io.vertx.up.eon.em.IpcType;
import io.vertx.up.fn.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.uca.container.VirtualUser;
import io.vertx.up.util.Ut;

public class DataEncap {
    private static final Annal LOGGER = Annal.get(DataEncap.class);

    public static void in(IpcData data, Record record) {
        if (null != record) {
            data.setHost(record.getLocation().getString("host"));
            data.setPort(record.getLocation().getInteger("port"));
            data.setName(record.getName());
        }
    }

    public static void in(IpcData data, Envelop envelop) {
        if (null != envelop) {
            MultiMap headers;
            User user = envelop.user();
            JsonObject sendData = new JsonObject();
            if (null != user) {
                sendData.put("user", user.principal());
            }
            if (null != (headers = envelop.headers())) {
                JsonObject headerData = new JsonObject();
                headers.forEach(entry -> headerData.put((String)entry.getKey(), (String)entry.getValue()));
                sendData.put("header", headerData);
            }
            Object content = envelop.data();
            sendData.put("data", content);
            sendData.put("config", data.getConfig());
            sendData.put("address", data.getAddress());
            data.setData(sendData.toBuffer());
        }
    }

    public static IpcRequest in(IpcData data) {
        IpcEnvelop envelop = IpcEnvelop.newBuilder().setBody(data.getData().toString()).setType(Format.JSON).build();
        return IpcRequest.newBuilder().setEnvelop(envelop).build();
    }

    public static IpcData consume(IpcRequest request, IpcType type) {
        IpcData ipcData = new IpcData();
        IpcEnvelop envelop = request.getEnvelop();
        String data = envelop.getBody();
        JsonObject json = new JsonObject(data);
        if (json.containsKey("address")) {
            ipcData.setAddress(json.getString("address"));
            json.remove("address");
        }
        ipcData.setData(Buffer.buffer((String)data));
        ipcData.setType(type);
        return ipcData;
    }

    public static Envelop consume(IpcData data) {
        JsonObject json = data.getData().toJsonObject();
        return DataEncap.build(json);
    }

    public static IpcResponse out(IpcData data) {
        IpcEnvelop result = IpcEnvelop.newBuilder().setBody(data.getData().toString()).setType(Format.JSON).build();
        return IpcResponse.newBuilder().setEnvelop(result).build();
    }

    private static Envelop build(JsonObject json) {
        Envelop envelop = Envelop.ok();
        if (null != json) {
            if (json.containsKey("data")) {
                envelop = Envelop.success((Object)json.getValue("data"));
            }
            if (null != json.getValue("header")) {
                MultiMap headers = MultiMap.caseInsensitiveMultiMap();
                JsonObject headerData = json.getJsonObject("header");
                for (String key : headerData.fieldNames()) {
                    Object value = headerData.getValue(key);
                    if (null == value) continue;
                    headers.set(key, value.toString());
                }
                envelop.setHeaders(headers);
            }
            if (null != json.getValue("user")) {
                envelop.setUser((User)new VirtualUser(json.getJsonObject("user")));
            }
        }
        return envelop;
    }

    public static Envelop out(IpcResponse data) {
        return DataEncap.build(DataEncap.outJson(data));
    }

    public static JsonObject outJson(IpcResponse data) {
        String json = data.getEnvelop().getBody();
        return (JsonObject)Fn.getSemi((boolean)Ut.notNil((String)json), (Annal)LOGGER, () -> new JsonObject(json));
    }
}

