/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.etcd.center;

import io.reactivex.Observable;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.up.atom.Ruler;
import io.vertx.up.exception.zero.EtcdConfigEmptyException;
import io.vertx.up.exception.zero.EtcdNetworkException;
import io.vertx.up.fn.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.uca.yaml.Node;
import io.vertx.up.uca.yaml.ZeroUniform;
import io.vertx.up.util.Ut;
import java.io.IOException;
import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import mousio.etcd4j.EtcdClient;
import mousio.etcd4j.promises.EtcdResponsePromise;
import mousio.etcd4j.requests.EtcdKeyDeleteRequest;
import mousio.etcd4j.requests.EtcdKeyGetRequest;
import mousio.etcd4j.requests.EtcdKeyPutRequest;
import mousio.etcd4j.responses.EtcdAuthenticationException;
import mousio.etcd4j.responses.EtcdException;
import mousio.etcd4j.responses.EtcdKeysResponse;

public class EtcdData {
    private static final Annal LOGGER = Annal.get(EtcdData.class);
    private static final Node<JsonObject> NODE = (Node)Ut.singleton(ZeroUniform.class, (Object[])new Object[0]);
    private static final ConcurrentMap<Class<?>, EtcdData> POOL = new ConcurrentHashMap();
    private static final String KEY = "etcd";
    private static final String MICRO = "micro";
    private static final String NODES = "nodes";
    private static final String TIMEOUT = "timeout";
    private static final String PORT = "port";
    private static final String HOST = "host";
    private final transient JsonArray config = new JsonArray();
    private final transient EtcdClient client;
    private final transient Class<?> clazz;
    private transient long timeout = -1L;
    private transient String application = "";

    private EtcdData(Class<?> clazz) {
        this.clazz = clazz;
        Annal logger = Annal.get(clazz);
        JsonObject config = (JsonObject)NODE.read();
        if (config.containsKey(KEY)) {
            JsonObject root = config.getJsonObject(KEY);
            Fn.outUp(() -> Fn.onZero(() -> Ruler.verify((String)KEY, (JsonObject)root), (Object[])new Object[]{root}), (Annal)LOGGER);
            if (root.containsKey(TIMEOUT)) {
                this.timeout = root.getLong(TIMEOUT);
            }
            if (root.containsKey(MICRO)) {
                this.application = root.getString(MICRO);
            }
            if (root.containsKey(NODES)) {
                this.config.addAll(root.getJsonArray(NODES));
            }
            LOGGER.info("( Etcd Center: {0} ) Etcd Client timeout = \"{1}s\" with nodes = {2}", new Object[]{this.application, this.timeout, this.config.size()});
        }
        Fn.outUp((boolean)this.config.isEmpty(), (Annal)logger, EtcdConfigEmptyException.class, (Object[])new Object[]{this.clazz});
        HashSet uris = new HashSet();
        ConcurrentHashMap<Integer, String> networks = new ConcurrentHashMap<Integer, String>();
        Observable.fromIterable((Iterable)this.config).filter(Objects::nonNull).map(item -> (JsonObject)item).filter(item -> item.containsKey(PORT) && item.containsKey(HOST)).map(item -> {
            Integer port = item.getInteger(PORT);
            String host = item.getString(HOST);
            networks.put(port, host);
            return "http://" + host + ":" + port;
        }).map(URI::create).subscribe(uris::add).dispose();
        networks.forEach((port, host) -> Fn.outUp((!Ut.netOk((String)host, (int)port) ? 1 : 0) != 0, (Annal)LOGGER, EtcdNetworkException.class, (Object[])new Object[]{this.getClass(), host, port}));
        LOGGER.info("( Etcd Center ) Etcd network checking has been passed successfully !", new Object[0]);
        this.client = new EtcdClient(uris.toArray(new URI[0]));
    }

    public static EtcdData create(Class<?> clazz) {
        if (EtcdData.enabled()) {
            LOGGER.info("( Etcd Center ) Etcd configuration center is enabled !", new Object[0]);
        }
        return (EtcdData)Fn.pool(POOL, clazz, () -> (EtcdData)Fn.getNull(null, () -> new EtcdData(clazz), (Object[])new Object[]{clazz}));
    }

    public static boolean enabled() {
        JsonObject config = (JsonObject)NODE.read();
        return null != config && config.containsKey(KEY);
    }

    public EtcdClient getClient() {
        return this.client;
    }

    public JsonArray getConfig() {
        return this.config;
    }

    public String getApplication() {
        return this.application;
    }

    public ConcurrentMap<String, String> readDir(String path, boolean shiftted) {
        return (ConcurrentMap)Fn.getJvm(new ConcurrentHashMap(), () -> {
            EtcdKeysResponse.EtcdNode node = this.readNode(path, arg_0 -> ((EtcdClient)this.client).getDir(arg_0));
            return (ConcurrentMap)Fn.getJvm(new ConcurrentHashMap(), () -> {
                ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
                List nodes = node.getNodes();
                for (EtcdKeysResponse.EtcdNode nodeItem : nodes) {
                    String key = nodeItem.getKey();
                    if (shiftted) {
                        key = key.substring(key.lastIndexOf("/") + 1);
                    }
                    result.put(key, nodeItem.getValue());
                }
                return result;
            }, (Object[])new Object[]{node});
        }, (Object[])new Object[]{path});
    }

    private void ensurePath(String path) {
        if (0 <= path.lastIndexOf(47)) {
            String parent = path.substring(0, path.lastIndexOf(47));
            try {
                EtcdKeysResponse response = (EtcdKeysResponse)this.client.getDir(parent).send().get();
                if (null != response) {
                    this.client.putDir(path).send();
                    this.ensurePath(parent);
                }
            }
            catch (IOException | TimeoutException | EtcdAuthenticationException | EtcdException ex) {
                this.ensurePath(parent);
            }
        }
    }

    public String readData(String path) {
        return (String)Fn.getJvm((Object)"", () -> this.readNode(path, arg_0 -> ((EtcdClient)this.client).get(arg_0)).getValue(), (Object[])new Object[]{path});
    }

    private EtcdKeysResponse.EtcdNode readNode(String path, Function<String, EtcdKeyGetRequest> executor) {
        return (EtcdKeysResponse.EtcdNode)Fn.getJvm(null, () -> {
            EtcdKeyGetRequest request = (EtcdKeyGetRequest)executor.apply(path);
            if (-1L != this.timeout) {
                request.timeout(this.timeout, TimeUnit.SECONDS);
            }
            EtcdResponsePromise promise = request.send();
            EtcdKeysResponse response = (EtcdKeysResponse)promise.get();
            return response.getNode();
        }, (Object[])new Object[]{path});
    }

    public String read(String path) {
        EtcdKeysResponse.EtcdNode node = this.readNode(path, arg_0 -> ((EtcdClient)this.client).get(arg_0));
        return null == node ? null : node.getValue();
    }

    public boolean delete(String path) {
        return (Boolean)Fn.getJvm((Object)Boolean.FALSE, () -> {
            EtcdKeyDeleteRequest request = this.client.delete(path);
            EtcdResponsePromise promise = request.send();
            EtcdKeysResponse response = (EtcdKeysResponse)promise.get();
            return null != response.getNode();
        }, (Object[])new Object[]{path});
    }

    public <T> JsonObject write(String path, T data, int ttl) {
        return (JsonObject)Fn.getJvm(null, () -> {
            EtcdKeyPutRequest request = this.client.put(path, (String)Fn.getSemi((data instanceof JsonObject || data instanceof JsonArray ? 1 : 0) != 0, (Annal)LOGGER, () -> (String)Ut.invoke((Object)data, (String)"encode", (Object[])new Object[0]), data::toString));
            if (0 != ttl) {
                request.ttl(Integer.valueOf(ttl));
            }
            if (-1L != this.timeout) {
                request.timeout(this.timeout, TimeUnit.SECONDS);
            }
            EtcdResponsePromise promise = request.send();
            EtcdKeysResponse response = (EtcdKeysResponse)promise.get();
            return (JsonObject)Ut.serializeJson((Object)response.getNode());
        }, (Object[])new Object[]{path, data});
    }
}

