/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.rpc;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.plugin.rpc.RpcClientImpl;
import java.util.UUID;

public interface RpcClient {
    public static final String DEFAULT_POOL_NAME = "DEFAULT_POOL";

    public static RpcClient createNonShared(Vertx vertx, JsonObject config) {
        return new RpcClientImpl(vertx, config, UUID.randomUUID().toString());
    }

    public static RpcClient createShared(Vertx vertx, JsonObject config, String name) {
        return new RpcClientImpl(vertx, config, name);
    }

    public static RpcClient createShared(Vertx vertx, JsonObject config) {
        return new RpcClientImpl(vertx, config, DEFAULT_POOL_NAME);
    }

    @Fluent
    public RpcClient connect(JsonObject var1, JsonObject var2, Handler<AsyncResult<JsonObject>> var3);

    @Fluent
    public RpcClient connect(String var1, String var2, JsonObject var3, Handler<AsyncResult<JsonObject>> var4);

    @Fluent
    public RpcClient close();
}

