/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.rpc;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.core.shareddata.LocalMap;
import io.vertx.servicediscovery.Record;
import io.vertx.tp.plugin.rpc.RpcClient;
import io.vertx.tp.plugin.rpc.RpcHelper;
import io.vertx.tp.plugin.rpc.RpcHolder;
import io.vertx.tp.plugin.rpc.client.RpcStub;
import io.vertx.tp.plugin.rpc.client.UnityStub;
import io.vertx.up.atom.rpc.IpcData;
import io.vertx.up.commune.Envelop;
import io.vertx.up.eon.em.IpcType;
import io.vertx.up.log.Annal;
import io.vertx.up.uca.micro.ipc.DataEncap;
import io.vertx.up.util.Ut;
import java.text.MessageFormat;
import java.util.Objects;

public class RpcClientImpl
implements RpcClient {
    private static final Annal LOGGER = Annal.get(RpcClientImpl.class);
    private static final String DS_LOCAL_MAP_NAME = "__vertx.IpcClient.{0}";
    private final Vertx vertx;
    private final JsonObject config;
    private final String name;
    protected RpcClient client;
    protected RpcHolder holder;

    public RpcClientImpl(Vertx vertx, JsonObject config, String name) {
        Objects.requireNonNull(vertx);
        Objects.requireNonNull(config);
        this.vertx = vertx;
        this.config = config;
        this.name = name;
    }

    @Override
    public RpcClient connect(JsonObject config, JsonObject data, Handler<AsyncResult<JsonObject>> handler) {
        Record record = RpcHelper.getRecord(config);
        String name = config.getString("name");
        String address = config.getString("addr");
        JsonObject normalized = RpcHelper.normalize(name, config, record);
        this.holder = this.lookupHolder(this.vertx, name, normalized);
        IpcType type = (IpcType)Ut.toEnum(IpcType.class, (String)config.getString("type"));
        RpcStub stub = this.getStub(type);
        IpcData request = new IpcData();
        request.setType(type);
        request.setAddress(address);
        DataEncap.in(request, record);
        DataEncap.in(request, Envelop.success((Object)data));
        LOGGER.info("( Rpc Client ) Final Traffic Data will be {0}", new Object[]{request.toString()});
        Future<JsonObject> future = stub.traffic(request);
        future.onComplete(res -> handler.handle((Object)Future.succeededFuture((Object)res.result())));
        return this;
    }

    @Override
    public RpcClient connect(String name, String address, JsonObject data, Handler<AsyncResult<JsonObject>> handler) {
        return this.connect(RpcHelper.on(name, address), data, handler);
    }

    @Override
    public RpcClient close() {
        this.holder.close();
        return this;
    }

    private RpcStub getStub(IpcType type) {
        switch (type) {
            default: 
        }
        RpcStub stub = (RpcStub)Ut.instance(UnityStub.class, (Object[])new Object[]{this.holder.getChannel()});
        return stub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RpcHolder lookupHolder(Vertx vertx, String ipcName, JsonObject config) {
        Vertx vertx2 = this.vertx;
        synchronized (vertx2) {
            String name = MessageFormat.format(DS_LOCAL_MAP_NAME, config.getString("type"));
            LocalMap map = this.vertx.sharedData().getLocalMap(name);
            RpcHolder holder = (RpcHolder)map.get((Object)ipcName);
            if (null == holder) {
                holder = new RpcHolder(vertx, config, () -> this.removeFromMap((LocalMap<String, RpcHolder>)map, name));
                map.put((Object)name, (Object)holder);
            } else {
                holder.incRefCount();
            }
            return holder;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromMap(LocalMap<String, RpcHolder> map, String name) {
        Vertx vertx = this.vertx;
        synchronized (vertx) {
            map.remove((Object)name);
            if (map.isEmpty()) {
                map.close();
            }
        }
    }
}

