/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.uca.micro.ssl;

import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.TCPSSLOptions;
import io.vertx.up.eon.em.CertType;
import io.vertx.up.uca.micro.ssl.server.JksCert;
import io.vertx.up.uca.micro.ssl.server.PemCert;
import io.vertx.up.uca.micro.ssl.server.PfxCert;
import io.vertx.up.util.Ut;

public interface CertPipe<I> {
    public static CertPipe<JsonObject> get(CertType type) {
        CertPipe pipe = null;
        switch (type) {
            case PKCS12: {
                pipe = (CertPipe)Ut.singleton(PfxCert.class, (Object[])new Object[0]);
                break;
            }
            case JKS: {
                pipe = (CertPipe)Ut.singleton(JksCert.class, (Object[])new Object[0]);
                break;
            }
            case PEM: {
                pipe = (CertPipe)Ut.singleton(PemCert.class, (Object[])new Object[0]);
            }
        }
        return pipe;
    }

    public Handler<TCPSSLOptions> parse(I var1);
}

