/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.integration.service;

import cn.vertxup.integration.domain.tables.daos.IDirectoryDao;
import cn.vertxup.integration.domain.tables.pojos.IDirectory;
import cn.vertxup.integration.service.DirStub;
import io.horizon.atom.common.Kv;
import io.horizon.uca.cache.Cc;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.is.refine.Is;
import io.vertx.tp.is.uca.command.Fs;
import io.vertx.tp.is.uca.updater.StoreMigration;
import io.vertx.tp.is.uca.updater.StoreRename;
import io.vertx.tp.is.uca.updater.StoreUp;
import io.vertx.up.uca.jooq.UxJooq;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;

public class DirService
implements DirStub {
    private static final Cc<String, StoreUp> CC_UP = Cc.openThread();

    @Override
    public Future<JsonObject> create(JsonObject directoryJ) {
        return Is.fsRun(directoryJ, fs -> {
            JsonObject inputJ = Is.dataIn(directoryJ);
            IDirectory directory = fs.initTree(inputJ);
            return Ux.Jooq.on(IDirectoryDao.class).insertJAsync((Object)directory).compose(Is::dataOut).compose(fs::mkdir);
        });
    }

    @Override
    public Future<Boolean> remove(String key) {
        UxJooq jq = Ux.Jooq.on(IDirectoryDao.class);
        return jq.fetchByIdAsync((Object)key).compose(directory -> Is.directoryQr(directory).compose(queried -> {
            ArrayList<IDirectory> directories = new ArrayList<IDirectory>();
            if (Objects.nonNull(directory)) {
                directories.add((IDirectory)directory);
            }
            directories.addAll((Collection<IDirectory>)queried);
            return Ux.future(directories);
        })).compose(arg_0 -> ((UxJooq)Ux.Jooq.on(IDirectoryDao.class)).deleteJAsync(arg_0)).compose(removed -> Is.fsRun(removed, Fs::rm)).compose(nil -> Ux.futureT());
    }

    @Override
    public Future<Boolean> remove(String key, String userId) {
        UxJooq jq = Ux.Jooq.on(IDirectoryDao.class);
        return jq.fetchByIdAsync((Object)key).compose(directory -> Is.directoryQr(directory).compose(queried -> {
            ArrayList<IDirectory> directories = new ArrayList<IDirectory>();
            if (Objects.nonNull(directory)) {
                directories.add((IDirectory)directory);
            }
            directories.addAll((Collection<IDirectory>)queried);
            directories.forEach(item -> {
                item.setActive(Boolean.FALSE);
                item.setUpdatedBy(userId);
                item.setUpdatedAt(LocalDateTime.now());
            });
            return jq.updateAsync(directories).compose(Ux::futureJ);
        })).compose(directoryJ -> Is.fsRun(directoryJ, fs -> {
            fs.initTrash();
            Kv<String, String> kv = Is.trashIn(directoryJ);
            return fs.rename(kv).compose(renamed -> Ux.future((Object)directoryJ));
        })).compose(removed -> Ux.futureT());
    }

    @Override
    public Future<JsonObject> updateBranch(IDirectory directory) {
        if (Objects.isNull(directory)) {
            return Ux.futureJ();
        }
        String parent = directory.getParentId();
        if (Ut.isNil((String)parent)) {
            return Ux.futureJ((Object)directory);
        }
        return Is.directoryBranch(parent, directory.getUpdatedBy()).compose(nil -> Ux.futureJ((Object)directory));
    }

    @Override
    public Future<JsonObject> update(String key, JsonObject directoryJ) {
        UxJooq jq = Ux.Jooq.on(IDirectoryDao.class);
        return jq.fetchByIdAsync((Object)key).compose(directory -> {
            if (Objects.isNull(directory)) {
                return Ux.future();
            }
            String integrationId = directoryJ.getString("integrationId");
            if (Ut.isDiff((Object)integrationId, (Object)directory.getIntegrationId())) {
                StoreUp store = (StoreUp)CC_UP.pick(StoreMigration::new, (Object)StoreMigration.class.getName());
                Is.LOG.Web.info(this.getClass(), "Integration Changing: {0}", new Object[]{store.getClass()});
                return store.migrate((IDirectory)directory, directoryJ);
            }
            String storePath = directoryJ.getString("storePath");
            if (Ut.isDiff((Object)storePath, (Object)directory.getStorePath())) {
                StoreUp store = (StoreUp)CC_UP.pick(StoreRename::new, (Object)StoreRename.class.getName());
                Is.LOG.Web.info(this.getClass(), "StorePath Changing: {0}", new Object[]{store.getClass()});
                return store.migrate((IDirectory)directory, directoryJ);
            }
            return Ux.future((Object)directory);
        }).compose(directory -> {
            if (Objects.isNull(directory)) {
                return Ux.futureJ();
            }
            JsonObject data = Is.dataIn(directoryJ);
            IDirectory updated = (IDirectory)Ux.updateT((Object)directory, (JsonObject)data);
            return jq.updateAsync((Object)key, (Object)updated).compose(this::updateBranch).compose(Is::dataOut);
        });
    }
}

