/*
 * Decompiled with CFR 0.152.
 */
package io.horizon.spi.business;

import cn.vertxup.integration.domain.tables.daos.IDirectoryDao;
import cn.vertxup.integration.domain.tables.pojos.IDirectory;
import io.horizon.atom.common.Kv;
import io.horizon.spi.business.ExIo;
import io.vertx.core.Future;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.is.refine.Is;
import io.vertx.tp.is.uca.command.Fs;
import io.vertx.up.fn.Fn;
import io.vertx.up.uca.jooq.UxJooq;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ExPath
implements ExIo {
    public Future<JsonArray> docInitialize(JsonArray data, JsonObject config) {
        return Is.fsDocument(data, config).compose(Is::dataOut);
    }

    public Future<JsonArray> dirRun(String sigma, String parentId) {
        Objects.requireNonNull(sigma);
        JsonObject condition = Ux.whereAnd();
        condition.put("sigma", (Object)sigma);
        condition.put("active", (Object)Boolean.TRUE);
        if (Ut.isNotNil((String)parentId)) {
            condition.put("parentId", (Object)parentId);
        }
        return Is.directoryQr(condition).compose(Ux::futureA).compose(Is::dataOut);
    }

    public Future<JsonObject> dirBy(String sigma, String directory) {
        Objects.requireNonNull(sigma);
        JsonObject condition = Ux.whereAnd();
        condition.put("sigma", (Object)sigma);
        condition.put("code", (Object)directory);
        return Ux.Jooq.on(IDirectoryDao.class).fetchJOneAsync(condition).compose(Is::dataOut);
    }

    public Future<ConcurrentMap<String, JsonObject>> dirBy(Set<String> keys) {
        JsonObject condition = Ux.whereAnd();
        condition.put("key,i", (Object)Ut.toJArray(keys));
        return Ux.Jooq.on(IDirectoryDao.class).fetchJAsync(condition).compose(Is::dataOut).compose(directories -> {
            ConcurrentMap map = Ut.elementMap((JsonArray)directories, (String)"key");
            return Ux.future((Object)map);
        });
    }

    public Future<JsonArray> dirTrash(String sigma) {
        Objects.requireNonNull(sigma);
        JsonObject condition = Ux.whereAnd();
        condition.put("sigma", (Object)sigma);
        condition.put("active", (Object)Boolean.FALSE);
        return Is.directoryQr(condition).compose(Ux::futureA).compose(Is::dataOut);
    }

    public Future<Boolean> fsUpload(String directoryId, ConcurrentMap<String, String> fileMap) {
        return Is.fsComponent(directoryId).compose(fs -> fs.upload(fileMap));
    }

    public Future<Boolean> fsRemove(String directoryId, ConcurrentMap<String, String> fileMap) {
        return Is.fsComponent(directoryId).compose(fs -> fs.rm(fileMap.values()));
    }

    public Future<Buffer> fsDownload(String directoryId, ConcurrentMap<String, String> fileMap) {
        return Is.fsComponent(directoryId).compose(fs -> fs.download(new HashSet<String>(fileMap.values())));
    }

    public Future<Buffer> fsDownload(String directoryId, String storePath) {
        return Is.fsComponent(directoryId).compose(fs -> fs.download(storePath));
    }

    public Future<JsonObject> update(String directoryId, String user) {
        return Is.directoryBranch(directoryId, user).compose(Ux::futureJ);
    }

    public Future<JsonArray> trashIn(JsonArray directoryJ, ConcurrentMap<String, String> fileMap) {
        return this.directoryU(directoryJ, false).compose(directoryMap -> Is.fsGroup(fileMap).compose(attachmentMap -> this.trashDo((ConcurrentMap<Fs, Set<String>>)directoryMap, (ConcurrentMap<Fs, Set<String>>)attachmentMap, false))).compose(nil -> Ux.future((Object)directoryJ));
    }

    public Future<JsonArray> trashOut(JsonArray directoryJ, ConcurrentMap<String, String> fileMap) {
        return this.directoryU(directoryJ, true).compose(directoryMap -> Is.fsGroup(fileMap).compose(attachmentMap -> this.trashDo((ConcurrentMap<Fs, Set<String>>)directoryMap, (ConcurrentMap<Fs, Set<String>>)attachmentMap, true))).compose(nil -> Ux.future((Object)directoryJ));
    }

    public Future<JsonArray> purge(JsonArray directoryJ, ConcurrentMap<String, String> fileMap) {
        return this.directoryD(directoryJ).compose(directoryMap -> Is.fsGroup(fileMap).compose(attachmentMap -> {
            ConcurrentMap<Fs, Set<String>> combine = Is.fsCombine(directoryMap, attachmentMap);
            ArrayList futures = new ArrayList();
            combine.forEach((fs, storeSet) -> {
                ConcurrentMap<String, String> renameMap = Is.trashIn(storeSet);
                futures.add(fs.rm(renameMap.values()));
            });
            return Fn.combineT(futures);
        })).compose(nil -> Ux.future((Object)directoryJ));
    }

    public Future<Boolean> rename(JsonObject directoryJ, Kv<String, String> renameKv) {
        String directoryId = directoryJ.getString("key");
        UxJooq jq = Ux.Jooq.on(IDirectoryDao.class);
        String updatedBy = directoryJ.getString("updatedBy");
        return jq.fetchByIdAsync((Object)directoryId).compose(directory -> {
            directory.setUpdatedAt(LocalDateTime.now());
            directory.setUpdatedBy(updatedBy);
            return jq.updateAsync(directory).compose(updated -> Is.directoryBranch(directoryId, updatedBy));
        }).compose(directory -> Is.fsComponent(directory.getKey())).compose(fs -> fs.rename(renameKv));
    }

    public Future<JsonArray> dirTree(String sigma, List<String> paths) {
        JsonObject condition = Ux.whereAnd();
        condition.put("storePath,i", (Object)Ut.toJArray(paths));
        condition.put("sigma", (Object)sigma);
        UxJooq jq = Ux.Jooq.on(IDirectoryDao.class);
        return jq.fetchJAsync(condition);
    }

    public Future<JsonObject> verifyIn(JsonArray directoryA, JsonObject params) {
        Ut.valueToString((JsonArray)directoryA, (String[])new String[]{"visitMode"});
        return Is.directoryLeaf(directoryA, params).compose(Ux::futureJ);
    }

    private Future<Boolean> trashDo(ConcurrentMap<Fs, Set<String>> directoryMap, ConcurrentMap<Fs, Set<String>> fileMap, boolean active) {
        ConcurrentMap<Fs, Set<String>> combine = Is.fsCombine(directoryMap, fileMap);
        ArrayList futures = new ArrayList();
        combine.forEach((fs, storeSet) -> {
            ConcurrentMap<String, String> renameMap;
            if (active) {
                renameMap = Is.trashOut(storeSet);
            } else {
                fs.initTrash();
                renameMap = Is.trashIn(storeSet);
            }
            futures.add(fs.rename(renameMap));
        });
        return Fn.combineT(futures).compose(nil -> Ux.futureT());
    }

    private Future<ConcurrentMap<Fs, Set<String>>> directoryD(JsonArray directoryD) {
        JsonObject criteria = Ux.whereOr();
        criteria.put("key,i", (Object)Ut.toJArray((Set)Ut.valueSetString((JsonArray)directoryD, (String)"key")));
        JsonObject children = Ux.whereOr();
        Ut.itJArray((JsonArray)directoryD).forEach(json -> {
            String storePath = json.getString("storePath");
            if (Ut.isNotNil((String)storePath)) {
                JsonObject child = Ux.whereAnd();
                child.put("storePath,s", (Object)json.getString("storePath"));
                child.put("active", (Object)Boolean.FALSE);
                children.put("$" + json.getString("code") + "$", (Object)child);
            }
        });
        criteria.put("$CH$", (Object)children);
        return Ux.Jooq.on(IDirectoryDao.class).deleteByAsync(criteria).compose(removed -> {
            ConcurrentMap grouped = Ut.elementGroup((JsonArray)directoryD, (String)"runComponent");
            ConcurrentHashMap directoryMap = new ConcurrentHashMap();
            ConcurrentMap<Fs, JsonArray> groupedComponents = Is.fsGroup(grouped, JsonArray::isEmpty);
            groupedComponents.forEach((fs, jarray) -> {
                HashSet valueSet = new HashSet();
                Ut.itJArray((JsonArray)jarray).forEach(json -> valueSet.add(json.getString("storePath")));
                directoryMap.put(fs, valueSet);
            });
            return Ux.future(directoryMap);
        });
    }

    private Future<ConcurrentMap<Fs, Set<String>>> directoryU(JsonArray directoryJ, Boolean active) {
        JsonArray normalized = Is.dataIn(directoryJ);
        Ut.itJArray((JsonArray)normalized).forEach(json -> {
            json.put("active", (Object)active);
            json.put("updatedAt", (Object)Instant.now());
        });
        List directories = Ux.fromJson((JsonArray)normalized, IDirectory.class);
        return Ux.Jooq.on(IDirectoryDao.class).updateAsync(directories).compose(updated -> {
            ConcurrentMap grouped = Ut.elementGroup((Collection)updated, IDirectory::getRunComponent, IDirectory::getStorePath);
            ConcurrentHashMap directoryMap = new ConcurrentHashMap();
            ConcurrentMap<Fs, List> groupedComponents = Is.fsGroup(grouped, List::isEmpty);
            groupedComponents.forEach((fs, list) -> directoryMap.put(fs, new HashSet(list)));
            return Ux.future(directoryMap);
        });
    }
}

