/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.is.refine;

import cn.vertxup.integration.domain.tables.pojos.IDirectory;
import io.horizon.atom.common.Kv;
import io.horizon.uca.log.Log;
import io.horizon.uca.log.LogModule;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.is.refine.IsDir;
import io.vertx.tp.is.refine.IsFs;
import io.vertx.tp.is.uca.command.Fs;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;

public class Is {
    public static Kv<String, String> trashIn(IDirectory directory) {
        Objects.requireNonNull(directory);
        return IsDir.trash(directory.getStorePath());
    }

    public static Kv<String, String> trashIn(JsonObject directoryJ) {
        String path = directoryJ.getString("storePath");
        Objects.requireNonNull(path);
        return IsDir.trash(path);
    }

    public static ConcurrentMap<String, String> trashIn(Set<String> pathSet) {
        return IsDir.trash(pathSet);
    }

    public static Kv<String, String> trashOut(IDirectory directory) {
        Objects.requireNonNull(directory);
        return IsDir.rollback(directory.getStorePath());
    }

    public static Kv<String, String> trashOut(JsonObject directoryJ) {
        String path = directoryJ.getString("storePath");
        Objects.requireNonNull(path);
        return IsDir.rollback(path);
    }

    public static ConcurrentMap<String, String> trashOut(Set<String> pathSet) {
        return IsDir.rollback(pathSet);
    }

    public static JsonObject dataIn(JsonObject input) {
        return IsDir.input(input);
    }

    public static JsonArray dataIn(JsonArray input) {
        return IsDir.input(input);
    }

    public static Future<JsonObject> dataOut(JsonObject output) {
        return IsDir.output(output);
    }

    public static Future<JsonArray> dataOut(JsonArray output) {
        return IsDir.output(output);
    }

    public static Future<List<IDirectory>> directoryQr(JsonObject condition) {
        return IsDir.query(condition);
    }

    public static Future<List<IDirectory>> directoryQr(IDirectory directory) {
        return IsDir.query(directory);
    }

    public static Future<List<IDirectory>> directoryQr(JsonArray data, String storeField, boolean strict) {
        return IsDir.query(data, storeField, strict);
    }

    public static Future<IDirectory> directoryBranch(String key, String updatedBy) {
        return IsDir.updateBranch(key, updatedBy);
    }

    public static Future<IDirectory> directoryLeaf(JsonArray directoryJ, JsonObject params) {
        return IsDir.updateLeaf(directoryJ, params);
    }

    public static Future<JsonObject> fsRun(JsonObject data, Function<Fs, Future<JsonObject>> fsRunner) {
        return IsFs.run(data, fsRunner);
    }

    public static Future<JsonArray> fsRun(JsonArray data, BiFunction<Fs, JsonArray, Future<JsonArray>> fsRunner) {
        return IsFs.run(data, fsRunner);
    }

    public static Future<ConcurrentMap<Fs, Set<String>>> fsGroup(ConcurrentMap<String, String> fileMap) {
        return IsFs.group(fileMap);
    }

    public static <V> ConcurrentMap<Fs, V> fsGroup(ConcurrentMap<String, V> map, Predicate<V> fnKo) {
        return IsFs.group(map, fnKo);
    }

    public static ConcurrentMap<Fs, Set<String>> fsCombine(ConcurrentMap<Fs, Set<String>> directoryMap, ConcurrentMap<Fs, Set<String>> fileMap) {
        return IsFs.combine(directoryMap, fileMap);
    }

    public static Future<Fs> fsComponent(String directoryId) {
        return IsFs.component(directoryId);
    }

    public static Future<JsonArray> fsDocument(JsonArray data, JsonObject config) {
        return IsFs.document(data, config);
    }

    public static interface LOG {
        public static final String MODULE = "\u039f\u03bb\u03bf\u03ba\u03bb\u03ae\u03c1\u03c9\u03c3\u03b7";
        public static final LogModule Init = Log.modulat((String)"\u039f\u03bb\u03bf\u03ba\u03bb\u03ae\u03c1\u03c9\u03c3\u03b7").program("Init");
        public static final LogModule Web = Log.modulat((String)"\u039f\u03bb\u03bf\u03ba\u03bb\u03ae\u03c1\u03c9\u03c3\u03b7").program("Web");
        public static final LogModule File = Log.modulat((String)"\u039f\u03bb\u03bf\u03ba\u03bb\u03ae\u03c1\u03c9\u03c3\u03b7").program("File/Directory");
        public static final LogModule Path = Log.modulat((String)"\u039f\u03bb\u03bf\u03ba\u03bb\u03ae\u03c1\u03c9\u03c3\u03b7").program("Path");
    }
}

