/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.is.refine;

import cn.vertxup.integration.domain.tables.daos.IDirectoryDao;
import cn.vertxup.integration.domain.tables.pojos.IDirectory;
import io.horizon.atom.common.Kv;
import io.horizon.eon.em.typed.ChangeFlag;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.is.refine.IsFs;
import io.vertx.tp.is.uca.command.FsDefault;
import io.vertx.tp.is.uca.command.FsReadOnly;
import io.vertx.up.fn.Fn;
import io.vertx.up.uca.jooq.UxJooq;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

class IsDir {
    IsDir() {
    }

    static Kv<String, String> trash(String path) {
        Objects.requireNonNull(path);
        String trashTo = Ut.ioPath((String)"/.Trash", (String)path);
        return Kv.create((Object)path, (Object)trashTo);
    }

    static ConcurrentMap<String, String> trash(Set<String> pathSet) {
        ConcurrentHashMap<String, String> trashMap = new ConcurrentHashMap<String, String>();
        pathSet.forEach(path -> {
            String trashTo = Ut.ioPath((String)"/.Trash", (String)path);
            trashMap.put((String)path, trashTo);
        });
        return trashMap;
    }

    static Kv<String, String> rollback(String path) {
        Objects.requireNonNull(path);
        String trashFrom = Ut.ioPath((String)"/.Trash", (String)path);
        return Kv.create((Object)trashFrom, (Object)path);
    }

    static ConcurrentMap<String, String> rollback(Set<String> pathSet) {
        ConcurrentHashMap<String, String> trashMap = new ConcurrentHashMap<String, String>();
        pathSet.forEach(path -> {
            String trashFrom = Ut.ioPath((String)"/.Trash", (String)path);
            trashMap.put(trashFrom, (String)path);
        });
        return trashMap;
    }

    static JsonObject input(JsonObject directoryJ) {
        directoryJ = directoryJ.copy();
        Ut.valueToString((JsonObject)directoryJ, (String[])new String[]{"metadata", "visitGroup", "visitRole", "visitMode"});
        return directoryJ;
    }

    static JsonArray input(JsonArray directoryJ) {
        directoryJ = directoryJ.copy();
        Ut.valueToString((JsonArray)directoryJ, (String[])new String[]{"metadata", "visitGroup", "visitRole", "visitMode"});
        return directoryJ;
    }

    static Future<JsonObject> output(JsonObject response) {
        return ((Future)Fn.ofJObject((String[])new String[]{"metadata", "visitGroup", "visitRole", "visitMode"}).apply(response)).compose(directory -> {
            directory.put("directory", (Object)Boolean.TRUE);
            Ut.valueCopy((JsonObject)directory, (String)"key", (String)"directoryId");
            return Ux.future((Object)directory);
        });
    }

    static Future<JsonArray> output(JsonArray response) {
        return ((Future)Fn.ofJArray((String[])new String[]{"metadata", "visitGroup", "visitRole", "visitMode"}).apply(response)).compose(directory -> {
            Ut.itJArray((JsonArray)directory).forEach(each -> {
                each.put("directory", (Object)Boolean.TRUE);
                Ut.valueCopy((JsonObject)each, (String)"key", (String)"directoryId");
            });
            return Ux.future((Object)directory);
        });
    }

    static Future<List<IDirectory>> query(JsonObject condition) {
        return Ux.Jooq.on(IDirectoryDao.class).fetchAsync(condition);
    }

    static Future<List<IDirectory>> query(IDirectory directory) {
        if (Objects.isNull(directory)) {
            return Ux.futureL();
        }
        JsonObject condition = Ux.whereAnd();
        condition.put("sigma", (Object)directory.getSigma());
        condition.put("storePath,s", (Object)directory.getStorePath());
        return Ux.Jooq.on(IDirectoryDao.class).fetchAsync(condition);
    }

    static Future<List<IDirectory>> query(JsonArray data, String storeField, boolean strict) {
        String sigma = Ut.valueString((JsonArray)data, (String)"sigma");
        JsonArray names = Ut.valueJArray((JsonArray)data, (String)storeField);
        JsonObject condition = Ux.whereAnd();
        condition.put("sigma", (Object)sigma);
        condition.put("active", (Object)Boolean.TRUE);
        if (strict) {
            condition.put("storePath,i", (Object)names);
        } else {
            String found = names.stream().map(item -> (String)item).reduce((left, right) -> {
                if (left.length() < right.length()) {
                    return left;
                }
                return right;
            }).orElse(null);
            if (Ut.isNotNil((String)found)) {
                condition.put("storePath,s", (Object)found);
            }
        }
        return Ux.Jooq.on(IDirectoryDao.class).fetchAsync(condition);
    }

    static ConcurrentMap<ChangeFlag, JsonArray> diff(JsonArray input, List<IDirectory> directories) {
        ConcurrentMap directoryMap = Ut.elementMap(directories, IDirectory::getStorePath);
        final JsonArray queueAD = new JsonArray();
        final JsonArray queueUP = new JsonArray();
        Ut.itJArray((JsonArray)input).forEach(json -> {
            String path = json.getString("storePath");
            if (directoryMap.containsKey(path)) {
                JsonObject normalized = Ux.toJson((Object)directoryMap.getOrDefault(path, null));
                queueUP.add((Object)normalized);
                directoryMap.remove(path);
            } else {
                queueAD.add(json);
            }
        });
        final JsonArray queueDft = new JsonArray();
        if (!directoryMap.isEmpty()) {
            directoryMap.values().forEach(item -> {
                JsonObject record = Ux.toJson((Object)item);
                record.put("directoryId", (Object)item.getKey());
                queueDft.add((Object)record);
            });
        }
        return new ConcurrentHashMap<ChangeFlag, JsonArray>(){
            {
                this.put(ChangeFlag.ADD, queueAD);
                this.put(ChangeFlag.UPDATE, queueUP);
                this.put(ChangeFlag.NONE, queueDft);
            }
        };
    }

    static Future<IDirectory> updateBranch(String key, String updatedBy) {
        UxJooq jq = Ux.Jooq.on(IDirectoryDao.class);
        return jq.fetchByIdAsync((Object)key).compose(queried -> {
            if (Objects.isNull(queried)) {
                return Ux.future();
            }
            queried.setUpdatedAt(LocalDateTime.now());
            queried.setUpdatedBy(updatedBy);
            return jq.updateAsync(queried).compose(updated -> IsDir.updateBranch(updated.getParentId(), updatedBy)).compose(updated -> Ux.future((Object)queried));
        });
    }

    static Future<IDirectory> updateLeaf(JsonArray directoryA, JsonObject params) {
        List directories = Ux.fromJson((JsonArray)directoryA, IDirectory.class);
        List storePath = Ut.toList((JsonArray)params.getJsonArray("storePath"));
        if (directories.isEmpty()) {
            return Ux.future();
        }
        ConcurrentMap dirMap = Ut.elementMap((List)directories, IDirectory::getStorePath);
        IDirectory root = null;
        int idxStart = 1;
        for (int idx = 0; idx < storePath.size(); ++idx) {
            String keyRoot = (String)storePath.get(idx);
            root = dirMap.getOrDefault(keyRoot, null);
            if (!Objects.nonNull(root)) continue;
            idxStart = idx + 1;
            break;
        }
        Objects.requireNonNull(root);
        Future future = Ux.future(root);
        for (int idx = idxStart; idx < storePath.size(); ++idx) {
            String keyPath = (String)storePath.get(idx);
            IDirectory dirNow = dirMap.getOrDefault(keyPath, null);
            JsonObject inputParams = params.copy();
            inputParams.put("storePath", (Object)keyPath);
            future = Objects.isNull(dirNow) ? IsDir.createChild((Future<IDirectory>)future, dirNow, inputParams).compose(created -> {
                dirMap.put(created.getStorePath(), created);
                return Ux.future((Object)created);
            }) : IsDir.createChild((Future<IDirectory>)future, dirNow, inputParams);
        }
        return future.compose(finished -> {
            String path = (String)storePath.get(storePath.size() - 1);
            return Ux.future((Object)dirMap.getOrDefault(path, null));
        });
    }

    private static Future<IDirectory> createChild(Future<IDirectory> futureParent, IDirectory child, JsonObject params) {
        UxJooq jq = Ux.Jooq.on(IDirectoryDao.class);
        String updatedBy = params.getString("updatedBy");
        if (Objects.isNull(child)) {
            return futureParent.compose(parent -> {
                String componentCls;
                JsonObject parentJ = Ux.toJson((Object)parent);
                IDirectory created = (IDirectory)Ux.fromJson((JsonObject)parentJ, IDirectory.class);
                created.setKey(UUID.randomUUID().toString());
                created.setParentId(parent.getKey());
                created.setCreatedAt(LocalDateTime.now());
                created.setCreatedBy(updatedBy);
                created.setUpdatedAt(LocalDateTime.now());
                created.setUpdatedBy(updatedBy);
                JsonArray visitMode = Ut.toJArray((String)parent.getVisitMode());
                if (!visitMode.contains((Object)"w")) {
                    visitMode.add((Object)"w");
                    created.setVisitMode(visitMode.encode());
                }
                if (visitMode.contains((Object)"w") && (componentCls = parent.getRunComponent()).equals(FsReadOnly.class.getName())) {
                    created.setRunComponent(FsDefault.class.getName());
                }
                created.setMetadata(new JsonObject().encode());
                String storePath = params.getString("storePath");
                String name = storePath.replace(parent.getStorePath(), "");
                if (name.startsWith("/")) {
                    name = name.substring(1);
                }
                created.setStorePath(storePath);
                created.setName(name);
                created.setCode(Ut.encryptMD5((String)storePath));
                return jq.insertAsync((Object)created).compose(inserted -> {
                    JsonObject serialized = Ut.toJObject((Object)inserted);
                    return IsFs.run(serialized, fs -> fs.mkdir(serialized)).compose(nil -> Ux.future((Object)inserted));
                });
            });
        }
        child.setUpdatedBy(updatedBy);
        child.setUpdatedAt(LocalDateTime.now());
        return jq.updateAsync((Object)child);
    }
}

