/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.is.refine;

import cn.vertxup.integration.domain.tables.daos.IDirectoryDao;
import cn.vertxup.integration.domain.tables.pojos.IDirectory;
import io.horizon.eon.em.typed.ChangeFlag;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.is.refine.IsDir;
import io.vertx.tp.is.uca.command.Fs;
import io.vertx.up.fn.Fn;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;

class IsFs {
    private static final String FS_DEFAULT = "io.vertx.tp.is.uca.command.FsDefault";

    IsFs() {
    }

    static Future<JsonObject> run(JsonObject data, Function<Fs, Future<JsonObject>> fsRunner) {
        String componentCls = data.getString("runComponent");
        if (Ut.isNil((String)componentCls)) {
            return Ux.future((Object)data);
        }
        Class clazz = Ut.clazz((String)componentCls, null);
        if (Objects.nonNull(clazz) && Ut.isImplement((Class)clazz, Fs.class)) {
            Fs fs = (Fs)Ut.singleton((Class)clazz, (Object[])new Object[0]);
            return fsRunner.apply(fs);
        }
        return Ux.future((Object)data);
    }

    static Future<JsonArray> run(JsonArray data, BiFunction<Fs, JsonArray, Future<JsonArray>> fsRunner) {
        ConcurrentMap<Fs, JsonArray> componentMap = IsFs.fsGroup(data);
        ArrayList futures = new ArrayList();
        componentMap.forEach((fs, dataEach) -> futures.add((Future)fsRunner.apply((Fs)fs, dataEach.copy())));
        return Fn.compressA(futures);
    }

    static Future<ConcurrentMap<Fs, Set<String>>> group(ConcurrentMap<String, String> fileMap) {
        ConcurrentMap directoryMap = Ut.inverseSet(fileMap);
        JsonObject criteria = new JsonObject();
        criteria.put("key,i", (Object)Ut.toJArray(directoryMap.keySet()));
        return IsDir.query(criteria).compose(directories -> {
            ConcurrentMap grouped = Ut.elementGroup((Collection)directories, IDirectory::getRunComponent, IDirectory::getKey);
            ConcurrentMap<Fs, List> fsGroup = IsFs.group(grouped, List::isEmpty);
            ConcurrentHashMap resultMap = new ConcurrentHashMap();
            fsGroup.forEach((fs, keyList) -> {
                HashSet storeSet = new HashSet();
                keyList.forEach(key -> {
                    Set subSet = (Set)directoryMap.get(key);
                    if (Objects.nonNull(subSet) && !subSet.isEmpty()) {
                        storeSet.addAll(subSet);
                    }
                });
                if (!storeSet.isEmpty()) {
                    resultMap.put(fs, storeSet);
                }
            });
            return Ux.future(resultMap);
        });
    }

    private static ConcurrentMap<Fs, JsonArray> fsGroup(JsonArray data) {
        JsonArray queueDft = new JsonArray();
        JsonArray queueIntegrated = new JsonArray();
        Ut.itJArray((JsonArray)data).forEach(json -> {
            if (json.containsKey("runComponent")) {
                queueIntegrated.add(json);
            } else {
                queueDft.add(json);
            }
        });
        ConcurrentMap groupIntegrated = Ut.elementGroup((JsonArray)queueIntegrated, (String)"runComponent");
        ConcurrentMap<Fs, JsonArray> groupComponent = IsFs.group(groupIntegrated, JsonArray::isEmpty);
        if (!queueDft.isEmpty()) {
            Fs fs = (Fs)Ut.singleton((String)FS_DEFAULT, (Object[])new Object[0]);
            JsonArray dataRef = groupComponent.getOrDefault(fs, new JsonArray());
            dataRef.addAll(queueDft);
            groupComponent.put(fs, dataRef);
        }
        return groupComponent;
    }

    static Future<Fs> component(String directoryId) {
        Fs fsDft = (Fs)Ut.singleton((String)FS_DEFAULT, (Object[])new Object[0]);
        if (Objects.isNull(directoryId)) {
            return Ux.future((Object)fsDft);
        }
        return Ux.Jooq.on(IDirectoryDao.class).fetchByIdAsync((Object)directoryId).compose(directory -> {
            if (Objects.isNull(directory)) {
                return Ux.future((Object)fsDft);
            }
            String componentCls = directory.getRunComponent();
            if (Ut.isNil((String)componentCls)) {
                return Ux.future((Object)fsDft);
            }
            Class clazz = Ut.clazz((String)componentCls, null);
            if (Objects.nonNull(clazz) && Ut.isImplement((Class)clazz, Fs.class)) {
                return Ux.future((Object)((Fs)Ut.singleton((Class)clazz, (Object[])new Object[0])));
            }
            return Ux.future((Object)fsDft);
        });
    }

    static ConcurrentMap<Fs, Set<String>> combine(ConcurrentMap<Fs, Set<String>> directoryMap, ConcurrentMap<Fs, Set<String>> fileMap) {
        ConcurrentHashMap<Fs, Set<String>> combine = new ConcurrentHashMap<Fs, Set<String>>(directoryMap);
        fileMap.forEach((fs, set) -> {
            Set valueSet = combine.containsKey(fs) ? (Set)combine.getOrDefault(fs, new HashSet()) : new HashSet();
            valueSet.addAll(set);
            combine.put((Fs)fs, valueSet);
        });
        return combine;
    }

    static <V> ConcurrentMap<Fs, V> group(ConcurrentMap<String, V> map, Predicate<V> fnKo) {
        ConcurrentHashMap groupComponent = new ConcurrentHashMap();
        map.forEach((componentCls, value) -> {
            Class clazz;
            if (!fnKo.test(value) && Objects.nonNull(clazz = Ut.clazz((String)componentCls, null)) && Ut.isImplement((Class)clazz, Fs.class)) {
                Fs fs = (Fs)Ut.singleton((Class)clazz, (Object[])new Object[0]);
                groupComponent.put(fs, value);
            }
        });
        return groupComponent;
    }

    static Future<JsonArray> document(JsonArray data, JsonObject config) {
        return IsDir.query(data, "storePath", false).compose(queried -> {
            ConcurrentMap<ChangeFlag, JsonArray> compared = IsDir.diff(data, queried);
            ArrayList<Object> futures = new ArrayList<Object>();
            futures.add(IsFs.mkdir(compared.getOrDefault(ChangeFlag.ADD, new JsonArray()), config));
            futures.add(IsFs.mkdir(compared.getOrDefault(ChangeFlag.UPDATE, new JsonArray()), queried));
            futures.add(Ux.future((Object)compared.getOrDefault(ChangeFlag.NONE, new JsonArray())));
            return Fn.compressA(futures);
        });
    }

    private static Future<JsonArray> mkdir(JsonArray queueUp, List<IDirectory> storeList) {
        if (Ut.isNil((JsonArray)queueUp)) {
            return Ux.futureA();
        }
        ConcurrentMap storeMap = Ut.elementMap(storeList, IDirectory::getStorePath);
        Ut.itJArray((JsonArray)queueUp).forEach(json -> {
            IDirectory store;
            String storePath = json.getString("storePath");
            if (Ut.isNotNil((String)storePath) && Objects.nonNull(store = (IDirectory)storeMap.get(storePath))) {
                json.put("directoryId", (Object)store.getKey());
                json.put("visitMode", (Object)Ut.toJArray((String)store.getVisitMode()));
            }
        });
        return Ux.future((Object)queueUp);
    }

    private static Future<JsonArray> mkdir(JsonArray queueAd, JsonObject config) {
        if (Ut.isNil((JsonArray)queueAd)) {
            return Ux.futureA();
        }
        if (config.containsKey("runComponent")) {
            Ut.itJArray((JsonArray)queueAd).forEach(json -> json.put("runComponent", (Object)config.getString("runComponent")));
        }
        return IsFs.run(queueAd, (Fs fs, JsonArray dataGroup) -> fs.synchronize((JsonArray)dataGroup, config)).compose(inserted -> {
            Ut.itJArray((JsonArray)inserted).forEach(json -> Ut.valueCopy((JsonObject)json, (String)"key", (String)"directoryId"));
            return Ux.future((Object)inserted);
        });
    }
}

