/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.is.uca.command;

import cn.vertxup.integration.domain.tables.pojos.IDirectory;
import io.horizon.atom.common.Kv;
import io.horizon.specification.uca.HFS;
import io.vertx.core.Future;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.is.atom.IsConfig;
import io.vertx.tp.is.cv.em.TypeDirectory;
import io.vertx.tp.is.init.IsPin;
import io.vertx.tp.is.refine.Is;
import io.vertx.tp.is.uca.command.AbstractFs;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;

public class FsDefault
extends AbstractFs {
    @Override
    public IDirectory initTree(JsonObject directoryJ) {
        IDirectory directory = (IDirectory)Ux.fromJson((JsonObject)directoryJ, IDirectory.class);
        directory.setCode(Ut.encryptMD5((String)directory.getStorePath()));
        return directory.setType(TypeDirectory.STORE.name());
    }

    @Override
    public void initTrash() {
        String root = this.configRoot();
        String rootTrash = Ut.ioPath((String)root, (String)"/.Trash");
        HFS.common().mkdir(rootTrash);
    }

    @Override
    public Future<JsonArray> mkdir(JsonArray data) {
        this.runRoot(data, arg_0 -> ((HFS)HFS.common()).mkdir(arg_0));
        return Ux.future((Object)data);
    }

    @Override
    public Future<JsonObject> mkdir(JsonObject data) {
        String root = this.configRoot();
        String path = data.getString("storePath");
        HFS.common().mkdir(Ut.ioPath((String)root, (String)path));
        return Ux.future((Object)data);
    }

    @Override
    public Future<JsonArray> synchronize(JsonArray data, JsonObject config) {
        return this.initialize(data, config).compose(this::mkdir);
    }

    @Override
    public Future<JsonArray> rm(JsonArray data) {
        this.runRoot(data, arg_0 -> ((HFS)HFS.common()).rm(arg_0));
        return Ux.future((Object)data);
    }

    @Override
    public Future<Boolean> rm(Collection<String> storeSet) {
        String root = this.configRoot();
        storeSet.forEach(path -> HFS.common().rm(Ut.ioPath((String)root, (String)path)));
        return Ux.futureT();
    }

    @Override
    public Future<JsonObject> rm(JsonObject data) {
        String root = this.configRoot();
        String path = data.getString("storePath");
        HFS.common().rm(Ut.ioPath((String)root, (String)path));
        return Ux.future((Object)data);
    }

    @Override
    public Future<Boolean> rename(ConcurrentMap<String, String> transfer) {
        if (!transfer.isEmpty()) {
            transfer.forEach(this::renameWith);
        }
        return Ux.futureT();
    }

    @Override
    public Future<Boolean> rename(String from, String to) {
        this.renameWith(from, to);
        return Ux.futureT();
    }

    @Override
    public Future<Boolean> rename(Kv<String, String> kv) {
        return this.rename((String)kv.key(), (String)kv.value());
    }

    @Override
    public Future<Boolean> upload(ConcurrentMap<String, String> transfer) {
        if (!transfer.isEmpty()) {
            String root = this.configRoot();
            transfer.forEach((from, to) -> {
                String toPath = Ut.ioPath((String)root, (String)to);
                HFS.common().rename(from, toPath);
            });
        }
        return Ux.futureT();
    }

    @Override
    public Future<Buffer> download(String storePath) {
        String root = this.configRoot();
        String toPath = Ut.ioPath((String)root, (String)storePath);
        Buffer buffer = Buffer.buffer();
        if (Ut.ioExist((String)toPath)) {
            buffer = Ut.ioBuffer((String)toPath);
        }
        return Ux.future((Object)buffer);
    }

    @Override
    public Future<Buffer> download(Set<String> storeSet) {
        String root = this.configRoot();
        HashSet files = new HashSet();
        storeSet.forEach(file -> files.add(Ut.ioPath((String)root, (String)file)));
        return Ux.future((Object)Ut.toZip(files));
    }

    private void renameWith(String from, String to) {
        String root = this.configRoot();
        String fromPath = Ut.ioPath((String)root, (String)from);
        String toPath = Ut.ioPath((String)root, (String)to);
        HFS.common().rename(fromPath, toPath);
    }

    private String configRoot() {
        IsConfig config = IsPin.getConfig();
        String rootPath = config.getStoreRoot();
        if (Ut.isNil((String)rootPath)) {
            Is.LOG.Path.warn(this.getClass(), "The `storeRoot` of integration service is null", new Object[0]);
        }
        return rootPath;
    }

    private void runRoot(JsonArray data, Consumer<Set<String>> fsRoot) {
        String root = this.configRoot();
        HashSet dirSet = new HashSet();
        Ut.itJArray((JsonArray)data).forEach(json -> {
            String path = json.getString("storePath");
            dirSet.add(Ut.ioPath((String)root, (String)path));
        });
        fsRoot.accept(dirSet);
    }
}

