/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.jet.service;

import cn.vertxup.cache.AmbientStub;
import cn.vertxup.jet.domain.tables.daos.IJobDao;
import cn.vertxup.jet.domain.tables.daos.IServiceDao;
import cn.vertxup.jet.domain.tables.pojos.IJob;
import cn.vertxup.jet.domain.tables.pojos.IService;
import cn.vertxup.jet.service.JobKit;
import cn.vertxup.jet.service.JobStub;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.jet.refine.Jt;
import io.vertx.up.atom.query.Inquiry;
import io.vertx.up.log.Annal;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class JobService
implements JobStub {
    private static final Annal LOGGER = Annal.get(JobService.class);
    @Inject
    private transient AmbientStub ambient;

    @Override
    public Future<JsonObject> searchJobs(String sigma, JsonObject body, boolean grouped) {
        Inquiry inquiry = Inquiry.create((JsonObject)body);
        inquiry.getCriteria().add("sigma", (Object)sigma);
        JsonObject condition = inquiry.toJson();
        LOGGER.info("Job condition: {0}", new Object[]{condition});
        return Ux.Jooq.on(IJobDao.class).searchAsync(condition).compose(jobs -> {
            JsonArray array = Ut.sureJArray((JsonArray)jobs.getJsonArray("list"));
            List jobList = Ux.fromJson((JsonArray)array, IJob.class);
            Set<String> codes = jobList.stream().filter(Objects::nonNull).map(Jt::jobCode).collect(Collectors.toSet());
            Jt.infoWeb(LOGGER, "Job fetched from database: {0}, input sigma: {1}", codes.size(), sigma);
            return JobKit.fetchMission(codes).compose(normalized -> {
                jobs.put("list", normalized);
                if (grouped) {
                    JsonObject criteria = inquiry.getCriteria().toJson();
                    return Ux.Jooq.on(IJobDao.class).countByAsync(criteria, "group").compose(aggregation -> {
                        JsonObject aggregationJson = new JsonObject();
                        aggregation.forEach((arg_0, arg_1) -> ((JsonObject)aggregationJson).put(arg_0, arg_1));
                        jobs.put("aggregation", aggregationJson);
                        return Ux.future((Object)jobs);
                    });
                }
                return Ux.future((Object)jobs);
            });
        });
    }

    @Override
    public Future<JsonObject> fetchByKey(String key) {
        return Ux.Jooq.on(IJobDao.class).findByIdAsync((Object)key).compose(Ut.ifNil(JsonObject::new, job -> JobKit.fetchMission(Jt.jobCode(job))));
    }

    @Override
    public Future<JsonObject> update(String key, JsonObject data) {
        JsonObject serviceJson = data.getJsonObject("service");
        if (Ut.isNil((JsonObject)serviceJson)) {
            serviceJson = new JsonObject();
        } else {
            serviceJson = serviceJson.copy();
            data.remove("service");
        }
        IJob job = (IJob)Ux.fromJson((JsonObject)data, IJob.class);
        IService service = JobKit.fromJson(serviceJson);
        return Ux.Jooq.on(IJobDao.class).upsertAsync(job.getKey(), (Object)job).compose(updatedJob -> Ux.Jooq.on(IServiceDao.class).upsertAsync(service.getKey(), (Object)service).compose(updatedSev -> this.ambient.updateJob((IJob)updatedJob, (IService)updatedSev)));
    }
}

