/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.jet.atom;

import cn.vertxup.jet.domain.tables.pojos.IApi;
import cn.vertxup.jet.domain.tables.pojos.IService;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.jet.atom.JtCommercial;
import io.vertx.tp.jet.atom.JtWorker;
import io.vertx.tp.jet.cv.em.ParamMode;
import io.vertx.tp.jet.refine.Jt;
import io.vertx.up.commune.Api;
import io.vertx.up.util.Ut;
import java.util.Objects;
import java.util.Set;
import javax.ws.rs.core.MediaType;

public class JtUri
extends JtCommercial
implements Api {
    private transient JtWorker worker;
    private transient IApi api;
    private transient String key;
    private transient Integer order;

    public JtUri() {
    }

    public JtUri(IApi api, IService service) {
        super(service);
        this.api = api;
        this.key = api.getKey();
        Jt.initApi(api);
        this.worker = Jt.toWorker(api);
    }

    public JtUri bind(Integer order) {
        this.order = order;
        return this;
    }

    public Integer order() {
        return Objects.nonNull(this.order) ? this.order : 6000000;
    }

    public Set<String> produces() {
        return Jt.toMimeString(this.api::getProduces);
    }

    public Set<MediaType> producesMime() {
        return Jt.toMime(this.api::getProduces);
    }

    public Set<String> consumes() {
        return Jt.toMimeString(this.api::getConsumes);
    }

    public ParamMode paramMode() {
        return (ParamMode)Ut.toEnum(this.api::getParamMode, ParamMode.class, (Enum)ParamMode.BODY);
    }

    public Set<String> paramRequired() {
        return Jt.toSet(this.api::getParamRequired);
    }

    public Set<String> paramContained() {
        return Jt.toSet(this.api::getParamContained);
    }

    @Override
    public String key() {
        return this.key;
    }

    public JtWorker worker() {
        return this.worker;
    }

    public IApi api() {
        return this.api;
    }

    public String path() {
        return Jt.toPath(this.getApp()::getRoute, this.api::getUri, this.api.getSecure(), this.getConfig());
    }

    public HttpMethod method() {
        return (HttpMethod)Ut.toEnum(this.api::getMethod, HttpMethod.class, (Enum)HttpMethod.GET);
    }

    public JsonObject options() {
        return Jt.toOptions(this.getApp(), this.api, this.service());
    }

    @Override
    public JsonObject toJson() {
        JsonObject data = super.toJson();
        data.put("order", this.order);
        data.put("api", (JsonObject)Ut.serializeJson((Object)this.api));
        return data;
    }

    @Override
    public void fromJson(JsonObject data) {
        super.fromJson(data);
        this.key = data.getString("key");
        this.order = data.getInteger("order");
        this.api = (IApi)Ut.deserialize((JsonObject)data.getJsonObject("api"), IApi.class);
        this.worker = Jt.toWorker(this.api);
    }
}

