/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.jet.refine;

import cn.vertxup.jet.domain.tables.pojos.IApi;
import cn.vertxup.jet.domain.tables.pojos.IJob;
import cn.vertxup.jet.domain.tables.pojos.IService;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.jet.atom.JtApp;
import io.vertx.tp.jet.cv.JtConstant;
import io.vertx.tp.jet.cv.em.WorkerType;
import io.vertx.tp.jet.refine.JtBusiness;
import io.vertx.tp.optic.environment.Ambient;
import io.vertx.up.commune.config.Database;
import io.vertx.up.commune.config.Integration;
import io.vertx.up.commune.exchange.DictConfig;
import io.vertx.up.commune.rule.RuleUnique;
import io.vertx.up.fn.Fn;
import io.vertx.up.util.Ut;
import java.util.Objects;
import java.util.function.Supplier;

class JtDataObject {
    JtDataObject() {
    }

    static Integration toIntegration(IService service) {
        if (Objects.isNull(service)) {
            return new Integration();
        }
        JsonObject data = Ut.toJObject((String)service.getConfigIntegration());
        Integration integration = new Integration();
        integration.fromJson(data);
        DictConfig dict = JtBusiness.toDict(service);
        if (Objects.nonNull(dict) && !dict.getEpsilon().isEmpty()) {
            integration.setEpsilon(dict.getEpsilon());
        }
        return integration;
    }

    static RuleUnique toRule(IService service) {
        if (Objects.isNull(service)) {
            return null;
        }
        String rules = service.getRuleUnique();
        if (Ut.isNil((String)rules)) {
            return null;
        }
        return (RuleUnique)Ut.deserialize((String)rules, RuleUnique.class);
    }

    static Database toDatabase(IService service) {
        String database = service.getConfigDatabase();
        if (Ut.isNil((String)database)) {
            JtApp app = Ambient.getApp(service.getSigma());
            if (Objects.nonNull(app)) {
                return app.getSource();
            }
            return null;
        }
        return null;
    }

    static Database toDatabase(Supplier<String> supplier, Database defaultDatabase) {
        JsonObject databaseJson = Ut.toJObject((String)supplier.get());
        if (Ut.isNil((JsonObject)databaseJson)) {
            return defaultDatabase;
        }
        Database database = new Database();
        database.fromJson(databaseJson);
        return database;
    }

    static JsonObject toOptions(JtApp app, IApi api, IService service) {
        JsonObject options = JtDataObject.toOptions(app, service);
        return options;
    }

    static JsonObject toOptions(JtApp app, IJob job, IService service) {
        JsonObject options = JtDataObject.toOptions(app, service);
        return options;
    }

    static JsonObject toOptions(JtApp app, IService service) {
        JsonObject options = Ut.toJObject((String)service.getServiceConfig());
        options.put("name", app.getName());
        options.put("sigma", app.getSigma());
        options.put("identifier", service.getIdentifier());
        return options;
    }

    static void initApi(IApi api) {
        Fn.safeSemi((boolean)Ut.isNil((String)api.getWorkerClass()), () -> api.setWorkerClass(JtConstant.COMPONENT_DEFAULT_WORKER.getName()));
        Fn.safeSemi((boolean)Ut.isNil((String)api.getWorkerAddress()), () -> api.setWorkerAddress("\u03a0\u03af\u03b4\u03b1\u03ba\u03b1\u03c2 \u03b4\u03c1\u03bf\u03bc\u03bf\u03bb\u03bf\u03b3\u03b7\u03c4\u03ae://EVENT-JET/ZERO/UNIFORM"));
        Fn.safeSemi((boolean)Ut.isNil((String)api.getWorkerConsumer()), () -> api.setWorkerConsumer(JtConstant.COMPONENT_DEFAULT_CONSUMER.getName()));
        Fn.safeSemi((boolean)Ut.isNil((String)api.getWorkerType()), () -> api.setWorkerType(WorkerType.STD.name()));
    }
}

