/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.jet.uca.micro;

import io.vertx.core.Future;
import io.vertx.tp.error._424ChannelConflictException;
import io.vertx.tp.error._424ChannelDefineException;
import io.vertx.tp.error._424ChannelDefinitionException;
import io.vertx.tp.jet.monitor.JtMonitor;
import io.vertx.tp.jet.uca.tunnel.ActorChannel;
import io.vertx.tp.jet.uca.tunnel.AdaptorChannel;
import io.vertx.tp.jet.uca.tunnel.ConnectorChannel;
import io.vertx.tp.jet.uca.tunnel.DirectorChannel;
import io.vertx.tp.optic.jet.JtChannel;
import io.vertx.up.atom.Refer;
import io.vertx.up.atom.worker.Mission;
import io.vertx.up.commune.Commercial;
import io.vertx.up.commune.Envelop;
import io.vertx.up.eon.em.ChannelType;
import io.vertx.up.fn.Fn;
import io.vertx.up.util.Ut;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;

class JtPandora {
    private static final ConcurrentMap<ChannelType, Class<?>> EXPECTED_MAP = new ConcurrentHashMap<ChannelType, Class<?>>(){
        {
            this.put(ChannelType.ADAPTOR, AdaptorChannel.class);
            this.put(ChannelType.CONNECTOR, ConnectorChannel.class);
            this.put(ChannelType.DIRECTOR, DirectorChannel.class);
            this.put(ChannelType.ACTOR, ActorChannel.class);
        }
    };

    JtPandora() {
    }

    static Future<Envelop> async(Envelop envelop, Commercial commercial, Mission mission, Refer refer, JtMonitor monitor) {
        ConcurrentMap dict;
        Class<?> channelClass = JtPandora.getChannel(commercial);
        JtChannel channel = (JtChannel)Ut.instance(channelClass, (Object[])new Object[0]);
        Ut.contract((Object)channel, Commercial.class, (Object)commercial);
        Ut.contract((Object)channel, Mission.class, (Object)mission);
        if (Objects.nonNull(refer) && Objects.nonNull(dict = (ConcurrentMap)refer.get())) {
            Ut.contract((Object)channel, ConcurrentMap.class, (Object)dict);
        }
        monitor.channelHit(channelClass);
        return channel.transferAsync(envelop);
    }

    static Future<Envelop> async(Envelop envelop, Commercial commercial, JtMonitor monitor) {
        return JtPandora.async(envelop, commercial, null, null, monitor);
    }

    private static Class<?> getChannel(Commercial commercial) {
        Class channelClass = commercial.channelComponent();
        ChannelType channelType = commercial.channelType();
        if (ChannelType.DEFINE == channelType) {
            Fn.out((!Ut.isImplement((Class)channelClass, JtChannel.class) ? 1 : 0) != 0, _424ChannelDefineException.class, (Object[])new Object[]{JtPandora.class, channelClass.getName()});
        } else {
            Fn.out((!EXPECTED_MAP.containsValue(channelClass) ? 1 : 0) != 0, _424ChannelDefinitionException.class, (Object[])new Object[]{JtPandora.class, Ut.fromJoin(EXPECTED_MAP.values().stream().map(Class::getSimpleName).collect(Collectors.toSet())), channelClass});
            Class expectedClass = (Class)EXPECTED_MAP.get(channelType);
            Fn.out((expectedClass != channelClass ? 1 : 0) != 0, _424ChannelConflictException.class, (Object[])new Object[]{JtPandora.class, channelClass.getName(), channelType});
        }
        return channelClass;
    }
}

