/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.optic.environment;

import cn.vertxup.jet.domain.tables.daos.IApiDao;
import cn.vertxup.jet.domain.tables.daos.IJobDao;
import cn.vertxup.jet.domain.tables.daos.IServiceDao;
import cn.vertxup.jet.domain.tables.pojos.IApi;
import cn.vertxup.jet.domain.tables.pojos.IJob;
import cn.vertxup.jet.domain.tables.pojos.IService;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.tp.jet.atom.JtApp;
import io.vertx.tp.jet.atom.JtJob;
import io.vertx.tp.jet.atom.JtUri;
import io.vertx.tp.plugin.database.DataPool;
import io.vertx.up.commune.config.Database;
import io.vertx.up.fn.Fn;
import io.vertx.up.util.Ut;
import java.sql.Connection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jooq.Configuration;

public class AmbientEnvironment {
    private final transient ConcurrentMap<String, JtJob> jobs = new ConcurrentHashMap<String, JtJob>();
    private final transient ConcurrentMap<String, JtUri> uris = new ConcurrentHashMap<String, JtUri>();
    private final transient JtApp app;
    private final transient DataPool pool;
    private final transient IApiDao apiDao;
    private final transient IJobDao jobDao;
    private final ConcurrentMap<String, IService> serviceMap = new ConcurrentHashMap<String, IService>();

    AmbientEnvironment(JtApp app) {
        this.app = app;
        this.pool = DataPool.create((Database)app.getSource());
        DataPool currentPool = DataPool.create((Database)Database.getCurrent());
        Configuration configuration = currentPool.getExecutor().configuration();
        this.apiDao = new IApiDao(configuration);
        IServiceDao serviceDao = new IServiceDao(configuration);
        this.jobDao = new IJobDao(configuration);
        List<IService> serviceList = serviceDao.fetchBySigma(this.app.getSigma());
        this.serviceMap.putAll(Ut.elementZip(serviceList, IService::getKey, service -> service));
    }

    @Fluent
    public AmbientEnvironment init() {
        this.initUris();
        this.initJobs();
        return this;
    }

    private void initJobs() {
        List<IJob> jobList = this.jobDao.fetchBySigma(this.app.getSigma());
        if (this.jobs.isEmpty()) {
            ConcurrentMap jobMap = Ut.elementZip(jobList, IJob::getServiceId, job -> job);
            jobMap.keySet().stream().map(serviceId -> (JtJob)new JtJob((IJob)jobMap.get(serviceId), (IService)this.serviceMap.get(serviceId)).bind(this.app.getAppId())).forEach(entry -> this.jobs.put(entry.key(), (JtJob)entry));
        }
    }

    private void initUris() {
        List<IApi> apiList = this.apiDao.fetchBySigma(this.app.getSigma());
        if (this.uris.isEmpty()) {
            ConcurrentMap apiMap = Ut.elementZip(apiList, IApi::getServiceId, api -> api);
            apiMap.keySet().stream().map(serviceId -> (JtUri)new JtUri((IApi)apiMap.get(serviceId), (IService)this.serviceMap.get(serviceId)).bind(this.app.getAppId())).forEach(entry -> this.uris.put(entry.key(), (JtUri)entry));
        }
    }

    public Connection getConnection() {
        return (Connection)Fn.getJvm(() -> this.pool.getDataSource().getConnection(), (Object[])new Object[]{this.pool});
    }

    public DataPool getPool() {
        return this.pool;
    }

    public Set<JtUri> routes() {
        return new HashSet<JtUri>(this.uris.values());
    }

    public Set<JtJob> jobs() {
        return new HashSet<JtJob>(this.jobs.values());
    }

    public void flushJob(JtJob job) {
        IService service = job.service();
        this.serviceMap.put(service.getKey(), service);
        this.jobs.put(service.getKey(), job);
    }

    public void flushUri(JtUri uri) {
        IService service = uri.service();
        this.serviceMap.put(service.getKey(), service);
        this.uris.put(service.getKey(), uri);
    }
}

