/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.ke.refine;

import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.ke.refine.KeLog;
import io.vertx.tp.optic.fantom.Fabric;
import io.vertx.up.atom.record.Atomy;
import io.vertx.up.log.Annal;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;

class KeCompare {
    KeCompare() {
    }

    static Function<JsonObject, Future<JsonObject>> combineAsync(String field) {
        return json -> {
            if (Ut.isNil((JsonObject)json) || !json.containsKey(field)) {
                return Ux.future((Object)json);
            }
            Class clazz = Ut.clazz((String)json.getString(field));
            Fabric fabric = (Fabric)Ut.instance((Class)clazz, (Object[])new Object[0]);
            return fabric.combine(json);
        };
    }

    static Atomy compared(Atomy atomy, String fieldName, String user) {
        JsonArray inserted = new JsonArray();
        JsonArray updated = new JsonArray();
        JsonArray originalArray = new JsonArray();
        JsonArray original = (JsonArray)atomy.original();
        JsonArray latest = (JsonArray)atomy.current();
        Ut.itJArray((JsonArray)latest).forEach(each -> {
            String value = each.getString(fieldName);
            JsonObject item = Ut.elementFind((JsonArray)original, (String)fieldName, (Object)value);
            if (Objects.isNull(item)) {
                JsonObject record = each.copy();
                record.put("createdAt", Instant.now());
                record.put("createdBy", user);
                inserted.add(record);
            } else {
                JsonObject dataItem = new JsonObject();
                dataItem.mergeIn(item.copy(), true).mergeIn(each.copy());
                dataItem.put("updatedAt", Instant.now());
                dataItem.put("updatedBy", user);
                originalArray.add(item.copy());
                updated.add(dataItem);
            }
        });
        return Atomy.create((JsonArray)originalArray, (JsonArray)latest).add(inserted).update(updated);
    }

    static BiFunction<Function<JsonArray, Future<JsonArray>>, Function<JsonArray, Future<JsonArray>>, Future<JsonArray>> atomyFn(Class<?> clazz, Atomy compared) {
        return (iFun, uFun) -> {
            JsonArray inserted = compared.add();
            JsonArray updated = compared.update();
            Annal LOGGER = Annal.get((Class)clazz);
            KeLog.infoKe(LOGGER, "Result of calculated, Insert = {0}, Update = {1}", String.valueOf(inserted.size()), String.valueOf(updated.size()));
            ArrayList futures = new ArrayList();
            futures.add(Ut.ifJEmpty((Function)iFun).apply(inserted));
            futures.add(Ut.ifJEmpty((Function)uFun).apply(updated));
            return Ux.thenCombineArray(futures);
        };
    }
}

