/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.ke.init;

import io.vertx.tp.optic.atom.Lexeme;
import io.vertx.up.log.Annal;
import java.util.Iterator;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class KePin {
    private static final Annal LOGGER = Annal.get(KePin.class);
    private static final ConcurrentMap<String, Object> REF = new ConcurrentHashMap<String, Object>();

    public static <T> Lexeme<T> get(Class<T> interfaceCls) {
        if (Objects.isNull(interfaceCls)) {
            return null;
        }
        Object original = REF.getOrDefault(interfaceCls.getName(), null);
        if (Objects.isNull(original)) {
            ServiceLoader<T> loader = ServiceLoader.load(interfaceCls, interfaceCls.getClassLoader());
            Iterator<T> it = loader.iterator();
            Lexeme<T> found = null;
            while (it.hasNext()) {
                T reference = it.next();
                if (!Objects.nonNull(reference)) continue;
                found = new Lexeme<T>(interfaceCls, reference);
                String cacheKey = interfaceCls.getName();
                LOGGER.info("Lexeme<T>: interface = {0} <-------- impl = {1}", new Object[]{cacheKey, reference.getClass().getName()});
                REF.put(cacheKey, found);
                break;
            }
            return found;
        }
        return original;
    }
}

