/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.ke.refine;

import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.up.uca.yaml.Node;
import io.vertx.up.uca.yaml.ZeroUniform;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;

class KeTool {
    private static final Node<JsonObject> VISITOR = (Node)Ut.singleton(ZeroUniform.class, (Object[])new Object[0]);

    KeTool() {
    }

    static String getCatalog() {
        JsonObject config = (JsonObject)VISITOR.read();
        return Ut.visitString((JsonObject)config, (String[])new String[]{"jooq", "provider", "catalog"});
    }

    static <T> Future<T> poolAsync(String name, String key, Supplier<Future<T>> value) {
        return Ux.Pool.on((String)name).get((Object)key).compose(item -> {
            if (null == item) {
                return ((Future)value.get()).compose(updated -> Ux.Pool.on((String)name).put((Object)key, updated).compose(kv -> Ux.future((Object)kv.getValue())));
            }
            return Ux.future((Object)item);
        });
    }

    static <T> void consume(Supplier<T> supplier, Consumer<T> consumer) {
        T input = supplier.get();
        if (Objects.nonNull(input)) {
            if (input instanceof String) {
                if (Ut.notNil((String)((String)input))) {
                    consumer.accept(input);
                }
            } else {
                consumer.accept(input);
            }
        }
    }

    static void banner(String module) {
        System.out.println("-------------------------------------------------------------");
        System.out.println("|                                                           |");
        System.out.println("|     Zero Extension:  " + module);
        System.out.println("|                                                           |");
        System.out.println("-------------------------------------------------------------");
    }
}

