/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.ke.atom.specification;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.error._412IndentParsingException;
import io.vertx.tp.error._412IndentUnknownException;
import io.vertx.tp.ke.atom.specification.KPoint;
import io.vertx.tp.ke.refine.Ke;
import io.vertx.up.fn.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.util.Ut;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;

public class KJoin
implements Serializable {
    private static final Annal LOGGER = Annal.get(KJoin.class);
    private volatile String targetIndent;
    private KPoint source;
    private ConcurrentMap<String, KPoint> target = new ConcurrentHashMap<String, KPoint>();

    public String getTargetIndent() {
        return this.targetIndent;
    }

    public void setTargetIndent(String targetIndent) {
        this.targetIndent = targetIndent;
    }

    public KPoint getSource() {
        return this.source;
    }

    public void setSource(KPoint source) {
        this.source = source;
    }

    public ConcurrentMap<String, KPoint> getTarget() {
        return this.target;
    }

    public void setTarget(ConcurrentMap<String, KPoint> target) {
        this.target = target;
    }

    private String identifier(JsonObject data) {
        if (Ut.isNil((String)this.targetIndent)) {
            LOGGER.warn("The `targetIndent` field is null", new Object[0]);
            return null;
        }
        String identifier = data.containsKey(this.targetIndent) ? data.getString(this.targetIndent) : this.targetIndent;
        return identifier;
    }

    public KPoint point(JsonObject data) {
        String identifier = this.identifier(data);
        Fn.out((boolean)Ut.isNil((String)identifier), _412IndentParsingException.class, (Object[])new Object[]{this.getClass(), this.targetIndent, data});
        KPoint result = this.point(identifier);
        if (Objects.isNull(result)) {
            Ke.infoKe(LOGGER, "System could not find configuration for `{0}` with data = {1}", identifier, data.encode());
        }
        return result;
    }

    public KPoint point(String identifier) {
        KPoint target = this.target.getOrDefault(identifier, null);
        if (Objects.isNull(target)) {
            return null;
        }
        return target.indent(identifier);
    }

    public KPoint point(JsonArray data) {
        if (Ut.isArrayJson((JsonArray)data)) {
            HashSet idSet = new HashSet();
            Ut.itJArray((JsonArray)data).map(this::identifier).filter(Objects::nonNull).forEach(idSet::add);
            Fn.out((1 != idSet.size() ? 1 : 0) != 0, _412IndentUnknownException.class, (Object[])new Object[]{this.getClass(), this.targetIndent});
            String identifier = (String)idSet.iterator().next();
            return this.point(identifier);
        }
        return null;
    }

    public void dataIn(JsonObject ds, KPoint target, JsonObject data) {
        this.dataRun(target, source -> {
            String joinedValue = ds.getString(source.getKey());
            if (Ut.notNil((String)joinedValue)) {
                data.put(target.getKeyJoin(), (Object)joinedValue);
            }
        });
    }

    public void dataCond(JsonObject ds, KPoint target, JsonObject data) {
        this.dataRun(target, source -> {
            String joinedValue = ds.getString(source.getKey());
            if (Ut.isNil((String)joinedValue)) {
                joinedValue = ds.getString(target.getKeyJoin());
            }
            if (Ut.notNil((String)joinedValue)) {
                data.put(target.getKeyJoin(), (Object)joinedValue);
            }
        });
    }

    public void dataOut(JsonObject ds, KPoint target, JsonObject data) {
        this.dataRun(target, source -> {
            String joinedValue = ds.getString(target.getKeyJoin());
            if (Ut.notNil((String)joinedValue)) {
                data.put(source.getKey(), (Object)joinedValue);
            }
        });
    }

    private void dataRun(KPoint target, Consumer<KPoint> consumer) {
        KPoint source = this.source;
        if (Objects.nonNull(target) && Objects.nonNull(source)) {
            consumer.accept(source);
        }
    }
}

