/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.ke.booter;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.WorkerExecutor;
import io.vertx.tp.ke.refine.Ke;
import io.vertx.tp.plugin.excel.ExcelClient;
import io.vertx.tp.plugin.excel.ExcelInfix;
import io.vertx.up.log.Annal;
import io.vertx.up.unity.Ux;
import io.vertx.up.unity.UxTimer;
import io.vertx.up.util.Ut;
import java.util.Objects;

class BtKit {
    private static final Annal LOGGER = Annal.get(BtKit.class);

    BtKit() {
    }

    static Handler<AsyncResult<Boolean>> complete(String folder, String prefix, UxTimer timer) {
        return handler -> {
            if (handler.succeeded()) {
                if (Objects.isNull(prefix)) {
                    Ke.infoKe(LOGGER, "The data folder `{0}` has been imported successfully!", folder);
                } else {
                    Ke.infoKe(LOGGER, "The data folder `{0}` with `{1}` has been imported successfully!", folder, prefix);
                }
                timer.end(System.currentTimeMillis());
                Ke.infoKe(LOGGER, "TOTAL EXECUTION TIME = The total execution time = {0}!", timer.value());
                System.exit(0);
            } else {
                handler.cause().printStackTrace();
            }
        };
    }

    static Future<String> complete(String filename) {
        Promise promise = Promise.promise();
        BtKit.execute(filename, (Handler<AsyncResult<String>>)((Handler)handler -> {
            Ke.infoKe(LOGGER, "Successfully to finish loading ! data file = {0}", filename);
            promise.complete((Object)((String)handler.result()));
        }));
        return promise.future();
    }

    private static void execute(String filename, Handler<AsyncResult<String>> callback) {
        WorkerExecutor executor = Ux.nativeWorker((String)filename);
        executor.executeBlocking(pre -> {
            ExcelClient client = ExcelInfix.createClient();
            Ke.infoKe(LOGGER, "Excel importing file = {0}", filename);
            client.importAsync(filename, handler -> {
                if (handler.succeeded()) {
                    pre.complete((Object)filename);
                } else {
                    pre.fail(handler.cause());
                }
            });
        }, post -> callback.handle((Object)Future.succeededFuture((Object)((String)post.result()))));
    }

    static boolean ensure(String filename) {
        if (Ut.isNil((String)filename)) {
            return false;
        }
        if (filename.contains("~")) {
            return false;
        }
        return filename.endsWith("xlsx") || filename.endsWith("xls");
    }
}

