/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.ke.refine;

import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import io.vertx.tp.ke.refine.KeCache;
import io.vertx.tp.ke.refine.KeCompare;
import io.vertx.tp.ke.refine.KeData;
import io.vertx.tp.ke.refine.KeLog;
import io.vertx.tp.ke.refine.KeRun;
import io.vertx.tp.ke.refine.KeTool;
import io.vertx.tp.ke.refine.KeUser;
import io.vertx.up.atom.record.Apt;
import io.vertx.up.atom.secure.Vis;
import io.vertx.up.commune.element.TypeAtom;
import io.vertx.up.log.Annal;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jooq.Configuration;

public class Ke {
    public static String getDatabase() {
        return KeTool.getCatalog();
    }

    public static Configuration getConfiguration() {
        return KeTool.getConfiguration();
    }

    public static Future<JsonArray> combineAsync(JsonArray data, ConcurrentMap<String, String> headers) {
        return KeCompare.combineAsync(data, headers);
    }

    public static Future<JsonArray> combineAsync(JsonArray data, ConcurrentMap<String, String> headers, List<String> columns) {
        return KeCompare.combineAsync(data, headers, columns, null);
    }

    public static Future<JsonArray> combineAsync(JsonArray data, ConcurrentMap<String, String> headers, List<String> columns, TypeAtom TypeAtom2) {
        return KeCompare.combineAsync(data, headers, columns, TypeAtom2);
    }

    public static Function<JsonObject, Future<JsonObject>> fabricFn(String field) {
        return KeCompare.combineAsync(field);
    }

    public static Function<JsonObject, Future<JsonObject>> mapFn(String field, ConcurrentMap<String, JsonObject> fieldConfig, BiFunction<JsonObject, JsonArray, Future<JsonArray>> fileFn) {
        return data -> KeTool.map(data, field, fieldConfig, fileFn);
    }

    public static Function<JsonObject, Future<JsonObject>> mapFn(ConcurrentMap<String, JsonObject> fieldConfig, BiFunction<JsonObject, JsonArray, Future<JsonArray>> fileFn) {
        return data -> KeTool.map(data, "key", fieldConfig, fileFn);
    }

    public static void banner(String module) {
        KeTool.banner(module);
    }

    public static void infoKe(Annal logger, String pattern, Object ... args) {
        KeLog.infoKe(logger, pattern, args);
    }

    public static void debugKe(Annal logger, String pattern, Object ... args) {
        KeLog.debugKe(logger, pattern, args);
    }

    public static void runString(Supplier<String> supplier, Consumer<String> consumer) {
        KeTool.consume(supplier, consumer);
    }

    public static void runBoolean(Supplier<Boolean> supplier, Consumer<Boolean> consumer) {
        KeTool.consume(supplier, consumer);
    }

    public static void runInteger(Supplier<Integer> supplier, Consumer<Integer> consumer) {
        KeTool.consume(supplier, consumer);
    }

    public static <T, O> Future<O> channel(Class<T> clazz, Supplier<O> supplier, Function<T, Future<O>> executor) {
        return KeRun.channel(clazz, supplier, executor);
    }

    public static <T, O> O channelSync(Class<T> clazz, Supplier<O> supplier, Function<T, O> executor) {
        return KeRun.channelSync(clazz, supplier, executor);
    }

    public static <T, O> Future<O> channelAsync(Class<T> clazz, Supplier<Future<O>> supplier, Function<T, Future<O>> executor) {
        return KeRun.channelAsync(clazz, supplier, executor);
    }

    public static String uri(String uri, String requestUri) {
        return KeCache.uri(uri, requestUri);
    }

    public static String uri(RoutingContext context) {
        return KeCache.uri(context);
    }

    public static String keyView(String method, String uri, Vis view) {
        return KeCache.keyView(method, uri, view);
    }

    public static String keyView(RoutingContext context) {
        return KeCache.keyView(context);
    }

    public static String keyAuthorized(String method, String uri) {
        return KeCache.keyAuthorized(method, uri);
    }

    public static String keyResource(String method, String uri) {
        return KeCache.keyResource(method, uri);
    }

    public static Apt compmared(Apt apt, String user) {
        return KeCompare.compared(apt, "code", user);
    }

    public static Apt compmared(Apt apt, String field, String user) {
        return KeCompare.compared(apt, field, user);
    }

    public static BiFunction<Function<JsonArray, Future<JsonArray>>, Function<JsonArray, Future<JsonArray>>, Future<JsonArray>> atomyFn(Class<?> clazz, Apt compared) {
        return KeCompare.atomyFn(clazz, compared);
    }

    public static <T, I> void umCreated(I output, T input) {
        KeUser.audit(output, null, input, null, false);
    }

    public static <T, I> void umCreated(I output, T input, String pojo) {
        KeUser.audit(output, null, input, pojo, false);
    }

    public static <T, I> void umCreated(I output, String pojo, T input) {
        KeUser.audit(output, pojo, input, null, false);
    }

    public static <T, I> void umCreated(I output, String outPojo, T input, String inPojo) {
        KeUser.audit(output, outPojo, input, inPojo, false);
    }

    public static <T, I> void umUpdated(I output, T input) {
        KeUser.audit(output, null, input, null, true);
    }

    public static <T, I> void umUpdated(I output, T input, String pojo) {
        KeUser.audit(output, null, input, pojo, true);
    }

    public static <T, I> void umUpdated(I output, String pojo, T input) {
        KeUser.audit(output, pojo, input, null, true);
    }

    public static <T, I> void umUpdated(I output, String outPojo, T input, String inPojo) {
        KeUser.audit(output, outPojo, input, inPojo, true);
    }

    public static Future<JsonObject> umIndent(JsonObject data, String code) {
        return KeData.indent(data, code);
    }

    public static Future<JsonArray> umIndent(JsonArray data, String code) {
        return KeData.indent(data, code);
    }

    public static <T> Future<T> umIndent(T input, Function<T, String> fnSigma, String code, BiConsumer<T, String> fnConsumer) {
        String sigma = fnSigma.apply(input);
        return KeData.indent(input, sigma, code, fnConsumer);
    }

    public static <T> Future<T> umIndent(T input, String sigma, String code, BiConsumer<T, String> fnConsumer) {
        return KeData.indent(input, sigma, code, fnConsumer);
    }

    public static <T> Future<List<T>> umIndent(List<T> input, Function<List<T>, String> fnSigma, String code, BiConsumer<T, String> fnConsumer) {
        String sigma = fnSigma.apply(input);
        return KeData.indent(input, sigma, code, fnConsumer);
    }

    public static <T> Future<List<T>> umIndent(List<T> input, String sigma, String code, BiConsumer<T, String> fnConsumer) {
        return KeData.indent(input, sigma, code, fnConsumer);
    }
}

