/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.ke.refine;

import io.vertx.core.Future;
import io.vertx.tp.ke.refine.KeLog;
import io.vertx.tp.optic.Pocket;
import io.vertx.up.unity.Ux;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;

class KeRun {
    KeRun() {
    }

    static <T, O> Future<O> channel(Class<T> clazz, Supplier<O> supplier, Function<T, Future<O>> executor) {
        T channel = Pocket.lookup(clazz);
        if (Objects.isNull(channel)) {
            KeLog.warnChannel(KeRun.class, "Channel {0} null", clazz.getName());
            return Ux.future(supplier.get());
        }
        KeLog.debugChannel(KeRun.class, "Channel Async selected {0}, {1}", channel.getClass().getName(), String.valueOf(channel.hashCode()));
        return executor.apply(channel);
    }

    static <T, O> O channelSync(Class<T> clazz, Supplier<O> supplier, Function<T, O> executor) {
        T channel = Pocket.lookup(clazz);
        if (Objects.isNull(channel)) {
            KeLog.warnChannel(KeRun.class, "Channel Sync {0} null", clazz.getName());
            return supplier.get();
        }
        KeLog.debugChannel(KeRun.class, "Channel Sync selected {0}, {1}", channel.getClass().getName(), String.valueOf(channel.hashCode()));
        return executor.apply(channel);
    }

    static <T, O> Future<O> channelAsync(Class<T> clazz, Supplier<Future<O>> supplier, Function<T, Future<O>> executor) {
        T channel = Pocket.lookup(clazz);
        if (Objects.isNull(channel)) {
            KeLog.warnChannel(KeRun.class, "Channel Async {0} null", clazz.getName());
            return supplier.get();
        }
        KeLog.debugChannel(KeRun.class, "Channel Async selected {0}, {1}", channel.getClass().getName(), String.valueOf(channel.hashCode()));
        return executor.apply(channel);
    }
}

