-- liquibase formatted sql

-- changeset Lang:l-region-1
SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for L_REGION
-- ----------------------------
DROP TABLE IF EXISTS `L_REGION`;
CREATE TABLE `L_REGION`
(
    `KEY`        VARCHAR(36) NOT NULL COMMENT '「key」- 主键',
    `NAME`       VARCHAR(32) NOT NULL COMMENT '「name」- 名称',
    `CODE`       VARCHAR(36) DEFAULT NULL COMMENT '「code」- 编码',
    `METADATA`   TEXT COMMENT '「metadata」- 附加配置',
    `ORDER`      INT(11)     DEFAULT NULL COMMENT '「order」- 排序',

    `CITY_ID`    VARCHAR(36) NOT NULL COMMENT '「cityId」- 城市ID',

    -- 特殊字段
    `ACTIVE`     BIT         DEFAULT NULL COMMENT '「active」- 是否启用',
    `SIGMA`      VARCHAR(32) DEFAULT NULL COMMENT '「sigma」- 统一标识',
    `LANGUAGE`   VARCHAR(8)  DEFAULT NULL COMMENT '「language」- 使用的语言',

    -- Auditor字段
    `CREATED_AT` DATETIME COMMENT '「createdAt」- 创建时间',
    `CREATED_BY` VARCHAR(36) COMMENT '「createdBy」- 创建人',
    `UPDATED_AT` DATETIME COMMENT '「updatedAt」- 更新时间',
    `UPDATED_BY` VARCHAR(36) COMMENT '「updatedBy」- 更新人',
    PRIMARY KEY (`KEY`)
);

-- changeset Lang:l-region-2
ALTER TABLE L_REGION
    ADD UNIQUE (`CODE`, `SIGMA`);

-- changeset Lang:l-region-3
-- ----------------------------
-- Records of L_REGION
-- ----------------------------
BEGIN;
INSERT INTO `L_REGION`
VALUES ('000dd234-5d3e-4ea5-8f6b-547c589e6d83', '和舍镇', NULL, NULL, 722, '0be5e1cb-cdb0-48ca-9f82-47f7f4c6dd2e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('001bba10-42c7-4f82-ae44-7dc02507d9d2', '舒城县', NULL, NULL, 285, '4ee9594e-d779-4cad-a3bc-d766de26628a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0023235b-0814-4b56-b9e0-b3998a6555d1', '达茂联合旗', NULL, NULL, 2050, 'd4910db5-a704-4273-bd13-a6dc05f468cf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0023f394-31e1-48d3-a7dc-19f6115856ce', '嘉积镇', NULL, NULL, 1446, '81aab36f-0e28-4ba3-9827-b7033fce9b24', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('002e4ba9-9ce6-44f0-8941-a0bfb72c16d6', '新华区', NULL, NULL, 3385, 'f5ebab20-0f47-47e8-b896-6f3d9651c97a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('003ac2b3-d91e-4844-8af4-84ca3aa881a1', '虎溪镇', NULL, NULL, 3904, '7fefd2bf-99e0-43f5-bc37-9ab15ee8e8f3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0045c9ea-4a0b-4339-b955-05d35ea3fa8c', '庄行镇', NULL, NULL, 634, 'fa34c22b-c1d8-45b2-bb1b-4ea08298e7f6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('005bd108-a97f-457a-82b1-1e6cda382a0e', '岚山区', NULL, NULL, 2420, '552f7151-162b-4453-a9c5-3a9092fce226', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('008cb15e-9e70-49b3-96d1-ae436d32b96e', '延寿县', NULL, NULL, 1538, '349a18f4-4117-490c-b26f-80702a4911bf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('00c573a8-976b-40c7-8064-d3b3377c0fb9', '北务镇', NULL, NULL, 3721, 'd1c1539c-b904-4bcc-a034-96213f63d0ff', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('00cee8e5-76db-41de-915f-aa16ab34d922', '曹回乡', NULL, NULL, 1492, '89e8be16-b810-4c7e-89f0-aa9f24483b98', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('00d6fd4d-e70e-4d5c-b0f1-6d8e25388a5e', '淮上区', NULL, NULL, 884, 'be39aa7b-a993-4abd-956c-dcb299cc7bc3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('00d9b995-059d-4442-9da5-960c1d3ef156', '木耳镇', NULL, NULL, 711, '97942649-3cc7-4e4a-81b4-9a8c82f82ea7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('00efb64b-82ae-497d-b321-750406a2f5ee', '张沟镇', NULL, NULL, 3469, 'ea11feaf-194c-4cec-be59-d17bac402db4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('00f006b0-8f75-489e-aa58-d675d9182331', '隆安县', NULL, NULL, 2808, 'b53ced47-2455-44ec-b740-7637148f574c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('010879f3-ca1a-4745-925d-a1dbdcb566d0', '那大镇', NULL, NULL, 3200, '2e21ea75-c640-4928-8cb4-e5ba4f6e2ffe', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('010f977f-3a3b-4e73-9a3a-d999d44533b9', '抱龙镇', NULL, NULL, 373, '76dd00a1-30a1-4226-ae06-cad845c0528c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('011bcf91-08ca-450f-a92d-b64a8436c5bd', '大垭乡', NULL, NULL, 1887, '2c8bc8c3-9317-4f36-a0ad-05a8d6b27053', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0126f1f0-0388-4d74-974d-9b86f48609ae', '金沙县', NULL, NULL, 2617, '55fdf7c7-6698-498a-8aef-b9455ab7926c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0137eada-3e01-4707-a240-72eb5a6229b4', '路北区', NULL, NULL, 2450, '4f4c1ef4-f54d-4ba4-a124-ca2d3d0ddb78', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('01510e6c-ca23-413d-aae9-bae701535b70', '民丰县', NULL, NULL, 854, '60e9ec7d-f371-4ea9-ace3-b13c1cd7081c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('015b8a8d-fe5e-421a-b2e7-272e4f08f4e0', '龙滚镇', NULL, NULL, 4483, 'f491d9c3-9527-46a4-8954-6795ff079478', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('01645df6-a7cf-4738-86f7-9d1cb31fb125', '红寺堡开发区', NULL, NULL, 606, '9d872dc5-ad1a-4b3c-86de-debd1a77eb8c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('019b38b5-ee93-465e-a31e-70e8edea2eda', '长安区', NULL, NULL, 2766, '334645de-ae54-416a-8978-2dbf9f7bbd09', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('01a1e3bc-1dc0-4c0a-be2d-09298da3fa49', '开平市', NULL, NULL, 3311, '2a61b8e3-4156-42df-836b-fc855d156f23', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('01a53a57-fe26-4b44-9b89-cf6b44dcf161', '接龙镇', NULL, NULL, 47, '43c813e3-8672-45c5-8d3e-9ee43dbe51c8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('01bbe7ee-4b0d-4dd1-bf27-0ee604741944', '蔚县', NULL, NULL, 141, '37614653-bf6c-458f-a844-540790491eb1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('01bf1953-3b04-4bf0-af5d-d05fa38c8298', '水口乡', NULL, NULL, 197, '4f867632-2989-4def-9934-a9c5fe0d5ca5', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('01c0e78f-128e-4674-b432-e64111af0923', '西和县', NULL, NULL, 1375, '7c9ca39d-ce8f-469d-899a-09a0a29c1541', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('01d6680e-9caf-4780-9bae-0163c9da397e', '城厢区', NULL, NULL, 6, '7acdab30-849a-4c32-b081-8cbdc15f711a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('01e544e2-50b7-48b4-a3e8-c0266b62edcb', '横山镇', NULL, NULL, 3663, '6581d8db-553e-4417-8c37-91ed47904920', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('01fdf7a9-30d9-4409-bc5b-b8702b5d89f0', '平房区', NULL, NULL, 1545, '349a18f4-4117-490c-b26f-80702a4911bf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('02007045-654c-4507-8681-e1ab013f4e4a', '蒲吕镇', NULL, NULL, 3845, 'c33c3107-81df-4ced-8b92-d694df412da3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('021769c4-ea8d-4ba7-80be-12d49000c7ba', '宜城市', NULL, NULL, 1342, '52d3ef0d-d999-4ae8-971b-534a2b25de02', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0217bcff-c599-485f-985d-1a724fd748ea', '莱西市', NULL, NULL, 3719, '1e53830d-8cdb-4111-8da6-987131b873ed', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('021dde2f-29db-4e41-b142-caa9d12a9619', '乐业县', NULL, NULL, 1220, 'f56fa64d-ca06-49d2-a9cb-94742a33af21', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('022e442a-2ded-468d-90d1-d60523b1c578', '珠山区', NULL, NULL, 2406, 'f02f3013-3723-48cb-9461-451981c81059', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('02322c93-c10c-42b1-a552-23387b0b6db7', '邛崃市', NULL, NULL, 1808, '4f073365-4e02-459f-8b32-cad88dd22637', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0250ffeb-6765-4447-8f68-dba430576ec4', '永丰镇', NULL, NULL, 2674, 'e509a1a5-95da-4fb2-9a2b-f84afa05a36c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0255439e-fabf-47e6-87c1-be7ad0f45698', '怀宁县', NULL, NULL, 3583, '818f3bc6-83b9-4d90-8e68-566cc7c2bb14', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('025c5d36-0c69-43c6-a8ec-1dace0470a3f', '信丰县', NULL, NULL, 1619, 'dd4a8577-afbe-449b-ae9b-be374a4c7434', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('026c9b94-4fae-4ad8-ae09-0e8e518324dc', '石河子市', NULL, NULL, 4048, '4c1e2adc-07ac-46ea-b0de-fb35e74a2708', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('026ee3d2-ecac-4bb9-b14b-f4cd671587e2', '城中区', NULL, NULL, 2746, '0f2ba543-1d40-4b41-b700-6b53a9622b5b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('027fd671-5285-4e4d-afad-093ee3bbb1cc', '其它地区', NULL, NULL, 3118, '310378c8-165d-4f81-a495-67e9b30f000f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0290444b-5476-4aab-afa8-21c17df5c02c', '十直镇', NULL, NULL, 1926, '442f465d-6566-45e4-9338-50f4395aa6f7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('02a2ff5f-a237-4e86-a305-019ce1944fcb', '运河区', NULL, NULL, 2898, 'a3c44525-9ccb-429d-a2b7-f5f5d52b8a6d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('02add3c7-704e-457a-8289-0d37d99ea165', '禹王台区', NULL, NULL, 4181, 'fb0dbd60-1d03-4394-a890-ffc2d3ec6a37', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('02b706f0-b6ff-4b56-b891-b69258ea3888', '柘城县', NULL, NULL, 3140, '62aa4f78-f1b9-44d1-9372-21e01c353757', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('031eb6f8-884e-4ffb-a7d1-bc91d6cfb13d', '排浦镇', NULL, NULL, 3215, '2e21ea75-c640-4928-8cb4-e5ba4f6e2ffe', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('032a1544-5e03-426e-b43f-7752b0a78517', '安县', NULL, NULL, 391, 'efb72ec7-b29f-48d0-a16c-9a33d3938d49', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('032f6d7c-9b29-4c8b-b413-ab5cab437bf1', '阎良区', NULL, NULL, 4294, '29595f0b-301d-42da-845d-01afb30a9c18', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('033d6fad-53b4-4e74-812b-a5a8a4ba1514', '丹徒区', NULL, NULL, 1758, '63f8e070-63c0-4fa1-821f-d1d5a695ce2a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('03432a06-db40-4a32-8829-397e86136c3e', '郓城县', NULL, NULL, 1795, 'e04fe06c-7641-47c7-a125-4d35e1800549', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('03580a71-c464-4b02-b0a8-d26dcae9648a', '椒江区', NULL, NULL, 3291, 'de41020d-a8dc-44d0-a2d4-75b6076c0ae8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('036a67d4-7f4d-4a72-9803-94bb7cfa16db', '大鹏新区', NULL, NULL, 680, 'fd718129-208d-4a94-9e52-7516af8ef013', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('03759d4a-8756-4bca-bba8-8f9793b5fb5e', '湛河区', NULL, NULL, 3383, 'f5ebab20-0f47-47e8-b896-6f3d9651c97a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0378beb0-aa37-4abf-ab23-61d3eba319fb', '八里湖新区', NULL, NULL, 119, 'bcaf1f36-5459-4e74-81d1-5026680b1a9c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('037eef6a-020c-4d6f-b58c-fb354e93f4c6', '临淄区', NULL, NULL, 2442, 'c03520db-2a67-4cae-a658-4806d4254996', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('03b2b68c-4e94-4e1c-93e5-eb358a94bf90', '通许县', NULL, NULL, 4182, 'fb0dbd60-1d03-4394-a890-ffc2d3ec6a37', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('03d793e0-91ce-4916-9764-2e5ff092cea6', '古蔺县', NULL, NULL, 583, '78000393-73bd-4a54-a688-5db0e578d9cd', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('03e22590-5077-435e-8618-798d207aa938', '主城区内', NULL, NULL, 1365, '5a1e74c1-6f4c-440f-8ade-ac470f4ada87', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('03ee2c0b-b33b-4236-b3a6-640caf67e251', '三都县', NULL, NULL, 3493, 'ef4b5cd7-d6b5-4839-9963-c010487ba475', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('03ee4e90-5ae7-4cac-a609-db2efb8d1390', '黎水镇', NULL, NULL, 3365, 'aa2f26e5-9705-4dc0-b54a-a2d7dbb8b511', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('04078eeb-0fa9-4dea-9d7b-318ffd301b23', '合庆镇', NULL, NULL, 2628, '4683d3ef-0edf-425a-98d5-2cb231a7d88a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('040bbdf1-3821-438f-a815-93ed952c8035', '府谷县', NULL, NULL, 1298, 'c0c88cbd-87ea-4281-9e8e-94a435ae6590', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0419a5b6-d5d1-499f-9009-ffa90dacafdd', '瓮安县', NULL, NULL, 3487, 'ef4b5cd7-d6b5-4839-9963-c010487ba475', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('041e65bb-dd8f-43f8-a54a-94e1cb22b388', '昆山市', NULL, NULL, 620, '278acb58-4d2d-40cb-a572-1fc7fb979c77', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0424dade-a173-432a-a2ec-6f2b5cf83024', '岳池县', NULL, NULL, 3297, '4bb2fe40-7307-498b-802c-e85e937f95e0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('042bd883-3ab7-4596-aad4-74521a2799d1', '双塔区', NULL, NULL, 4138, '0c1d1a8a-4eea-4aa0-9a5e-b68ae380a09a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('043021b4-9596-4345-9c89-cd9206178513', '四面山镇', NULL, NULL, 888, '41f376c0-764f-46b9-af35-e555518fc613', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0450e1bf-5817-4e1b-8b3a-733cbb77bc03', '吴江区', NULL, NULL, 618, '278acb58-4d2d-40cb-a572-1fc7fb979c77', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('045d7860-7f91-4e4f-ac43-b9a706d9510b', '龙川县', NULL, NULL, 1722, 'a9736c65-aeba-4a39-861f-5edf105d8673', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('045d8740-66e6-45a4-b88d-c507003d2f55', '大田镇', NULL, NULL, 3606, '46073b56-9ab9-4efb-874f-efe112a304a6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0473d9ae-0a4c-49c7-92f1-84ef7b2c4cd6', '施秉市', NULL, NULL, 3078, '6d3a8433-1273-4323-a3eb-d39effecc1d7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0496cfa2-c899-41cc-b8f8-1f38b0f0f70a', '商城县', NULL, NULL, 3501, '976170b4-d0f7-4fd9-82ed-6e336c9bf3c0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('049d2e9f-bbc6-44c1-9783-ebe6083fd40e', '铁峰乡', NULL, NULL, 4236, '0ee28cef-8dfc-4a9f-b7c1-330bc11c1bb3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('049e781f-04cd-4d35-9ca0-855c92ae35b7', '普安乡', NULL, NULL, 191, '4f867632-2989-4def-9934-a9c5fe0d5ca5', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('04a4eb8c-17d8-435a-a3db-379c56482615', '双峰县', NULL, NULL, 3749, 'cff58e36-5b90-4beb-a3b7-e04021d244cb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('04af0c77-3c1d-44b5-88a0-6a30bd290447', '白碱滩区', NULL, NULL, 1435, '24925ffc-d2fd-4b44-823a-250fcc224503', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('04b44395-253c-4b7b-b011-7a76d744e8da', '同乐乡', NULL, NULL, 1149, '72d4f69f-2e4c-4bde-9df8-2aadc9168686', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('04cffba3-6fce-4832-a7ef-b91400b51a85', '平阴县', NULL, NULL, 4358, 'c6ac73d4-9854-403a-9b61-12c22eeb4903', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('04d7d9e6-c423-4bd0-ac49-5b8cc0ca2411', '陆川县', NULL, NULL, 2338, 'ee710091-bfa9-4285-89e3-80ad65ebd912', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('04e24c97-73cb-4089-977f-d5e39e35a73c', '尧都区', NULL, NULL, 3708, '1aeeea9e-d028-4a96-94ce-ba84cdd3e69f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('04ebabe0-a17c-40f4-93a6-d736b77ea213', '天府镇', NULL, NULL, 2328, '671d3a34-71bf-42c5-8dda-a813f5ecba22', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('04ec7e9f-8f53-49f4-9635-8aecb9758194', '江口县', NULL, NULL, 2871, 'dce7fe20-4766-408d-92be-62ba8fbb7a43', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('04f47b49-be40-48fa-a9d1-5036a104450c', '兰洋镇', NULL, NULL, 3206, '2e21ea75-c640-4928-8cb4-e5ba4f6e2ffe', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('04fbee56-9f51-412f-b042-21a3a05ac4f1', '清苑县', NULL, NULL, 2485, '81e22d56-a1c7-4263-be18-81a4af165ae3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('050eb787-ec25-446c-b138-2eb2837e9e0b', '城区', NULL, NULL, 3654, '6581d8db-553e-4417-8c37-91ed47904920', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('051b0f89-a80f-4035-bb92-cfb94d506d9b', '元谋县', NULL, NULL, 2091, '50868d97-8741-48fe-9cba-86e2e118f220', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('052c0b20-7a50-45fa-9fbb-37b49655bcd6', '墨江县', NULL, NULL, 1709, 'db61cc5b-b13b-417f-a232-7925ffdfa9b2', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('052f8682-fb52-4ba4-bdd5-7f0ef2244ea2', '滨江区', NULL, NULL, 2313, 'f530455e-1c70-47dd-9a80-4bc74a4e2680', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0530c33b-e847-4ab1-a8b5-d3f83a6da5c8', '抚顺县', NULL, NULL, 1380, '6b5fed36-b200-40ca-af0b-11999b4399ef', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('053c10f3-2dd4-4fc7-9e39-ef033498076c', '保国农场', NULL, NULL, 2551, 'a1e3332c-7029-4de7-a221-40c041a9a620', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('054c7ae7-106d-4291-b504-3ca4fb32d456', '平川区', NULL, NULL, 3094, '0fafa17c-1c8a-4cb9-a100-4cfa035e3fed', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('05502abc-6569-435e-8e1b-46e4261b23ee', '香河县', NULL, NULL, 1236, '86f7f02d-658e-44ec-9d36-b14cc3c65aaf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('055d9fb9-251a-44e9-b27d-7691a01b9214', '木垒县', NULL, NULL, 1277, '8db1e665-1af9-4697-8514-7fa18e3a8683', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('056708b9-24d6-4f62-81d3-9994c567c234', '烈山区', NULL, NULL, 2246, '8afb487f-de86-4a5b-9abc-27ae2c07797d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('058eef3a-e497-4a4b-94b2-9887409dbbc8', '围场县', NULL, NULL, 4035, '8db8f645-a1a6-4c39-9c27-2f703951f66d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('058efcc2-2fcf-4805-bbaa-244c4b9b5e9e', '浑江区', NULL, NULL, 1394, 'baaceb68-ffec-405f-8bcc-9d58ab5a0c1e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('05a17803-4127-4c21-bc94-90044c6a0af9', '长阳土家族自治县', NULL, NULL, 1787, '3760382f-ecb5-4ef6-8bd2-049afe34b574', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('05ba1674-832a-4872-bee4-e492edaa01b8', '呼图壁县', NULL, NULL, 1276, '8db1e665-1af9-4697-8514-7fa18e3a8683', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('05baee57-fb97-46bd-9ebc-995e58b7952a', '泗泾镇', NULL, NULL, 86, '3e082d1b-ecb4-4bf8-8715-54132a9106e1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('05c2b42d-63e7-422f-ac44-89058280ed09', '城区', NULL, NULL, 2185, 'f2727650-b0d9-4541-acdb-b4eabf894893', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('05c50e3f-1c88-47d9-8a42-002b2669f9d0', '迁西区', NULL, NULL, 2458, '4f4c1ef4-f54d-4ba4-a124-ca2d3d0ddb78', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('05d2b4a3-ece1-416b-a8aa-6d6a49af57cd', '饶平县', NULL, NULL, 4387, '08acb8e2-e168-4e7b-81ce-918197cf4ecf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('05d5955e-bd54-4bc3-ad26-0934b9ab5901', '天全县', NULL, NULL, 3633, '6af0e8d8-91c9-43be-be32-5ec5c86b14f5', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('05d94721-97a5-44f7-81dd-4d198c8f838a', '浦城县', NULL, NULL, 3448, 'dd15d032-477c-4f54-9629-ea782606b468', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('05e2b08d-737b-4438-bc97-a8558264851e', '杨林街道', NULL, NULL, 2138, '671275c4-6107-4968-bd8e-96d53e9995b2', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('05eaf76f-026d-47c3-a863-20740f077068', '格尔木市', NULL, NULL, 3012, 'a638060f-a01c-4c77-b905-b46ef8d3e89d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('05fba777-a00a-4521-a025-5a59c785a456', '三河乡', NULL, NULL, 818, '0f559985-f6fe-4a8f-af80-3d0d64932dbc', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('05fc7043-c68e-4592-b4e3-240946805670', '环江县', NULL, NULL, 1162, '509d3498-d5ba-4378-8bee-0baf015c2a11', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('06054bc1-1338-4651-a6fd-fbb4612fce1f', '海珠区', NULL, NULL, 1981, '926eaeaf-e8c5-47f2-89ff-6932b52c87d3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('060d44ee-381b-43e4-9d36-6aecdcd7e889', '洞头区', NULL, NULL, 258, '86b77e39-331e-4927-9517-49be7b738b9a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('06115bad-bd8f-42e7-bfda-2f793a160fb8', '庄河市', NULL, NULL, 4059, 'd83aabcc-3c2e-4b48-962a-c548442bc896', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('061ba133-bc92-4e44-ac3d-3e7b4760dc75', '牟平区', NULL, NULL, 590, 'f3717726-7743-4838-852b-3a09f9528a69', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('062dafe5-9566-4081-abab-e92e47fc6e49', '凤来乡', NULL, NULL, 4457, '4888e1e9-ba45-4254-83e7-87796f338e2d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0692285c-ff0f-44e8-bfb8-18df1bc8c8bb', '贞丰县', NULL, NULL, 3109, '875ed189-3d32-4466-a24f-7cbac524774e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('06a20275-5f65-4903-8796-f244701c6efc', '玛多县', NULL, NULL, 2652, '292d9fec-f1c5-4100-b5be-fe56a5036e70', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('06c7d7ba-9950-4b01-829a-c394acd0747f', '威信县', NULL, NULL, 3691, '31187fc0-8d6e-45f3-9653-b7ce4227ef1d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('06cd8cef-5fbf-41de-93ef-fa500572c26d', '西湖镇', NULL, NULL, 905, '41f376c0-764f-46b9-af35-e555518fc613', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('06d6270f-d568-4340-ac96-337e34acebda', '雨山区', NULL, NULL, 3454, 'a77a0530-087f-4dab-84ab-e8a9690de27f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('06e17091-098f-488c-a60e-f5d861dc36f0', '七塘镇', NULL, NULL, 3596, '27289f06-ca7a-4916-8f25-f6b13d8687ec', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('06ef69c2-6f02-4692-b782-6b00cbab2d76', '徐行镇', NULL, NULL, 1324, '99c50aa3-ab40-4b1e-addd-f68662f3c560', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('06f28ce2-69fe-4616-9300-a55c4fdb4f92', '武定县', NULL, NULL, 2094, '50868d97-8741-48fe-9cba-86e2e118f220', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0704f8a5-fb02-40f0-a461-7d827cebf05a', '丰宁县', NULL, NULL, 4034, '8db8f645-a1a6-4c39-9c27-2f703951f66d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('07078fb7-0355-4f77-ab97-bf4ed839f57e', '淮滨县', NULL, NULL, 3495, '976170b4-d0f7-4fd9-82ed-6e336c9bf3c0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0721c98a-e76b-4b94-b7a3-68ee5b7dd6a9', '柳城县', NULL, NULL, 2750, '0f2ba543-1d40-4b41-b700-6b53a9622b5b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('072cb954-b345-476d-bd83-a6d79c332e77', '鼎湖区', NULL, NULL, 1475, '2ca74ae0-5e04-4119-84d8-187921fe4056', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('076484e6-e6d2-4362-97f3-f0b6eb8abca2', '拖市镇', NULL, NULL, 2141, '671275c4-6107-4968-bd8e-96d53e9995b2', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('07979289-44dd-4f45-be7a-9ba0cae5f484', '额敏县', NULL, NULL, 2720, 'a419fd83-e078-4430-aa48-ca9aa67e4fff', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('079c08fa-27e1-45bb-9ccc-f088cc86bd5e', '集美区', NULL, NULL, 1211, '9122834d-aef5-4895-974e-82d2f568bcd4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('07a7bd92-dc8b-4acb-b20a-941bf8fc991d', '佛子山镇', NULL, NULL, 2139, '671275c4-6107-4968-bd8e-96d53e9995b2', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('07bedc34-548e-4881-80d3-d7237931921b', '石桥乡', NULL, NULL, 4464, '4888e1e9-ba45-4254-83e7-87796f338e2d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('07c0308b-96f0-437a-8263-aec488fc3f6b', '惠民乡', NULL, NULL, 1136, '72d4f69f-2e4c-4bde-9df8-2aadc9168686', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('07d136df-9f20-4359-8b3a-4755b9d7a09f', '尖峰岭林业公司', NULL, NULL, 2563, 'a1e3332c-7029-4de7-a221-40c041a9a620', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('07d16179-1c05-4cb2-90b3-93fb702b9450', '博湖县', NULL, NULL, 3176, '0ce20b86-8bea-4d7c-a1e4-09c7519d8b16', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('07d965c6-4085-4349-bace-1d1037494958', '道滘镇', NULL, NULL, 3334, '3bc6861d-0eeb-497e-9257-42f9cd6fd26f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('07dfe1d9-80f9-411d-9aa5-8107d3501255', '河口区', NULL, NULL, 1213, '1de2a515-79f9-47f9-a31f-f6892f97a705', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('07ff8852-a47f-4da4-be0a-8354c37d8a08', '马武镇', NULL, NULL, 1119, '72d4f69f-2e4c-4bde-9df8-2aadc9168686', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0818d25d-5116-40ad-8124-2e2c35278270', '木棠镇', NULL, NULL, 3208, '2e21ea75-c640-4928-8cb4-e5ba4f6e2ffe', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('081bc3e6-ded5-4ecd-81f8-73078a628303', '港南区', NULL, NULL, 3017, 'eb4d8886-4710-4809-8f77-b3caa4b4904e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('08266783-13f5-4bf2-ad9b-fae5c1e63c2b', '广坝农场', NULL, NULL, 3614, '46073b56-9ab9-4efb-874f-efe112a304a6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0829851b-186f-475c-9e61-403c29bdc25a', '米易县', NULL, NULL, 1666, '8e1185d8-66bf-4f53-8ffc-ae9aad60cac2', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('082f6100-7051-4ff2-9197-e78168cf90e7', '苏仙区', NULL, NULL, 1316, '50d6a2ea-ba0d-4ff5-8b4c-f9d84e79e381', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0833cb2c-d3f6-4cfd-8e0d-732a5b57360d', '宣化区', NULL, NULL, 134, '37614653-bf6c-458f-a844-540790491eb1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0840fa84-8962-4713-a7de-850df2195445', '富源县', NULL, NULL, 1330, '9568bdcc-65c2-4b1c-a512-b2ff897db321', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('08491d37-269c-4fa1-89fb-5ff2812ac0c4', '南田农场', NULL, NULL, 3063, 'e60d3fe5-6d26-4a3f-b920-8fb6c4986bfb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0849338e-1e3c-4deb-b525-07a9e63a0689', '滕州市', NULL, NULL, 1411, '8e4df698-c772-488a-acf8-70e7d4adebd2', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('084ffd56-3963-4929-8355-47bd15d961f9', '任城区', NULL, NULL, 2831, '5c8748b9-cee3-4d8e-956c-0d0e24db8850', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0877bb7d-a0f4-46b9-83cf-c445fe56fa86', '长阳镇', NULL, NULL, 71, '0863a0a5-7ac5-4a13-80f5-d31e3a1aa459', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('08784603-1fa4-4fc5-8100-f7ee8f171f63', '礼纪镇', NULL, NULL, 4488, 'f491d9c3-9527-46a4-8954-6795ff079478', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0887b9e5-bac2-49ea-95a5-162bde2425b4', '兴山县', NULL, NULL, 1784, '3760382f-ecb5-4ef6-8bd2-049afe34b574', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('08b25110-f30f-4c27-90b2-afd33dc4b788', '黄石镇', NULL, NULL, 170, '4f867632-2989-4def-9934-a9c5fe0d5ca5', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('08b44165-2930-42f0-9990-56db412de658', '随县', NULL, NULL, 2276, '5da76347-cb7e-4817-b07a-985010b9c63a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('08b6f8c3-d66b-4fdf-aa7a-ed010acc90b0', '龙溪镇', NULL, NULL, 367, '76dd00a1-30a1-4226-ae06-cad845c0528c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('08c22589-6c76-4beb-aa88-48f5878bc2ac', '马尾区', NULL, NULL, 4246, '71a49c5c-c3c2-4fcb-8f90-aa1d733a19f7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('08c788bf-272f-4830-9a97-43b223f33493', '铜鼓镇', NULL, NULL, 2513, 'd998f8bc-c659-47ce-8e5e-a6b29e03ecb3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('08d5e503-8899-4541-9e99-ab9e9f36cb0b', '淅川县', NULL, NULL, 736, 'a769a530-0bcf-4e52-a9e5-3a8f5af945d2', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('08ec1ae2-9214-4b19-804b-5c47f2847aaf', '花台乡', NULL, NULL, 1587, 'ac0e6e50-b6a1-457c-811c-06ac309cd5a3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('09029c34-2146-4486-a80e-d4918b833e47', '盂县', NULL, NULL, 2115, 'c3c4411b-8905-45b4-b38f-09be90102664', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('090daca7-b8b2-4233-b4b1-f77e7b95be40', '王益区', NULL, NULL, 914, '667720b0-8429-42ef-b6a6-582df9b59468', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0912dd38-148d-4cd8-a6a4-a35253b1a1bd', '化州市', NULL, NULL, 696, '88bc9baa-b7fd-4bf4-a896-4e049185e0c2', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('09190efc-71c5-42e0-9756-2808c9469d23', '庙堂乡', NULL, NULL, 369, '76dd00a1-30a1-4226-ae06-cad845c0528c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('09249bca-9e96-4382-b7a5-71368bc47d03', '县城内', NULL, NULL, 1902, '2c8bc8c3-9317-4f36-a0ad-05a8d6b27053', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('092c94e1-1a7e-49cb-aa13-13c7c4267619', '凌云县', NULL, NULL, 1229, 'f56fa64d-ca06-49d2-a9cb-94742a33af21', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('092fa148-0444-4233-aa30-3307fd6122c8', '常山县', NULL, NULL, 2816, 'b2a03fc9-88f2-4734-9af2-7234863d0f87', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0953612b-f74c-4150-b941-04173d96b3d6', '铜山区', NULL, NULL, 4429, 'e20441c5-c8b4-493a-9738-2327e656fbcb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('095cd87d-2e62-4073-8d22-7ceae8043347', '焦石镇', NULL, NULL, 1115, '72d4f69f-2e4c-4bde-9df8-2aadc9168686', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('096b5b35-8115-41b3-99f3-1241b5d240c6', '东英镇', NULL, NULL, 718, '0be5e1cb-cdb0-48ca-9f82-47f7f4c6dd2e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('09761f17-fec8-40cd-9e82-320a9dffef85', '涵江区', NULL, NULL, 9, '7acdab30-849a-4c32-b081-8cbdc15f711a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('09778cd9-b339-40f4-ac51-02469d2c8e0b', '峨蔓镇', NULL, NULL, 3210, '2e21ea75-c640-4928-8cb4-e5ba4f6e2ffe', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('097d0563-7ac7-4be2-be53-70577ccf1efc', '新沂市', NULL, NULL, 4427, 'e20441c5-c8b4-493a-9738-2327e656fbcb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0990f4c9-9251-4493-bb05-219e3b211b43', '梅县', NULL, NULL, 4390, '2aabe025-ea3b-4ce4-885f-9ecf122b3e79', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('09a61c7b-9957-48aa-9bb8-9afee43f8816', '内环到三环里', NULL, NULL, 4008, 'e6e5b9bd-f324-448f-8776-8e7eb18ca5d4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('09ac063e-fa55-4af0-b1a6-78e10e09b422', '青云谱区', NULL, NULL, 1278, 'cf24a0a2-c56e-45df-920c-8247c771d48e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('09bc81d3-56e6-4142-a1de-cea24331f570', '蓬安县', NULL, NULL, 1255, '71643995-698f-4bdf-afe9-09fce8a065c0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('09e7bd4a-656f-4550-9f2c-e2e798444cea', '泖港镇', NULL, NULL, 92, '3e082d1b-ecb4-4bf8-8715-54132a9106e1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('09e90d84-6170-4040-9fe1-3a06660115aa', '尖扎县', NULL, NULL, 2057, 'c9781b3d-f13b-42a5-962f-df7de65d2033', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('09fa3568-f443-474c-8aa2-23b2f8beff2c', '三元区', NULL, NULL, 281, 'cae0a47d-0d79-4fa6-aac9-e8b3b535ee3c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0a11866c-b313-474c-b81e-194d924a59bf', '霍邱县', NULL, NULL, 284, '4ee9594e-d779-4cad-a3bc-d766de26628a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0a36cb85-2ea5-46ee-9969-aec18a540954', '错那县', NULL, NULL, 1022, 'f7038861-43d2-49c3-a5c9-53fde2c139fa', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0a3f674f-24bf-4681-bf57-12ea57a1fb92', '鸡东县', NULL, NULL, 2418, 'f583e1ae-7239-4815-b3c7-c5538eb73da9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0a448a70-3c66-4fb5-b54f-1264405bbcda', '合水县', NULL, NULL, 1768, '61cc258d-1868-4356-bcbc-2e8b118745ca', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0a48dc03-0dff-42d0-881a-f6fe3ae856f0', '双土镇', NULL, NULL, 182, '4f867632-2989-4def-9934-a9c5fe0d5ca5', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0a5c8853-7e9d-4272-8a23-40393bfa63e8', '朔城区', NULL, NULL, 2066, '49bad2d2-0c83-48ed-9985-7a709362f3a8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0a72a3a2-4b24-4138-be25-113e7f80563b', '什运乡', NULL, NULL, 2290, 'b3792f06-9c78-446e-b6ac-d95d5e9092e8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0a776d7a-087e-4253-8b9a-309ddf54b823', '篆塘镇', NULL, NULL, 3672, '6581d8db-553e-4417-8c37-91ed47904920', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0a79b2fb-3a35-4dc7-ba71-ebbea79fa3d7', '裴兴乡', NULL, NULL, 1497, '89e8be16-b810-4c7e-89f0-aa9f24483b98', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0aaf0d72-929e-41f0-877e-4b4854f79481', '巩义市', NULL, NULL, 4122, '4ff4ef6c-41df-4562-a58f-d8b25b2e3ba4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0aafbab5-2d88-4039-ae63-1cdaa2028653', '桦甸市', NULL, NULL, 1951, 'a4031322-7fba-466a-ba72-50082ab248c6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0ab852a3-3540-4848-b8f8-b2c4aaf34584', '五常市', NULL, NULL, 1531, '349a18f4-4117-490c-b26f-80702a4911bf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0ac9f1f8-c555-4b46-86ea-3f95c7eaf6e6', '郭家沱镇', NULL, NULL, 1715, '86ab4d11-9653-4b0d-8cc1-2e12a4de15d6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0acab854-b576-4656-9636-5551b28666ab', '厚坝镇', NULL, NULL, 3252, 'a39ced08-b6e9-4de0-a2db-7a230a673d1e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0af09fa1-c979-4d52-8b27-3cc034880fe2', '辉南县', NULL, NULL, 869, 'def0f6fb-9804-4bed-8554-2115bfca9849', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0b09b791-48cd-40b6-a97a-f1012357b080', '练塘镇', NULL, NULL, 2544, '89a9c37c-487a-4c32-968c-cf9fefad8151', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0b1551ce-8f27-4405-9b20-a267967dfda7', '镇原县', NULL, NULL, 1767, '61cc258d-1868-4356-bcbc-2e8b118745ca', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0b2f1f0f-2bd5-4624-ae91-e488800f4446', '汤阴县', NULL, NULL, 2575, 'd94ce52b-fe8c-47d7-9b1a-d37da377cbbe', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0b352618-fb3f-4293-a16a-df844a98e9b4', '古龙镇', NULL, NULL, 1659, 'a560b8db-8db1-4bc8-bb6b-fbbecebcaf10', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0b410113-ccf3-4e8a-aa2f-55671b65c532', '官渡镇', NULL, NULL, 3876, 'a732da28-870c-4d9c-a287-c2c1e3222b59', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0b49f5d5-83cd-4df7-8506-eb7cec35716d', '芙蓉区', NULL, NULL, 621, 'dccf3d25-c012-444b-94c6-bbcbae7e63d8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0b548680-1b83-4ac2-8af4-8274bf329c84', '深水埗区', NULL, NULL, 477, 'dfb8b556-10a2-43ab-9fdb-66cde92320ee', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0b7b32dd-c1f0-429a-8022-5edd5262984b', '舟曲县', NULL, NULL, 3130, '9d7c5001-b115-4bea-abb4-a289a03b5075', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0b93e8c8-8755-497d-acc5-8e99cd49f2c0', '沿河土家族自治县', NULL, NULL, 2876, 'dce7fe20-4766-408d-92be-62ba8fbb7a43', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0ba93be8-bfaf-4934-b759-6a2a417e794b', '晋安区', NULL, NULL, 4244, '71a49c5c-c3c2-4fcb-8f90-aa1d733a19f7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0baa2b16-231a-45c4-b308-05a312774e79', '佘山镇', NULL, NULL, 87, '3e082d1b-ecb4-4bf8-8715-54132a9106e1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0bcdcda3-9e71-45f0-9e9c-b8d1cb8b7340', '汤旺河区', NULL, NULL, 466, '7ca3412f-b06b-467e-b547-691ab8327b15', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0bddb2a4-fde6-4b06-8d04-289bf6c598f2', '武陵源区', NULL, NULL, 333, '1af0c5e6-6728-445e-9278-f1eaf5c6303a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0bece3f1-692a-4e53-a637-358f4c56e8e0', '大河乡', NULL, NULL, 1585, 'ac0e6e50-b6a1-457c-811c-06ac309cd5a3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0c11b36b-842e-4606-ba00-70823ccfab1e', '镇海区', NULL, NULL, 1672, 'c5cc1924-02da-4927-982d-54f0b9f70ef8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0c155680-3dce-41fe-a88a-0a6e034a591f', '大观镇', NULL, NULL, 642, 'd7f44c2a-2728-4633-a8b6-7643136bc99d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0c26852f-6fd2-4d6d-ba6d-16ccdd92816e', '河曲县', NULL, NULL, 2841, '18b3c51b-f699-467d-a342-d78bf9cff362', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0c2f094f-96e8-4adb-925c-798148d10eca', '方正县', NULL, NULL, 1532, '349a18f4-4117-490c-b26f-80702a4911bf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0c3386b1-592c-4fc2-b74e-86f8ed0f8c94', '吊罗山林业公司', NULL, NULL, 556, 'b75db043-9782-4bae-aaee-bea49fc286e6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0c723e50-529c-4751-a4ff-b524ccbe36f8', '石家乡', NULL, NULL, 820, '0f559985-f6fe-4a8f-af80-3d0d64932dbc', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0ca91b02-b066-4591-91e8-443cb216e295', '白石乡', NULL, NULL, 3371, 'aa2f26e5-9705-4dc0-b54a-a2d7dbb8b511', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0cc02930-2ec2-49b9-92b6-3fb4537f30c9', '横峰县', NULL, NULL, 498, '8bf55045-9366-4acb-b884-bca672ff9644', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0cd0a949-7938-462b-a9ae-04be412af3c0', '孙家镇', NULL, NULL, 4214, '0ee28cef-8dfc-4a9f-b7c1-330bc11c1bb3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0cd9304c-77cc-4749-882d-9fa2dbb2f62b', '鼓楼区', NULL, NULL, 1867, 'adb7aa6e-99a6-453f-a2db-21ecfbc44874', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0ce0811e-fa67-4824-b5ec-89f69b158c25', '阳曲县', NULL, NULL, 105, 'de59cca6-548c-4009-9776-5daae2b866a6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0cfb8b11-9ddc-4e3a-8839-268a05c38593', '南林乡', NULL, NULL, 2998, '4b3478d4-3e85-4143-bc6f-ac4a338a9d47', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0d1a6408-b221-494b-9c91-7050bdc87f0b', '汉川市', NULL, NULL, 2752, 'caa97f6a-9b5e-4871-968e-42852537e6f0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0d2dfddc-1f28-48a0-bc73-fc2f7c1fd0c3', '乌当区', NULL, NULL, 540, '46abe060-5805-4aaf-9d89-b66bed4b224e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0d3c12bc-1334-4656-87cc-b6f05fc48fe6', '梨园镇', NULL, NULL, 2125, '88d84710-80d6-4837-b889-286c74d7940d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0d3de818-5571-4443-9229-6bf4f5c4f760', '察哈尔右翼中旗', NULL, NULL, 3968, 'a061ae4e-1b4e-4b42-8aa9-cc6bbae9619a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0d4b638d-3fd4-42a0-9dec-194b4091a2ef', '宜兴市', NULL, NULL, 2217, 'e658aec8-1268-4349-a3f5-570b669a4f06', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0d716435-75bd-452d-9573-6d2a0704c284', '龙井乡', NULL, NULL, 382, '76dd00a1-30a1-4226-ae06-cad845c0528c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0d8348b3-7132-4ad8-aee6-7695b7bdf76d', '石林镇', NULL, NULL, 3679, '6581d8db-553e-4417-8c37-91ed47904920', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0d92f8d6-4f96-4742-8d2e-a33decbf8c8c', '宣威市', NULL, NULL, 1329, '9568bdcc-65c2-4b1c-a512-b2ff897db321', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0dbc0fd0-c7e8-40c2-99b8-0166fadf834c', '锦江区', NULL, NULL, 1802, '4f073365-4e02-459f-8b32-cad88dd22637', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0dbdb94e-0444-4913-9acd-1428d486dae5', '武平县', NULL, NULL, 3349, '381b5351-4075-4ec0-88cd-f3e1da71c110', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0dc44b95-2173-4e3f-b5df-339208431414', '南票区', NULL, NULL, 962, '1671eb17-f102-4972-9d41-7b1463da334d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0dc568ac-bc23-425d-a648-64e79c5dd0db', '马村区', NULL, NULL, 4017, 'e95972c4-fd28-45ac-b9da-9aee0057d3d0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0dcf16c2-b3fd-4391-8e34-4e0ad08cb210', '沙子镇', NULL, NULL, 800, '0f559985-f6fe-4a8f-af80-3d0d64932dbc', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0dd848e1-6076-4ef9-b00a-340e8cd53065', '玉屏侗族自治县', NULL, NULL, 2878, 'dce7fe20-4766-408d-92be-62ba8fbb7a43', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0de48728-1ad5-4da8-b1e4-ad1bfb6c671b', '邹城市', NULL, NULL, 2827, '5c8748b9-cee3-4d8e-956c-0d0e24db8850', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0df037da-e1d4-43b1-8b73-a3bd0d36d53c', '景县', NULL, NULL, 2473, 'b126935b-0423-4bea-b802-d4e6680d1d71', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0dfebfcc-d120-47a4-8dde-f05bad1ae2ce', '湘乡市', NULL, NULL, 4311, '40852955-b0b0-4a50-b4b2-201be5c3808b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0dffed95-4e13-407e-ba85-972bed445b9a', '大观区', NULL, NULL, 3587, '818f3bc6-83b9-4d90-8e68-566cc7c2bb14', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0e11136c-f041-4d49-9d88-bf46e0cacdb8', '杜集区', NULL, NULL, 2245, '8afb487f-de86-4a5b-9abc-27ae2c07797d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0e116ee9-85f8-4454-af04-c45f9e3fbf38', '和静县', NULL, NULL, 3175, '0ce20b86-8bea-4d7c-a1e4-09c7519d8b16', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0e1b7fcd-ffed-47d3-b358-8dfaa374b0fe', '柏家镇', NULL, NULL, 640, 'd7f44c2a-2728-4633-a8b6-7643136bc99d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0e1fdc25-cf4f-4ea3-9491-451e626b6850', '城区', NULL, NULL, 31, '43c813e3-8672-45c5-8d3e-9ee43dbe51c8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0e4b6b6f-5be8-4150-85a3-48dfc9d82df9', '新民镇', NULL, NULL, 1486, '89e8be16-b810-4c7e-89f0-aa9f24483b98', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0e4e1edd-5bcb-408a-881d-f43c4cfb56ab', '悦来镇', NULL, NULL, 703, '97942649-3cc7-4e4a-81b4-9a8c82f82ea7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0e59117d-7afc-4820-9059-b1804106eac2', '藤县', NULL, NULL, 3037, '01d0a041-f2c0-4416-b710-9376b2aabcaf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0e5cd0ef-aa87-45e3-b727-0015b805e1a3', '兴宁市', NULL, NULL, 4389, '2aabe025-ea3b-4ce4-885f-9ecf122b3e79', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0e652241-e420-47c7-ab96-1ee56f00afad', '谢岗镇', NULL, NULL, 3345, '3bc6861d-0eeb-497e-9257-42f9cd6fd26f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0e8694df-dad2-45b2-a1c9-7d2d4cc0eee0', '双路镇', NULL, NULL, 1661, 'a560b8db-8db1-4bc8-bb6b-fbbecebcaf10', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0e899ec3-db71-45fe-8bfc-9ab24a9b53dc', '黎场乡', NULL, NULL, 814, '0f559985-f6fe-4a8f-af80-3d0d64932dbc', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0e8fca45-bdb0-435e-90a8-213aaf73c3d7', '花溪区', NULL, NULL, 533, '46abe060-5805-4aaf-9d89-b66bed4b224e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0e9a48c7-381a-4f9d-9d57-a4cde0531e53', '武川县', NULL, NULL, 1266, '1fdea9c2-419d-4fd5-b725-8d361e4376fb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0ec16768-1f5b-4bdc-822e-eebf285ae77f', '海阳市', NULL, NULL, 597, 'f3717726-7743-4838-852b-3a09f9528a69', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0ed21d55-7035-416d-9cf0-64cd856a4e3a', '延川县', NULL, NULL, 3400, 'f95958de-a678-4371-9710-6bcac3f425fa', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0ed41ddc-fb62-4251-85e8-53aa463a8ef7', '虹桥镇', NULL, NULL, 4024, 'f6eb800d-2093-4ce2-8105-3747d69abe97', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0eebf6a5-7f8b-45c9-b738-6c9ebcfa9660', '观山湖区', NULL, NULL, 541, '46abe060-5805-4aaf-9d89-b66bed4b224e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0ef207c5-add1-4c13-886b-6ecb7c1d408e', '安定区', NULL, NULL, 3121, 'fc26f78a-1b0b-4967-8d26-df9e530e5260', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0ef5b59b-4031-4756-8fc7-e609d364f4cf', '白土乡', NULL, NULL, 3372, 'aa2f26e5-9705-4dc0-b54a-a2d7dbb8b511', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0f00ad98-d94c-4c6a-a9c6-45f6357d7f93', '王家镇', NULL, NULL, 702, '97942649-3cc7-4e4a-81b4-9a8c82f82ea7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0f013751-9561-4144-9ead-acabb9d47ba6', '西峰区', NULL, NULL, 1766, '61cc258d-1868-4356-bcbc-2e8b118745ca', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0f0179b4-4a7a-4855-97d1-e7f3692ce565', '蒲莲乡', NULL, NULL, 1590, 'ac0e6e50-b6a1-457c-811c-06ac309cd5a3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0f0b728d-5908-4460-af79-b1f7459f8930', '罗江县', NULL, NULL, 3621, 'b2c794cc-d351-415b-b53c-cf0c454c1165', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0f2b3d48-a3c3-443d-add8-3493a52ac9a3', '回龙镇', NULL, NULL, 647, 'd7f44c2a-2728-4633-a8b6-7643136bc99d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0f3dcc13-a3ad-4db1-b43a-cd3a1a7cf376', '西二旗', NULL, NULL, 4377, '27537995-4520-4156-95b5-b3d1e368a5dc', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0f4625d6-a65e-467e-aa3a-63c991c7bd7e', '大埔区', NULL, NULL, 487, 'dfb8b556-10a2-43ab-9fdb-66cde92320ee', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0f50adce-af4d-46f1-a2c1-e0bbe290fda9', '海门市', NULL, NULL, 1750, '7de09763-759b-437b-a3aa-4cb32bd3c6b9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0f66f5c5-a744-4fb2-8871-61e2b2ae246f', '开化县', NULL, NULL, 2817, 'b2a03fc9-88f2-4734-9af2-7234863d0f87', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0f7c8229-bbef-4399-8106-ffbed8e3f02a', '六环外(马驹桥镇)', NULL, NULL, 2136, '88d84710-80d6-4837-b889-286c74d7940d',
        1, 'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0f7c94a0-88d9-4413-9259-cc173ad7f649', '兴文县', NULL, NULL, 1824, '18a8dd20-aad4-43cd-ab48-ab6108097d8a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0f8d2824-21e2-4507-a4fb-f9617c8c355d', '宋洛乡', NULL, NULL, 3074, '4b20c67b-06ca-4c0b-a947-bc518238537e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0f91b325-4dab-45d0-8ace-5f4ea2f698d1', '红坪镇', NULL, NULL, 3072, '4b20c67b-06ca-4c0b-a947-bc518238537e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0f96816f-15d1-4036-a197-9986dc87a0aa', '碾子山区', NULL, NULL, 2731, 'f4e36f9a-e006-44a6-8d77-47971d41810b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0fa818ae-24ae-426c-912a-b40e57b7c639', '徽县', NULL, NULL, 1373, '7c9ca39d-ce8f-469d-899a-09a0a29c1541', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0fac17b4-ef3a-42bd-907e-f88e5f3ccf0c', '新村乡', NULL, NULL, 1150, '72d4f69f-2e4c-4bde-9df8-2aadc9168686', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0fb1bb15-b7c9-49db-8c86-652e6459cd75', '仪征市', NULL, NULL, 3052, 'f9ca7af3-a2b5-4d1c-a8c5-c4dbe4fe60e1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0fbf90d4-85f2-46b5-a64e-d02cfe43ed0c', '大港油田', NULL, NULL, 1364, '5a1e74c1-6f4c-440f-8ade-ac470f4ada87', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0fca813a-9531-44eb-9d94-b3f338067000', '中塘乡', NULL, NULL, 3382, 'aa2f26e5-9705-4dc0-b54a-a2d7dbb8b511', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0fe43d33-a718-4cab-a8bf-d0a28ccaa68a', '远安县', NULL, NULL, 1785, '3760382f-ecb5-4ef6-8bd2-049afe34b574', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0ff10b1f-3188-4136-8f47-812c0a71909d', '嫩江县', NULL, NULL, 1427, 'e27d8c07-338c-4b1a-b45c-cf9cf0a22a0c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('0ffb717f-db09-4f16-88ba-d0370fc55b65', '刘斌堡乡', NULL, NULL, 1515, 'd5ab951d-20ab-46ff-8838-de5efe06b6b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1013364b-a4af-4c9b-926a-b5d3fc7b35d6', '凤冈县', NULL, NULL, 3431, '69324865-24e8-4abe-a068-a1392c117c0d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1026095a-3305-478e-95ef-77c3de103b26', '赵家乡', NULL, NULL, 4469, '4888e1e9-ba45-4254-83e7-87796f338e2d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('102fa91e-7455-49df-9555-d51a1d9cb96d', '延津县', NULL, NULL, 2182, '1aabde9d-2b04-4892-a20d-5b4e3efaeedf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('10409b22-b2ad-457c-8c8f-496ec3f5dca0', '满月乡', NULL, NULL, 3272, 'a39ced08-b6e9-4de0-a2db-7a230a673d1e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('105d06cd-867c-41f8-858d-db2de9407662', '渔洋镇', NULL, NULL, 830, '24ad0708-80a9-43b1-8e1c-758f2492d3f6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('106e5b17-a9f0-4fe4-842e-ced66404d180', '昆都仑区', NULL, NULL, 2054, 'd4910db5-a704-4273-bd13-a6dc05f468cf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('107edf5a-ac84-4ea4-91d6-665b59ca1927', '杏花岭区', NULL, NULL, 103, 'de59cca6-548c-4009-9776-5daae2b866a6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1083c655-aef9-4910-96fb-9f32da0457cc', '塘河镇', NULL, NULL, 903, '41f376c0-764f-46b9-af35-e555518fc613', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1087b86b-af9e-4fe8-86af-115f985fb117', '建宁县', NULL, NULL, 275, 'cae0a47d-0d79-4fa6-aac9-e8b3b535ee3c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('108f0d88-353a-4d48-a3dd-f62f304b32b1', '吕巷镇', NULL, NULL, 2705, '0e5598a8-f405-4745-8cd5-a7a4c99f67f9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('10ad37eb-4da5-46fe-a022-e2b839c0dbe3', '新市区', NULL, NULL, 3233, '8349c2b0-91a2-4e19-b9c7-81b5224fbabe', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('10ad9477-be4a-486f-a728-575dc5451fe1', '光村镇', NULL, NULL, 3207, '2e21ea75-c640-4928-8cb4-e5ba4f6e2ffe', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('10be9ce5-85b8-4e8c-8352-fa28b7a87144', '洪泽县', NULL, NULL, 755, '3c9ba44c-7031-4422-b9b7-85d772ee3e08', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('10bfac8f-bbe7-41b3-b600-251e2c03e306', '惠安县', NULL, NULL, 1855, '0d3bd52a-74b2-4461-9a57-17c7cce4ac1b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('10d4c508-0f16-4c1b-b765-b40531609ade', '鄂托克前旗', NULL, NULL, 3535, 'eb551697-7acc-4bcd-9d21-3d48c16f8258', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('10db426a-c784-4457-9c09-54bed225486e', '岑溪市', NULL, NULL, 3035, '01d0a041-f2c0-4416-b710-9376b2aabcaf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('10ef605e-8243-4d66-9992-a399620302da', '湛普镇', NULL, NULL, 1931, '442f465d-6566-45e4-9338-50f4395aa6f7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('11175cda-51ce-41e8-9bc5-e1f3dbd2016b', '城桥镇', NULL, NULL, 3981, 'fcc07455-c69c-4c90-82cb-ddb268adb8a9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1126c751-cd8d-41b8-bb57-f33b3a5d39b7', '江阴市', NULL, NULL, 2216, 'e658aec8-1268-4349-a3f5-570b669a4f06', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('112db321-7852-429f-9692-1cb0e3d3ed87', '和谦镇', NULL, NULL, 3250, 'a39ced08-b6e9-4de0-a2db-7a230a673d1e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1142459b-0082-44b5-a5b6-7517f21f5491', '吉利区', NULL, NULL, 1180, 'b5a118ad-786c-4d86-b4e8-5d25a3776a78', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('11749ec4-e2b2-46aa-a966-7a30f70e44d6', '天竺地区', NULL, NULL, 3740, 'd1c1539c-b904-4bcc-a034-96213f63d0ff', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('11937360-248a-4978-945b-9690f5c9c1f5', '镇沅县', NULL, NULL, 1707, 'db61cc5b-b13b-417f-a232-7925ffdfa9b2', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1199a1b5-3331-4517-bacb-abb50c19ebe8', '上饶县', NULL, NULL, 504, '8bf55045-9366-4acb-b884-bca672ff9644', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('11aadf4a-3aa8-45ee-a941-7c3c64cec998', '太康县', NULL, NULL, 2296, 'f3e12d68-f8c5-4d9d-8314-dd1ce7dac2f9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('11aca5f1-f09b-4e81-b565-5a813f1759e6', '阿鲁科尔沁旗', NULL, NULL, 4481, '4b199fdb-3a49-40f7-9843-8bd43f4ea30c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('11b1cc2b-c5a8-4130-a45f-3fa0beb54c92', '东河镇', NULL, NULL, 3605, '46073b56-9ab9-4efb-874f-efe112a304a6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('11c30703-2680-4eb8-b247-a8d35ecff5ff', '高升镇', NULL, NULL, 1657, 'a560b8db-8db1-4bc8-bb6b-fbbecebcaf10', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('11f3eb82-5dd2-45b9-a996-61f5e2692e59', '车田乡', NULL, NULL, 2914, '465e9ea2-a2f2-4b42-95dd-b48d91f67105', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('120230f5-1b52-4d29-8ea9-8036204c9ace', '双柏县', NULL, NULL, 2096, '50868d97-8741-48fe-9cba-86e2e118f220', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('120cc562-a0f6-4d18-a03a-2025dcc79c12', '神池县', NULL, NULL, 2834, '18b3c51b-f699-467d-a342-d78bf9cff362', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('121aa05b-d846-4298-8b01-2da599732a22', '石排镇', NULL, NULL, 3333, '3bc6861d-0eeb-497e-9257-42f9cd6fd26f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('121e8184-ea90-4ec2-af8a-a379640240ee', '干川乡', NULL, NULL, 982, 'cc124ed6-091a-42ce-a87a-bb4d0d7357b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1220aaee-e0f7-4e59-947b-c2e66afdd49e', '金峰镇', NULL, NULL, 3240, 'a39ced08-b6e9-4de0-a2db-7a230a673d1e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1223e9e1-f9db-4e77-a288-afb4fa4194b8', '资源县', NULL, NULL, 3196, '796bb0e0-6b76-4c1d-801f-2dbcbab74087', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('123127a9-1950-47f5-a3a0-45d1f96385d5', '荔城区', NULL, NULL, 7, '7acdab30-849a-4c32-b081-8cbdc15f711a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('12390b3e-eb2c-4ef3-8281-cef348ffee16', '南镇县', NULL, NULL, 340, '5c4e7f63-9162-47e1-a948-c64ca46ff566', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('123b7fa8-87f0-4c41-9bff-4cbe7270b756', '察哈尔右翼前旗', NULL, NULL, 3967, 'a061ae4e-1b4e-4b42-8aa9-cc6bbae9619a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('12536a3f-2ef3-4f14-9ebc-c0bf4c32f28e', '王平镇', NULL, NULL, 3574, '5d21af6a-f035-42f4-a0cf-ff1fd3d36f3b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1256a5c9-8b55-40fb-9dcd-e92766f55d10', '万江区', NULL, NULL, 3321, '3bc6861d-0eeb-497e-9257-42f9cd6fd26f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('125c1854-0937-4cb9-a05e-f489383dbfcf', '栖霞乡', NULL, NULL, 192, '4f867632-2989-4def-9934-a9c5fe0d5ca5', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('126d1c86-1680-4046-b0ef-d022ab1804b1', '兴和县', NULL, NULL, 3961, 'a061ae4e-1b4e-4b42-8aa9-cc6bbae9619a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('126ddd27-80dc-4e10-b6ea-1a80351c409e', '安宁区', NULL, NULL, 4041, '2d364b6d-2931-4d45-995a-336e4e0f2b55', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('12704d5e-23e1-4e30-a7ac-4c70d1c29c4e', '洛浦县', NULL, NULL, 851, '60e9ec7d-f371-4ea9-ace3-b13c1cd7081c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1281317b-8f81-4887-9273-7e817b260991', '武宣县', NULL, NULL, 2168, 'f63c9587-7455-4dff-950d-0da6dddd16c1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('12a22fbd-3bfa-4730-8b55-c8820a60cdab', '岳西县', NULL, NULL, 3584, '818f3bc6-83b9-4d90-8e68-566cc7c2bb14', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('12b450e0-c6ec-4be2-b656-b858b7777f30', '石阡县', NULL, NULL, 2874, 'dce7fe20-4766-408d-92be-62ba8fbb7a43', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('12bb712b-45db-4456-b99d-6b452a1e5aed', '南俸农场', NULL, NULL, 1461, '81aab36f-0e28-4ba3-9827-b7033fce9b24', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('12c25890-4459-4b37-b49c-df545d258408', '克什克腾旗', NULL, NULL, 4476, '4b199fdb-3a49-40f7-9843-8bd43f4ea30c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('12d4cacc-12db-400c-97df-fda544f66227', '大安山乡', NULL, NULL, 51, '0863a0a5-7ac5-4a13-80f5-d31e3a1aa459', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('12dbecb9-2c5c-475f-85a2-c48278dbf867', '杨村镇、下朱庄内', NULL, NULL, 2537, '1643aaaf-a1e0-4b6b-8953-28c93dce03e0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('12e1a28f-90e9-465c-b985-899968fc6988', '响水镇', NULL, NULL, 2994, '4b3478d4-3e85-4143-bc6f-ac4a338a9d47', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('12e4c760-485a-45cb-b897-057ec6026205', '宣汉县', NULL, NULL, 1008, '6681b8cd-3740-4dbd-b311-143871994e15', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('12e90f81-8235-480a-8809-ca900ca0a79c', '金铃乡', NULL, NULL, 811, '0f559985-f6fe-4a8f-af80-3d0d64932dbc', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('12eccff7-bb01-4727-80b3-e1960a1f7d34', '杨行镇', NULL, NULL, 765, 'c470aa47-a334-4df9-a8ea-b90683ddc861', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1315671c-a422-4bd6-bda9-d6dbe07b7501', '姜家镇', NULL, NULL, 46, '43c813e3-8672-45c5-8d3e-9ee43dbe51c8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1317644e-ecc6-4480-9bf9-d8ccd633ac90', '龙河镇', NULL, NULL, 2082, '4686b935-e3f0-4173-bdfe-ab6a5450d1a8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('131f3e4c-2068-4e1a-b8c1-d347f4023359', '三环到四环之间', NULL, NULL, 1700, '576c43af-0a86-47d9-83a7-4989ce3b3dc7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1322d3d0-ee83-4d55-965f-bfdf961c815d', '康县', NULL, NULL, 1369, '7c9ca39d-ce8f-469d-899a-09a0a29c1541', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('132806b9-b592-4552-aacb-ea8eaf8f6f8c', '阿坝县', NULL, NULL, 1193, 'd56c2ee6-b81c-4df8-ba2f-3df7680243c4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1334c9e3-1b83-41f0-ad0b-b551c178807f', '扶欢镇', NULL, NULL, 3660, '6581d8db-553e-4417-8c37-91ed47904920', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1338bd26-c127-4a22-b687-48387371106b', '瓜州县', NULL, NULL, 2428, '42852584-118b-41cf-ba7e-db28102a593a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('133fe514-a6ad-4f1d-9b88-de0af5c9c937', '太仆寺旗', NULL, NULL, 2346, '67723aea-a4ef-4eb7-afbf-55cc07806f98', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1352c20e-feca-440b-a4a7-730881d3dbe2', '仙龙镇', NULL, NULL, 415, '9d7d52af-ec34-48e3-b81d-09ac51e11590', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1358ce8f-910d-4efb-8064-095c37b7ae03', '庆城县', NULL, NULL, 1765, '61cc258d-1868-4356-bcbc-2e8b118745ca', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('136412d3-ea2b-42b4-98e4-de938124091f', '古县', NULL, NULL, 3700, '1aeeea9e-d028-4a96-94ce-ba84cdd3e69f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('13663041-4f0b-40a4-9514-76e358581167', '铁山区', NULL, NULL, 3914, 'b3b5e655-b2df-467e-ad5f-2ab21c2a0aba', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('13766546-00c3-4764-b1db-ef9068d2260c', '确山县', NULL, NULL, 742, 'a096e337-c439-4751-a014-b49dd13bee26', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('13802fe5-a8fc-4a97-a058-7e977fce4f20', '曾家镇', NULL, NULL, 3908, '7fefd2bf-99e0-43f5-bc37-9ab15ee8e8f3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('13849b67-3010-4cc0-97ab-ba31fbadcccb', '宁乡县', NULL, NULL, 628, 'dccf3d25-c012-444b-94c6-bbcbae7e63d8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('13a81766-3a5d-4f37-90d0-f6381bd6106c', '岩湾乡', NULL, NULL, 1107, '79482cd9-7d51-4c89-94c2-4bcd773b8323', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('13af9b38-f370-4b41-b416-1521d29a3252', '文圣区', NULL, NULL, 4161, 'f856399f-e403-4734-abb9-b972db76c06b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('13ccbfe9-5dfb-4a57-a564-07e5802cce06', '太平坝乡', NULL, NULL, 1933, '442f465d-6566-45e4-9338-50f4395aa6f7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('13fbf98d-37b4-417c-bb40-05215f66a35a', '罗店镇', NULL, NULL, 762, 'c470aa47-a334-4df9-a8ea-b90683ddc861', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('13fcc548-e393-4597-8057-c44bf4e3bfc5', '枣强县', NULL, NULL, 2467, 'b126935b-0423-4bea-b802-d4e6680d1d71', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('140d56fa-2b0e-47f5-bb87-3fb97a6fe140', '瑞金市', NULL, NULL, 1606, 'dd4a8577-afbe-449b-ae9b-be374a4c7434', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('14108241-bc8e-4780-84bf-33beeeac5f5c', '五环至六环之间', NULL, NULL, 295, 'd5bceaed-c2c5-4104-a42c-4c9c8114c7c9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('144ec308-d586-40f6-ae33-1d5bca9cab2d', '忻城县', NULL, NULL, 2167, 'f63c9587-7455-4dff-950d-0da6dddd16c1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('145815ee-9dfc-487b-beec-5da8bd92b5c1', '大有镇', NULL, NULL, 942, '88260608-a8b9-4b52-a474-1a551465c675', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1458694a-e957-45cb-ab24-8ab6f92eb51d', '辰溪县', NULL, NULL, 2021, 'd133a3fc-3db0-426f-8a04-e25b44a5565c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('146c0f70-b01a-4308-aad9-8f96beb05585', '北石槽镇', NULL, NULL, 3720, 'd1c1539c-b904-4bcc-a034-96213f63d0ff', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1476cc6f-e5ef-4902-9a00-1c11122b3284', '经济开发区', NULL, NULL, 4096, '94f58cdc-52ca-4a35-a822-4b62ab8bd3d7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1483b73f-b319-4159-a375-5b9ab209c2ba', '西贡区', NULL, NULL, 484, 'dfb8b556-10a2-43ab-9fdb-66cde92320ee', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('14898293-3736-4ed8-ac47-1ce64ac0509b', '天长市', NULL, NULL, 858, '1a27a18f-784d-4314-bd00-8add932005d6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1492750e-4c88-4d2d-98a7-d359dac75789', '中山区', NULL, NULL, 4049, 'd83aabcc-3c2e-4b48-962a-c548442bc896', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('14b1f95c-8eed-49d0-b049-914d8a9aef1f', '张江镇', NULL, NULL, 2634, '4683d3ef-0edf-425a-98d5-2cb231a7d88a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('14ba97eb-2eeb-43e3-abba-d340f5ef77d0', '温江区', NULL, NULL, 1800, '4f073365-4e02-459f-8b32-cad88dd22637', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('14e29693-df62-482b-84ce-882a3678db42', '宜居乡', NULL, NULL, 2948, '465e9ea2-a2f2-4b42-95dd-b48d91f67105', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('14e9b107-6845-49ed-8163-a90e7af3d4dc', '安泽县', NULL, NULL, 3697, '1aeeea9e-d028-4a96-94ce-ba84cdd3e69f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('14fecfe0-9963-4be8-8584-7e4a1a92a091', '肇州县', NULL, NULL, 2366, 'c5e2b320-fd7d-448b-9a02-4fb93e1d3302', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('15090cd6-8d5c-413b-9174-585daffcd7c3', '北林区', NULL, NULL, 3553, 'fcd4a18f-a57a-47c4-b2f2-504bc8bccb20', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('150e410f-9707-44f9-b970-c91b6af8ecd2', '石台县', NULL, NULL, 2046, '7294fb6c-cbd8-49b7-ad18-f285bc43f1d9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('151bf6de-fbfd-4751-b232-2be0b1c061bc', '定襄县', NULL, NULL, 2843, '18b3c51b-f699-467d-a342-d78bf9cff362', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('152a093a-67b9-4a63-9c4e-7002e07f5c60', '菱角乡', NULL, NULL, 1589, 'ac0e6e50-b6a1-457c-811c-06ac309cd5a3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('153cf68d-c2c5-43ea-9459-a967ce02a69c', '盐都区', NULL, NULL, 4363, 'b85d2a61-b018-431a-9609-2ca0841f5cab', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('154073f4-dbf9-4ce5-bd04-f7a50a82be91', '耀灵乡', NULL, NULL, 202, '4f867632-2989-4def-9934-a9c5fe0d5ca5', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1542c0a6-84ff-42be-b5ea-4487699af67d', '弥勒县', NULL, NULL, 3151, '99a9abd1-f107-4dc6-ae43-e9d1120504b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('154be78c-54d1-493d-b3f1-e2dbd9152ad4', '东区', NULL, NULL, 1663, '8e1185d8-66bf-4f53-8ffc-ae9aad60cac2', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1554279a-b65c-461f-8077-8f62e45c1525', '尖峰镇', NULL, NULL, 2560, 'a1e3332c-7029-4de7-a221-40c041a9a620', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('15776492-9f43-4349-b09c-03b651a77a2f', '松阳县', NULL, NULL, 2373, '982c089d-7fb7-4cdc-a3c2-865e4637006f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('15b2356b-25d0-40b5-8516-e8247519be0c', '定陶县', NULL, NULL, 1791, 'e04fe06c-7641-47c7-a125-4d35e1800549', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('15b7ee35-75f0-40d5-b4c0-00c257af4e4f', '安塞县', NULL, NULL, 3394, 'f95958de-a678-4371-9710-6bcac3f425fa', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('15ddee76-f55a-4e64-94c1-657322798acb', '邻封镇', NULL, NULL, 2078, '4686b935-e3f0-4173-bdfe-ab6a5450d1a8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('15e8efc1-1d77-4462-9273-a8799eb871b5', '华县', NULL, NULL, 3165, '9e5ae65c-206f-4d7b-87f2-c252d5f40b52', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('15f713d9-833b-48c2-8714-1ed6ac4577d5', '犍为县', NULL, NULL, 2525, '8f917434-e687-4552-b494-0eab3af61900', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('160d312c-9f6f-48a9-aa93-695775355784', '青山区', NULL, NULL, 2053, 'd4910db5-a704-4273-bd13-a6dc05f468cf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('16208ac2-e01d-48f5-b714-76ca88dc44ef', '白桥乡', NULL, NULL, 3267, 'a39ced08-b6e9-4de0-a2db-7a230a673d1e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1630bc70-9198-49ed-8c04-fbb0dcbb9ae9', '城步县', NULL, NULL, 3761, '30ce87bd-09cc-4250-9b5e-1f5916ce4d70', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1639f809-8363-46eb-a6bb-b5f87010cc8f', '通道县', NULL, NULL, 2023, 'd133a3fc-3db0-426f-8a04-e25b44a5565c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('163e9d20-b422-40bf-b286-cd914319a465', '哈密市', NULL, NULL, 2067, '89e63cc0-6828-4bfd-9e6c-e5752f3cc837', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1640225f-baef-4ace-b855-4d184d56f6b9', '自流井区', NULL, NULL, 1687, '39b19556-caa3-41de-a70f-2d81f23db54d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1646aa34-9fb6-496a-9c00-9de5400631b5', '鼓楼区', NULL, NULL, 4243, '71a49c5c-c3c2-4fcb-8f90-aa1d733a19f7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('167967a2-6fe7-4006-abe4-5f4db2681242', '隆尧县', NULL, NULL, 1034, '4d6c5692-82f1-443c-9163-39a3dd77636b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('16810ba0-11dc-4cbe-be10-2a9ea16ea633', '双流县', NULL, NULL, 1810, '4f073365-4e02-459f-8b32-cad88dd22637', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('16a209ab-d096-42a1-ba8e-51970fcaa8c6', '南彩镇', NULL, NULL, 3733, 'd1c1539c-b904-4bcc-a034-96213f63d0ff', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('16a8096f-d80c-4850-8a54-817dc59ae082', '海安县', NULL, NULL, 1748, '7de09763-759b-437b-a3aa-4cb32bd3c6b9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('16ab43dd-60a9-461d-95a4-77a204d9928a', '娄星区', NULL, NULL, 3745, 'cff58e36-5b90-4beb-a3b7-e04021d244cb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('16adc00b-61eb-445b-ab39-5b4aa4165075', '江东区', NULL, NULL, 1669, 'c5cc1924-02da-4927-982d-54f0b9f70ef8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('16c0fe20-34e9-4204-bda9-33b8a39dc22b', '亭林镇', NULL, NULL, 2704, '0e5598a8-f405-4745-8cd5-a7a4c99f67f9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('16e0f7d3-2511-4257-b6c4-ae36a76a40e8', '前锋区', NULL, NULL, 3300, '4bb2fe40-7307-498b-802c-e85e937f95e0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('16e58fd7-5edd-4476-ad5e-b0e5e9ba9f46', '安坪乡', NULL, NULL, 1096, '79482cd9-7d51-4c89-94c2-4bcd773b8323', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('171632df-f7ea-4411-b5e6-4fe54b1a32ac', '樟木头镇', NULL, NULL, 3322, '3bc6861d-0eeb-497e-9257-42f9cd6fd26f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('172d296f-c5a2-4c30-bdb7-dea5a3fe0cda', '金桥镇', NULL, NULL, 3676, '6581d8db-553e-4417-8c37-91ed47904920', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('173eb126-f92d-452b-ba24-793affdf77c1', '商南县', NULL, NULL, 1391, '332e1b20-ce8a-4065-ab84-b60416060476', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1752da53-e64c-4cf0-8d1b-5dcf2daa2df1', '东安县', NULL, NULL, 1736, 'c7d6739c-4d7d-4d8f-bf6e-d6a6a7d38f20', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1753f9d6-e497-4a70-82a8-22f98e72052e', '全境', NULL, NULL, 2369, '2ba31d52-f5a5-4186-b924-4049b61f3d18', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('178c672f-587e-48ac-81cc-848b7b8afeb5', '杨市', NULL, NULL, 823, '24ad0708-80a9-43b1-8e1c-758f2492d3f6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('17904354-22ae-4ba4-b3a0-0d9e3a87be9e', '琼山区', NULL, NULL, 2884, 'b899bf86-aa99-4e70-a544-8ebe64da4f24', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('17922273-fe7c-4093-93d5-b08189434b56', '沙河乡', NULL, NULL, 1499, '89e8be16-b810-4c7e-89f0-aa9f24483b98', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('17a0214f-954d-4705-aa72-d363c1d08958', '周村区', NULL, NULL, 2444, 'c03520db-2a67-4cae-a658-4806d4254996', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('17a37731-70db-422b-9793-baaa1d5234c1', '平山区', NULL, NULL, 1548, '7becad81-2a66-497c-9c70-276a85718c91', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('17aac784-5ac5-4f84-aedc-2070480ac987', '晋源区', NULL, NULL, 100, 'de59cca6-548c-4009-9776-5daae2b866a6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('17b7355a-4aa6-4923-9351-32f01d56c528', '高石碑镇', NULL, NULL, 828, '24ad0708-80a9-43b1-8e1c-758f2492d3f6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('17b7e889-dee2-45ad-b231-3fb7092c0ca8', '榕城区', NULL, NULL, 1740, '03f84ef3-e7e9-4c0d-a1ab-b4170505bcaf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('17b92df0-5a9c-40ad-99eb-4b7117d0b220', '监利县', NULL, NULL, 878, '7fe0855f-3ef6-419b-a145-5994fe28cc8f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('17c6a3b3-8456-4110-94c0-44c536771e67', '迎泽区', NULL, NULL, 99, 'de59cca6-548c-4009-9776-5daae2b866a6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('17cac4a2-f1d8-4c8d-a1ff-77e93b03b7e0', '碧山镇', NULL, NULL, 641, 'd7f44c2a-2728-4633-a8b6-7643136bc99d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('17ccea92-6d18-4147-80b9-245003167158', '畜禽良种场', NULL, NULL, 3480, 'ea11feaf-194c-4cec-be59-d17bac402db4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('17d3d112-7a6c-423d-a9d6-5e43c49fe031', '拉孜县', NULL, NULL, 3643, '5800fbac-51b0-4bc6-bc2b-34f78067fc28', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('17d5e938-ecfe-4cee-bebe-161c1a6f740d', '福清市', NULL, NULL, 4247, '71a49c5c-c3c2-4fcb-8f90-aa1d733a19f7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('17d91e6e-edc9-4da6-ac37-6b91fde70a32', '潞城镇', NULL, NULL, 2131, '88d84710-80d6-4837-b889-286c74d7940d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('17dbcb2c-dcea-4b7c-8ee2-36686e1e1341', '总口管理区', NULL, NULL, 840, '24ad0708-80a9-43b1-8e1c-758f2492d3f6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('17e3ed57-4df5-4ad5-b01a-ce6532dfb329', '禄劝县', NULL, NULL, 2866, 'd7efec13-7e84-436d-8390-41868af0e359', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('17f37aa1-a4d0-4447-8d80-71bfad3844e2', '魏县', NULL, NULL, 214, '237eff18-fe6c-4842-afb1-acb05027a5c1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('17f807d4-979a-431b-8c56-ab46974881f4', '德昌县', NULL, NULL, 3507, 'c8f594a3-8acc-48a9-ba2f-e76934de05eb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1814bb2f-c44c-41a5-a116-0298da74cc3d', '钟楼区', NULL, NULL, 4002, '4a5fccf3-5d70-4b0b-85ef-c2a8e5fdfadc', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1839b128-2c30-4aff-96e8-4c0586ed5578', '瑶海区', NULL, NULL, 150, '6ab7dc5a-1064-4090-a81b-79c3a2e8302d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('18406f8d-2ef1-4e07-8d2d-8804683bec64', '大溪镇', NULL, NULL, 2915, '465e9ea2-a2f2-4b42-95dd-b48d91f67105', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1840aa6b-e064-4fa4-a2e0-4024ca364dd4', '健龙镇', NULL, NULL, 3603, '27289f06-ca7a-4916-8f25-f6b13d8687ec', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('184b4fec-6ab8-4003-9c5a-c3246c7df007', '城区', NULL, NULL, 887, '41f376c0-764f-46b9-af35-e555518fc613', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1851d10d-e35b-4584-94ed-4ec9b0d215ae', '龙潭乡', NULL, NULL, 816, '0f559985-f6fe-4a8f-af80-3d0d64932dbc', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('18577806-eec4-4acd-bf08-a0867cb2a0fa', '茌平县', NULL, NULL, 356, '56b97c58-86a5-4869-9130-c5dc51ea9a26', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1858cd52-f50b-419b-8602-b17e510a53d2', '石沱镇', NULL, NULL, 1123, '72d4f69f-2e4c-4bde-9df8-2aadc9168686', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('186924c7-57a3-41fa-9da7-20267298fb01', '莘县', NULL, NULL, 357, '56b97c58-86a5-4869-9130-c5dc51ea9a26', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('18704ab6-d035-4133-9c4e-c6075505957c', '象山区', NULL, NULL, 3182, '796bb0e0-6b76-4c1d-801f-2dbcbab74087', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1870ca4a-7460-4a99-b3d4-1031c3d45cb2', '秦安县', NULL, NULL, 3116, 'b31f9073-6d76-4083-b00f-cc23550ef59a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1874fb58-de4f-489d-8a38-c02068a42f25', '资兴市', NULL, NULL, 1306, '50d6a2ea-ba0d-4ff5-8b4c-f9d84e79e381', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('18ac63a7-d153-4a33-bddd-ff31c8a5d714', '蓬溪县', NULL, NULL, 3024, '44b40fc1-5bf4-476c-b869-580342d65c02', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('18d9eaad-9a40-4413-b97b-ef73b2c01a36', '桓台县', NULL, NULL, 2449, 'c03520db-2a67-4cae-a658-4806d4254996', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('18de7a11-fdd4-4baa-950b-e12f1aaa0a8c', '龙华新区', NULL, NULL, 679, 'fd718129-208d-4a94-9e52-7516af8ef013', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('18e576fc-b497-47f4-9243-26de1b8709f0', '贾汪区', NULL, NULL, 4423, 'e20441c5-c8b4-493a-9738-2327e656fbcb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('18ebc34a-6337-4839-8c63-71d0fca80a29', '邻水县', NULL, NULL, 3299, '4bb2fe40-7307-498b-802c-e85e937f95e0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('18f2b225-0e0f-40fd-820d-8ce4accc60a2', '木里藏族自治县', NULL, NULL, 3505, 'c8f594a3-8acc-48a9-ba2f-e76934de05eb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('190faffa-97a9-4015-86c7-5c8ec83084b0', '南县', NULL, NULL, 79, 'c2eab125-e437-4681-9331-695a7b3b1ecf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('191538dd-b033-460e-b9c2-aa694e100e55', '沙坝乡', NULL, NULL, 3375, 'aa2f26e5-9705-4dc0-b54a-a2d7dbb8b511', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1919087c-81cc-4f11-8476-e017fe05942d', '阿合奇县', NULL, NULL, 2242, '4f2a5173-2b34-4ed5-974e-a6ab5641b2a8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('19352c38-feb2-4d43-a979-6e71a1a87acc', '东郊镇', NULL, NULL, 3803, '96fec37f-11d5-4d41-aba4-a36d0652744c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('193548ac-39d8-4b52-932a-0a3eef0f4a12', '赤水市', NULL, NULL, 3425, '69324865-24e8-4abe-a068-a1392c117c0d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1971ddd3-dae0-4aab-a1a4-064b46e42d73', '丹江口市', NULL, NULL, 3930, 'd795e41b-eb16-4383-b762-ea557481f8e1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('19989596-9781-4985-9921-828dfc0ee5ed', '铁桥镇', NULL, NULL, 3257, 'a39ced08-b6e9-4de0-a2db-7a230a673d1e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('199b6597-8d79-4d44-ad36-3c167c5841a8', '鄱阳县', NULL, NULL, 495, '8bf55045-9366-4acb-b884-bca672ff9644', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('199ca286-18a9-4b9b-a05c-bb440b3985d7', '市北区', NULL, NULL, 3710, '1e53830d-8cdb-4111-8da6-987131b873ed', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('19a3b4f1-ae8a-46d5-8175-161184bcd651', '文儒镇', NULL, NULL, 4087, '5d3b3a34-50c8-4a01-83b7-e3e068d5c9a7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('19b6d645-999b-4521-b960-9368e352e888', '沙坪镇', NULL, NULL, 1483, '89e8be16-b810-4c7e-89f0-aa9f24483b98', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('19cbc673-5b24-4f5e-8322-139873a5f834', '兴县', NULL, NULL, 3411, '9348509b-6d82-47e7-86d7-f054fb47b7fe', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('19e01a35-fd02-4b2d-82a1-26183434ccc6', '季家镇', NULL, NULL, 1658, 'a560b8db-8db1-4bc8-bb6b-fbbecebcaf10', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('19e3bd5e-1392-4d4c-9cdd-531717d6bbfa', '霞浦县', NULL, NULL, 2437, '8300a2db-b893-4d51-a009-89478871edf1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('19ebc5c9-5930-4b43-a8d1-0896d7ffdd82', '东海县', NULL, NULL, 1635, 'bea9983e-fee5-44d8-9884-18c75d7d052d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('19f6622f-351f-4c24-a79f-aad3328bad53', '沈北新区', NULL, NULL, 1851, '271a8d5d-a9a3-4876-a9a2-ca9bcee4b83f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('19f8b661-bf13-40e2-8ca5-24da83df4c0e', '临沭县', NULL, NULL, 4346, '56327d0b-ec26-4f34-8ab6-0eba49931c67', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1a0d2858-33fd-469c-9fd7-d6e300ab5312', '高阳县', NULL, NULL, 2490, '81e22d56-a1c7-4263-be18-81a4af165ae3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1a0f1009-5107-4406-86c5-b5205366157a', '全境', NULL, NULL, 752, '20783033-f61b-4dd8-88da-fbd1efe84423', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1a15fd39-4957-4d0e-bb3e-a3440e576033', '西丰县', NULL, NULL, 2791, 'def78b05-5d2b-430c-b268-442502dc3ca5', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1a1a7c07-def3-4741-9667-a2ca83cd9d7e', '三汇口乡', NULL, NULL, 3266, 'a39ced08-b6e9-4de0-a2db-7a230a673d1e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1a30d505-9219-4a64-9503-b614926247d8', '龙文区', NULL, NULL, 1197, 'bda1d0f2-1476-4e0d-8fb9-2d1392397cbb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1a4a8c02-6178-40be-b63a-30beb5f95d32', '老边区', NULL, NULL, 2686, '1c705a6d-5a16-4544-905c-68134716c6cf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1a5bd0c5-20c5-4aa7-810d-c7da347543ef', '洛南县', NULL, NULL, 1390, '332e1b20-ce8a-4065-ab84-b60416060476', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1a84077e-50cd-4e63-96c0-07d0c0a371fa', '南芬区', NULL, NULL, 1551, '7becad81-2a66-497c-9c70-276a85718c91', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1a8592ff-39b7-4f8c-b6f5-6ec36d56140e', '肥城市', NULL, NULL, 1244, '23df07d6-66e4-474e-b42b-258f50d7b0e4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1a8a5e07-6b3b-4064-b24c-5142f94b31b6', '新州镇', NULL, NULL, 3217, '2e21ea75-c640-4928-8cb4-e5ba4f6e2ffe', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1a9cbd38-9f0e-4de4-ae8b-0c16398c4b12', '霍城县', NULL, NULL, 2590, 'e6f53877-d5bf-4b42-aded-5ab8960ef034', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1aaa58cf-be24-4bed-ae1f-c267d2a01566', '阳原县', NULL, NULL, 137, '37614653-bf6c-458f-a844-540790491eb1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1ac9079e-cda9-40be-af92-b56448d1f6d9', '宁海县', NULL, NULL, 1677, 'c5cc1924-02da-4927-982d-54f0b9f70ef8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1ad354a0-c68e-421d-ad8e-377a78a69963', '康乐县', NULL, NULL, 2234, '5d2d5d2f-fd44-47ad-8108-b7f838073fbd', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1ad3c438-b196-4595-8442-4c04d649018f', '柯坪县', NULL, NULL, 4402, 'b7bc3a10-ad00-4b20-9fa4-cb08ad7492d3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1ae768e9-cde3-4a0c-8efc-6e311252286c', '富文镇', NULL, NULL, 1570, '5f7e2e46-8a4e-4463-907c-5762bcd006a8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1aec8cdd-e4ca-4949-a025-44d6ce07f316', '崇龛镇', NULL, NULL, 560, '8ae99c85-66b1-406b-8084-9f77cbf73b10', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1af0d63a-fc50-41f6-9be0-43062f4d39d6', '修武县', NULL, NULL, 4011, 'e95972c4-fd28-45ac-b9da-9aee0057d3d0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1af47c91-8ef8-4909-905d-d29914086d7f', '博野县', NULL, NULL, 2498, '81e22d56-a1c7-4263-be18-81a4af165ae3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1b02a299-0b62-4123-bd87-f8b2d0196a18', '荔浦县', NULL, NULL, 3195, '796bb0e0-6b76-4c1d-801f-2dbcbab74087', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1b1ebab6-0a29-4f56-9dea-3804c494c8bc', '清江镇', NULL, NULL, 2507, 'd998f8bc-c659-47ce-8e5e-a6b29e03ecb3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1b27d5f3-7e4d-4778-9c67-29f6b993f360', '潼关县', NULL, NULL, 3166, '9e5ae65c-206f-4d7b-87f2-c252d5f40b52', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1b2ba2db-75e7-4f4d-a2e6-3050af4ed7ec', '榆树市', NULL, NULL, 313, '096d0f9e-9537-43f8-95f6-8dca9fa4cad4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1b2fbe91-e308-4852-8e26-2ef2e3851354', '金平区', NULL, NULL, 1440, '8596baaf-4bfe-4522-a422-f397f3494bcb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1b52d320-f89b-4f5e-aaad-d7b4a91422bf', '丁青县', NULL, NULL, 2692, 'b7342349-941d-427d-9ab6-e83a36078088', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1b5968f0-ed40-41d1-b26d-162f8da92a22', '称多县', NULL, NULL, 2071, '27eaf8ae-634a-45eb-bdc9-207c699d16ef', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1b5ee0fc-2eff-44a1-bdee-e599be7fbf49', '荆州区', NULL, NULL, 873, '7fe0855f-3ef6-419b-a145-5994fe28cc8f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1b6046d7-be3d-4823-a85b-e9bacaceacf7', '广宗县', NULL, NULL, 1036, '4d6c5692-82f1-443c-9163-39a3dd77636b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1b67bddf-aa9e-4e3b-9375-933c5df8fb95', '大昌镇', NULL, NULL, 363, '76dd00a1-30a1-4226-ae06-cad845c0528c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1b8fa999-4190-4e37-bf7a-263bab569bde', '息县', NULL, NULL, 3496, '976170b4-d0f7-4fd9-82ed-6e336c9bf3c0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1b92ead9-608b-4a04-a792-12a41f8414d0', '大成镇', NULL, NULL, 3204, '2e21ea75-c640-4928-8cb4-e5ba4f6e2ffe', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1ba2c42a-4c92-40c3-bb28-4d4e3d12ff6c', '清浦区', NULL, NULL, 760, '3c9ba44c-7031-4422-b9b7-85d772ee3e08', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1ba810ad-e912-4bba-bc20-3f5beafcd28c', '下花园区', NULL, NULL, 144, '37614653-bf6c-458f-a844-540790491eb1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1bb3b43b-4d61-499e-a27d-7c17e7ba9c5b', '武侯区', NULL, NULL, 1799, '4f073365-4e02-459f-8b32-cad88dd22637', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1bb48bb8-5eed-4b4d-97a0-efd1138c0736', '番禺区', NULL, NULL, 1984, '926eaeaf-e8c5-47f2-89ff-6932b52c87d3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1bc04a28-808c-4e9d-9413-d9d6273bb144', '杨陵区', NULL, NULL, 2114, 'e42fbad8-c29e-4f35-878d-95a667b5cc90', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1bcabb45-c163-46af-a270-d01818635b6c', '玉泉区', NULL, NULL, 1262, '1fdea9c2-419d-4fd5-b725-8d361e4376fb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1bdaf5a4-9882-496d-945c-99575b52461a', '宝峰镇', NULL, NULL, 405, '9d7d52af-ec34-48e3-b81d-09ac51e11590', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1bebe22a-a3ee-4f81-9edc-10be13768166', '清水河县', NULL, NULL, 1268, '1fdea9c2-419d-4fd5-b725-8d361e4376fb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1c0454ba-7f3d-4a82-8b4b-806913154a55', '全境', NULL, NULL, 2741, 'c6f12750-ac26-4f30-8705-bd3807488895', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1c11709b-f23c-4278-afa2-88f1d5de11d4', '南沱镇', NULL, NULL, 1120, '72d4f69f-2e4c-4bde-9df8-2aadc9168686', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1c1a6e96-99a1-4460-9015-9037aafb4042', '道孚县', NULL, NULL, 3770, 'c262a40d-a147-4930-b33b-574ec51fa884', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1c1eb727-756f-424b-9b58-4438849daa79', '龙水镇', NULL, NULL, 1639, 'a560b8db-8db1-4bc8-bb6b-fbbecebcaf10', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1c275748-17b8-4a22-a35d-98e3ff855cfb', '鹿鸣乡', NULL, NULL, 1895, '2c8bc8c3-9317-4f36-a0ad-05a8d6b27053', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1c341d9f-19ce-4b54-997b-c214d28c424c', '石拐区', NULL, NULL, 2055, 'd4910db5-a704-4273-bd13-a6dc05f468cf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1c49aaff-1999-4e57-a7f1-1330cbdef135', '莱阳市', NULL, NULL, 593, 'f3717726-7743-4838-852b-3a09f9528a69', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1c5527bd-bc99-46ab-8bbc-d8876ffcddf8', '徐闻县', NULL, NULL, 2602, '5c5b11a0-6a29-4173-b876-8fdbc543cb2b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1c666ac8-847c-483a-a878-199021d2451e', '金阳县', NULL, NULL, 3513, 'c8f594a3-8acc-48a9-ba2f-e76934de05eb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1c75c6d9-12b0-42d6-a11e-af0f13f8cf30', '广河县', NULL, NULL, 2239, '5d2d5d2f-fd44-47ad-8108-b7f838073fbd', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1c994f01-3f62-4d3e-b31f-26eb9de8e22c', '永定镇', NULL, NULL, 3571, '5d21af6a-f035-42f4-a0cf-ff1fd3d36f3b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1ca31bba-ca2a-4bcc-8023-30999980cca2', '城西区', NULL, NULL, 3868, 'baa2f053-c419-40c1-93fe-68e081b7f229', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1cad1e76-60ef-4b2b-ae85-4272e1455fe4', '五桂山镇', NULL, NULL, 2202, 'f2727650-b0d9-4541-acdb-b4eabf894893', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1cbb7a4f-39ae-4cd4-991d-7827c22cc83e', '李桥镇', NULL, NULL, 3728, 'd1c1539c-b904-4bcc-a034-96213f63d0ff', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1cbded3e-1435-440e-aedf-7d91ed7f52a4', '勃利县', NULL, NULL, 2002, '9653e91f-7d63-4d36-adcc-4cdbe21dcbea', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1cc455cd-6d73-4b17-8f84-307e8c087aa5', '大石桥市', NULL, NULL, 2684, '1c705a6d-5a16-4544-905c-68134716c6cf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1ce4baf4-1718-421f-8434-d7a5fa04999f', '华漕镇', NULL, NULL, 4027, 'f6eb800d-2093-4ce2-8105-3747d69abe97', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1cf64401-83c7-4093-905f-91eb057d54ca', '游仙区', NULL, NULL, 389, 'efb72ec7-b29f-48d0-a16c-9a33d3938d49', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1d0cdf02-3a3c-4b80-8bdb-a6132544f5a3', '中坤农场', NULL, NULL, 4336, 'e98653ba-264e-4417-b74e-e0798b25e646', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1d2dec8c-34fd-4ad6-a292-e44d43e3425a', '赞皇县', NULL, NULL, 2778, '334645de-ae54-416a-8978-2dbf9f7bbd09', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1d32bf61-f589-4a7a-9cda-4485c43abb33', '富克镇', NULL, NULL, 3201, '2e21ea75-c640-4928-8cb4-e5ba4f6e2ffe', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1d409c17-3dd7-49e1-afd7-e85f315e76f0', '莫力达瓦旗', NULL, NULL, 1067, 'c31a65eb-4d77-4b38-8142-9c9e2f54ed46', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1d524992-490a-4e8f-89be-0a9cdd6f4339', '金溪县', NULL, NULL, 3950, '1e0a806c-ad0b-4e9f-a488-8bf9fc903f4d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1d5c962f-69b7-4dba-93a2-dae1172d2c6e', '安龙县', NULL, NULL, 3110, '875ed189-3d32-4466-a24f-7cbac524774e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1d62a763-f294-4a12-bd45-07190bdaf15f', '云县', NULL, NULL, 517, '88546360-1a0c-4407-9b25-2cde1db643ee', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1d7095d8-3c00-45a0-9c81-0eb091590d34', '感城镇', NULL, NULL, 3607, '46073b56-9ab9-4efb-874f-efe112a304a6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1d7e3b12-4c46-4e8d-a966-bd310e0c9a73', '茂港区', NULL, NULL, 697, '88bc9baa-b7fd-4bf4-a896-4e049185e0c2', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1d83dee3-46e5-4935-a4e0-ed4a88bbac73', '龙射镇', NULL, NULL, 1879, '2c8bc8c3-9317-4f36-a0ad-05a8d6b27053', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1d913433-c9d0-449a-99bd-46ab70ef63ac', '永平县', NULL, NULL, 239, 'feece7c8-8eeb-494a-8e84-571b6ebcf0d9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1da78b16-3d28-4e95-bf33-e4569db17ae0', '清镇市', NULL, NULL, 536, '46abe060-5805-4aaf-9d89-b66bed4b224e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1da7ffe9-f920-4e97-bfc6-282ed83f6d7f', '平遥县', NULL, NULL, 528, '84a16421-f7fb-4f99-b2c0-1e0dea97bf0b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1da907e0-c8b0-4a8a-bcc4-d4a9bf5701b9', '黄竹镇', NULL, NULL, 1560, '5f7e2e46-8a4e-4463-907c-5762bcd006a8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1daf0100-33c0-4db3-8d44-1ca3ce71deda', '白马井镇', NULL, NULL, 3213, '2e21ea75-c640-4928-8cb4-e5ba4f6e2ffe', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1db2a7c6-dea8-46a5-aaa6-a40bbdf540a9', '道里区', NULL, NULL, 1541, '349a18f4-4117-490c-b26f-80702a4911bf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1db40eca-faa5-43b8-b9c5-a5cf577a10b8', '新晃县', NULL, NULL, 2025, 'd133a3fc-3db0-426f-8a04-e25b44a5565c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1dbe72a9-878a-489d-b16d-b644c74d40db', '双龙镇', NULL, NULL, 371, '76dd00a1-30a1-4226-ae06-cad845c0528c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1dbf496e-2978-42df-b054-46f97bc294bb', '兴义市', NULL, NULL, 3103, '875ed189-3d32-4466-a24f-7cbac524774e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1dc13b5b-049f-4481-8063-a5a2b625c3c2', '带岭区', NULL, NULL, 467, '7ca3412f-b06b-467e-b547-691ab8327b15', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1de76f23-b0e7-4bda-b8eb-95f23289388a', '中岗乡', NULL, NULL, 1602, 'ac0e6e50-b6a1-457c-811c-06ac309cd5a3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1df5b434-c72e-44b1-b277-59f35b36eaf2', '平坝县', NULL, NULL, 3624, 'a70a258d-7c8f-4726-a9ef-e2aa7c6247f9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1df7dc91-2d52-4bff-b846-af41baa1f8bd', '高新科技开发区', NULL, NULL, 1679, 'c5cc1924-02da-4927-982d-54f0b9f70ef8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1dfcc990-bcbc-48a5-ae0d-97b14b0ad6a5', '太和区', NULL, NULL, 1073, '99f84690-670c-4a0e-ade1-ebcf17b00adb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1e04f5b0-3cb2-4946-854e-bc9609152ffc', '五洞镇', NULL, NULL, 1485, '89e8be16-b810-4c7e-89f0-aa9f24483b98', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1e177870-8a69-422d-9844-f78b529204df', '五华区', NULL, NULL, 2856, 'd7efec13-7e84-436d-8390-41868af0e359', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1e252055-922e-44b0-8372-5eaccd8cfe7e', '潮南区', NULL, NULL, 1443, '8596baaf-4bfe-4522-a422-f397f3494bcb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1e4f045d-9abb-4b37-bb59-ca9714393019', '沙鱼镇', NULL, NULL, 3875, 'a732da28-870c-4d9c-a287-c2c1e3222b59', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1e53f072-97d9-4e1d-b99e-152024b23258', '阳春市', NULL, NULL, 3972, '97a2157a-88ce-46f6-ba0f-e432060024ca', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1e5b0307-e856-41f2-ba3f-106cbe670926', '勉县', NULL, NULL, 347, '5c4e7f63-9162-47e1-a948-c64ca46ff566', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1e5b5e96-b7ab-46ba-b00a-95e3baeb12ac', '丛林乡', NULL, NULL, 1134, '72d4f69f-2e4c-4bde-9df8-2aadc9168686', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1e5d13e9-5d6c-44db-a0ff-c9a122c4bfda', '龙凤镇', NULL, NULL, 3882, 'a732da28-870c-4d9c-a287-c2c1e3222b59', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1e5deda2-d392-4607-a126-78f8816145eb', '雍溪镇', NULL, NULL, 1652, 'a560b8db-8db1-4bc8-bb6b-fbbecebcaf10', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1e6bf674-b604-4542-9a0f-b5b868d92d44', '叶县', NULL, NULL, 3389, 'f5ebab20-0f47-47e8-b896-6f3d9651c97a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1e9de05a-7c09-4c74-9373-acb1e8a455a4', '天等县', NULL, NULL, 3031, 'c99528d5-bed7-4890-b547-f2159ed13a78', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1eaa27cd-ac07-4e0a-a00e-a3cfbce84c40', '登封市', NULL, NULL, 4126, '4ff4ef6c-41df-4562-a58f-d8b25b2e3ba4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1eb5d855-c0df-4899-b2e0-02ae28fa4623', '金台区', NULL, NULL, 1827, '7c3fbad9-df03-4d15-93a4-695924a2f35d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1ec0a4a4-d5e5-41ac-ac9f-cbdfbfbee84a', '沁源县', NULL, NULL, 3861, '6fc78ef9-e2eb-46bc-bf8e-8b830ad96136', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1ec83341-ef04-4fcd-a97c-73cb6a774777', '正安县', NULL, NULL, 3432, '69324865-24e8-4abe-a068-a1392c117c0d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1ed08929-6e13-46fb-8c9c-4e6a1bba596d', '泔溪镇', NULL, NULL, 2917, '465e9ea2-a2f2-4b42-95dd-b48d91f67105', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1ef71dc6-42af-475d-8688-96913ef927b0', '峰高镇', NULL, NULL, 2503, 'd998f8bc-c659-47ce-8e5e-a6b29e03ecb3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1f10fd0e-8c6a-45d4-ad0d-194da4f70f60', '洞泾镇', NULL, NULL, 90, '3e082d1b-ecb4-4bf8-8715-54132a9106e1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1f1c112d-be04-40b0-8259-e3ad1000ca15', '雄县', NULL, NULL, 2499, '81e22d56-a1c7-4263-be18-81a4af165ae3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1f2a77de-8f4a-4a57-97cb-ad8bdf2b6204', '城区', NULL, NULL, 1354, '21bb958f-e5d4-4a71-a350-b5bf2c0e2de0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1f38876b-1fc8-4d10-b446-5d2b8abf97b5', '松北区', NULL, NULL, 1540, '349a18f4-4117-490c-b26f-80702a4911bf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1f430cbe-090b-45a3-b745-e29dc78759a7', '德令哈市', NULL, NULL, 3005, 'a638060f-a01c-4c77-b905-b46ef8d3e89d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1f5e6ba3-d9ba-4308-8b7c-5551d2db45b4', '五河县', NULL, NULL, 883, 'be39aa7b-a993-4abd-956c-dcb299cc7bc3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1f7cf679-069a-4b01-9ecf-5c439524ca53', '其它地区', NULL, NULL, 584, 'a6c5ceb6-42ea-4d90-bd06-3c0f8cf8bb81', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1f9b7a46-c53d-42d3-8a1e-2e1d8d10d882', '白帝镇', NULL, NULL, 1082, '79482cd9-7d51-4c89-94c2-4bcd773b8323', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1f9fe836-2dc9-4927-b057-392624cd3720', '江山市', NULL, NULL, 2815, 'b2a03fc9-88f2-4734-9af2-7234863d0f87', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1fb2e3e7-7266-432d-8368-463c81e93f28', '月湖区', NULL, NULL, 1338, '20a1443b-429b-4c83-83ca-2c9de2bd67b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1fd5b81a-5873-489b-8e9c-c5e31929a703', '麻阳县', NULL, NULL, 2026, 'd133a3fc-3db0-426f-8a04-e25b44a5565c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1fdd89dc-8275-4921-85b2-42cc846ac940', '县城内', NULL, NULL, 2911, '465e9ea2-a2f2-4b42-95dd-b48d91f67105', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1fdf01c2-a98c-4c25-9681-6cba63e09bd8', '远觉镇', NULL, NULL, 2516, 'd998f8bc-c659-47ce-8e5e-a6b29e03ecb3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1fe1192f-ffea-4bf6-add7-f10dfa65b99b', '黔西县', NULL, NULL, 2614, '55fdf7c7-6698-498a-8aef-b9455ab7926c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('1ff1f502-aeea-4ef9-9a3a-ad6e0c4d426d', '海州区', NULL, NULL, 1631, 'bea9983e-fee5-44d8-9884-18c75d7d052d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('20183e6d-f02c-4386-a070-6709801190d9', '城区', NULL, NULL, 2562, 'a1e3332c-7029-4de7-a221-40c041a9a620', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('201dff85-5905-48be-9ed5-0d4e18e73457', '龙港区', NULL, NULL, 957, '1671eb17-f102-4972-9d41-7b1463da334d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('20387871-52ba-4fed-9304-1db57d231b8d', '佛子庄乡', NULL, NULL, 54, '0863a0a5-7ac5-4a13-80f5-d31e3a1aa459', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('203e6a5a-086c-412e-9b38-495bcdee18dc', '聚宝乡', NULL, NULL, 1138, '72d4f69f-2e4c-4bde-9df8-2aadc9168686', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('20446c20-0835-4efd-a677-092ffab4b623', '歇马镇', NULL, NULL, 2327, '671d3a34-71bf-42c5-8dda-a813f5ecba22', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2055fff0-4f36-4ce4-ad9e-2580ad72295f', '若尔盖县', NULL, NULL, 1194, 'd56c2ee6-b81c-4df8-ba2f-3df7680243c4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('207f08d0-31d1-450e-873a-c1de0a849cd7', '大德乡', NULL, NULL, 3268, 'a39ced08-b6e9-4de0-a2db-7a230a673d1e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2087e36b-7b44-4ac3-a6a7-be0ff06db6c2', '泽州县', NULL, NULL, 2854, 'ffe07042-807c-4f16-a63c-c1eb8785b06b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('208a262c-a8ca-4011-93c4-3875dde29ced', '康坪乡', NULL, NULL, 1100, '79482cd9-7d51-4c89-94c2-4bcd773b8323', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2097ebab-61d1-4c43-b83c-bbc6c3293452', '汽车产业开发区', NULL, NULL, 323, '096d0f9e-9537-43f8-95f6-8dca9fa4cad4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('209d98f1-f693-4340-9a24-33f68c4a8951', '华岩镇', NULL, NULL, 3541, '99107e35-f7d9-4c45-8d21-7a03b9c2f99d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('20b7bb15-0c84-4e84-9de0-4c510db29266', '东升镇', NULL, NULL, 2206, 'f2727650-b0d9-4541-acdb-b4eabf894893', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('20c43be0-8160-4c13-85f0-c7755b6cd22b', '陇西县', NULL, NULL, 3126, 'fc26f78a-1b0b-4967-8d26-df9e530e5260', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('20c47ea1-1f2a-4991-903f-2d4bf1324785', '南溪镇', NULL, NULL, 174, '4f867632-2989-4def-9934-a9c5fe0d5ca5', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('20c8beec-dd4a-424f-b661-d22d188e3058', '志丹县', NULL, NULL, 3403, 'f95958de-a678-4371-9710-6bcac3f425fa', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('20cbf303-78dd-4317-adf3-4e42105e562a', '五寨县', NULL, NULL, 2835, '18b3c51b-f699-467d-a342-d78bf9cff362', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('20dd815d-cbf1-4aec-aec4-5be45c5de0e4', '武宁县', NULL, NULL, 111, 'bcaf1f36-5459-4e74-81d1-5026680b1a9c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('20dff1e5-d759-4cc7-aca5-817ff5f4975a', '宝丰县', NULL, NULL, 3391, 'f5ebab20-0f47-47e8-b896-6f3d9651c97a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('20f0f8c8-8dcb-4a10-ae1e-5cba79bd0852', '跳石镇', NULL, NULL, 41, '43c813e3-8672-45c5-8d3e-9ee43dbe51c8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('20f2da0e-8006-472c-ac53-743fc9b63d98', '凉州区', NULL, NULL, 335, 'eea322d8-1faf-4a08-a7f9-1d097375a96d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('21032817-a62d-4b90-a404-6d433d7e1f38', '塔城市', NULL, NULL, 2718, 'a419fd83-e078-4430-aa48-ca9aa67e4fff', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('21043340-9efa-4c94-978b-0958579024a2', '银州区', NULL, NULL, 2787, 'def78b05-5d2b-430c-b268-442502dc3ca5', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('210a8dac-4de6-4fb9-a679-6601563b9cab', '任丘市', NULL, NULL, 2900, 'a3c44525-9ccb-429d-a2b7-f5f5d52b8a6d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('211e86fc-1946-4b75-ab04-38f62be36dec', '项城市', NULL, NULL, 2293, 'f3e12d68-f8c5-4d9d-8314-dd1ce7dac2f9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('21473716-1ee1-4fb1-9d3e-ac74521c003e', '天星乡', NULL, NULL, 1594, 'ac0e6e50-b6a1-457c-811c-06ac309cd5a3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('214bd596-987a-4a63-b711-6a823b726a46', '九龙县', NULL, NULL, 3768, 'c262a40d-a147-4930-b33b-574ec51fa884', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('215f68be-7e30-4669-8889-e0e231ff86b0', '武昌区', NULL, NULL, 420, 'e6e46871-d5a0-4d2b-8243-9d4bd864ab43', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('21622b5e-6660-451f-a569-68649cb5316d', '明溪县', NULL, NULL, 271, 'cae0a47d-0d79-4fa6-aac9-e8b3b535ee3c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('216e1c1e-21f7-4e00-aeae-7c74178f2050', '龙湾区', NULL, NULL, 249, '86b77e39-331e-4927-9517-49be7b738b9a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('219145c2-fb21-4b91-ad4c-1cc40c546d07', '涞滩镇', NULL, NULL, 3877, 'a732da28-870c-4d9c-a287-c2c1e3222b59', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('21a73b82-5081-466e-ac21-a30e04bd20dd', '尉氏县', NULL, NULL, 4186, 'fb0dbd60-1d03-4394-a890-ffc2d3ec6a37', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('21ada489-6948-4747-adaf-e774d0c0d399', '高新技术开发区', NULL, NULL, 4129, '4ff4ef6c-41df-4562-a58f-d8b25b2e3ba4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('21b0a7fc-540f-4316-8791-06a221c64c65', '别口乡', NULL, NULL, 574, '8ae99c85-66b1-406b-8084-9f77cbf73b10', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('21db5447-3204-4e5d-b13a-a77ccdba636e', '南宾镇', NULL, NULL, 795, '0f559985-f6fe-4a8f-af80-3d0d64932dbc', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('21e8f58c-2293-448d-9369-a31f2d9ee0d0', '高青县', NULL, NULL, 2447, 'c03520db-2a67-4cae-a658-4806d4254996', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('21f65c38-c8d8-4f2f-b5df-4f7328697e61', '清徐县', NULL, NULL, 107, 'de59cca6-548c-4009-9776-5daae2b866a6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('22186f2a-f028-4d28-8999-99600c64b37a', '兴平市', NULL, NULL, 2103, 'e42fbad8-c29e-4f35-878d-95a667b5cc90', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2224359d-e024-4470-9efc-ff6c19ec64d2', '新海镇', NULL, NULL, 3990, 'fcc07455-c69c-4c90-82cb-ddb268adb8a9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('222c1150-509e-4514-b0e4-31774ab86926', '上街区', NULL, NULL, 4128, '4ff4ef6c-41df-4562-a58f-d8b25b2e3ba4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('22331d6d-2767-4b72-86fc-85f5fd0602d7', '大石乡', NULL, NULL, 1493, '89e8be16-b810-4c7e-89f0-aa9f24483b98', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('22440a80-c2d9-4c8c-b7ff-0421d1885cc5', '富民县', NULL, NULL, 2862, 'd7efec13-7e84-436d-8390-41868af0e359', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2252a040-8136-4a54-aaaf-846cf19f1ad4', '楠木乡', NULL, NULL, 2939, '465e9ea2-a2f2-4b42-95dd-b48d91f67105', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('226f1fb9-85f7-4b06-b813-9ce66451504e', '兴安县', NULL, NULL, 3193, '796bb0e0-6b76-4c1d-801f-2dbcbab74087', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('228a7cc5-067b-40ae-8e59-4dfb4696ab61', '梅江区', NULL, NULL, 4388, '2aabe025-ea3b-4ce4-885f-9ecf122b3e79', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('228feb80-8cfb-45eb-97cd-b303e09ae391', '东安乡', NULL, NULL, 2388, '0275a9ca-e89b-4217-b3b0-ada824d9e095', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('22925653-a5d2-4fa7-bb6e-60c6ea53e7f0', '海城区', NULL, NULL, 2028, '93e31709-76d2-4b65-aa0f-7990919a44d0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('22945f39-c758-4bec-9df3-fb8793afc25c', '邓家乡', NULL, NULL, 376, '76dd00a1-30a1-4226-ae06-cad845c0528c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('22aba1b2-5431-4466-86f3-b61d1a94aa80', '城区', NULL, NULL, 2258, 'd17f8f8e-b3dd-4818-a89d-8b431ff5c555', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('22b693f1-53f7-42e0-bb92-a81bbd142a11', '秭归县', NULL, NULL, 1783, '3760382f-ecb5-4ef6-8bd2-049afe34b574', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('22d49dfb-e05a-45f6-814e-4c4ba4bf7ee4', '竹贤乡', NULL, NULL, 387, '76dd00a1-30a1-4226-ae06-cad845c0528c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('22e8d3a6-925c-449e-88bf-f87b113d9371', '朝天区', NULL, NULL, 507, '74a706f1-82bb-4132-8ee4-9abf7bd809cb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('230c2840-7b05-47b5-8295-625e74c600f9', '龙亭区', NULL, NULL, 4178, 'fb0dbd60-1d03-4394-a890-ffc2d3ec6a37', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('230e26e4-e02b-48ef-bd29-2e81e039bacd', '武穴市', NULL, NULL, 998, '63a5fa32-35eb-4eca-ab79-f3887e122564', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('231d3548-878e-49cb-a593-922ebef15f07', '七坊镇', NULL, NULL, 1358, '21bb958f-e5d4-4a71-a350-b5bf2c0e2de0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('232541eb-2784-4fc0-a512-2a400b5ecb8b', '金明区', NULL, NULL, 4177, 'fb0dbd60-1d03-4394-a890-ffc2d3ec6a37', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('23257a0d-3b33-45df-8260-078364ece940', '巴楚县', NULL, NULL, 2033, 'e6436d79-8045-4185-b2b2-22cd280d22b0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('232df26f-da8e-4cea-aa92-a5f9bd8e8bc7', '掇刀区', NULL, NULL, 774, '060b2327-c9b1-47ef-a56a-d280d1a4297d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('232eac58-93bf-4e8c-b3f7-3299659ae7f1', '鲁甸县', NULL, NULL, 3681, '31187fc0-8d6e-45f3-9653-b7ce4227ef1d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('236dc4ea-dade-416f-b78a-e2c649f41e9c', '明通镇', NULL, NULL, 2384, '0275a9ca-e89b-4217-b3b0-ada824d9e095', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('23763ef3-8e02-46d9-a629-354921d9a0de', '新民镇', NULL, NULL, 1091, '79482cd9-7d51-4c89-94c2-4bcd773b8323', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('23853673-66e3-48fb-979e-4c92c8eb3dd6', '行唐县', NULL, NULL, 2774, '334645de-ae54-416a-8978-2dbf9f7bbd09', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('238b4678-d980-4fc6-81ff-0e6bd17ee915', '涉县', NULL, NULL, 217, '237eff18-fe6c-4842-afb1-acb05027a5c1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('23a4afc9-458b-47bc-9254-d585ad67f49c', '天心区', NULL, NULL, 625, 'dccf3d25-c012-444b-94c6-bbcbae7e63d8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('23a5227e-280c-4219-978a-503d11fe7b9e', '民主乡', NULL, NULL, 930, '88260608-a8b9-4b52-a474-1a551465c675', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('23a96cfa-42a7-4cc0-9992-b475a5969c88', '佛冈县', NULL, NULL, 2952, '8377f1cd-7272-4396-b99b-84bb707dbc2c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('23d5a081-885b-4110-9647-dbc30a898d23', '江岸区', NULL, NULL, 421, 'e6e46871-d5a0-4d2b-8243-9d4bd864ab43', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('23d7ac40-0332-448c-bf26-8e1f0a72e979', '荣县', NULL, NULL, 1691, '39b19556-caa3-41de-a70f-2d81f23db54d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('23dc33d5-45bb-4c08-9afa-0189ade81ffb', '大连开发区', NULL, NULL, 4054, 'd83aabcc-3c2e-4b48-962a-c548442bc896', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('23e056c5-4b25-4629-911d-d2ead7074fec', '金东区', NULL, NULL, 223, '1721f4b0-56cf-4408-a217-62416951c176', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('23e15335-12b4-4ade-87b3-30d55799ee51', '越西县', NULL, NULL, 3517, 'c8f594a3-8acc-48a9-ba2f-e76934de05eb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('23e17ecd-8727-42ee-b59e-61e11288794e', '承留镇', NULL, NULL, 3929, '22f622f8-7eaf-41e9-90ee-2a0cfda1f326', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('23ee91e4-1420-4318-8d23-4788554d8544', '萝北县', NULL, NULL, 3284, '978f3e32-c5e0-48e4-b9ba-4f7f04ed87a1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('241c876e-f035-48e0-929c-b7a3cce7264d', '松柏镇', NULL, NULL, 3069, '4b20c67b-06ca-4c0b-a947-bc518238537e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('24253325-94b1-43e9-be72-f3d2c59fd03d', '长清区', NULL, NULL, 4351, 'c6ac73d4-9854-403a-9b61-12c22eeb4903', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('244744a3-6e59-4013-8cce-3a58f3d8379c', '兴宁区', NULL, NULL, 2803, 'b53ced47-2455-44ec-b740-7637148f574c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2459fcd6-2982-4f08-8d37-0915a6fed5f9', '察雅县', NULL, NULL, 2693, 'b7342349-941d-427d-9ab6-e83a36078088', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('246c18d0-1c84-4421-a4f9-c1a53ac27d5b', '黄圃镇', NULL, NULL, 2201, 'f2727650-b0d9-4541-acdb-b4eabf894893', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('24758d51-80d3-44e7-97bf-f1bdc33686cc', '伊川县', NULL, NULL, 1174, 'b5a118ad-786c-4d86-b4e8-5d25a3776a78', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('247eff7e-3875-41c1-bf45-57667873c011', '冯家镇', NULL, NULL, 3361, 'aa2f26e5-9705-4dc0-b54a-a2d7dbb8b511', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('247f6bd6-982e-4433-883e-01f49ef865cf', '会理县', NULL, NULL, 3508, 'c8f594a3-8acc-48a9-ba2f-e76934de05eb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('247fffc3-b1e0-43eb-a93f-f6cb38abc03e', '武强县', NULL, NULL, 2474, 'b126935b-0423-4bea-b802-d4e6680d1d71', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2486a624-70a1-446d-bb41-fcaa9b97fd04', '洗新乡', NULL, NULL, 791, '0f559985-f6fe-4a8f-af80-3d0d64932dbc', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('248ff0d2-c1b9-46e0-ac1e-c5795586ef54', '皮山县', NULL, NULL, 855, '60e9ec7d-f371-4ea9-ace3-b13c1cd7081c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('24a82a0d-b931-4265-92ea-124cbc26f8e6', '直升镇', NULL, NULL, 2505, 'd998f8bc-c659-47ce-8e5e-a6b29e03ecb3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('24a859a8-cd5a-434d-aaa4-21b1c0abd1d9', '竹溪镇', NULL, NULL, 3265, 'a39ced08-b6e9-4de0-a2db-7a230a673d1e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('24fac6d1-6d0e-405e-a2da-a61e0fbeac15', '金州区', NULL, NULL, 4055, 'd83aabcc-3c2e-4b48-962a-c548442bc896', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2504e192-56de-4d29-bd8a-3a963251c41a', '吐鲁番市', NULL, NULL, 2879, '674106ce-5cae-4104-9851-34997d094c8a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('251bce8b-e552-484b-b278-42a00acfb5dc', '城区', NULL, NULL, 2404, '301b83a6-8049-4c5e-805e-2cea20190d97', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2523565c-93a1-4c9a-850f-3e5378bb5076', '横山县', NULL, NULL, 1300, 'c0c88cbd-87ea-4281-9e8e-94a435ae6590', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('25364fb1-3a8c-4954-97fe-6f95bd09cff8', '平原县', NULL, NULL, 4175, '9c8b6d83-dd06-4238-b7f4-c0ad532e5b6e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2552cb0f-f685-4b5f-b94a-f8396d400b68', '南江县', NULL, NULL, 454, '312a1e8d-70a3-4529-bfe8-04a7f21cc881', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('256fbcec-89ea-4af1-813f-a37fc187624f', '西湖区', NULL, NULL, 2308, 'f530455e-1c70-47dd-9a80-4bc74a4e2680', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('25990649-4750-4c80-8d08-ff8f6fe9de3f', '盐井镇', NULL, NULL, 3872, 'a732da28-870c-4d9c-a287-c2c1e3222b59', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('259f73af-458a-4b00-afe1-93d5f727f4a9', '扎鲁特旗', NULL, NULL, 1557, '1dc7d092-717c-424e-a473-bb2cc8836b5e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('25a16d0a-6ddc-42c1-9859-aa718e8adbde', '澳门特别行政区', NULL, NULL, 920, '691e132f-04a3-4856-a77a-92ed2dc5c246', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('25b1c08c-a6e8-4826-90c3-4ca96a0269ce', '东溪镇', NULL, NULL, 2657, 'e509a1a5-95da-4fb2-9a2b-f84afa05a36c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('25fa6280-6324-483a-9c95-a712517d6848', '灌南县', NULL, NULL, 1636, 'bea9983e-fee5-44d8-9884-18c75d7d052d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('26132579-e4ec-4309-85ee-9997d089f75f', '长生桥镇', NULL, NULL, 2261, 'd17f8f8e-b3dd-4818-a89d-8b431ff5c555', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('263502cc-116e-43b1-afec-c7b99ad04c32', '高密市', NULL, NULL, 446, '3e54862f-40e4-4b44-b318-6a64b04a9558', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2635932b-bf11-4920-b414-bef23d3ea38a', '呈贡区', NULL, NULL, 2859, 'd7efec13-7e84-436d-8390-41868af0e359', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('266310f2-20db-441b-bea1-c82b33e85e65', '赶水镇', NULL, NULL, 3661, '6581d8db-553e-4417-8c37-91ed47904920', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('26715500-fce5-43b0-b570-9667816a9d7d', '宜良县', NULL, NULL, 2865, 'd7efec13-7e84-436d-8390-41868af0e359', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('267f9241-c418-4d54-8f42-bc3ad45d13fd', '六弓乡', NULL, NULL, 2997, '4b3478d4-3e85-4143-bc6f-ac4a338a9d47', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('26854a9b-297b-45c9-a80e-67076efe43a9', '松山湖', NULL, NULL, 3341, '3bc6861d-0eeb-497e-9257-42f9cd6fd26f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('26b69709-19bf-4878-b5c0-e79174990db7', '城区', NULL, NULL, 2849, 'ffe07042-807c-4f16-a63c-c1eb8785b06b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('26ba6d8d-5ba1-4125-9287-42b0e8e903ad', '社旗县', NULL, NULL, 729, 'a769a530-0bcf-4e52-a9e5-3a8f5af945d2', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('26d2a400-6da3-403b-b5b1-0fe71bd5b079', '鹿角镇', NULL, NULL, 1880, '2c8bc8c3-9317-4f36-a0ad-05a8d6b27053', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('26d99e43-5af9-4849-bd88-b9ead5964ecc', '石堰镇', NULL, NULL, 2083, '4686b935-e3f0-4173-bdfe-ab6a5450d1a8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('26f17c34-ed60-4fe5-8f5b-4fdf05022ee0', '通海口镇', NULL, NULL, 3472, 'ea11feaf-194c-4cec-be59-d17bac402db4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('26fc3e74-45fc-4508-a507-4c857abf03eb', '阿克陶县', NULL, NULL, 2244, '4f2a5173-2b34-4ed5-974e-a6ab5641b2a8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('27177a22-bd57-450d-adc1-a057f056b37f', '土地乡', NULL, NULL, 4467, '4888e1e9-ba45-4254-83e7-87796f338e2d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2757bbbb-f5a8-4ca7-b3f3-c8f2467f18da', '海兴县', NULL, NULL, 2896, 'a3c44525-9ccb-429d-a2b7-f5f5d52b8a6d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2757bcfd-6ef8-40a7-b303-4015e9bf1e6a', '浦江镇', NULL, NULL, 4022, 'f6eb800d-2093-4ce2-8105-3747d69abe97', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2759bf14-f648-4829-a80e-87e1a1b3c280', '文复乡', NULL, NULL, 4468, '4888e1e9-ba45-4254-83e7-87796f338e2d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('275dd676-635f-4cc0-80b7-c583b9e46584', '大理市', NULL, NULL, 243, 'feece7c8-8eeb-494a-8e84-571b6ebcf0d9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('275eef1c-1c05-4686-909c-c3c6be5d98e8', '双龙镇', NULL, NULL, 2081, '4686b935-e3f0-4173-bdfe-ab6a5450d1a8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('27608f71-4b4b-494f-9104-bf0dbd19678b', '托克托县', NULL, NULL, 1267, '1fdea9c2-419d-4fd5-b725-8d361e4376fb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2767ca5c-dd8e-442f-9afe-f36cf9165382', '郊区', NULL, NULL, 4437, '16769cc8-c7bd-49cd-8e76-bcb74327f133', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('276d0137-86fd-49bb-9a54-7a28cd468293', '谢家集区', NULL, NULL, 2961, '69508f5e-7304-4092-95a4-73d6a9b68eff', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('27732075-96ef-40d5-a401-97e844eaaa0f', '德安县', NULL, NULL, 116, 'bcaf1f36-5459-4e74-81d1-5026680b1a9c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('277c9574-7a63-4b2f-999c-080e5ef43c92', '闻喜县', NULL, NULL, 4114, 'fc30b5e5-3005-4778-94f7-706b31514bff', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('277ea456-926c-4f51-b9fc-de59e31c1ca1', '北城新区', NULL, NULL, 158, '6ab7dc5a-1064-4090-a81b-79c3a2e8302d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('278b5ef8-36b4-4224-a2c2-b18c4a7a0730', '石峰区', NULL, NULL, 2605, 'cdeda821-2101-44e1-a986-183436199f05', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('279184ef-dc71-4563-85f2-21df1e1d10f8', '南召县', NULL, NULL, 739, 'a769a530-0bcf-4e52-a9e5-3a8f5af945d2', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('279a5d4b-1053-4125-8e96-9301cfdc3d5f', '莲都区', NULL, NULL, 2377, '982c089d-7fb7-4cdc-a3c2-865e4637006f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('279dc3d2-89a4-47ce-bfdf-d55aa7527f82', '河鱼乡', NULL, NULL, 2391, '0275a9ca-e89b-4217-b3b0-ada824d9e095', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('27b85af4-335a-4fa7-bd53-b7e8118c9160', '荣邦乡', NULL, NULL, 1353, '21bb958f-e5d4-4a71-a350-b5bf2c0e2de0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('27c67d10-f551-4069-9fa0-870fe9418573', '句容市', NULL, NULL, 1761, '63f8e070-63c0-4fa1-821f-d1d5a695ce2a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('27cc3048-9a93-4abc-9905-49b80a8884ae', '龙河镇', NULL, NULL, 1567, '5f7e2e46-8a4e-4463-907c-5762bcd006a8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('27d04d87-696c-4d40-ab9e-6d996d088649', '安源区', NULL, NULL, 1155, '20c4f23e-77e7-4763-9ba8-dd00d5216748', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('27d80954-8faf-4f81-b1bd-7c2b8c4db801', '梨林镇', NULL, NULL, 3926, '22f622f8-7eaf-41e9-90ee-2a0cfda1f326', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('27df16a4-210b-4228-a523-7329d192d1e5', '靛水乡', NULL, NULL, 1889, '2c8bc8c3-9317-4f36-a0ad-05a8d6b27053', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('27ea7f8b-e90b-42cd-b231-ce1dca59e9d4', '联合乡', NULL, NULL, 1891, '2c8bc8c3-9317-4f36-a0ad-05a8d6b27053', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('280c5f70-f296-4154-93db-374a2a8ffa0d', '清水镇', NULL, NULL, 3579, '5d21af6a-f035-42f4-a0cf-ff1fd3d36f3b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('280c9938-f615-403c-99ba-10ae6ade7f8d', '江桥镇', NULL, NULL, 1321, '99c50aa3-ab40-4b1e-addd-f68662f3c560', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2813ccef-6330-4b52-822b-550198299e67', '河东区', NULL, NULL, 4340, '56327d0b-ec26-4f34-8ab6-0eba49931c67', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('282f572f-61f7-4163-aa9a-2c88f6d66052', '平罗县', NULL, NULL, 1436, 'ef951e0d-15d6-4343-901d-8412af9b0b93', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('28307333-fd88-4b31-a6e6-2067d0757716', '精河县', NULL, NULL, 4271, '4a8f2a43-831a-4413-b4b5-2de877d9b166', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2834bff2-02e7-4cac-a636-7bd928d248a5', '隆盛镇', NULL, NULL, 3664, '6581d8db-553e-4417-8c37-91ed47904920', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2845a286-2a9e-4a0e-9b33-1e568da82612', '石景山城区', NULL, NULL, 3762, '8aa8a856-f81b-43f1-9749-14798022b2eb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('284849d1-b887-4812-bd01-dd4418eda68b', '梅列区', NULL, NULL, 280, 'cae0a47d-0d79-4fa6-aac9-e8b3b535ee3c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('28517917-90c0-43c6-99b9-955a43c3de1f', '澜沧县', NULL, NULL, 1710, 'db61cc5b-b13b-417f-a232-7925ffdfa9b2', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('28650ee5-9b95-4572-8176-37c350791920', '乌坡镇', NULL, NULL, 4331, 'e98653ba-264e-4417-b74e-e0798b25e646', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2866142a-847e-4b6d-b4ac-dfe38dcebe97', '甘州区', NULL, NULL, 687, 'dcdb1184-ab1f-4332-8ca0-f4edfd7cc087', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('28667083-9d23-42bf-b8e2-27f56a5fab92', '黎平县', NULL, NULL, 3090, '6d3a8433-1273-4323-a3eb-d39effecc1d7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('286f427c-b920-4c3c-a3de-d53681a6e9d4', '鄯善县', NULL, NULL, 2881, '674106ce-5cae-4104-9851-34997d094c8a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('28a9b0f0-256a-48e8-afde-93aa43916b46', '礼嘉镇', NULL, NULL, 700, '97942649-3cc7-4e4a-81b4-9a8c82f82ea7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('28ab56b8-2d0d-4cff-9538-068c56e4a59e', '同安区', NULL, NULL, 1212, '9122834d-aef5-4895-974e-82d2f568bcd4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('28b79f93-4d5e-42cf-b23e-529400baf6bc', '铜罐驿镇', NULL, NULL, 3540, '99107e35-f7d9-4c45-8d21-7a03b9c2f99d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('28bca05c-9096-433f-9c81-1a7af20798fb', '凤县', NULL, NULL, 1835, '7c3fbad9-df03-4d15-93a4-695924a2f35d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('28c039a9-1908-4c7a-a87c-c3c8eadd1cd9', '白涛镇', NULL, NULL, 1112, '72d4f69f-2e4c-4bde-9df8-2aadc9168686', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('28cfc03a-2332-4168-b948-d3b21fdf6c5f', '溪口乡', NULL, NULL, 990, 'cc124ed6-091a-42ce-a87a-bb4d0d7357b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('28dd6c92-e9dc-420d-80de-08397da570a5', '高安镇', NULL, NULL, 1479, '89e8be16-b810-4c7e-89f0-aa9f24483b98', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('28e52971-0005-4261-9c2d-66fe62ed0e5e', '丹棱县', NULL, NULL, 22, 'a24f5cc3-558c-447d-bedc-895b418c750f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('28f078d3-afd2-401a-b65c-0ea2010998be', '盱眙县', NULL, NULL, 757, '3c9ba44c-7031-4422-b9b7-85d772ee3e08', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2902c5e4-9d85-40ee-9c8b-67b0523a573f', '大庙镇', NULL, NULL, 3835, 'c33c3107-81df-4ced-8b92-d694df412da3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('291b03d3-72a9-43ea-aded-2382ef76db6c', '其它地区', NULL, NULL, 4375, '7932fd13-00db-4934-bfc2-79c835527339', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('292450c2-0d11-4a7d-89d5-1ff9a6518543', '太平场镇', NULL, NULL, 940, '88260608-a8b9-4b52-a474-1a551465c675', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('292d805f-676a-4261-b5d7-e61b1b2c8cf9', '马喇镇', NULL, NULL, 3367, 'aa2f26e5-9705-4dc0-b54a-a2d7dbb8b511', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('293508e3-47f1-4f33-a919-4a406241012c', '治平乡', NULL, NULL, 2401, '0275a9ca-e89b-4217-b3b0-ada824d9e095', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('293577a7-0286-4bb1-880f-2c77a42a0037', '农坝镇', NULL, NULL, 175, '4f867632-2989-4def-9934-a9c5fe0d5ca5', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('293fdd43-3b5e-401b-9e6a-b51a95f00d4d', '青神县', NULL, NULL, 23, 'a24f5cc3-558c-447d-bedc-895b418c750f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('29667fee-b598-4002-9a6c-009862840c42', '桥东区', NULL, NULL, 2764, '334645de-ae54-416a-8978-2dbf9f7bbd09', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('296ceef3-8fb0-4248-bf38-d166328505a7', '石壕镇', NULL, NULL, 3666, '6581d8db-553e-4417-8c37-91ed47904920', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2970702c-6801-4e90-8c56-df81e947e613', '长丰县', NULL, NULL, 155, '6ab7dc5a-1064-4090-a81b-79c3a2e8302d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('297c230a-853b-4389-b3b1-7be1585d9d2a', '南丰镇', NULL, NULL, 3203, '2e21ea75-c640-4928-8cb4-e5ba4f6e2ffe', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('29cd7b45-5662-4332-bab8-7375443f1e7b', '平河乡', NULL, NULL, 384, '76dd00a1-30a1-4226-ae06-cad845c0528c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('29e12195-9d36-4288-a66c-f4cf517c354d', '洞口县', NULL, NULL, 3755, '30ce87bd-09cc-4250-9b5e-1f5916ce4d70', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2a1cabdd-7a35-4fb9-93a4-a28f902c8b5f', '廊下镇', NULL, NULL, 2706, '0e5598a8-f405-4745-8cd5-a7a4c99f67f9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2a3c3c77-3a69-4c7c-bea0-39667c2524df', '泾县', NULL, NULL, 1048, 'a489375e-6a4e-410b-be41-f687ba6c52cf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2a3d16b1-3588-44b4-8cb6-ccbfe0791efa', '贵德县', NULL, NULL, 4073, 'ed217127-f5a1-4f77-b32d-75d0114bce26', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2a47f5b6-bb0e-40ce-b263-8c6ea1f22ed3', '邮亭镇', NULL, NULL, 1655, 'a560b8db-8db1-4bc8-bb6b-fbbecebcaf10', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2a62a9d7-2179-4598-90cd-471952cae0ac', '鄂伦春旗', NULL, NULL, 1066, 'c31a65eb-4d77-4b38-8142-9c9e2f54ed46', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2a64fa74-7c3b-4e62-bc95-6c44475f1d11', '珠溪镇', NULL, NULL, 1653, 'a560b8db-8db1-4bc8-bb6b-fbbecebcaf10', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2a653289-0ea0-4843-aff2-b40426fe3b1c', '仁寿县', NULL, NULL, 19, 'a24f5cc3-558c-447d-bedc-895b418c750f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2a7762b0-4406-4a41-81d0-538cc39a5c8d', '思南县', NULL, NULL, 2872, 'dce7fe20-4766-408d-92be-62ba8fbb7a43', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2a7a6dc4-2c2e-4c06-8c8f-adbf1c28942d', '安福县', NULL, NULL, 4324, '5f548430-51dc-45ad-82e5-bcd0394d8f6c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2a992e27-5b7b-446c-9a13-2c11840c16b5', '措勤县', NULL, NULL, 2908, '3a856f9e-a1e5-4657-b81e-cc7d76d14ff5', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2aa74375-6736-4883-8b7a-a609bc69fe44', '高楠乡', NULL, NULL, 2389, '0275a9ca-e89b-4217-b3b0-ada824d9e095', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2abe8a73-eca9-4123-8832-068687551c9c', '荷塘区', NULL, NULL, 2607, 'cdeda821-2101-44e1-a986-183436199f05', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2ac487bf-e022-42d7-80b7-6dc9bcf67800', '雨花区', NULL, NULL, 623, 'dccf3d25-c012-444b-94c6-bbcbae7e63d8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2ae956c5-6415-4b4a-80ec-4c7bafa3ad41', '昌邑区', NULL, NULL, 1946, 'a4031322-7fba-466a-ba72-50082ab248c6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2aeb7095-000a-41f7-922e-6e446b0ad00d', '沙朗镇', NULL, NULL, 2204, 'f2727650-b0d9-4541-acdb-b4eabf894893', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2aee6852-184c-43d5-bdd6-0710a1b10d73', '城区', NULL, NULL, 1561, '5f7e2e46-8a4e-4463-907c-5762bcd006a8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2af41470-57fa-45be-839b-debfdc3ad158', '芜湖县', NULL, NULL, 3942, '5d5b2d25-fb30-4b3b-baac-c5481ccc67e9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2afbd9b8-a36c-4479-b7c3-48e8acc291de', '甘南县', NULL, NULL, 2735, 'f4e36f9a-e006-44a6-8d77-47971d41810b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2b0020d0-34c6-4716-8d5e-f6f0d596d48b', '新都区', NULL, NULL, 1798, '4f073365-4e02-459f-8b32-cad88dd22637', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2b13f43a-cbeb-4d8e-8f26-2135e3076286', '塘坝镇', NULL, NULL, 568, '8ae99c85-66b1-406b-8084-9f77cbf73b10', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2b1fa65e-11c7-4620-a552-3fb95643cedd', '云岩区', NULL, NULL, 532, '46abe060-5805-4aaf-9d89-b66bed4b224e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2b274173-08fd-49d3-b479-6afb2b77c2dc', '塔洋镇', NULL, NULL, 1454, '81aab36f-0e28-4ba3-9827-b7033fce9b24', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2b441a35-05f8-458b-a800-e1e84a365458', '彭市镇', NULL, NULL, 2149, '671275c4-6107-4968-bd8e-96d53e9995b2', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2b56a9d9-264c-440b-ae5b-f8e14d604714', '景泰县', NULL, NULL, 3096, '0fafa17c-1c8a-4cb9-a100-4cfa035e3fed', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2b5d4dcc-0b13-4f12-96fd-3334335a3af0', '城区', NULL, NULL, 1962, 'c8df6064-e107-46b5-b861-acd5b509b146', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2b6325f7-5e86-41e8-a321-ac7d897cf09b', '汝阳县', NULL, NULL, 1173, 'b5a118ad-786c-4d86-b4e8-5d25a3776a78', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2b6f1ee3-f97a-46f7-971a-7356fc21fa1f', '普陀区', NULL, NULL, 1292, '02033c55-d6b3-4a85-91e0-b68d170d3383', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2b7cce33-bc5a-4df1-bfc9-e6b7965636c8', '白石镇', NULL, NULL, 2656, 'e509a1a5-95da-4fb2-9a2b-f84afa05a36c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2b7d7c6c-1b1f-4880-8a8a-e9cc04df84b2', '浩口原种场', NULL, NULL, 842, '24ad0708-80a9-43b1-8e1c-758f2492d3f6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2b7faa8f-7500-442a-b8a2-f6ab7b1d64da', '仁兴镇', NULL, NULL, 4089, '5d3b3a34-50c8-4a01-83b7-e3e068d5c9a7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2b8f5616-9cf0-4c06-835c-ee23fd8f2970', '龙子湖区', NULL, NULL, 885, 'be39aa7b-a993-4abd-956c-dcb299cc7bc3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2b8fe081-b144-40fb-a739-0f9ada5f4173', '刚察县', NULL, NULL, 3785, '583dc13d-fce3-4f8a-b534-f717ec055405', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2ba6381e-bdb8-4247-8a3d-35c50ae982eb', '宁化县', NULL, NULL, 274, 'cae0a47d-0d79-4fa6-aac9-e8b3b535ee3c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2bab2836-ed9b-4a4a-b1a1-a44a81666af4', '吴家镇', NULL, NULL, 2511, 'd998f8bc-c659-47ce-8e5e-a6b29e03ecb3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2babcd05-89fe-4b1b-8ad4-97bc64f7af5a', '南溪县', NULL, NULL, 1818, '18a8dd20-aad4-43cd-ab48-ab6108097d8a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2bada05b-9a79-4134-b1f7-e732fa27a697', '萧县', NULL, NULL, 4100, '94f58cdc-52ca-4a35-a822-4b62ab8bd3d7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2bc285ea-3370-4f37-9d70-1308b2bf3ae8', '全境', NULL, NULL, 2419, '291193af-b923-45d1-8597-2d00a0f4ad51', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2bd8af17-cc0c-4b7f-9d69-fe9669716735', '会同县', NULL, NULL, 2018, 'd133a3fc-3db0-426f-8a04-e25b44a5565c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2bdbd6e8-2366-4565-adfe-b4ea7bc247bd', '来苏镇', NULL, NULL, 410, '9d7d52af-ec34-48e3-b81d-09ac51e11590', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2bdc188a-1fc8-4c09-b2c0-6d682c5db0a4', '乐至县', NULL, NULL, 3016, '951c8fd2-5d67-4ba4-b9a1-fd13fdcea9f9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2be3da70-32c6-4d88-9ae4-6e060db1b67c', '杭锦旗', NULL, NULL, 3533, 'eb551697-7acc-4bcd-9d21-3d48c16f8258', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2be63d66-08b1-418f-8305-266cfd64281e', '扶余县', NULL, NULL, 4442, 'a632ea02-ee66-43f0-b946-2bce0ba5396a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2be9ce7d-f02f-4547-88c1-4a9e88dbac8b', '堡镇', NULL, NULL, 3978, 'fcc07455-c69c-4c90-82cb-ddb268adb8a9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2c102d9b-cb2a-45ba-bac3-aa10830df6b7', '新野县', NULL, NULL, 741, 'a769a530-0bcf-4e52-a9e5-3a8f5af945d2', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2c136b93-c351-4b25-8e44-12868e608ee1', '盘山县', NULL, NULL, 1998, '9d95b0ef-0bbc-404d-80d4-2143f433a4c2', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2c267d94-8fe1-413b-adf5-4289732cf42f', '大邑县', NULL, NULL, 1811, '4f073365-4e02-459f-8b32-cad88dd22637', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2c3c8903-e309-4dd1-8a14-3388f2403f92', '石鼓区', NULL, NULL, 4258, '75dd761e-ce3f-45bb-a86b-d3a1e2c7629a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2c427217-d2cf-4a0f-b950-4c0dc695af4f', '革吉县', NULL, NULL, 2906, '3a856f9e-a1e5-4657-b81e-cc7d76d14ff5', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2c482a71-b2ec-4bb4-9de1-ea5f99b109dc', '玛曲县', NULL, NULL, 3131, '9d7c5001-b115-4bea-abb4-a289a03b5075', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2c50c0eb-7002-4424-88a1-25fa72982705', '隆子县', NULL, NULL, 1021, 'f7038861-43d2-49c3-a5c9-53fde2c139fa', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2c5cfe03-fe62-4a72-ab38-169f5924419a', '安新县', NULL, NULL, 2483, '81e22d56-a1c7-4263-be18-81a4af165ae3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2c84be32-bcf4-4e19-a651-829ecb3918bb', '社坛镇', NULL, NULL, 1925, '442f465d-6566-45e4-9338-50f4395aa6f7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2c853dc4-c9c3-451c-bea5-ca1b308ed5ed', '勐海县', NULL, NULL, 2007, '69f08469-ecd2-4a94-a921-da836fbf5838', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2c8ef9ca-5595-4a8c-a71d-d20a0ce47a0b', '乌拉特后旗', NULL, NULL, 1685, '753245e5-8705-4940-badd-cd71430a4fdb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2c97235a-e19c-418f-84dd-d74a78ab6752', '仙居县', NULL, NULL, 3289, 'de41020d-a8dc-44d0-a2d4-75b6076c0ae8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2ca502e3-1e33-4509-9d74-e76aadce095b', '东太农场', NULL, NULL, 1458, '81aab36f-0e28-4ba3-9827-b7033fce9b24', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2cb29b57-eae1-4625-bd43-799fd33958a9', '松岭区', NULL, NULL, 3043, '1b8b9a84-0955-4d1e-8f33-8de97af3bedd', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2cb8abcb-b601-48ef-9e90-d64347815648', '金山镇', NULL, NULL, 944, '88260608-a8b9-4b52-a474-1a551465c675', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2cc8a8c5-439e-4d48-bf47-1b4a65bbc301', '连湖镇', NULL, NULL, 1878, '2c8bc8c3-9317-4f36-a0ad-05a8d6b27053', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2cca3215-13fc-4acb-9a7c-cc4216c6dab8', '东溪镇', NULL, NULL, 3659, '6581d8db-553e-4417-8c37-91ed47904920', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2cd87459-db13-4fa3-9ec3-df41392d7a8b', '炉霍县', NULL, NULL, 3771, 'c262a40d-a147-4930-b33b-574ec51fa884', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2ce7b6b9-c9e0-4c49-8339-8bf36101da6c', '军庄镇', NULL, NULL, 3575, '5d21af6a-f035-42f4-a0cf-ff1fd3d36f3b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2cf0c556-bc5b-41cc-b9b4-e94b0f2c1bd7', '韶山市', NULL, NULL, 4313, '40852955-b0b0-4a50-b4b2-201be5c3808b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2cf2bcde-2876-459b-90c1-6ce05628383e', '城区', NULL, NULL, 2565, '727ca4ab-f7fc-49fb-9b2b-569d2fc79aa4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2cf840b8-ef88-428f-9e80-8a42dd58b510', '景宁县', NULL, NULL, 2374, '982c089d-7fb7-4cdc-a3c2-865e4637006f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2d05d6ee-1f68-42fb-a984-7648d1288a57', '三驱镇', NULL, NULL, 1643, 'a560b8db-8db1-4bc8-bb6b-fbbecebcaf10', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2d0cf163-8908-44a3-bd0b-b0c927ff3971', '唐镇', NULL, NULL, 2629, '4683d3ef-0edf-425a-98d5-2cb231a7d88a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2d1dd5f5-4dbf-4a71-9aca-6922891bd5aa', '洛江区', NULL, NULL, 1860, '0d3bd52a-74b2-4461-9a57-17c7cce4ac1b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2d21236e-adf2-4038-a637-9d7eab93a2ac', '川汇区', NULL, NULL, 2302, 'f3e12d68-f8c5-4d9d-8314-dd1ce7dac2f9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2d51b413-bcef-4c1f-b0df-01e35664b5e3', '古冶区', NULL, NULL, 2454, '4f4c1ef4-f54d-4ba4-a124-ca2d3d0ddb78', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2d52b39d-9230-473d-a49b-0fbe93a4ea0a', '双路镇', NULL, NULL, 1928, '442f465d-6566-45e4-9338-50f4395aa6f7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2d54d4bd-10d9-443b-bb98-1b44ee5ba37e', '伊金霍洛旗', NULL, NULL, 3531, 'eb551697-7acc-4bcd-9d21-3d48c16f8258', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2d67c09e-bd4a-4b4a-a949-a2e6564f903e', '彭泽县', NULL, NULL, 112, 'bcaf1f36-5459-4e74-81d1-5026680b1a9c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2d8f4f03-7a55-4f91-b48d-b6b674c88092', '琼结县', NULL, NULL, 1016, 'f7038861-43d2-49c3-a5c9-53fde2c139fa', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2d9f0de5-3de0-4422-996b-15103228e25b', '和布克赛尔县', NULL, NULL, 2724, 'a419fd83-e078-4430-aa48-ca9aa67e4fff', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2da1ab9b-af81-4497-beaf-ee55f7c50e01', '东区', NULL, NULL, 474, 'dfb8b556-10a2-43ab-9fdb-66cde92320ee', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2da1dd99-f601-4de4-887d-4d0ca49f5c25', '惠济区', NULL, NULL, 4127, '4ff4ef6c-41df-4562-a58f-d8b25b2e3ba4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2da76009-f44a-4e54-bdac-41f3b0ac6d39', '扎赉特旗', NULL, NULL, 2972, '9758648c-eab9-4434-b7ae-318e7e08548e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2dc43564-161a-490b-b9f0-2ac1e6de3d38', '城区', NULL, NULL, 2291, 'b3792f06-9c78-446e-b6ac-d95d5e9092e8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2dca3c8d-7142-4750-b617-ed13d8a7731a', '文化镇', NULL, NULL, 657, 'd7f44c2a-2728-4633-a8b6-7643136bc99d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2dcf07e1-9b1b-45d9-9b4d-cabadda4c01b', '二七区', NULL, NULL, 4115, '4ff4ef6c-41df-4562-a58f-d8b25b2e3ba4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2dde85ae-d02b-473e-bc41-ee1a5be2f624', '汾阳市', NULL, NULL, 3408, '9348509b-6d82-47e7-86d7-f054fb47b7fe', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2ddfd840-d6f4-4bb4-a462-5f83afc638ee', '回龙镇', NULL, NULL, 1648, 'a560b8db-8db1-4bc8-bb6b-fbbecebcaf10', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2de6e14e-d353-4135-8a63-31c20dd78967', '张家湾镇', NULL, NULL, 2128, '88d84710-80d6-4837-b889-286c74d7940d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2df2fd22-6238-43e8-bddd-586211bef834', '龙市镇', NULL, NULL, 3893, 'a732da28-870c-4d9c-a287-c2c1e3222b59', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2df63f94-157b-41c5-8380-d0c93530c140', '文山市', NULL, NULL, 2219, 'fadbb851-aec5-4d3e-be0e-09e7462eaceb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2e15d4c5-2197-448c-8953-62fda3091dbb', '广陵区', NULL, NULL, 3049, 'f9ca7af3-a2b5-4d1c-a8c5-c4dbe4fe60e1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2e29e4d0-6a69-43e0-a83b-e1675014e71f', '东丰县', NULL, NULL, 3, '7845d9d9-ca44-43a0-93d5-602fdb04ef55', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2e3179a6-a452-41d2-9a92-30fb78153954', '长坪镇', NULL, NULL, 4226, '0ee28cef-8dfc-4a9f-b7c1-330bc11c1bb3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2e3b46de-90dd-4cca-9d96-b399ecedc00f', '南丰县', NULL, NULL, 3948, '1e0a806c-ad0b-4e9f-a488-8bf9fc903f4d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2e5fb5e9-b193-4c8d-838f-ef8e1e022f77', '淳安县', NULL, NULL, 2318, 'f530455e-1c70-47dd-9a80-4bc74a4e2680', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2e75242d-ea84-4b84-9cf8-a32debd9d03d', '同心县', NULL, NULL, 604, '9d872dc5-ad1a-4b3c-86de-debd1a77eb8c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2e7592a5-be15-481c-9142-ac2a21b2a627', '凤鸣镇', NULL, NULL, 166, '4f867632-2989-4def-9934-a9c5fe0d5ca5', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2ea0c375-d170-4ef3-a629-9038f695f1ee', '龙湾镇', NULL, NULL, 836, '24ad0708-80a9-43b1-8e1c-758f2492d3f6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2eab6185-cc64-47c1-8d4d-817287675c08', '龙门县', NULL, NULL, 78, 'f951b5e7-debd-4c51-9c02-03ebe84ebbfc', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2eb0091f-aff9-42b1-ba73-572fd395977d', '霞山区', NULL, NULL, 2595, '5c5b11a0-6a29-4173-b876-8fdbc543cb2b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2ed82f19-6cac-4872-8d0f-e45c11c0c36a', '香龙镇', NULL, NULL, 3891, 'a732da28-870c-4d9c-a287-c2c1e3222b59', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2ee65283-e884-48fd-9e20-c1df46ac1d45', '保康县', NULL, NULL, 1344, '52d3ef0d-d999-4ae8-971b-534a2b25de02', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2eea738e-098f-4181-82c1-f3cc3f44e931', '洪江市', NULL, NULL, 2017, 'd133a3fc-3db0-426f-8a04-e25b44a5565c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2ef3f3bf-1dab-4d6a-a006-260feaccce4c', '安吉县', NULL, NULL, 4198, 'af4299a6-6902-4c79-bc49-f7b3f3c6f683', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2f04b52f-eee1-4748-8b8e-c6731eee683e', '雁江区', NULL, NULL, 3013, '951c8fd2-5d67-4ba4-b9a1-fd13fdcea9f9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2f1f5223-c60f-4f18-932f-408168556e7f', '天山区', NULL, NULL, 3229, '8349c2b0-91a2-4e19-b9c7-81b5224fbabe', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2f4d8289-5ac4-4831-b72e-69f3e73ff3a1', '龙田乡', NULL, NULL, 2396, '0275a9ca-e89b-4217-b3b0-ada824d9e095', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2f5dc80c-f7f9-472d-b4fd-ba22a3129a5e', '富顺县', NULL, NULL, 1692, '39b19556-caa3-41de-a70f-2d81f23db54d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2f8ea3f8-946e-43c5-a0e1-8aac49763e95', '岳阳县', NULL, NULL, 2270, '8369850a-f796-470f-902f-393cfb615571', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2f96066a-c270-4063-87a5-3a1ad1a78916', '城区', NULL, NULL, 3870, 'a732da28-870c-4d9c-a287-c2c1e3222b59', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2fc71b5d-6979-47d9-84a0-6df4acd61817', '庆安县', NULL, NULL, 3561, 'fcd4a18f-a57a-47c4-b2f2-504bc8bccb20', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2fd2717f-28a9-4442-b0ae-377bb133ffdf', '皋兰县', NULL, NULL, 4047, '2d364b6d-2931-4d45-995a-336e4e0f2b55', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2fd7d36c-9e98-4546-8b8e-6eb8e6efca5d', '黟县', NULL, NULL, 4277, 'e3fa5765-1e86-4f89-a751-2f63dbe81c99', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('2fed580d-2dda-4b2f-a204-d676f8dea68f', '麻江县', NULL, NULL, 3082, '6d3a8433-1273-4323-a3eb-d39effecc1d7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3002bef7-0ee2-4714-ad03-ad7aa063ead8', '阳日镇', NULL, NULL, 3070, '4b20c67b-06ca-4c0b-a947-bc518238537e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3038bcbf-66d8-4e2b-b072-9ac265784331', '荃湾区', NULL, NULL, 488, 'dfb8b556-10a2-43ab-9fdb-66cde92320ee', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3039df55-95b9-4e78-8b70-da3ce778e5fd', '赵全营镇', NULL, NULL, 3744, 'd1c1539c-b904-4bcc-a034-96213f63d0ff', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3046b6c3-a319-46d1-945b-9204db0ab2db', '邕宁区', NULL, NULL, 2811, 'b53ced47-2455-44ec-b740-7637148f574c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('304dce56-a76c-47cb-9bfe-0c1a78e1f721', '遂溪县', NULL, NULL, 2597, '5c5b11a0-6a29-4173-b876-8fdbc543cb2b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3070f85f-7f83-460b-a902-817cf107954c', '黄流镇', NULL, NULL, 2558, 'a1e3332c-7029-4de7-a221-40c041a9a620', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('30865f25-de74-432d-870c-573a48d01a95', '子洲县', NULL, NULL, 1299, 'c0c88cbd-87ea-4281-9e8e-94a435ae6590', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('308a4833-612f-4004-b5fa-47ddd3fb2976', '城区', NULL, NULL, 779, 'af6f4f65-b2db-4670-88ca-21de1de477fc', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3098bed5-3129-40c5-8a36-4f128bad7bad', '三泉镇', NULL, NULL, 947, '88260608-a8b9-4b52-a474-1a551465c675', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('309bcda2-499a-45ee-b957-742529647240', '新宾县', NULL, NULL, 1381, '6b5fed36-b200-40ca-af0b-11999b4399ef', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('30a5504c-df03-4817-a664-d440201a9902', '金山镇', NULL, NULL, 1649, 'a560b8db-8db1-4bc8-bb6b-fbbecebcaf10', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('30ae074a-3150-4dbc-be69-ed15dec1a61f', '古塔区', NULL, NULL, 1072, '99f84690-670c-4a0e-ade1-ebcf17b00adb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('30b06ab0-9d45-4dd7-bbba-d0c665cf0f6b', '左贡县', NULL, NULL, 2695, 'b7342349-941d-427d-9ab6-e83a36078088', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('30b5e8db-2dde-4a52-8980-ea719b3f1af6', '应城市', NULL, NULL, 2757, 'caa97f6a-9b5e-4871-968e-42852537e6f0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('30b9d6bf-ce3e-407c-a184-da4c43cd6a4d', '西区', NULL, NULL, 1664, '8e1185d8-66bf-4f53-8ffc-ae9aad60cac2', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('30cfeef9-4c42-4059-9535-1ddd12d3e911', '日喀则市', NULL, NULL, 3638, '5800fbac-51b0-4bc6-bc2b-34f78067fc28', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('30d8f4e6-9f76-4518-8e32-589badaf72bf', '朝阳县', NULL, NULL, 4137, '0c1d1a8a-4eea-4aa0-9a5e-b68ae380a09a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('30fadf37-3edd-440d-b72f-234781267dd4', '博乐市', NULL, NULL, 4270, '4a8f2a43-831a-4413-b4b5-2de877d9b166', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('31242ec3-3827-4518-b428-204658bb1cc5', '中益乡', NULL, NULL, 792, '0f559985-f6fe-4a8f-af80-3d0d64932dbc', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('312506f2-ecef-42b7-9635-62644634e4d5', '富裕县', NULL, NULL, 2733, 'f4e36f9a-e006-44a6-8d77-47971d41810b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('31349734-126e-49e0-bc9a-793dd086725a', '东升农场', NULL, NULL, 1460, '81aab36f-0e28-4ba3-9827-b7033fce9b24', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3167e821-627e-4586-8dd4-633665c1e395', '北小营镇', NULL, NULL, 3722, 'd1c1539c-b904-4bcc-a034-96213f63d0ff', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3168e23a-ac91-4fc1-85dd-1934f407de0e', '会宁县', NULL, NULL, 3097, '0fafa17c-1c8a-4cb9-a100-4cfa035e3fed', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('316907d7-d6d4-4b20-9adc-5758b709b741', '东兴区', NULL, NULL, 1994, '7e24b0e5-bf57-4e62-880a-e5b6ec159053', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3172ec6b-9f53-4748-b2c0-95651d3b80a9', '重兴镇', NULL, NULL, 3796, '96fec37f-11d5-4d41-aba4-a36d0652744c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('317c8b38-0067-43e0-be44-b56fba6fda3e', '怀远县', NULL, NULL, 881, 'be39aa7b-a993-4abd-956c-dcb299cc7bc3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3181936f-f1ac-44ce-a2f6-4f3bdb1fd42c', '遂昌县', NULL, NULL, 2372, '982c089d-7fb7-4cdc-a3c2-865e4637006f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('31852bd7-7f80-43f1-9228-87c59f9ff194', '赫章县', NULL, NULL, 2618, '55fdf7c7-6698-498a-8aef-b9455ab7926c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('31a7d54b-83e7-4a36-926f-87b9ecadca7d', '修水县', NULL, NULL, 114, 'bcaf1f36-5459-4e74-81d1-5026680b1a9c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('31b77383-b726-4298-a724-457e9026701c', '城区', NULL, NULL, 1637, 'a560b8db-8db1-4bc8-bb6b-fbbecebcaf10', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('31bc1096-35f4-4b74-8f28-da45e07cb6bd', '七里河区', NULL, NULL, 4040, '2d364b6d-2931-4d45-995a-336e4e0f2b55', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('31c79f47-ebb5-4a7e-997f-2cbfa6d1c08a', '章贡区', NULL, NULL, 1604, 'dd4a8577-afbe-449b-ae9b-be374a4c7434', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('31cf1630-9e21-448a-bd83-3017c62a97b4', '翁牛特旗', NULL, NULL, 4473, '4b199fdb-3a49-40f7-9843-8bd43f4ea30c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('31d3a16f-8d78-46ae-9b22-5069c352749f', '万荣县', NULL, NULL, 4113, 'fc30b5e5-3005-4778-94f7-706b31514bff', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('31df7f7f-444f-468c-8e40-4939ed21bcc8', '致韩镇', NULL, NULL, 1129, '72d4f69f-2e4c-4bde-9df8-2aadc9168686', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('31e2d0cd-e0dd-4af8-98e6-2582fe81c324', '金鸡岭农场', NULL, NULL, 1571, '5f7e2e46-8a4e-4463-907c-5762bcd006a8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('31e5d6a1-5f76-4fa4-8ae0-020584c61548', '尖山区', NULL, NULL, 2249, '69696549-d65b-4e13-80ef-05ecaf0f61e3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('31ef1ba9-634e-4133-a83a-c56fe4ad5709', '松滋市', NULL, NULL, 877, '7fe0855f-3ef6-419b-a145-5994fe28cc8f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('31f6ab48-726d-4d22-85a1-76d986ea6610', '金安区', NULL, NULL, 286, '4ee9594e-d779-4cad-a3bc-d766de26628a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('31f834b2-e89b-4cfe-b6b4-5522a87a0749', '德清县', NULL, NULL, 4197, 'af4299a6-6902-4c79-bc49-f7b3f3c6f683', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('31fa46bf-7f53-4cd5-80fd-fb01241d12d3', '永宁镇', NULL, NULL, 1506, 'd5ab951d-20ab-46ff-8838-de5efe06b6b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('320729cf-0308-47e1-8639-3894129f5635', '爱民区', NULL, NULL, 1966, '1c2bd9d2-bc08-486e-a5f3-ba5de82c6365', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('32119b10-bc4a-443f-b210-94bc26c2d7c8', '青龙镇', NULL, NULL, 1089, '79482cd9-7d51-4c89-94c2-4bcd773b8323', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('321a191e-c28d-414e-b0ac-774594e631ab', '栖霞区', NULL, NULL, 1868, 'adb7aa6e-99a6-453f-a2db-21ecfbc44874', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('32230747-976f-4cac-b529-85f56598e020', '阜宁县', NULL, NULL, 4368, 'b85d2a61-b018-431a-9609-2ca0841f5cab', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3230cedb-f6e8-42ac-bfe7-f382db35d042', '莱州市', NULL, NULL, 592, 'f3717726-7743-4838-852b-3a09f9528a69', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('32502fcd-77cc-4a66-ae75-35f8f4c41ef3', '阳江镇', NULL, NULL, 1451, '81aab36f-0e28-4ba3-9827-b7033fce9b24', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('32509a9e-98fb-41b1-86b9-94e266eada78', '鹤峰乡', NULL, NULL, 1098, '79482cd9-7d51-4c89-94c2-4bcd773b8323', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('325e2305-2dca-45d7-8822-4149c4a0a2ac', '主城区外', NULL, NULL, 1366, '5a1e74c1-6f4c-440f-8ade-ac470f4ada87', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3287791a-ce36-4fb0-aab3-0df831fb76e3', '新立镇', NULL, NULL, 2681, 'e509a1a5-95da-4fb2-9a2b-f84afa05a36c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('329b4bf6-5169-48b0-a207-efad186ddc09', '兴隆镇', NULL, NULL, 1092, '79482cd9-7d51-4c89-94c2-4bcd773b8323', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('32ad594f-21eb-47b7-9c49-a4781a40f1a1', '毛坝乡', NULL, NULL, 2936, '465e9ea2-a2f2-4b42-95dd-b48d91f67105', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('32c77566-7a11-4235-b306-d59bd06583c0', '永安镇', NULL, NULL, 1081, '79482cd9-7d51-4c89-94c2-4bcd773b8323', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('32cb69e7-1117-45d8-b943-3c92d7302cd9', '乌什县', NULL, NULL, 4404, 'b7bc3a10-ad00-4b20-9fa4-cb08ad7492d3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('32d20970-f466-4531-891d-0e7f10eb2d54', '凤凰镇', NULL, NULL, 3909, '7fefd2bf-99e0-43f5-bc37-9ab15ee8e8f3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('32d216b5-d45c-4951-9de3-bb11dd1614ef', '渝水区', NULL, NULL, 2968, '72738f5c-f5f3-4895-8ada-20327c2d5826', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('32f0e909-c9e6-4b81-92ae-d2575d041a29', '新浜镇', NULL, NULL, 94, '3e082d1b-ecb4-4bf8-8715-54132a9106e1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('331bc0cd-3e82-4564-8a45-87701f2719af', '郏县', NULL, NULL, 3388, 'f5ebab20-0f47-47e8-b896-6f3d9651c97a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('33206dd6-e2d4-4e86-a777-29563bc89416', '龙陵县', NULL, NULL, 3147, '3fbd3d32-e8e3-476f-9f4c-319ffaaed527', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3320c4b7-ef79-4553-97b0-eaf574c47ed4', '仪陇县', NULL, NULL, 1254, '71643995-698f-4bdf-afe9-09fce8a065c0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3338697d-ee5b-495f-a196-5aa2f3e31795', '涿鹿县', NULL, NULL, 142, '37614653-bf6c-458f-a844-540790491eb1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('333b4488-f556-4cf6-98e0-dedc370f715e', '昌宁县', NULL, NULL, 3146, '3fbd3d32-e8e3-476f-9f4c-319ffaaed527', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3362da36-ea33-4eaa-abb9-c87e3325ee57', '振安区', NULL, NULL, 2796, 'c0064cbf-ba5c-4dc0-a855-b330e096cd61', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('33657e9a-d7ee-43ef-b94c-2050be921757', '沛县', NULL, NULL, 4431, 'e20441c5-c8b4-493a-9738-2327e656fbcb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('33690f34-3acf-4425-b0b9-28f5d8a045a1', '永新镇', NULL, NULL, 3670, '6581d8db-553e-4417-8c37-91ed47904920', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('336ecaf6-6848-46c9-8ccb-a81dfbe0f139', '南山区', NULL, NULL, 673, 'fd718129-208d-4a94-9e52-7516af8ef013', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('338732e5-37fe-4e2b-bd2c-1e8d1bb1ad3f', '黄平县', NULL, NULL, 3085, '6d3a8433-1273-4323-a3eb-d39effecc1d7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('338b5acb-33a2-4165-a64b-7ab1faf18687', '广南县', NULL, NULL, 2222, 'fadbb851-aec5-4d3e-be0e-09e7462eaceb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('338e6f1b-ad7c-497d-832a-00bf180b8b02', '灵武市', NULL, NULL, 4280, '2a45fee0-aa22-4471-be1a-0f6edce52b7a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('33ab0e54-4897-4c02-b1c8-928dcd7adbfd', '李河镇', NULL, NULL, 4210, '0ee28cef-8dfc-4a9f-b7c1-330bc11c1bb3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('33b4e3e9-3ba6-4cba-aaa5-bf724abc26be', '裕华区', NULL, NULL, 2765, '334645de-ae54-416a-8978-2dbf9f7bbd09', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('33cf0a5a-8a08-4243-af82-41e5449a6e04', '萨迦县', NULL, NULL, 3642, '5800fbac-51b0-4bc6-bc2b-34f78067fc28', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('33df05e9-2886-4ca1-a4fa-0c0023e6ac60', '焉耆县', NULL, NULL, 3181, '0ce20b86-8bea-4d7c-a1e4-09c7519d8b16', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('33e5ea16-a0c9-4220-9ae8-5a27f7476901', '县城内', NULL, NULL, 3244, 'a39ced08-b6e9-4de0-a2db-7a230a673d1e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('33edca33-bd51-4ac0-aa80-2788567c2e49', '静乐县', NULL, NULL, 2839, '18b3c51b-f699-467d-a342-d78bf9cff362', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('33f2a02e-7c3a-4617-bac7-7fe9a96150eb', '天峻县', NULL, NULL, 3007, 'a638060f-a01c-4c77-b905-b46ef8d3e89d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('33ff6904-174a-41a4-b1c4-4f9918a1addc', '铁西区', NULL, NULL, 2014, '48832e11-ddfb-478a-9787-e46c47346d7e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('34126b3c-5b10-4018-aa47-12d5f65dd46b', '亚东县', NULL, NULL, 3650, '5800fbac-51b0-4bc6-bc2b-34f78067fc28', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('34326fb3-ec39-4df2-b88e-d5324e9ee6ac', '大台镇', NULL, NULL, 3572, '5d21af6a-f035-42f4-a0cf-ff1fd3d36f3b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('34397ca1-59a6-4794-89a3-3e1cb94d9858', '义马市', NULL, NULL, 3998, 'ba612057-dda4-4e54-9951-f847a74f623e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('34671ce1-ad65-49ee-8756-dfc8bfc8d963', '仙游县', NULL, NULL, 5, '7acdab30-849a-4c32-b081-8cbdc15f711a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('346e1c8b-5614-4742-87af-0d63b38ffb4e', '红塔区', NULL, NULL, 4142, '2b997404-05c1-436b-8004-2d5dfd364db3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('346e5e79-61ac-4eb8-845a-7f1c4650ee21', '太极乡', NULL, NULL, 3379, 'aa2f26e5-9705-4dc0-b54a-a2d7dbb8b511', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3476b91a-bd55-4abc-9f78-93124589ee1a', '山丹县', NULL, NULL, 688, 'dcdb1184-ab1f-4332-8ca0-f4edfd7cc087', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3478e9bd-c2ca-4a32-a3b2-a9035d20883d', '故城县', NULL, NULL, 2469, 'b126935b-0423-4bea-b802-d4e6680d1d71', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3482bdbf-fdf6-4663-b719-e3e8ba9214f5', '江夏区', NULL, NULL, 424, 'e6e46871-d5a0-4d2b-8243-9d4bd864ab43', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('34853b6d-a837-4052-82a3-e6e022ac95d0', '毛阳镇', NULL, NULL, 12, 'c8bf9a67-2bfc-47fe-9580-3f2f2eac1edb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('348df8bf-e525-4605-bd7f-692942aa9e8f', '平桥镇', NULL, NULL, 4449, '4888e1e9-ba45-4254-83e7-87796f338e2d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3496c813-70c3-46ca-ab0d-e068f9bb43b9', '竹根滩镇', NULL, NULL, 827, '24ad0708-80a9-43b1-8e1c-758f2492d3f6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('34ab9e56-83b9-481d-9d0f-f249a00a6599', '芦塘乡', NULL, NULL, 1894, '2c8bc8c3-9317-4f36-a0ad-05a8d6b27053', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('34b6eb75-be1c-4589-87e8-1f01d07a2424', '漷县镇', NULL, NULL, 2127, '88d84710-80d6-4837-b889-286c74d7940d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('34bc6a9a-48b9-4965-84d2-04a16c0978f3', '北川羌族自治县', NULL, NULL, 394, 'efb72ec7-b29f-48d0-a16c-9a33d3938d49', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('34c44dae-4788-4d21-8bbf-fb3107454a6b', '长葛市', NULL, NULL, 3565, 'c2e61b39-2188-4b9c-a36f-ef7b600b0188', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('34e0998e-f80a-45e4-bb25-4e44514b1f49', '崇礼县', NULL, NULL, 139, '37614653-bf6c-458f-a844-540790491eb1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('34ea3874-97eb-4577-a9c2-44c3536c6d8b', '秦淮区', NULL, NULL, 1865, 'adb7aa6e-99a6-453f-a2db-21ecfbc44874', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('35029615-fecd-4414-908d-3ff37782a579', '长泰县', NULL, NULL, 1206, 'bda1d0f2-1476-4e0d-8fb9-2d1392397cbb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3504e1f3-ad13-4d40-b2b3-2d3b1a6883f7', '安澜镇', NULL, NULL, 40, '43c813e3-8672-45c5-8d3e-9ee43dbe51c8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('35099e70-0eec-4fef-8c1d-eb9b8a461acc', '长桂乡', NULL, NULL, 1601, 'ac0e6e50-b6a1-457c-811c-06ac309cd5a3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('352247e1-82e0-4e5c-8153-eb259287b1f6', '龙形镇', NULL, NULL, 562, '8ae99c85-66b1-406b-8084-9f77cbf73b10', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('35246412-008a-48d7-bb8f-60768104422f', '宜黄县', NULL, NULL, 3954, '1e0a806c-ad0b-4e9f-a488-8bf9fc903f4d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3539baea-a0da-4c0f-a4f5-eb12235a0b6f', '昭苏县', NULL, NULL, 2588, 'e6f53877-d5bf-4b42-aded-5ab8960ef034', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3554581a-cf80-46c3-b949-3bab2e1965c2', '坦洲镇', NULL, NULL, 2200, 'f2727650-b0d9-4541-acdb-b4eabf894893', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('35598441-4c39-4581-8885-b93dcfedec3e', '新生镇', NULL, NULL, 2671, 'e509a1a5-95da-4fb2-9a2b-f84afa05a36c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('355b4756-b03e-4007-ad91-b5483ada0365', '惠阳区', NULL, NULL, 73, 'f951b5e7-debd-4c51-9c02-03ebe84ebbfc', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('356dbb3c-98a2-44b2-b6af-70705d2a23cd', '江源区', NULL, NULL, 1396, 'baaceb68-ffec-405f-8bcc-9d58ab5a0c1e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3573daf7-bb6b-47c1-965b-fe10c0905674', '普格县', NULL, NULL, 3511, 'c8f594a3-8acc-48a9-ba2f-e76934de05eb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('357a6ad7-2713-45b0-b869-df9ae86a184f', '殷都区', NULL, NULL, 2568, 'd94ce52b-fe8c-47d7-9b1a-d37da377cbbe', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('357d82c8-f31c-4e45-8dc1-dc87c051b05e', '聂拉木县', NULL, NULL, 3636, '5800fbac-51b0-4bc6-bc2b-34f78067fc28', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('35897b35-8cf1-4058-bf56-4e51b0bf2da8', '嵊州市', NULL, NULL, 1421, '472589fe-78e1-4c48-8fde-cf3996a778ca', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('35b406f7-bc2f-4933-99d7-4dd2bcb2ed94', '让胡路区', NULL, NULL, 2362, 'c5e2b320-fd7d-448b-9a02-4fb93e1d3302', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('35e23214-49ad-45e1-9283-06a26f09fa91', '金塔县', NULL, NULL, 2425, '42852584-118b-41cf-ba7e-db28102a593a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('35ff97ef-4ac5-4456-9c0c-e368fb053bf1', '郾城区', NULL, NULL, 4130, '55b0b2d6-58e4-40a1-b278-e63aa372ba29', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3603b4de-ba84-4a4c-bbca-e13ec4159ff3', '松山区', NULL, NULL, 4480, '4b199fdb-3a49-40f7-9843-8bd43f4ea30c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('360a39f3-4c14-4730-80f3-b3c2383e4afc', '大观镇', NULL, NULL, 941, '88260608-a8b9-4b52-a474-1a551465c675', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('361036ac-d981-438b-a4e4-56742aa4cf18', '鲁山县', NULL, NULL, 3390, 'f5ebab20-0f47-47e8-b896-6f3d9651c97a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3611b07b-e18d-436c-9251-9e1acadb42a5', '西平县', NULL, NULL, 746, 'a096e337-c439-4751-a014-b49dd13bee26', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('36219f72-b720-471a-98b5-eaf8afd098b1', '南通镇', NULL, NULL, 3677, '6581d8db-553e-4417-8c37-91ed47904920', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3628f6bf-8e61-4ecc-81e5-2e306058f2f7', '青年镇', NULL, NULL, 3678, '6581d8db-553e-4417-8c37-91ed47904920', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('36352a72-c3ba-4cee-bf6f-72eb5c322924', '定福庄', NULL, NULL, 1698, '576c43af-0a86-47d9-83a7-4989ce3b3dc7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3635b605-eec7-41ff-aeaa-fe8a99e1b883', '叠彩区', NULL, NULL, 3185, '796bb0e0-6b76-4c1d-801f-2dbcbab74087', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3644dec7-9221-4529-bb47-4852f82d0ac6', '后沙峪地区', NULL, NULL, 3726, 'd1c1539c-b904-4bcc-a034-96213f63d0ff', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('364990a9-6bcd-46de-89a1-13a01a60ba18', '当阳乡', NULL, NULL, 375, '76dd00a1-30a1-4226-ae06-cad845c0528c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('364a5e3b-24d8-4c71-97ba-49d8dcc71abf', '兴海县', NULL, NULL, 4074, 'ed217127-f5a1-4f77-b32d-75d0114bce26', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('364c1c97-399f-49ea-b264-6da8db7b00e7', '营根镇', NULL, NULL, 2282, 'b3792f06-9c78-446e-b6ac-d95d5e9092e8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('36683d7c-3b7a-4e2b-a0e9-9c00ce6b1fab', '苏尼特右旗', NULL, NULL, 2344, '67723aea-a4ef-4eb7-afbf-55cc07806f98', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('36792d30-ddca-4384-bb12-3b9ef060dccd', '和田市', NULL, NULL, 849, '60e9ec7d-f371-4ea9-ace3-b13c1cd7081c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('36932812-34eb-4879-838e-a8f4ab84a4bf', '氹仔', NULL, NULL, 917, '691e132f-04a3-4856-a77a-92ed2dc5c246', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('36a3766d-d759-43e7-92cc-457ffe5b04f0', '花田乡', NULL, NULL, 2931, '465e9ea2-a2f2-4b42-95dd-b48d91f67105', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('36bd378b-ad67-4b5d-8b0d-a934ca59d3b3', '珍珠泉乡', NULL, NULL, 1517, 'd5ab951d-20ab-46ff-8838-de5efe06b6b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('36c016ae-709a-4623-a594-360302c31bf3', '铁门乡', NULL, NULL, 664, 'd7f44c2a-2728-4633-a8b6-7643136bc99d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('36e02579-641c-4837-b24a-5aefb119beac', '新星农场', NULL, NULL, 2988, '4b3478d4-3e85-4143-bc6f-ac4a338a9d47', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('36efbe9c-cf97-4860-8bf6-161c0a4d1106', '阜龙乡', NULL, NULL, 1350, '21bb958f-e5d4-4a71-a350-b5bf2c0e2de0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('36f31366-b7c8-48b1-99c1-4c0f99fe48da', '和龙市', NULL, NULL, 1055, '87e1c9be-7455-45a9-ace5-641efce55e22', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('36f84d14-890b-4f1b-9198-7a6a71acce5f', '板溪乡', NULL, NULL, 2929, '465e9ea2-a2f2-4b42-95dd-b48d91f67105', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('36f8fc74-8449-4294-85ad-53d15a778dab', '宝清县', NULL, NULL, 2254, '69696549-d65b-4e13-80ef-05ecaf0f61e3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('36fea905-3688-42a2-bb36-02bfe5f1f65a', '泰山区', NULL, NULL, 1243, '23df07d6-66e4-474e-b42b-258f50d7b0e4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('36ff889e-5226-4c2a-a983-357800d5feb9', '申扎县', NULL, NULL, 4418, 'fae5ed6b-9b68-4ef9-93fa-221dea13a975', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3706ddeb-409e-4668-a551-5603d17b9a55', '王场镇', NULL, NULL, 801, '0f559985-f6fe-4a8f-af80-3d0d64932dbc', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3741fe79-35f7-406d-bbf7-54472282f60d', '洱源县', NULL, NULL, 235, 'feece7c8-8eeb-494a-8e84-571b6ebcf0d9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('374889fc-1c4b-4260-a351-18e5220a2a54', '全境', NULL, NULL, 2782, 'c7a0d698-4738-4ad6-a378-5abea095d54f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('37535e07-f8c2-477f-a168-9a27e389bca1', '库尔勒市', NULL, NULL, 3173, '0ce20b86-8bea-4d7c-a1e4-09c7519d8b16', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3756af71-37fa-4733-84fc-0b81b6b3f747', '沂南县', NULL, NULL, 4341, '56327d0b-ec26-4f34-8ab6-0eba49931c67', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3758a484-ade2-4043-9523-b8944098ec42', '丹徒新区', NULL, NULL, 1763, '63f8e070-63c0-4fa1-821f-d1d5a695ce2a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('37635416-41d7-4a20-9fdb-9092e2b242d6', '禅城区', NULL, NULL, 327, 'dbd204cb-29de-4212-8c03-c2286f2ba4f5', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3768527c-db51-44aa-982e-685b253dbf49', '善广乡', NULL, NULL, 2677, 'e509a1a5-95da-4fb2-9a2b-f84afa05a36c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('376cb5fc-cd0b-477e-bba4-2a8078d034b5', '平武县', NULL, NULL, 393, 'efb72ec7-b29f-48d0-a16c-9a33d3938d49', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('37718df2-5c48-4a9b-bca5-3ec70fa0c412', '石门镇', NULL, NULL, 902, '41f376c0-764f-46b9-af35-e555518fc613', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('37810bec-da96-462d-a342-3a712be8cefc', '道真县', NULL, NULL, 3435, '69324865-24e8-4abe-a068-a1392c117c0d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('378d9a0a-fcab-472c-9aec-a3670d676a13', '长坝镇', NULL, NULL, 4454, '4888e1e9-ba45-4254-83e7-87796f338e2d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('37a3bbda-acbe-4911-bf66-f9e00c73f0de', '进贤县', NULL, NULL, 1283, 'cf24a0a2-c56e-45df-920c-8247c771d48e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('37aa33f4-73e0-475b-af42-d9ae4bef8be1', '芦山县', NULL, NULL, 3634, '6af0e8d8-91c9-43be-be32-5ec5c86b14f5', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('37f659c5-cb52-48dd-bbbd-d182310ba0c0', '阳明区', NULL, NULL, 1968, '1c2bd9d2-bc08-486e-a5f3-ba5de82c6365', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('37f9e3ad-614a-4aa6-a53e-0289422c1b34', '常宁市', NULL, NULL, 4261, '75dd761e-ce3f-45bb-a86b-d3a1e2c7629a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('37ff343f-bff8-4286-a3d8-9ab338acde1d', '光泽县', NULL, NULL, 3450, 'dd15d032-477c-4f54-9629-ea782606b468', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('380ff792-9d3c-4188-852c-134241df9829', '万朝乡', NULL, NULL, 821, '0f559985-f6fe-4a8f-af80-3d0d64932dbc', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3813f012-35b4-46f2-a104-900d514433b1', '浦口区', NULL, NULL, 1874, 'adb7aa6e-99a6-453f-a2db-21ecfbc44874', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('381c4178-5a8f-4a9b-9d5e-18f2f1f9da0f', '新和县', NULL, NULL, 4403, 'b7bc3a10-ad00-4b20-9fa4-cb08ad7492d3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('38306d90-6706-4d6b-8114-e315bb926a1f', '万顺镇', NULL, NULL, 2090, '4686b935-e3f0-4173-bdfe-ab6a5450d1a8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('38382760-b37d-4549-86a5-25a1ebdbc050', '普定县', NULL, NULL, 3623, 'a70a258d-7c8f-4726-a9ef-e2aa7c6247f9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('383dc770-1f58-4e53-8d9d-478a00cfaf45', '新政镇', NULL, NULL, 2995, '4b3478d4-3e85-4143-bc6f-ac4a338a9d47', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('383eb4af-8515-4d59-bec6-24927bd924e2', '长兴区', NULL, NULL, 4196, 'af4299a6-6902-4c79-bc49-f7b3f3c6f683', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('384391e6-a4d8-4270-b01c-3a4a315477cb', '峰峰矿区', NULL, NULL, 211, '237eff18-fe6c-4842-afb1-acb05027a5c1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3859cdbc-80bd-471e-9c7c-62a50b021850', '黎城县', NULL, NULL, 3856, '6fc78ef9-e2eb-46bc-bf8e-8b830ad96136', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('385e7fb7-a9db-4e1f-8044-667c2bdbd059', '支坪镇', NULL, NULL, 889, '41f376c0-764f-46b9-af35-e555518fc613', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('38621072-7919-4e83-b555-c41512eca491', '海晏县', NULL, NULL, 3783, '583dc13d-fce3-4f8a-b534-f717ec055405', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('38987ede-46c3-4590-8d89-70635ac151ff', '长征镇', NULL, NULL, 2286, 'b3792f06-9c78-446e-b6ac-d95d5e9092e8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('38b02be0-899f-463e-a52f-45f304156761', '澄江镇', NULL, NULL, 2325, '671d3a34-71bf-42c5-8dda-a813f5ecba22', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('38bd8956-a8d7-4dfe-8d06-d7fc77381a8a', '仲巴县', NULL, NULL, 3649, '5800fbac-51b0-4bc6-bc2b-34f78067fc28', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3900abc8-670e-4e2a-a707-2cbd94fab512', '广汉市', NULL, NULL, 3617, 'b2c794cc-d351-415b-b53c-cf0c454c1165', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3901439a-1e35-400a-b76f-538fe12c33d7', '四会市', NULL, NULL, 1469, '2ca74ae0-5e04-4119-84d8-187921fe4056', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('39025635-75d6-45d2-9af5-51f4cadbabba', '那曲县', NULL, NULL, 4413, 'fae5ed6b-9b68-4ef9-93fa-221dea13a975', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('39056f65-25ab-47d1-af5c-0ce85d02853e', '南关区', NULL, NULL, 317, '096d0f9e-9537-43f8-95f6-8dca9fa4cad4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('39077c29-e046-4d12-abb1-0a082d8b8a4e', '下堡镇', NULL, NULL, 1582, 'ac0e6e50-b6a1-457c-811c-06ac309cd5a3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3918031b-a3cb-4810-9e67-025746a98540', '襄城县', NULL, NULL, 3568, 'c2e61b39-2188-4b9c-a36f-ef7b600b0188', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('39327d16-523e-4e0d-9093-f3c8df88e98a', '公坡镇', NULL, NULL, 3811, '96fec37f-11d5-4d41-aba4-a36d0652744c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('39398a25-4511-4093-8c24-a997b77a8434', '零陵区', NULL, NULL, 1737, 'c7d6739c-4d7d-4d8f-bf6e-d6a6a7d38f20', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('39574e9f-d799-4365-8f66-519cc993fde2', '山荣农场', NULL, NULL, 2548, 'a1e3332c-7029-4de7-a221-40c041a9a620', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('39578fbc-70a8-47f2-8099-7623b1e7c13d', '雨湖区', NULL, NULL, 4309, '40852955-b0b0-4a50-b4b2-201be5c3808b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('395caee8-6569-47e3-b05e-68986846a7c6', '冷水江市', NULL, NULL, 3746, 'cff58e36-5b90-4beb-a3b7-e04021d244cb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('395cc589-c360-4c50-8d94-a1111d0928b8', '麦积区', NULL, NULL, 3111, 'b31f9073-6d76-4083-b00f-cc23550ef59a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('396603e9-70b7-413e-8a1c-934a3b703df3', '云溪区', NULL, NULL, 2267, '8369850a-f796-470f-902f-393cfb615571', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('39688bcb-2de9-4dd0-a86c-a99776d36a72', '庙溪乡', NULL, NULL, 2937, '465e9ea2-a2f2-4b42-95dd-b48d91f67105', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3985edef-9537-4723-ad4f-4941ba2f769c', '增城区', NULL, NULL, 1990, '926eaeaf-e8c5-47f2-89ff-6932b52c87d3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('398acdc0-d4d1-4d7b-bfd4-c810b6d46972', '老港镇', NULL, NULL, 2646, '4683d3ef-0edf-425a-98d5-2cb231a7d88a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('399f61a7-0d01-4962-ba99-1514a834856a', '图木舒克市', NULL, NULL, 4193, '137c8fae-dfaf-499e-93ff-48944e652926', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('39c13b95-5a43-4c8e-bd68-9b53f6ef9309', '福禄镇', NULL, NULL, 643, 'd7f44c2a-2728-4633-a8b6-7643136bc99d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('39cfadf7-0f47-4819-bfa4-a1632af99be9', '鹤庆县', NULL, NULL, 236, 'feece7c8-8eeb-494a-8e84-571b6ebcf0d9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('39d67e11-abd2-485d-8f96-9dfe9fd18aa1', '金口河区', NULL, NULL, 2523, '8f917434-e687-4552-b494-0eab3af61900', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3a047631-f859-4c2e-ab09-2057eaa3847b', '宝龙镇', NULL, NULL, 559, '8ae99c85-66b1-406b-8084-9f77cbf73b10', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3a17dbad-b4cd-42bb-9bf9-f9a95d8676b7', '票草乡', NULL, NULL, 190, '4f867632-2989-4def-9934-a9c5fe0d5ca5', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3a1df5c3-31bd-48a5-9d21-1213891a63db', '大盛镇', NULL, NULL, 706, '97942649-3cc7-4e4a-81b4-9a8c82f82ea7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3a38378c-a562-4ed0-abb0-84ad116fa71f', '卫滨区', NULL, NULL, 2175, '1aabde9d-2b04-4892-a20d-5b4e3efaeedf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3a43f6df-50fb-4efd-8572-d781b595761b', '金山桥开发区', NULL, NULL, 4433, 'e20441c5-c8b4-493a-9738-2327e656fbcb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3a44837d-cddd-48ab-8d25-8bf7a92a417c', '椰林镇', NULL, NULL, 544, 'b75db043-9782-4bae-aaee-bea49fc286e6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3a48f704-7699-46f0-b948-4239b80559aa', '玉州区', NULL, NULL, 2334, 'ee710091-bfa9-4285-89e3-80ad65ebd912', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3a56e256-a204-477f-8ca7-762fbcba8785', '昌化镇', NULL, NULL, 784, 'af6f4f65-b2db-4670-88ca-21de1de477fc', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3a5b531f-f9ef-4a83-a0e2-8a9209130d3f', '西永镇', NULL, NULL, 3905, '7fefd2bf-99e0-43f5-bc37-9ab15ee8e8f3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3a619a79-b522-4b74-a8a8-cd3c8a9b69c9', '豆河镇', NULL, NULL, 3461, 'ea11feaf-194c-4cec-be59-d17bac402db4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3a66119d-ec33-4bc2-a8a8-54aafed042ac', '长征农场', NULL, NULL, 2281, 'b3792f06-9c78-446e-b6ac-d95d5e9092e8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3a717b16-56da-4814-b095-7fd3a99823d2', '高碑店市', NULL, NULL, 2478, '81e22d56-a1c7-4263-be18-81a4af165ae3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3a72722d-fee3-4540-b491-69f802c8d6d6', '萨尔图区', NULL, NULL, 2360, 'c5e2b320-fd7d-448b-9a02-4fb93e1d3302', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3a76a699-d8d3-480b-a122-801dc24566ef', '齐河县', NULL, NULL, 4168, '9c8b6d83-dd06-4238-b7f4-c0ad532e5b6e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3a95c390-5598-4328-9d0b-a6abe4d87db3', '二道区', NULL, NULL, 319, '096d0f9e-9537-43f8-95f6-8dca9fa4cad4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3a9d0d4b-d319-47d2-b759-5635edf0f516', '湖山乡', NULL, NULL, 3819, '96fec37f-11d5-4d41-aba4-a36d0652744c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3aa29835-4a75-4b35-8138-a336f1f22dc0', '城北区', NULL, NULL, 3869, 'baa2f053-c419-40c1-93fe-68e081b7f229', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3aa8b1b4-6ede-4631-a2ac-2aee4f78d9fd', '孟州市', NULL, NULL, 4010, 'e95972c4-fd28-45ac-b9da-9aee0057d3d0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3aacb791-a376-487d-a7bd-120c966b5ba5', '泾川县', NULL, NULL, 28, '4edd328e-68af-4f0e-bca8-63686e5cad24', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3ae286c9-26f6-4cc4-bd9a-cff4bb332914', '板桥乡', NULL, NULL, 2950, '465e9ea2-a2f2-4b42-95dd-b48d91f67105', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3af54296-8d0b-49d1-87d7-5672af177e8b', '源汇区', NULL, NULL, 4134, '55b0b2d6-58e4-40a1-b278-e63aa372ba29', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3b040e63-08b6-43ad-90c4-6c0c1b9487e8', '北流市', NULL, NULL, 2335, 'ee710091-bfa9-4285-89e3-80ad65ebd912', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3b0c3d9b-0a59-4485-bbcb-0863b5273408', '拜泉县', NULL, NULL, 2734, 'f4e36f9a-e006-44a6-8d77-47971d41810b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3b1f5b6a-d9af-4bd9-be89-e868f4d06abc', '江丰乡', NULL, NULL, 2932, '465e9ea2-a2f2-4b42-95dd-b48d91f67105', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3b375fb4-6c56-43c5-8e68-6766fb8ee76c', '珠晖区', NULL, NULL, 4259, '75dd761e-ce3f-45bb-a86b-d3a1e2c7629a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3b409d67-ccef-4491-9d29-135d5a0023eb', '大广县', NULL, NULL, 1239, '86f7f02d-658e-44ec-9d36-b14cc3c65aaf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3b4709e9-f5e6-482c-ac46-5eb071462973', '外环内', NULL, NULL, 4370, '74fd7f9a-ddb6-4065-a99c-054987fffdb8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3b5992bb-c86e-4f00-8f95-048ed346db44', '辽中县', NULL, NULL, 1841, '271a8d5d-a9a3-4876-a9a2-ca9bcee4b83f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3b7d7aed-9c3c-4367-a72c-1a965b141ba7', '涂市乡', NULL, NULL, 2945, '465e9ea2-a2f2-4b42-95dd-b48d91f67105', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3b965916-8b49-4cdd-ace6-78f0af6eeb4c', '土坎镇', NULL, NULL, 4451, '4888e1e9-ba45-4254-83e7-87796f338e2d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3b9713d3-eb3a-4b75-98c8-f46053d00363', '地宝乡', NULL, NULL, 4235, '0ee28cef-8dfc-4a9f-b7c1-330bc11c1bb3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3b9f4551-02d1-4838-ab89-a842fcd85566', '原州区', NULL, NULL, 292, '76330308-a439-44e8-9f63-30f07cae40fe', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3ba83ee2-bbfa-406e-87f9-660cdaafe2d3', '成县', NULL, NULL, 1367, '7c9ca39d-ce8f-469d-899a-09a0a29c1541', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3baff4dc-520b-422d-8fa1-f2bae0c0e469', '清溪镇', NULL, NULL, 3327, '3bc6861d-0eeb-497e-9257-42f9cd6fd26f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3bc4b956-70b8-42d9-b825-0e2de99ca9a9', '蒋湖农场', NULL, NULL, 2161, '671275c4-6107-4968-bd8e-96d53e9995b2', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3bd1a747-d5f8-4cca-8f4b-5b64381ac923', '大东区', NULL, NULL, 1845, '271a8d5d-a9a3-4876-a9a2-ca9bcee4b83f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3bdb7851-2def-44b6-8e05-98d31072b34b', '抱由镇', NULL, NULL, 2550, 'a1e3332c-7029-4de7-a221-40c041a9a620', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3bdc5d93-8527-4709-95a2-69b609a9d153', '土地坡乡', NULL, NULL, 1130, '72d4f69f-2e4c-4bde-9df8-2aadc9168686', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3be820e0-4e6a-45ac-9d1f-f4426d4cf595', '东兴农场', NULL, NULL, 4495, 'f491d9c3-9527-46a4-8954-6795ff079478', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3be8ec14-3882-4373-b7f0-934b19d59007', '庙宇镇', NULL, NULL, 370, '76dd00a1-30a1-4226-ae06-cad845c0528c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3bf9097e-ba85-4589-8897-f30afe8f0a1e', '中桥乡', NULL, NULL, 939, '88260608-a8b9-4b52-a474-1a551465c675', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3c0437ad-a6eb-4e0f-835d-345ec7ac3458', '林州市', NULL, NULL, 2572, 'd94ce52b-fe8c-47d7-9b1a-d37da377cbbe', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3c15d6fe-47b7-45d7-a71b-c7b5ae1143fb', '石园街道', NULL, NULL, 3738, 'd1c1539c-b904-4bcc-a034-96213f63d0ff', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3c1a2cfe-7b7e-4eb0-9aa1-e931bce3d7f6', '霍州市', NULL, NULL, 3694, '1aeeea9e-d028-4a96-94ce-ba84cdd3e69f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3c1c5b02-4da1-40e9-b03c-9e70a70e1caa', '中和镇', NULL, NULL, 965, 'cc124ed6-091a-42ce-a87a-bb4d0d7357b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3c1c6356-3f6e-42c0-bb6c-d466765c9bd5', '丛林镇', NULL, NULL, 3673, '6581d8db-553e-4417-8c37-91ed47904920', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3c292b2e-31cd-4cea-a45d-1d32f8eef58b', '同德县', NULL, NULL, 4072, 'ed217127-f5a1-4f77-b32d-75d0114bce26', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3c373aa7-6e5b-469b-a248-cc455019d1b0', '伊春区', NULL, NULL, 456, '7ca3412f-b06b-467e-b547-691ab8327b15', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3c3bc231-ee9e-46fe-8a09-f9a8919eff2b', '汝溪镇', NULL, NULL, 2665, 'e509a1a5-95da-4fb2-9a2b-f84afa05a36c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3c46b5a6-89f0-43a7-8923-c1c99b1a4f71', '云安县', NULL, NULL, 263, '34138fe1-593f-4c44-87ac-1beaee74bafb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3c5c6513-a3d0-434a-99ec-e1e08957f439', '柳南区', NULL, NULL, 2747, '0f2ba543-1d40-4b41-b700-6b53a9622b5b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3c5d89f7-28aa-4e89-84ca-74770f3ba771', '火炬开发区', NULL, NULL, 2186, 'f2727650-b0d9-4541-acdb-b4eabf894893', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3c6d1e6d-c268-446e-a5ec-7808b3042b96', '阿克塞县', NULL, NULL, 2426, '42852584-118b-41cf-ba7e-db28102a593a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3d288f08-9407-47ec-a40e-2cb820ac120f', '官渡镇', NULL, NULL, 365, '76dd00a1-30a1-4226-ae06-cad845c0528c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3d41ad51-bba3-4aa5-ba16-18e2b34c0a01', '江陵县', NULL, NULL, 874, '7fe0855f-3ef6-419b-a145-5994fe28cc8f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3d4b3de3-a35c-4db2-8374-0b7ffcb35e5f', '雷鸣镇', NULL, NULL, 1565, '5f7e2e46-8a4e-4463-907c-5762bcd006a8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3d718a86-1a66-4fbc-8d1e-6d14fdf982a3', '高新区', NULL, NULL, 1289, 'cf24a0a2-c56e-45df-920c-8247c771d48e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3d9d24af-7052-4dd3-8dc6-d508091e6f24', '华容县', NULL, NULL, 2272, '8369850a-f796-470f-902f-393cfb615571', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3dac82dc-5ae7-45c6-85d5-0bf7ada5f3ec', '蒲城县', NULL, NULL, 3164, '9e5ae65c-206f-4d7b-87f2-c252d5f40b52', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3dba3e28-9b92-443e-ae30-50d0b0c7ab13', '新抚区', NULL, NULL, 1378, '6b5fed36-b200-40ca-af0b-11999b4399ef', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3dc4fc7a-1ee7-4ac6-8d3c-35e546f2e949', '恒合乡', NULL, NULL, 4241, '0ee28cef-8dfc-4a9f-b7c1-330bc11c1bb3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3dc883b4-0996-4b60-8a6a-2ba68b31242b', '三道镇', NULL, NULL, 2996, '4b3478d4-3e85-4143-bc6f-ac4a338a9d47', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3ddf583e-dd85-4b62-a82f-ca7034a5b5bb', '沿滩区', NULL, NULL, 1690, '39b19556-caa3-41de-a70f-2d81f23db54d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3de577b2-289c-4cf1-ad53-da6ace698ddd', '浦江县', NULL, NULL, 227, '1721f4b0-56cf-4408-a217-62416951c176', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3de67398-d0e8-46a7-b210-c15dcfbc2369', '漳平市', NULL, NULL, 3347, '381b5351-4075-4ec0-88cd-f3e1da71c110', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3dfffb00-56a3-4902-a58b-7b48c4220713', '石棉县', NULL, NULL, 3632, '6af0e8d8-91c9-43be-be32-5ec5c86b14f5', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3e03be7c-5170-4583-9f6f-6ed20729c6b9', '磨子乡', NULL, NULL, 2676, 'e509a1a5-95da-4fb2-9a2b-f84afa05a36c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3e14ab97-ef62-49c7-b9fe-e0536ac65d2f', '汶上县', NULL, NULL, 2822, '5c8748b9-cee3-4d8e-956c-0d0e24db8850', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3e266792-806c-4d37-a059-723de9e3064f', '临湘市', NULL, NULL, 2268, '8369850a-f796-470f-902f-393cfb615571', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3e27f35c-e168-438b-aeda-feb86a7681f2', '新安县', NULL, NULL, 1178, 'b5a118ad-786c-4d86-b4e8-5d25a3776a78', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3e46893c-3f3d-44de-80bf-78d509919df5', '滴道区', NULL, NULL, 2411, 'f583e1ae-7239-4815-b3c7-c5538eb73da9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3e5c4a5d-3086-40fe-96c7-48225879c987', '侣俸镇', NULL, NULL, 3846, 'c33c3107-81df-4ced-8b92-d694df412da3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3e5fecb0-1993-47ef-ad7e-7c99fbf57b82', '宁蒗县', NULL, NULL, 3304, '533981ab-21f3-46b9-91a4-320129bd0b49', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3e70462e-698e-4d4f-a841-7085a86ba13b', '顺德区', NULL, NULL, 326, 'dbd204cb-29de-4212-8c03-c2286f2ba4f5', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3e70c41e-0d73-4b70-bac1-fb8c04041a50', '汉阴县', NULL, NULL, 2982, '55fbb0a6-5436-4d04-9f29-716233f81fd7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3e824ed8-8c3a-4cdc-bbf6-c31950671501', '师宗县', NULL, NULL, 1333, '9568bdcc-65c2-4b1c-a512-b2ff897db321', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3e8cc71b-4af3-4b50-af9f-dc34819555e2', '高淳区', NULL, NULL, 1872, 'adb7aa6e-99a6-453f-a2db-21ecfbc44874', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3eaf380a-2709-4e0f-9c19-9f148251169b', '博望区', NULL, NULL, 3452, 'a77a0530-087f-4dab-84ab-e8a9690de27f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3eb5a850-739d-4441-adf5-9b221ff4d000', '连云区', NULL, NULL, 1633, 'bea9983e-fee5-44d8-9884-18c75d7d052d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3ebfa927-d7e3-49a5-baa7-01293bac728a', '高观镇', NULL, NULL, 2382, '0275a9ca-e89b-4217-b3b0-ada824d9e095', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3ec679bf-02e2-451a-976e-fbb1dd62e7c9', '广宁县', NULL, NULL, 1471, '2ca74ae0-5e04-4119-84d8-187921fe4056', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3ec92319-88a2-4a00-adca-627c29f81968', '右江区', NULL, NULL, 1218, 'f56fa64d-ca06-49d2-a9cb-94742a33af21', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3edb646e-3627-4877-bda7-686d5de5bffb', '洛隆县', NULL, NULL, 2697, 'b7342349-941d-427d-9ab6-e83a36078088', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3eecd3ea-7fdd-4ec1-b04c-ecb3b51e6bcc', '茂南区', NULL, NULL, 693, '88bc9baa-b7fd-4bf4-a896-4e049185e0c2', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3f0879a4-2849-44db-97d8-966166424cc7', '久治县', NULL, NULL, 2651, '292d9fec-f1c5-4100-b5be-fe56a5036e70', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3f0933bd-1015-4c21-a91b-ac3d993da73e', '雄关区', NULL, NULL, 246, 'eff5ed18-ee14-4201-876c-3c40dd858438', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3f0c2a59-c59c-4c7f-984d-478d8a316bab', '张堰镇', NULL, NULL, 2703, '0e5598a8-f405-4745-8cd5-a7a4c99f67f9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3f1ceb2c-9514-459d-8186-74383205c0e9', '龙塘乡', NULL, NULL, 1892, '2c8bc8c3-9317-4f36-a0ad-05a8d6b27053', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3f30565f-4302-4ec5-ba30-8d76809401d1', '宁安市', NULL, NULL, 1972, '1c2bd9d2-bc08-486e-a5f3-ba5de82c6365', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3f305868-136a-43e1-8d6b-62a2cd40034e', '花山区', NULL, NULL, 3453, 'a77a0530-087f-4dab-84ab-e8a9690de27f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3f3a0324-ba4c-4a8f-803f-b18145ce20c3', '栖霞市', NULL, NULL, 596, 'f3717726-7743-4838-852b-3a09f9528a69', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3f41932f-41f7-4053-940a-0d7d03aa535d', '李沧区', NULL, NULL, 3713, '1e53830d-8cdb-4111-8da6-987131b873ed', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3f429739-ece2-49cc-8a17-ccfbb58a65bb', '武夷山市', NULL, NULL, 3444, 'dd15d032-477c-4f54-9629-ea782606b468', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3f4414e6-5670-49a4-a1b9-6b64c7fc9312', '岫岩县', NULL, NULL, 2013, '48832e11-ddfb-478a-9787-e46c47346d7e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3f449b5a-9cae-4ae7-94b4-62b7bf6c175d', '永定区', NULL, NULL, 334, '1af0c5e6-6728-445e-9278-f1eaf5c6303a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3f4f2fa0-7d13-4d57-931d-e1e4ece3fafb', '经济技术开发区', NULL, NULL, 123, 'bcaf1f36-5459-4e74-81d1-5026680b1a9c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3f5342ec-35cf-4093-86eb-370887ac30b1', '桓仁县', NULL, NULL, 1546, '7becad81-2a66-497c-9c70-276a85718c91', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3f546bfa-6be0-4d91-9223-3590ce029730', '皇姑区', NULL, NULL, 1843, '271a8d5d-a9a3-4876-a9a2-ca9bcee4b83f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3f54982c-692d-42f1-a5af-973a9fe265d8', '鱼泉乡', NULL, NULL, 938, '88260608-a8b9-4b52-a474-1a551465c675', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3f5bae25-d396-401b-a1e4-a9127d1d80d9', '黄大仙区', NULL, NULL, 479, 'dfb8b556-10a2-43ab-9fdb-66cde92320ee', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3f6947b0-b3e1-4a88-94bb-7e5c7ae90237', '郭家镇', NULL, NULL, 3249, 'a39ced08-b6e9-4de0-a2db-7a230a673d1e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3f7dc612-98fd-41cf-b2ac-fdf97edff858', '美溪区', NULL, NULL, 462, '7ca3412f-b06b-467e-b547-691ab8327b15', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3f8ae766-cb81-4298-bb5a-a90e8023d5ee', '马灌镇', NULL, NULL, 2663, 'e509a1a5-95da-4fb2-9a2b-f84afa05a36c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3fb67461-dbb6-40e8-a251-d4ee9ed131c7', '清流县', NULL, NULL, 278, 'cae0a47d-0d79-4fa6-aac9-e8b3b535ee3c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3fb9a283-a5b4-47b7-bb26-90e9b8aa1a4d', '西充县', NULL, NULL, 1252, '71643995-698f-4bdf-afe9-09fce8a065c0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3fc1073d-afa1-4247-8d39-0c24545c6898', '秦州区', NULL, NULL, 3112, 'b31f9073-6d76-4083-b00f-cc23550ef59a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3fcc1bd2-8a22-4fc0-8ff4-9b526507af7a', '新北区', NULL, NULL, 4005, '4a5fccf3-5d70-4b0b-85ef-c2a8e5fdfadc', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('3fecf558-63a2-4d30-97f1-7bc17a91083d', '多文镇', NULL, NULL, 721, '0be5e1cb-cdb0-48ca-9f82-47f7f4c6dd2e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('400267b9-a2f7-4117-9c05-b2079e402dd9', '平鲁区', NULL, NULL, 2061, '49bad2d2-0c83-48ed-9985-7a709362f3a8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('40065eab-eb61-4b9d-a138-90dacc81d14a', '润溪乡', NULL, NULL, 1899, '2c8bc8c3-9317-4f36-a0ad-05a8d6b27053', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('401fb3be-ff44-42f5-9113-183ce5e35e1d', '东陵区', NULL, NULL, 1847, '271a8d5d-a9a3-4876-a9a2-ca9bcee4b83f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4023ce95-d4fb-4e54-9ceb-3248ea8ad9b6', '安仁县', NULL, NULL, 1308, '50d6a2ea-ba0d-4ff5-8b4c-f9d84e79e381', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4025bddd-269e-46d3-bffb-3b9070b8afe4', '镇江镇', NULL, NULL, 1932, '442f465d-6566-45e4-9338-50f4395aa6f7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('402999c7-d59b-4f03-a341-f8901a0814fc', '沙田区', NULL, NULL, 485, 'dfb8b556-10a2-43ab-9fdb-66cde92320ee', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4051221f-4dd4-4e2e-aed6-6e3666c517dc', '青川县', NULL, NULL, 510, '74a706f1-82bb-4132-8ee4-9abf7bd809cb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4055d910-3cc1-48f7-aa8b-b471dd461708', '冯坪乡', NULL, NULL, 1097, '79482cd9-7d51-4c89-94c2-4bcd773b8323', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4063333c-8a9d-4122-828e-731d96d7655f', '木凉乡', NULL, NULL, 931, '88260608-a8b9-4b52-a474-1a551465c675', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4075bb17-0de0-494d-818b-3bd44b453425', '昌乐县', NULL, NULL, 448, '3e54862f-40e4-4b44-b318-6a64b04a9558', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('407e3095-317a-467b-b35c-5c294e3f3c0d', '东阁镇', NULL, NULL, 3801, '96fec37f-11d5-4d41-aba4-a36d0652744c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('409b46a5-fc58-4b7b-920a-f8c8a1416a63', '平江县', NULL, NULL, 2273, '8369850a-f796-470f-902f-393cfb615571', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('40aec1ac-8e77-43ce-8906-1db16d00cbea', '通江县', NULL, NULL, 453, '312a1e8d-70a3-4529-bfe8-04a7f21cc881', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('40c4596f-4f9b-4b49-9307-a9484ac9242d', '吴中区', NULL, NULL, 619, '278acb58-4d2d-40cb-a572-1fc7fb979c77', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('40d06f8c-0736-4ee8-ae13-6c687ded2c07', '八达岭镇', NULL, NULL, 1505, 'd5ab951d-20ab-46ff-8838-de5efe06b6b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('40d5854b-6837-4b60-bdc3-1916d01391d9', '钟灵乡', NULL, NULL, 994, 'cc124ed6-091a-42ce-a87a-bb4d0d7357b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('40d74e73-ef2a-4d03-95fd-b71a2c6a5532', '龙泉市', NULL, NULL, 2370, '982c089d-7fb7-4cdc-a3c2-865e4637006f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('40d8ca30-948d-430a-b10a-6ce8218a3ff6', '溪湖区', NULL, NULL, 1549, '7becad81-2a66-497c-9c70-276a85718c91', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('40da04a1-a7f5-4311-bc5e-6de0c5c4fd70', '沙溪镇', NULL, NULL, 2199, 'f2727650-b0d9-4541-acdb-b4eabf894893', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4101f1cb-d0dd-4221-b8e0-18d0e155e814', '临溪镇', NULL, NULL, 797, '0f559985-f6fe-4a8f-af80-3d0d64932dbc', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4106e891-164c-4c87-91ef-7aa10aa09ac1', '建胜镇', NULL, NULL, 2784, '40c54e46-4d4f-4d44-95a2-d38a55d0af7b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('41082be5-a24f-4cc7-8ae5-7051248e7c74', '峡江县', NULL, NULL, 4322, '5f548430-51dc-45ad-82e5-bcd0394d8f6c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('410f04a2-6dd6-44fc-977a-aadfcdac0d86', '新宁县', NULL, NULL, 3758, '30ce87bd-09cc-4250-9b5e-1f5916ce4d70', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('41150cd3-0867-49ac-bc9a-29d799d0d5a5', '化德县', NULL, NULL, 3965, 'a061ae4e-1b4e-4b42-8aa9-cc6bbae9619a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('411d26dd-6964-4339-b0b5-4e2cb6a16f53', '偃师市', NULL, NULL, 1171, 'b5a118ad-786c-4d86-b4e8-5d25a3776a78', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('41339ced-216d-4de8-8ba6-3775268be691', '高新技术开发区', NULL, NULL, 324, '096d0f9e-9537-43f8-95f6-8dca9fa4cad4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4135e6ee-8eac-4715-97fe-646d5cc6c396', '翠峦区', NULL, NULL, 460, '7ca3412f-b06b-467e-b547-691ab8327b15', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('41409deb-c796-4038-bbd6-2f0a0610b864', '苏家屯区', NULL, NULL, 1838, '271a8d5d-a9a3-4876-a9a2-ca9bcee4b83f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4145bdf3-8a3e-443b-969b-0f8655e2da22', '双河镇', NULL, NULL, 2504, 'd998f8bc-c659-47ce-8e5e-a6b29e03ecb3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('415f4982-92ed-4e5f-8a11-c68a94e6bc45', '澄溪镇', NULL, NULL, 1478, '89e8be16-b810-4c7e-89f0-aa9f24483b98', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4180d0ed-38f6-4d08-808b-015a40b1e2da', '诸城市', NULL, NULL, 444, '3e54862f-40e4-4b44-b318-6a64b04a9558', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4190ddcd-66a4-44db-af8e-e85da094ab1b', '六环内(马驹桥镇)', NULL, NULL, 2135, '88d84710-80d6-4837-b889-286c74d7940d',
        1, 'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('419ab49a-1fc0-43c3-9873-e1daa57a39d2', '南木林县', NULL, NULL, 3639, '5800fbac-51b0-4bc6-bc2b-34f78067fc28', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('419d6a11-3c6f-4e08-b424-94bee92d173b', '三台县', NULL, NULL, 395, 'efb72ec7-b29f-48d0-a16c-9a33d3938d49', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('41a0baa5-d9d2-47f0-be28-6fa246e3e391', '紫金县', NULL, NULL, 1723, 'a9736c65-aeba-4a39-861f-5edf105d8673', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('41ad2a01-3b15-4582-bd31-f555f838e0a4', '雅星镇', NULL, NULL, 3205, '2e21ea75-c640-4928-8cb4-e5ba4f6e2ffe', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('41e7ae3a-9d84-48de-8320-c333fed8352e', '两坪乡', NULL, NULL, 381, '76dd00a1-30a1-4226-ae06-cad845c0528c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('41f1b6c8-03ae-4935-b206-a7732b9e9c48', '山海关区', NULL, NULL, 2715, 'f4bc760a-86e0-4fa1-a5e9-cdc21cc7a127', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('421084fe-49e4-4fb5-88c1-4848c6010cb5', '杠家乡', NULL, NULL, 1494, '89e8be16-b810-4c7e-89f0-aa9f24483b98', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4256e057-531b-48b9-b098-a98fa1153eb2', '新蔡县', NULL, NULL, 743, 'a096e337-c439-4751-a014-b49dd13bee26', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('426a3372-df27-40b4-a9f8-71fd60b2da02', '茶山镇', NULL, NULL, 3329, '3bc6861d-0eeb-497e-9257-42f9cd6fd26f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4276e8f7-fd87-41ae-9c06-d0d10e0df0fd', '嘉鱼县', NULL, NULL, 953, '7a5b4813-b095-4a1a-a008-1297fd9aa978', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('427870cd-b0c5-4b29-861a-e31f39370e83', '和县', NULL, NULL, 3457, 'a77a0530-087f-4dab-84ab-e8a9690de27f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('427d87cf-8005-4c17-af43-bee8bbe75a7e', '惠城区', NULL, NULL, 75, 'f951b5e7-debd-4c51-9c02-03ebe84ebbfc', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4292b09c-dda7-44f5-9471-443da34b5ae0', '新巴尔虎左旗', NULL, NULL, 1069, 'c31a65eb-4d77-4b38-8142-9c9e2f54ed46', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('429efe60-8da8-4d05-8b26-72f65639e280', '沁阳市', NULL, NULL, 4009, 'e95972c4-fd28-45ac-b9da-9aee0057d3d0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('42b5a580-fc12-4d48-8c13-8fc1870b2306', '善感乡', NULL, NULL, 1901, '2c8bc8c3-9317-4f36-a0ad-05a8d6b27053', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('42b90655-c229-4e85-9c77-af3893b76b3f', '红原县', NULL, NULL, 1195, 'd56c2ee6-b81c-4df8-ba2f-3df7680243c4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('42ba5125-cc20-4a2d-85da-2706d8ed16c8', '郭扶镇', NULL, NULL, 3662, '6581d8db-553e-4417-8c37-91ed47904920', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('42c015e4-a2e7-4523-8362-b086bf5de074', '石龙区', NULL, NULL, 3392, 'f5ebab20-0f47-47e8-b896-6f3d9651c97a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('42d88db1-7ec1-49a8-b131-d2217a0aa572', '江海区', NULL, NULL, 3309, '2a61b8e3-4156-42df-836b-fc855d156f23', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('42e47234-d99e-4cb2-8e4c-ce1412d0c9a4', '锦山镇', NULL, NULL, 3809, '96fec37f-11d5-4d41-aba4-a36d0652744c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('42ec3edc-6db8-49b2-beb0-91666712210a', '大武口区', NULL, NULL, 1438, 'ef951e0d-15d6-4343-901d-8412af9b0b93', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('42f4fb55-e455-4762-9462-30bbc1f00ad0', '新村镇', NULL, NULL, 551, 'b75db043-9782-4bae-aaee-bea49fc286e6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('43052698-74a3-475a-912b-f47ada1fc00e', '道县', NULL, NULL, 1730, 'c7d6739c-4d7d-4d8f-bf6e-d6a6a7d38f20', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('430a6e71-fe8c-47cb-9ca3-e9265dcd9dd5', '封开县', NULL, NULL, 1474, '2ca74ae0-5e04-4119-84d8-187921fe4056', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4319b29c-3fb1-4e9f-a099-d1c9b41d438f', '武陵区', NULL, NULL, 4304, 'dd99fcda-6192-4ada-bef5-b04735e7dae8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('431f294b-5a51-4795-92bb-2a455451856e', '隘口镇', NULL, NULL, 966, 'cc124ed6-091a-42ce-a87a-bb4d0d7357b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4327c0db-f9af-4053-b31a-0fff465e51b8', '吴桥县', NULL, NULL, 2893, 'a3c44525-9ccb-429d-a2b7-f5f5d52b8a6d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('43328c8e-7fc8-425f-bee8-56f8ff789846', '巴东县', NULL, NULL, 2356, 'ecba10ba-2c25-4ead-a781-ad16a832226f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('433293a0-737b-451f-a5d5-b44e3e50eaf8', '五环到六环之间', NULL, NULL, 3004, '1e3ed660-6de7-4b3a-a1d2-3ea7e0778e94', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4336293a-fc11-4659-b8fd-a985b94ef4a8', '鼎城区', NULL, NULL, 4303, 'dd99fcda-6192-4ada-bef5-b04735e7dae8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('43640f56-f7f4-44a9-ae5e-45837025649f', '东凤镇', NULL, NULL, 2191, 'f2727650-b0d9-4541-acdb-b4eabf894893', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('436e7e7b-459b-486e-99f7-8e3d2f3bcb16', '小金县', NULL, NULL, 1189, 'd56c2ee6-b81c-4df8-ba2f-3df7680243c4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('43701c13-d36f-4350-a495-1a39f2d9d345', '德惠市', NULL, NULL, 312, '096d0f9e-9537-43f8-95f6-8dca9fa4cad4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('437f1c13-ab6e-45ce-801f-22a79e919762', '霞云岭乡', NULL, NULL, 65, '0863a0a5-7ac5-4a13-80f5-d31e3a1aa459', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('43a1a367-ee86-4c39-8fec-03249d02c1ce', '临川区', NULL, NULL, 3958, '1e0a806c-ad0b-4e9f-a488-8bf9fc903f4d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('43ab8ff0-9b2a-43cb-8773-57a5f017cc71', '镇平县', NULL, NULL, 737, 'a769a530-0bcf-4e52-a9e5-3a8f5af945d2', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('43e53b89-3e68-47fd-b103-d9c7bc3cf349', '于都县', NULL, NULL, 1615, 'dd4a8577-afbe-449b-ae9b-be374a4c7434', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('43ea1a1a-fbdb-4c50-9a15-3e907ae3b5a9', '金阊区', NULL, NULL, 612, '278acb58-4d2d-40cb-a572-1fc7fb979c77', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('43eb2a56-240c-4efd-8aaf-1b95d5f5a2dd', '安宁市', NULL, NULL, 2861, 'd7efec13-7e84-436d-8390-41868af0e359', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('44039ac4-f059-4bb1-8823-c3cc9366ab41', '紫照乡', NULL, NULL, 665, 'd7f44c2a-2728-4633-a8b6-7643136bc99d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('44104268-617d-44cf-96bf-ef2b63d503f0', '西塞山区', NULL, NULL, 3913, 'b3b5e655-b2df-467e-ad5f-2ab21c2a0aba', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('441484d4-bc56-455d-800a-72a1f1995704', '红光农场', NULL, NULL, 4093, '5d3b3a34-50c8-4a01-83b7-e3e068d5c9a7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4416a5b4-f94c-47e2-b508-b4fb173ed853', '崇川区', NULL, NULL, 1745, '7de09763-759b-437b-a3aa-4cb32bd3c6b9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('44186ed0-36a0-4625-83d1-0671879a21ce', '临泉县', NULL, NULL, 1627, '6de68814-d6ea-430e-88b6-bf98620aa604', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4423ddc0-14dd-4acd-a66c-1456c657cc9a', '都安县', NULL, NULL, 1164, '509d3498-d5ba-4378-8bee-0baf015c2a11', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('44554c17-d405-4af7-8635-8af670c070c1', '哈巴河县', NULL, NULL, 3528, '2ca5ebc8-b3f5-49d8-b421-85ae2dc0de35', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('445977ad-83e3-4253-b2dd-31275c1df0fd', '枣阳市', NULL, NULL, 1341, '52d3ef0d-d999-4ae8-971b-534a2b25de02', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('445f7036-0d45-4fd3-81f0-863fa4d731b5', '金安农场', NULL, NULL, 4095, '5d3b3a34-50c8-4a01-83b7-e3e068d5c9a7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('446d41d4-c31a-4019-a645-4ce025c5390c', '虎丘区', NULL, NULL, 613, '278acb58-4d2d-40cb-a572-1fc7fb979c77', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('44930a2b-823b-4875-a3e6-d2cc1cf12080', '木叶乡', NULL, NULL, 2938, '465e9ea2-a2f2-4b42-95dd-b48d91f67105', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('44a2d043-5af1-4fdb-a6d4-e43b35b25c1a', '福鼎市', NULL, NULL, 2435, '8300a2db-b893-4d51-a009-89478871edf1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('44b0f897-5422-48a4-8e3d-3f7bbe2bef86', '苍南县', NULL, NULL, 259, '86b77e39-331e-4927-9517-49be7b738b9a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('44b22251-9e0b-45ae-977b-5bd791f1bff7', '开发区', NULL, NULL, 588, 'f3717726-7743-4838-852b-3a09f9528a69', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('44d2ad2d-9f7f-41ec-954e-48336d2b1ccd', '冠县', NULL, NULL, 359, '56b97c58-86a5-4869-9130-c5dc51ea9a26', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('44f43420-b63b-4645-8788-796e0e90fc1d', '龙安区', NULL, NULL, 2567, 'd94ce52b-fe8c-47d7-9b1a-d37da377cbbe', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('451994f0-17a9-4ad8-8cf8-c78b8eb56561', '东侨开发区', NULL, NULL, 2433, '8300a2db-b893-4d51-a009-89478871edf1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('453391f3-5024-40bd-936d-7a287ebcd580', '上高县', NULL, NULL, 4070, 'fa27d3fb-a80f-4b4c-8d0c-bf7d544bb974', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('453f282d-df39-4135-959c-15a83d4b3dd9', '槐荫区', NULL, NULL, 4354, 'c6ac73d4-9854-403a-9b61-12c22eeb4903', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4542eb65-3037-40e2-978a-6f6a995e4e7f', '隆化县', NULL, NULL, 4030, '8db8f645-a1a6-4c39-9c27-2f703951f66d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('45563452-253f-4040-ba32-dcd82ace8c72', '玛沁县', NULL, NULL, 2647, '292d9fec-f1c5-4100-b5be-fe56a5036e70', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('45587384-2ef4-4adf-9eee-d7b4e4e9919f', '台湾市区', NULL, NULL, 1764, 'f83a5a46-d0a9-4094-96cd-369ddab61388', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('45788edb-1623-4154-9a56-27e42059a44a', '新兴镇', NULL, NULL, 4329, 'e98653ba-264e-4417-b74e-e0798b25e646', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('458698a9-c2a5-4038-9120-a86e561d1482', '稷山县', NULL, NULL, 4109, 'fc30b5e5-3005-4778-94f7-706b31514bff', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('459ea35f-daa9-4191-b419-f4eb968fcc71', '谢通门县', NULL, NULL, 3644, '5800fbac-51b0-4bc6-bc2b-34f78067fc28', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('45a61cc9-ae9b-4dc2-a621-1af6a756288a', '朝阳区', NULL, NULL, 316, '096d0f9e-9537-43f8-95f6-8dca9fa4cad4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('45aa8e8f-b1a4-4d04-91ad-a586ecead0ef', '二环到三环', NULL, NULL, 2910, '0687423f-e02f-4a66-92aa-f508821059ee', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('45c5e8da-8ec4-4f38-b6f4-4f9cf9d49c65', '铜溪镇', NULL, NULL, 3884, 'a732da28-870c-4d9c-a287-c2c1e3222b59', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('45d4f9d3-a620-4b4e-a94e-b66e38f1747f', '清新县', NULL, NULL, 2954, '8377f1cd-7272-4396-b99b-84bb707dbc2c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('45d85267-94ab-446d-b790-46f6862cbbde', '城区', NULL, NULL, 1410, 'ef3ce48f-e710-4c8e-9945-8fd849aa8e34', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('45d9bd47-9656-41da-ae25-e2ca848eb0a4', '油尖旺区', NULL, NULL, 480, 'dfb8b556-10a2-43ab-9fdb-66cde92320ee', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('45e8272f-2062-4ce0-92ab-a8706af7fd51', '六枝特区', NULL, NULL, 3550, 'd80168e9-9b95-4dbe-8977-d2e37c07e946', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('45e994a1-b971-4a2a-b2f4-18094b1b0ee0', '润州区', NULL, NULL, 1756, '63f8e070-63c0-4fa1-821f-d1d5a695ce2a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('45ec4928-2771-4520-af11-f5030369d21a', '珙县', NULL, NULL, 1823, '18a8dd20-aad4-43cd-ab48-ab6108097d8a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('45f5b683-0600-4242-8f84-9f5b877c0a81', '浮山县', NULL, NULL, 3698, '1aeeea9e-d028-4a96-94ce-ba84cdd3e69f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('45f7a007-38a9-4fa2-aa94-6fa607330518', '南海区', NULL, NULL, 330, 'dbd204cb-29de-4212-8c03-c2286f2ba4f5', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('45fa1c3b-47f7-43a0-810d-50b06216ecc8', '武冈市', NULL, NULL, 3753, '30ce87bd-09cc-4250-9b5e-1f5916ce4d70', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('460fb20b-254a-464c-9a4c-859aad56ecd0', '汉寿县', NULL, NULL, 4300, 'dd99fcda-6192-4ada-bef5-b04735e7dae8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('46192a3b-2bc6-4641-8d4a-e2017dd57e68', '孟村县', NULL, NULL, 2897, 'a3c44525-9ccb-429d-a2b7-f5f5d52b8a6d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('461ff988-58fc-4b2d-864f-e07e7a236dba', '通州区', NULL, NULL, 1746, '7de09763-759b-437b-a3aa-4cb32bd3c6b9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('462278e4-4b4a-44cd-b3b9-47193cec6958', '越秀区', NULL, NULL, 1983, '926eaeaf-e8c5-47f2-89ff-6932b52c87d3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('46261a22-d2e8-41a7-a9a9-40ec4a1db59b', '禹城市', NULL, NULL, 4170, '9c8b6d83-dd06-4238-b7f4-c0ad532e5b6e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('46278e4a-b3f1-472f-a5ce-375f09fc38ea', '资阳区', NULL, NULL, 83, 'c2eab125-e437-4681-9331-695a7b3b1ecf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('462e1a53-6706-4159-9f74-347755fc9be3', '电白县', NULL, NULL, 694, '88bc9baa-b7fd-4bf4-a896-4e049185e0c2', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('46354d9b-fb6e-48b1-9271-137caa7d70a2', '大朗镇', NULL, NULL, 3325, '3bc6861d-0eeb-497e-9257-42f9cd6fd26f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('465f84b6-2851-44b1-9d68-c70b8360ccac', '新绛县', NULL, NULL, 4105, 'fc30b5e5-3005-4778-94f7-706b31514bff', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('46824009-e14a-4988-9e77-2246bfa3a16f', '宝应县', NULL, NULL, 3051, 'f9ca7af3-a2b5-4d1c-a8c5-c4dbe4fe60e1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('468af103-fe98-45ef-8d4c-ecb232b08828', '其它地区', NULL, NULL, 2536, '1643aaaf-a1e0-4b6b-8953-28c93dce03e0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('46939204-a0a7-4d07-bba9-2bb7f46694fa', '城东乡', NULL, NULL, 669, 'd7f44c2a-2728-4633-a8b6-7643136bc99d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('46ac1d7c-434f-4e0c-91a7-c37c10bab5fc', '娄烦县', NULL, NULL, 106, 'de59cca6-548c-4009-9776-5daae2b866a6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('46c24994-ff5a-4734-bbef-0b211cf0327b', '香洲区', NULL, NULL, 1431, '258231ca-ed61-443c-873c-5d5b85483ac0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('470226eb-6dc2-4647-a6e1-bc75b8f90f14', '临夏县', NULL, NULL, 2233, '5d2d5d2f-fd44-47ad-8108-b7f838073fbd', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4707c47b-5ced-43be-9e97-a439362a6e6f', '接龙乡', NULL, NULL, 4462, '4888e1e9-ba45-4254-83e7-87796f338e2d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4719f9b2-50c5-47c3-8ecf-48a55bbf3f69', '三江县', NULL, NULL, 2743, '0f2ba543-1d40-4b41-b700-6b53a9622b5b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('471d182c-108e-4d87-8fb1-55493c07ecf4', '宝塔区', NULL, NULL, 3393, 'f95958de-a678-4371-9710-6bcac3f425fa', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('472c5aa5-ee9b-4e92-9228-174f23c07943', '淮阴区', NULL, NULL, 759, '3c9ba44c-7031-4422-b9b7-85d772ee3e08', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('475bce79-8e54-46dd-81bc-9287c973ff11', '清原县', NULL, NULL, 1382, '6b5fed36-b200-40ca-af0b-11999b4399ef', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('47754d28-5f9b-4137-9ebf-c384424158aa', '宿松县', NULL, NULL, 3581, '818f3bc6-83b9-4d90-8e68-566cc7c2bb14', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('477965f9-f9bc-4534-a11a-6eb8670ad174', '海棠湾镇', NULL, NULL, 3056, 'e60d3fe5-6d26-4a3f-b920-8fb6c4986bfb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('477fc6b8-948b-4f21-9b76-063f943ac53a', '竟陵街道', NULL, NULL, 2137, '671275c4-6107-4968-bd8e-96d53e9995b2', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4780816d-e867-4591-82fe-306e06b8381b', '平桥区', NULL, NULL, 3502, '976170b4-d0f7-4fd9-82ed-6e336c9bf3c0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('478e80bc-323f-4988-b48c-c93e3c8848d9', '市中区', NULL, NULL, 2520, '8f917434-e687-4552-b494-0eab3af61900', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('479a1a15-edf7-40fe-9bca-87209aa7733b', '长安镇', NULL, NULL, 3313, '3bc6861d-0eeb-497e-9257-42f9cd6fd26f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('47b4b086-29f4-40f8-b2e0-490a1191ebd8', '金泽镇', NULL, NULL, 2545, '89a9c37c-487a-4c32-968c-cf9fefad8151', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('47b90146-8af6-4aa5-87d3-9dd4f841a99c', '涿州市', NULL, NULL, 2475, '81e22d56-a1c7-4263-be18-81a4af165ae3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('47bff7b0-8a74-46a1-88f4-d5988a1c868e', '黄水镇', NULL, NULL, 796, '0f559985-f6fe-4a8f-af80-3d0d64932dbc', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('47c370a3-5068-49ea-a7e3-0737d56cc6df', '平果县', NULL, NULL, 1219, 'f56fa64d-ca06-49d2-a9cb-94742a33af21', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('47ca059b-29f1-4671-8036-19ee4c940838', '金洞乡', NULL, NULL, 3373, 'aa2f26e5-9705-4dc0-b54a-a2d7dbb8b511', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('47d5fb08-023b-4a94-8023-83b4a8643997', '陵县', NULL, NULL, 4171, '9c8b6d83-dd06-4238-b7f4-c0ad532e5b6e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('47de114e-00be-4448-bf3a-839e2db9950d', '余姚市', NULL, NULL, 1675, 'c5cc1924-02da-4927-982d-54f0b9f70ef8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('47eaba92-be2b-4d59-ae5b-fc5bb37995fd', '冷水关乡', NULL, NULL, 924, '88260608-a8b9-4b52-a474-1a551465c675', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('481288c7-bf1d-44b3-9f4c-c39fef8671e2', '阿蓬江镇', NULL, NULL, 3358, 'aa2f26e5-9705-4dc0-b54a-a2d7dbb8b511', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4812957e-20e3-4c26-a8e3-fb48accef0b2', '安乡县', NULL, NULL, 4302, 'dd99fcda-6192-4ada-bef5-b04735e7dae8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('48142eb9-8286-4d1b-aaa8-f170eedebb56', '长滩乡', NULL, NULL, 1911, '2c8bc8c3-9317-4f36-a0ad-05a8d6b27053', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('482b4e0f-20d4-403f-a552-46c8aa003d9b', '柏乡县', NULL, NULL, 1031, '4d6c5692-82f1-443c-9163-39a3dd77636b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('482c0012-c23b-4dc6-b0d5-daee40376c5c', '临江市', NULL, NULL, 1395, 'baaceb68-ffec-405f-8bcc-9d58ab5a0c1e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('483845a4-48fe-48d4-b4ee-f86b21e75bfc', '芦淞区', NULL, NULL, 2606, 'cdeda821-2101-44e1-a986-183436199f05', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('483ff64a-e6e3-4718-a8e8-89504ddf4523', '兴宾区', NULL, NULL, 2165, 'f63c9587-7455-4dff-950d-0da6dddd16c1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('48446316-a79b-45cb-adea-a4de53b8a54c', '长龙乡', NULL, NULL, 1501, '89e8be16-b810-4c7e-89f0-aa9f24483b98', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('486d0f1d-c3c8-4876-8a91-4d8058a05c33', '巴福镇', NULL, NULL, 3542, '99107e35-f7d9-4c45-8d21-7a03b9c2f99d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4870eec0-0259-4b47-a444-7904bc46c323', '忠州镇', NULL, NULL, 2653, 'e509a1a5-95da-4fb2-9a2b-f84afa05a36c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4874c912-c806-4565-bc62-f39186f2cae9', '蒸湘区', NULL, NULL, 4257, '75dd761e-ce3f-45bb-a86b-d3a1e2c7629a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('488aeae4-dec7-4ef5-9c59-4b61c41791e0', '盈江县', NULL, NULL, 435, '10aecf03-914d-4a26-a6c3-0045748d43b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('489d44a6-4792-4fe4-a793-75c93d7a15fc', '罗泾镇', NULL, NULL, 767, 'c470aa47-a334-4df9-a8ea-b90683ddc861', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('48a79222-3f98-41fa-87f7-b9a70e6aed31', '江阳区', NULL, NULL, 577, '78000393-73bd-4a54-a688-5db0e578d9cd', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('48bce4eb-38db-4a12-9165-1c23fa947f21', '高行镇', NULL, NULL, 2632, '4683d3ef-0edf-425a-98d5-2cb231a7d88a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('48c1e02f-2d62-45e6-be86-e66b9f6955b2', '沙雅县', NULL, NULL, 4398, 'b7bc3a10-ad00-4b20-9fa4-cb08ad7492d3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('48c8b1f4-ed30-4e07-a843-6f619a7f8515', '城北乡', NULL, NULL, 668, 'd7f44c2a-2728-4633-a8b6-7643136bc99d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('48ee6194-72ee-4fcc-8449-11b846447f12', '侯马市', NULL, NULL, 3693, '1aeeea9e-d028-4a96-94ce-ba84cdd3e69f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('491c8321-1da4-4360-bb63-8326b924f619', '神童镇', NULL, NULL, 948, '88260608-a8b9-4b52-a474-1a551465c675', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4923d4cf-23da-4756-89b4-7115b350f2c7', '五大连池市', NULL, NULL, 1424, 'e27d8c07-338c-4b1a-b45c-cf9cf0a22a0c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('492a217d-ccb3-4193-9338-f2646298e735', '宝芳乡', NULL, NULL, 3817, '96fec37f-11d5-4d41-aba4-a36d0652744c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('492e558e-abaa-4067-a6a5-fd36afef2ea8', '泰和县', NULL, NULL, 4321, '5f548430-51dc-45ad-82e5-bcd0394d8f6c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('493297c4-10fb-4b7f-b028-41c7868f231a', '桃城区', NULL, NULL, 2468, 'b126935b-0423-4bea-b802-d4e6680d1d71', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('49339f79-2044-4e34-8ffd-30555d90a0f4', '内环到二环里', NULL, NULL, 4080, '18de87f3-b679-462e-93ac-770a72141f3b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4937fe5e-1110-47fd-a28a-5130a94708d0', '罗豆农场', NULL, NULL, 3822, '96fec37f-11d5-4d41-aba4-a36d0652744c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('493e9ed6-780e-4d95-8316-04061610839c', '荣隆镇', NULL, NULL, 2518, 'd998f8bc-c659-47ce-8e5e-a6b29e03ecb3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('49446ad5-5c5d-4ed1-b098-a6c22c904255', '弋阳县', NULL, NULL, 499, '8bf55045-9366-4acb-b884-bca672ff9644', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('494493ca-6b66-4255-bae1-c1de08f015d8', '绥德县', NULL, NULL, 1295, 'c0c88cbd-87ea-4281-9e8e-94a435ae6590', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4944c4fb-c94e-455e-b587-5c227e98d29c', '路南区', NULL, NULL, 2451, '4f4c1ef4-f54d-4ba4-a124-ca2d3d0ddb78', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('494fc66a-3807-468b-836a-8c18ffa71097', '港西镇', NULL, NULL, 3983, 'fcc07455-c69c-4c90-82cb-ddb268adb8a9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4951abe8-c81a-4f6a-a3dc-2c9ca79a84b7', '张家港市', NULL, NULL, 609, '278acb58-4d2d-40cb-a572-1fc7fb979c77', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('495ae2d6-3038-4f9a-a657-cfdff01928a6', '磐安县', NULL, NULL, 228, '1721f4b0-56cf-4408-a217-62416951c176', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('496ea65e-1acf-4fce-a06a-b9e6104312a2', '长子县', NULL, NULL, 3858, '6fc78ef9-e2eb-46bc-bf8e-8b830ad96136', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('497ee9df-b8b1-4b2f-a83b-65c250d0e540', '县城内', NULL, NULL, 1914, '442f465d-6566-45e4-9338-50f4395aa6f7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('49940f89-f34e-428e-9366-f7db4596f721', '芦溪县', NULL, NULL, 1154, '20c4f23e-77e7-4763-9ba8-dd00d5216748', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4996ed5c-a0fe-4fa8-9f37-bd90488af42b', '江宁区', NULL, NULL, 1869, 'adb7aa6e-99a6-453f-a2db-21ecfbc44874', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('49984799-a046-4f1b-84d9-fb3538dbdc1b', '兰桥镇', NULL, NULL, 970, 'cc124ed6-091a-42ce-a87a-bb4d0d7357b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('49abd2ef-f88c-4d7a-b442-5694f0e5c638', '盘县', NULL, NULL, 3549, 'd80168e9-9b95-4dbe-8977-d2e37c07e946', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('49b085d2-5b65-4555-882e-036972a28955', '宽甸县', NULL, NULL, 2799, 'c0064cbf-ba5c-4dc0-a855-b330e096cd61', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('49c8b7ad-419d-40dc-bc71-71bc219319bf', '仁贤镇', NULL, NULL, 655, 'd7f44c2a-2728-4633-a8b6-7643136bc99d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('49e5861e-e879-4523-91bf-e7dbcecda378', '安化县', NULL, NULL, 81, 'c2eab125-e437-4681-9331-695a7b3b1ecf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4a283ba3-52bb-4e9a-a8d9-50edbe562fdb', '中梁镇', NULL, NULL, 3910, '7fefd2bf-99e0-43f5-bc37-9ab15ee8e8f3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4a2ab7c3-fe44-4bb3-be18-fd0302b1c40b', '阳新县', NULL, NULL, 3916, 'b3b5e655-b2df-467e-ad5f-2ab21c2a0aba', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4a2fc610-66a1-4bba-b179-bbe414aca75e', '王家乡', NULL, NULL, 790, '0f559985-f6fe-4a8f-af80-3d0d64932dbc', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4a3f01bb-5e9a-430a-9aee-a067221d163f', '中平乡', NULL, NULL, 993, 'cc124ed6-091a-42ce-a87a-bb4d0d7357b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4a565270-d031-4c70-9b8d-47e6f61c79ad', '法库县', NULL, NULL, 1840, '271a8d5d-a9a3-4876-a9a2-ca9bcee4b83f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4a75ac0a-6f77-4620-9568-5b06332e654b', '靖宇县', NULL, NULL, 1397, 'baaceb68-ffec-405f-8bcc-9d58ab5a0c1e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4a77ba0d-1987-4b5d-af58-bcc93d35989c', '庙坝镇', NULL, NULL, 2383, '0275a9ca-e89b-4217-b3b0-ada824d9e095', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4a95cf63-5671-4faf-aedc-d4d0bc1ee457', '柯桥区', NULL, NULL, 1417, '472589fe-78e1-4c48-8fde-cf3996a778ca', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4ac1a67d-29c6-4a39-9237-66e71a586335', '盐津县', NULL, NULL, 3687, '31187fc0-8d6e-45f3-9653-b7ce4227ef1d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4adb709d-c1dd-40df-b482-e1680ca43806', '合山市', NULL, NULL, 2166, 'f63c9587-7455-4dff-950d-0da6dddd16c1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4af17ce0-5168-46a9-a2fb-c2c7cf9422fd', '百胜镇', NULL, NULL, 1113, '72d4f69f-2e4c-4bde-9df8-2aadc9168686', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4af1fdc2-1a04-4ca7-aeb1-a90a36e7d62d', '康保县', NULL, NULL, 135, '37614653-bf6c-458f-a844-540790491eb1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4af7151b-8305-42c5-b081-4dc3f2c22d73', '高丽营镇', NULL, NULL, 3724, 'd1c1539c-b904-4bcc-a034-96213f63d0ff', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4b27612a-5c80-4ecc-8e3c-cd38c78a5644', '太和县', NULL, NULL, 1624, '6de68814-d6ea-430e-88b6-bf98620aa604', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4b2c0f97-b6c2-41b0-9061-7cca577f5f1a', '丹阳市', NULL, NULL, 1760, '63f8e070-63c0-4fa1-821f-d1d5a695ce2a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4b2dbc3c-66c7-415c-a5be-9f9219793d82', '武平镇', NULL, NULL, 1929, '442f465d-6566-45e4-9338-50f4395aa6f7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4b3004df-3cc8-41c4-a06e-385ef19a77e0', '泉港区', NULL, NULL, 1852, '0d3bd52a-74b2-4461-9a57-17c7cce4ac1b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4b3b00be-5124-44e8-9a23-8d1dd5736b62', '曲麻莱县', NULL, NULL, 2075, '27eaf8ae-634a-45eb-bdc9-207c699d16ef', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4b4103cd-245f-4e56-8057-e21340368329', '阳城县', NULL, NULL, 2851, 'ffe07042-807c-4f16-a63c-c1eb8785b06b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4b4bf0fd-73b0-44ad-b895-44bfdb400de8', '文罗镇', NULL, NULL, 549, 'b75db043-9782-4bae-aaee-bea49fc286e6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4b642f15-9ebd-40bf-82f4-420f7e7c59ad', '金江镇', NULL, NULL, 4082, '5d3b3a34-50c8-4a01-83b7-e3e068d5c9a7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4b6ebe9d-f48c-449b-8066-9ad4c2ac379a', '黑水县', NULL, NULL, 1190, 'd56c2ee6-b81c-4df8-ba2f-3df7680243c4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4bbfa9dd-a970-4ae0-ad2f-2f62fdfbc69d', '温泉镇', NULL, NULL, 3259, 'a39ced08-b6e9-4de0-a2db-7a230a673d1e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4bc47f59-b591-4e9c-94e8-4dd45c0d21fb', '仁沙乡', NULL, NULL, 1942, '442f465d-6566-45e4-9338-50f4395aa6f7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4bc660ed-c36f-43fb-91f8-fdab7405776b', '走马镇', NULL, NULL, 3548, '99107e35-f7d9-4c45-8d21-7a03b9c2f99d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4bd63f4c-4ac3-48f9-aaa8-0b2b5e1c68b3', '峡口镇', NULL, NULL, 2262, 'd17f8f8e-b3dd-4818-a89d-8b431ff5c555', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4bd7a292-253b-45b6-a16c-a373caf80180', '灵璧县', NULL, NULL, 4098, '94f58cdc-52ca-4a35-a822-4b62ab8bd3d7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4be2cc0f-0abf-45c5-bdf7-a654fd444bec', '新竹镇', NULL, NULL, 1563, '5f7e2e46-8a4e-4463-907c-5762bcd006a8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4be34000-8485-47ac-943e-2c4727009602', '西昌镇', NULL, NULL, 4337, 'e98653ba-264e-4417-b74e-e0798b25e646', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4c0090b9-3f40-485a-9201-ae11d23d61e5', '包鸾镇', NULL, NULL, 1917, '442f465d-6566-45e4-9338-50f4395aa6f7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4c05ae30-15d3-40c1-97c7-63bb452779cb', '陇县', NULL, NULL, 1831, '7c3fbad9-df03-4d15-93a4-695924a2f35d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4c09c4b4-56c5-407b-905b-0666fa99b834', '全境', NULL, NULL, 2405, '66241d25-208b-4800-958a-fa2767754102', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4c3d2bdd-743d-4b87-9768-d151b9944aa5', '叶城县', NULL, NULL, 2036, 'e6436d79-8045-4185-b2b2-22cd280d22b0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4c4ab0ea-cf5c-4caa-8406-7ceffb8b2a98', '彰武县', NULL, NULL, 306, 'fca062e6-ca02-4963-9f79-ed8cbfbb11df', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4c511a13-a01f-41c1-acfb-169d0954c813', '边坝县', NULL, NULL, 2698, 'b7342349-941d-427d-9ab6-e83a36078088', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4c7b7b47-0705-4926-b88f-c08eb549e403', '和顺乡', NULL, NULL, 4459, '4888e1e9-ba45-4254-83e7-87796f338e2d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4c7d159e-d6ab-451d-b2fc-3f86d6ba07e8', '郧县', NULL, NULL, 3934, 'd795e41b-eb16-4383-b762-ea557481f8e1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4c9f1413-2c80-476f-adf7-6f6842894632', '南岛农场', NULL, NULL, 3065, 'e60d3fe5-6d26-4a3f-b920-8fb6c4986bfb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4ca5dd63-1b5c-44c4-a8aa-01066637eff6', '赤城县', NULL, NULL, 138, '37614653-bf6c-458f-a844-540790491eb1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4cabd779-936e-4a8b-807b-0c45606151bc', '融安县', NULL, NULL, 2742, '0f2ba543-1d40-4b41-b700-6b53a9622b5b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4cac42ec-534b-475b-8aa1-7f2742478648', '山阳县', NULL, NULL, 1389, '332e1b20-ce8a-4065-ab84-b60416060476', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4cae9d39-a3c8-443f-a161-e184a837159c', '湟源县', NULL, NULL, 3864, 'baa2f053-c419-40c1-93fe-68e081b7f229', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4cbac4bf-48c2-4654-9618-03b96433117e', '南涧县', NULL, NULL, 242, 'feece7c8-8eeb-494a-8e84-571b6ebcf0d9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4cbad628-807f-4279-9b89-cfde77d1547d', '万全县', NULL, NULL, 143, '37614653-bf6c-458f-a844-540790491eb1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4cc2c892-f063-474f-a4b2-5e9ef3e6d026', '渠县', NULL, NULL, 1011, '6681b8cd-3740-4dbd-b311-143871994e15', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4cfb8f04-2062-42f6-b54d-58954426f614', '官阳镇', NULL, NULL, 366, '76dd00a1-30a1-4226-ae06-cad845c0528c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4d1b63aa-931e-4bc6-a803-597e89af11a5', '潜山县', NULL, NULL, 3586, '818f3bc6-83b9-4d90-8e68-566cc7c2bb14', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4d3bda35-19d1-4cae-8c56-1faafcf10875', '城区', NULL, NULL, 2118, 'c3c4411b-8905-45b4-b38f-09be90102664', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4d567359-66f2-4f9c-85e1-556837c636ea', '思明区', NULL, NULL, 1207, '9122834d-aef5-4895-974e-82d2f568bcd4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4d681b48-5e5c-43a4-8ea3-56e8508fa66f', '江干区', NULL, NULL, 2309, 'f530455e-1c70-47dd-9a80-4bc74a4e2680', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4d6e2555-f541-4775-b7a0-eb5e791dc18b', '沾益县', NULL, NULL, 1335, '9568bdcc-65c2-4b1c-a512-b2ff897db321', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4d883d3b-3f0a-4c5d-93df-bab757ec5c14', '邢台县', NULL, NULL, 1028, '4d6c5692-82f1-443c-9163-39a3dd77636b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4db6191d-a773-4de4-8474-f51f8edb6595', '企石镇', NULL, NULL, 3328, '3bc6861d-0eeb-497e-9257-42f9cd6fd26f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4dc82f99-fd91-42ea-a556-f4ef545ce114', '龙马乡', NULL, NULL, 3818, '96fec37f-11d5-4d41-aba4-a36d0652744c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4dd04b8b-15a3-4455-8b47-e6559aa2056d', '铺前镇', NULL, NULL, 3810, '96fec37f-11d5-4d41-aba4-a36d0652744c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4dd1a690-87d4-4343-820a-c016c078542e', '铁村乡', NULL, NULL, 936, '88260608-a8b9-4b52-a474-1a551465c675', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4dd90f74-b5a2-40e1-bd41-69cf99556eb8', '寸滩镇', NULL, NULL, 1714, '86ab4d11-9653-4b0d-8cc1-2e12a4de15d6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4e02ca02-7684-476a-a381-588f6bd36fc7', '细水乡', NULL, NULL, 1362, '21bb958f-e5d4-4a71-a350-b5bf2c0e2de0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4e04baed-83b5-41da-957c-e0a3b1a12caa', '临城县', NULL, NULL, 1035, '4d6c5692-82f1-443c-9163-39a3dd77636b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4e0c78e2-b71f-48ac-a58d-8184e18f193a', '雨城区', NULL, NULL, 3628, '6af0e8d8-91c9-43be-be32-5ec5c86b14f5', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4e1ff821-95b9-4d65-a1db-e29888c6d798', '黑溪镇', NULL, NULL, 3362, 'aa2f26e5-9705-4dc0-b54a-a2d7dbb8b511', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4e3e53cf-b408-47b0-a03d-ace8ed412906', '长垣县', NULL, NULL, 2181, '1aabde9d-2b04-4892-a20d-5b4e3efaeedf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4e4f6320-c3f6-4f08-889f-e6bff429e604', '东港区', NULL, NULL, 2423, '552f7151-162b-4453-a9c5-3a9092fce226', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4e593d6f-8a14-4ec6-b419-3fbe7d3ad259', '经济技术开发区', NULL, NULL, 1078, '99f84690-670c-4a0e-ade1-ebcf17b00adb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4e5dc6ed-3f86-410f-b6b7-2ada9cadb8cb', '澳门半岛', NULL, NULL, 916, '691e132f-04a3-4856-a77a-92ed2dc5c246', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4e5e4ecc-7401-4343-b8b7-541cabe15114', '颍泉区', NULL, NULL, 1628, '6de68814-d6ea-430e-88b6-bf98620aa604', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4e5ff549-a17a-4c66-8750-8305e9f8a8dd', '定兴县', NULL, NULL, 2488, '81e22d56-a1c7-4263-be18-81a4af165ae3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4e8a74ba-f0ce-4014-ad59-86e0b12e348b', '芒康县', NULL, NULL, 2696, 'b7342349-941d-427d-9ab6-e83a36078088', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4ea649f6-1bdf-461c-a552-1c8a02e9d394', '白云区', NULL, NULL, 535, '46abe060-5805-4aaf-9d89-b66bed4b224e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4ea71901-bd82-406c-841a-e43515133273', '上林县', NULL, NULL, 2807, 'b53ced47-2455-44ec-b740-7637148f574c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4ee8160e-7bde-41cb-8867-f692673180dc', '工业园区', NULL, NULL, 3474, 'ea11feaf-194c-4cec-be59-d17bac402db4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4ee99c66-f43d-41c3-9d43-3f9a596580c9', '晋宁县', NULL, NULL, 2864, 'd7efec13-7e84-436d-8390-41868af0e359', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4ef4dbb2-1446-49bc-8574-1e444dce0937', '打安镇', NULL, NULL, 1361, '21bb958f-e5d4-4a71-a350-b5bf2c0e2de0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4f04eeb9-4464-4a88-808f-282b1a62dc3c', '正蓝旗', NULL, NULL, 2348, '67723aea-a4ef-4eb7-afbf-55cc07806f98', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4f099728-353e-4418-bb1d-b7ef6c4104ac', '顺河区', NULL, NULL, 4179, 'fb0dbd60-1d03-4394-a890-ffc2d3ec6a37', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4f0a0bf9-0897-45eb-8e0e-2db43de353d7', '翔安区', NULL, NULL, 1209, '9122834d-aef5-4895-974e-82d2f568bcd4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4f279c56-a35b-4eb0-a898-8fdf79678213', '红椿乡', NULL, NULL, 378, '76dd00a1-30a1-4226-ae06-cad845c0528c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4f2ab560-281f-4085-9920-6cfe38efcc2f', '六环以外', NULL, NULL, 3001, '1e3ed660-6de7-4b3a-a1d2-3ea7e0778e94', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4f33bb94-4e52-4424-932c-65dcf6ba8aeb', '大石坝镇', NULL, NULL, 1720, '86ab4d11-9653-4b0d-8cc1-2e12a4de15d6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4f3859ed-924e-4224-93a3-2f4396807004', '礼泉县', NULL, NULL, 2104, 'e42fbad8-c29e-4f35-878d-95a667b5cc90', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4f450012-cb6d-4949-8d26-d9e84953c5b5', '郑东新区', NULL, NULL, 4117, '4ff4ef6c-41df-4562-a58f-d8b25b2e3ba4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4f75d7ce-4f39-45ad-abc3-a865d72dacb7', '京口区', NULL, NULL, 1757, '63f8e070-63c0-4fa1-821f-d1d5a695ce2a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4f88c0b0-25e5-44cb-b082-e3cdacc4a867', '重固镇', NULL, NULL, 2542, '89a9c37c-487a-4c32-968c-cf9fefad8151', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4f94985b-98da-423b-a755-c0cd8589d11b', '北塔区', NULL, NULL, 3752, '30ce87bd-09cc-4250-9b5e-1f5916ce4d70', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4f94a5a6-6892-4329-a2f5-58e04be630dd', '新桥镇', NULL, NULL, 89, '3e082d1b-ecb4-4bf8-8715-54132a9106e1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4fa51cd2-28b0-4d72-b50a-a6d4b438a55a', '中和镇', NULL, NULL, 3214, '2e21ea75-c640-4928-8cb4-e5ba4f6e2ffe', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4faac389-3b8a-4189-ac8a-c9d701778622', '未央区', NULL, NULL, 4288, '29595f0b-301d-42da-845d-01afb30a9c18', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4fab8b13-038a-4dd4-b423-895dc8d50a11', '即墨市', NULL, NULL, 3714, '1e53830d-8cdb-4111-8da6-987131b873ed', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4fb2ca01-ebec-44b8-9b6b-9095cf277429', '常平镇', NULL, NULL, 3319, '3bc6861d-0eeb-497e-9257-42f9cd6fd26f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4fd88931-2508-4f45-b4a8-f621c373acd2', '平山县', NULL, NULL, 2770, '334645de-ae54-416a-8978-2dbf9f7bbd09', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('4fdddbca-3aa4-458c-8a51-04d8dcb4ad6d', '双阳区', NULL, NULL, 320, '096d0f9e-9537-43f8-95f6-8dca9fa4cad4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('500dee60-2819-4eb9-93a5-5c25178eb271', '五峰土家族自治县', NULL, NULL, 1786, '3760382f-ecb5-4ef6-8bd2-049afe34b574', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('500ef381-3b6e-4e4f-b636-9fc9c348c2c0', '凤凰县', NULL, NULL, 3792, 'b9b94634-b449-4449-9581-c70550dc5099', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5017a257-3296-451c-a312-5be0882c578d', '港口镇', NULL, NULL, 2195, 'f2727650-b0d9-4541-acdb-b4eabf894893', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('502514e1-a0e1-47ae-a136-12e1e483e77d', '江川县', NULL, NULL, 4147, '2b997404-05c1-436b-8004-2d5dfd364db3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('502cfa9f-31af-47d5-ba0d-b38a432a08ae', '乌兰县', NULL, NULL, 3006, 'a638060f-a01c-4c77-b905-b46ef8d3e89d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('502d35e4-9098-46fd-abfe-8e530a9d0abb', '遂川县', NULL, NULL, 4323, '5f548430-51dc-45ad-82e5-bcd0394d8f6c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('503834bf-7381-45ba-8433-00eb0b295ccc', '红安县', NULL, NULL, 1000, '63a5fa32-35eb-4eca-ab79-f3887e122564', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('50399852-92c4-47a2-9cba-a66d7a73bafd', '新站综合开发试验区', NULL, NULL, 161, '6ab7dc5a-1064-4090-a81b-79c3a2e8302d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('505731d1-ae8d-4dd7-b30e-a4e1901f4d00', '宣恩县', NULL, NULL, 2358, 'ecba10ba-2c25-4ead-a781-ad16a832226f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('505afb3f-85cf-4561-966a-c52c833c329e', '沙县', NULL, NULL, 276, 'cae0a47d-0d79-4fa6-aac9-e8b3b535ee3c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('50649be8-8806-46e4-a0f8-27944ecc6ae1', '九龙', NULL, NULL, 491, 'dfb8b556-10a2-43ab-9fdb-66cde92320ee', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('50759d14-534c-4150-9477-7ae8dd88b007', '庐山风景名胜区', NULL, NULL, 122, 'bcaf1f36-5459-4e74-81d1-5026680b1a9c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('508ef063-addd-4348-8da8-170b641f2e11', '颛桥镇', NULL, NULL, 4028, 'f6eb800d-2093-4ce2-8105-3747d69abe97', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('50b3dfe6-83a3-4c82-9067-c03e65f842c7', '本号镇', NULL, NULL, 550, 'b75db043-9782-4bae-aaee-bea49fc286e6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('50cbf17c-8beb-4f6d-b574-7297c1691b2a', '玉峰山镇', NULL, NULL, 704, '97942649-3cc7-4e4a-81b4-9a8c82f82ea7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('50d9d4fe-a845-4333-a677-936621411ab6', '刘家垸林场', NULL, NULL, 3479, 'ea11feaf-194c-4cec-be59-d17bac402db4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('50e31266-7f77-4df4-ac31-00bbcef86c3b', '八塘镇', NULL, NULL, 3595, '27289f06-ca7a-4916-8f25-f6b13d8687ec', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('50e41f2d-8482-45ff-ad7e-88a983f6a9fc', '普顺镇', NULL, NULL, 1482, '89e8be16-b810-4c7e-89f0-aa9f24483b98', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('50ea1b50-883f-41ed-8502-0f207768e9ee', '南沙区', NULL, NULL, 1988, '926eaeaf-e8c5-47f2-89ff-6932b52c87d3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('50f81935-c27a-4f6e-92a7-cef749a5d3e4', '连南县', NULL, NULL, 2956, '8377f1cd-7272-4396-b99b-84bb707dbc2c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('50ff2622-dabf-4135-a86b-8f2b397466f8', '荔波县', NULL, NULL, 3488, 'ef4b5cd7-d6b5-4839-9963-c010487ba475', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('510f49df-36ff-47ae-ac73-7480c99060e7', '德江县', NULL, NULL, 2870, 'dce7fe20-4766-408d-92be-62ba8fbb7a43', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5141c2b6-0da8-4b8f-9404-3a1fb75d4de8', '合阳县', NULL, NULL, 3169, '9e5ae65c-206f-4d7b-87f2-c252d5f40b52', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('51420032-9171-46e0-81db-5562adc80674', '古路镇', NULL, NULL, 1577, 'ac0e6e50-b6a1-457c-811c-06ac309cd5a3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('514219b9-a79d-4b8f-b5d4-7a61ea3348ce', '冕宁县', NULL, NULL, 3516, 'c8f594a3-8acc-48a9-ba2f-e76934de05eb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5163755a-d40c-477e-8be6-1f7e04f3c200', '畅好农场', NULL, NULL, 17, 'c8bf9a67-2bfc-47fe-9580-3f2f2eac1edb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5167284e-89c9-4864-b5fc-b008a0a0e91e', '九湖乡', NULL, NULL, 3075, '4b20c67b-06ca-4c0b-a947-bc518238537e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('51672cbc-f865-4cd9-bf13-e372de2db132', '七星区', NULL, NULL, 3186, '796bb0e0-6b76-4c1d-801f-2dbcbab74087', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('518482a7-4fee-488c-ae9c-97d6850a84d2', '熊家镇', NULL, NULL, 4223, '0ee28cef-8dfc-4a9f-b7c1-330bc11c1bb3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('518ace67-3a58-4292-b61d-5b040282b835', '永城镇', NULL, NULL, 3669, '6581d8db-553e-4417-8c37-91ed47904920', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('51ad7237-9a65-4646-ab54-9d7f33da0c16', '罗田镇', NULL, NULL, 4213, '0ee28cef-8dfc-4a9f-b7c1-330bc11c1bb3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('51b06866-cd07-48de-9d1c-09096f4bed99', '依兰县', NULL, NULL, 1534, '349a18f4-4117-490c-b26f-80702a4911bf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('51c73204-90e6-4101-83ed-568ad72f2b61', '绿春县', NULL, NULL, 3153, '99a9abd1-f107-4dc6-ae43-e9d1120504b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('51ca9575-6321-498c-b7a8-fd501b601036', '高峰镇', NULL, NULL, 4207, '0ee28cef-8dfc-4a9f-b7c1-330bc11c1bb3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('51e020c6-bd41-4a3b-8522-06a5a03af34e', '新郑市', NULL, NULL, 4121, '4ff4ef6c-41df-4562-a58f-d8b25b2e3ba4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('51e167dd-4d86-481e-81ac-6512e821e1fd', '梁山县', NULL, NULL, 2819, '5c8748b9-cee3-4d8e-956c-0d0e24db8850', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('51fb7980-399d-4d2b-9fa6-faba2e69adea', '河边镇', NULL, NULL, 3597, '27289f06-ca7a-4916-8f25-f6b13d8687ec', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('51ff7867-668a-4360-868b-285cfefc13ab', '简阳市', NULL, NULL, 3014, '951c8fd2-5d67-4ba4-b9a1-fd13fdcea9f9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('520bace5-22ff-4dfe-a555-fd2d150b4e89', '瑞安市', NULL, NULL, 250, '86b77e39-331e-4927-9517-49be7b738b9a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('52129b01-2699-4566-9a5b-6cb0e99df043', '喀喇沁左翼县', NULL, NULL, 4141, '0c1d1a8a-4eea-4aa0-9a5e-b68ae380a09a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5213e398-48a6-4a9f-bdd8-bc74b87f842e', '泽普县', NULL, NULL, 2034, 'e6436d79-8045-4185-b2b2-22cd280d22b0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('521a53e1-634e-497d-88b3-391363df3a86', '任县', NULL, NULL, 1032, '4d6c5692-82f1-443c-9163-39a3dd77636b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('524a8cec-1e6b-4d90-bc91-5e02fd156cdf', '松桃苗族自治县', NULL, NULL, 2875, 'dce7fe20-4766-408d-92be-62ba8fbb7a43', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5264544a-a294-4fb0-9598-3e28ea09e4e3', '鸭江镇', NULL, NULL, 4452, '4888e1e9-ba45-4254-83e7-87796f338e2d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('526aea48-351a-4447-81ea-406b03da0e4c', '白沙镇', NULL, NULL, 890, '41f376c0-764f-46b9-af35-e555518fc613', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('526c19be-2a29-4af4-8e49-3cb699a97edf', '天馆乡', NULL, NULL, 2943, '465e9ea2-a2f2-4b42-95dd-b48d91f67105', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5275fe19-e304-41e2-8f82-5d098c807f0e', '江油市', NULL, NULL, 390, 'efb72ec7-b29f-48d0-a16c-9a33d3938d49', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('527c7186-a2a5-4aa7-9118-63e2bc19c965', '石和乡', NULL, NULL, 1145, '72d4f69f-2e4c-4bde-9df8-2aadc9168686', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('528d4d92-abd4-447a-9b12-c78d117d82c7', '路阳镇', NULL, NULL, 173, '4f867632-2989-4def-9934-a9c5fe0d5ca5', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('528f2bf2-bbc1-4f87-a269-e044fb62537f', '卓资县', NULL, NULL, 3962, 'a061ae4e-1b4e-4b42-8aa9-cc6bbae9619a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('529bec02-6114-4bc1-b6fc-cb6ab6082fa2', '深泽县', NULL, NULL, 2779, '334645de-ae54-416a-8978-2dbf9f7bbd09', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('52acbd7d-7337-4a0a-aa21-7e19ce9b999b', '拱墅区', NULL, NULL, 2307, 'f530455e-1c70-47dd-9a80-4bc74a4e2680', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('52e954f2-0f47-4e0f-9faf-ef7127d320f2', '永清县', NULL, NULL, 1235, '86f7f02d-658e-44ec-9d36-b14cc3c65aaf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('52f38a0a-1081-4cde-8c33-4ab345f733b9', '巴彦县', NULL, NULL, 1535, '349a18f4-4117-490c-b26f-80702a4911bf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('530893f6-2d8b-4bd1-9af3-588d760eb8e5', '八公山区', NULL, NULL, 2962, '69508f5e-7304-4092-95a4-73d6a9b68eff', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5313238c-3fdd-47bd-9483-d3b5ae3328f7', '白马镇', NULL, NULL, 4446, '4888e1e9-ba45-4254-83e7-87796f338e2d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('531d64ab-c957-4b6c-af56-0b18a37ae922', '乌达区', NULL, NULL, 2209, 'aa1e4355-d9bd-4e6a-8812-0173f4f9815a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('532f68f1-f8e3-409e-95fe-a5625e4cd0d8', '通海县', NULL, NULL, 4146, '2b997404-05c1-436b-8004-2d5dfd364db3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('533a9da2-6aab-4718-b7cc-7316243ac4e5', '武江区', NULL, NULL, 1518, '754500f9-7ec4-4379-8b1c-9370f50564c0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('535588ca-fe71-46b4-9853-97e0057e2dc9', '利国镇', NULL, NULL, 2557, 'a1e3332c-7029-4de7-a221-40c041a9a620', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5358b3af-faa0-4073-a6d1-4f239b20b319', '丛台区', NULL, NULL, 204, '237eff18-fe6c-4842-afb1-acb05027a5c1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('536ad18e-a7d9-444d-819d-bd6527016b5a', '襄城区', NULL, NULL, 1347, '52d3ef0d-d999-4ae8-971b-534a2b25de02', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('536c9518-8b51-4dd3-bc63-5de9abf0ecfa', '布拖县', NULL, NULL, 3512, 'c8f594a3-8acc-48a9-ba2f-e76934de05eb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('53722f8c-b7eb-408a-bcb3-e74955ef1b79', '岳口镇', NULL, NULL, 2147, '671275c4-6107-4968-bd8e-96d53e9995b2', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('53a8a67d-176d-469b-ae75-27954fb85cdc', '长海县', NULL, NULL, 4060, 'd83aabcc-3c2e-4b48-962a-c548442bc896', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('53d08612-6b6d-43ba-aa96-a47fbdde6d02', '井研县', NULL, NULL, 2526, '8f917434-e687-4552-b494-0eab3af61900', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5403b43e-9fba-4e27-b63b-f89808430276', '银海区', NULL, NULL, 2029, '93e31709-76d2-4b65-aa0f-7990919a44d0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('54120df4-847f-4d85-8fc4-31702e0a4c9e', '万秀区', NULL, NULL, 3039, '01d0a041-f2c0-4416-b710-9376b2aabcaf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('541aa602-85f7-4633-b779-a8fcec3cc418', '水口镇', NULL, NULL, 3827, 'c33c3107-81df-4ced-8b92-d694df412da3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('542dc821-9350-4f17-85d8-630e266db9b2', '沙河口区', NULL, NULL, 4050, 'd83aabcc-3c2e-4b48-962a-c548442bc896', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('543860d3-bcb3-4b0d-801a-72c81f04e2ae', '双凤镇', NULL, NULL, 3885, 'a732da28-870c-4d9c-a287-c2c1e3222b59', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('54471525-381a-4f15-beae-019d063d0588', '五里乡', NULL, NULL, 3380, 'aa2f26e5-9705-4dc0-b54a-a2d7dbb8b511', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('544f05b9-da9f-490c-a224-c1032dcc2170', '都江堰市', NULL, NULL, 1809, '4f073365-4e02-459f-8b32-cad88dd22637', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('54555f58-c9c1-4192-bf02-56ba5e57829e', '崖城镇', NULL, NULL, 3055, 'e60d3fe5-6d26-4a3f-b920-8fb6c4986bfb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5458bce4-095c-4376-9daf-7d595c2ff4a7', '桥东区', NULL, NULL, 1027, '4d6c5692-82f1-443c-9163-39a3dd77636b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('547914e8-067c-49c3-9db0-44834eb8cd90', '隆昌县', NULL, NULL, 1997, '7e24b0e5-bf57-4e62-880a-e5b6ec159053', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('547c23f1-8c20-4dcd-a6f5-a4ab0d88918d', '聂荣县', NULL, NULL, 4416, 'fae5ed6b-9b68-4ef9-93fa-221dea13a975', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('54859af6-4b2d-42d9-87ef-08959e3e1d36', '鱼泉镇', NULL, NULL, 183, '4f867632-2989-4def-9934-a9c5fe0d5ca5', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('54a38e7e-d223-4c89-a888-6e7575a7864a', '连城县', NULL, NULL, 3352, '381b5351-4075-4ec0-88cd-f3e1da71c110', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('54b1ac48-1d7f-463a-8f76-9dc4ef0cd9a6', '中堂镇', NULL, NULL, 3344, '3bc6861d-0eeb-497e-9257-42f9cd6fd26f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('54b2e669-520b-4f35-bba0-36c28c093ee0', '永福县', NULL, NULL, 3197, '796bb0e0-6b76-4c1d-801f-2dbcbab74087', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('54b61ea0-645e-4997-8861-b1735f232631', '达坂城区', NULL, NULL, 3231, '8349c2b0-91a2-4e19-b9c7-81b5224fbabe', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('54c5053e-24f3-435b-a81b-579c8688e240', '上磺镇', NULL, NULL, 1580, 'ac0e6e50-b6a1-457c-811c-06ac309cd5a3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('54cddc6b-8964-4002-bbe1-d42cb9e02582', '路氹城', NULL, NULL, 918, '691e132f-04a3-4856-a77a-92ed2dc5c246', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('54d3de72-cac8-4c8a-90f6-13c0fa2a1b43', '大峪镇', NULL, NULL, 3928, '22f622f8-7eaf-41e9-90ee-2a0cfda1f326', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('552268e8-97cf-4f5f-8840-952be36e65ba', '金鸡镇', NULL, NULL, 2662, 'e509a1a5-95da-4fb2-9a2b-f84afa05a36c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('55391611-7a04-48a4-bd8d-634b3c13b889', '民众镇', NULL, NULL, 2190, 'f2727650-b0d9-4541-acdb-b4eabf894893', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('553ebd67-38a4-4ac9-8594-489953b78911', '铁锋区', NULL, NULL, 2727, 'f4e36f9a-e006-44a6-8d77-47971d41810b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('554d4a33-2281-4218-a9a8-1c13593962cb', '后叶乡', NULL, NULL, 186, '4f867632-2989-4def-9934-a9c5fe0d5ca5', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('55549446-bd56-43a4-9c2d-3aa9c4aa427a', '兴隆镇', NULL, NULL, 923, '88260608-a8b9-4b52-a474-1a551465c675', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('555ac521-adad-4346-99fe-9d76fe39283e', '管庄', NULL, NULL, 1696, '576c43af-0a86-47d9-83a7-4989ce3b3dc7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5563f8c4-b85b-4294-8634-a83fa1c61939', '南新农场', NULL, NULL, 3064, 'e60d3fe5-6d26-4a3f-b920-8fb6c4986bfb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5587693f-1d3a-4282-b48f-13b302d9f0ff', '米林县', NULL, NULL, 2579, '23ca0ede-0d68-4451-afde-afd774149ec4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5593d58f-cd1f-4639-bb8e-156d0d896431', '铁山镇', NULL, NULL, 1656, 'a560b8db-8db1-4bc8-bb6b-fbbecebcaf10', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('55ab5669-bf58-4cbe-bc7c-674faae569e7', '月浦镇', NULL, NULL, 766, 'c470aa47-a334-4df9-a8ea-b90683ddc861', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('55b01e0d-7bbb-4583-93fc-597661896772', '港北区', NULL, NULL, 3018, 'eb4d8886-4710-4809-8f77-b3caa4b4904e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('55c04bf3-a870-4db4-a948-2da0c15025a5', '桐庐县', NULL, NULL, 2316, 'f530455e-1c70-47dd-9a80-4bc74a4e2680', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('55c4c6a0-7458-4d86-87cc-68cc05de39c4', '六塘乡', NULL, NULL, 815, '0f559985-f6fe-4a8f-af80-3d0d64932dbc', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('55d8829f-8fd7-4188-8677-49dd81d8e2c1', '无棣县', NULL, NULL, 304, 'be93aa9b-d81f-4e98-a0c0-18f840594a05', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('55f31cc1-8845-4ee2-b3b2-9f563ce0e0a8', '澧县', NULL, NULL, 4306, 'dd99fcda-6192-4ada-bef5-b04735e7dae8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('55f6a8dc-cbfc-46ae-998a-5ddbc47316d0', '盐湖区', NULL, NULL, 4102, 'fc30b5e5-3005-4778-94f7-706b31514bff', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('55fd6633-0884-4b2d-a367-d3ad1486c2b6', '庐阳区', NULL, NULL, 151, '6ab7dc5a-1064-4090-a81b-79c3a2e8302d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('55ffbee7-14ed-46ce-a255-56133d3fbcbc', '龙潭镇', NULL, NULL, 1118, '72d4f69f-2e4c-4bde-9df8-2aadc9168686', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('56032702-6333-42d3-858e-72df63c5be03', '从化区', NULL, NULL, 1991, '926eaeaf-e8c5-47f2-89ff-6932b52c87d3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('561f35e4-f77c-46b6-a3ab-7286e226aea6', '宜君县', NULL, NULL, 913, '667720b0-8429-42ef-b6a6-582df9b59468', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('56350c11-8e02-42ac-8844-ebc9be75a274', '大安镇', NULL, NULL, 402, '9d7d52af-ec34-48e3-b81d-09ac51e11590', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('563a8804-0043-4e6e-8bb1-afe38039d865', '交城县', NULL, NULL, 3417, '9348509b-6d82-47e7-86d7-f054fb47b7fe', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('563b5c0b-fd9d-4626-81ef-293ab5226884', '云阳镇', NULL, NULL, 163, '4f867632-2989-4def-9934-a9c5fe0d5ca5', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('565d9067-72dd-4b0b-b5cc-625ca04fbff0', '宣桥镇', NULL, NULL, 2638, '4683d3ef-0edf-425a-98d5-2cb231a7d88a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('567730dd-0e21-4b0a-9058-8ebbdf8a4ef9', '独山子区', NULL, NULL, 1433, '24925ffc-d2fd-4b44-823a-250fcc224503', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('56794021-4287-437b-820c-1012f16545f8', '鸡冠石镇', NULL, NULL, 2260, 'd17f8f8e-b3dd-4818-a89d-8b431ff5c555', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('567a3e8d-3763-4b88-90be-e4e21cf80ded', '龙潭区', NULL, NULL, 1947, 'a4031322-7fba-466a-ba72-50082ab248c6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('567eeb2c-b14e-4a32-9e83-0f79c7f874de', '蓝山县', NULL, NULL, 1735, 'c7d6739c-4d7d-4d8f-bf6e-d6a6a7d38f20', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('568b02c9-8fd4-40b9-bbea-b5c4344fcacf', '南乐县', NULL, NULL, 1257, 'e16eafe9-9ca0-4609-8c8c-a1b16b52669f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5690cd50-557f-4625-8283-d9202e93bace', '双江县', NULL, NULL, 512, '88546360-1a0c-4407-9b25-2cde1db643ee', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('56a2731a-9b38-41fc-875c-c4f1b0d10f9b', '长岭县', NULL, NULL, 4441, 'a632ea02-ee66-43f0-b946-2bce0ba5396a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('56aa95ec-7f98-471c-87ac-f161edabfaa0', '龙角镇', NULL, NULL, 172, '4f867632-2989-4def-9934-a9c5fe0d5ca5', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('56b4ca7e-40c3-4392-a8fa-03a02266971f', '印江土家族苗族自治县', NULL, NULL, 2877, 'dce7fe20-4766-408d-92be-62ba8fbb7a43',
        1, 'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('56bc4c47-91e0-4dd0-aa9e-d24750cad05a', '长乐市', NULL, NULL, 4249, '71a49c5c-c3c2-4fcb-8f90-aa1d733a19f7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('56bdc1c5-9327-4893-990c-dd314473ff9b', '头屯河区', NULL, NULL, 3230, '8349c2b0-91a2-4e19-b9c7-81b5224fbabe', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('56cb5b41-9cdc-4285-8855-73607765a2ad', '钟祥市', NULL, NULL, 775, '060b2327-c9b1-47ef-a56a-d280d1a4297d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('56d1c302-28ea-414b-8864-e13a35481757', '赉县', NULL, NULL, 3101, '7af2dfc0-6d0b-4da1-a6c9-fa505dbc6e9b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('56ea00b7-41b9-4346-b2c0-3a3dbf0cddbe', '国梁镇', NULL, NULL, 1651, 'a560b8db-8db1-4bc8-bb6b-fbbecebcaf10', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('56f3f609-f342-4687-be75-93816bd4a12d', '龙岗区', NULL, NULL, 676, 'fd718129-208d-4a94-9e52-7516af8ef013', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('570d284b-e7c3-4ab4-ae95-35eb96ced4b2', '培石乡', NULL, NULL, 383, '76dd00a1-30a1-4226-ae06-cad845c0528c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('571a5bc7-097f-4298-b771-8d1bcdf5c3d3', '栾川县', NULL, NULL, 1177, 'b5a118ad-786c-4d86-b4e8-5d25a3776a78', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('57239132-1573-43fa-91da-b6e3ed567757', '一环到二环', NULL, NULL, 2909, '0687423f-e02f-4a66-92aa-f508821059ee', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('573db476-68c8-4a87-9a1a-a6318c893c32', '临颍县', NULL, NULL, 4131, '55b0b2d6-58e4-40a1-b278-e63aa372ba29', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('574482e6-283f-44ff-b32b-dc49a61b7b94', '芷江县', NULL, NULL, 2024, 'd133a3fc-3db0-426f-8a04-e25b44a5565c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('576f7dbd-2823-4959-b923-18fd81bc9486', '如皋市', NULL, NULL, 1749, '7de09763-759b-437b-a3aa-4cb32bd3c6b9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('57928f84-0e54-4274-aac5-063c6e2a083b', '福田镇', NULL, NULL, 364, '76dd00a1-30a1-4226-ae06-cad845c0528c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('57c1d132-e172-4240-ba45-877a4dce8388', '额尔古纳市', NULL, NULL, 1063, 'c31a65eb-4d77-4b38-8142-9c9e2f54ed46', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('57e1ae97-4ee1-4f6f-a870-21ab9c9dbc13', '潭柘寺镇', NULL, NULL, 3573, '5d21af6a-f035-42f4-a0cf-ff1fd3d36f3b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('57f443dd-0c9a-46ad-b22a-1138a1edc536', '巷口镇', NULL, NULL, 4445, '4888e1e9-ba45-4254-83e7-87796f338e2d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('57f797c2-5c33-4435-b5cc-ebb843fcffdc', '龙山区', NULL, NULL, 1, '7845d9d9-ca44-43a0-93d5-602fdb04ef55', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('58012c85-fe5c-4e71-92be-42439bbd4052', '红毛镇', NULL, NULL, 2287, 'b3792f06-9c78-446e-b6ac-d95d5e9092e8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5824ac93-9a8b-4422-9587-9235bf75331f', '老城镇', NULL, NULL, 4083, '5d3b3a34-50c8-4a01-83b7-e3e068d5c9a7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('582b0267-5743-41bf-8f25-a36c7f955b2a', '玉溪镇', NULL, NULL, 573, '8ae99c85-66b1-406b-8084-9f77cbf73b10', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('582e22dc-1ecf-4925-bbe2-bb552cde2922', '临猗县', NULL, NULL, 4112, 'fc30b5e5-3005-4778-94f7-706b31514bff', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5842cb76-d503-437a-9729-b169e11f35c9', '昌吉市', NULL, NULL, 1271, '8db1e665-1af9-4697-8514-7fa18e3a8683', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('584d0609-d356-41cb-a9e2-882c16517737', '兰英乡', NULL, NULL, 1588, 'ac0e6e50-b6a1-457c-811c-06ac309cd5a3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('585fc9fc-40e1-4117-88f5-535ba03d7a79', '太和乡', NULL, NULL, 1104, '79482cd9-7d51-4c89-94c2-4bcd773b8323', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('586a4b0f-2feb-4ebe-a909-0c7a1e8df530', '坪坝镇', NULL, NULL, 2385, '0275a9ca-e89b-4217-b3b0-ada824d9e095', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5890c952-624f-47e1-9a1f-a2b64285a9c7', '广丰县', NULL, NULL, 494, '8bf55045-9366-4acb-b884-bca672ff9644', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('58a5bc72-b384-4477-b8cd-00fbfc05ab7b', '建邺区', NULL, NULL, 1866, 'adb7aa6e-99a6-453f-a2db-21ecfbc44874', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('58a7f4da-0d33-4c85-8a88-f34268768df0', '西工区', NULL, NULL, 1168, 'b5a118ad-786c-4d86-b4e8-5d25a3776a78', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('58c202ad-43ba-47ca-8848-c4ef5d4aef63', '新妙镇', NULL, NULL, 1124, '72d4f69f-2e4c-4bde-9df8-2aadc9168686', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('58c5235d-d9fa-41e6-b421-7f279c808ab3', '桥东区', NULL, NULL, 146, '37614653-bf6c-458f-a844-540790491eb1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('58d3de16-9da1-48ff-8195-765345e59338', '余杭区', NULL, NULL, 2311, 'f530455e-1c70-47dd-9a80-4bc74a4e2680', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('58dd20b9-6e91-44cd-bd54-f9feaa50df52', '梅陇镇', NULL, NULL, 4023, 'f6eb800d-2093-4ce2-8105-3747d69abe97', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('58ebefde-25e9-46d0-9002-bf7b5c19783d', '长城区', NULL, NULL, 244, 'eff5ed18-ee14-4201-876c-3c40dd858438', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('58fee18e-9898-40fc-b992-78ee48c14778', '干驿镇', NULL, NULL, 2152, '671275c4-6107-4968-bd8e-96d53e9995b2', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('59083cba-c80c-4aab-8d42-9109667c1fce', '汉沽区街里、汉沽开发区', NULL, NULL, 4255, '7932fd13-00db-4934-bfc2-79c835527339',
        1, 'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('590d22ef-9f54-4f68-8a0b-f41d3a59cf40', '惠水县', NULL, NULL, 3485, 'ef4b5cd7-d6b5-4839-9963-c010487ba475', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('590e57fc-90d7-49d2-999d-ce75597bef41', '沧浪区', NULL, NULL, 615, '278acb58-4d2d-40cb-a572-1fc7fb979c77', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('59116ec0-900a-43fe-a1f8-bd4f1a528a79', '平利县', NULL, NULL, 2980, '55fbb0a6-5436-4d04-9f29-716233f81fd7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5913bcd2-940a-411b-9fd5-751e19935634', '根河市', NULL, NULL, 1062, 'c31a65eb-4d77-4b38-8142-9c9e2f54ed46', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('591dba0b-5c0d-45d9-987b-75dd105fd56f', '武乡县', NULL, NULL, 3859, '6fc78ef9-e2eb-46bc-bf8e-8b830ad96136', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5942dc11-5ad9-4ff6-842e-276ed3264b6e', '孝南区', NULL, NULL, 2756, 'caa97f6a-9b5e-4871-968e-42852537e6f0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5946d6bc-63fb-45a6-8b95-82931e2adb0e', '赤壁市', NULL, NULL, 951, '7a5b4813-b095-4a1a-a008-1297fd9aa978', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('594a82c4-01df-4e0e-b8bf-a33e76505b25', '靖西县', NULL, NULL, 1225, 'f56fa64d-ca06-49d2-a9cb-94742a33af21', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('594e5640-9569-4f6b-a279-326eedf9484a', '全境', NULL, NULL, 1945, '99071178-910e-48e6-a6ac-6ddd867677bb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('594e79aa-c0f0-4306-8db1-ab4a54bfced5', '廉江市', NULL, NULL, 2598, '5c5b11a0-6a29-4173-b876-8fdbc543cb2b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('595b64bd-f19d-4b16-9ab9-7a8b7281655c', '武都区', NULL, NULL, 1370, '7c9ca39d-ce8f-469d-899a-09a0a29c1541', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('59658040-ed45-4c53-91d6-2fe9ade02760', '永德县', NULL, NULL, 518, '88546360-1a0c-4407-9b25-2cde1db643ee', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5966702d-b3ce-481e-8ec7-854bd58338e2', '闽侯县', NULL, NULL, 4248, '71a49c5c-c3c2-4fcb-8f90-aa1d733a19f7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5972fb8a-6255-4f67-8891-34649bcd6828', '义和镇', NULL, NULL, 1125, '72d4f69f-2e4c-4bde-9df8-2aadc9168686', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('59d021a7-4bdc-4330-a35b-b8044060dcfa', '乾安县', NULL, NULL, 4440, 'a632ea02-ee66-43f0-b946-2bce0ba5396a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('59d55e64-1082-4de8-982b-c51886c0924b', '明山区', NULL, NULL, 1550, '7becad81-2a66-497c-9c70-276a85718c91', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('59db9901-9ca4-4e45-a800-21e3e186ac78', '寿桥乡', NULL, NULL, 576, '8ae99c85-66b1-406b-8084-9f77cbf73b10', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5a181219-e96c-4c85-adce-1ad9dfeee55e', '宜秀区', NULL, NULL, 3588, '818f3bc6-83b9-4d90-8e68-566cc7c2bb14', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5a30b224-cac9-47f0-a1b9-c7bdaa1c5ebc', '谭家乡', NULL, NULL, 3273, 'a39ced08-b6e9-4de0-a2db-7a230a673d1e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5a367f05-b27c-4ea9-9f45-43e94405bf31', '高新技术开发区', NULL, NULL, 160, '6ab7dc5a-1064-4090-a81b-79c3a2e8302d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5a37a962-959d-4a3c-88f4-c10962e62eb2', '广安区', NULL, NULL, 3295, '4bb2fe40-7307-498b-802c-e85e937f95e0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5a37c6cb-aa1d-4fe0-a6a4-9dd89b114ced', '阿巴嘎旗', NULL, NULL, 2343, '67723aea-a4ef-4eb7-afbf-55cc07806f98', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5a77abfb-3285-4965-957a-7f75c24f2355', '黄骅市', NULL, NULL, 2901, 'a3c44525-9ccb-429d-a2b7-f5f5d52b8a6d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5a96230d-993e-4e8d-9b8b-a8c082afa8b3', '姜堰区', NULL, NULL, 2232, '0541b99e-02a6-415b-8282-4ef9d27cb647', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5a9f480d-b90d-47e1-a050-c72ea4bb4c86', '复兴镇', NULL, NULL, 2658, 'e509a1a5-95da-4fb2-9a2b-f84afa05a36c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5aa3aa8d-f8eb-4c09-8d42-d23547ba6134', '云安镇', NULL, NULL, 184, '4f867632-2989-4def-9934-a9c5fe0d5ca5', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5ad6f19e-742b-443c-8dd9-817d75ad7b60', '吐祥镇', NULL, NULL, 1090, '79482cd9-7d51-4c89-94c2-4bcd773b8323', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5ada55a4-2df6-483a-9a9d-71743cdb992f', '龙池镇', NULL, NULL, 971, 'cc124ed6-091a-42ce-a87a-bb4d0d7357b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5aef1674-86e5-435f-8068-f11413bf102b', '西庆农场', NULL, NULL, 3223, '2e21ea75-c640-4928-8cb4-e5ba4f6e2ffe', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5afff3ef-5e73-454e-9539-872833ddfe52', '聚奎镇', NULL, NULL, 649, 'd7f44c2a-2728-4633-a8b6-7643136bc99d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5b05c559-382f-4b69-9650-3802a17c91dc', '乔梓乡', NULL, NULL, 1898, '2c8bc8c3-9317-4f36-a0ad-05a8d6b27053', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5b1109f8-e8f2-4ed1-8d65-1bc28cc581ca', '嘉陵区', NULL, NULL, 1249, '71643995-698f-4bdf-afe9-09fce8a065c0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5b311230-fd6c-4003-8640-9107022d3ea3', '三才镇', NULL, NULL, 546, 'b75db043-9782-4bae-aaee-bea49fc286e6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5b3c7866-f80f-4433-9a95-45a67a3919eb', '袁州区', NULL, NULL, 4063, 'fa27d3fb-a80f-4b4c-8d0c-bf7d544bb974', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5b7132b8-5c62-4e03-bae0-44d05a3be266', '高港区', NULL, NULL, 2228, '0541b99e-02a6-415b-8282-4ef9d27cb647', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5b878e06-fe17-4978-b733-5ed2b4dcbd22', '洪洞县', NULL, NULL, 3706, '1aeeea9e-d028-4a96-94ce-ba84cdd3e69f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5bb5e409-4851-48c5-a4bd-f456d297a264', '武进区', NULL, NULL, 4004, '4a5fccf3-5d70-4b0b-85ef-c2a8e5fdfadc', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5bbc6ce9-c43d-4138-a529-67d952f9ee5d', '海南矿业公司', NULL, NULL, 788, 'af6f4f65-b2db-4670-88ca-21de1de477fc', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5bc7afc0-ba58-4382-8efc-472b9e56973a', '中原镇', NULL, NULL, 1449, '81aab36f-0e28-4ba3-9827-b7033fce9b24', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5bcaf24c-8ff4-4f26-b9f8-62ae307e3e77', '罗城县', NULL, NULL, 1166, '509d3498-d5ba-4378-8bee-0baf015c2a11', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5be561df-33e1-4918-b92e-b0a1429d9464', '黎母山镇', NULL, NULL, 2284, 'b3792f06-9c78-446e-b6ac-d95d5e9092e8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5c12eb9d-3670-488b-8cef-35343a8fb6fc', '次渠镇', NULL, NULL, 2134, '88d84710-80d6-4837-b889-286c74d7940d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5c39a2d1-c666-4346-9d5d-0c13757e22a6', '含山县', NULL, NULL, 3456, 'a77a0530-087f-4dab-84ab-e8a9690de27f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5c3f5e42-c202-4649-b8e7-1fe2413a4a59', '乌烈镇', NULL, NULL, 783, 'af6f4f65-b2db-4670-88ca-21de1de477fc', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5c5014a0-d894-4719-b167-947a7412940d', '来凤镇', NULL, NULL, 3592, '27289f06-ca7a-4916-8f25-f6b13d8687ec', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5c5240c7-028c-407e-93bc-5f5ba673df81', '恩施市', NULL, NULL, 2352, 'ecba10ba-2c25-4ead-a781-ad16a832226f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5c553c24-0963-4ee1-a91f-622041707a02', '威远县', NULL, NULL, 1996, '7e24b0e5-bf57-4e62-880a-e5b6ec159053', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5c623ee7-eb56-4dcc-9d11-edf75b0ea696', '利川市', NULL, NULL, 2353, 'ecba10ba-2c25-4ead-a781-ad16a832226f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5c680bdd-c937-4d4f-b8cb-76123614ad8d', '黄山区', NULL, NULL, 4279, 'e3fa5765-1e86-4f89-a751-2f63dbe81c99', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5c737cc6-774f-48ea-94ed-f113c0f7e800', '汨罗市', NULL, NULL, 2269, '8369850a-f796-470f-902f-393cfb615571', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5c9c399e-a14d-4110-8b5e-f87ca5472c33', '左云县', NULL, NULL, 1959, 'c8df6064-e107-46b5-b861-acd5b509b146', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5cab3c6e-8a70-4fca-94d6-5d6c75ad69f6', '淮阳县', NULL, NULL, 2295, 'f3e12d68-f8c5-4d9d-8314-dd1ce7dac2f9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5cbe8541-ef71-4ad5-afaa-15af906df075', '鼓楼区', NULL, NULL, 4180, 'fb0dbd60-1d03-4394-a890-ffc2d3ec6a37', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5cd3911a-345c-4bda-a6b4-31f27f51efbf', '治多县', NULL, NULL, 2074, '27eaf8ae-634a-45eb-bdc9-207c699d16ef', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5cd749f6-28bb-4b38-a6e4-794ff9ef0f5c', '肃南县', NULL, NULL, 691, 'dcdb1184-ab1f-4332-8ca0-f4edfd7cc087', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5cff4811-7105-4386-b88d-578fb897f703', '六合区', NULL, NULL, 1870, 'adb7aa6e-99a6-453f-a2db-21ecfbc44874', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5d22ae75-2778-40bb-9fe7-badac0d8d4bf', '上坝乡', NULL, NULL, 194, '4f867632-2989-4def-9934-a9c5fe0d5ca5', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5d242f45-237e-40e3-9747-b16650d88b9a', '永乐店镇', NULL, NULL, 2130, '88d84710-80d6-4837-b889-286c74d7940d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5d27ba12-6a03-4e15-a93c-2a2af7c87a49', '新村乡', NULL, NULL, 3995, 'fcc07455-c69c-4c90-82cb-ddb268adb8a9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5d3da869-e25c-4d67-b392-e06441373a5b', '海棠镇', NULL, NULL, 2085, '4686b935-e3f0-4173-bdfe-ab6a5450d1a8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5d46f615-a947-4aeb-a347-c713191cc0b1', '下谷坪乡', NULL, NULL, 3076, '4b20c67b-06ca-4c0b-a947-bc518238537e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5d5c4dee-76a4-4d21-8650-9ad9eca14b46', '沧源县', NULL, NULL, 513, '88546360-1a0c-4407-9b25-2cde1db643ee', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5d74fea2-fac6-4f5d-881c-f27615704da4', '双泉乡', NULL, NULL, 2942, '465e9ea2-a2f2-4b42-95dd-b48d91f67105', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5d9868b3-9116-497b-b16e-61382dbaa083', '双台子区', NULL, NULL, 2001, '9d95b0ef-0bbc-404d-80d4-2143f433a4c2', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5d9cab29-84bd-4eca-ad6d-432e4f9e0242', '城区', NULL, NULL, 3237, '42cd885b-80a2-4098-bd35-be2e606f9ab1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5dc53bb5-9681-4126-815e-03e2402c5a07', '仁和地区', NULL, NULL, 3736, 'd1c1539c-b904-4bcc-a034-96213f63d0ff', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5dc8ca74-dad2-4afd-82b2-62aa03aa0b8d', '宁洱县', NULL, NULL, 1705, 'db61cc5b-b13b-417f-a232-7925ffdfa9b2', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5de39068-3b2d-4bd4-a158-8d1a02f91693', '石堤镇', NULL, NULL, 975, 'cc124ed6-091a-42ce-a87a-bb4d0d7357b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5de5f7c6-3036-4c34-8b82-a474cee557de', '铜鼓乡', NULL, NULL, 2944, '465e9ea2-a2f2-4b42-95dd-b48d91f67105', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5decdacb-9a2a-4716-b436-3ee75d1c6cf9', '南翔镇', NULL, NULL, 1318, '99c50aa3-ab40-4b1e-addd-f68662f3c560', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5dff466a-d63b-4810-a9d6-6efdf1e8b66d', '柏林镇', NULL, NULL, 892, '41f376c0-764f-46b9-af35-e555518fc613', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5e19ab26-d623-494c-a972-2576dcec8479', '南阳镇', NULL, NULL, 3814, '96fec37f-11d5-4d41-aba4-a36d0652744c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5e250f12-cf30-4544-8929-6a8044b75cde', '浦江县', NULL, NULL, 1813, '4f073365-4e02-459f-8b32-cad88dd22637', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5e2bfbfe-f478-4ef0-9565-4083d9c615dd', '白塔区', NULL, NULL, 4160, 'f856399f-e403-4734-abb9-b972db76c06b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5e355c83-70ef-45d8-be81-3533be991509', '望花区', NULL, NULL, 1376, '6b5fed36-b200-40ca-af0b-11999b4399ef', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5e4790dd-c89f-42b0-9316-c877ef28ea87', '大路镇', NULL, NULL, 3594, '27289f06-ca7a-4916-8f25-f6b13d8687ec', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5e58802d-0607-4027-bf34-0cde265c0703', '城区', NULL, NULL, 130, '6f153ca7-c91a-454a-809f-ebbc09e9f091', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5e706313-312b-411c-8722-7fdbbfa0a443', '疏附县', NULL, NULL, 2038, 'e6436d79-8045-4185-b2b2-22cd280d22b0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5e7cd19f-5c1d-4aa2-839e-ce5f1e07add5', '景东县', NULL, NULL, 1706, 'db61cc5b-b13b-417f-a232-7925ffdfa9b2', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5eb2612b-f27c-442c-835d-6048b23d155b', '高坪区', NULL, NULL, 1248, '71643995-698f-4bdf-afe9-09fce8a065c0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5eb38b23-2a4b-45c4-811d-3dcfefea1ea2', '南天湖镇', NULL, NULL, 1915, '442f465d-6566-45e4-9338-50f4395aa6f7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5eb607a4-90cd-4068-8f55-4134ce4826b1', '大名县', NULL, NULL, 216, '237eff18-fe6c-4842-afb1-acb05027a5c1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5eb75b89-fefd-4569-8d69-c91f12783cde', '建阳市', NULL, NULL, 3445, 'dd15d032-477c-4f54-9629-ea782606b468', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5eceb1ce-3507-4a35-8d97-89792a8e532e', '隰县', NULL, NULL, 3701, '1aeeea9e-d028-4a96-94ce-ba84cdd3e69f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5ed3b262-cf3f-4826-b848-bf7acf96a61c', '叶榭镇', NULL, NULL, 95, '3e082d1b-ecb4-4bf8-8715-54132a9106e1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5edddab3-b178-4d86-ac5e-ca3db18b340e', '坡头镇', NULL, NULL, 3925, '22f622f8-7eaf-41e9-90ee-2a0cfda1f326', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5edf252e-a11c-45e1-8e81-f2483784d79c', '石宝镇', NULL, NULL, 2667, 'e509a1a5-95da-4fb2-9a2b-f84afa05a36c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5ee4ab99-b3c9-44d9-87b6-485ece4500d5', '秦都区', NULL, NULL, 2101, 'e42fbad8-c29e-4f35-878d-95a667b5cc90', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5eecf340-cf9e-443b-a56e-195fc6fb12ea', '灵山县', NULL, NULL, 3422, 'd6095cf5-28d0-419b-a799-9a3c87594720', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5eee9b17-539c-4138-867b-3960a6bd7acb', '东泉镇', NULL, NULL, 45, '43c813e3-8672-45c5-8d3e-9ee43dbe51c8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5ef3b67c-cacb-4de3-b60e-4499925b3d9d', '莺歌海镇', NULL, NULL, 2561, 'a1e3332c-7029-4de7-a221-40c041a9a620', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5efb7e57-6ccc-4c58-aa80-0f737ce74843', '蛟河市', NULL, NULL, 1952, 'a4031322-7fba-466a-ba72-50082ab248c6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5f0cf915-2113-4e5d-b59b-d80a4b7a19cf', '彬村山华侨农场', NULL, NULL, 1462, '81aab36f-0e28-4ba3-9827-b7033fce9b24', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5f18a9e8-09ba-473e-89fc-764d8085cec3', '后山镇', NULL, NULL, 4209, '0ee28cef-8dfc-4a9f-b7c1-330bc11c1bb3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5f444f61-37cb-411d-a863-006371d38e01', '仁义镇', NULL, NULL, 2508, 'd998f8bc-c659-47ce-8e5e-a6b29e03ecb3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5f6052c3-6403-4bf7-b6fe-02b1f9658954', '金龙镇', NULL, NULL, 409, '9d7d52af-ec34-48e3-b81d-09ac51e11590', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5f7595f6-031b-4db6-9806-eb958586feec', '台江县', NULL, NULL, 3083, '6d3a8433-1273-4323-a3eb-d39effecc1d7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5f9c9f15-10ff-4a92-b544-b3e25148f4f7', '正兴镇', NULL, NULL, 3600, '27289f06-ca7a-4916-8f25-f6b13d8687ec', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5fb24cc7-0003-445f-be83-f4330a667a2e', '宿豫区', NULL, NULL, 4190, '2263db14-1626-4430-a8ea-bc9c02268004', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5fb7b5dd-db91-49f0-ad52-ab27ef082e9d', '蒙阴县', NULL, NULL, 4345, '56327d0b-ec26-4f34-8ab6-0eba49931c67', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5fc0ff90-7fa4-4743-9b8a-70675e836fd3', '红星区', NULL, NULL, 469, '7ca3412f-b06b-467e-b547-691ab8327b15', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5fc76dd4-a41c-4912-96c4-73cf6dd941d9', '龙井市', NULL, NULL, 1054, '87e1c9be-7455-45a9-ace5-641efce55e22', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5fee884f-879e-445c-9578-9656b1bebe57', '文峰镇', NULL, NULL, 1581, 'ac0e6e50-b6a1-457c-811c-06ac309cd5a3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('5ffbe542-c044-4bae-807a-ba5b1b8dbeae', '博兴县', NULL, NULL, 302, 'be93aa9b-d81f-4e98-a0c0-18f840594a05', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('60045396-34e2-4916-93dc-94a6fc55d927', '河图乡', NULL, NULL, 929, '88260608-a8b9-4b52-a474-1a551465c675', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('60101d82-fc20-4d26-9160-95265cd38548', '孝溪乡', NULL, NULL, 991, 'cc124ed6-091a-42ce-a87a-bb4d0d7357b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('601c6a40-0e45-4969-bfc8-c9829d03ddc2', '扎囊县', NULL, NULL, 1013, 'f7038861-43d2-49c3-a5c9-53fde2c139fa', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('60317582-d0bd-476c-aef1-db1d1f17b74e', '合兴镇', NULL, NULL, 644, 'd7f44c2a-2728-4633-a8b6-7643136bc99d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6034128d-81ca-4c7c-b711-fd3781d1e12b', '响水镇', NULL, NULL, 4219, '0ee28cef-8dfc-4a9f-b7c1-330bc11c1bb3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6048188e-8d59-44de-8060-b32335609fc9', '陈食镇', NULL, NULL, 403, '9d7d52af-ec34-48e3-b81d-09ac51e11590', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('607273a5-394d-4b62-bd8f-db97e50f3e82', '树人镇', NULL, NULL, 1927, '442f465d-6566-45e4-9338-50f4395aa6f7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('609d3339-725b-4a65-bcf2-032567a2f0d9', '和平区', NULL, NULL, 1849, '271a8d5d-a9a3-4876-a9a2-ca9bcee4b83f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('60a1925b-c815-418f-9ea4-bb5b84a54925', '福果镇', NULL, NULL, 3832, 'c33c3107-81df-4ced-8b92-d694df412da3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('60f35532-7132-4460-b687-96219533305a', '额济纳旗', NULL, NULL, 1695, 'fe94b712-ef16-4435-a491-7601776344cf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('610235f4-4846-43c6-a727-91dd4cce2198', '官舟乡', NULL, NULL, 984, 'cc124ed6-091a-42ce-a87a-bb4d0d7357b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('61024e63-d19b-469c-aee6-ddc6d7feca0c', '盐池县', NULL, NULL, 605, '9d872dc5-ad1a-4b3c-86de-debd1a77eb8c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('61026a62-7586-4bba-81f1-b8e49c340fff', '巧家县', NULL, NULL, 3690, '31187fc0-8d6e-45f3-9653-b7ce4227ef1d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('612d2f28-0c3c-44e5-8035-c2b9ac0cbc4f', '全境', NULL, NULL, 847, 'f476b47a-b7f5-4632-8219-13b93e018735', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('61392c7e-1ae1-4aef-a538-f0bbb4496efd', '莲花县', NULL, NULL, 1152, '20c4f23e-77e7-4763-9ba8-dd00d5216748', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('614e29c2-7d6b-4001-a812-4cb1ae8e2a03', '福海县', NULL, NULL, 3527, '2ca5ebc8-b3f5-49d8-b421-85ae2dc0de35', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('61529ccf-ba43-4db3-8a4c-816c3d498541', '义乌市', NULL, NULL, 229, '1721f4b0-56cf-4408-a217-62416951c176', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6157cb8d-fd4f-45d6-8e4b-3c4581f9e8fd', '金带镇', NULL, NULL, 648, 'd7f44c2a-2728-4633-a8b6-7643136bc99d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6171ca2a-f93d-4a5e-9922-5c78a94e9c36', '黎川县', NULL, NULL, 3956, '1e0a806c-ad0b-4e9f-a488-8bf9fc903f4d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6185332f-14a4-4a42-9741-fa331c9c7ed5', '渠口镇', NULL, NULL, 3256, 'a39ced08-b6e9-4de0-a2db-7a230a673d1e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6198158e-d8a6-4d01-922d-288f3b77fe80', '解放区', NULL, NULL, 4016, 'e95972c4-fd28-45ac-b9da-9aee0057d3d0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('619ad1a1-bd82-4aa5-b0fc-abe2a1fffd0e', '丰泽区', NULL, NULL, 1862, '0d3bd52a-74b2-4461-9a57-17c7cce4ac1b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('619b3bb4-95ea-410b-a156-a5da792153c2', '龙湖区', NULL, NULL, 1439, '8596baaf-4bfe-4522-a422-f397f3494bcb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('61a747f8-6e08-4a31-92f7-16a16a3e1950', '金声乡', NULL, NULL, 2675, 'e509a1a5-95da-4fb2-9a2b-f84afa05a36c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('61cf58fb-848f-44e1-b2ec-de5b57110905', '罗山县', NULL, NULL, 3499, '976170b4-d0f7-4fd9-82ed-6e336c9bf3c0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('61dbbd22-e1fa-48db-9b15-8f7ce375352e', '海洋乡', NULL, NULL, 985, 'cc124ed6-091a-42ce-a87a-bb4d0d7357b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('61de037c-cb93-4774-aa24-8beabcc73d95', '雁峰区', NULL, NULL, 4260, '75dd761e-ce3f-45bb-a86b-d3a1e2c7629a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('61e7adcf-301e-4b85-ab85-b35c6bc31ebf', '绥芬河市', NULL, NULL, 1970, '1c2bd9d2-bc08-486e-a5f3-ba5de82c6365', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('61f8c598-d2df-4306-88f3-eef59f5e23c8', '贵池区', NULL, NULL, 2044, '7294fb6c-cbd8-49b7-ad18-f285bc43f1d9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('61fd5096-545a-4e57-abce-06d7234d5c38', '莱城区', NULL, NULL, 1773, '6e4850af-4247-4791-b0c5-d6d55ebc74b2', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('62054e84-461f-4665-a22a-3d6d544452ab', '九龙城区', NULL, NULL, 475, 'dfb8b556-10a2-43ab-9fdb-66cde92320ee', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6228208f-d4df-4c57-9682-c8ea1bbb710d', '洛宁县', NULL, NULL, 1175, 'b5a118ad-786c-4d86-b4e8-5d25a3776a78', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('62369d1e-c305-40c4-b25a-3b9989f9b206', '龙兴镇', NULL, NULL, 709, '97942649-3cc7-4e4a-81b4-9a8c82f82ea7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('62447234-cf2c-42c1-a09b-4095d1108941', '航头镇', NULL, NULL, 2644, '4683d3ef-0edf-425a-98d5-2cb231a7d88a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6259024c-c050-4704-895f-bfe936cafc33', '蒙自市', NULL, NULL, 3154, '99a9abd1-f107-4dc6-ae43-e9d1120504b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('62657990-2db0-4d16-8bb6-21dc7d213b51', '大通区', NULL, NULL, 2960, '69508f5e-7304-4092-95a4-73d6a9b68eff', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6271ec97-82e1-40f8-a87f-e17613617c89', '溪口乡', NULL, NULL, 4233, '0ee28cef-8dfc-4a9f-b7c1-330bc11c1bb3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('628c5636-4e24-49e2-8349-b6008fa72234', '漾濞县', NULL, NULL, 241, 'feece7c8-8eeb-494a-8e84-571b6ebcf0d9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('628d6a79-f2ac-4cbc-9ce6-f7aeb4a69b1e', '榆次区', NULL, NULL, 530, '84a16421-f7fb-4f99-b2c0-1e0dea97bf0b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('62c18568-5e34-422f-b0d5-52f29a72fdd5', '台儿庄区', NULL, NULL, 1413, '8e4df698-c772-488a-acf8-70e7d4adebd2', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('62c97968-7160-4a50-8f4e-da5f948b181a', '城区以外', NULL, NULL, 2566, '727ca4ab-f7fc-49fb-9b2b-569d2fc79aa4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('62e75cd2-b25f-49b2-8ef8-c292c6922945', '宾川县', NULL, NULL, 237, 'feece7c8-8eeb-494a-8e84-571b6ebcf0d9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('62ec523b-d7cf-42fa-b7eb-b91c710f5f45', '大祥区', NULL, NULL, 3750, '30ce87bd-09cc-4250-9b5e-1f5916ce4d70', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6304e718-abe0-4976-9881-65a1837239d5', '上栗县', NULL, NULL, 1153, '20c4f23e-77e7-4763-9ba8-dd00d5216748', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('63057083-ba56-45bf-bcb2-0493e9a13d80', '全境', NULL, NULL, 4199, '49c42e59-25a9-4152-b9e4-ebfd45252ef5', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('631c465a-373c-4f7d-9d44-6bb995d936a8', '黄梅县', NULL, NULL, 1002, '63a5fa32-35eb-4eca-ab79-f3887e122564', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('631cb172-e6a5-43c7-af6d-a3436a2d47c9', '雁翅镇', NULL, NULL, 3577, '5d21af6a-f035-42f4-a0cf-ff1fd3d36f3b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('63221aa2-6554-439e-b151-f33d3ee794a2', '香港', NULL, NULL, 490, 'dfb8b556-10a2-43ab-9fdb-66cde92320ee', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6326ab9f-16ef-4274-8c82-5ca70a3c95b9', '新河县', NULL, NULL, 1041, '4d6c5692-82f1-443c-9163-39a3dd77636b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('63335755-e24d-4d5d-a397-8a376153899a', '张山营镇', NULL, NULL, 1508, 'd5ab951d-20ab-46ff-8838-de5efe06b6b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('63364d7b-2096-43f9-805f-9c7566fc6154', '大石镇', NULL, NULL, 3874, 'a732da28-870c-4d9c-a287-c2c1e3222b59', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6339ecf8-f01f-4baa-9599-3a583fd267ce', '台湖镇', NULL, NULL, 2132, '88d84710-80d6-4837-b889-286c74d7940d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6341f43c-b97c-4511-a3ee-147ddfeddb33', '曲水乡', NULL, NULL, 666, 'd7f44c2a-2728-4633-a8b6-7643136bc99d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6345e18b-33ff-4299-8412-4e27532657bf', '郊区', NULL, NULL, 2534, '574f476d-e1ab-4240-a84f-b9671a2cb9cc', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('634bf0d8-939f-4cc6-bca2-1c8751cd9733', '商州区', NULL, NULL, 1387, '332e1b20-ce8a-4065-ab84-b60416060476', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6358d510-2f29-4313-b027-8f018eaad0ed', '麦盖提县', NULL, NULL, 2041, 'e6436d79-8045-4185-b2b2-22cd280d22b0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6358fbca-a653-48e7-81b5-e06a8d841bfc', '邦溪农场', NULL, NULL, 1359, '21bb958f-e5d4-4a71-a350-b5bf2c0e2de0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('636b045a-b00c-4bcc-9028-4d79c77a7bd4', '淇滨区', NULL, NULL, 3437, '2130bd75-b4cf-44af-a13b-2b64109f0cb9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('636f0c23-bd1a-48b8-af19-0c578bfa5fb5', '贡觉县', NULL, NULL, 2690, 'b7342349-941d-427d-9ab6-e83a36078088', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('637b14a8-cb83-4e2b-9f03-ceabc78a66eb', '城阳区', NULL, NULL, 3715, '1e53830d-8cdb-4111-8da6-987131b873ed', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('637c7b82-372a-4d70-b3cb-7c4d9907bc6b', '平昌县', NULL, NULL, 452, '312a1e8d-70a3-4529-bfe8-04a7f21cc881', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('63ac58ea-b278-4b19-bd9e-26fda0972482', '奎屯市', NULL, NULL, 2593, 'e6f53877-d5bf-4b42-aded-5ab8960ef034', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('63bc6ceb-afc8-4b42-ac32-38dad4863e46', '西彭镇', NULL, NULL, 3547, '99107e35-f7d9-4c45-8d21-7a03b9c2f99d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('63d08fdf-5756-40a7-9101-a24b2efb3061', '吉阳镇', NULL, NULL, 3057, 'e60d3fe5-6d26-4a3f-b920-8fb6c4986bfb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('63d2d632-94a2-47e5-abef-d853cf2da24c', '霍林郭勒市', NULL, NULL, 1553, '1dc7d092-717c-424e-a473-bb2cc8836b5e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('63d5a12d-66c4-420b-8a31-7e4be7182170', '古花乡', NULL, NULL, 928, '88260608-a8b9-4b52-a474-1a551465c675', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('63e67d8c-51df-4438-8e35-080acc3351bf', '新县', NULL, NULL, 3497, '976170b4-d0f7-4fd9-82ed-6e336c9bf3c0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('64020759-f98b-4e3b-88d4-a38faf14ea9e', '鱼台县', NULL, NULL, 2825, '5c8748b9-cee3-4d8e-956c-0d0e24db8850', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('640421d7-8d89-4298-b383-814b0d150319', '梨树乡', NULL, NULL, 4239, '0ee28cef-8dfc-4a9f-b7c1-330bc11c1bb3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6414e01a-2c52-46e3-841a-169af3f920fb', '袁驿镇', NULL, NULL, 660, 'd7f44c2a-2728-4633-a8b6-7643136bc99d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('641a5d74-f090-4600-a536-95de915ff601', '平定县', NULL, NULL, 2116, 'c3c4411b-8905-45b4-b38f-09be90102664', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6435629d-6c94-42cb-b635-3578146dbed0', '台安县', NULL, NULL, 2011, '48832e11-ddfb-478a-9787-e46c47346d7e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('644288a5-9c29-4818-b601-efab4861904e', '千家店镇', NULL, NULL, 1510, 'd5ab951d-20ab-46ff-8838-de5efe06b6b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('644882ac-3c76-43f5-b0bd-35485b11d7d7', '肇东市', NULL, NULL, 3555, 'fcd4a18f-a57a-47c4-b2f2-504bc8bccb20', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6466185a-ac99-494f-b7e3-3956e09aea8e', '鱼峰区', NULL, NULL, 2745, '0f2ba543-1d40-4b41-b700-6b53a9622b5b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('646b0ca9-a10c-4664-88a9-da1550e4d0f1', '城区', NULL, NULL, 599, 'e11c17b6-eb2f-4d32-9de9-48ab1440c8c7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('648749a9-157c-4954-aad2-e9356a121ba2', '桥头镇', NULL, NULL, 4091, '5d3b3a34-50c8-4a01-83b7-e3e068d5c9a7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('648908ef-4ccb-4626-9064-2c8c56d0c1d3', '射阳县', NULL, NULL, 4361, 'b85d2a61-b018-431a-9609-2ca0841f5cab', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('64917a06-070c-488e-bd55-07ee08a4ec85', '淞南镇', NULL, NULL, 771, 'c470aa47-a334-4df9-a8ea-b90683ddc861', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6499381c-3d62-49f2-9199-e99ca00bf52f', '白家乡', NULL, NULL, 1490, '89e8be16-b810-4c7e-89f0-aa9f24483b98', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('649d6813-bec8-43f1-8275-ad8b5fe16194', '玛纳斯县', NULL, NULL, 1274, '8db1e665-1af9-4697-8514-7fa18e3a8683', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('64a3a15d-9e0a-4afb-b6b9-e3665bfe3f82', '右玉县', NULL, NULL, 2063, '49bad2d2-0c83-48ed-9985-7a709362f3a8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('64b781e6-6665-4e24-8456-ce9885cd4600', '新华街道', NULL, NULL, 2121, '88d84710-80d6-4837-b889-286c74d7940d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('64c4564c-3cec-4844-a2be-3ffbce4074f3', '澄城县', NULL, NULL, 3168, '9e5ae65c-206f-4d7b-87f2-c252d5f40b52', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('64d6ea64-f75d-4d36-9ce6-452d53b0d5ad', '砚山县', NULL, NULL, 2221, 'fadbb851-aec5-4d3e-be0e-09e7462eaceb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('64e6b9a9-5834-409b-8124-1099daa1c1a0', '平桂管理区', NULL, NULL, 1467, '6f0d2b72-566f-44e5-969d-2d2ce65ace5c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('64ebaacc-991c-4a32-8fad-ad23eede9b37', '米脂县', NULL, NULL, 1301, 'c0c88cbd-87ea-4281-9e8e-94a435ae6590', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6501093e-c2d8-4c6d-b90f-2884b6311694', '平顺县', NULL, NULL, 3855, '6fc78ef9-e2eb-46bc-bf8e-8b830ad96136', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('65220b9d-5f20-447d-b5e1-23000aff8363', '美兰区', NULL, NULL, 2885, 'b899bf86-aa99-4e70-a544-8ebe64da4f24', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6535c460-52d2-43a2-b2f1-d167f8cf1220', '阿拉善左旗', NULL, NULL, 1694, 'fe94b712-ef16-4435-a491-7601776344cf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('654c0053-1140-40cc-ac40-2deda5fc4875', '县城内', NULL, NULL, 557, '8ae99c85-66b1-406b-8084-9f77cbf73b10', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('65660992-b9fe-4050-b516-e3663c5546ba', '统景镇', NULL, NULL, 713, '97942649-3cc7-4e4a-81b4-9a8c82f82ea7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('656b390f-e3d0-46b4-868d-66b2ee6174c6', '沾化县', NULL, NULL, 300, 'be93aa9b-d81f-4e98-a0c0-18f840594a05', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('656b3983-af19-429e-a8c6-85aa0fd6f4d9', '经济技术开发区', NULL, NULL, 159, '6ab7dc5a-1064-4090-a81b-79c3a2e8302d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('656e2e7d-3fdb-4aee-81ad-f8d31f90a176', '胜利街道', NULL, NULL, 3737, 'd1c1539c-b904-4bcc-a034-96213f63d0ff', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6570475e-778a-48a6-a9ce-0dcd46de6cb5', '石碌镇', NULL, NULL, 780, 'af6f4f65-b2db-4670-88ca-21de1de477fc', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('657af2fe-02b7-41a1-80d7-8fbd5caf90c3', '涞源县', NULL, NULL, 2492, '81e22d56-a1c7-4263-be18-81a4af165ae3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6594d9f2-9920-499e-ab62-6cfbc32763a5', '顾村镇', NULL, NULL, 768, 'c470aa47-a334-4df9-a8ea-b90683ddc861', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6595842a-4767-437a-afb8-282dd8c72295', '濠江区', NULL, NULL, 1444, '8596baaf-4bfe-4522-a422-f397f3494bcb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('65a70acd-1d69-4539-8095-cf045a342deb', '介休市', NULL, NULL, 520, '84a16421-f7fb-4f99-b2c0-1e0dea97bf0b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('65ae421f-ff5c-4d77-a1f7-32e58f2db2b8', '周溪乡', NULL, NULL, 2402, '0275a9ca-e89b-4217-b3b0-ada824d9e095', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('65b31df9-4251-46b1-a658-62ae5443c8f4', '潮安县', NULL, NULL, 4386, '08acb8e2-e168-4e7b-81ce-918197cf4ecf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('65c5ea70-17bd-41bc-b045-7e330476ba8c', '唐河县', NULL, NULL, 738, 'a769a530-0bcf-4e52-a9e5-3a8f5af945d2', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('65c868e6-ff1d-4414-a64a-f06bbda80f71', '西河镇', NULL, NULL, 3840, 'c33c3107-81df-4ced-8b92-d694df412da3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('65decaa7-a08e-4e3f-a063-eaa5a1087cc2', '丁山镇', NULL, NULL, 3658, '6581d8db-553e-4417-8c37-91ed47904920', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('66001c69-9c24-456f-a6c6-1080216777ce', '和林镇', NULL, NULL, 645, 'd7f44c2a-2728-4633-a8b6-7643136bc99d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('66010eb8-bb6f-456a-bced-50f4c61143c5', '西华县', NULL, NULL, 2298, 'f3e12d68-f8c5-4d9d-8314-dd1ce7dac2f9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('660195b2-0b60-4d97-be67-dbf0093b7e5c', '古镇', NULL, NULL, 2188, 'f2727650-b0d9-4541-acdb-b4eabf894893', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('662308f5-83b4-4646-99b9-bb50cfeece77', '湾仔区', NULL, NULL, 478, 'dfb8b556-10a2-43ab-9fdb-66cde92320ee', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('66287619-8e0a-47c1-af0a-5864083f62f9', '卓尼县', NULL, NULL, 3134, '9d7c5001-b115-4bea-abb4-a289a03b5075', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('66449072-eba0-4584-a7a8-0f8491c0b9c8', '九合垸原种场', NULL, NULL, 3481, 'ea11feaf-194c-4cec-be59-d17bac402db4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6645e6da-165a-430b-b9cf-39bd7cf26ea7', '屏边县', NULL, NULL, 3160, '99a9abd1-f107-4dc6-ae43-e9d1120504b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6648256a-afcf-4cbd-8e2c-c3301e7a12d3', '万泉镇', NULL, NULL, 1447, '81aab36f-0e28-4ba3-9827-b7033fce9b24', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6650bd6a-7ced-428a-bc9b-45af8eee49cb', '五马乡', NULL, NULL, 1105, '79482cd9-7d51-4c89-94c2-4bcd773b8323', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('667fa235-71c5-4283-b265-7cda7c446325', '保安乡', NULL, NULL, 979, 'cc124ed6-091a-42ce-a87a-bb4d0d7357b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('669bb8c2-fb53-4959-ad2e-930f21e372b4', '曲阳县', NULL, NULL, 2495, '81e22d56-a1c7-4263-be18-81a4af165ae3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('66d0b4f2-5391-484a-a91e-a87cd3fb52cd', '东乡县', NULL, NULL, 3952, '1e0a806c-ad0b-4e9f-a488-8bf9fc903f4d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('66d2d396-d9d7-4b1e-894b-30ec951b9693', '八一农场', NULL, NULL, 3221, '2e21ea75-c640-4928-8cb4-e5ba4f6e2ffe', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('66e58567-6817-4821-be0f-f85da2d0c4d9', '东和农场', NULL, NULL, 4496, 'f491d9c3-9527-46a4-8954-6795ff079478', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6703e95a-ae9d-4e6a-b666-55f6761bdd89', '安陆市', NULL, NULL, 2758, 'caa97f6a-9b5e-4871-968e-42852537e6f0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('67190c75-f7c3-4abc-b8bd-7f827e72db37', '祁东县', NULL, NULL, 4267, '75dd761e-ce3f-45bb-a86b-d3a1e2c7629a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('672affac-310e-46cb-ae28-82a371b95533', '涪城区', NULL, NULL, 388, 'efb72ec7-b29f-48d0-a16c-9a33d3938d49', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('673e6f65-fd98-4126-8ad8-c66c80a0a2c3', '凌海市', NULL, NULL, 1075, '99f84690-670c-4a0e-ade1-ebcf17b00adb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6757aced-f730-4721-be24-34fc4f7ef381', '高楼镇', NULL, NULL, 3834, 'c33c3107-81df-4ced-8b92-d694df412da3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('675d3538-1d41-41c5-a28d-d09f697f5f0e', '固镇县', NULL, NULL, 882, 'be39aa7b-a993-4abd-956c-dcb299cc7bc3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('677245b7-4f07-4ebd-bbbc-2dd69e6b0f6f', '莘庄镇', NULL, NULL, 4020, 'f6eb800d-2093-4ce2-8105-3747d69abe97', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('67740430-15f6-42c4-9f41-91556dfa4323', '绥江县', NULL, NULL, 3682, '31187fc0-8d6e-45f3-9653-b7ce4227ef1d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('677f5fa8-b5b3-48d7-9b91-ee9a65f0d061', '九原区', NULL, NULL, 2052, 'd4910db5-a704-4273-bd13-a6dc05f468cf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6789f59e-810d-4679-bbbb-6aa9eefc1db7', '新邵县', NULL, NULL, 3756, '30ce87bd-09cc-4250-9b5e-1f5916ce4d70', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('67a74ebb-656c-47d5-822b-f93cf55900d3', '绥棱县', NULL, NULL, 3557, 'fcd4a18f-a57a-47c4-b2f2-504bc8bccb20', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('67afddcf-fc5d-4e0c-ad2b-fc15fd6621f5', '井庄镇', NULL, NULL, 1513, 'd5ab951d-20ab-46ff-8838-de5efe06b6b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('67b58923-516e-4d98-8769-2fb787e96920', '雷山县', NULL, NULL, 3089, '6d3a8433-1273-4323-a3eb-d39effecc1d7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('67bd6241-9312-4473-a783-de6335c0e9d3', '东风区', NULL, NULL, 1406, 'a03ec6c9-8a1e-456b-bab9-164f8015c723', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('67d39f0e-bbc7-4aff-a504-0bd3729836e1', '平和县', NULL, NULL, 1199, 'bda1d0f2-1476-4e0d-8fb9-2d1392397cbb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('67d6708a-7f5f-475e-a041-fa2ec39fd42e', '镇巴县', NULL, NULL, 345, '5c4e7f63-9162-47e1-a948-c64ca46ff566', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('67de3213-aada-423f-a098-e8cf6547437c', '新平县', NULL, NULL, 4149, '2b997404-05c1-436b-8004-2d5dfd364db3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('67df1244-84c7-4af6-9ca7-ba73f8b458f7', '石角镇', NULL, NULL, 3667, '6581d8db-553e-4417-8c37-91ed47904920', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('67e10f47-7559-4ec8-b7d6-a1e85202169f', '太和乡', NULL, NULL, 1147, '72d4f69f-2e4c-4bde-9df8-2aadc9168686', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('67e8c01b-6353-4645-9444-0a4f28c24835', '龙河镇', NULL, NULL, 1922, '442f465d-6566-45e4-9338-50f4395aa6f7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('67f73b34-01ee-4960-8eca-40e7ba6779fa', '青州市', NULL, NULL, 443, '3e54862f-40e4-4b44-b318-6a64b04a9558', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('680b4087-08cf-424b-bba9-455fec6ae2bd', '金秀县', NULL, NULL, 2170, 'f63c9587-7455-4dff-950d-0da6dddd16c1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('680f018f-7484-4f17-87e9-ca646474794b', '茂县', NULL, NULL, 1185, 'd56c2ee6-b81c-4df8-ba2f-3df7680243c4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('682eff7e-157d-4ab2-a792-15dae1a2dc17', '衢江区', NULL, NULL, 2814, 'b2a03fc9-88f2-4734-9af2-7234863d0f87', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('683c0108-4e48-405e-9844-aa4ed3117645', '上虞区', NULL, NULL, 1420, '472589fe-78e1-4c48-8fde-cf3996a778ca', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('68422e34-fb26-449f-a6c6-fd0893cbf549', '连山区', NULL, NULL, 958, '1671eb17-f102-4972-9d41-7b1463da334d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('684e1f86-17f5-4baf-be07-4157f7875f9e', '乌苏市', NULL, NULL, 2719, 'a419fd83-e078-4430-aa48-ca9aa67e4fff', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('685d5426-0baf-454c-8a6a-8d3a0a187db0', '新界', NULL, NULL, 492, 'dfb8b556-10a2-43ab-9fdb-66cde92320ee', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('68762192-6227-43b0-9a91-fdf73f8043c1', '保靖县', NULL, NULL, 3794, 'b9b94634-b449-4449-9581-c70550dc5099', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('687e3ef2-6500-45f0-b767-18b4fe42aa90', '前郭县', NULL, NULL, 4439, 'a632ea02-ee66-43f0-b946-2bce0ba5396a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('68806be9-a520-4a72-8dde-17470522252f', '巴里坤县', NULL, NULL, 2068, '89e63cc0-6828-4bfd-9e6c-e5752f3cc837', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('68a761d3-e9b8-4a44-b6e8-6020142802d1', '南市区', NULL, NULL, 2481, '81e22d56-a1c7-4263-be18-81a4af165ae3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('68baa2a5-c444-4a34-86ac-ea506350ce57', '抱罗镇', NULL, NULL, 3807, '96fec37f-11d5-4d41-aba4-a36d0652744c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('68d0e231-829a-45f1-990e-ade66a6fab9b', '庐江县', NULL, NULL, 157, '6ab7dc5a-1064-4090-a81b-79c3a2e8302d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('68d246b9-014a-4226-a973-764754aa0533', '香格里拉县', NULL, NULL, 2846, '931058d3-f668-41c4-94a8-7a763997d1df', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('68ec9979-f82c-4db0-a6c8-3de8ac3d775f', '中峰乡', NULL, NULL, 1132, '72d4f69f-2e4c-4bde-9df8-2aadc9168686', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6907a001-842a-48e7-bb9b-710abdc489ee', '峨山县', NULL, NULL, 4150, '2b997404-05c1-436b-8004-2d5dfd364db3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6912b5d7-2957-47b8-acc5-b6cccc7d906e', '松溉镇', NULL, NULL, 413, '9d7d52af-ec34-48e3-b81d-09ac51e11590', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('692adb72-1808-4632-87bc-efe4cf229fc6', '积石山县', NULL, NULL, 2237, '5d2d5d2f-fd44-47ad-8108-b7f838073fbd', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('69335703-4491-4106-ada9-1b7e37a78f8b', '龙马潭区', NULL, NULL, 578, '78000393-73bd-4a54-a688-5db0e578d9cd', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('69463eca-6312-4095-8b07-1e9aba232603', '晋州市', NULL, NULL, 2768, '334645de-ae54-416a-8978-2dbf9f7bbd09', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('69586ec8-c059-4f9e-88a5-2d27809894c9', '中敖镇', NULL, NULL, 1642, 'a560b8db-8db1-4bc8-bb6b-fbbecebcaf10', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('696ee9c0-24b7-4a0b-b78b-b2c56cb033a1', '董家镇', NULL, NULL, 1918, '442f465d-6566-45e4-9338-50f4395aa6f7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('69795cb1-ae08-4442-8304-657690941d8b', '灵宝市', NULL, NULL, 3999, 'ba612057-dda4-4e54-9951-f847a74f623e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6984b480-4f8f-4d24-bfd2-f43810964c7d', '博鳌镇', NULL, NULL, 1450, '81aab36f-0e28-4ba3-9827-b7033fce9b24', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('698f5834-0eec-4b1a-8972-8b0c4ffe0626', '沈丘县', NULL, NULL, 2300, 'f3e12d68-f8c5-4d9d-8314-dd1ce7dac2f9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('69908bcb-cf3e-4b54-99f6-0fbec9613cea', '林芝县', NULL, NULL, 2577, '23ca0ede-0d68-4451-afde-afd774149ec4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('699960a0-20ba-44e0-9e84-23d5a157e759', '尚志市', NULL, NULL, 1529, '349a18f4-4117-490c-b26f-80702a4911bf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('69ab812d-7ec4-43c0-80a0-334abdddc693', '湘阴县', NULL, NULL, 2271, '8369850a-f796-470f-902f-393cfb615571', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('69af89d1-cbe3-48ed-9641-3215a7b34ce3', '墨竹工卡县', NULL, NULL, 4158, '5a657ab2-3d76-4a46-917c-ddfe22c60d16', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('69c85b8e-b38f-490a-9244-dc11de95f042', '安丘市', NULL, NULL, 445, '3e54862f-40e4-4b44-b318-6a64b04a9558', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('69d52b94-d824-450f-ac4e-3d7ede4de1ba', '天柱县', NULL, NULL, 3084, '6d3a8433-1273-4323-a3eb-d39effecc1d7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('69e0ff4a-2d2b-4b14-ba60-75310652d24d', '洪山区', NULL, NULL, 429, 'e6e46871-d5a0-4d2b-8243-9d4bd864ab43', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('69e90449-7680-4c3e-9247-0d7d9212f22b', '镇雄县', NULL, NULL, 3684, '31187fc0-8d6e-45f3-9653-b7ce4227ef1d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('69ee4bb1-dbbf-4d0f-9f65-ceaedf9b1c9f', '公安县', NULL, NULL, 879, '7fe0855f-3ef6-419b-a145-5994fe28cc8f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('69f2c84f-086f-4814-a562-faa4786b1035', '成安县', NULL, NULL, 215, '237eff18-fe6c-4842-afb1-acb05027a5c1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6a1480af-3cb4-46d7-940d-f9025f86e1d2', '二环到三环', NULL, NULL, 3000, '1e3ed660-6de7-4b3a-a1d2-3ea7e0778e94', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6a21124a-33e4-4814-a0d3-cb1ad1ad24fb', '新场镇', NULL, NULL, 2624, '4683d3ef-0edf-425a-98d5-2cb231a7d88a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6a379280-6834-46a0-9e49-f62952ff75c1', '丰镇市', NULL, NULL, 3960, 'a061ae4e-1b4e-4b42-8aa9-cc6bbae9619a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6a525dab-50ff-488c-81ca-f2ba74e360f1', '清河区', NULL, NULL, 758, '3c9ba44c-7031-4422-b9b7-85d772ee3e08', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6a6b5809-dd18-4578-b035-45908ccb6e2f', '西达农场', NULL, NULL, 4094, '5d3b3a34-50c8-4a01-83b7-e3e068d5c9a7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6a84a797-b2fd-4231-8e24-67089cfa502a', '新民区', NULL, NULL, 1839, '271a8d5d-a9a3-4876-a9a2-ca9bcee4b83f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6a87e17b-28aa-44b2-a763-290794bca4d3', '积玉口镇', NULL, NULL, 829, '24ad0708-80a9-43b1-8e1c-758f2492d3f6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6ab2887f-3819-49f2-97f6-3563d3d366a4', '吉州区', NULL, NULL, 4315, '5f548430-51dc-45ad-82e5-bcd0394d8f6c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6ac7e155-78c0-4076-85b6-1a8045abb7ac', '八大处科技园区', NULL, NULL, 3764, '8aa8a856-f81b-43f1-9749-14798022b2eb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6aca7dd5-47bf-455f-ba56-01485f9b769e', '新华镇', NULL, NULL, 3073, '4b20c67b-06ca-4c0b-a947-bc518238537e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6acb23af-0a69-422b-8428-d88ee3a0e8e3', '开江县', NULL, NULL, 1009, '6681b8cd-3740-4dbd-b311-143871994e15', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6afa742d-9bd2-445e-a1c3-8464527e4386', '四环到五环之间', NULL, NULL, 4382, '27537995-4520-4156-95b5-b3d1e368a5dc', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6b09afb1-b160-4b70-97fd-49e305b641ea', '盘龙镇', NULL, NULL, 176, '4f867632-2989-4def-9934-a9c5fe0d5ca5', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6b0e709e-81e4-4cf2-8e68-695fe54ff744', '迎龙镇', NULL, NULL, 2264, 'd17f8f8e-b3dd-4818-a89d-8b431ff5c555', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6b322909-5a9c-4c7b-86f6-289d581de870', '沁阳县', NULL, NULL, 745, 'a096e337-c439-4751-a014-b49dd13bee26', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6b47b684-aece-401a-92ae-1c28a58b7cbd', '广顺镇', NULL, NULL, 2501, 'd998f8bc-c659-47ce-8e5e-a6b29e03ecb3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6b4d837a-2245-420b-89b1-5264f18c3d9f', '四环到五环内', NULL, NULL, 3763, '8aa8a856-f81b-43f1-9749-14798022b2eb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6b7b7813-c4dc-4817-b1b7-4d7a07885ffb', '麻城市', NULL, NULL, 997, '63a5fa32-35eb-4eca-ab79-f3887e122564', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6b85bba5-bdce-4e4f-9917-aaed06c147e7', '龙胜乡', NULL, NULL, 667, 'd7f44c2a-2728-4633-a8b6-7643136bc99d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6b96a2bd-c385-4c35-b64b-3ede42042773', '硚口区', NULL, NULL, 419, 'e6e46871-d5a0-4d2b-8243-9d4bd864ab43', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6ba99f06-e9c9-4e16-a8c0-9df3a9e21f3c', '嘉禾县', NULL, NULL, 1310, '50d6a2ea-ba0d-4ff5-8b4c-f9d84e79e381', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6bc5dc12-01e7-467e-8ae3-8d3416d54998', '妙泉乡', NULL, NULL, 987, 'cc124ed6-091a-42ce-a87a-bb4d0d7357b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6bc689a5-6af1-4746-b59f-717ce816db01', '庆云县', NULL, NULL, 4174, '9c8b6d83-dd06-4238-b7f4-c0ad532e5b6e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6bd053a3-d41b-499f-bb27-a45d710402af', '中和镇', NULL, NULL, 3264, 'a39ced08-b6e9-4de0-a2db-7a230a673d1e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6beacb34-9b40-4ba1-aefa-652f3764928c', '西华农场', NULL, NULL, 3222, '2e21ea75-c640-4928-8cb4-e5ba4f6e2ffe', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6bef023a-0de1-4bf1-b27c-9aac99632c9e', '繁昌县', NULL, NULL, 3943, '5d5b2d25-fb30-4b3b-baac-c5481ccc67e9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6bf77c02-4ed3-434f-9f4a-4f0b823c4fe2', '屏锦镇', NULL, NULL, 654, 'd7f44c2a-2728-4633-a8b6-7643136bc99d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6c2316a4-53c3-4ff2-88ee-3b57eacad7a5', '东营区', NULL, NULL, 1217, '1de2a515-79f9-47f9-a31f-f6892f97a705', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6c2929ea-c8f2-41ee-9664-d13375a0340f', '下路镇', NULL, NULL, 803, '0f559985-f6fe-4a8f-af80-3d0d64932dbc', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6c30ef6c-6013-43df-8c66-5e4c77607663', '铜官区', NULL, NULL, 2532, '574f476d-e1ab-4240-a84f-b9671a2cb9cc', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6c32affe-34ad-4f92-9415-fe0d562c2461', '新市镇', NULL, NULL, 2087, '4686b935-e3f0-4173-bdfe-ab6a5450d1a8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6c36da5a-d3ea-479a-b662-8257869e3b0b', '乌拉特前旗', NULL, NULL, 1686, '753245e5-8705-4940-badd-cd71430a4fdb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6c372551-53ff-4fd0-9320-d956b2b713d2', '张坊镇', NULL, NULL, 69, '0863a0a5-7ac5-4a13-80f5-d31e3a1aa459', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6c397280-cb43-4c43-8f3a-45988b0ff11e', '盐边县', NULL, NULL, 1667, '8e1185d8-66bf-4f53-8ffc-ae9aad60cac2', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6c42384b-0682-4445-b2d3-e873652723b4', '石泉县', NULL, NULL, 2983, '55fbb0a6-5436-4d04-9f29-716233f81fd7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6c5875cf-1bf5-4855-84cb-aeba94a98f3a', '玄武区', NULL, NULL, 1864, 'adb7aa6e-99a6-453f-a2db-21ecfbc44874', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6c63c616-2cdf-47ea-959f-c9a3f28b1674', '信州区', NULL, NULL, 503, '8bf55045-9366-4acb-b884-bca672ff9644', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6c6592ad-8bb9-4b9b-a398-4a18f755152b', '杞县', NULL, NULL, 4184, 'fb0dbd60-1d03-4394-a890-ffc2d3ec6a37', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6c7b58cb-a60f-4815-badb-285102bf58a5', '原平市', NULL, NULL, 2832, '18b3c51b-f699-467d-a342-d78bf9cff362', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6c7e3857-0632-43e4-aeb1-580fd46c763c', '先锋镇', NULL, NULL, 907, '41f376c0-764f-46b9-af35-e555518fc613', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6c89c1c3-ef1b-4e00-b552-db307af12258', '白云矿区', NULL, NULL, 2056, 'd4910db5-a704-4273-bd13-a6dc05f468cf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6c922cb1-f994-45c3-8458-782ed1feccf4', '头渡镇', NULL, NULL, 922, '88260608-a8b9-4b52-a474-1a551465c675', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6ca506b1-8dd2-4071-a0e3-d11c4629d620', '绛县', NULL, NULL, 4108, 'fc30b5e5-3005-4778-94f7-706b31514bff', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6ca5d25c-05cb-4317-8ab7-58e658e46021', '鱼鳞乡', NULL, NULL, 1600, 'ac0e6e50-b6a1-457c-811c-06ac309cd5a3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6ca6f7cf-c249-4715-b6e0-1e2b9f485a41', '类乌齐县', NULL, NULL, 2691, 'b7342349-941d-427d-9ab6-e83a36078088', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6cc4192e-6985-49a4-bf56-b93acc245844', '衡山县', NULL, NULL, 4266, '75dd761e-ce3f-45bb-a86b-d3a1e2c7629a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6d0ae98f-754b-4a81-a0cd-7410a3746027', '筠连县', NULL, NULL, 1822, '18a8dd20-aad4-43cd-ab48-ab6108097d8a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6d12b8e2-1f0a-4fa1-9f86-7fff6cb21653', '新盈农场', NULL, NULL, 3225, '2e21ea75-c640-4928-8cb4-e5ba4f6e2ffe', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6d399e2f-9a8b-4523-b9fc-a654eecd337d', '三林镇', NULL, NULL, 2635, '4683d3ef-0edf-425a-98d5-2cb231a7d88a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6d3c6551-5a93-4d89-b712-b9b9936dff0c', '沂源县', NULL, NULL, 2448, 'c03520db-2a67-4cae-a658-4806d4254996', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6d5345d2-9606-4ec2-98c3-43fdf5800f95', '红林农场', NULL, NULL, 778, 'af6f4f65-b2db-4670-88ca-21de1de477fc', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6d7614a6-e206-4b1d-8fcd-c89159c4285f', '花都区', NULL, NULL, 1985, '926eaeaf-e8c5-47f2-89ff-6932b52c87d3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6dda9661-118c-466e-9849-babe280a59d7', '茨竹镇', NULL, NULL, 705, '97942649-3cc7-4e4a-81b4-9a8c82f82ea7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6df57a73-5545-4979-828f-608e1848fd10', '二环到三环', NULL, NULL, 4079, '18de87f3-b679-462e-93ac-770a72141f3b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6e05665c-4327-4c6e-8ec9-ffed9c604bdb', '乳山市', NULL, NULL, 1385, 'e86879a9-9808-4629-8311-39d63744f2fb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6e0a71b4-4b91-459c-ad23-35ada535768c', '西市区', NULL, NULL, 2682, '1c705a6d-5a16-4544-905c-68134716c6cf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6e258f8c-1982-4e97-b305-231729e6bbaf', '河间市', NULL, NULL, 2888, 'a3c44525-9ccb-429d-a2b7-f5f5d52b8a6d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6e4e5140-8294-4663-be78-26dfb74dc962', '大溪乡', NULL, NULL, 374, '76dd00a1-30a1-4226-ae06-cad845c0528c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6e57912b-a049-4950-8084-35918ce66649', '文水县', NULL, NULL, 3409, '9348509b-6d82-47e7-86d7-f054fb47b7fe', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6e778381-46b1-4b30-8696-ba15d4dc9a7c', '凤泉县', NULL, NULL, 2184, '1aabde9d-2b04-4892-a20d-5b4e3efaeedf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6e7c9bb8-3fbb-4f55-8784-0f69546d14ca', '龙石镇', NULL, NULL, 1654, 'a560b8db-8db1-4bc8-bb6b-fbbecebcaf10', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6e8e1350-2c97-4d18-868b-a03febb736de', '伍家岗区', NULL, NULL, 1775, '3760382f-ecb5-4ef6-8bd2-049afe34b574', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6e9de299-f3a3-4d82-a87e-dc8ab5009cce', '兴隆镇', NULL, NULL, 2925, '465e9ea2-a2f2-4b42-95dd-b48d91f67105', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6ea1967e-46c3-45a6-b26b-18e33692e5d8', '洋县', NULL, NULL, 342, '5c4e7f63-9162-47e1-a948-c64ca46ff566', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6ea95e37-2d3f-4a9b-a138-f5a0d5bd8b42', '盐亭县', NULL, NULL, 396, 'efb72ec7-b29f-48d0-a16c-9a33d3938d49', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6eb99c96-9153-47c4-9c34-a85c9ae7c8c5', '揭西县', NULL, NULL, 1742, '03f84ef3-e7e9-4c0d-a1ab-b4170505bcaf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6eccfc30-216e-4268-8a06-bdfd1fce043e', '少云镇', NULL, NULL, 3844, 'c33c3107-81df-4ced-8b92-d694df412da3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6ee65901-f13c-43b6-8566-5a262b14552c', '桦川县', NULL, NULL, 1400, 'a03ec6c9-8a1e-456b-bab9-164f8015c723', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6eef6c3e-7129-425a-9070-af701c6a4a3a', '玉龙镇', NULL, NULL, 1645, 'a560b8db-8db1-4bc8-bb6b-fbbecebcaf10', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6ef0261e-d84c-464e-9bda-aba5b0f6e7bf', '金寨县', NULL, NULL, 283, '4ee9594e-d779-4cad-a3bc-d766de26628a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6f060aaa-bbd3-4ed2-87df-a33fee1594af', '招远市', NULL, NULL, 594, 'f3717726-7743-4838-852b-3a09f9528a69', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6f19b59f-31a3-4494-b1e8-0e51bfc90e3c', '交口县', NULL, NULL, 3416, '9348509b-6d82-47e7-86d7-f054fb47b7fe', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6f273985-6cf6-4d81-b7a6-472e61d7c8a2', '阿图什市', NULL, NULL, 2241, '4f2a5173-2b34-4ed5-974e-a6ab5641b2a8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6f2b3a45-769a-4ad9-927b-31df4383fe30', '伊宁县', NULL, NULL, 2584, 'e6f53877-d5bf-4b42-aded-5ab8960ef034', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6f47e86b-8a08-494a-b621-3643b380be2d', '朱沱镇', NULL, NULL, 417, '9d7d52af-ec34-48e3-b81d-09ac51e11590', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6f576bcf-6ca2-417c-bf13-f896db1c8798', '黄沙乡', NULL, NULL, 1496, '89e8be16-b810-4c7e-89f0-aa9f24483b98', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6f5a9c87-4cb8-4375-9cfe-0540b7584072', '江汉区', NULL, NULL, 422, 'e6e46871-d5a0-4d2b-8243-9d4bd864ab43', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6f71121d-9c57-4b3f-a8b8-8805aa0d9f55', '米心镇', NULL, NULL, 563, '8ae99c85-66b1-406b-8084-9f77cbf73b10', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6f773339-5bdd-4a26-aa7d-df71a1031d08', '南朗镇', NULL, NULL, 2203, 'f2727650-b0d9-4541-acdb-b4eabf894893', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6f981240-8657-4425-a12c-620c005a78cf', '杨林尾镇', NULL, NULL, 3467, 'ea11feaf-194c-4cec-be59-d17bac402db4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6f9af1b0-ab74-4402-925c-87abc997d817', '旬邑县', NULL, NULL, 2109, 'e42fbad8-c29e-4f35-878d-95a667b5cc90', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6f9db4d2-bec7-47be-8c46-0baa859baaf8', '周矶管理区', NULL, NULL, 837, '24ad0708-80a9-43b1-8e1c-758f2492d3f6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6f9f56c3-305b-43ef-a7f0-33014ffca901', '惠农区', NULL, NULL, 1437, 'ef951e0d-15d6-4343-901d-8412af9b0b93', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6f9f68aa-5e0e-40e9-bee4-cb39130ce526', '古楼镇', NULL, NULL, 3879, 'a732da28-870c-4d9c-a287-c2c1e3222b59', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6fa066e1-b8f6-40be-8080-80862fee70dd', '鸡泽县', NULL, NULL, 218, '237eff18-fe6c-4842-afb1-acb05027a5c1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6fa6a322-31a9-419d-b488-63e91d14caea', '河口县', NULL, NULL, 3161, '99a9abd1-f107-4dc6-ae43-e9d1120504b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6faafda7-6824-44be-bd00-449055edd393', '回龙坝镇', NULL, NULL, 3902, '7fefd2bf-99e0-43f5-bc37-9ab15ee8e8f3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6fac2281-557f-4b6b-88d9-c6613095f168', '园林', NULL, NULL, 822, '24ad0708-80a9-43b1-8e1c-758f2492d3f6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6fac9fbb-3fd5-4f61-aa11-29eb875be4da', '裕安区', NULL, NULL, 287, '4ee9594e-d779-4cad-a3bc-d766de26628a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6fba8ca0-ff29-4759-8ab2-bc1ad38b2a27', '新林区', NULL, NULL, 3048, '1b8b9a84-0955-4d1e-8f33-8de97af3bedd', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6fca7170-524b-412a-9baf-2d8e45c0aa6f', '经济开发区', NULL, NULL, 1622, '6de68814-d6ea-430e-88b6-bf98620aa604', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6fd26822-4573-4d55-ac5b-a885e094e378', '宁阳县', NULL, NULL, 1246, '23df07d6-66e4-474e-b42b-258f50d7b0e4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6fd55417-bc4b-4eff-80c6-3888cb900028', '田阳县', NULL, NULL, 1221, 'f56fa64d-ca06-49d2-a9cb-94742a33af21', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6fe7db2f-ad8a-4847-88bb-d67f26d7c217', '湖滨区', NULL, NULL, 3997, 'ba612057-dda4-4e54-9951-f847a74f623e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6ff8dcd6-3765-4819-a923-e5d87b7b6311', '泰丰', NULL, NULL, 826, '24ad0708-80a9-43b1-8e1c-758f2492d3f6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6ffad993-2b40-4bf2-83da-6e5f28bd1e4c', '珞璜镇', NULL, NULL, 891, '41f376c0-764f-46b9-af35-e555518fc613', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('6fff4c73-ad04-41f3-877e-3f5994aadf1f', '广普镇', NULL, NULL, 3601, '27289f06-ca7a-4916-8f25-f6b13d8687ec', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('700f4628-2e5c-48b4-b69d-75098b5f1c47', '分宜县', NULL, NULL, 2967, '72738f5c-f5f3-4895-8ada-20327c2d5826', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('70230468-56db-4c76-94a5-a69d1dafd180', '丰南区', NULL, NULL, 2457, '4f4c1ef4-f54d-4ba4-a124-ca2d3d0ddb78', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('702acf87-3414-4afe-bab2-fad2598d7dc1', '兴山区', NULL, NULL, 3278, '978f3e32-c5e0-48e4-b9ba-4f7f04ed87a1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('702d88d1-19e6-424f-a320-70aa69b5582b', '热作学院', NULL, NULL, 3199, '2e21ea75-c640-4928-8cb4-e5ba4f6e2ffe', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('70310030-cddf-44fa-be52-91b8bc8f193e', '南坤镇', NULL, NULL, 4333, 'e98653ba-264e-4417-b74e-e0798b25e646', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('70345d86-6893-42df-8a1e-6bf9e2c2e758', '加来镇', NULL, NULL, 726, '0be5e1cb-cdb0-48ca-9f82-47f7f4c6dd2e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7041afd5-42b3-4ba4-b1ef-3d7c3cd2a6f0', '上安乡', NULL, NULL, 2289, 'b3792f06-9c78-446e-b6ac-d95d5e9092e8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7049d86f-ce87-4900-a778-266449166e2d', '宜丰县', NULL, NULL, 4067, 'fa27d3fb-a80f-4b4c-8d0c-bf7d544bb974', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('704f6803-afa3-46e6-af5d-be0c72d3c683', '中兴镇', NULL, NULL, 3992, 'fcc07455-c69c-4c90-82cb-ddb268adb8a9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7059720a-9275-42fd-98f4-3dd265121088', '定城镇', NULL, NULL, 1562, '5f7e2e46-8a4e-4463-907c-5762bcd006a8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7062adcb-2c11-4669-b137-65b72d076efc', '北市区', NULL, NULL, 2480, '81e22d56-a1c7-4263-be18-81a4af165ae3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('706600ac-a8bb-4ed7-a152-fc598960087a', '田林县', NULL, NULL, 1223, 'f56fa64d-ca06-49d2-a9cb-94742a33af21', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('706e3b25-82de-4daa-b1f4-a8adebaeb59b', '沂水县', NULL, NULL, 4342, '56327d0b-ec26-4f34-8ab6-0eba49931c67', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7076497a-41b8-47b6-874a-4c97d9ac12e7', '桃江县', NULL, NULL, 80, 'c2eab125-e437-4681-9331-695a7b3b1ecf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('709b9af5-fb14-483c-8162-23c59a27ca62', '蒙山县', NULL, NULL, 3038, '01d0a041-f2c0-4416-b710-9376b2aabcaf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('70a2e579-bbac-485b-9cbe-b22a91e46b35', '友谊县', NULL, NULL, 2255, '69696549-d65b-4e13-80ef-05ecaf0f61e3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('70bf6a17-c68a-4020-80a8-bf85f363a1d0', '三合镇', NULL, NULL, 3602, '27289f06-ca7a-4916-8f25-f6b13d8687ec', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('70c866a1-fe72-4d6f-a727-aa2476540e48', '阿尔山市', NULL, NULL, 2970, '9758648c-eab9-4434-b7ae-318e7e08548e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('70cca258-6eb9-4a15-ade6-ecae567f8cf1', '麻洋镇', NULL, NULL, 2150, '671275c4-6107-4968-bd8e-96d53e9995b2', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('70df0c49-192d-43eb-bb9a-e1cd28b75027', '罗田县', NULL, NULL, 1001, '63a5fa32-35eb-4eca-ab79-f3887e122564', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('70f269b2-c4e0-4ca0-aee5-459df0da95b3', '关岭布依族苗族自治区', NULL, NULL, 3625, 'a70a258d-7c8f-4726-a9ef-e2aa7c6247f9',
        1, 'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('70f28c78-1865-40af-9175-1f3e4195f77e', '五环到六环之间', NULL, NULL, 4383, '27537995-4520-4156-95b5-b3d1e368a5dc', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('710e00ae-05f1-40b1-85e9-cfc2ab366052', '良庆区', NULL, NULL, 2801, 'b53ced47-2455-44ec-b740-7637148f574c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7112a4bd-ace9-4367-a405-59ace01a2807', '黄陵县', NULL, NULL, 3397, 'f95958de-a678-4371-9710-6bcac3f425fa', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('711697f6-b2bf-4d31-a381-a287b5a9d03f', '桑植县', NULL, NULL, 332, '1af0c5e6-6728-445e-9278-f1eaf5c6303a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7117c3c2-6ec1-44dd-9c4a-82fed3cb0d65', '五华县', NULL, NULL, 4394, '2aabe025-ea3b-4ce4-885f-9ecf122b3e79', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('712efdf5-7990-42d5-a66a-1524c51cb68b', '蒲县', NULL, NULL, 3707, '1aeeea9e-d028-4a96-94ce-ba84cdd3e69f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('713122c4-77ac-46be-a192-bdf300a3667b', '习水县', NULL, NULL, 3430, '69324865-24e8-4abe-a068-a1392c117c0d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('71490135-f2c7-4563-982e-52e4763ed0b9', '双湖县', NULL, NULL, 4422, 'fae5ed6b-9b68-4ef9-93fa-221dea13a975', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('71577ed2-653d-464c-9115-579398235ca1', '鸣玉镇', NULL, NULL, 945, '88260608-a8b9-4b52-a474-1a551465c675', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('715dc3f2-62b3-4f5f-a100-2061c5e99b13', '宛城区', NULL, NULL, 732, 'a769a530-0bcf-4e52-a9e5-3a8f5af945d2', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('715ea4a0-6265-498b-bc4d-876ce062b1fb', '武山县', NULL, NULL, 3114, 'b31f9073-6d76-4083-b00f-cc23550ef59a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7162c59d-e97d-48a7-9610-e9128fdf44b9', '馆陶县', NULL, NULL, 213, '237eff18-fe6c-4842-afb1-acb05027a5c1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('716bae20-bbdc-48c6-a95f-de860cfadda7', '横沙乡', NULL, NULL, 3994, 'fcc07455-c69c-4c90-82cb-ddb268adb8a9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7176a320-96d5-4ebe-9a27-29e396cb46b6', '崂山区', NULL, NULL, 3716, '1e53830d-8cdb-4111-8da6-987131b873ed', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7177af01-3748-499d-97a5-92e0a00c2228', '白羊镇', NULL, NULL, 4202, '0ee28cef-8dfc-4a9f-b7c1-330bc11c1bb3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7178706a-eff5-49be-9c98-e160ce4d2920', '茅箭区', NULL, NULL, 3936, 'd795e41b-eb16-4383-b762-ea557481f8e1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('71a1e691-6aed-4542-a0c6-b6aa2d5b7818', '罗湖区', NULL, NULL, 671, 'fd718129-208d-4a94-9e52-7516af8ef013', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('71bae494-e652-409b-ae7c-3122d744a53d', '广平县', NULL, NULL, 220, '237eff18-fe6c-4842-afb1-acb05027a5c1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('71bca8a8-270f-44b0-8b68-7dee2ad7e824', '宝顶镇', NULL, NULL, 1641, 'a560b8db-8db1-4bc8-bb6b-fbbecebcaf10', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('71cdd939-c77c-45f8-90b9-499872be4d35', '长安乡', NULL, NULL, 1109, '79482cd9-7d51-4c89-94c2-4bcd773b8323', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('71d17c89-7505-46e6-8fbd-bc4859c64cfe', '岳麓区', NULL, NULL, 622, 'dccf3d25-c012-444b-94c6-bbcbae7e63d8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('71d3c2ab-2401-4572-9aff-0656cd954e16', '东阳镇', NULL, NULL, 2320, '671d3a34-71bf-42c5-8dda-a813f5ecba22', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('71f0ee97-757b-4fa5-a518-50a1a9ff0555', '临澧县', NULL, NULL, 4307, 'dd99fcda-6192-4ada-bef5-b04735e7dae8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('71f40b8c-59af-4d04-91b2-2b81dde6727d', '德庆县', NULL, NULL, 1472, '2ca74ae0-5e04-4119-84d8-187921fe4056', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('71f5b521-3189-4c04-ab66-79da8517b26c', '中方县', NULL, NULL, 2020, 'd133a3fc-3db0-426f-8a04-e25b44a5565c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('720d4cef-f2c6-4c9a-9356-bf6505bfe9c0', '且末县', NULL, NULL, 3180, '0ce20b86-8bea-4d7c-a1e4-09c7519d8b16', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7220a45f-a3cc-4679-9956-7778bd532b13', '正阳镇', NULL, NULL, 3356, 'aa2f26e5-9705-4dc0-b54a-a2d7dbb8b511', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7243b432-9cd4-44f7-99c0-4e6ec77b3e51', '苍岭镇', NULL, NULL, 2913, '465e9ea2-a2f2-4b42-95dd-b48d91f67105', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7244cc31-dbee-4cfa-ab0d-31d5dbc6c9d6', '湟中县', NULL, NULL, 3863, 'baa2f053-c419-40c1-93fe-68e081b7f229', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7249dfba-fa7b-4d4b-ae3f-ab03226b4c31', '凤凰镇', NULL, NULL, 1576, 'ac0e6e50-b6a1-457c-811c-06ac309cd5a3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('724a8ab7-ecbe-4ffe-89bd-7c38e46ee41b', '环翠区', NULL, NULL, 1386, 'e86879a9-9808-4629-8311-39d63744f2fb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('725e88e8-524f-4f8b-97be-b02499ef78b6', '广兴镇', NULL, NULL, 896, '41f376c0-764f-46b9-af35-e555518fc613', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('725f6c5d-177c-41ef-88df-3c49312fb791', '城区', NULL, NULL, 2538, '89a9c37c-487a-4c32-968c-cf9fefad8151', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('72687ad3-cd78-4005-b33b-9e40820d2afa', '平度市', NULL, NULL, 3718, '1e53830d-8cdb-4111-8da6-987131b873ed', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('72739efc-aa6f-44b0-a396-c5adc6fe3a41', '立山区', NULL, NULL, 2010, '48832e11-ddfb-478a-9787-e46c47346d7e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('727a976a-5bb3-464b-95a1-383176e6de2c', '新胜镇', NULL, NULL, 572, '8ae99c85-66b1-406b-8084-9f77cbf73b10', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('727f0006-e2ef-44e7-960d-7682077a410d', '二坪镇', NULL, NULL, 3826, 'c33c3107-81df-4ced-8b92-d694df412da3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('728051b3-4290-4372-b68e-2244d3770c98', '克山县', NULL, NULL, 2737, 'f4e36f9a-e006-44a6-8d77-47971d41810b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7284cacd-39d7-43ff-9c2f-fc24eb5221c3', '腾冲县', NULL, NULL, 3148, '3fbd3d32-e8e3-476f-9f4c-319ffaaed527', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7288fa3d-1b22-486b-b355-f9828a7955f2', '会山镇', NULL, NULL, 1457, '81aab36f-0e28-4ba3-9827-b7033fce9b24', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7292c8f8-517a-4cee-b427-0dd5730a33b7', '大安市', NULL, NULL, 3098, '7af2dfc0-6d0b-4da1-a6c9-fa505dbc6e9b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7292ccd5-190d-469b-ac0d-3b112cd94feb', '后溪镇', NULL, NULL, 2920, '465e9ea2-a2f2-4b42-95dd-b48d91f67105', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('72a86d28-b33f-4822-a104-7b52473b6337', '岳普湖县', NULL, NULL, 2037, 'e6436d79-8045-4185-b2b2-22cd280d22b0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('72c101a4-7abb-4d11-bf4b-891d50b913aa', '固始县', NULL, NULL, 3498, '976170b4-d0f7-4fd9-82ed-6e336c9bf3c0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('72d1cb05-7e83-48db-9d0d-c9fe066559bf', '隆兴镇', NULL, NULL, 3883, 'a732da28-870c-4d9c-a287-c2c1e3222b59', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('72dde451-325c-45f6-8e66-1d8f9e7cbfec', '柳河县', NULL, NULL, 870, 'def0f6fb-9804-4bed-8554-2115bfca9849', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('73062d57-16b8-4d15-8788-2865328b3a5b', '乾丰乡', NULL, NULL, 932, '88260608-a8b9-4b52-a474-1a551465c675', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('73086203-a6ef-4a91-b5fa-4c681eac1812', '新乡县', NULL, NULL, 2178, '1aabde9d-2b04-4892-a20d-5b4e3efaeedf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('73249a33-a45e-4036-8d15-fc5382cc184e', '两汇乡', NULL, NULL, 1140, '72d4f69f-2e4c-4bde-9df8-2aadc9168686', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7328deb8-2eb1-4394-8293-ec80e4ec5893', '高场原种场', NULL, NULL, 841, '24ad0708-80a9-43b1-8e1c-758f2492d3f6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('73296107-56b0-4b9b-acca-53ca477559fc', '浩口镇', NULL, NULL, 834, '24ad0708-80a9-43b1-8e1c-758f2492d3f6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('734b3daf-581d-410a-9eea-191be904262f', '邯山区', NULL, NULL, 205, '237eff18-fe6c-4842-afb1-acb05027a5c1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('735b57fc-9a95-4fe6-b52d-768c7b227818', '青县', NULL, NULL, 2891, 'a3c44525-9ccb-429d-a2b7-f5f5d52b8a6d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('736bd603-0139-4a43-90ef-1a11a8b2ef89', '晋阳县', NULL, NULL, 521, '84a16421-f7fb-4f99-b2c0-1e0dea97bf0b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('736c7059-40d2-4c58-b3a3-3f4624b9ac4f', '青羊镇', NULL, NULL, 1121, '72d4f69f-2e4c-4bde-9df8-2aadc9168686', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('737aad13-3def-46b3-b483-7ad1ffa3aae7', '高境镇', NULL, NULL, 769, 'c470aa47-a334-4df9-a8ea-b90683ddc861', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7387ba5f-8b0f-4b74-bb16-201546cdbb10', '二郎镇', NULL, NULL, 3881, 'a732da28-870c-4d9c-a287-c2c1e3222b59', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7391e7ed-1b70-4488-8b28-6e5b8ddf75b0', '上和镇', NULL, NULL, 565, '8ae99c85-66b1-406b-8084-9f77cbf73b10', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7392d04c-9368-40c9-b26b-a6e050c7f313', '裕民县', NULL, NULL, 2721, 'a419fd83-e078-4430-aa48-ca9aa67e4fff', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('73931e1c-ee31-41e2-9249-f58f46654f4a', '永安镇', NULL, NULL, 1488, '89e8be16-b810-4c7e-89f0-aa9f24483b98', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7396b125-af4c-405b-84f3-fabcba05ecdd', '群力镇', NULL, NULL, 564, '8ae99c85-66b1-406b-8084-9f77cbf73b10', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('73ec2e91-1666-41b3-b0d8-d498e57add53', '理县', NULL, NULL, 1184, 'd56c2ee6-b81c-4df8-ba2f-3df7680243c4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('73f8234e-f519-4987-baa6-53aab48bd973', '禄丰县', NULL, NULL, 2097, '50868d97-8741-48fe-9cba-86e2e118f220', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7408fe6c-8e30-4ec8-a140-183484338544', '兰考县', NULL, NULL, 4185, 'fb0dbd60-1d03-4394-a890-ffc2d3ec6a37', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('74103217-7449-4ed0-a62a-c3267d66b8cf', '郭河镇', NULL, NULL, 3470, 'ea11feaf-194c-4cec-be59-d17bac402db4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7415e224-2b16-41cd-b5dc-99b66d6a4000', '滨湖新区', NULL, NULL, 152, '6ab7dc5a-1064-4090-a81b-79c3a2e8302d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7421e4f8-ffd6-4ae7-b3bf-96dc0b3dab0e', '新津县', NULL, NULL, 1812, '4f073365-4e02-459f-8b32-cad88dd22637', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('74372685-0689-4c7c-a2d9-3b1c65074395', '龙沙区', NULL, NULL, 2726, 'f4e36f9a-e006-44a6-8d77-47971d41810b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7437d2b4-5285-4b73-8bc1-42015012c4ed', '海州区', NULL, NULL, 307, 'fca062e6-ca02-4963-9f79-ed8cbfbb11df', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7447e3e2-a3d2-40b9-8f38-b22a80b6b759', '龙胜县', NULL, NULL, 3198, '796bb0e0-6b76-4c1d-801f-2dbcbab74087', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('745f6f26-da26-4afb-8ed1-ef3de0bc738b', '兴业县', NULL, NULL, 2339, 'ee710091-bfa9-4285-89e3-80ad65ebd912', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7466f15d-44d4-46c9-819c-17dbe455b2c1', '南沙群岛', NULL, NULL, 352, 'e6678936-cb1f-4a28-9b29-fb553d2adf87', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('746ddc28-8ef1-498d-a920-6897fd1ab24d', '铁西区', NULL, NULL, 1844, '271a8d5d-a9a3-4876-a9a2-ca9bcee4b83f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('748263aa-9004-41c1-be5f-86060bf2a27b', '和田县', NULL, NULL, 848, '60e9ec7d-f371-4ea9-ace3-b13c1cd7081c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('748bf595-0a5e-4293-bae3-5aee5ce6eeba', '长沟镇', NULL, NULL, 70, '0863a0a5-7ac5-4a13-80f5-d31e3a1aa459', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('748d9fdf-b676-4530-96b0-4134904b8ea9', '赵巷镇', NULL, NULL, 2539, '89a9c37c-487a-4c32-968c-cf9fefad8151', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7490c742-2b8f-451e-9673-9ed5a23d8a62', '高家镇', NULL, NULL, 1919, '442f465d-6566-45e4-9338-50f4395aa6f7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7491f65b-25f9-4d53-a8b7-48bc134a352b', '公主岭市', NULL, NULL, 683, 'de003161-c00c-4f8a-ac92-6a2188069e9b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7498a9a1-f75a-4d2c-9982-8cced4040054', '高安市', NULL, NULL, 4064, 'fa27d3fb-a80f-4b4c-8d0c-bf7d544bb974', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('749b7eff-c9da-41a8-9c61-4cdcc7a313e6', '利通区', NULL, NULL, 607, '9d872dc5-ad1a-4b3c-86de-debd1a77eb8c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('749c363c-6a39-43a8-8d3d-4e720dba05ba', '普子乡', NULL, NULL, 4234, '0ee28cef-8dfc-4a9f-b7c1-330bc11c1bb3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('74a32301-3b78-4b49-95ea-e6c2c09d50ca', '迎江区', NULL, NULL, 3589, '818f3bc6-83b9-4d90-8e68-566cc7c2bb14', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('74a847d9-ebce-4315-aa1b-89a0d936e080', '保合乡', NULL, NULL, 1935, '442f465d-6566-45e4-9338-50f4395aa6f7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('74b086e0-4afa-490e-92ad-4fa78e4e0f06', '天台县', NULL, NULL, 3288, 'de41020d-a8dc-44d0-a2d4-75b6076c0ae8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('74b9dc51-5fe2-4a5d-ae66-b10540dceb5e', '红华农场', NULL, NULL, 727, '0be5e1cb-cdb0-48ca-9f82-47f7f4c6dd2e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('74bfec39-e482-41ab-91ca-182942c20e38', '金山工业区', NULL, NULL, 2700, '0e5598a8-f405-4745-8cd5-a7a4c99f67f9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('74c0d52b-198b-41d7-a3aa-09994e9e4f9a', '岚天乡', NULL, NULL, 2394, '0275a9ca-e89b-4217-b3b0-ada824d9e095', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('74c116b8-c653-4627-8749-276abead1535', '咸水沽镇、海河教育园、海河科技园', NULL, NULL, 4376,
        '7932fd13-00db-4934-bfc2-79c835527339', 1, 'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL,
        '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('74e31c62-849c-4191-9f9a-252f15d9fb60', '宁津县', NULL, NULL, 4172, '9c8b6d83-dd06-4238-b7f4-c0ad532e5b6e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('74e672ca-b3cd-492d-9bc0-0c674d6379c6', '金波乡', NULL, NULL, 1352, '21bb958f-e5d4-4a71-a350-b5bf2c0e2de0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('75258ef8-2d23-4420-bc27-048ef1415cd4', '爱辉区', NULL, NULL, 1428, 'e27d8c07-338c-4b1a-b45c-cf9cf0a22a0c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('752e512b-e160-44ad-b183-76ad65d9ea1c', '朗溪乡', NULL, NULL, 1890, '2c8bc8c3-9317-4f36-a0ad-05a8d6b27053', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('75354c66-5bec-4ef9-b354-4241a37637ae', '凤台县', NULL, NULL, 2964, '69508f5e-7304-4092-95a4-73d6a9b68eff', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('75544a6b-6b8d-49d4-bebd-63792fe8042a', '八段工业园区', NULL, NULL, 4435, 'e20441c5-c8b4-493a-9738-2327e656fbcb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('755ddd1a-f79f-4b4f-998a-a155973033c3', '中牟县', NULL, NULL, 4124, '4ff4ef6c-41df-4562-a58f-d8b25b2e3ba4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7563412a-2e2c-4780-a57f-fc3720f42579', '新兴县', NULL, NULL, 264, '34138fe1-593f-4c44-87ac-1beaee74bafb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7565d005-b0fc-46f9-97fa-941d724d996f', '宜章县', NULL, NULL, 1307, '50d6a2ea-ba0d-4ff5-8b4c-f9d84e79e381', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('75768c57-73e5-4a03-8b3a-9dc2732553a4', '毛感乡', NULL, NULL, 2999, '4b3478d4-3e85-4143-bc6f-ac4a338a9d47', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('757bc690-85d6-40b2-9cd1-2dc296186a89', '古溪镇', NULL, NULL, 561, '8ae99c85-66b1-406b-8084-9f77cbf73b10', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('757bd1fb-da01-4d43-b380-d31a9254bd2d', '清水乡', NULL, NULL, 193, '4f867632-2989-4def-9934-a9c5fe0d5ca5', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7586df49-64ff-4bf3-832d-db841bf742b4', '江州区', NULL, NULL, 3027, 'c99528d5-bed7-4890-b547-f2159ed13a78', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('75a5a99a-503a-45c2-9695-c1f594a3a17d', '卧龙区', NULL, NULL, 731, 'a769a530-0bcf-4e52-a9e5-3a8f5af945d2', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('75a7d4b7-0177-4c42-9235-4ff7be8de0a0', '雷州市', NULL, NULL, 2600, '5c5b11a0-6a29-4173-b876-8fdbc543cb2b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('75b06723-0954-4a5d-aba6-8285e54e7fd9', '野鹤镇', NULL, NULL, 2673, 'e509a1a5-95da-4fb2-9a2b-f84afa05a36c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('75b18bc7-7f8a-43bf-a590-7924157c16e0', '敖汉旗', NULL, NULL, 4471, '4b199fdb-3a49-40f7-9843-8bd43f4ea30c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('75c1857a-d311-4c0f-b607-0271d752d174', '新邱区', NULL, NULL, 311, 'fca062e6-ca02-4963-9f79-ed8cbfbb11df', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('75c32cf3-deaf-4dc0-9aef-ba7b1646aa41', '南安市', NULL, NULL, 1854, '0d3bd52a-74b2-4461-9a57-17c7cce4ac1b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('75d7fb55-6fe6-4cda-b9c7-682864490a01', '邵阳县', NULL, NULL, 3759, '30ce87bd-09cc-4250-9b5e-1f5916ce4d70', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('75e86a3f-c46d-48be-a0b8-0208dc68dd90', '陆河县', NULL, NULL, 601, 'e11c17b6-eb2f-4d32-9de9-48ab1440c8c7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('76049c57-cae0-4598-8ec2-c2e0e2db37eb', '兰山区', NULL, NULL, 4339, '56327d0b-ec26-4f34-8ab6-0eba49931c67', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('76070ab1-bf45-456d-bb7e-d61525c9b2c8', '桥西区', NULL, NULL, 2763, '334645de-ae54-416a-8978-2dbf9f7bbd09', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('760fe61f-c42f-4fab-a470-66c117df8266', '临海市', NULL, NULL, 3286, 'de41020d-a8dc-44d0-a2d4-75b6076c0ae8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('761e4a1d-621e-489a-a14b-c75ab9c56e34', '石莲乡', NULL, NULL, 934, '88260608-a8b9-4b52-a474-1a551465c675', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('76430cb7-366e-452b-b0f9-8868ca5286ab', '敦好镇', NULL, NULL, 3247, 'a39ced08-b6e9-4de0-a2db-7a230a673d1e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('76623f7f-3c93-4025-82b5-b37650021c13', '高新区', NULL, NULL, 440, '3e54862f-40e4-4b44-b318-6a64b04a9558', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7669d037-e5a6-4986-a271-6e15e2e012cf', '石楼镇', NULL, NULL, 63, '0863a0a5-7ac5-4a13-80f5-d31e3a1aa459', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('76756aab-5f93-44dd-80ca-256e2b75bef2', '庐山区', NULL, NULL, 120, 'bcaf1f36-5459-4e74-81d1-5026680b1a9c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('76762ad2-615d-414b-904f-9605f29ab15b', '膏田乡', NULL, NULL, 983, 'cc124ed6-091a-42ce-a87a-bb4d0d7357b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7678a3e9-bcf2-4aa5-b891-a27401c68efd', '大荔县', NULL, NULL, 3167, '9e5ae65c-206f-4d7b-87f2-c252d5f40b52', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('769654b1-6c1c-4c7a-a57e-fe5142a750b9', '逊克县', NULL, NULL, 1425, 'e27d8c07-338c-4b1a-b45c-cf9cf0a22a0c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('76988f1d-6023-43cb-90d5-50efe0f071fe', '长顺县', NULL, NULL, 3491, 'ef4b5cd7-d6b5-4839-9963-c010487ba475', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('76a599ad-f836-4b56-a401-af9f68695cdc', '荔湾区', NULL, NULL, 1982, '926eaeaf-e8c5-47f2-89ff-6932b52c87d3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('76ab131d-f803-4f51-ae78-db5b6926e753', '太子河区', NULL, NULL, 4163, 'f856399f-e403-4734-abb9-b972db76c06b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('76b2517c-9c00-48de-9865-b017cf5cb6aa', '营山县', NULL, NULL, 1253, '71643995-698f-4bdf-afe9-09fce8a065c0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('76b9e424-9d58-485f-924f-330f16a6e0f5', '吉安县', NULL, NULL, 4317, '5f548430-51dc-45ad-82e5-bcd0394d8f6c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('76bbaaf8-76b4-44b3-8a57-745fa05cf68f', '大英县', NULL, NULL, 3026, '44b40fc1-5bf4-476c-b869-580342d65c02', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('76d286ad-06e1-45f9-a294-ce78f693c97f', '城中区', NULL, NULL, 3866, 'baa2f053-c419-40c1-93fe-68e081b7f229', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('76eaf090-3d31-4875-a80b-eb6eb6b259be', '凤城市', NULL, NULL, 2798, 'c0064cbf-ba5c-4dc0-a855-b330e096cd61', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('76f1ff01-0a66-4a94-bfc5-3b83ccd07f93', '舞阳县', NULL, NULL, 4133, '55b0b2d6-58e4-40a1-b278-e63aa372ba29', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('76f4eed0-7eaf-4b54-83b9-e8acde733929', '亦庄经济开发区', NULL, NULL, 296, 'd5bceaed-c2c5-4104-a42c-4c9c8114c7c9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('76fb0e68-3c87-40a3-8a1d-966f8f07e986', '高燕乡', NULL, NULL, 2390, '0275a9ca-e89b-4217-b3b0-ada824d9e095', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('77016a95-a410-40e5-9cca-e422503e1710', '晋江市', NULL, NULL, 1863, '0d3bd52a-74b2-4461-9a57-17c7cce4ac1b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7720486b-62bd-4cd4-a67d-ab196dc67140', '江南区', NULL, NULL, 2802, 'b53ced47-2455-44ec-b740-7637148f574c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('772ae4df-ff1b-4dca-b37f-c1a3b70a023f', '新政乡', NULL, NULL, 1106, '79482cd9-7d51-4c89-94c2-4bcd773b8323', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7749a329-3c4e-4f41-bede-6dce98c119f7', '宽城区', NULL, NULL, 318, '096d0f9e-9537-43f8-95f6-8dca9fa4cad4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('775ced4e-cbd7-4244-bbf1-94e7c1498d4d', '泉山区', NULL, NULL, 4426, 'e20441c5-c8b4-493a-9738-2327e656fbcb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('775e6d45-7b0b-49bb-8aad-34b3bc97429e', '磐石市', NULL, NULL, 1953, 'a4031322-7fba-466a-ba72-50082ab248c6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('777234b7-bb43-4b24-967e-1dd24c4e5997', '东澳镇', NULL, NULL, 4487, 'f491d9c3-9527-46a4-8954-6795ff079478', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('777ef7ee-523c-4534-bb46-d903e4268ec7', '团风县', NULL, NULL, 1004, '63a5fa32-35eb-4eca-ab79-f3887e122564', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('77880f5f-ee8f-44c5-a647-d8fd45180844', '西秀区', NULL, NULL, 3622, 'a70a258d-7c8f-4726-a9ef-e2aa7c6247f9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('778bd343-f7b5-4e08-91e6-0288f5b506fd', '蒋场镇', NULL, NULL, 2143, '671275c4-6107-4968-bd8e-96d53e9995b2', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('779bdca0-0f47-4ae8-9b47-d77d859d2cb4', '镇安镇', NULL, NULL, 1128, '72d4f69f-2e4c-4bde-9df8-2aadc9168686', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('77aa43db-55bc-48be-b34d-6e2511570ffc', '新华乡', NULL, NULL, 3381, 'aa2f26e5-9705-4dc0-b54a-a2d7dbb8b511', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('77cd332f-1f28-47a8-8194-c5490e15a37d', '天城镇', NULL, NULL, 4217, '0ee28cef-8dfc-4a9f-b7c1-330bc11c1bb3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('77e73632-9e4e-4eae-a23e-3373690fc43a', '沧县', NULL, NULL, 2886, 'a3c44525-9ccb-429d-a2b7-f5f5d52b8a6d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7819ddd9-65fd-4816-b2ad-3f159e5362b8', '宝兴县', NULL, NULL, 3635, '6af0e8d8-91c9-43be-be32-5ec5c86b14f5', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('782f3f04-6838-4920-bad1-b8a8c2d538ec', '加格达奇区', NULL, NULL, 3042, '1b8b9a84-0955-4d1e-8f33-8de97af3bedd', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7831f848-32b4-4d1d-b994-f4e23b72f1de', '慈溪市', NULL, NULL, 1670, 'c5cc1924-02da-4927-982d-54f0b9f70ef8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('78589c90-7deb-4255-a5dd-8ab4443b16f2', '坊子区', NULL, NULL, 450, '3e54862f-40e4-4b44-b318-6a64b04a9558', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('785fdb77-32e9-4fef-be40-28a8ed8c802f', '惠南镇', NULL, NULL, 2626, '4683d3ef-0edf-425a-98d5-2cb231a7d88a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('78690507-4abb-4ebc-80fe-21c178fd1956', '熊口管理区', NULL, NULL, 839, '24ad0708-80a9-43b1-8e1c-758f2492d3f6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7874423a-accc-432c-a72a-5ab73e069491', '琉璃河镇', NULL, NULL, 58, '0863a0a5-7ac5-4a13-80f5-d31e3a1aa459', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7875d41c-dcdc-4af7-b12e-a839e759fb88', '和顺县', NULL, NULL, 526, '84a16421-f7fb-4f99-b2c0-1e0dea97bf0b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7878fcb4-655a-4324-b447-86e1913a26b8', '三元镇', NULL, NULL, 1924, '442f465d-6566-45e4-9338-50f4395aa6f7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('787eaa2c-3e4b-4e42-b69f-21064ca25865', '龙沙镇', NULL, NULL, 4212, '0ee28cef-8dfc-4a9f-b7c1-330bc11c1bb3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('788e0b8c-c045-4531-9e28-dc0d37023db6', '东明县', NULL, NULL, 1794, 'e04fe06c-7641-47c7-a125-4d35e1800549', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('78a4da02-844c-43e4-adcd-06319d64648a', '翠屏区', NULL, NULL, 1816, '18a8dd20-aad4-43cd-ab48-ab6108097d8a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('78a521da-88fd-4d9e-be90-17d259780be7', '双石镇', NULL, NULL, 412, '9d7d52af-ec34-48e3-b81d-09ac51e11590', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('78bc8363-e9c8-414d-b899-55a6543e68de', '郭村乡', NULL, NULL, 4240, '0ee28cef-8dfc-4a9f-b7c1-330bc11c1bb3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('78c03c3c-82fb-4ce6-b495-5b5b85fe0ddf', '礼县', NULL, NULL, 1368, '7c9ca39d-ce8f-469d-899a-09a0a29c1541', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('78c10f58-fde2-4fa3-87a5-948aa2cf78d2', '佳县', NULL, NULL, 1296, 'c0c88cbd-87ea-4281-9e8e-94a435ae6590', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('78c2bba4-526c-42f1-860f-7ef36787b1f8', '金乡县', NULL, NULL, 2826, '5c8748b9-cee3-4d8e-956c-0d0e24db8850', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('78c4a0b3-fdc5-4385-ba03-0b049a62bb23', '五莲县', NULL, NULL, 2422, '552f7151-162b-4453-a9c5-3a9092fce226', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('78cb8c0a-e7b9-40fe-bcec-a61dd5b6f911', '吉木乃县', NULL, NULL, 3525, '2ca5ebc8-b3f5-49d8-b421-85ae2dc0de35', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('78d505d6-3476-4a64-8d21-d5a3a2356899', '洪湖镇', NULL, NULL, 2089, '4686b935-e3f0-4173-bdfe-ab6a5450d1a8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('78dde201-3b7b-4c03-89fa-4434068cb862', '三江镇', NULL, NULL, 3655, '6581d8db-553e-4417-8c37-91ed47904920', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('78e523f8-ee54-4eec-8c34-023629826978', '塘坊乡', NULL, NULL, 1593, 'ac0e6e50-b6a1-457c-811c-06ac309cd5a3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7900dac1-6450-4ee5-a566-3ca4bf716afb', '舞钢市', NULL, NULL, 3387, 'f5ebab20-0f47-47e8-b896-6f3d9651c97a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('791d2973-43c1-4ca9-b96d-a98b694e2511', '汉南区', NULL, NULL, 430, 'e6e46871-d5a0-4d2b-8243-9d4bd864ab43', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('791dd7d8-b22d-4867-8b3c-ac63c7a7eb45', '正镶白旗', NULL, NULL, 2347, '67723aea-a4ef-4eb7-afbf-55cc07806f98', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('791e309c-f61d-4e45-b5df-6cd035812166', '沙依巴克区', NULL, NULL, 3234, '8349c2b0-91a2-4e19-b9c7-81b5224fbabe', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7938ffa8-88cc-4b78-97e4-1ec0731754b2', '博山区', NULL, NULL, 2446, 'c03520db-2a67-4cae-a658-4806d4254996', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('794194a1-abbf-4ca3-b8c0-404ce3c213d2', '东红农场', NULL, NULL, 1459, '81aab36f-0e28-4ba3-9827-b7033fce9b24', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('798ff798-8021-4c80-a865-3046c9401b2e', '屯门区', NULL, NULL, 486, 'dfb8b556-10a2-43ab-9fdb-66cde92320ee', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('799c8aed-1e3c-45fa-8696-31012b64ead5', '书院镇', NULL, NULL, 2639, '4683d3ef-0edf-425a-98d5-2cb231a7d88a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('79a280bc-2c52-404e-94b6-152b71972ccb', '和庆镇', NULL, NULL, 3202, '2e21ea75-c640-4928-8cb4-e5ba4f6e2ffe', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('79a7cb9d-7662-482c-891d-09989369acd0', '白水县', NULL, NULL, 3170, '9e5ae65c-206f-4d7b-87f2-c252d5f40b52', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('79b7693f-ca24-4900-aaa4-021ac235d934', '草堂镇', NULL, NULL, 1083, '79482cd9-7d51-4c89-94c2-4bcd773b8323', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('79be1007-be29-442c-8051-cecdb91c0292', '石蟆镇', NULL, NULL, 901, '41f376c0-764f-46b9-af35-e555518fc613', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('79d1ef45-c6b6-4ee6-9525-1cf32142f099', '敦化市', NULL, NULL, 1052, '87e1c9be-7455-45a9-ace5-641efce55e22', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('79d9e9f9-0104-4f5b-a9e6-cefe730ddd26', '金凤镇', NULL, NULL, 3544, '99107e35-f7d9-4c45-8d21-7a03b9c2f99d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7a221bd2-995b-4c11-aa70-eff3719cea2e', '开鲁县', NULL, NULL, 1554, '1dc7d092-717c-424e-a473-bb2cc8836b5e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7a22b44d-a0d7-4f1d-b34c-35bbe9af3415', '东台市', NULL, NULL, 4364, 'b85d2a61-b018-431a-9609-2ca0841f5cab', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7a27f77f-2891-4c94-923c-b652b6daadaf', '八宿县', NULL, NULL, 2694, 'b7342349-941d-427d-9ab6-e83a36078088', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7a2a3acf-d6f4-4b46-8134-2cbd9074a305', '建始县', NULL, NULL, 2354, 'ecba10ba-2c25-4ead-a781-ad16a832226f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7a4c1588-504c-41ff-a0a5-6cd82ddb4232', '井冈山市', NULL, NULL, 4316, '5f548430-51dc-45ad-82e5-bcd0394d8f6c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7a502696-bcc9-4286-a0a8-a07a94654b30', '浠水县', NULL, NULL, 999, '63a5fa32-35eb-4eca-ab79-f3887e122564', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7a545d7f-5171-47a0-9c31-f9794c27c370', '深州市', NULL, NULL, 2465, 'b126935b-0423-4bea-b802-d4e6680d1d71', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7a5c7ca0-944f-4f2a-8d3e-b0294471b838', '船营区', NULL, NULL, 1948, 'a4031322-7fba-466a-ba72-50082ab248c6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7a622cd9-dc78-48f5-9abe-b49ed20f8e56', '旺泉街道', NULL, NULL, 3741, 'd1c1539c-b904-4bcc-a034-96213f63d0ff', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7a7e6612-b271-4e95-8791-563b9e69dee4', '卢氏县', NULL, NULL, 4001, 'ba612057-dda4-4e54-9951-f847a74f623e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7a8a9bf4-7052-42d3-babf-ae2b58404224', '寿宁县', NULL, NULL, 2436, '8300a2db-b893-4d51-a009-89478871edf1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7a9959ec-9e06-4ab3-88b1-9abd7dd63f2c', '松溪县', NULL, NULL, 3446, 'dd15d032-477c-4f54-9629-ea782606b468', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7aa06a45-6f88-48d2-b3f4-271adab7c783', '迈号镇', NULL, NULL, 3812, '96fec37f-11d5-4d41-aba4-a36d0652744c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7aae2972-c319-4c8b-94f4-78d4ef9af851', '瑞昌市', NULL, NULL, 109, 'bcaf1f36-5459-4e74-81d1-5026680b1a9c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7ac37302-ed38-4171-a959-2e5a9281c28b', '嵩明县', NULL, NULL, 2863, 'd7efec13-7e84-436d-8390-41868af0e359', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7acdc13f-baf1-4e8e-8dc8-6fbf789fc9ac', '宾阳县', NULL, NULL, 2812, 'b53ced47-2455-44ec-b740-7637148f574c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7ad8083a-6840-4d36-bbe3-fd841b83eba5', '清城区', NULL, NULL, 2957, '8377f1cd-7272-4396-b99b-84bb707dbc2c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7aeb1a7e-1c00-43af-8929-eb25a9661e34', '三道农场', NULL, NULL, 2990, '4b3478d4-3e85-4143-bc6f-ac4a338a9d47', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7afab72e-efdf-4441-a5e1-e276d4f58bfd', '牙克石市', NULL, NULL, 1060, 'c31a65eb-4d77-4b38-8142-9c9e2f54ed46', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7b061fe0-23f2-41cc-b691-8224a64ecb96', '丰城市', NULL, NULL, 4061, 'fa27d3fb-a80f-4b4c-8d0c-bf7d544bb974', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7b0f1f1c-6cd8-46a6-be9c-2d3c52fbe223', '贵南县', NULL, NULL, 4075, 'ed217127-f5a1-4f77-b32d-75d0114bce26', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7b2e06c1-279a-4626-9b64-42119c2f6854', '古交市', NULL, NULL, 104, 'de59cca6-548c-4009-9776-5daae2b866a6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7b2f1649-a3a5-4934-a6be-5dfb4a44b16d', '博白县', NULL, NULL, 2337, 'ee710091-bfa9-4285-89e3-80ad65ebd912', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7b3e6f0f-b730-4940-915c-a857b41d30ec', '南长区', NULL, NULL, 2211, 'e658aec8-1268-4349-a3f5-570b669a4f06', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7b48696c-4b49-48a3-9e66-507db5142640', '青山湖区', NULL, NULL, 1285, 'cf24a0a2-c56e-45df-920c-8247c771d48e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7b5b6590-f326-4e9e-bfc0-b292bb43dc65', '新罗区', NULL, NULL, 3346, '381b5351-4075-4ec0-88cd-f3e1da71c110', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7b8d096a-38cd-4b73-94a8-f8fdd19e71c6', '乐安县', NULL, NULL, 3949, '1e0a806c-ad0b-4e9f-a488-8bf9fc903f4d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7ba12678-06d5-4e3b-924c-b8694a389e2e', '里仁乡', NULL, NULL, 986, 'cc124ed6-091a-42ce-a87a-bb4d0d7357b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7bc07a31-2d43-4b85-9ccb-334c75a50e0a', '定南县', NULL, NULL, 1613, 'dd4a8577-afbe-449b-ae9b-be374a4c7434', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7bca43b3-94e8-4b72-940e-5300bd41a006', '河北镇', NULL, NULL, 56, '0863a0a5-7ac5-4a13-80f5-d31e3a1aa459', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7bca784f-41e9-4fde-83af-bf2ffae801d3', '盘龙区', NULL, NULL, 2855, 'd7efec13-7e84-436d-8390-41868af0e359', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7bcd30c9-bb62-413d-863c-632aaeaa7ddb', '枝江市', NULL, NULL, 1781, '3760382f-ecb5-4ef6-8bd2-049afe34b574', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7c04efd0-703d-4514-9174-f7709a695518', '沁水县', NULL, NULL, 2852, 'ffe07042-807c-4f16-a63c-c1eb8785b06b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7c19adcb-ef9b-4366-b582-da3740466e40', '息烽县', NULL, NULL, 539, '46abe060-5805-4aaf-9d89-b66bed4b224e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7c1b52fa-15d2-4d12-9ac2-0062dabe3a1f', '福贡县', NULL, NULL, 3975, '141f0b1e-0746-4a59-b91a-6356d1352335', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7c210c77-9df0-42bf-8228-0096555bd413', '吉隆县', NULL, NULL, 3651, '5800fbac-51b0-4bc6-bc2b-34f78067fc28', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7c27d936-4b51-4771-b1e6-86994bbc8f7c', '平邑县', NULL, NULL, 4344, '56327d0b-ec26-4f34-8ab6-0eba49931c67', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7c2d717b-610e-46ee-9e3d-bbf26564910b', '托里县', NULL, NULL, 2723, 'a419fd83-e078-4430-aa48-ca9aa67e4fff', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7c32a0ec-24a6-423d-b738-d6eea6d42ca1', '永宁县', NULL, NULL, 4281, '2a45fee0-aa22-4471-be1a-0f6edce52b7a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7c3d1459-ff13-4c7f-8c07-8ef236ef68d5', '中梁乡', NULL, NULL, 1603, 'ac0e6e50-b6a1-457c-811c-06ac309cd5a3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7c3d77f3-adfa-4794-841c-5868f7bafa12', '海丰县', NULL, NULL, 602, 'e11c17b6-eb2f-4d32-9de9-48ab1440c8c7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7c487f6e-ee6d-447d-af0e-5fa8be043c71', '桃源县', NULL, NULL, 4308, 'dd99fcda-6192-4ada-bef5-b04735e7dae8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7c7a2821-ab3e-46de-8141-7b0044079024', '峰岩乡', NULL, NULL, 926, '88260608-a8b9-4b52-a474-1a551465c675', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7c8b3a31-8a76-4ee1-8eee-efd69526e58b', '嘉定工业区', NULL, NULL, 1326, '99c50aa3-ab40-4b1e-addd-f68662f3c560', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7c98d4d5-69ed-4b9e-8fe4-b93587c22cfb', '板桥镇', NULL, NULL, 3608, '46073b56-9ab9-4efb-874f-efe112a304a6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7cb2bb7b-cf36-4ff4-a3a9-e569c6df7c2a', '灵石县', NULL, NULL, 527, '84a16421-f7fb-4f99-b2c0-1e0dea97bf0b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7cc5004b-d2bb-4933-a6c6-7539b8975344', '崇阳县', NULL, NULL, 955, '7a5b4813-b095-4a1a-a008-1297fd9aa978', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7cca76ba-8f28-43a8-95c8-568f863382b4', '棣棠乡', NULL, NULL, 1888, '2c8bc8c3-9317-4f36-a0ad-05a8d6b27053', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7ccfdd0f-c5a7-4d1a-878b-0f5b026eb027', '镇安镇', NULL, NULL, 3263, 'a39ced08-b6e9-4de0-a2db-7a230a673d1e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7cd439b8-5407-4319-9e2f-ee7bbb69a97b', '永靖县', NULL, NULL, 2235, '5d2d5d2f-fd44-47ad-8108-b7f838073fbd', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7cfc8ebb-0c74-4cfc-a5f6-fa5c867e919a', '广灵县', NULL, NULL, 1961, 'c8df6064-e107-46b5-b861-acd5b509b146', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7d028687-1308-48e0-954c-6cf6484c0780', '古城县', NULL, NULL, 3305, '533981ab-21f3-46b9-91a4-320129bd0b49', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7d02e06d-7464-4bd5-975e-81476505263d', '定结县', NULL, NULL, 3648, '5800fbac-51b0-4bc6-bc2b-34f78067fc28', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7d0d31d5-83d9-42c6-a23d-d4d3b65a5c72', '洪湖市', NULL, NULL, 875, '7fe0855f-3ef6-419b-a145-5994fe28cc8f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7d0d6d01-c28b-4c53-88e4-e69ef86abf45', '外郎乡', NULL, NULL, 198, '4f867632-2989-4def-9934-a9c5fe0d5ca5', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7d1797dc-9d08-42d3-a7f7-182d133dd342', '纳溪区', NULL, NULL, 579, '78000393-73bd-4a54-a688-5db0e578d9cd', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7d25b1cc-8e39-40a0-aee7-5ca33eee1149', '青村镇', NULL, NULL, 636, 'fa34c22b-c1d8-45b2-bb1b-4ea08298e7f6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7d2e153b-58ba-4bd6-9e9c-0379e306a6fd', '水土镇', NULL, NULL, 2326, '671d3a34-71bf-42c5-8dda-a813f5ecba22', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7d337564-3161-4b77-b2c2-d9b2dc97129f', '肥东县', NULL, NULL, 156, '6ab7dc5a-1064-4090-a81b-79c3a2e8302d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7d393166-29b7-4f57-aa25-ab9d2aaed333', '长坡镇', NULL, NULL, 1455, '81aab36f-0e28-4ba3-9827-b7033fce9b24', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7d500021-2f35-4944-b2bb-78d76bc6cbb9', '丰县', NULL, NULL, 4432, 'e20441c5-c8b4-493a-9738-2327e656fbcb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7d51bc7a-ca8b-486d-b020-7200265c51e4', '沁县', NULL, NULL, 3860, '6fc78ef9-e2eb-46bc-bf8e-8b830ad96136', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7d52afcb-bb8a-4df7-9392-a05847245d8d', '东路镇', NULL, NULL, 3799, '96fec37f-11d5-4d41-aba4-a36d0652744c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7d57c11e-2d05-4938-8648-ecb23ea95ab3', '宁县', NULL, NULL, 1771, '61cc258d-1868-4356-bcbc-2e8b118745ca', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7d5e50a5-6b9f-467f-88b5-423268ccfe58', '曲沃县', NULL, NULL, 3692, '1aeeea9e-d028-4a96-94ce-ba84cdd3e69f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7d713dac-b1dd-4063-9f02-d44ed44d794e', '南昌县', NULL, NULL, 1282, 'cf24a0a2-c56e-45df-920c-8247c771d48e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7d7fb115-83f0-4f88-8b57-cb610c5aa099', '星子县', NULL, NULL, 110, 'bcaf1f36-5459-4e74-81d1-5026680b1a9c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7de2bf24-a736-4348-89d1-7d04b40dd012', '台前县', NULL, NULL, 1258, 'e16eafe9-9ca0-4609-8c8c-a1b16b52669f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7de6b507-8320-4e82-a8d2-5bbf57c62774', '双滦区', NULL, NULL, 4029, '8db8f645-a1a6-4c39-9c27-2f703951f66d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7dee7c17-b844-4d19-abdd-a971ad11cd2a', '宁南县', NULL, NULL, 3510, 'c8f594a3-8acc-48a9-ba2f-e76934de05eb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7df17aa1-babb-4aa2-981d-591e5fc2aac3', '城区', NULL, NULL, 3569, '5d21af6a-f035-42f4-a0cf-ff1fd3d36f3b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7dfb9e02-2568-418a-b1ac-b7a1f67cc841', '石柳乡', NULL, NULL, 1903, '2c8bc8c3-9317-4f36-a0ad-05a8d6b27053', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7e042298-9157-4612-ad03-1d9e1c09c835', '子长县', NULL, NULL, 3396, 'f95958de-a678-4371-9710-6bcac3f425fa', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7e296680-17b1-4771-b692-86a7009ce98c', '河东区', NULL, NULL, 3062, 'e60d3fe5-6d26-4a3f-b920-8fb6c4986bfb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7e46579e-1592-4d5a-b586-29df66202166', '永兴镇', NULL, NULL, 908, '41f376c0-764f-46b9-af35-e555518fc613', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7e473a19-10ee-48ce-afcd-c79c771510ae', '曲江区', NULL, NULL, 1526, '754500f9-7ec4-4379-8b1c-9370f50564c0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7e5673cb-355d-409a-8122-a6bee519109e', '新市区', NULL, NULL, 2421, '552f7151-162b-4453-a9c5-3a9092fce226', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7e5ded76-82ba-4c39-957f-14a443354286', '桐梓县', NULL, NULL, 3428, '69324865-24e8-4abe-a068-a1392c117c0d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7e87ac9f-3541-4488-beea-00beb6b0364f', '宝兴镇', NULL, NULL, 1644, 'a560b8db-8db1-4bc8-bb6b-fbbecebcaf10', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7e90d8eb-f0f5-489d-8489-068dcc39ea6d', '厚坪乡', NULL, NULL, 2392, '0275a9ca-e89b-4217-b3b0-ada824d9e095', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7e9d4f0c-4972-4d35-8304-f2218ea500f7', '赵家镇', NULL, NULL, 3262, 'a39ced08-b6e9-4de0-a2db-7a230a673d1e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7eaf1296-4dfc-4c77-b859-780d8fafeaeb', '三建乡', NULL, NULL, 1944, '442f465d-6566-45e4-9338-50f4395aa6f7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7eba1e79-69bc-46e3-bc3a-f260fbabdf90', '始兴县', NULL, NULL, 1523, '754500f9-7ec4-4379-8b1c-9370f50564c0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7ed2c0a3-d6a3-4ba8-97de-adfcdd4f67be', '无极限', NULL, NULL, 2780, '334645de-ae54-416a-8978-2dbf9f7bbd09', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7ed37b18-d47c-4ea5-b48e-3232d015925a', '临洮县', NULL, NULL, 3123, 'fc26f78a-1b0b-4967-8d26-df9e530e5260', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7ee35835-0392-4c28-8d6c-771ba288719f', '桥西区', NULL, NULL, 1026, '4d6c5692-82f1-443c-9163-39a3dd77636b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7ef0a83f-7e0f-4c96-9ab6-62f596f3a833', '武安市', NULL, NULL, 207, '237eff18-fe6c-4842-afb1-acb05027a5c1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7ef21f5c-8235-4a58-b097-1a702a29abe6', '延长县', NULL, NULL, 3398, 'f95958de-a678-4371-9710-6bcac3f425fa', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7f036167-d45c-4f5c-b4b4-965567c80397', '永城市', NULL, NULL, 3135, '62aa4f78-f1b9-44d1-9372-21e01c353757', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7f068300-d646-4f3a-8a05-7d1c887dad99', '长埫口镇', NULL, NULL, 3464, 'ea11feaf-194c-4cec-be59-d17bac402db4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7f161228-ad9f-49a4-8798-f8f85f44addf', '田东县', NULL, NULL, 1226, 'f56fa64d-ca06-49d2-a9cb-94742a33af21', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7f214c5b-a0a5-4237-a204-73aa20b5c202', '城区', NULL, NULL, 2319, '671d3a34-71bf-42c5-8dda-a813f5ecba22', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7f5169dc-3155-4fc2-b058-8ddd98695c9c', '阜新县', NULL, NULL, 305, 'fca062e6-ca02-4963-9f79-ed8cbfbb11df', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7f5f30c6-f683-4a7e-9ed1-5255e69fc9df', '临朐县', NULL, NULL, 449, '3e54862f-40e4-4b44-b318-6a64b04a9558', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7f75f4f5-6633-4320-b80c-e2b6858e64dc', '林周县', NULL, NULL, 4152, '5a657ab2-3d76-4a46-917c-ddfe22c60d16', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7f76209c-449a-46b9-b25e-a0ba66f9a26f', '平安乡', NULL, NULL, 1102, '79482cd9-7d51-4c89-94c2-4bcd773b8323', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7f8548d3-4ee2-4bcc-bad7-34981e919815', '寿阳县', NULL, NULL, 524, '84a16421-f7fb-4f99-b2c0-1e0dea97bf0b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7f8df097-fa02-41b0-ba96-b33dc4a51a0a', '虎尾镇', NULL, NULL, 1920, '442f465d-6566-45e4-9338-50f4395aa6f7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7faff035-4141-455f-a129-7e0b92348654', '旬阳县', NULL, NULL, 2978, '55fbb0a6-5436-4d04-9f29-716233f81fd7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('7fc0af84-b195-44e0-82b1-bc49a5aa6174', '桃山区', NULL, NULL, 2003, '9653e91f-7d63-4d36-adcc-4cdbe21dcbea', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('80214572-2619-499d-817a-644567c850dc', '双槐镇', NULL, NULL, 3897, 'a732da28-870c-4d9c-a287-c2c1e3222b59', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('803af4a6-501d-4c02-b98e-d8b6a5cf4bf9', '龙城区', NULL, NULL, 4140, '0c1d1a8a-4eea-4aa0-9a5e-b68ae380a09a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('803e3405-86c2-4d42-a3ae-42c53b5f46df', '慈利县', NULL, NULL, 331, '1af0c5e6-6728-445e-9278-f1eaf5c6303a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8042dc22-ac81-4014-b59d-4429ed1abab8', '祁阳县', NULL, NULL, 1728, 'c7d6739c-4d7d-4d8f-bf6e-d6a6a7d38f20', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('80464c8e-690e-4242-bfde-f9b98d6d5522', '诸暨市', NULL, NULL, 1419, '472589fe-78e1-4c48-8fde-cf3996a778ca', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('80610b44-33ea-4d0b-9438-da02edf7575c', '白玉县', NULL, NULL, 3775, 'c262a40d-a147-4930-b33b-574ec51fa884', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('806c8066-13f5-4727-b603-9b2e1c60c1f7', '沙湾区', NULL, NULL, 2522, '8f917434-e687-4552-b494-0eab3af61900', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('80773842-96a8-4a63-bb0b-6a933f80591e', '岚皋县', NULL, NULL, 2977, '55fbb0a6-5436-4d04-9f29-716233f81fd7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('808355ef-7661-4c67-90d0-90244673945f', '耿马县', NULL, NULL, 519, '88546360-1a0c-4407-9b25-2cde1db643ee', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8093e63d-427c-4014-8521-b67b334be7e9', '经济开发区', NULL, NULL, 4120, '4ff4ef6c-41df-4562-a58f-d8b25b2e3ba4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8098cbab-3247-4634-aa76-954f814f407a', '东乡族自治县', NULL, NULL, 2240, '5d2d5d2f-fd44-47ad-8108-b7f838073fbd', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('80afaeb2-9148-497a-b342-50e77aba12b3', '贡山县', NULL, NULL, 3977, '141f0b1e-0746-4a59-b91a-6356d1352335', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('80d08414-5703-4f6f-a3c1-58a5f9cd0635', '贡井区', NULL, NULL, 1688, '39b19556-caa3-41de-a70f-2d81f23db54d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('80e99712-91d6-4833-95cb-3969defa3d4c', '安溪镇', NULL, NULL, 3839, 'c33c3107-81df-4ced-8b92-d694df412da3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('80ebd7aa-e128-4c55-b570-5c2431e74680', '太安镇', NULL, NULL, 567, '8ae99c85-66b1-406b-8084-9f77cbf73b10', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('80edf1a2-4271-4f7b-b4ea-d0aad159fe7c', '跳磴镇', NULL, NULL, 2785, '40c54e46-4d4f-4d44-95a2-d38a55d0af7b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('811ac290-ec01-4736-a197-02745e43c7f0', '蠡县', NULL, NULL, 2496, '81e22d56-a1c7-4263-be18-81a4af165ae3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8120bfaf-ab0c-46b9-acdc-c9951eb169d7', '华池县', NULL, NULL, 1769, '61cc258d-1868-4356-bcbc-2e8b118745ca', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8121c34a-9963-44b8-9e90-d6e9a9ff91e2', '如东县', NULL, NULL, 1747, '7de09763-759b-437b-a3aa-4cb32bd3c6b9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('813f387a-2cc5-431a-9b50-82ab9f1ab622', '朝阳洞乡', NULL, NULL, 1584, 'ac0e6e50-b6a1-457c-811c-06ac309cd5a3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('81405ea3-0f46-4eb8-8131-e17d2ff9e356', '蜀山区', NULL, NULL, 149, '6ab7dc5a-1064-4090-a81b-79c3a2e8302d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('81445d18-aa62-429a-8744-4e10ead24e59', '甘德县', NULL, NULL, 2648, '292d9fec-f1c5-4100-b5be-fe56a5036e70', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('81555847-72b8-44d2-8448-fff080ff1a42', '南岳区', NULL, NULL, 4268, '75dd761e-ce3f-45bb-a86b-d3a1e2c7629a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('815974a4-351e-4fd1-b247-ff560c3b4b46', '泗洪县', NULL, NULL, 4191, '2263db14-1626-4430-a8ea-bc9c02268004', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('815d961d-d2a5-409c-833e-f4b58ecb84c7', '鞍子乡', NULL, NULL, 1886, '2c8bc8c3-9317-4f36-a0ad-05a8d6b27053', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('81618e2c-488f-4d95-9496-1aeda0211a49', '化隆县', NULL, NULL, 128, '21aca68b-8887-476c-b2b3-fe670c301acc', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8170233e-6619-4e76-80e9-0eae8393a22f', '离岛区', NULL, NULL, 481, 'dfb8b556-10a2-43ab-9fdb-66cde92320ee', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8170987e-46aa-436b-93ae-ad20fb6de13e', '梅江镇', NULL, NULL, 972, 'cc124ed6-091a-42ce-a87a-bb4d0d7357b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8182c35c-30d6-4535-99d5-05bc07fa974b', '猇亭区', NULL, NULL, 1778, '3760382f-ecb5-4ef6-8bd2-049afe34b574', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('819832b9-636c-4018-aa9f-62233d8eb180', '海沧区', NULL, NULL, 1210, '9122834d-aef5-4895-974e-82d2f568bcd4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('81a10373-c160-469d-bc1f-9b6b7628cb4c', '弋江区', NULL, NULL, 3940, '5d5b2d25-fb30-4b3b-baac-c5481ccc67e9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('81a1f041-aae7-4f2d-a028-18be00d46a6a', '文登市', NULL, NULL, 1384, 'e86879a9-9808-4629-8311-39d63744f2fb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('81ada322-2daa-47c7-a305-88086dcde96d', '歙县', NULL, NULL, 4276, 'e3fa5765-1e86-4f89-a751-2f63dbe81c99', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('81b1ac80-14e2-4437-841b-5a7fee8c6809', '钟山县', NULL, NULL, 1464, '6f0d2b72-566f-44e5-969d-2d2ce65ace5c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('81dc3485-6270-4990-ab89-bada278c963d', '宜州市', NULL, NULL, 1156, '509d3498-d5ba-4378-8bee-0baf015c2a11', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8207faf1-28da-4cdc-8a04-61f1a4fe4b02', '肇源县', NULL, NULL, 2367, 'c5e2b320-fd7d-448b-9a02-4fb93e1d3302', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('820da3b6-e429-429b-baa0-5f040251c33f', '色达县', NULL, NULL, 3777, 'c262a40d-a147-4930-b33b-574ec51fa884', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8215079e-ddea-4e8b-9ab6-5ea820a9907f', '县城内', NULL, NULL, 1080, '79482cd9-7d51-4c89-94c2-4bcd773b8323', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('821b3e0d-b598-4c10-bb16-867fa44cb83c', '恩平市', NULL, NULL, 3312, '2a61b8e3-4156-42df-836b-fc855d156f23', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('82253fd6-a454-4511-8e57-a6576f5f9c8c', '惠东县', NULL, NULL, 76, 'f951b5e7-debd-4c51-9c02-03ebe84ebbfc', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8227f1f9-8137-4b04-a48e-939c9f1bae0e', '英山县', NULL, NULL, 1003, '63a5fa32-35eb-4eca-ab79-f3887e122564', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('823fbb43-216c-447d-916a-a7f10ba42286', '阳谷县', NULL, NULL, 355, '56b97c58-86a5-4869-9130-c5dc51ea9a26', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('824fdf48-eaa6-4ff9-9961-cd62e744faf5', '于田县', NULL, NULL, 853, '60e9ec7d-f371-4ea9-ace3-b13c1cd7081c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8264befe-7838-460d-b0be-d3aa38b15578', '双河乡', NULL, NULL, 4465, '4888e1e9-ba45-4254-83e7-87796f338e2d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('82799712-acca-4041-9a27-1624c5d680dd', '安义县', NULL, NULL, 1284, 'cf24a0a2-c56e-45df-920c-8247c771d48e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('828273a7-0232-4d42-a96a-f1de263b392e', '嘉善县', NULL, NULL, 4407, '0118b1e4-bae7-4459-94b9-db6947b14aba', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8299550b-771e-4ef6-bef1-200ac37da123', '富县', NULL, NULL, 3402, 'f95958de-a678-4371-9710-6bcac3f425fa', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('829afae6-2026-4c66-abcd-5690af9082a0', '胜利乡', NULL, NULL, 1591, 'ac0e6e50-b6a1-457c-811c-06ac309cd5a3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('829fcd31-ac61-4266-bfff-010284f6b8f3', '冷水乡', NULL, NULL, 813, '0f559985-f6fe-4a8f-af80-3d0d64932dbc', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('82a7501e-5c93-47b0-9a25-6780170355ae', '京山县', NULL, NULL, 776, '060b2327-c9b1-47ef-a56a-d280d1a4297d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('82a9c0b3-b5ad-456a-9219-9f66f0323e1e', '新荣区', NULL, NULL, 1963, 'c8df6064-e107-46b5-b861-acd5b509b146', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('82acad21-db11-495b-b45f-3131f4e9ba5c', '立才农场', NULL, NULL, 3066, 'e60d3fe5-6d26-4a3f-b920-8fb6c4986bfb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('82bf516f-f953-4dc5-aea9-8527e58303b8', '端州区', NULL, NULL, 1468, '2ca74ae0-5e04-4119-84d8-187921fe4056', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('82e9619b-167f-44f8-84a2-b293bd9d8a30', '黄莺乡', NULL, NULL, 4461, '4888e1e9-ba45-4254-83e7-87796f338e2d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8303c295-fed2-44e0-9e0c-8ba5bde4e965', '牙叉镇', NULL, NULL, 1356, '21bb958f-e5d4-4a71-a350-b5bf2c0e2de0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('832095d6-0400-4947-93ba-11326b1a64ad', '路孔镇', NULL, NULL, 2506, 'd998f8bc-c659-47ce-8e5e-a6b29e03ecb3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('83213f91-c3b5-448f-a686-a29ff4489937', '旅顺口区', NULL, NULL, 4056, 'd83aabcc-3c2e-4b48-962a-c548442bc896', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8323938b-61ee-4bc3-9a28-5140e11a972f', '周嘉镇', NULL, NULL, 1489, '89e8be16-b810-4c7e-89f0-aa9f24483b98', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('833b9b6d-1ac8-431b-8c22-287fc78422e5', '冯坡镇', NULL, NULL, 3808, '96fec37f-11d5-4d41-aba4-a36d0652744c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('833ca6ab-0c73-4e15-9679-6f9a19a8e048', '高新园区', NULL, NULL, 4053, 'd83aabcc-3c2e-4b48-962a-c548442bc896', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('834804b8-ccbf-4917-bec4-3ce5d0bb8f5d', '江孜县', NULL, NULL, 3640, '5800fbac-51b0-4bc6-bc2b-34f78067fc28', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8367d2e7-cc6f-488a-9798-39a9b0341b1c', '全境', NULL, NULL, 2717, '35efbdcb-33ab-4b9c-b3b7-bfde26a8a33c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8368aae7-cb3d-4360-a848-94ed87804875', '港沿镇', NULL, NULL, 3984, 'fcc07455-c69c-4c90-82cb-ddb268adb8a9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('83903a2f-8d6e-433e-b6d1-0ebd1e3643a6', '西安区', NULL, NULL, 2, '7845d9d9-ca44-43a0-93d5-602fdb04ef55', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8397a88a-f1ef-4757-bc15-7da76967a83b', '竹溪县', NULL, NULL, 3933, 'd795e41b-eb16-4383-b762-ea557481f8e1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('839b434b-4718-42b8-9fab-aafec160a51a', '兰西县', NULL, NULL, 3558, 'fcd4a18f-a57a-47c4-b2f2-504bc8bccb20', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('839d24f9-2a64-41c7-bb48-ff50ee79e0d9', '友好区', NULL, NULL, 458, '7ca3412f-b06b-467e-b547-691ab8327b15', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('83a020dc-226f-4c37-9dc3-085e8e919185', '陆丰市', NULL, NULL, 600, 'e11c17b6-eb2f-4d32-9de9-48ab1440c8c7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('83a36cd9-1c7b-40ee-9136-06666c3934ab', '独山县', NULL, NULL, 3492, 'ef4b5cd7-d6b5-4839-9963-c010487ba475', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('83ab82a2-e469-4228-a7a7-9f803c098234', '小板镇', NULL, NULL, 2155, '671275c4-6107-4968-bd8e-96d53e9995b2', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('83aca585-67a5-4a87-98c7-1a207a624ee4', '通渭县', NULL, NULL, 3122, 'fc26f78a-1b0b-4967-8d26-df9e530e5260', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('83aceb4d-393b-4a0b-95fa-a22834acfff3', '寿光市', NULL, NULL, 442, '3e54862f-40e4-4b44-b318-6a64b04a9558', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('83b732d6-e4f4-4b75-ad79-0ae57b438aa7', '万载县', NULL, NULL, 4069, 'fa27d3fb-a80f-4b4c-8d0c-bf7d544bb974', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('83d363a9-b457-45fa-81fa-b3f0ec756a32', '大茂镇', NULL, NULL, 4486, 'f491d9c3-9527-46a4-8954-6795ff079478', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('83dd0aa1-4219-42ca-98b9-f11b9854c682', '合溪镇', NULL, NULL, 943, '88260608-a8b9-4b52-a474-1a551465c675', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('83ec9aca-d85c-47ae-8ca4-633f80a817d2', '暨龙乡', NULL, NULL, 1938, '442f465d-6566-45e4-9338-50f4395aa6f7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('83f079b8-f67a-4657-b17f-69d27b016ff6', '建昌县', NULL, NULL, 961, '1671eb17-f102-4972-9d41-7b1463da334d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('83f33b40-fe39-41f1-8eb0-d84747d15044', '临漳县', NULL, NULL, 208, '237eff18-fe6c-4842-afb1-acb05027a5c1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('83f58800-2c8c-40ab-9483-3f4bcb432c1b', '北苑', NULL, NULL, 1697, '576c43af-0a86-47d9-83a7-4989ce3b3dc7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('840f7981-dd92-4a6b-b6ff-a070a01a83cd', '达拉特旗', NULL, NULL, 3536, 'eb551697-7acc-4bcd-9d21-3d48c16f8258', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8420797c-189f-4a5e-866a-d58337f663f9', '乌兰浩特市', NULL, NULL, 2969, '9758648c-eab9-4434-b7ae-318e7e08548e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8423ccba-b988-43df-a841-c7ba40f2913a', '新镇', NULL, NULL, 66, '0863a0a5-7ac5-4a13-80f5-d31e3a1aa459', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8424a9c8-2c00-413c-99ca-e359169a0ec7', '明达镇', NULL, NULL, 652, 'd7f44c2a-2728-4633-a8b6-7643136bc99d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('844d2cfc-bb0b-456c-ad73-d833b7da0808', '双城市', NULL, NULL, 1530, '349a18f4-4117-490c-b26f-80702a4911bf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('846205ca-dba4-4710-8b83-546f9ba9637a', '东城区', NULL, NULL, 3330, '3bc6861d-0eeb-497e-9257-42f9cd6fd26f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('84623621-35b0-4dbe-b267-867dd798bb09', '南桥镇', NULL, NULL, 4492, 'f491d9c3-9527-46a4-8954-6795ff079478', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('847887e6-116d-4ae1-ab05-60ec23a0ce0b', '田家庵区', NULL, NULL, 2959, '69508f5e-7304-4092-95a4-73d6a9b68eff', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('84790cff-f9b3-429f-8bf0-9e4e3b2c3e69', '民乐县', NULL, NULL, 692, 'dcdb1184-ab1f-4332-8ca0-f4edfd7cc087', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8497f2a1-f32c-40b3-967f-66849c7d7bfc', '站前区', NULL, NULL, 2683, '1c705a6d-5a16-4544-905c-68134716c6cf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('849a5d36-8ea4-469a-a201-bcf1c5090593', '紫阳县', NULL, NULL, 2976, '55fbb0a6-5436-4d04-9f29-716233f81fd7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('84b82828-b13b-47dd-adc8-f3a9727bbe57', '临武县', NULL, NULL, 1311, '50d6a2ea-ba0d-4ff5-8b4c-f9d84e79e381', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('84bc6fc8-cbcd-473b-80e2-78b0ab5c3dcc', '九寨沟县', NULL, NULL, 1187, 'd56c2ee6-b81c-4df8-ba2f-3df7680243c4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('84cf050c-63a3-4281-983c-658deaf44263', '楚雄市', NULL, NULL, 2100, '50868d97-8741-48fe-9cba-86e2e118f220', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('84d0fb61-83fc-4260-a844-474f5f478fe3', '太龙镇', NULL, NULL, 4216, '0ee28cef-8dfc-4a9f-b7c1-330bc11c1bb3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('84d1e3e7-4c81-40bd-8c99-19b3a1ab52a6', '青羊区', NULL, NULL, 1804, '4f073365-4e02-459f-8b32-cad88dd22637', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('84d77659-bd50-462b-b05e-4963e492d1e0', '马湾镇', NULL, NULL, 2153, '671275c4-6107-4968-bd8e-96d53e9995b2', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('84f74a83-a54f-4f64-bc91-1ce03266f4d9', '昌北区', NULL, NULL, 1281, 'cf24a0a2-c56e-45df-920c-8247c771d48e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('851edefb-643e-496a-bdca-e4534f6d001f', '义县', NULL, NULL, 1074, '99f84690-670c-4a0e-ade1-ebcf17b00adb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('85230151-8071-4e46-94d8-a1965d780dd7', '兴安区', NULL, NULL, 3282, '978f3e32-c5e0-48e4-b9ba-4f7f04ed87a1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('85243b10-ab72-4eb3-8330-50712e084e4a', '肃北县', NULL, NULL, 2427, '42852584-118b-41cf-ba7e-db28102a593a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('85344607-e048-4835-beaf-7c7009d03a12', '安远县', NULL, NULL, 1608, 'dd4a8577-afbe-449b-ae9b-be374a4c7434', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8547d55c-5536-4d3a-aa23-bf01d5081cba', '通城乡', NULL, NULL, 1597, 'ac0e6e50-b6a1-457c-811c-06ac309cd5a3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('85557866-08d3-4cd2-bfe9-25304902bb45', '茶园新区', NULL, NULL, 2259, 'd17f8f8e-b3dd-4818-a89d-8b431ff5c555', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('85654b83-cce2-4024-af9f-c3bfbdfe9c60', '白土镇', NULL, NULL, 4201, '0ee28cef-8dfc-4a9f-b7c1-330bc11c1bb3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8565c190-5c54-43d2-9467-b33017adf6fe', '喀什市', NULL, NULL, 2032, 'e6436d79-8045-4185-b2b2-22cd280d22b0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('857a9277-47f3-400d-963c-e33f4c6ba49b', '龙虎山风景旅游区', NULL, NULL, 1339, '20a1443b-429b-4c83-83ca-2c9de2bd67b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8594eb4a-3852-44fe-8a03-b6ccfec32338', '中沙群岛', NULL, NULL, 350, 'e6678936-cb1f-4a28-9b29-fb553d2adf87', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('85b82ebb-5165-448f-af6c-1fa95a123f3c', '西固区', NULL, NULL, 4043, '2d364b6d-2931-4d45-995a-336e4e0f2b55', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('85d9e42a-0519-40d6-a9bf-5f3d5b0a7596', '佛罗镇', NULL, NULL, 2559, 'a1e3332c-7029-4de7-a221-40c041a9a620', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('85f3379b-fd49-419d-bbbb-a483c45d9035', '井陉矿区', NULL, NULL, 2771, '334645de-ae54-416a-8978-2dbf9f7bbd09', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('85f9e6ed-d623-4d10-92fb-9ecf0b56099e', '南岔区', NULL, NULL, 457, '7ca3412f-b06b-467e-b547-691ab8327b15', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8601c06d-c05f-4f8a-8725-9b90dbca1e0b', '开平区', NULL, NULL, 2455, '4f4c1ef4-f54d-4ba4-a124-ca2d3d0ddb78', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8609c413-fc93-4f5b-a93e-80d5af133ac9', '碑林区', NULL, NULL, 4291, '29595f0b-301d-42da-845d-01afb30a9c18', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('86312c42-3157-4197-9697-03659744d359', '安次区', NULL, NULL, 1234, '86f7f02d-658e-44ec-9d36-b14cc3c65aaf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('86321d6f-2c5b-4125-98cc-02f187be676d', '通什镇', NULL, NULL, 10, 'c8bf9a67-2bfc-47fe-9580-3f2f2eac1edb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8643c7f0-ddc3-4e7b-91bd-ceca07b10062', '剑河县', NULL, NULL, 3087, '6d3a8433-1273-4323-a3eb-d39effecc1d7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('86452d06-9596-4ee0-a3f5-a160e0c96f4e', '徐泾镇', NULL, NULL, 2540, '89a9c37c-487a-4c32-968c-cf9fefad8151', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('864c47b8-cd24-45e6-ab52-04aa0cad434d', '鄂城区', NULL, NULL, 4078, '657fcfcb-2cbe-4a17-8c6f-184169cfeb6f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('864f1a0f-d67c-482f-8552-174e5a1cb02e', '城区', NULL, NULL, 715, '0be5e1cb-cdb0-48ca-9f82-47f7f4c6dd2e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('865fe0ef-5a04-4b69-8a48-46252eac91fb', '元阳县', NULL, NULL, 3157, '99a9abd1-f107-4dc6-ae43-e9d1120504b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('866319da-ba9d-45ab-902f-44ae5d41b341', '朗县', NULL, NULL, 2583, '23ca0ede-0d68-4451-afde-afd774149ec4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8666d804-6735-4450-a2d7-86403c911b0a', '华宁县', NULL, NULL, 4143, '2b997404-05c1-436b-8004-2d5dfd364db3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('866708b8-33a9-4f72-b630-e0b228138b3d', '兴隆华侨农场', NULL, NULL, 4498, 'f491d9c3-9527-46a4-8954-6795ff079478', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('867003ad-db82-4db9-aa50-fbc0956077a7', '尖草坪区', NULL, NULL, 102, 'de59cca6-548c-4009-9776-5daae2b866a6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('86745c77-f3e2-4a99-9cdc-c2ab6e30d3e4', '南澳县', NULL, NULL, 1445, '8596baaf-4bfe-4522-a422-f397f3494bcb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('86838f0e-baf0-4eff-a787-47632c2a00d6', '历下区', NULL, NULL, 4355, 'c6ac73d4-9854-403a-9b61-12c22eeb4903', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('868dfbc1-4e27-4c0b-a1a8-7e6a8b255509', '会文镇', NULL, NULL, 3798, '96fec37f-11d5-4d41-aba4-a36d0652744c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('869e20cd-8a59-4904-9025-02af74d3f42c', '南岗区', NULL, NULL, 1542, '349a18f4-4117-490c-b26f-80702a4911bf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('86a1609d-8b5e-46a9-9ad1-8c628e53e27c', '波莲镇', NULL, NULL, 717, '0be5e1cb-cdb0-48ca-9f82-47f7f4c6dd2e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('86a6ab83-70d5-47e7-8b18-e8defc0a6a4a', '津市市', NULL, NULL, 4305, 'dd99fcda-6192-4ada-bef5-b04735e7dae8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('86d4ffde-8bed-433c-8eba-ffb6492f376b', '新华区', NULL, NULL, 2899, 'a3c44525-9ccb-429d-a2b7-f5f5d52b8a6d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('86d72a23-0573-4045-a314-c568943de084', '石狮市', NULL, NULL, 1853, '0d3bd52a-74b2-4461-9a57-17c7cce4ac1b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('86dcb0e0-b845-4cfb-8ec1-2b4c53667a28', '中山镇', NULL, NULL, 910, '41f376c0-764f-46b9-af35-e555518fc613', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('86e2b33c-3f2a-4808-9e72-b12e085b31ba', '南雄市', NULL, NULL, 1520, '754500f9-7ec4-4379-8b1c-9370f50564c0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('86e789e6-1430-4757-9d21-1304df5144ed', '皇桐镇', NULL, NULL, 720, '0be5e1cb-cdb0-48ca-9f82-47f7f4c6dd2e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('87088d2f-54d1-4f37-873b-8626f7b30c87', '驿城区', NULL, NULL, 751, 'a096e337-c439-4751-a014-b49dd13bee26', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('870acfb9-8bd8-4793-b8af-8d6d4e9eee23', '遂平县', NULL, NULL, 747, 'a096e337-c439-4751-a014-b49dd13bee26', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('871bd3ff-79a6-4559-86a4-47027d7055fc', '公平镇', NULL, NULL, 1086, '79482cd9-7d51-4c89-94c2-4bcd773b8323', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('871df424-d9f3-4feb-843b-6e3ec67d6050', '南海农场', NULL, NULL, 1573, '5f7e2e46-8a4e-4463-907c-5762bcd006a8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('87248ebc-7328-4617-ac3f-b898d8c3f94f', '柳江县', NULL, NULL, 2749, '0f2ba543-1d40-4b41-b700-6b53a9622b5b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('873234d3-6144-45ea-b9e6-87fd2ac02d27', '班玛县', NULL, NULL, 2650, '292d9fec-f1c5-4100-b5be-fe56a5036e70', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('873c4331-a3ca-4cf2-a7af-6eb3d9631363', '秀洲区', NULL, NULL, 4409, '0118b1e4-bae7-4459-94b9-db6947b14aba', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('873cf650-24d9-490a-9ae7-312508332ddb', '新丰县', NULL, NULL, 1525, '754500f9-7ec4-4379-8b1c-9370f50564c0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8746ebb2-590d-4f3d-8361-45afd641be00', '涡阳县', NULL, NULL, 1978, '9c7fcb3f-9d15-445a-944f-d2231a75f23d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('87472a13-722b-400f-b8e8-4b48868bc3a5', '张镇', NULL, NULL, 3743, 'd1c1539c-b904-4bcc-a034-96213f63d0ff', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('874fd88a-4c9a-44af-aefa-43deb28bb5d4', '金川区', NULL, NULL, 3354, '0f534d39-ac41-4416-8f72-8ca7e6ad951d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8751c17a-04c7-48bc-9da8-5a6f6edd8f50', '庄浪县', NULL, NULL, 30, '4edd328e-68af-4f0e-bca8-63686e5cad24', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8751c953-a04e-4150-9f14-cf37513f2a30', '加来农场', NULL, NULL, 728, '0be5e1cb-cdb0-48ca-9f82-47f7f4c6dd2e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8753791a-ba67-4db8-9637-610aaf077a5c', '栗子乡', NULL, NULL, 1939, '442f465d-6566-45e4-9338-50f4395aa6f7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('87647185-e99a-4b18-bd05-4a083f52084f', '木洞镇', NULL, NULL, 42, '43c813e3-8672-45c5-8d3e-9ee43dbe51c8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('87679c0d-4c17-43a1-936e-84e4cf9c983a', '黄岛区', NULL, NULL, 3712, '1e53830d-8cdb-4111-8da6-987131b873ed', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('87713d9f-4aa3-417a-bcb1-d5d7ab1c5bcd', '海尾镇', NULL, NULL, 785, 'af6f4f65-b2db-4670-88ca-21de1de477fc', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('87729454-a07f-4de0-8573-35f0c5ca68e3', '鹰手营子矿区', NULL, NULL, 4039, '8db8f645-a1a6-4c39-9c27-2f703951f66d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8772c804-4bb4-4238-b471-af34dfc533ac', '工布江达县', NULL, NULL, 2578, '23ca0ede-0d68-4451-afde-afd774149ec4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8775c640-9609-4b38-b26e-151e30e7eab1', '石河镇', NULL, NULL, 2159, '671275c4-6107-4968-bd8e-96d53e9995b2', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('87769094-04a2-4957-b611-81cd8371460f', '宁陵县', NULL, NULL, 3136, '62aa4f78-f1b9-44d1-9372-21e01c353757', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('878a011a-b565-42a0-86d8-4b2996605476', '乌石农场', NULL, NULL, 2279, 'b3792f06-9c78-446e-b6ac-d95d5e9092e8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('87a88924-b95d-4130-a10d-cef2fda88d6c', '永兴县', NULL, NULL, 1313, '50d6a2ea-ba0d-4ff5-8b4c-f9d84e79e381', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('87a968b4-92d9-41f2-8c2c-d0296465787d', '天星寺镇', NULL, NULL, 37, '43c813e3-8672-45c5-8d3e-9ee43dbe51c8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('87a998d4-fdaf-4f54-9bca-efa1120c8c65', '城关区', NULL, NULL, 4151, '5a657ab2-3d76-4a46-917c-ddfe22c60d16', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('87b47ded-81f6-4caf-aa92-fbb0f3e4bf35', '通川区', NULL, NULL, 1005, '6681b8cd-3740-4dbd-b311-143871994e15', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('87ce5c59-3d77-4e0f-bd6a-06662ba622bc', '葛城镇', NULL, NULL, 2380, '0275a9ca-e89b-4217-b3b0-ada824d9e095', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('87e3a51c-ae1c-4120-ba9d-6c38048a5203', '安国市', NULL, NULL, 2482, '81e22d56-a1c7-4263-be18-81a4af165ae3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('87f1bc4c-8245-4f5a-bc29-60f5f4085e86', '绩溪县', NULL, NULL, 1047, 'a489375e-6a4e-410b-be41-f687ba6c52cf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('881c3333-26d3-4bd3-ae74-91f37c66d920', '锡山区', NULL, NULL, 2213, 'e658aec8-1268-4349-a3f5-570b669a4f06', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8827debe-e850-4fed-b7b2-7ecf9e8476a5', '中建农场', NULL, NULL, 4334, 'e98653ba-264e-4417-b74e-e0798b25e646', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('883d0d49-bd8b-44ca-bd93-6b2e097c5fe1', '陆良县', NULL, NULL, 1332, '9568bdcc-65c2-4b1c-a512-b2ff897db321', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('884317cc-05c5-43b7-968f-ab1d0724a417', '康马县', NULL, NULL, 3647, '5800fbac-51b0-4bc6-bc2b-34f78067fc28', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('88548dc9-d46d-4f2b-907c-a6b7937726f6', '双江镇', NULL, NULL, 566, '8ae99c85-66b1-406b-8084-9f77cbf73b10', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('885ef346-0adc-4d1d-a00d-ffc2b27b8768', '云雾乡', NULL, NULL, 1108, '79482cd9-7d51-4c89-94c2-4bcd773b8323', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('88635802-389c-436d-8930-64a974720e1a', '马龙县', NULL, NULL, 1328, '9568bdcc-65c2-4b1c-a512-b2ff897db321', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8887d1fd-0bb4-449a-be16-07bcbf81ee0f', '郊区', NULL, NULL, 3852, '6fc78ef9-e2eb-46bc-bf8e-8b830ad96136', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('88889976-3854-44d8-b181-01afcd39b126', '高州市', NULL, NULL, 695, '88bc9baa-b7fd-4bf4-a896-4e049185e0c2', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8888b844-48cb-4a37-af09-c4be40b3af3c', '白市驿镇', NULL, NULL, 3539, '99107e35-f7d9-4c45-8d21-7a03b9c2f99d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('88a14f57-d6b0-4b6d-b364-2fe3cab2ea17', '石会镇', NULL, NULL, 3368, 'aa2f26e5-9705-4dc0-b54a-a2d7dbb8b511', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('88b3cfda-1cb6-45a4-9e20-fd4e7d7d7844', '大庄科乡', NULL, NULL, 1514, 'd5ab951d-20ab-46ff-8838-de5efe06b6b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('88ca78fc-7a97-43f0-afe1-d4872907c2e2', '万冲镇', NULL, NULL, 2552, 'a1e3332c-7029-4de7-a221-40c041a9a620', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('88d02a9a-3d46-48a5-a1d5-df59e684632a', '镜铁区', NULL, NULL, 245, 'eff5ed18-ee14-4201-876c-3c40dd858438', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('88f9fa75-6960-4b19-88c4-11c18267c06e', '黄柏乡', NULL, NULL, 4237, '0ee28cef-8dfc-4a9f-b7c1-330bc11c1bb3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('88fc5d6c-0103-4994-9d11-549a7fc10739', '广饶县', NULL, NULL, 1214, '1de2a515-79f9-47f9-a31f-f6892f97a705', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8900d532-a726-4cc1-a23f-a82f47a3238d', '溧阳市', NULL, NULL, 4007, '4a5fccf3-5d70-4b0b-85ef-c2a8e5fdfadc', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8906a14f-cd2b-4f38-9ffd-b40e76569d6a', '城区', NULL, NULL, 856, 'f09dfd05-ae12-4875-8ff6-98901e8e7c28', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('89096651-6f55-4388-beca-5bff6d233d82', '二道江区', NULL, NULL, 871, 'def0f6fb-9804-4bed-8554-2115bfca9849', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('891d14ea-3f85-465f-ba31-f1ccfbf2e6d6', '峨边彝族自治区', NULL, NULL, 2529, '8f917434-e687-4552-b494-0eab3af61900', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8928ce72-d0b3-48a1-8e55-a1c758dedb35', '伊吾县', NULL, NULL, 2069, '89e63cc0-6828-4bfd-9e6c-e5752f3cc837', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('892ebec9-3cee-48c7-8e5e-1a343e547f4a', '庙行镇', NULL, NULL, 770, 'c470aa47-a334-4df9-a8ea-b90683ddc861', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('893cf7f8-57e4-4bd5-bd45-79173f62a05f', '兴峰乡', NULL, NULL, 2680, 'e509a1a5-95da-4fb2-9a2b-f84afa05a36c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('894456f9-6d02-47fb-9df6-f6c20321294a', '伊通县', NULL, NULL, 686, 'de003161-c00c-4f8a-ac92-6a2188069e9b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('894a2f81-55df-4fad-9e8d-2125b5112dd5', '阿瓦提县', NULL, NULL, 4400, 'b7bc3a10-ad00-4b20-9fa4-cb08ad7492d3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('894dbc04-2106-49c3-8e4e-bec22305bdae', '康乐镇', NULL, NULL, 1088, '79482cd9-7d51-4c89-94c2-4bcd773b8323', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('89506fe5-d465-452e-888d-666f54043d7a', '禹州市', NULL, NULL, 3564, 'c2e61b39-2188-4b9c-a36f-ef7b600b0188', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('898e9aab-06c3-4334-8df2-b01741f9b02d', '波密县', NULL, NULL, 2581, '23ca0ede-0d68-4451-afde-afd774149ec4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('89989cff-df54-49a4-96b8-fe8ad8d59af6', '青白江区', NULL, NULL, 1803, '4f073365-4e02-459f-8b32-cad88dd22637', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('89ac1009-e31a-48a9-9fa9-c41a91da6d34', '肖家镇', NULL, NULL, 3878, 'a732da28-870c-4d9c-a287-c2c1e3222b59', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('89b1d473-c953-4919-982c-35396dcab7ab', '昌江区', NULL, NULL, 2409, 'f02f3013-3723-48cb-9461-451981c81059', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('89b2050c-2572-4a5d-aff3-335f00c4bde6', '大溪乡', NULL, NULL, 981, 'cc124ed6-091a-42ce-a87a-bb4d0d7357b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('89b9c477-78ad-4077-a01d-0322a657b2b1', '册亨县', NULL, NULL, 3107, '875ed189-3d32-4466-a24f-7cbac524774e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('89c4f6f8-7ddf-48e0-96bf-26731c947cd4', '武陵镇', NULL, NULL, 4218, '0ee28cef-8dfc-4a9f-b7c1-330bc11c1bb3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('89e64e38-49e1-4b40-a0c9-0bc906c40a81', '北海新区', NULL, NULL, 297, 'be93aa9b-d81f-4e98-a0c0-18f840594a05', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('89f709e6-5fa8-439e-b609-7e13207aa1d6', '夹江县', NULL, NULL, 2527, '8f917434-e687-4552-b494-0eab3af61900', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8a08494d-1b72-4481-8479-3477e7d2204b', '大进镇', NULL, NULL, 3246, 'a39ced08-b6e9-4de0-a2db-7a230a673d1e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8a18ec22-fac9-441e-854a-6f2f7f11172d', '黄潭镇', NULL, NULL, 2146, '671275c4-6107-4968-bd8e-96d53e9995b2', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8a2541ea-6612-446c-95ac-6c88c038ee9a', '谷城县', NULL, NULL, 1345, '52d3ef0d-d999-4ae8-971b-534a2b25de02', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8a2a732f-98ce-4df3-bed1-cfbddc2e092e', '天桥区', NULL, NULL, 4353, 'c6ac73d4-9854-403a-9b61-12c22eeb4903', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8a333a1a-29d2-4026-8bd0-2c94c0f3264a', '红土乡', NULL, NULL, 1099, '79482cd9-7d51-4c89-94c2-4bcd773b8323', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8a41a70a-19f0-4d1d-b825-fe1e6a6e34f0', '铜山经济技术开发区', NULL, NULL, 4434, 'e20441c5-c8b4-493a-9738-2327e656fbcb',
        1, 'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8a427db4-3a93-434c-a975-4504a9e116b7', '江池镇', NULL, NULL, 1921, '442f465d-6566-45e4-9338-50f4395aa6f7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8a4cb030-9062-4330-9e26-dae9707242e3', '西沙群岛', NULL, NULL, 351, 'e6678936-cb1f-4a28-9b29-fb553d2adf87', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8a5f89d1-cfc9-4b05-a334-8b8bb19757e0', '白茅湖农场', NULL, NULL, 2162, '671275c4-6107-4968-bd8e-96d53e9995b2', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8a772c6c-4013-46c1-aa19-51d3c7e0e92b', '中瑞农场', NULL, NULL, 1572, '5f7e2e46-8a4e-4463-907c-5762bcd006a8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8a80f843-450c-4953-bcc9-4c3c8cb38815', '荥阳市', NULL, NULL, 4123, '4ff4ef6c-41df-4562-a58f-d8b25b2e3ba4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8a8e70e1-bf02-4a53-8d6b-8b36e41a7d39', '小渡镇', NULL, NULL, 571, '8ae99c85-66b1-406b-8084-9f77cbf73b10', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8a8ed840-8212-44f8-a037-f145b3757ba5', '灵寿县', NULL, NULL, 2775, '334645de-ae54-416a-8978-2dbf9f7bbd09', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8aa13be9-740e-4add-99d4-b93ed04407c0', '芮城县', NULL, NULL, 4110, 'fc30b5e5-3005-4778-94f7-706b31514bff', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8aa5d166-b219-47ac-9d70-cdac73f03f6e', '甘孜县', NULL, NULL, 3772, 'c262a40d-a147-4930-b33b-574ec51fa884', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8aa85705-bb0b-4b1a-a5db-5c2063201499', '宁国市', NULL, NULL, 1044, 'a489375e-6a4e-410b-be41-f687ba6c52cf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8ab4b900-279c-402c-a927-ff0def8ba013', '神湾镇', NULL, NULL, 2193, 'f2727650-b0d9-4541-acdb-b4eabf894893', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8acb3a02-ff96-4b8d-b626-eb1a9005d77d', '万木乡', NULL, NULL, 2946, '465e9ea2-a2f2-4b42-95dd-b48d91f67105', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8acee998-2b01-49bd-8448-e4690d0e3284', '吉首市', NULL, NULL, 3787, 'b9b94634-b449-4449-9581-c70550dc5099', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8ad3f3be-9adb-448d-8cc6-49b8680cedf1', '朱衣镇', NULL, NULL, 1094, '79482cd9-7d51-4c89-94c2-4bcd773b8323', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8adcb819-1db8-453c-8858-a729bf28e4bc', '青龙乡', NULL, NULL, 1941, '442f465d-6566-45e4-9338-50f4395aa6f7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8ae0f102-a890-493b-a92c-9f4d9d503aa1', '梓潼县', NULL, NULL, 392, 'efb72ec7-b29f-48d0-a16c-9a33d3938d49', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8af71bd6-40ce-46dd-884f-b2510b4d27bf', '青田县', NULL, NULL, 2376, '982c089d-7fb7-4cdc-a3c2-865e4637006f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8afa8d8d-dded-449a-89aa-43a20a6516a7', '胡场镇', NULL, NULL, 3463, 'ea11feaf-194c-4cec-be59-d17bac402db4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8aff6a94-4e96-4330-a0ca-d5be241d8ed9', '林西县', NULL, NULL, 4475, '4b199fdb-3a49-40f7-9843-8bd43f4ea30c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8b0b1819-8723-4c2a-96c2-1081c80f0e40', '走马镇', NULL, NULL, 4228, '0ee28cef-8dfc-4a9f-b7c1-330bc11c1bb3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8b0dafc3-8335-4d32-b6cb-c24c19e8820f', '策勒县', NULL, NULL, 852, '60e9ec7d-f371-4ea9-ace3-b13c1cd7081c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8b12c8c2-4b23-4ad2-8d61-f4958e478eb8', '仁怀市', NULL, NULL, 3426, '69324865-24e8-4abe-a068-a1392c117c0d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8b2e16d0-cf99-4bc7-b993-aa464160f8fb', '汝南县', NULL, NULL, 748, 'a096e337-c439-4751-a014-b49dd13bee26', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8b30144c-c6ab-435b-9ff0-f2cbc0974716', '霍山县', NULL, NULL, 282, '4ee9594e-d779-4cad-a3bc-d766de26628a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8b51c7c1-25cf-4456-bde6-5d565c4bebbb', '岷县', NULL, NULL, 3120, 'fc26f78a-1b0b-4967-8d26-df9e530e5260', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8b57cb40-3085-41fa-9b5c-38114b62bc72', '石龙镇', NULL, NULL, 49, '43c813e3-8672-45c5-8d3e-9ee43dbe51c8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8b78ae16-6a3d-4de3-bfdc-5b1d444ab422', '达日县', NULL, NULL, 2649, '292d9fec-f1c5-4100-b5be-fe56a5036e70', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8b8d4ae7-2df2-47d6-9b8d-e87f60f5d899', '后坪乡', NULL, NULL, 4460, '4888e1e9-ba45-4254-83e7-87796f338e2d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8b9e4dd9-10f6-4c4a-b2d9-f9dc67810639', '代县', NULL, NULL, 2833, '18b3c51b-f699-467d-a342-d78bf9cff362', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8ba88c47-bdd8-4130-9e6e-186a5e64447e', '启东市', NULL, NULL, 1751, '7de09763-759b-437b-a3aa-4cb32bd3c6b9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8bcb0afc-b99f-48f1-b483-e02b760e9a97', '讷河市', NULL, NULL, 2732, 'f4e36f9a-e006-44a6-8d77-47971d41810b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8bd1a0b3-ad5f-48de-9fa4-735ec49076ae', '获嘉县', NULL, NULL, 2179, '1aabde9d-2b04-4892-a20d-5b4e3efaeedf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8bf2b234-4175-4b85-a828-79f3a907b2ba', '光明新区', NULL, NULL, 675, 'fd718129-208d-4a94-9e52-7516af8ef013', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8bfbdb6c-f901-4218-88d0-05056a2664ba', '吴川市', NULL, NULL, 2601, '5c5b11a0-6a29-4173-b876-8fdbc543cb2b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8bfd0412-0be6-4e3b-b0b3-e77b692ab815', '蒲洼乡', NULL, NULL, 60, '0863a0a5-7ac5-4a13-80f5-d31e3a1aa459', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8c2b7d8f-175f-471e-b875-fd1ad2084b3f', '周宁县', NULL, NULL, 2441, '8300a2db-b893-4d51-a009-89478871edf1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8c543782-1f37-43cd-a281-d19b69a1b850', '东阿县', NULL, NULL, 358, '56b97c58-86a5-4869-9130-c5dc51ea9a26', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8c57816d-8991-462f-91ee-fb46da541003', '大同县', NULL, NULL, 1955, 'c8df6064-e107-46b5-b861-acd5b509b146', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8c5b7e0b-d987-431d-8348-344b19e0e081', '滨湖区', NULL, NULL, 2218, 'e658aec8-1268-4349-a3f5-570b669a4f06', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8c613923-396e-44da-a355-273102e6d2a3', '六环以内', NULL, NULL, 2564, '727ca4ab-f7fc-49fb-9b2b-569d2fc79aa4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8c7475d2-5850-43f1-a12a-39268eb40736', '渔薪镇', NULL, NULL, 2145, '671275c4-6107-4968-bd8e-96d53e9995b2', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8c975e91-666b-4322-9532-6ea11d0a3f69', '清澜镇', NULL, NULL, 3813, '96fec37f-11d5-4d41-aba4-a36d0652744c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8c97b9b3-515c-4d3e-bc9d-9be32ba9fdff', '调楼镇', NULL, NULL, 725, '0be5e1cb-cdb0-48ca-9f82-47f7f4c6dd2e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8c9b6cc9-a475-4241-9e01-8e60cbabc40b', '河嘴乡', NULL, NULL, 809, '0f559985-f6fe-4a8f-af80-3d0d64932dbc', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8ca33789-2707-4019-b9e4-a7ba6fcf6ffc', '嘉黎县', NULL, NULL, 4414, 'fae5ed6b-9b68-4ef9-93fa-221dea13a975', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8cc855a6-80df-4abd-9159-5437da29422b', '城区', NULL, NULL, 2171, 'c35b997d-64f4-42d2-92c6-a0090291ed08', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8ccb33bb-5978-4023-a15f-a8e9f60c422d', '南滨农场', NULL, NULL, 3067, 'e60d3fe5-6d26-4a3f-b920-8fb6c4986bfb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8ccbaa60-192d-4c8a-8d7a-b2e15597b6c0', '天宁区', NULL, NULL, 4003, '4a5fccf3-5d70-4b0b-85ef-c2a8e5fdfadc', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8cec1d69-9a76-4a7c-add4-2bf8a908afdf', '经济开发区', NULL, NULL, 2304, 'f3e12d68-f8c5-4d9d-8314-dd1ce7dac2f9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8ceefa5c-a6f5-4969-981f-2faa949cc31a', '镜湖区', NULL, NULL, 3939, '5d5b2d25-fb30-4b3b-baac-c5481ccc67e9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8d1ad1ac-9c8c-498c-97a1-ada9d4d3e6dc', '织金县', NULL, NULL, 2616, '55fdf7c7-6698-498a-8aef-b9455ab7926c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8d310e79-ba1d-4bd4-bb7f-1b5d1c28671d', '渭城区', NULL, NULL, 2102, 'e42fbad8-c29e-4f35-878d-95a667b5cc90', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8d356d48-a6a8-4870-831f-d00032c044f2', '天和镇', NULL, NULL, 3242, 'a39ced08-b6e9-4de0-a2db-7a230a673d1e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8d3d1919-0b79-45ff-8746-445b40f95acf', '溆浦县', NULL, NULL, 2019, 'd133a3fc-3db0-426f-8a04-e25b44a5565c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8d5f4c72-3b39-4ec1-8c42-122601c77976', '人和镇', NULL, NULL, 179, '4f867632-2989-4def-9934-a9c5fe0d5ca5', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8d62afbb-2381-49c6-b413-d0285d9f6df7', '利州区', NULL, NULL, 505, '74a706f1-82bb-4132-8ee4-9abf7bd809cb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8d6d261e-8132-41e1-9c69-b7ad0b8d93bc', '安达市', NULL, NULL, 3554, 'fcd4a18f-a57a-47c4-b2f2-504bc8bccb20', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8d79a480-d37d-4892-85c6-c56929ee5a3a', '大树镇', NULL, NULL, 1084, '79482cd9-7d51-4c89-94c2-4bcd773b8323', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8d7b85fb-f42a-4124-be58-c2c30682799f', '贵定县', NULL, NULL, 3484, 'ef4b5cd7-d6b5-4839-9963-c010487ba475', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8d7b8f42-e95b-428e-9c7f-78524ba3e580', '怀仁县', NULL, NULL, 2065, '49bad2d2-0c83-48ed-9985-7a709362f3a8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8d7eb3f4-d95c-4353-b8a7-11cdf845cd02', '界石镇', NULL, NULL, 39, '43c813e3-8672-45c5-8d3e-9ee43dbe51c8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8d84a922-3cb9-4fa0-b29d-ac05dba90d7e', '临江镇', NULL, NULL, 3253, 'a39ced08-b6e9-4de0-a2db-7a230a673d1e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8d924ade-2ecc-4e25-b839-ba0c2995251b', '蕲春县', NULL, NULL, 996, '63a5fa32-35eb-4eca-ab79-f3887e122564', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8da0edf6-9cdc-4126-991b-675fbacdb5b1', '井陉县', NULL, NULL, 2772, '334645de-ae54-416a-8978-2dbf9f7bbd09', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8dad212a-b736-4644-bf29-4e10b1ccc66e', '汶川县', NULL, NULL, 1183, 'd56c2ee6-b81c-4df8-ba2f-3df7680243c4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8db25f9a-a54e-4b7f-b5fc-6d725854b0db', '札达县', NULL, NULL, 2904, '3a856f9e-a1e5-4657-b81e-cc7d76d14ff5', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8dcac6fe-d52c-428e-8247-4d2f5899839a', '大方县', NULL, NULL, 2615, '55fdf7c7-6698-498a-8aef-b9455ab7926c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8dd45dc7-e90f-4957-a903-12c3e1586da0', '名山镇', NULL, NULL, 1923, '442f465d-6566-45e4-9338-50f4395aa6f7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8de89da0-bd3a-47ca-8fdf-2298850e0823', '黄龙县', NULL, NULL, 3404, 'f95958de-a678-4371-9710-6bcac3f425fa', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8df24a1e-36b8-4cb1-9b3e-aab2d59b4e23', '鹿泉市', NULL, NULL, 2760, '334645de-ae54-416a-8978-2dbf9f7bbd09', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8e010900-8515-430e-a527-60c767b3dffb', '长汀县', NULL, NULL, 3348, '381b5351-4075-4ec0-88cd-f3e1da71c110', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8e1fac4d-7467-41a2-a383-ae9104ea0d28', '清河县', NULL, NULL, 1033, '4d6c5692-82f1-443c-9163-39a3dd77636b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8e52d247-b38c-42c2-b2d2-5371c28a7e9d', '六环以外', NULL, NULL, 4379, '27537995-4520-4156-95b5-b3d1e368a5dc', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8e65f55b-173a-4e0e-a6e9-970970f5ca3c', '小店区', NULL, NULL, 98, 'de59cca6-548c-4009-9776-5daae2b866a6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8e6c650f-3d23-47c1-a100-6fabb8cbbdb0', '尉犁县', NULL, NULL, 3174, '0ce20b86-8bea-4d7c-a1e4-09c7519d8b16', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8e6fb351-ac4c-4a1c-a2b9-0aed3c38df4e', '七宝镇', NULL, NULL, 4021, 'f6eb800d-2093-4ce2-8105-3747d69abe97', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8e78e1e9-731c-42e4-ae17-90d9ac7444d9', '双河口镇', NULL, NULL, 38, '43c813e3-8672-45c5-8d3e-9ee43dbe51c8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8e79ed9d-0e95-4ab4-a149-0f9e3ad2ecd2', '浦北县', NULL, NULL, 3421, 'd6095cf5-28d0-419b-a799-9a3c87594720', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8e843b5d-e845-431b-9b56-6db1965a1fc2', '修文县', NULL, NULL, 538, '46abe060-5805-4aaf-9d89-b66bed4b224e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8e864216-aaaa-43e7-9393-12b6628f6424', '闽清县', NULL, NULL, 4254, '71a49c5c-c3c2-4fcb-8f90-aa1d733a19f7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8e9f4145-c0fb-4dc0-b1fd-2b5a8d97a0ce', '新华区', NULL, NULL, 2762, '334645de-ae54-416a-8978-2dbf9f7bbd09', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8ea6b03f-41a6-4e29-ad88-b91ab1911eb9', '鼓楼区', NULL, NULL, 4424, 'e20441c5-c8b4-493a-9738-2327e656fbcb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8eb1a5d1-874a-47ef-85ca-9cc3ddfe1c13', '渭沱镇', NULL, NULL, 3896, 'a732da28-870c-4d9c-a287-c2c1e3222b59', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8eea8013-4c1d-43e0-846f-8d4af3245b34', '大城县', NULL, NULL, 1237, '86f7f02d-658e-44ec-9d36-b14cc3c65aaf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8efc0b6c-38aa-4b8a-9dd4-f42578bb8b01', '五台县', NULL, NULL, 2836, '18b3c51b-f699-467d-a342-d78bf9cff362', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8f22b1b7-1ba1-489c-bb6f-fbc1085430b2', '西沱镇', NULL, NULL, 802, '0f559985-f6fe-4a8f-af80-3d0d64932dbc', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8f445d24-d032-4210-9534-ea9453a69327', '新桥镇', NULL, NULL, 3815, '96fec37f-11d5-4d41-aba4-a36d0652744c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8f4e3d63-c548-45a9-8db0-40f305a1122d', '七叉镇', NULL, NULL, 786, 'af6f4f65-b2db-4670-88ca-21de1de477fc', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8f52e26c-9f92-4da7-a8e7-9cf4db54240a', '大柴旦行委', NULL, NULL, 3009, 'a638060f-a01c-4c77-b905-b46ef8d3e89d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8f7485a6-b365-4f8f-8d6a-60af9f5d399a', '茄子溪镇', NULL, NULL, 2783, '40c54e46-4d4f-4d44-95a2-d38a55d0af7b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8f87569f-5109-4b1c-acde-27baac5aed81', '金坛区', NULL, NULL, 4006, '4a5fccf3-5d70-4b0b-85ef-c2a8e5fdfadc', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8f901854-37d5-4d4b-86a2-155d22c96401', '土主镇', NULL, NULL, 3906, '7fefd2bf-99e0-43f5-bc37-9ab15ee8e8f3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8f95f536-5dd3-429a-8065-a89d39407404', '复盛镇', NULL, NULL, 1718, '86ab4d11-9653-4b0d-8cc1-2e12a4de15d6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8f9ca979-3a86-4be7-868b-fdf4459c492d', '南宝镇', NULL, NULL, 723, '0be5e1cb-cdb0-48ca-9f82-47f7f4c6dd2e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8fa3209d-b36f-4b2e-b270-3ecd59f2dfa4', '水城县', NULL, NULL, 3551, 'd80168e9-9b95-4dbe-8977-d2e37c07e946', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8fa93513-e339-4a69-880d-eb9d2222370a', '三山区', NULL, NULL, 3946, '5d5b2d25-fb30-4b3b-baac-c5481ccc67e9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8fc4052c-c2e1-49b3-b484-ff012be4058f', '奇台县', NULL, NULL, 1273, '8db1e665-1af9-4697-8514-7fa18e3a8683', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8fdbbae0-8acd-438c-906f-c11872b78c41', '青河县', NULL, NULL, 3524, '2ca5ebc8-b3f5-49d8-b421-85ae2dc0de35', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8fea5d3b-8865-4b7c-a7d8-d6b90ad74b53', '黎母山林业公司', NULL, NULL, 2292, 'b3792f06-9c78-446e-b6ac-d95d5e9092e8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8feaa006-5d89-49ad-b67c-a30d4c3e188a', '睢宁县', NULL, NULL, 4430, 'e20441c5-c8b4-493a-9738-2327e656fbcb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('8febcee0-21cb-4d05-ae9c-9afd246db1ac', '安阳县', NULL, NULL, 2573, 'd94ce52b-fe8c-47d7-9b1a-d37da377cbbe', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9006b299-5802-4979-bf42-6db6e63ca9a5', '乐都县', NULL, NULL, 125, '21aca68b-8887-476c-b2b3-fe670c301acc', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9007c44f-d3d1-41f8-80cc-8e4bd772c93b', '长洲区', NULL, NULL, 3041, '01d0a041-f2c0-4416-b710-9376b2aabcaf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('901a19ee-c0e4-4c97-ac3d-f88ee6625c2b', '卧佛镇', NULL, NULL, 569, '8ae99c85-66b1-406b-8084-9f77cbf73b10', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('901ad921-0afc-43b0-bc4f-9d977db85fd3', '凭祥市', NULL, NULL, 3028, 'c99528d5-bed7-4890-b547-f2159ed13a78', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('903f0ae5-3909-4147-9079-81c36d76e38a', '龙潭镇', NULL, NULL, 2922, '465e9ea2-a2f2-4b42-95dd-b48d91f67105', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9042b8c9-8e8d-4e24-b167-433ccf45914e', '坡头区', NULL, NULL, 2599, '5c5b11a0-6a29-4173-b876-8fdbc543cb2b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9042c8e8-a738-49a5-90a9-7164d21818f8', '松潘县', NULL, NULL, 1186, 'd56c2ee6-b81c-4df8-ba2f-3df7680243c4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('904d9467-6308-4d60-a1a6-aac36ca594fd', '高要市', NULL, NULL, 1470, '2ca74ae0-5e04-4119-84d8-187921fe4056', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('906b7bd7-069d-41ca-a1b5-027c82bca35c', '庆隆乡', NULL, NULL, 3849, 'c33c3107-81df-4ced-8b92-d694df412da3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('906c07ab-5e3c-4023-b4d3-ba778092eee0', '拾万镇', NULL, NULL, 1647, 'a560b8db-8db1-4bc8-bb6b-fbbecebcaf10', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('907b0296-2abc-467c-9712-3b089208d9f0', '洋渡镇', NULL, NULL, 2672, 'e509a1a5-95da-4fb2-9a2b-f84afa05a36c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('908b61b4-9171-4dad-a05c-3f397ae378e6', '崇义县', NULL, NULL, 1617, 'dd4a8577-afbe-449b-ae9b-be374a4c7434', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('908d92af-d53b-4b59-92c5-c384d93b4388', '延平区', NULL, NULL, 3451, 'dd15d032-477c-4f54-9629-ea782606b468', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('909ccc8f-07a3-4982-85f2-c6a6df03f724', '但渡镇', NULL, NULL, 2079, '4686b935-e3f0-4173-bdfe-ab6a5450d1a8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('90a0956a-14d3-466f-84f9-728506f1852e', '乌龙乡', NULL, NULL, 1599, 'ac0e6e50-b6a1-457c-811c-06ac309cd5a3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('90bbb230-e943-45d4-b3b0-41697283554a', '黄溪镇', NULL, NULL, 3363, 'aa2f26e5-9705-4dc0-b54a-a2d7dbb8b511', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('90c7d86b-2ec8-4aca-b169-f6209896e944', '龙滩子镇', NULL, NULL, 1638, 'a560b8db-8db1-4bc8-bb6b-fbbecebcaf10', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('90d6d805-20c4-41f5-9f1a-52b94c770965', '蓬莱镇', NULL, NULL, 3797, '96fec37f-11d5-4d41-aba4-a36d0652744c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('90daadf0-41d5-4963-a597-1f2f472eb2f8', '金竹乡', NULL, NULL, 812, '0f559985-f6fe-4a8f-af80-3d0d64932dbc', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('90dfd4f6-0a07-4440-a7c2-8798949f5d4d', '普安县', NULL, NULL, 3106, '875ed189-3d32-4466-a24f-7cbac524774e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('90e9966b-8de2-489f-8992-d64b18df97aa', '迁乔乡', NULL, NULL, 1897, '2c8bc8c3-9317-4f36-a0ad-05a8d6b27053', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('90f0e1a1-664c-4126-b90f-16b6fb06dfa9', '密山市', NULL, NULL, 2416, 'f583e1ae-7239-4815-b3c7-c5538eb73da9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('911eaa57-040d-4821-8c35-12a5d22dc6a7', '连平县', NULL, NULL, 1724, 'a9736c65-aeba-4a39-861f-5edf105d8673', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('912a64d8-7322-4783-b85f-c89bce9fb5ce', '九江县', NULL, NULL, 108, 'bcaf1f36-5459-4e74-81d1-5026680b1a9c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('912d715d-80c5-4c54-95c8-ab5fe371183d', '通榆县', NULL, NULL, 3100, '7af2dfc0-6d0b-4da1-a6c9-fa505dbc6e9b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('913a6f96-3c8b-4ba3-9bb2-f09c0b926c63', '全境', NULL, NULL, 2800, 'f5314eed-cd10-44d2-b656-d62d633c813d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('91562cae-4658-4396-bd64-7887b2c1e81d', '城区', NULL, NULL, 763, 'c470aa47-a334-4df9-a8ea-b90683ddc861', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9162362a-d082-4ddd-a515-a86ae11f72f1', '高邑县', NULL, NULL, 2776, '334645de-ae54-416a-8978-2dbf9f7bbd09', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9176ce03-3001-4498-b567-04af87c53e79', '崇安区', NULL, NULL, 2210, 'e658aec8-1268-4349-a3f5-570b669a4f06', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('917ee10d-4912-4eb6-89db-f50faccd7814', '城区', NULL, NULL, 921, '88260608-a8b9-4b52-a474-1a551465c675', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('919ad987-33a4-4a51-b3a4-ec4634b3bead', '绿园区', NULL, NULL, 321, '096d0f9e-9537-43f8-95f6-8dca9fa4cad4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('91aff7c0-df22-44fc-8e89-8a4ce9c46894', '老新镇', NULL, NULL, 833, '24ad0708-80a9-43b1-8e1c-758f2492d3f6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('91b704c0-9a71-462b-9141-0b01df950809', '清流镇', NULL, NULL, 2514, 'd998f8bc-c659-47ce-8e5e-a6b29e03ecb3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('91bb0c34-b067-48b8-9e1d-41431fdcabea', '凤山县', NULL, NULL, 1158, '509d3498-d5ba-4378-8bee-0baf015c2a11', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('91d14159-4505-4b85-ba8f-a689884fb2e1', '旌德县', NULL, NULL, 1043, 'a489375e-6a4e-410b-be41-f687ba6c52cf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('91d20fcb-7429-4fa0-9f2d-0d17f3c3587b', '城区', NULL, NULL, 3862, '6fc78ef9-e2eb-46bc-bf8e-8b830ad96136', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('91dc65e0-8ad8-4ad2-84d7-90a2ea891c0f', '抚远县', NULL, NULL, 1401, 'a03ec6c9-8a1e-456b-bab9-164f8015c723', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('91e5044f-2e04-4e14-8556-1ba747b77b4a', '海港区', NULL, NULL, 2714, 'f4bc760a-86e0-4fa1-a5e9-cdc21cc7a127', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('91e57369-ef3c-4f53-8b35-b2c191eecb10', '扶绥县', NULL, NULL, 3029, 'c99528d5-bed7-4890-b547-f2159ed13a78', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('91f33d16-f161-41a6-a1a9-9191be389b52', '蔡甸区', NULL, NULL, 423, 'e6e46871-d5a0-4d2b-8243-9d4bd864ab43', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('920cb19e-4929-4cce-b165-42519653c695', '望谟县', NULL, NULL, 3104, '875ed189-3d32-4466-a24f-7cbac524774e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('920e5b40-c479-4490-93c5-2d2e62b142a2', '大竹县', NULL, NULL, 1010, '6681b8cd-3740-4dbd-b311-143871994e15', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9223093b-41ff-4150-be56-74d87fcd0cf0', '梅子垭乡', NULL, NULL, 1885, '2c8bc8c3-9317-4f36-a0ad-05a8d6b27053', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('92314600-5484-455d-94aa-c3174b82825c', '蚌山区', NULL, NULL, 880, 'be39aa7b-a993-4abd-956c-dcb299cc7bc3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('924b087a-1089-4dfa-9584-187b1a18b4f0', '燕窝镇', NULL, NULL, 3894, 'a732da28-870c-4d9c-a287-c2c1e3222b59', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9255f6c8-58c4-43ad-9412-cf9164bbbbb4', '龙州县', NULL, NULL, 3033, 'c99528d5-bed7-4890-b547-f2159ed13a78', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('925cb9ad-d9ed-4923-a59e-72b8a728274e', '岑巩县', NULL, NULL, 3091, '6d3a8433-1273-4323-a3eb-d39effecc1d7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('92856779-f85b-462b-b884-1448ff8d7bb3', '龙华镇', NULL, NULL, 900, '41f376c0-764f-46b9-af35-e555518fc613', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('928a5285-6771-47bf-9431-b8bee302914b', '射洪县', NULL, NULL, 3025, '44b40fc1-5bf4-476c-b869-580342d65c02', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('928ac6f1-6248-49d5-8fe5-1c1d60cdca17', '矿区', NULL, NULL, 2119, 'c3c4411b-8905-45b4-b38f-09be90102664', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('929010bb-01b2-46e5-82f6-4bc3e4241499', '阳朔县', NULL, NULL, 3188, '796bb0e0-6b76-4c1d-801f-2dbcbab74087', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9290d57f-ea05-4f19-8f52-309470527e60', '静宁县', NULL, NULL, 24, '4edd328e-68af-4f0e-bca8-63686e5cad24', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9291e09c-3f06-4903-82fa-22626c5e9b10', '富川县', NULL, NULL, 1466, '6f0d2b72-566f-44e5-969d-2d2ce65ace5c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('92931d03-613e-4530-af1c-0252a4bec3f4', '走马乡', NULL, NULL, 1913, '2c8bc8c3-9317-4f36-a0ad-05a8d6b27053', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('92b08630-f4c9-4f32-a5b8-ea0d5358856e', '政务文化新区', NULL, NULL, 162, '6ab7dc5a-1064-4090-a81b-79c3a2e8302d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('92b57eb1-58ef-4fe7-8337-ccba79eb6372', '天峨县', NULL, NULL, 1157, '509d3498-d5ba-4378-8bee-0baf015c2a11', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('92b7da46-fdaa-4b48-8c6b-c44fadef11f1', '大洼县', NULL, NULL, 1999, '9d95b0ef-0bbc-404d-80d4-2143f433a4c2', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('92b85172-225b-4f7a-8a4a-f85c471d3ad7', '内环以内', NULL, NULL, 2786, '40c54e46-4d4f-4d44-95a2-d38a55d0af7b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('92ba101c-d863-4965-bdc2-9c2f501c5a0e', '渭源县', NULL, NULL, 3125, 'fc26f78a-1b0b-4967-8d26-df9e530e5260', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('92bbea78-32df-4ee2-a891-50b8054fe3ce', '道外区', NULL, NULL, 1543, '349a18f4-4117-490c-b26f-80702a4911bf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('92de68d4-552c-488a-aad5-58ad308474f8', '江北区', NULL, NULL, 1674, 'c5cc1924-02da-4927-982d-54f0b9f70ef8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('931a1372-5141-4519-9775-60fd0796ef57', '都匀市', NULL, NULL, 3482, 'ef4b5cd7-d6b5-4839-9963-c010487ba475', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('931c657b-74e9-4af7-8da6-724d33a1ea8c', '西培农场', NULL, NULL, 3218, '2e21ea75-c640-4928-8cb4-e5ba4f6e2ffe', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('932a1d96-97d8-419c-bc0f-2414f9ef6a52', '桐乡市', NULL, NULL, 4405, '0118b1e4-bae7-4459-94b9-db6947b14aba', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('932f19bf-863e-487a-aaef-c027ce1c0bcf', '东新区', NULL, NULL, 2303, 'f3e12d68-f8c5-4d9d-8314-dd1ce7dac2f9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9332ada4-fddb-420f-9c3d-0f8812c44565', '南彭镇', NULL, NULL, 34, '43c813e3-8672-45c5-8d3e-9ee43dbe51c8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('934e20e9-a832-4476-9993-7b34d4bd39e8', '调兵山市', NULL, NULL, 2793, 'def78b05-5d2b-430c-b268-442502dc3ca5', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('934fce38-ffb6-4619-9dfb-24f46a74498c', '旺苍县', NULL, NULL, 509, '74a706f1-82bb-4132-8ee4-9abf7bd809cb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('93677beb-f21c-4f11-ac38-cc3f5ea6c74a', '塔什库尔干县', NULL, NULL, 2043, 'e6436d79-8045-4185-b2b2-22cd280d22b0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('936e3be1-4966-4c7e-ad04-082069f003c3', '石船镇', NULL, NULL, 712, '97942649-3cc7-4e4a-81b4-9a8c82f82ea7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('93704e2a-324b-47a5-93b2-bcaf3bad31eb', '古浪县', NULL, NULL, 336, 'eea322d8-1faf-4a08-a7f9-1d097375a96d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('93728c99-ef1e-4d3b-9bf2-fc6c8f952280', '大安镇', NULL, NULL, 2553, 'a1e3332c-7029-4de7-a221-40c041a9a620', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('937a2b2c-1271-40cc-a1e6-0a78a47ae50f', '汝城县', NULL, NULL, 1309, '50d6a2ea-ba0d-4ff5-8b4c-f9d84e79e381', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9380984e-f2ee-499f-b925-b733597e1bbe', '甲高镇', NULL, NULL, 1087, '79482cd9-7d51-4c89-94c2-4bcd773b8323', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('93828e08-a4f2-40fb-861a-aed60089f9ec', '卷洞乡', NULL, NULL, 1139, '72d4f69f-2e4c-4bde-9df8-2aadc9168686', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9393c3e3-f505-40a0-b9c1-200c5275792a', '黄陂区', NULL, NULL, 426, 'e6e46871-d5a0-4d2b-8243-9d4bd864ab43', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('93bf0b5e-a6bf-4733-9a61-7c944509b931', '得荣县', NULL, NULL, 3782, 'c262a40d-a147-4930-b33b-574ec51fa884', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('93d63d79-c6f0-4aa3-825e-fbd700b46d3f', '麻涌镇', NULL, NULL, 3340, '3bc6861d-0eeb-497e-9257-42f9cd6fd26f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('93e75a8a-0fdc-443c-a1db-65efc60e1fc6', '蒙城县', NULL, NULL, 1977, '9c7fcb3f-9d15-445a-944f-d2231a75f23d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('93ec343b-e565-4dae-af0c-ebfa9b82b5ff', '市中区', NULL, NULL, 1993, '7e24b0e5-bf57-4e62-880a-e5b6ec159053', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('93f0a2fd-a952-4432-8a62-54ae21f7c824', '太平镇', NULL, NULL, 1484, '89e8be16-b810-4c7e-89f0-aa9f24483b98', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('93f9b692-7e05-4afe-bba2-8b4a26e207ed', '李溪镇', NULL, NULL, 2921, '465e9ea2-a2f2-4b42-95dd-b48d91f67105', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('93f9e857-686b-4dcc-94a9-71e660413270', '新干县', NULL, NULL, 4320, '5f548430-51dc-45ad-82e5-bcd0394d8f6c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9409276a-9c1c-432a-9bc7-071e2dea01af', '伊滨区', NULL, NULL, 1179, 'b5a118ad-786c-4d86-b4e8-5d25a3776a78', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('941a5c19-2e2d-4ca9-8535-05e59860b474', '城区以外', NULL, NULL, 248, '6c067928-5765-4455-9019-74593fd0e11d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('94258651-4075-43a3-8cdb-fea803e15baa', '左岚乡', NULL, NULL, 2403, '0275a9ca-e89b-4217-b3b0-ada824d9e095', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('94319be1-6276-4867-95e7-305a4586225a', '石墙镇', NULL, NULL, 949, '88260608-a8b9-4b52-a474-1a551465c675', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9449730e-0375-4121-9bf7-832a7fb083c7', '万古镇', NULL, NULL, 1650, 'a560b8db-8db1-4bc8-bb6b-fbbecebcaf10', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('944d838a-59d8-4a78-9fca-682997aeaadc', '龙湾屯镇', NULL, NULL, 3730, 'd1c1539c-b904-4bcc-a034-96213f63d0ff', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9451786b-b33a-4231-819b-8d42771c3b49', '高东镇', NULL, NULL, 2633, '4683d3ef-0edf-425a-98d5-2cb231a7d88a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('94610535-3660-427d-9022-14e5f7666e55', '复平乡', NULL, NULL, 670, 'd7f44c2a-2728-4633-a8b6-7643136bc99d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('947569b6-4156-4e0a-be79-501263de4b33', '德兴市', NULL, NULL, 493, '8bf55045-9366-4acb-b884-bca672ff9644', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('949e010c-f2f2-43f6-8e22-96a311d8b5e4', '大亚湾区', NULL, NULL, 74, 'f951b5e7-debd-4c51-9c02-03ebe84ebbfc', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('949fcc55-dcc4-470f-87d3-3445def1e38b', '老城区', NULL, NULL, 1182, 'b5a118ad-786c-4d86-b4e8-5d25a3776a78', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('94b9fa3b-a0e9-4a7e-b0e6-d06a43279947', '小周镇', NULL, NULL, 4220, '0ee28cef-8dfc-4a9f-b7c1-330bc11c1bb3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('94c1740b-9d99-4c80-baf6-b07c9105092a', '诏安县', NULL, NULL, 1201, 'bda1d0f2-1476-4e0d-8fb9-2d1392397cbb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('94c60687-4f38-4a3d-b6df-72409046ab4b', '广德县', NULL, NULL, 1046, 'a489375e-6a4e-410b-be41-f687ba6c52cf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('94ccacb5-ffbe-422f-b974-ee2a5cfb6d81', '石安镇', NULL, NULL, 656, 'd7f44c2a-2728-4633-a8b6-7643136bc99d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('94dd4b9c-188d-4fd6-82a9-6e726d9d1131', '三溪乡', NULL, NULL, 1498, '89e8be16-b810-4c7e-89f0-aa9f24483b98', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('94e76a98-f4e6-429a-82f7-c09a7f3f1f65', '安胜乡', NULL, NULL, 663, 'd7f44c2a-2728-4633-a8b6-7643136bc99d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('94eb2ca3-c9aa-480e-ae96-a3e33270174e', '砀山县', NULL, NULL, 4101, '94f58cdc-52ca-4a35-a822-4b62ab8bd3d7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('94efbe4a-abc7-4f11-b0fb-ad610912d68e', '开阳县', NULL, NULL, 537, '46abe060-5805-4aaf-9d89-b66bed4b224e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('94f20a15-e88a-4274-8084-868a199cb573', '木林镇', NULL, NULL, 3732, 'd1c1539c-b904-4bcc-a034-96213f63d0ff', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('94fb3a51-e064-4680-9ea4-a7bc3fa91c74', '乡城县', NULL, NULL, 3780, 'c262a40d-a147-4930-b33b-574ec51fa884', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('950325ef-e983-47c7-8c2c-859c6988231f', '梅里斯区', NULL, NULL, 2728, 'f4e36f9a-e006-44a6-8d77-47971d41810b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('95143221-886f-47dd-b5d6-7307e2e426b1', '涂井乡', NULL, NULL, 2679, 'e509a1a5-95da-4fb2-9a2b-f84afa05a36c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('951688b2-bff9-4872-b4a2-f08b07afbf82', '饶河县', NULL, NULL, 2256, '69696549-d65b-4e13-80ef-05ecaf0f61e3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('95221e75-32a0-4268-8f2c-cb3db86d047f', '石碣镇', NULL, NULL, 3338, '3bc6861d-0eeb-497e-9257-42f9cd6fd26f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('952b9d9e-fcf3-459b-bdaf-dfb86ae820c5', '小河镇', NULL, NULL, 2924, '465e9ea2-a2f2-4b42-95dd-b48d91f67105', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('953ad9ae-be56-48fa-9bb5-d7d1139a1c4c', '大学城', NULL, NULL, 3903, '7fefd2bf-99e0-43f5-bc37-9ab15ee8e8f3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9542a120-1e47-49b4-83df-be424671dccf', '苍梧县', NULL, NULL, 3036, '01d0a041-f2c0-4416-b710-9376b2aabcaf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('954b961d-8751-4860-a695-b923df6f97e6', '新乐乡', NULL, NULL, 793, '0f559985-f6fe-4a8f-af80-3d0d64932dbc', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9553fa02-a48e-4b22-9f40-4e31d9f4c227', '眉县', NULL, NULL, 1836, '7c3fbad9-df03-4d15-93a4-695924a2f35d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9571c5df-0096-48a6-952b-2ebc4a9cc7da', '揭东县', NULL, NULL, 1741, '03f84ef3-e7e9-4c0d-a1ab-b4170505bcaf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('95940496-7d84-46b4-b7b3-9d3210aa2d27', '株洲县', NULL, NULL, 2609, 'cdeda821-2101-44e1-a986-183436199f05', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('959f3b2a-64e4-45d7-bac4-8823034dc50c', '上甘岭区', NULL, NULL, 470, '7ca3412f-b06b-467e-b547-691ab8327b15', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('95a27c14-7d6a-43cf-9b4c-601615a5b5a2', '凤岗镇', NULL, NULL, 3324, '3bc6861d-0eeb-497e-9257-42f9cd6fd26f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('95b501c8-08c8-4692-adc4-1f02acb128a8', '洮南市', NULL, NULL, 3099, '7af2dfc0-6d0b-4da1-a6c9-fa505dbc6e9b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('95ba4279-599d-4285-92fc-1f4ae9b7b6f5', '泗县', NULL, NULL, 4099, '94f58cdc-52ca-4a35-a822-4b62ab8bd3d7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('95badb5b-cfdb-4adb-8f53-ef330ae183c4', '民勤县', NULL, NULL, 338, 'eea322d8-1faf-4a08-a7f9-1d097375a96d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('95bae31e-6a0c-42cd-9cba-e6bcc47aff21', '东山区', NULL, NULL, 1738, '03f84ef3-e7e9-4c0d-a1ab-b4170505bcaf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('95c20ccc-e760-4bf9-b36c-7840b6440c9a', '保亭研究所', NULL, NULL, 2987, '4b3478d4-3e85-4143-bc6f-ac4a338a9d47', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('95cf3ef6-14a7-4253-a063-6b7c0795097a', '和硕县', NULL, NULL, 3177, '0ce20b86-8bea-4d7c-a1e4-09c7519d8b16', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('95cfa209-4b8d-4d59-815b-bc0b5819b60d', '泊头市', NULL, NULL, 2887, 'a3c44525-9ccb-429d-a2b7-f5f5d52b8a6d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('96040af0-1600-4413-9559-cc909a8b7f9b', '托克逊县', NULL, NULL, 2880, '674106ce-5cae-4104-9851-34997d094c8a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('96117dea-68ea-4027-821a-b8a2d3997a32', '南浔区', NULL, NULL, 4194, 'af4299a6-6902-4c79-bc49-f7b3f3c6f683', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9617b408-5761-4548-897a-6af0a2ce0b99', '资溪县', NULL, NULL, 3953, '1e0a806c-ad0b-4e9f-a488-8bf9fc903f4d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('963f8344-10ed-4d92-993a-a9d0a47db4c8', '加查县', NULL, NULL, 1020, 'f7038861-43d2-49c3-a5c9-53fde2c139fa', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('967b4ef3-e923-4da9-a1e6-7a04efadd5ba', '绥宁县', NULL, NULL, 3757, '30ce87bd-09cc-4250-9b5e-1f5916ce4d70', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9686439a-df3f-4deb-8ac6-729985772b09', '缙云县', NULL, NULL, 2371, '982c089d-7fb7-4cdc-a3c2-865e4637006f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('96ac21b1-fa50-4ef5-8061-fc9b132dfb61', '镇康县', NULL, NULL, 515, '88546360-1a0c-4407-9b25-2cde1db643ee', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('96b03e75-3e8f-41ca-8f34-fc2b4afb2e99', '淮南高新技术开发区', NULL, NULL, 2966, '69508f5e-7304-4092-95a4-73d6a9b68eff',
        1, 'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('96caace7-1f7c-4d7b-86cd-c34e8f57fdea', '新泰市', NULL, NULL, 1245, '23df07d6-66e4-474e-b42b-258f50d7b0e4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('96ce0e20-8aa8-4fdf-ba49-7933f94a2760', '怀来县', NULL, NULL, 147, '37614653-bf6c-458f-a844-540790491eb1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('96eb541c-86a4-4f23-b14b-6e92a4e87640', '汇川区', NULL, NULL, 3424, '69324865-24e8-4abe-a068-a1392c117c0d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9700d4bc-3ecf-48c8-901b-815dc269deee', '大场镇', NULL, NULL, 764, 'c470aa47-a334-4df9-a8ea-b90683ddc861', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('97047536-7087-48af-8dd8-a85093784830', '周浦镇', NULL, NULL, 2641, '4683d3ef-0edf-425a-98d5-2cb231a7d88a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('971ca90d-0234-4bd9-88fb-cfdbaa1c1c82', '石溪乡', NULL, NULL, 935, '88260608-a8b9-4b52-a474-1a551465c675', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('972126d3-f33e-4a3f-8231-a9d6901eab93', '罗云乡', NULL, NULL, 1141, '72d4f69f-2e4c-4bde-9df8-2aadc9168686', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('972ccff4-1b42-414e-bfa3-5fe01e2cf7ce', '荣成市', NULL, NULL, 1383, 'e86879a9-9808-4629-8311-39d63744f2fb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('97372be3-e910-46b3-b1c3-b4e744ab74ac', '彭阳县', NULL, NULL, 291, '76330308-a439-44e8-9f63-30f07cae40fe', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('973d48dc-62ed-4038-b0bf-d91f882e6f6a', '东坑镇', NULL, NULL, 3326, '3bc6861d-0eeb-497e-9257-42f9cd6fd26f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9752f366-90f2-4aa0-a3aa-4f24582a7856', '抚宁县', NULL, NULL, 2716, 'f4bc760a-86e0-4fa1-a5e9-cdc21cc7a127', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('975ce26f-e4db-488e-ac83-83381941673d', '滦平县', NULL, NULL, 4033, '8db8f645-a1a6-4c39-9c27-2f703951f66d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('97623786-c0cf-4b56-ae55-8af90958425e', '泥城镇', NULL, NULL, 2643, '4683d3ef-0edf-425a-98d5-2cb231a7d88a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('97734222-049e-42a3-8696-ed98032f891d', '大木乡', NULL, NULL, 1135, '72d4f69f-2e4c-4bde-9df8-2aadc9168686', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('97760d63-6a75-43fd-9f8a-c492b968a1ff', '乌恰县', NULL, NULL, 2243, '4f2a5173-2b34-4ed5-974e-a6ab5641b2a8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9778d772-059a-47b0-87b2-17c70f176715', '天元乡', NULL, NULL, 1595, 'ac0e6e50-b6a1-457c-811c-06ac309cd5a3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('978daef7-b176-410e-9336-cb65df5ef122', '肃州区', NULL, NULL, 2429, '42852584-118b-41cf-ba7e-db28102a593a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9793a831-817e-4221-9337-4c680c81fad7', '德隆乡', NULL, NULL, 925, '88260608-a8b9-4b52-a474-1a551465c675', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9797e2c0-e2c1-484b-92b3-dc42b6c09c75', '苏尼特左旗', NULL, NULL, 2345, '67723aea-a4ef-4eb7-afbf-55cc07806f98', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('979e2856-c059-4651-a46f-451783236213', '甘井子区', NULL, NULL, 4052, 'd83aabcc-3c2e-4b48-962a-c548442bc896', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('97d12ba8-6673-4400-8bb5-fa6cbb52fcdd', '笃坪乡', NULL, NULL, 377, '76dd00a1-30a1-4226-ae06-cad845c0528c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('97eb523d-9d62-4b3b-a3fc-2c6415d214f8', '南郊区', NULL, NULL, 1964, 'c8df6064-e107-46b5-b861-acd5b509b146', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('97f82008-c91a-4e60-8c8f-2f928c901170', '江边乡', NULL, NULL, 3613, '46073b56-9ab9-4efb-874f-efe112a304a6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9801efcf-3c16-42ff-a781-7389cc001df5', '召陵区', NULL, NULL, 4132, '55b0b2d6-58e4-40a1-b278-e63aa372ba29', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('98070f92-9168-4143-be78-fd4705eca59f', '淳化县', NULL, NULL, 2113, 'e42fbad8-c29e-4f35-878d-95a667b5cc90', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('98326600-279d-4652-8db3-1e0542950137', '白河县', NULL, NULL, 2984, '55fbb0a6-5436-4d04-9f29-716233f81fd7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('984cdc99-7e4e-4859-b6bb-f6572b9aa709', '靖远县', NULL, NULL, 3095, '0fafa17c-1c8a-4cb9-a100-4cfa035e3fed', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('987665f0-a2cf-449f-8776-599a19c33b36', '土默特右旗', NULL, NULL, 2049, 'd4910db5-a704-4273-bd13-a6dc05f468cf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('987780ba-5181-446f-97b5-e00e66b32a5e', '漳浦县', NULL, NULL, 1202, 'bda1d0f2-1476-4e0d-8fb9-2d1392397cbb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('98abd37d-51e2-4418-9e6e-eb1d032028a0', '桥头镇', NULL, NULL, 3342, '3bc6861d-0eeb-497e-9257-42f9cd6fd26f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('98c13024-4155-4331-9709-5c667ac3525d', '北蔡镇', NULL, NULL, 2627, '4683d3ef-0edf-425a-98d5-2cb231a7d88a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('98dcafda-dbdd-404a-9d65-252616df814d', '郧西县', NULL, NULL, 3935, 'd795e41b-eb16-4383-b762-ea557481f8e1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('991e1022-2735-4b60-8442-cd6889ff1549', '薛城区', NULL, NULL, 1415, '8e4df698-c772-488a-acf8-70e7d4adebd2', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('99219537-ccb7-4377-9706-4d172fbc39ea', '凤庆县', NULL, NULL, 516, '88546360-1a0c-4407-9b25-2cde1db643ee', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('992e8552-9040-48bb-b382-44ccdeda38c8', '宁城县', NULL, NULL, 4470, '4b199fdb-3a49-40f7-9843-8bd43f4ea30c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9942720e-3800-44e3-9970-850249b89637', '滑县', NULL, NULL, 2574, 'd94ce52b-fe8c-47d7-9b1a-d37da377cbbe', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('994ad73d-6c27-4275-a41c-a73464311d1b', '无为县', NULL, NULL, 3941, '5d5b2d25-fb30-4b3b-baac-c5481ccc67e9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9956d0d2-2418-473d-9ca5-a38aa89ba044', '崆峒区', NULL, NULL, 25, '4edd328e-68af-4f0e-bca8-63686e5cad24', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('996dfee0-e2ea-44cf-944f-da5fd1dc6fee', '偏关县', NULL, NULL, 2837, '18b3c51b-f699-467d-a342-d78bf9cff362', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('997ee6c9-af89-47c8-a8f2-aa4fa670fe3e', '呼中区', NULL, NULL, 3044, '1b8b9a84-0955-4d1e-8f33-8de97af3bedd', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('99810e39-1529-4aeb-83d6-7aed355a5fb5', '温泉县', NULL, NULL, 4272, '4a8f2a43-831a-4413-b4b5-2de877d9b166', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('99867385-bb70-4e59-9d0f-4d5cbea4907e', '龙山县', NULL, NULL, 3789, 'b9b94634-b449-4449-9581-c70550dc5099', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('998897c1-7f41-4654-aa0b-4c4ef3773c62', '商水县', NULL, NULL, 2294, 'f3e12d68-f8c5-4d9d-8314-dd1ce7dac2f9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9991de2e-75aa-4010-b371-fc69f64fe157', '茨竹乡', NULL, NULL, 4230, '0ee28cef-8dfc-4a9f-b7c1-330bc11c1bb3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9993346d-9578-4b1a-ab07-e0cd81209e55', '和政县', NULL, NULL, 2236, '5d2d5d2f-fd44-47ad-8108-b7f838073fbd', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('99958aa8-7694-4774-a8ab-8fad5b384559', '扶沟县', NULL, NULL, 2299, 'f3e12d68-f8c5-4d9d-8314-dd1ce7dac2f9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('999ba51a-7526-4ffb-8249-706e47456d59', '东平镇', NULL, NULL, 3982, 'fcc07455-c69c-4c90-82cb-ddb268adb8a9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('99b2cdad-ca76-41c5-8013-065d4c73ab65', '永定县', NULL, NULL, 3350, '381b5351-4075-4ec0-88cd-f3e1da71c110', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('99b4f962-1aa5-4365-b4ee-30ba244f82f6', '磴口县', NULL, NULL, 1682, '753245e5-8705-4940-badd-cd71430a4fdb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('99bcce28-f704-40d6-bea9-faa5c9931929', '利辛县', NULL, NULL, 1976, '9c7fcb3f-9d15-445a-944f-d2231a75f23d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('99e9c3eb-a139-4332-95f4-07cc027848de', '龙江镇', NULL, NULL, 1452, '81aab36f-0e28-4ba3-9827-b7033fce9b24', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('99ee42a4-a0f1-4a1d-9ef4-0c8c9b082724', '共和县', NULL, NULL, 4071, 'ed217127-f5a1-4f77-b32d-75d0114bce26', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('99fd21f3-b826-4868-aec2-3697d2bdf9e6', '泰宁县', NULL, NULL, 279, 'cae0a47d-0d79-4fa6-aac9-e8b3b535ee3c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9a0e4b86-0580-46a4-8123-bb21b650fc53', '潢川县', NULL, NULL, 3494, '976170b4-d0f7-4fd9-82ed-6e336c9bf3c0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9a155ee9-8f6e-40c2-bbe0-3a4a8bf5b166', '昌黎县', NULL, NULL, 2712, 'f4bc760a-86e0-4fa1-a5e9-cdc21cc7a127', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9a168bd4-60ec-41af-beb4-a2e02267ccba', '曲水县', NULL, NULL, 4155, '5a657ab2-3d76-4a46-917c-ddfe22c60d16', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9a271fec-dc04-4d12-94cc-589c5c11b097', '鹿城区', NULL, NULL, 252, '86b77e39-331e-4927-9517-49be7b738b9a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9a2ea38e-bcc2-4a99-915f-d24ff65ad33f', '新中农场', NULL, NULL, 4497, 'f491d9c3-9527-46a4-8954-6795ff079478', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9a348efa-b961-43c3-8ce8-be685d516d82', '西昌市', NULL, NULL, 3504, 'c8f594a3-8acc-48a9-ba2f-e76934de05eb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9a4216cc-cb0f-45cc-9d7a-4342ad5a3068', '云硐乡', NULL, NULL, 203, '4f867632-2989-4def-9934-a9c5fe0d5ca5', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9a4a079f-2de6-4187-bf73-deec738a9afe', '三门县', NULL, NULL, 3287, 'de41020d-a8dc-44d0-a2d4-75b6076c0ae8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9a57464b-364b-4175-8904-a3148fa31219', '古田县', NULL, NULL, 2440, '8300a2db-b893-4d51-a009-89478871edf1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9a727c78-f64e-4061-b818-9ec4a2d7697e', '靖边县', NULL, NULL, 1305, 'c0c88cbd-87ea-4281-9e8e-94a435ae6590', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9a7ca597-68d8-47cc-8f0b-23cc6dc351b0', '天安乡', NULL, NULL, 3612, '46073b56-9ab9-4efb-874f-efe112a304a6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9a806dd7-2d7f-421e-ab7e-c60d430bed0a', '官清乡', NULL, NULL, 2930, '465e9ea2-a2f2-4b42-95dd-b48d91f67105', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9aa614ee-3953-4643-b756-43c19d13e0d6', '花垣县', NULL, NULL, 3793, 'b9b94634-b449-4449-9581-c70550dc5099', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9ab88dbd-ae07-41c3-bd6a-c7781aa6b37a', '新昌县', NULL, NULL, 1422, '472589fe-78e1-4c48-8fde-cf3996a778ca', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9abc9a4d-e451-49dc-b59f-c4bc2bdf2798', '羊市镇', NULL, NULL, 1093, '79482cd9-7d51-4c89-94c2-4bcd773b8323', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9abdf0c5-b804-4c57-901e-af1f47c4ef59', '颍上县', NULL, NULL, 1626, '6de68814-d6ea-430e-88b6-bf98620aa604', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9ac42875-19c8-40f9-a4de-d8c4c3ccb4ab', '云龙镇', NULL, NULL, 661, 'd7f44c2a-2728-4633-a8b6-7643136bc99d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9ac92969-bfe0-4970-af0a-c94541150dd4', '福泉市', NULL, NULL, 3483, 'ef4b5cd7-d6b5-4839-9963-c010487ba475', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9acd8620-9261-4e66-bcad-d1d9c13582fc', '龙凤区', NULL, NULL, 2361, 'c5e2b320-fd7d-448b-9a02-4fb93e1d3302', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9ad3ba30-e487-470e-bf8b-1b56142b47ee', '万安县', NULL, NULL, 4326, '5f548430-51dc-45ad-82e5-bcd0394d8f6c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9ae2de1f-b6ff-4197-946c-7eac8033210d', '河包镇', NULL, NULL, 2509, 'd998f8bc-c659-47ce-8e5e-a6b29e03ecb3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9b1f07a9-e2b5-4e4e-a0cb-86f276c332b4', '东山区', NULL, NULL, 3283, '978f3e32-c5e0-48e4-b9ba-4f7f04ed87a1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9b222d73-7388-4a08-b895-47ae218ab176', '寻乌县', NULL, NULL, 1611, 'dd4a8577-afbe-449b-ae9b-be374a4c7434', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9b2a170a-8788-4074-b618-649e073d5392', '丰满区', NULL, NULL, 1949, 'a4031322-7fba-466a-ba72-50082ab248c6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9b35caee-cd32-4439-8ff6-4694717b1c6a', '巴马县', NULL, NULL, 1161, '509d3498-d5ba-4378-8bee-0baf015c2a11', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9b53c805-c1fd-47b5-b125-127055a3bdff', '西安武警工程学院', NULL, NULL, 4299, '29595f0b-301d-42da-845d-01afb30a9c18', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9b8743e8-0135-415f-a40d-f7bcf592d8e5', '前进区', NULL, NULL, 1404, 'a03ec6c9-8a1e-456b-bab9-164f8015c723', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9b8ebf43-ede5-4397-8e49-a5c63e82ad96', '威宁彝族回族自治县', NULL, NULL, 2620, '55fdf7c7-6698-498a-8aef-b9455ab7926c',
        1, 'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9bac46b9-9660-4f4e-af47-ae8df63c2808', '桑柘镇', NULL, NULL, 1882, '2c8bc8c3-9317-4f36-a0ad-05a8d6b27053', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9bd40529-55cc-47c9-ab2b-59baac792c60', '大悟县', NULL, NULL, 2754, 'caa97f6a-9b5e-4871-968e-42852537e6f0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9be2d080-a7fa-46ae-a94f-945911c53af0', '海原县', NULL, NULL, 1754, '5ce65120-7c31-4b33-8e77-7db1c92d085c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9be2f5a0-e20f-4a58-aa1b-a6e9e49259fe', '文安县', NULL, NULL, 1238, '86f7f02d-658e-44ec-9d36-b14cc3c65aaf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9c149ddc-8ce5-40dd-bc7b-ac685a98da0a', '龙沙镇', NULL, NULL, 798, '0f559985-f6fe-4a8f-af80-3d0d64932dbc', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9c221c0a-4d9c-4402-941f-bd3a6896ac6c', '枞阳县', NULL, NULL, 2533, '574f476d-e1ab-4240-a84f-b9671a2cb9cc', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9c24c7e1-e5b1-4fe1-bf01-7ab2db5e5e3d', '柞水县', NULL, NULL, 1393, '332e1b20-ce8a-4065-ab84-b60416060476', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9c3055e5-2dc2-401a-9dd5-514d64a2210d', '巨野县', NULL, NULL, 1792, 'e04fe06c-7641-47c7-a125-4d35e1800549', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9c45436c-69dd-494f-acd8-b703692ba0bd', '昂仁县', NULL, NULL, 3637, '5800fbac-51b0-4bc6-bc2b-34f78067fc28', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9c47cab4-e76a-43c2-b5fe-620d7c735716', '天台乡', NULL, NULL, 1148, '72d4f69f-2e4c-4bde-9df8-2aadc9168686', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9c63a6d2-fb9e-43d0-8d08-14127b9e860d', '萝岗区', NULL, NULL, 1986, '926eaeaf-e8c5-47f2-89ff-6932b52c87d3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9c7e9ead-2312-4459-91be-597ad8143c80', '永荣镇', NULL, NULL, 416, '9d7d52af-ec34-48e3-b81d-09ac51e11590', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9c7f329c-e86d-4926-b93e-fbfd1539a4c1', '婺城区', NULL, NULL, 224, '1721f4b0-56cf-4408-a217-62416951c176', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9c9662f8-54c7-4cf9-ae23-12666cf3311d', '孙吴县', NULL, NULL, 1426, 'e27d8c07-338c-4b1a-b45c-cf9cf0a22a0c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9c969d70-b45e-4906-b38e-69200154dbdf', '巢湖市', NULL, NULL, 154, '6ab7dc5a-1064-4090-a81b-79c3a2e8302d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9c982128-c6f2-4226-a58d-fe3df13c6d6c', '巫峡镇', NULL, NULL, 361, '76dd00a1-30a1-4226-ae06-cad845c0528c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9cb60927-7cbb-47e1-b594-2f79eec72e76', '察隅县', NULL, NULL, 2582, '23ca0ede-0d68-4451-afde-afd774149ec4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9cb7778f-6214-4208-968a-7cd44c3321c3', '沙坡头区', NULL, NULL, 1755, '5ce65120-7c31-4b33-8e77-7db1c92d085c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9cbf74bf-619c-4d29-9903-2037208efed9', '高县', NULL, NULL, 1821, '18a8dd20-aad4-43cd-ab48-ab6108097d8a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9cbfa0d3-a66d-4301-b10c-f1b5f83a5384', '全州县', NULL, NULL, 3191, '796bb0e0-6b76-4c1d-801f-2dbcbab74087', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9ce36021-3c06-4ae0-8a70-feda8e195a40', '邵东县', NULL, NULL, 3754, '30ce87bd-09cc-4250-9b5e-1f5916ce4d70', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9ce4cafe-3a79-4ba9-b9a4-25ca830ef774', '山阳镇', NULL, NULL, 2709, '0e5598a8-f405-4745-8cd5-a7a4c99f67f9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9cf1a414-6861-4267-810f-30cf117f867c', '奉城镇', NULL, NULL, 631, 'fa34c22b-c1d8-45b2-bb1b-4ea08298e7f6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9cfb0cc4-7d35-47a0-8606-2e990b978961', '东港市', NULL, NULL, 2797, 'c0064cbf-ba5c-4dc0-a855-b330e096cd61', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9d05aa2f-2900-4b0e-a088-ad3fc147719b', '小河区', NULL, NULL, 534, '46abe060-5805-4aaf-9d89-b66bed4b224e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9d332e6d-e1f2-4b96-8477-d77064de67e6', '琅琊区', NULL, NULL, 857, '1a27a18f-784d-4314-bd00-8add932005d6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9d396b07-0b5b-4fce-ac2a-217a1186ee27', '武功县', NULL, NULL, 2112, 'e42fbad8-c29e-4f35-878d-95a667b5cc90', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9d3f3e80-9f76-49e6-9b75-09a53e0b1cda', '龙孔乡', NULL, NULL, 1940, '442f465d-6566-45e4-9338-50f4395aa6f7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9d4c6f67-3b9e-48b5-b956-a07a0197ea88', '岭口镇', NULL, NULL, 1568, '5f7e2e46-8a4e-4463-907c-5762bcd006a8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9d7d9a38-6f7a-475c-8794-7537c89612a8', '惠山区', NULL, NULL, 2214, 'e658aec8-1268-4349-a3f5-570b669a4f06', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9d7dd04e-0b74-44ad-ab16-d10106581311', '嵩县', NULL, NULL, 1170, 'b5a118ad-786c-4d86-b4e8-5d25a3776a78', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9d8ecae5-457a-43e4-9bac-38b8f894d0c2', '通化县', NULL, NULL, 868, 'def0f6fb-9804-4bed-8554-2115bfca9849', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9d91fd06-12ac-445c-8ff8-eb8844e3a059', '中兴镇', NULL, NULL, 4088, '5d3b3a34-50c8-4a01-83b7-e3e068d5c9a7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9dd65a18-e414-4d7e-9002-849ca814a78f', '管城区', NULL, NULL, 4118, '4ff4ef6c-41df-4562-a58f-d8b25b2e3ba4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9ddeb482-b61e-427b-98d9-f13485118c94', '三伏潭镇', NULL, NULL, 3462, 'ea11feaf-194c-4cec-be59-d17bac402db4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9e08fd21-b57a-485d-badf-264e7854929b', '饶阳县', NULL, NULL, 2466, 'b126935b-0423-4bea-b802-d4e6680d1d71', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9e10f231-0b46-4adc-847c-3f4388fab7ff', '高峰镇', NULL, NULL, 1480, '89e8be16-b810-4c7e-89f0-aa9f24483b98', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9e1cd630-011a-47c2-8606-e656c7f4c808', '蔡家岗镇', NULL, NULL, 2321, '671d3a34-71bf-42c5-8dda-a813f5ecba22', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9e25fff1-b89f-481e-88ef-7314deb52109', '邵武市', NULL, NULL, 3443, 'dd15d032-477c-4f54-9629-ea782606b468', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9e4b5f42-e2e6-4cf5-b94d-67e376f723c8', '平湖市', NULL, NULL, 4406, '0118b1e4-bae7-4459-94b9-db6947b14aba', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9e704261-5a99-4a96-97ce-ca279a4edbf7', '金门县', NULL, NULL, 1859, '0d3bd52a-74b2-4461-9a57-17c7cce4ac1b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9e93ff04-b542-4352-9fb7-162a1884301e', '湘潭县', NULL, NULL, 4312, '40852955-b0b0-4a50-b4b2-201be5c3808b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9e943a74-97c4-438f-9e17-8e80d77eea84', '秀英区', NULL, NULL, 2882, 'b899bf86-aa99-4e70-a544-8ebe64da4f24', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9eb0a177-0070-4e50-a986-38b78e71737d', '八所镇', NULL, NULL, 3604, '46073b56-9ab9-4efb-874f-efe112a304a6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9ed53f24-b525-4382-b1e1-0f2ee2059c7b', '五宝镇', NULL, NULL, 1719, '86ab4d11-9653-4b0d-8cc1-2e12a4de15d6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9eef5b9f-cab5-45bf-97fb-231370d2f140', '全境', NULL, NULL, 3068, '64cf8b0a-4f50-458a-9aa6-475f368c183f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9f13f7a9-049a-4490-a8e6-e27ba240073c', '纳雍县', NULL, NULL, 2619, '55fdf7c7-6698-498a-8aef-b9455ab7926c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9f341bd0-2b44-4a0d-8e6c-335f3584c456', '柳荫镇', NULL, NULL, 2331, '671d3a34-71bf-42c5-8dda-a813f5ecba22', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9f4b5999-974a-4bc9-ad3c-6044c667c970', '定海区', NULL, NULL, 1293, '02033c55-d6b3-4a85-91e0-b68d170d3383', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9f552c5a-913a-4d40-9311-5d1f8d213d13', '五桂镇', NULL, NULL, 570, '8ae99c85-66b1-406b-8084-9f77cbf73b10', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9f6565c8-6b4d-455b-b5ee-ab73e985a6ad', '小榄镇', NULL, NULL, 2187, 'f2727650-b0d9-4541-acdb-b4eabf894893', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9f6d8269-14ec-4947-bdb2-067d10043827', '上犹县', NULL, NULL, 1614, 'dd4a8577-afbe-449b-ae9b-be374a4c7434', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9f735284-0d9c-4b8b-891c-510787ef7c38', '锡林浩特市', NULL, NULL, 2340, '67723aea-a4ef-4eb7-afbf-55cc07806f98', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9f7ea55c-264d-43c5-9f14-504d0bcb72f8', '两罾乡', NULL, NULL, 2935, '465e9ea2-a2f2-4b42-95dd-b48d91f67105', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9f834837-667b-4bfc-8699-f362844018fc', '维西县', NULL, NULL, 2848, '931058d3-f668-41c4-94a8-7a763997d1df', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9f885279-92d5-4680-8804-459dcec90e3e', '包家乡', NULL, NULL, 1491, '89e8be16-b810-4c7e-89f0-aa9f24483b98', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9f90b355-8a98-41a2-94b9-2849416c2cab', '永吉县', NULL, NULL, 1954, 'a4031322-7fba-466a-ba72-50082ab248c6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9fb8ff0c-3079-4520-a261-df5677d6f078', '达县', NULL, NULL, 1007, '6681b8cd-3740-4dbd-b311-143871994e15', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9fca30f8-3f0a-4652-84a7-c71c6c981f74', '双港，辛庄', NULL, NULL, 4374, '7932fd13-00db-4934-bfc2-79c835527339', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9fd1d746-bceb-4519-b2b2-2da8d1da5078', '上城区', NULL, NULL, 2305, 'f530455e-1c70-47dd-9a80-4bc74a4e2680', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9fe6d623-949e-40a2-bbeb-9d65b8c14cb4', '肥西县', NULL, NULL, 153, '6ab7dc5a-1064-4090-a81b-79c3a2e8302d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('9ffaa47f-4c11-4146-ad4e-f4a362f5b5ab', '岳塘区', NULL, NULL, 4310, '40852955-b0b0-4a50-b4b2-201be5c3808b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a01019a7-b2ea-4885-b38b-ab6760e59e4b', '长寿湖镇', NULL, NULL, 2077, '4686b935-e3f0-4173-bdfe-ab6a5450d1a8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a0214586-8d72-4d6d-a804-f929194fb0aa', '大兴镇', NULL, NULL, 3599, '27289f06-ca7a-4916-8f25-f6b13d8687ec', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a03ba155-c1cb-4f7f-b2cd-4e34eb1d24cb', '坪山新区', NULL, NULL, 677, 'fd718129-208d-4a94-9e52-7516af8ef013', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a03fe45e-1e49-4486-9266-46432399e335', '县城内', NULL, NULL, 4327, 'e98653ba-264e-4417-b74e-e0798b25e646', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a0406140-7381-41e1-9a37-24b87497dd32', '太平镇', NULL, NULL, 3841, 'c33c3107-81df-4ced-8b92-d694df412da3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a084576b-c75f-47cd-972b-d8bd7aa069df', '曹路镇', NULL, NULL, 2630, '4683d3ef-0edf-425a-98d5-2cb231a7d88a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a08bc771-4bdb-49d6-8265-9a7834d3f5eb', '应县', NULL, NULL, 2064, '49bad2d2-0c83-48ed-9985-7a709362f3a8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a091d5cd-b855-49a5-88bc-b4bb652953ad', '瓦房店市', NULL, NULL, 4058, 'd83aabcc-3c2e-4b48-962a-c548442bc896', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a098eb3c-db07-467a-b9d6-f765bdf4c022', '察布查尔县', NULL, NULL, 2591, 'e6f53877-d5bf-4b42-aded-5ab8960ef034', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a0ac0f02-fe21-4462-9922-209866b012bc', '河西区', NULL, NULL, 3061, 'e60d3fe5-6d26-4a3f-b920-8fb6c4986bfb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a0c58469-44b6-4386-ad77-4bffa00b1cde', '奉新县', NULL, NULL, 4068, 'fa27d3fb-a80f-4b4c-8d0c-bf7d544bb974', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a0c5917a-45ce-4b21-b73f-be7ba3926fb7', '渔池镇', NULL, NULL, 805, '0f559985-f6fe-4a8f-af80-3d0d64932dbc', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a0d8d986-0da8-4168-8ed5-fc02f0ff004b', '迭部县', NULL, NULL, 3132, '9d7c5001-b115-4bea-abb4-a289a03b5075', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a0daf3c7-a954-4819-869d-ea117dd0610f', '妙峰山镇', NULL, NULL, 3576, '5d21af6a-f035-42f4-a0cf-ff1fd3d36f3b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a0f924d5-426c-482f-a0bb-9d59e0cb52e5', '准格尔旗', NULL, NULL, 3530, 'eb551697-7acc-4bcd-9d21-3d48c16f8258', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a108bfe8-9258-48aa-90f6-31e501dbfed7', '红古区', NULL, NULL, 4044, '2d364b6d-2931-4d45-995a-336e4e0f2b55', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a11548fa-ea13-429c-8dae-38c4146ef844', '光山县', NULL, NULL, 3500, '976170b4-d0f7-4fd9-82ed-6e336c9bf3c0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a11dd913-d87f-4e49-a4df-5dcdb06cfc74', '石壁镇', NULL, NULL, 1448, '81aab36f-0e28-4ba3-9827-b7033fce9b24', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a133c591-8993-4902-947d-6069a971ac3e', '汉阳区', NULL, NULL, 427, 'e6e46871-d5a0-4d2b-8243-9d4bd864ab43', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a14ebe7b-8df7-4485-86fd-e9bd0b8d44a9', '浚县', NULL, NULL, 3438, '2130bd75-b4cf-44af-a13b-2b64109f0cb9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a1503bd8-f040-4af6-b205-b0117d4cb23e', '南山区', NULL, NULL, 3281, '978f3e32-c5e0-48e4-b9ba-4f7f04ed87a1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a160c8f8-0041-487f-8fc4-0344d11d5e1a', '下陆区', NULL, NULL, 3912, 'b3b5e655-b2df-467e-ad5f-2ab21c2a0aba', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a16eb1b0-c429-417b-b8f2-2a9e4943be5f', '建平乡', NULL, NULL, 379, '76dd00a1-30a1-4226-ae06-cad845c0528c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a178885e-4b65-405f-94e4-a88ad1ff027c', '白云乡', NULL, NULL, 4455, '4888e1e9-ba45-4254-83e7-87796f338e2d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a1887bb9-0765-4c8e-8e4f-01fc55d55218', '鲤城区', NULL, NULL, 1861, '0d3bd52a-74b2-4461-9a57-17c7cce4ac1b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a1b4990e-af1a-4ca8-ad32-7489275ef87d', '紫水乡', NULL, NULL, 3277, 'a39ced08-b6e9-4de0-a2db-7a230a673d1e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a1ba272c-f801-46bd-8dbf-6d9e3cca2623', '新河镇', NULL, NULL, 3991, 'fcc07455-c69c-4c90-82cb-ddb268adb8a9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a1cefd0c-9dc1-45db-93b5-495d50d64218', '志仲镇', NULL, NULL, 2554, 'a1e3332c-7029-4de7-a221-40c041a9a620', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a1d9e10e-820f-4021-922b-dbc5b337529c', '大涌镇', NULL, NULL, 2197, 'f2727650-b0d9-4541-acdb-b4eabf894893', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a1e684a8-2e5e-4d9d-a1df-8cbdfbd52540', '冷湖行委', NULL, NULL, 3010, 'a638060f-a01c-4c77-b905-b46ef8d3e89d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a209016b-5b2a-46d6-b956-f0dc98a1c21d', '太原乡', NULL, NULL, 1906, '2c8bc8c3-9317-4f36-a0ad-05a8d6b27053', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a212975c-e583-4c99-8426-c199920b4085', '县城内', NULL, NULL, 362, '76dd00a1-30a1-4226-ae06-cad845c0528c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a21762de-863d-4a75-ab22-b0c922f59d3c', '高明区', NULL, NULL, 328, 'dbd204cb-29de-4212-8c03-c2286f2ba4f5', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a23569dd-0d70-46a8-ac6a-1c7128c02657', '博罗县', NULL, NULL, 77, 'f951b5e7-debd-4c51-9c02-03ebe84ebbfc', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a251a0c4-dc2b-4f02-9aab-22a87f325168', '堡子镇', NULL, NULL, 1114, '72d4f69f-2e4c-4bde-9df8-2aadc9168686', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a2534ee7-d725-4fc1-9489-6b601b8e6ae0', '华容区', NULL, NULL, 4077, '657fcfcb-2cbe-4a17-8c6f-184169cfeb6f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a2591d71-5503-4348-9234-3c9887e80028', '港口区', NULL, NULL, 267, 'b844b23e-c209-4691-8773-29f9f7f080e6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a25e1e1b-d626-4b81-be11-5b8ef414f4cf', '红山区', NULL, NULL, 4479, '4b199fdb-3a49-40f7-9843-8bd43f4ea30c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a2717ed2-e862-4bb7-9e5e-f09c9b39627b', '石鱼镇', NULL, NULL, 3831, 'c33c3107-81df-4ced-8b92-d694df412da3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a2763287-c787-499e-a68c-0ef209f61071', '奉化市', NULL, NULL, 1676, 'c5cc1924-02da-4927-982d-54f0b9f70ef8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a28f9ff2-d61a-4560-8477-af06f3c21178', '章丘市', NULL, NULL, 4357, 'c6ac73d4-9854-403a-9b61-12c22eeb4903', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a2b37f2e-f794-4115-a7da-63c147173545', '临清市', NULL, NULL, 354, '56b97c58-86a5-4869-9130-c5dc51ea9a26', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a2b4c784-19f4-4930-93f2-fb173194d2e8', '夏津县', NULL, NULL, 4176, '9c8b6d83-dd06-4238-b7f4-c0ad532e5b6e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a2cad5e9-001f-4814-ae82-b5f351e78c67', '湘东区', NULL, NULL, 1151, '20c4f23e-77e7-4763-9ba8-dd00d5216748', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a2db7833-af7a-4d20-99f2-9a84c97b0c7b', '茄子河区区', NULL, NULL, 2005, '9653e91f-7d63-4d36-adcc-4cdbe21dcbea', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a2ee469e-0121-4c7e-831b-e3441d6b085c', '定日县', NULL, NULL, 3641, '5800fbac-51b0-4bc6-bc2b-34f78067fc28', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a30fc25f-b0a5-4eea-9740-03ba08e4ef40', '史家营乡', NULL, NULL, 64, '0863a0a5-7ac5-4a13-80f5-d31e3a1aa459', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a3178007-9f0f-4f05-b57f-dade7a74d4b4', '武鸣区', NULL, NULL, 2810, 'b53ced47-2455-44ec-b740-7637148f574c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a367fda5-84d9-4279-b65a-a8728b9decf3', '郯城县', NULL, NULL, 4348, '56327d0b-ec26-4f34-8ab6-0eba49931c67', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a3680b48-275d-45fb-a987-33cbccca5fbd', '澄江县', NULL, NULL, 4144, '2b997404-05c1-436b-8004-2d5dfd364db3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a3a5c7be-9f0d-42ef-bae1-f1de7d1d0e52', '三溪乡', NULL, NULL, 386, '76dd00a1-30a1-4226-ae06-cad845c0528c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a3aeb690-4178-440a-923c-a2575032420a', '巴塘县', NULL, NULL, 3779, 'c262a40d-a147-4930-b33b-574ec51fa884', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a3bdf5ba-98e5-4581-8c15-daaa4b7d7ea9', '南开乡', NULL, NULL, 1349, '21bb958f-e5d4-4a71-a350-b5bf2c0e2de0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a3bfd96c-7194-4e94-8d73-b53bed3647d7', '浑源县', NULL, NULL, 1960, 'c8df6064-e107-46b5-b861-acd5b509b146', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a3db9c76-0046-4b22-95f2-53bb9554dcc6', '王场镇', NULL, NULL, 831, '24ad0708-80a9-43b1-8e1c-758f2492d3f6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a3e44aa1-a614-4a5d-9799-704e14ce8094', '竖新镇', NULL, NULL, 3988, 'fcc07455-c69c-4c90-82cb-ddb268adb8a9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a40878ba-654e-4761-9c76-f71332a943fd', '西乌珠穆沁旗', NULL, NULL, 2350, '67723aea-a4ef-4eb7-afbf-55cc07806f98', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a40ea388-d068-4c35-a3d2-6ca2c99153bb', '永乐镇', NULL, NULL, 1079, '79482cd9-7d51-4c89-94c2-4bcd773b8323', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a428cdbd-1196-4fa3-9c5b-3e660cabea49', '济阳县', NULL, NULL, 4359, 'c6ac73d4-9854-403a-9b61-12c22eeb4903', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a43e6ea4-22fe-493b-b4b2-126d1ee0c4b0', '海城市', NULL, NULL, 2012, '48832e11-ddfb-478a-9787-e46c47346d7e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a44406b0-c608-41f0-bf25-88d9b2e247b5', '清升镇', NULL, NULL, 2517, 'd998f8bc-c659-47ce-8e5e-a6b29e03ecb3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a45987ce-be03-457f-9495-8ebbcfe8489e', '路桥区', NULL, NULL, 3292, 'de41020d-a8dc-44d0-a2d4-75b6076c0ae8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a46543b9-83f4-4077-a25c-283b20ae9ba4', '英吉沙县', NULL, NULL, 2040, 'e6436d79-8045-4185-b2b2-22cd280d22b0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a486044a-bea8-4cf0-bb4a-0e3f8fcc9390', '成武县', NULL, NULL, 1793, 'e04fe06c-7641-47c7-a125-4d35e1800549', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a4a5ba09-6031-4937-90bb-bf1046f8699e', '华蓥市', NULL, NULL, 3296, '4bb2fe40-7307-498b-802c-e85e937f95e0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a4ac8bcb-16c2-4563-a317-128873bc08dc', '屯溪区', NULL, NULL, 4274, 'e3fa5765-1e86-4f89-a751-2f63dbe81c99', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a4ba91ab-9728-4840-917c-054f2a611e67', '共青城市', NULL, NULL, 118, 'bcaf1f36-5459-4e74-81d1-5026680b1a9c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a4c0d4d1-9d67-403c-9c69-773a01faecb5', '凤凰镇', NULL, NULL, 3058, 'e60d3fe5-6d26-4a3f-b920-8fb6c4986bfb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a4ca808a-1f01-4dfc-844c-b82c077b5c29', '板芙镇', NULL, NULL, 2192, 'f2727650-b0d9-4541-acdb-b4eabf894893', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a4cdc275-d56f-44de-a2bf-84d41485d410', '平安县', NULL, NULL, 124, '21aca68b-8887-476c-b2b3-fe670c301acc', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a4d07de9-991d-499f-81d4-debfe5430e32', '玉山县', NULL, NULL, 501, '8bf55045-9366-4acb-b884-bca672ff9644', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a4e5a2dd-da3c-45cc-86dd-93af84555e4d', '五营区', NULL, NULL, 464, '7ca3412f-b06b-467e-b547-691ab8327b15', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a5007ee3-0e8c-4fe0-85a3-4f20ca4cbd0e', '和林格尔县', NULL, NULL, 1265, '1fdea9c2-419d-4fd5-b725-8d361e4376fb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a51c322e-7cf8-40b1-be34-476f24ad370b', '金刀峡镇', NULL, NULL, 2324, '671d3a34-71bf-42c5-8dda-a813f5ecba22', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a51f4ee1-9016-4464-a951-8c9c0e905c0f', '清涧县', NULL, NULL, 1294, 'c0c88cbd-87ea-4281-9e8e-94a435ae6590', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a52d58c1-3362-4bf3-a2af-6834f0c21f3b', '翁田镇', NULL, NULL, 3806, '96fec37f-11d5-4d41-aba4-a36d0652744c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a53684e1-3e3d-40fc-94b1-9d56cc32201a', '浉河区', NULL, NULL, 3503, '976170b4-d0f7-4fd9-82ed-6e336c9bf3c0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a54c82eb-4fce-4df5-bc72-31574019b5a9', '玉龙县', NULL, NULL, 3301, '533981ab-21f3-46b9-91a4-320129bd0b49', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a5556dac-2542-45df-aeb3-11d191acca88', '林口县', NULL, NULL, 1974, '1c2bd9d2-bc08-486e-a5f3-ba5de82c6365', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a571953b-4427-4aa4-b1a1-8784d2a2f4e4', '桂溪镇', NULL, NULL, 1477, '89e8be16-b810-4c7e-89f0-aa9f24483b98', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a58d2743-9663-4145-ac60-37870f1b536b', '五通桥区', NULL, NULL, 2521, '8f917434-e687-4552-b494-0eab3af61900', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a58eb217-eafc-4852-9b48-4f2a86889710', '白云区', NULL, NULL, 1987, '926eaeaf-e8c5-47f2-89ff-6932b52c87d3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a58f8d32-dfd4-4413-ad7e-c21ad79225fe', '元江县', NULL, NULL, 4148, '2b997404-05c1-436b-8004-2d5dfd364db3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a599c910-1b95-44db-9e0d-e14d6ef8f55b', '察哈尔右翼后旗', NULL, NULL, 3969, 'a061ae4e-1b4e-4b42-8aa9-cc6bbae9619a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a5a30b46-35ef-4cb0-9e61-2ed87b2faaa3', '大平区', NULL, NULL, 308, 'fca062e6-ca02-4963-9f79-ed8cbfbb11df', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a5a74214-14b8-4000-b243-59abb6754664', '河南县', NULL, NULL, 2060, 'c9781b3d-f13b-42a5-962f-df7de65d2033', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a5b089d7-a5cf-43c3-a6ac-0517f41c195f', '城区', NULL, NULL, 247, '6c067928-5765-4455-9019-74593fd0e11d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a5b16598-9ee3-45de-8608-34f45334391e', '畅好乡', NULL, NULL, 14, 'c8bf9a67-2bfc-47fe-9580-3f2f2eac1edb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a5b99712-e440-42fa-a95c-550744926066', '麻栗坡县', NULL, NULL, 2220, 'fadbb851-aec5-4d3e-be0e-09e7462eaceb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a5bf32e4-3ed6-46a7-98c5-ba1b6a057b36', '城关镇、马家店开发区、天宝工业园', NULL, NULL, 3119,
        '310378c8-165d-4f81-a495-67e9b30f000f', 1, 'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL,
        '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a5ce6ca3-2369-46a7-966b-a152568fcc07', '汾河镇', NULL, NULL, 1085, '79482cd9-7d51-4c89-94c2-4bcd773b8323', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a5d981d2-7b16-4113-8924-7e0855590c7a', '杭锦后旗', NULL, NULL, 1683, '753245e5-8705-4940-badd-cd71430a4fdb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a604785d-1ce3-4418-8fd8-ee26b87c1a31', '陕县', NULL, NULL, 4000, 'ba612057-dda4-4e54-9951-f847a74f623e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a6062a36-920c-4446-b972-5c22ed74824e', '湖里区', NULL, NULL, 1208, '9122834d-aef5-4895-974e-82d2f568bcd4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a628a14c-48da-4cdb-a1b2-55657924e6de', '平塘县', NULL, NULL, 3490, 'ef4b5cd7-d6b5-4839-9963-c010487ba475', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a62fe998-63c0-4c74-9266-4d8adae0272b', '措美县', NULL, NULL, 1018, 'f7038861-43d2-49c3-a5c9-53fde2c139fa', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a64371be-f63a-4d81-a3dc-5a416584a715', '岗巴县', NULL, NULL, 3653, '5800fbac-51b0-4bc6-bc2b-34f78067fc28', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a647cb69-bce8-4a84-b028-740d621a4877', '茶陵县', NULL, NULL, 2611, 'cdeda821-2101-44e1-a986-183436199f05', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a64f907f-051e-45b6-899c-0aeb17371ad1', '城区以外', NULL, NULL, 2172, 'c35b997d-64f4-42d2-92c6-a0090291ed08', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a6938c5a-be17-40c3-842d-330c00c9e574', '五通乡', NULL, NULL, 3276, 'a39ced08-b6e9-4de0-a2db-7a230a673d1e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a696e081-b023-4023-8dfe-c07bb833e747', '浪坪乡', NULL, NULL, 2934, '465e9ea2-a2f2-4b42-95dd-b48d91f67105', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a6a1ba9f-da27-4c02-bfb1-667209b3d882', '麻柳乡', NULL, NULL, 3271, 'a39ced08-b6e9-4de0-a2db-7a230a673d1e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a6af56dc-6632-4abe-8c4c-2d2244069793', '文县', NULL, NULL, 1371, '7c9ca39d-ce8f-469d-899a-09a0a29c1541', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a6d8cc8d-701e-4847-b6b9-6069cc2e4559', '吴起县', NULL, NULL, 3405, 'f95958de-a678-4371-9710-6bcac3f425fa', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a6e1b67d-5f6c-4a79-bea3-8eaff7d58553', '北区', NULL, NULL, 483, 'dfb8b556-10a2-43ab-9fdb-66cde92320ee', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a6e6267f-3dff-4eb6-aa9c-edb9728accfa', '石城县', NULL, NULL, 1607, 'dd4a8577-afbe-449b-ae9b-be374a4c7434', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a6ea4e18-18cc-4acc-95c6-0b887b4906f1', '赛罕区', NULL, NULL, 1263, '1fdea9c2-419d-4fd5-b725-8d361e4376fb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a6f9f8e8-335d-44ef-93e9-27a5bcf6b8b1', '九亭镇', NULL, NULL, 91, '3e082d1b-ecb4-4bf8-8715-54132a9106e1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a71d4800-0b5e-4f1c-ad09-8631a0e056b0', '坪山镇', NULL, NULL, 1495, '89e8be16-b810-4c7e-89f0-aa9f24483b98', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a73ff5de-aee0-4c5d-9c79-df4e8a46533f', '和平镇', NULL, NULL, 2285, 'b3792f06-9c78-446e-b6ac-d95d5e9092e8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a74f2c94-6245-4f63-89a5-5b4d711557c0', '太白县', NULL, NULL, 1829, '7c3fbad9-df03-4d15-93a4-695924a2f35d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a754491c-b529-47a6-8d00-a673bff4336a', '澄海区', NULL, NULL, 1441, '8596baaf-4bfe-4522-a422-f397f3494bcb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a75d2964-d475-490d-9393-9b50ebe9fc39', '清河门区', NULL, NULL, 310, 'fca062e6-ca02-4963-9f79-ed8cbfbb11df', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a7736a86-d5e7-453b-bd3f-19da6e3f1a1b', '盐山县', NULL, NULL, 2895, 'a3c44525-9ccb-429d-a2b7-f5f5d52b8a6d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a78399ed-152e-4502-b023-94cb1086e50b', '岳溪镇', NULL, NULL, 3258, 'a39ced08-b6e9-4de0-a2db-7a230a673d1e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a78f17d9-de38-40b1-85f7-d2cf7c23b1c1', '泗阳县', NULL, NULL, 4189, '2263db14-1626-4430-a8ea-bc9c02268004', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a79797a0-f727-4142-a4f9-50f5c9088693', '鹤城区', NULL, NULL, 2016, 'd133a3fc-3db0-426f-8a04-e25b44a5565c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a7b513fe-0b16-40de-946a-5928b7ff8dc0', '智凤镇', NULL, NULL, 1640, 'a560b8db-8db1-4bc8-bb6b-fbbecebcaf10', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a7b6fc92-f0cd-4ef6-ae4e-8712c5dc13a4', '鄂温克族旗', NULL, NULL, 1068, 'c31a65eb-4d77-4b38-8142-9c9e2f54ed46', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a7b7e269-4200-4932-8e67-f84e5f78e362', '隆回县', NULL, NULL, 3760, '30ce87bd-09cc-4250-9b5e-1f5916ce4d70', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a7c19c96-75b3-48b7-a4d0-81e86a42eb4a', '钦南区', NULL, NULL, 3419, 'd6095cf5-28d0-419b-a799-9a3c87594720', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a7c4edef-12c3-4efe-b22a-33945f4e9a52', '安稳镇', NULL, NULL, 3656, '6581d8db-553e-4417-8c37-91ed47904920', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a7d32480-595a-43c2-a786-d2a1996d2659', '阜康市', NULL, NULL, 1272, '8db1e665-1af9-4697-8514-7fa18e3a8683', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a7ddade7-03da-49b3-a1b1-83f7c6cb84e9', '昌图县', NULL, NULL, 2792, 'def78b05-5d2b-430c-b268-442502dc3ca5', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a7dec0a3-91da-4c43-b464-f9d9bd40ac0d', '桂阳县', NULL, NULL, 1314, '50d6a2ea-ba0d-4ff5-8b4c-f9d84e79e381', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a7fe258f-4a1d-43e3-a266-8aca8366500e', '张店区', NULL, NULL, 2443, 'c03520db-2a67-4cae-a658-4806d4254996', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a80caa62-d789-4e56-bf53-dc167f31b29a', '阿拉善右旗', NULL, NULL, 1693, 'fe94b712-ef16-4435-a491-7601776344cf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a8189be3-febb-47a6-bc58-ce16fc2904e6', '市中区', NULL, NULL, 1416, '8e4df698-c772-488a-acf8-70e7d4adebd2', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a8375066-c91a-49dd-aec3-3666edff1beb', '县城内', NULL, NULL, 2500, 'd998f8bc-c659-47ce-8e5e-a6b29e03ecb3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a84391a7-3534-4851-a034-5b149be480a5', '同江市', NULL, NULL, 1408, 'a03ec6c9-8a1e-456b-bab9-164f8015c723', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a84e3499-f3ee-4f22-bb0b-227238af275f', '蔡家镇', NULL, NULL, 893, '41f376c0-764f-46b9-af35-e555518fc613', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a8611c85-f018-455a-b450-9741389e0b74', '南门镇', NULL, NULL, 3254, 'a39ced08-b6e9-4de0-a2db-7a230a673d1e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a86705f5-077b-4dbc-a224-068cefdb4c5b', '珲春市', NULL, NULL, 1053, '87e1c9be-7455-45a9-ace5-641efce55e22', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a86e27a1-0dfb-4233-bb82-52816f7b93cd', '洪梅镇', NULL, NULL, 3339, '3bc6861d-0eeb-497e-9257-42f9cd6fd26f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a86f9f94-177c-410d-87fd-b48220dfdaa2', '辉县市', NULL, NULL, 2177, '1aabde9d-2b04-4892-a20d-5b4e3efaeedf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a87215f3-5e1a-44e0-8b43-15bc0ccf22e2', '石盘乡', NULL, NULL, 1904, '2c8bc8c3-9317-4f36-a0ad-05a8d6b27053', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a8885a4a-1a8d-4d65-a21c-e334b989accb', '马边彝族自治区', NULL, NULL, 2530, '8f917434-e687-4552-b494-0eab3af61900', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a8a62846-dc8e-4286-97b9-1ca81968b626', '徐家镇', NULL, NULL, 1583, 'ac0e6e50-b6a1-457c-811c-06ac309cd5a3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a8a94bb9-2179-4596-9c85-70c6d6ceb689', '全南县', NULL, NULL, 1620, 'dd4a8577-afbe-449b-ae9b-be374a4c7434', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a8b5ae09-c80b-4aae-b718-d190d0fa472c', '高坪镇', NULL, NULL, 1660, 'a560b8db-8db1-4bc8-bb6b-fbbecebcaf10', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a8b62dae-263d-4434-ac86-18feb51740df', '莞城区', NULL, NULL, 3314, '3bc6861d-0eeb-497e-9257-42f9cd6fd26f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a8c0bcec-91fe-4f52-b5f4-529a79e8aa4e', '尚义县', NULL, NULL, 140, '37614653-bf6c-458f-a844-540790491eb1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a8d468b7-34bf-4a30-bc25-0133897c9663', '新建县', NULL, NULL, 1287, 'cf24a0a2-c56e-45df-920c-8247c771d48e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a8d7a134-74a3-49bf-b994-6198007a39d1', '平陆县', NULL, NULL, 4106, 'fc30b5e5-3005-4778-94f7-706b31514bff', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a8d8645d-5e41-4e9f-a7bd-6422d81bc39f', '昭平县', NULL, NULL, 1465, '6f0d2b72-566f-44e5-969d-2d2ce65ace5c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a8f9d8d4-414b-4be6-a83f-b31af93aba1a', '贺兰县', NULL, NULL, 4282, '2a45fee0-aa22-4471-be1a-0f6edce52b7a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a8fb9a5e-fdac-4f92-9471-4b7538dbad6d', '临夏市', NULL, NULL, 2238, '5d2d5d2f-fd44-47ad-8108-b7f838073fbd', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a90ecc89-b8d5-41ce-bcad-892b941a4cc6', '三汇镇', NULL, NULL, 2666, 'e509a1a5-95da-4fb2-9a2b-f84afa05a36c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a9340b6c-293e-4883-a513-919734d38616', '肥乡县', NULL, NULL, 221, '237eff18-fe6c-4842-afb1-acb05027a5c1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a93b3f2c-f9b8-4fc9-8aeb-5f0662bc0b4c', '乐光农场', NULL, NULL, 2549, 'a1e3332c-7029-4de7-a221-40c041a9a620', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a93bcb23-7538-4d72-9f76-6d4a87a0283f', '汤原县', NULL, NULL, 1403, 'a03ec6c9-8a1e-456b-bab9-164f8015c723', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a93bfc5c-3bf9-402a-801d-783a1ef2f604', '泰顺县', NULL, NULL, 257, '86b77e39-331e-4927-9517-49be7b738b9a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a953476e-b1d1-40e5-93f1-48b0d97c00fa', '千家镇', NULL, NULL, 2555, 'a1e3332c-7029-4de7-a221-40c041a9a620', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a96a53d1-288c-4bc4-af08-1e79aec95720', '青木关镇', NULL, NULL, 3901, '7fefd2bf-99e0-43f5-bc37-9ab15ee8e8f3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a9829e24-d57e-44ae-ac26-c9bf75d43ff0', '凌源市', NULL, NULL, 4135, '0c1d1a8a-4eea-4aa0-9a5e-b68ae380a09a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a982e059-a432-4523-bc02-77acda5d3dc9', '黄家镇', NULL, NULL, 1877, '2c8bc8c3-9317-4f36-a0ad-05a8d6b27053', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a9865991-a826-4169-9bcf-7ee45be6358e', '蓝田县', NULL, NULL, 4296, '29595f0b-301d-42da-845d-01afb30a9c18', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a995d8bd-8e1a-4e9e-aa51-9818d88db7f7', '尖山镇', NULL, NULL, 1578, 'ac0e6e50-b6a1-457c-811c-06ac309cd5a3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a9a25012-21e6-4f1f-ad27-dd78ce5cc47c', '剑川县', NULL, NULL, 232, 'feece7c8-8eeb-494a-8e84-571b6ebcf0d9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a9a3c8d1-6eca-4851-a7e4-e11d329d4fc9', '横县', NULL, NULL, 2806, 'b53ced47-2455-44ec-b740-7637148f574c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a9aae469-0c54-4ce1-9cb3-842135a07453', '明家乡', NULL, NULL, 1142, '72d4f69f-2e4c-4bde-9df8-2aadc9168686', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a9b0598f-9396-406c-9ffd-c2413330d15b', '磁县', NULL, NULL, 222, '237eff18-fe6c-4842-afb1-acb05027a5c1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a9b2b6cb-ce60-4cd4-a992-ca225058af93', '正定县', NULL, NULL, 2761, '334645de-ae54-416a-8978-2dbf9f7bbd09', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a9d847a5-db09-4006-ad36-37632824f01f', '岱岳区', NULL, NULL, 1242, '23df07d6-66e4-474e-b42b-258f50d7b0e4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a9dd25f8-908c-466f-b87e-551b647575e7', '沐阳县', NULL, NULL, 4188, '2263db14-1626-4430-a8ea-bc9c02268004', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a9ee99d0-d22e-42e0-b734-40a5a02e54d6', '郁山镇', NULL, NULL, 1884, '2c8bc8c3-9317-4f36-a0ad-05a8d6b27053', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('a9f2ca1b-8482-4d5a-85e2-5632bae42d5e', '瓯海区', NULL, NULL, 253, '86b77e39-331e-4927-9517-49be7b738b9a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('aa0dbd65-79c8-43dd-af98-9a843e4e55b2', '乳源瑶族自治区', NULL, NULL, 1527, '754500f9-7ec4-4379-8b1c-9370f50564c0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('aa1e6508-b49a-4f7b-868f-567cd691ed5d', '隆阳区', NULL, NULL, 3144, '3fbd3d32-e8e3-476f-9f4c-319ffaaed527', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('aa29268d-ee03-4afd-8617-d3b9ca6e147d', '城区', NULL, NULL, 85, '3e082d1b-ecb4-4bf8-8715-54132a9106e1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('aa39eb49-dcf3-41b3-ad73-6bf462ebc648', '滨海县', NULL, NULL, 4369, 'b85d2a61-b018-431a-9609-2ca0841f5cab', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('aa3c6e69-6e4b-4b08-9e12-88609cc507ec', '城关区', NULL, NULL, 4042, '2d364b6d-2931-4d45-995a-336e4e0f2b55', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('aa401cf3-c512-4a26-82f2-dc676c6fc65d', '夏邑县', NULL, NULL, 3139, '62aa4f78-f1b9-44d1-9372-21e01c353757', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('aa485169-b6fc-4827-8d01-848994b8dfc2', '大田县', NULL, NULL, 273, 'cae0a47d-0d79-4fa6-aac9-e8b3b535ee3c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('aa4f5b18-8d19-42b3-9c8b-0abad51d3c40', '延吉市', NULL, NULL, 1050, '87e1c9be-7455-45a9-ace5-641efce55e22', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('aa5d3174-ff7c-4c2b-85c6-a7e808159df5', '改则县', NULL, NULL, 2907, '3a856f9e-a1e5-4657-b81e-cc7d76d14ff5', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('aa8997b5-79e2-4d8b-8d4d-85faa39368a1', '景谷县', NULL, NULL, 1708, 'db61cc5b-b13b-417f-a232-7925ffdfa9b2', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('aa918ec9-efe9-4701-890f-8869475b1a28', '红旗区', NULL, NULL, 2174, '1aabde9d-2b04-4892-a20d-5b4e3efaeedf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('aa92c8f1-4799-4eeb-94b9-a5fdd7237928', '建水县', NULL, NULL, 3156, '99a9abd1-f107-4dc6-ae43-e9d1120504b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('aa97a533-430a-4f62-b4e1-6659df60364d', '王屋镇', NULL, NULL, 3922, '22f622f8-7eaf-41e9-90ee-2a0cfda1f326', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('aaa0cf59-edbf-4cf5-b291-9cec3f9d6993', '南头镇', NULL, NULL, 2198, 'f2727650-b0d9-4541-acdb-b4eabf894893', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('aaa76ebd-76c5-493d-a033-cd01ed6d2877', '宝安区', NULL, NULL, 674, 'fd718129-208d-4a94-9e52-7516af8ef013', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('aaa79f7c-deee-435d-9b87-3fde4013f512', '城区', NULL, NULL, 1317, '99c50aa3-ab40-4b1e-addd-f68662f3c560', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('aab9054f-e192-4682-96ab-107deff9c210', '浪卡子县', NULL, NULL, 1023, 'f7038861-43d2-49c3-a5c9-53fde2c139fa', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('aac90743-baaa-449b-a961-5f1c054a0a3d', '平安镇', NULL, NULL, 177, '4f867632-2989-4def-9934-a9c5fe0d5ca5', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('aacc033e-a21b-423e-ad34-99005c84c3c6', '巴青县', NULL, NULL, 4420, 'fae5ed6b-9b68-4ef9-93fa-221dea13a975', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('aad1d96f-2775-4929-85a0-b1d9cb931c0d', '永顺镇', NULL, NULL, 2124, '88d84710-80d6-4837-b889-286c74d7940d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('aaf78f16-3954-4eeb-895a-4dcbf6c10bce', '苍溪县', NULL, NULL, 511, '74a706f1-82bb-4132-8ee4-9abf7bd809cb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ab4abbe0-f839-4391-8ff2-6d7c3bd29508', '英德市', NULL, NULL, 2958, '8377f1cd-7272-4396-b99b-84bb707dbc2c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ab4cabb2-35f6-471d-b965-39bdfe581f53', '龙游县', NULL, NULL, 2818, 'b2a03fc9-88f2-4734-9af2-7234863d0f87', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ab55a807-4be3-42be-a53f-752ab96a87ca', '周至县', NULL, NULL, 4298, '29595f0b-301d-42da-845d-01afb30a9c18', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ab6f13a4-a4cc-4e65-a133-71c3bd4f3b93', '蔺市镇', NULL, NULL, 1116, '72d4f69f-2e4c-4bde-9df8-2aadc9168686', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ab79b68a-d1cc-40dc-abcc-17e92f33ff0d', '轵城镇', NULL, NULL, 3921, '22f622f8-7eaf-41e9-90ee-2a0cfda1f326', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ab8ca146-c3e9-4bb8-b21c-d5210f83bf33', '永发镇', NULL, NULL, 4085, '5d3b3a34-50c8-4a01-83b7-e3e068d5c9a7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('aba5a229-2e8c-404e-8548-affa5704f528', '吉水县', NULL, NULL, 4325, '5f548430-51dc-45ad-82e5-bcd0394d8f6c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('aba947dd-ce1d-47b8-a077-0b8add6bfb6d', '都兰县', NULL, NULL, 3008, 'a638060f-a01c-4c77-b905-b46ef8d3e89d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('abb450c2-4367-4440-89c5-353500bfb686', '文城镇', NULL, NULL, 3795, '96fec37f-11d5-4d41-aba4-a36d0652744c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('abbcf585-3ccd-4aa0-ab8e-e0a42b96eda9', '石屏县', NULL, NULL, 3158, '99a9abd1-f107-4dc6-ae43-e9d1120504b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('abc77092-b715-4b93-8c61-d230abb0b2a1', '双竹镇', NULL, NULL, 400, '9d7d52af-ec34-48e3-b81d-09ac51e11590', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('abd1deab-c88b-4fd8-914f-adad124835f6', '思茅区', NULL, NULL, 1704, 'db61cc5b-b13b-417f-a232-7925ffdfa9b2', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('abd52d70-adcf-4a37-9538-5160a4695355', '富阳区', NULL, NULL, 2315, 'f530455e-1c70-47dd-9a80-4bc74a4e2680', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('abe2419d-2d15-4dc9-9da7-a7f78092c921', '弓长岭区', NULL, NULL, 4164, 'f856399f-e403-4734-abb9-b972db76c06b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('abe88b91-72ed-4964-85a4-247ae5e5c5ab', '兴庆区', NULL, NULL, 4283, '2a45fee0-aa22-4471-be1a-0f6edce52b7a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('abf37989-d716-4d15-a6c3-17ec5abcae40', '曹县', NULL, NULL, 1790, 'e04fe06c-7641-47c7-a125-4d35e1800549', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('abf48ed0-c3c9-4fbb-b83d-697abfcb9845', '防城区', NULL, NULL, 266, 'b844b23e-c209-4691-8773-29f9f7f080e6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('abf744c4-b0ce-4175-a11f-cfcfd0f60971', '双桥区', NULL, NULL, 4037, '8db8f645-a1a6-4c39-9c27-2f703951f66d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ac0214d4-e6b8-4226-95b6-8a395afee81d', '满城县', NULL, NULL, 2484, '81e22d56-a1c7-4263-be18-81a4af165ae3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ac1ef954-3c7c-4a11-9ae6-6ab9bd5ba243', '骡坪镇', NULL, NULL, 368, '76dd00a1-30a1-4226-ae06-cad845c0528c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ac2091a3-77b9-4926-8387-364f054bdf4a', '新乐市', NULL, NULL, 2769, '334645de-ae54-416a-8978-2dbf9f7bbd09', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ac2dcb5f-9ddd-4478-95f4-7a298e726e70', '杜市镇', NULL, NULL, 895, '41f376c0-764f-46b9-af35-e555518fc613', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ac3cc7d1-b214-4a97-9f2a-9cdff0952008', '马武镇', NULL, NULL, 799, '0f559985-f6fe-4a8f-af80-3d0d64932dbc', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ac5e50be-4870-410b-b9f4-22a43bb4c05c', '瀍河区', NULL, NULL, 1181, 'b5a118ad-786c-4d86-b4e8-5d25a3776a78', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ac67a0c5-e40c-4d09-9e48-77c91db27170', '阜平县', NULL, NULL, 2487, '81e22d56-a1c7-4263-be18-81a4af165ae3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ac6a1e2a-353b-4bd8-b36d-215ebd98ca16', '芦潮港镇', NULL, NULL, 2642, '4683d3ef-0edf-425a-98d5-2cb231a7d88a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ac72566d-d80d-4cc0-8782-6f52b31efa70', '光明街道', NULL, NULL, 3725, 'd1c1539c-b904-4bcc-a034-96213f63d0ff', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ac75de7c-910d-409e-a678-d4c4775b1e1b', '石黄镇', NULL, NULL, 2668, 'e509a1a5-95da-4fb2-9a2b-f84afa05a36c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ac7bdde3-bec5-4bf9-b6bf-dfa455db2c38', '土桥镇', NULL, NULL, 3825, 'c33c3107-81df-4ced-8b92-d694df412da3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ac985647-cae7-446b-938d-3b5d189918d6', '岚县', NULL, NULL, 3415, '9348509b-6d82-47e7-86d7-f054fb47b7fe', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('aca0926d-85da-4ab7-8b4e-bcefaab55458', '鸡鸣乡', NULL, NULL, 2393, '0275a9ca-e89b-4217-b3b0-ada824d9e095', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('acacdfdb-7e26-421b-9678-9a28c1c89225', '石林县', NULL, NULL, 2867, 'd7efec13-7e84-436d-8390-41868af0e359', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('acc64f5c-0b58-418a-b63d-dd34989dc6a4', '城区', NULL, NULL, 555, 'b75db043-9782-4bae-aaee-bea49fc286e6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('acd8c0c2-68c0-47cf-a181-49cc650449a4', '何埂镇', NULL, NULL, 418, '9d7d52af-ec34-48e3-b81d-09ac51e11590', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('acf8f10d-0e1a-4339-b089-78a46e76e9f7', '毛道乡', NULL, NULL, 15, 'c8bf9a67-2bfc-47fe-9580-3f2f2eac1edb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ad1ecd5e-bebc-462a-a225-b655db006f86', '李渡镇', NULL, NULL, 1111, '72d4f69f-2e4c-4bde-9df8-2aadc9168686', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ad33d643-3000-4530-9925-16fb315e908f', '东安区', NULL, NULL, 1967, '1c2bd9d2-bc08-486e-a5f3-ba5de82c6365', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ad9f2504-ea28-4475-87ca-1de65ae0aa8a', '南谯区', NULL, NULL, 862, '1a27a18f-784d-4314-bd00-8add932005d6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ada93e3e-63a2-41a9-ac3a-a12eb0cca137', '赣县', NULL, NULL, 1609, 'dd4a8577-afbe-449b-ae9b-be374a4c7434', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('adb53b36-bc4f-4ea9-b564-1d85827e0293', '昭阳区', NULL, NULL, 3683, '31187fc0-8d6e-45f3-9653-b7ce4227ef1d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('adbe2a96-746b-4e96-8c0c-2cb757be7035', '神木县', NULL, NULL, 1297, 'c0c88cbd-87ea-4281-9e8e-94a435ae6590', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('adda3ccf-e212-4649-8752-dacea012829d', '农安县', NULL, NULL, 315, '096d0f9e-9537-43f8-95f6-8dca9fa4cad4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ade04c30-3b0d-4c93-ba9f-9fdafbee074d', '石龙镇', NULL, NULL, 3337, '3bc6861d-0eeb-497e-9257-42f9cd6fd26f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ade7e340-fc49-4c3a-9579-fa433d6bf000', '尼玛县', NULL, NULL, 4421, 'fae5ed6b-9b68-4ef9-93fa-221dea13a975', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('adefe3d7-8e42-443a-bae4-ca20435a076a', '西安区', NULL, NULL, 1969, '1c2bd9d2-bc08-486e-a5f3-ba5de82c6365', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('adf21a49-ef25-4c12-9c74-5dcf3dc846bc', '覃塘区', NULL, NULL, 3021, 'eb4d8886-4710-4809-8f77-b3caa4b4904e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('adf3e43f-3a6d-4f3d-aee6-fafa767db46c', '吴兴区', NULL, NULL, 4195, 'af4299a6-6902-4c79-bc49-f7b3f3c6f683', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ae0a7319-f360-4536-92bf-1233c06beed3', '三角镇', NULL, NULL, 3665, '6581d8db-553e-4417-8c37-91ed47904920', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ae1f7a0b-cd5e-4067-b785-1003d8eb3d42', '莺歌海盐场', NULL, NULL, 2547, 'a1e3332c-7029-4de7-a221-40c041a9a620', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ae273535-34cf-4392-afe1-18a23442b30b', '库伦旗', NULL, NULL, 1555, '1dc7d092-717c-424e-a473-bb2cc8836b5e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ae43cb4b-e3b0-4043-bc87-514c6f78db16', '西吉县', NULL, NULL, 288, '76330308-a439-44e8-9f63-30f07cae40fe', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ae45e97d-1172-4e55-9b1e-dc8e2225a910', '浏阳市', NULL, NULL, 626, 'dccf3d25-c012-444b-94c6-bbcbae7e63d8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ae4e616e-d8c1-4348-9b9a-e4876739ab4f', '中阳县', NULL, NULL, 3410, '9348509b-6d82-47e7-86d7-f054fb47b7fe', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ae515d94-fd3b-49d6-bb5b-d48eb6f216d6', '梁子湖区', NULL, NULL, 4076, '657fcfcb-2cbe-4a17-8c6f-184169cfeb6f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ae52bd4f-3996-4d89-a10c-ca1854690e87', '蓝洋农场', NULL, NULL, 3220, '2e21ea75-c640-4928-8cb4-e5ba4f6e2ffe', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ae5c6b94-c0f2-4313-8f04-0e0ca8d7882d', '县城内', NULL, NULL, 2379, '0275a9ca-e89b-4217-b3b0-ada824d9e095', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ae6f32fe-8f95-4aee-ad73-fcab4be356c8', '西山区', NULL, NULL, 2857, 'd7efec13-7e84-436d-8390-41868af0e359', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ae7af6a0-06b1-446f-971b-2fe835500b1a', '县城内', NULL, NULL, 1476, '89e8be16-b810-4c7e-89f0-aa9f24483b98', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('aea25cf7-3723-4fc7-943f-293d502058dc', '曲尺乡', NULL, NULL, 385, '76dd00a1-30a1-4226-ae06-cad845c0528c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('aea3b08f-0185-414d-8c60-54d3f825447c', '四环到五环之间', NULL, NULL, 1701, '576c43af-0a86-47d9-83a7-4989ce3b3dc7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('aead756c-2dbc-4d3b-ae3c-a802ddd0bd49', '熊口镇', NULL, NULL, 832, '24ad0708-80a9-43b1-8e1c-758f2492d3f6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('aec56e02-1d9a-4842-b443-a999faa2cf53', '安多县', NULL, NULL, 4417, 'fae5ed6b-9b68-4ef9-93fa-221dea13a975', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('aec6fd49-dfbf-4c26-b4a4-b70c7b3d4ae5', '张金镇', NULL, NULL, 835, '24ad0708-80a9-43b1-8e1c-758f2492d3f6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('aecbb474-a630-4b51-adf9-b454df7fe78a', '夏坝镇', NULL, NULL, 906, '41f376c0-764f-46b9-af35-e555518fc613', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('aeeb240e-c41b-4336-bbf9-c1304c272f46', '天河区', NULL, NULL, 1980, '926eaeaf-e8c5-47f2-89ff-6932b52c87d3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('af096f57-c51f-4496-8d8c-4c3aa79072aa', '雁塔区', NULL, NULL, 4287, '29595f0b-301d-42da-845d-01afb30a9c18', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('af110494-7ee6-4273-be0a-48d9c4176150', '云门镇', NULL, NULL, 3873, 'a732da28-870c-4d9c-a287-c2c1e3222b59', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('af1a5933-7585-4dcc-bc67-984ff340b216', '延庆镇', NULL, NULL, 1502, 'd5ab951d-20ab-46ff-8838-de5efe06b6b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('af201673-a392-47dc-83a0-a68708ad5b69', '耒阳市', NULL, NULL, 4263, '75dd761e-ce3f-45bb-a86b-d3a1e2c7629a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('af20d33b-0b4e-464d-8f5b-d10c59dcc63f', '吴泾镇', NULL, NULL, 4026, 'f6eb800d-2093-4ce2-8105-3747d69abe97', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('af224999-11f6-48e4-84ff-1ccabb4051e8', '开发区', NULL, NULL, 2570, 'd94ce52b-fe8c-47d7-9b1a-d37da377cbbe', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('af3ada8f-c73c-4304-b717-674c18cafef2', '四方区', NULL, NULL, 3709, '1e53830d-8cdb-4111-8da6-987131b873ed', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('af3f4657-1d9b-41ae-99b2-1bb20c0cf0b6', '寻甸县', NULL, NULL, 2868, 'd7efec13-7e84-436d-8390-41868af0e359', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('af53305c-c793-4b62-9977-ef6c3a441be9', '鄞州区', NULL, NULL, 1673, 'c5cc1924-02da-4927-982d-54f0b9f70ef8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('af5f4ee1-e85c-4703-8b36-cf8103759d52', '施家梁镇', NULL, NULL, 2323, '671d3a34-71bf-42c5-8dda-a813f5ecba22', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('af6250a2-9e99-4be0-a95d-50262c49d445', '吉安镇', NULL, NULL, 408, '9d7d52af-ec34-48e3-b81d-09ac51e11590', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('af8c4feb-36c4-4d21-9f7e-df5a6afbf079', '盐源县', NULL, NULL, 3506, 'c8f594a3-8acc-48a9-ba2f-e76934de05eb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('afb1ad65-3962-414f-8086-394308d18c11', '天镇县', NULL, NULL, 1956, 'c8df6064-e107-46b5-b861-acd5b509b146', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('afb5c06c-7f7a-4285-a897-a38c43d96fe8', '清溪场镇', NULL, NULL, 964, 'cc124ed6-091a-42ce-a87a-bb4d0d7357b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('afb9f2d6-7f8b-4636-8c64-d69500920338', '宏伟区', NULL, NULL, 4165, 'f856399f-e403-4734-abb9-b972db76c06b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('afba2d2e-40c2-48aa-bceb-2c11006c93a2', '大德镇', NULL, NULL, 3239, 'a39ced08-b6e9-4de0-a2db-7a230a673d1e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('afbeeb7e-0243-410f-bb1a-6f845240d158', '山根镇', NULL, NULL, 4490, 'f491d9c3-9527-46a4-8954-6795ff079478', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('afe40223-f713-44f1-ba3e-4119c94e1ae0', '遵义县', NULL, NULL, 3427, '69324865-24e8-4abe-a068-a1392c117c0d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('afe5a7be-38c1-4c7f-8314-40fb93e83ff5', '集安市', NULL, NULL, 867, 'def0f6fb-9804-4bed-8554-2115bfca9849', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('afec098a-7dd6-47a8-b93a-f2f9f7036860', '文峰区', NULL, NULL, 2569, 'd94ce52b-fe8c-47d7-9b1a-d37da377cbbe', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b006f65e-dba7-4d38-b6aa-cf79e8f2ca95', '麻章区', NULL, NULL, 2596, '5c5b11a0-6a29-4173-b876-8fdbc543cb2b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b011e9c5-734e-4bb6-bf3f-5046204d7668', '安图县', NULL, NULL, 1057, '87e1c9be-7455-45a9-ace5-641efce55e22', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b014aceb-e398-44f3-b162-04282d4daa26', '集宁区', NULL, NULL, 3959, 'a061ae4e-1b4e-4b42-8aa9-cc6bbae9619a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b02ed336-987e-49af-84a1-95a977ae39a7', '龙洞乡', NULL, NULL, 187, '4f867632-2989-4def-9934-a9c5fe0d5ca5', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b0424a85-2a92-4e45-8fe3-9f4961e457d9', '余江县', NULL, NULL, 1336, '20a1443b-429b-4c83-83ca-2c9de2bd67b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b04b2d31-34c9-45eb-aeee-bef90629bc46', '太谷县', NULL, NULL, 525, '84a16421-f7fb-4f99-b2c0-1e0dea97bf0b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b05ca777-0911-4b82-80f6-eeccb5687552', '丰润区', NULL, NULL, 2453, '4f4c1ef4-f54d-4ba4-a124-ca2d3d0ddb78', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b097eb4c-b2f2-4c81-9041-ceb0ac3e8219', '阜南县', NULL, NULL, 1625, '6de68814-d6ea-430e-88b6-bf98620aa604', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b09cf81e-8f39-4117-b570-7408e70a5888', '龙桥乡', NULL, NULL, 1101, '79482cd9-7d51-4c89-94c2-4bcd773b8323', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b0ec0a1d-c297-459b-b170-4ffb671dc66f', '永丰县', NULL, NULL, 4318, '5f548430-51dc-45ad-82e5-bcd0394d8f6c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b10f613c-59af-49c1-90e4-687611ab26aa', '柏梓镇', NULL, NULL, 558, '8ae99c85-66b1-406b-8084-9f77cbf73b10', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b15d4936-1f61-41ff-b7e6-1ada5c62f1a0', '龙门镇', NULL, NULL, 1566, '5f7e2e46-8a4e-4463-907c-5762bcd006a8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b16289fe-e27a-4965-91ad-fb10a4c420c2', '靖安县', NULL, NULL, 4066, 'fa27d3fb-a80f-4b4c-8d0c-bf7d544bb974', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b17e3abd-b7fb-4fe3-9e23-f9d57ef39da5', '萧山区', NULL, NULL, 2312, 'f530455e-1c70-47dd-9a80-4bc74a4e2680', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b182abf8-8919-4d4f-b0b4-049df2f69fae', '广州大学城', NULL, NULL, 1992, '926eaeaf-e8c5-47f2-89ff-6932b52c87d3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b18cec95-9860-4d4d-bc6d-84e9e9e50434', '攸县', NULL, NULL, 2610, 'cdeda821-2101-44e1-a986-183436199f05', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b1943853-a554-44a7-a813-7a65bdc25490', '靖江市', NULL, NULL, 2230, '0541b99e-02a6-415b-8282-4ef9d27cb647', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b1a4ba28-772f-45a3-a423-af6704e286d2', '开福区', NULL, NULL, 624, 'dccf3d25-c012-444b-94c6-bbcbae7e63d8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b1b50f4c-248c-4f73-9e5b-d4248532ea45', '良乡镇', NULL, NULL, 57, '0863a0a5-7ac5-4a13-80f5-d31e3a1aa459', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b1c633fb-1d32-4dc5-b4af-680d1e930907', '梁山镇', NULL, NULL, 639, 'd7f44c2a-2728-4633-a8b6-7643136bc99d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b1e120fe-4963-4762-b995-8d27e85abeb9', '上杭县', NULL, NULL, 3351, '381b5351-4075-4ec0-88cd-f3e1da71c110', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b1ec82c2-218b-4c3b-963a-2761f92c3204', '灵川县', NULL, NULL, 3190, '796bb0e0-6b76-4c1d-801f-2dbcbab74087', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b20d44be-a036-4f34-b666-0736379ca3eb', '君山区', NULL, NULL, 2266, '8369850a-f796-470f-902f-393cfb615571', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b21ff040-54e2-4120-ba07-030aa7d29838', '平南县', NULL, NULL, 3020, 'eb4d8886-4710-4809-8f77-b3caa4b4904e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b221fd3f-a88b-45f8-bcdd-5041d5fb370b', '浩口乡', NULL, NULL, 4458, '4888e1e9-ba45-4254-83e7-87796f338e2d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b22675fc-d872-4c5e-9b80-503dbcf60a6a', '许明寺镇', NULL, NULL, 1916, '442f465d-6566-45e4-9338-50f4395aa6f7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b23d4eb1-6090-4efe-920f-ad0093a94e6a', '疏勒县', NULL, NULL, 2039, 'e6436d79-8045-4185-b2b2-22cd280d22b0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b2446a1d-c37b-4ddf-a8b2-7de7aa8ed214', '安富镇', NULL, NULL, 2502, 'd998f8bc-c659-47ce-8e5e-a6b29e03ecb3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b2606c53-57fa-4aa8-8ed4-8305f08b945e', '菊园新区', NULL, NULL, 1322, '99c50aa3-ab40-4b1e-addd-f68662f3c560', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b26c76d1-a53a-4b80-ae5b-4af2c77c779b', '观胜镇', NULL, NULL, 2512, 'd998f8bc-c659-47ce-8e5e-a6b29e03ecb3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b2a3c602-47e1-46ce-acfa-5bab58d7a79a', '红谷滩新区', NULL, NULL, 1286, 'cf24a0a2-c56e-45df-920c-8247c771d48e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b2a46867-6b13-4d31-a0e8-969cc81a9af2', '平马乡', NULL, NULL, 988, 'cc124ed6-091a-42ce-a87a-bb4d0d7357b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b2b08b24-3193-41f3-8a0e-06441834a764', '孟连县', NULL, NULL, 1703, 'db61cc5b-b13b-417f-a232-7925ffdfa9b2', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b2c5659b-0d0c-429c-8aaa-dd7d16e7cee1', '云梦县', NULL, NULL, 2753, 'caa97f6a-9b5e-4871-968e-42852537e6f0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b2cbafbf-d821-4bc3-9935-5c9b725b0796', '特克斯县', NULL, NULL, 2586, 'e6f53877-d5bf-4b42-aded-5ab8960ef034', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b2cd1966-f080-448e-8f11-e41f110396d3', '连江县', NULL, NULL, 4251, '71a49c5c-c3c2-4fcb-8f90-aa1d733a19f7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b2fa9755-bbbc-4094-8d00-7a44a57a1c94', '砚台镇', NULL, NULL, 1487, '89e8be16-b810-4c7e-89f0-aa9f24483b98', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b3164c58-2104-49cf-8c52-00d04fa15548', '漳县', NULL, NULL, 3124, 'fc26f78a-1b0b-4967-8d26-df9e530e5260', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b31de287-f0f5-42be-8d7b-bbd40904ff6e', '开封县', NULL, NULL, 4183, 'fb0dbd60-1d03-4394-a890-ffc2d3ec6a37', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b330418c-148b-42e2-910d-33399f221dd6', '大新县', NULL, NULL, 3030, 'c99528d5-bed7-4890-b547-f2159ed13a78', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b368226e-f8b1-4918-986d-90a9a74ff749', '龙泉驿区', NULL, NULL, 1805, '4f073365-4e02-459f-8b32-cad88dd22637', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b368a11a-e989-46ae-8819-c16f1c0a41d4', '宜都市', NULL, NULL, 1777, '3760382f-ecb5-4ef6-8bd2-049afe34b574', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b37487d9-acdd-44e4-ac98-df03c001333f', '平舆县', NULL, NULL, 749, 'a096e337-c439-4751-a014-b49dd13bee26', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b374a375-b6e1-4dc5-9aef-fef29deef8ff', '常熟市', NULL, NULL, 608, '278acb58-4d2d-40cb-a572-1fc7fb979c77', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b385a25a-42ab-46b3-98c7-d431e6f82534', '循化县', NULL, NULL, 129, '21aca68b-8887-476c-b2b3-fe670c301acc', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b387e76e-5d99-4d5d-adef-bd2744f8ffc6', '塘厦镇', NULL, NULL, 3323, '3bc6861d-0eeb-497e-9257-42f9cd6fd26f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b38fec8b-d215-47e6-bf16-3a18cdfe4af8', '城固县', NULL, NULL, 341, '5c4e7f63-9162-47e1-a948-c64ca46ff566', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b3972a8f-0474-4500-8dc4-d5c1293018b8', '五湖渔场', NULL, NULL, 3477, 'ea11feaf-194c-4cec-be59-d17bac402db4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b3b28e7c-1b83-4c97-8439-dfc55412de00', '平江区', NULL, NULL, 614, '278acb58-4d2d-40cb-a572-1fc7fb979c77', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b3bb8502-4203-4765-88c4-e7a395de5349', '华兴镇', NULL, NULL, 3837, 'c33c3107-81df-4ced-8b92-d694df412da3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b3cf283a-8b3a-416c-bd9f-1d9e83ab959f', '杂多县', NULL, NULL, 2073, '27eaf8ae-634a-45eb-bdc9-207c699d16ef', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b3e2123e-9e8c-47ae-a528-20c6e5955117', '北关区', NULL, NULL, 2571, 'd94ce52b-fe8c-47d7-9b1a-d37da377cbbe', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b3f885e9-92c4-40cf-9fb6-4959ed11f92f', '马关县', NULL, NULL, 2223, 'fadbb851-aec5-4d3e-be0e-09e7462eaceb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b3f9bbf1-602b-4503-82fc-67c3f4fd084c', '双辽市', NULL, NULL, 684, 'de003161-c00c-4f8a-ac92-6a2188069e9b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b403faf7-68ab-4de8-b555-ff7db7c2b0d0', '郊区', NULL, NULL, 1407, 'a03ec6c9-8a1e-456b-bab9-164f8015c723', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b407d2c8-04af-4482-847a-c996e8025d8b', '洋浦经济开发区', NULL, NULL, 3228, '2e21ea75-c640-4928-8cb4-e5ba4f6e2ffe', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b40cce20-ec01-4fb1-87ef-38ebf9b1aad1', '羊角镇', NULL, NULL, 4453, '4888e1e9-ba45-4254-83e7-87796f338e2d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b410a9a6-6822-4fdc-9ed3-9d5813e121fb', '富锦市', NULL, NULL, 1409, 'a03ec6c9-8a1e-456b-bab9-164f8015c723', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b43d97f0-b754-4730-8697-0db9c24299bc', '马陆镇', NULL, NULL, 1319, '99c50aa3-ab40-4b1e-addd-f68662f3c560', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b4666a20-bd3c-4e26-ad84-235567240167', '镇坪县', NULL, NULL, 2979, '55fbb0a6-5436-4d04-9f29-716233f81fd7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b4668fb5-f2b0-4577-9927-907236f09ae4', '渠马镇', NULL, NULL, 178, '4f867632-2989-4def-9934-a9c5fe0d5ca5', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b46ac198-56f0-401f-8d64-32e535e69a3b', '湾岭镇', NULL, NULL, 2283, 'b3792f06-9c78-446e-b6ac-d95d5e9092e8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b48cd7e8-03f3-44d9-a770-2ee793bd9559', '于洪区', NULL, NULL, 1848, '271a8d5d-a9a3-4876-a9a2-ca9bcee4b83f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b4a67176-fd77-4269-8e94-5f28ef27b546', '墨玉县', NULL, NULL, 850, '60e9ec7d-f371-4ea9-ace3-b13c1cd7081c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b4b224ad-2b0b-4416-8e9a-4f7766a729c6', '多祥镇', NULL, NULL, 2151, '671275c4-6107-4968-bd8e-96d53e9995b2', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b4b94fe0-696b-4b1e-8db5-ba26f1b60451', '土城乡', NULL, NULL, 1598, 'ac0e6e50-b6a1-457c-811c-06ac309cd5a3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b4cb6c28-5cea-4949-b71d-2cc07e52ce5c', '陇川县', NULL, NULL, 437, '10aecf03-914d-4a26-a6c3-0045748d43b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b4de7e61-fb4b-4f65-83c8-b3ed49ef1093', '伊宁市', NULL, NULL, 2585, 'e6f53877-d5bf-4b42-aded-5ab8960ef034', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b4fca720-0bf5-4f57-a5de-308ea0ab7c56', '临县', NULL, NULL, 3412, '9348509b-6d82-47e7-86d7-f054fb47b7fe', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b51d94ef-ac37-413f-a672-b7a0acaf8974', '金江农场', NULL, NULL, 2989, '4b3478d4-3e85-4143-bc6f-ac4a338a9d47', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b522b1e9-b9a9-404b-9fc4-de16f71b6894', '泾源县', NULL, NULL, 290, '76330308-a439-44e8-9f63-30f07cae40fe', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b5296ae5-2cd8-4640-b163-0ad51cbbe39c', '日土县', NULL, NULL, 2905, '3a856f9e-a1e5-4657-b81e-cc7d76d14ff5', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b5353324-fed5-469c-ac6c-46ce5887edd8', '六环以外', NULL, NULL, 293, 'd5bceaed-c2c5-4104-a42c-4c9c8114c7c9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b545bed5-7951-4d05-bd5f-7c954920530f', '安岳县', NULL, NULL, 3015, '951c8fd2-5d67-4ba4-b9a1-fd13fdcea9f9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b55c7c4e-048f-4d44-ac09-2131e0979614', '东成镇', NULL, NULL, 3216, '2e21ea75-c640-4928-8cb4-e5ba4f6e2ffe', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b55ee931-b566-4e00-814a-8ebf01c2a5aa', '禹会区', NULL, NULL, 886, 'be39aa7b-a993-4abd-956c-dcb299cc7bc3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b560a8d8-08ac-4473-927c-f0c1ffc4aed8', '元朗区', NULL, NULL, 489, 'dfb8b556-10a2-43ab-9fdb-66cde92320ee', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b5625b30-5060-48e3-bf29-3fa90eeb2a94', '铁西区', NULL, NULL, 682, 'de003161-c00c-4f8a-ac92-6a2188069e9b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b5637033-025e-4036-b9d3-0c2f55afe400', '汾西县', NULL, NULL, 3695, '1aeeea9e-d028-4a96-94ce-ba84cdd3e69f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b56aa20f-b370-48bb-a79e-ea4772e8e033', '清丰县', NULL, NULL, 1259, 'e16eafe9-9ca0-4609-8c8c-a1b16b52669f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b575bb16-4b4b-44c5-a502-74021a08b21d', '三河市', NULL, NULL, 1230, '86f7f02d-658e-44ec-9d36-b14cc3c65aaf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b57ee5d6-6cf2-415d-acfd-87c03ffad7d8', '板桥镇', NULL, NULL, 404, '9d7d52af-ec34-48e3-b81d-09ac51e11590', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b5927d77-0ade-47ec-b21e-f855c83af744', '陵川县', NULL, NULL, 2853, 'ffe07042-807c-4f16-a63c-c1eb8785b06b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b5a91240-f70a-424e-8c7b-d521003f8dc7', '隆广镇', NULL, NULL, 548, 'b75db043-9782-4bae-aaee-bea49fc286e6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b5e030d0-7eb7-4d2d-9caf-bccb1844eb6e', '汝州市', NULL, NULL, 3386, 'f5ebab20-0f47-47e8-b896-6f3d9651c97a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b5edb097-d0da-4d47-96c3-09ceca8e6516', '新区', NULL, NULL, 2215, 'e658aec8-1268-4349-a3f5-570b669a4f06', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b6011fd3-5384-4b0f-8e72-ef04c0958b26', '东山县', NULL, NULL, 1205, 'bda1d0f2-1476-4e0d-8fb9-2d1392397cbb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b60707e7-e992-4e77-a670-fa45061a5e8f', '金坪乡', NULL, NULL, 380, '76dd00a1-30a1-4226-ae06-cad845c0528c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b61825d5-6688-4384-8b3e-4879f57c74da', '净潭乡', NULL, NULL, 2160, '671275c4-6107-4968-bd8e-96d53e9995b2', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b62ed7b1-7f9d-4c62-baaa-a23bee1b6d23', '蓬莱市', NULL, NULL, 595, 'f3717726-7743-4838-852b-3a09f9528a69', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b63dca90-81dc-4b29-a78c-4d0819a1cb40', '桂东县', NULL, NULL, 1312, '50d6a2ea-ba0d-4ff5-8b4c-f9d84e79e381', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b65d6fd2-08b9-4f83-8c50-5f9357f7ad5b', '高新区', NULL, NULL, 617, '278acb58-4d2d-40cb-a572-1fc7fb979c77', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b666c179-3cb8-40ae-b409-d8e6d231f466', '南平农场', NULL, NULL, 543, 'b75db043-9782-4bae-aaee-bea49fc286e6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b6684531-27c2-4479-8783-80a4cb81f5b5', '白沙农场', NULL, NULL, 1355, '21bb958f-e5d4-4a71-a350-b5bf2c0e2de0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b677b884-4b56-4a40-af90-70a0bc51f000', '辛集市', NULL, NULL, 2767, '334645de-ae54-416a-8978-2dbf9f7bbd09', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b6800ec4-80de-4211-b31b-a76ef9b8e18c', '北大镇', NULL, NULL, 4491, 'f491d9c3-9527-46a4-8954-6795ff079478', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b687ec61-62f0-43ae-b3cc-bf1d31194346', '腴地乡', NULL, NULL, 2949, '465e9ea2-a2f2-4b42-95dd-b48d91f67105', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b6950973-7773-42a1-ba16-e73589af3946', '什邡市', NULL, NULL, 3618, 'b2c794cc-d351-415b-b53c-cf0c454c1165', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b6a93dc2-9553-4e40-9542-9e8fe48fc8bc', '靖州县', NULL, NULL, 2022, 'd133a3fc-3db0-426f-8a04-e25b44a5565c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b6b4c9b1-8ea2-42e1-9cbb-4ac58a362a3f', '三家镇', NULL, NULL, 3609, '46073b56-9ab9-4efb-874f-efe112a304a6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b6be1d3f-a67f-4f8a-87c3-ee3e1f8a074b', '永仁县', NULL, NULL, 2098, '50868d97-8741-48fe-9cba-86e2e118f220', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b6c72ac9-026b-448a-9ff0-81065c23c02f', '万东镇', NULL, NULL, 3680, '6581d8db-553e-4417-8c37-91ed47904920', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b6ccdf53-45e5-4aeb-afa3-bec0344be9dd', '千阳县', NULL, NULL, 1833, '7c3fbad9-df03-4d15-93a4-695924a2f35d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b6cfb666-4a95-4872-8024-629dc608c16d', '睢县', NULL, NULL, 3141, '62aa4f78-f1b9-44d1-9372-21e01c353757', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b6dc2af1-2341-43e3-b629-066c604efa6d', '壶关县', NULL, NULL, 3857, '6fc78ef9-e2eb-46bc-bf8e-8b830ad96136', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b6e19493-208b-4bf2-adb4-079837e2cf79', '兴隆县', NULL, NULL, 4031, '8db8f645-a1a6-4c39-9c27-2f703951f66d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b6fdefa9-a9fb-417b-98ff-536cbf3c7f82', '梨树区', NULL, NULL, 2412, 'f583e1ae-7239-4815-b3c7-c5538eb73da9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b70a7b29-ece1-497c-baab-99fa90cb0d63', '萨嘎县', NULL, NULL, 3652, '5800fbac-51b0-4bc6-bc2b-34f78067fc28', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b70eaebc-40b1-4c7d-b097-a117f5bd42e4', '长白县', NULL, NULL, 1399, 'baaceb68-ffec-405f-8bcc-9d58ab5a0c1e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b71b3bba-3d98-4f03-b40e-8ca29a7b290d', '寮步镇', NULL, NULL, 3316, '3bc6861d-0eeb-497e-9257-42f9cd6fd26f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b722c166-040b-48e4-a6db-a3c7014cf334', '吴滩镇', NULL, NULL, 904, '41f376c0-764f-46b9-af35-e555518fc613', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b732b5e7-5599-4168-bfef-2761a4989d0b', '乌杨镇', NULL, NULL, 2670, 'e509a1a5-95da-4fb2-9a2b-f84afa05a36c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b73d54e1-2ff6-48cd-95fc-39036f75f3a7', '堆龙德庆县', NULL, NULL, 4156, '5a657ab2-3d76-4a46-917c-ddfe22c60d16', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b73fac9b-1d70-4eeb-b077-060efce20441', '大姚县', NULL, NULL, 2095, '50868d97-8741-48fe-9cba-86e2e118f220', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b751854e-b239-4d9d-9581-8bf78d607644', '江安县', NULL, NULL, 1819, '18a8dd20-aad4-43cd-ab48-ab6108097d8a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b76af5c1-5eae-4e37-ab01-309073458dc5', '竹山县', NULL, NULL, 3932, 'd795e41b-eb16-4383-b762-ea557481f8e1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b7832be5-4248-4035-98a3-11562de96dcd', '木兰县', NULL, NULL, 1537, '349a18f4-4117-490c-b26f-80702a4911bf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b7a26ede-de2d-4aed-bf89-3cebeb03000a', '合作市', NULL, NULL, 3127, '9d7c5001-b115-4bea-abb4-a289a03b5075', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b7dfa9ea-bf58-4a9c-9e68-77fa7be86cec', '洛扎县', NULL, NULL, 1019, 'f7038861-43d2-49c3-a5c9-53fde2c139fa', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b7e8760e-617f-49fd-b750-fc7c81f127ca', '小沔镇', NULL, NULL, 3889, 'a732da28-870c-4d9c-a287-c2c1e3222b59', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b804eb06-0a41-4b0a-abd4-d4b195e7c830', '昌邑市', NULL, NULL, 447, '3e54862f-40e4-4b44-b318-6a64b04a9558', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b80cf971-8d3c-4496-917a-aae78677f922', '和平县', NULL, NULL, 1721, 'a9736c65-aeba-4a39-861f-5edf105d8673', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b80f31e4-d394-4e3f-a630-e48b6ecbda33', '龙溪乡', NULL, NULL, 1893, '2c8bc8c3-9317-4f36-a0ad-05a8d6b27053', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b84fdf51-5d78-4d10-9d2e-4dcc2b594fe0', '后湖管理区', NULL, NULL, 838, '24ad0708-80a9-43b1-8e1c-758f2492d3f6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b8528670-7472-4622-a38e-ea4d5d17573d', '满洲里市', NULL, NULL, 1059, 'c31a65eb-4d77-4b38-8142-9c9e2f54ed46', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b86ef486-a73d-43cd-96e7-8d9cbc97e96b', '泸西县', NULL, NULL, 3155, '99a9abd1-f107-4dc6-ae43-e9d1120504b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b88c9f4a-d9c6-42be-816a-1c7a3cf2cd2d', '襄垣县', NULL, NULL, 3853, '6fc78ef9-e2eb-46bc-bf8e-8b830ad96136', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b893546f-8294-441c-9477-10861df28a7d', '广阳市', NULL, NULL, 1231, '86f7f02d-658e-44ec-9d36-b14cc3c65aaf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b8ace8a3-6010-492c-a7da-3ae34cc39d89', '孝昌县', NULL, NULL, 2755, 'caa97f6a-9b5e-4871-968e-42852537e6f0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b8b221f9-7442-493f-b929-18a1dd2f71e7', '耀州区', NULL, NULL, 915, '667720b0-8429-42ef-b6a6-582df9b59468', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b8b35dc7-d389-4e03-9443-60fd3e7d638f', '商河县', NULL, NULL, 4360, 'c6ac73d4-9854-403a-9b61-12c22eeb4903', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b8b6fb4a-08a5-4cee-afca-e0b3ca3bf082', '虎门镇', NULL, NULL, 3331, '3bc6861d-0eeb-497e-9257-42f9cd6fd26f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b8b6fe40-1abd-4c82-94a4-1432e6b09838', '麒麟区', NULL, NULL, 1327, '9568bdcc-65c2-4b1c-a512-b2ff897db321', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b8cb3587-c638-4248-a474-80c493d9f283', '路环', NULL, NULL, 919, '691e132f-04a3-4856-a77a-92ed2dc5c246', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b8d00ae7-cde4-4fe8-b09d-833514553921', '献县', NULL, NULL, 2889, 'a3c44525-9ccb-429d-a2b7-f5f5d52b8a6d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b8d8a70e-3790-460e-9803-0a466cf9df49', '民权县', NULL, NULL, 3138, '62aa4f78-f1b9-44d1-9372-21e01c353757', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b8e39f9e-e0a0-4663-8944-3c749b63c9c2', '福田区', NULL, NULL, 672, 'fd718129-208d-4a94-9e52-7516af8ef013', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b8fbd669-fb36-4fe4-b4b1-f5eac8cd6b3c', '赫山区', NULL, NULL, 82, 'c2eab125-e437-4681-9331-695a7b3b1ecf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b8ffac7d-1e26-46c2-8ffa-440c9aa21cbc', '陈场镇', NULL, NULL, 3473, 'ea11feaf-194c-4cec-be59-d17bac402db4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b912fdc0-1d48-4ceb-9a90-afc9edd2a9f6', '温宿县', NULL, NULL, 4397, 'b7bc3a10-ad00-4b20-9fa4-cb08ad7492d3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b9134732-a500-4910-b0e1-47c3c484719f', '双山乡', NULL, NULL, 3848, 'c33c3107-81df-4ced-8b92-d694df412da3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b923f574-c800-48c0-96dd-5e1b25362c22', '西陵区', NULL, NULL, 1776, '3760382f-ecb5-4ef6-8bd2-049afe34b574', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b939ccd4-019f-4316-b633-132f8a3e50ef', '略阳县', NULL, NULL, 348, '5c4e7f63-9162-47e1-a948-c64ca46ff566', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b945af84-6efe-4753-87d8-9f9e4b9bc8ec', '三义乡', NULL, NULL, 1900, '2c8bc8c3-9317-4f36-a0ad-05a8d6b27053', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b94be09b-07ab-4349-84c7-4d430ea56ab3', '南平镇', NULL, NULL, 946, '88260608-a8b9-4b52-a474-1a551465c675', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b95d06b3-615b-43e8-8262-75ebb88f7978', '颍州区', NULL, NULL, 1629, '6de68814-d6ea-430e-88b6-bf98620aa604', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b9679dae-4b3e-4355-a620-6a9d2d68c352', '芗城区', NULL, NULL, 1196, 'bda1d0f2-1476-4e0d-8fb9-2d1392397cbb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b983c2f9-a0a3-40b4-9c9b-498aa23f6969', '大团镇', NULL, NULL, 2640, '4683d3ef-0edf-425a-98d5-2cb231a7d88a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b997294e-0932-4efa-bc9c-92d75a6f934c', '罗源县', NULL, NULL, 4252, '71a49c5c-c3c2-4fcb-8f90-aa1d733a19f7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b99fc1ac-a985-479e-af49-51b49e58b81f', '郊区', NULL, NULL, 2117, 'c3c4411b-8905-45b4-b38f-09be90102664', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b9a28c5e-fac7-44f0-a32d-253e0e41ae43', '大宁县', NULL, NULL, 3699, '1aeeea9e-d028-4a96-94ce-ba84cdd3e69f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b9d352ed-997e-4c4c-959c-e59ef8d16bb2', '泸县', NULL, NULL, 580, '78000393-73bd-4a54-a688-5db0e578d9cd', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b9e1567b-b70b-4251-be59-09a11993e89e', '务川县', NULL, NULL, 3436, '69324865-24e8-4abe-a068-a1392c117c0d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b9e7e88c-22b3-4bd9-aa8e-616f67a0a74d', '杉岭乡', NULL, NULL, 3376, 'aa2f26e5-9705-4dc0-b54a-a2d7dbb8b511', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('b9fc0301-3533-4ecb-9311-593df42483f7', '乐亭县', NULL, NULL, 2462, '4f4c1ef4-f54d-4ba4-a124-ca2d3d0ddb78', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ba1673bc-f12e-4d6c-bf9e-29832d49eb5b', '盐田区', NULL, NULL, 678, 'fd718129-208d-4a94-9e52-7516af8ef013', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ba1c5645-2b38-4441-a160-35c0b8379042', '县城内', NULL, NULL, 963, 'cc124ed6-091a-42ce-a87a-bb4d0d7357b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ba2fa07c-d755-41b7-a302-3ab635633280', '宁武县', NULL, NULL, 2838, '18b3c51b-f699-467d-a342-d78bf9cff362', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ba320e5d-fb5a-4765-b58e-efaf05016cc8', '贾嗣镇', NULL, NULL, 898, '41f376c0-764f-46b9-af35-e555518fc613', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ba3f4559-d22e-4d88-8381-652e4ac23afb', '大周镇', NULL, NULL, 4203, '0ee28cef-8dfc-4a9f-b7c1-330bc11c1bb3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ba4ed70d-a968-4008-9a35-5fb7fdf359a2', '越城区', NULL, NULL, 1418, '472589fe-78e1-4c48-8fde-cf3996a778ca', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ba64d9ad-e4d7-4ed2-bd85-86e6d6f3eb9d', '经济技术开发区', NULL, NULL, 3917, 'b3b5e655-b2df-467e-ad5f-2ab21c2a0aba', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ba982760-d8d4-4800-b738-0eca1c9259db', '宋农乡', NULL, NULL, 989, 'cc124ed6-091a-42ce-a87a-bb4d0d7357b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ba9b1265-48dd-433f-8184-aa8ca37351b5', '枫木乡', NULL, NULL, 808, '0f559985-f6fe-4a8f-af80-3d0d64932dbc', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('baa1684a-929c-4e60-948d-7b666b587d30', '任家镇', NULL, NULL, 2664, 'e509a1a5-95da-4fb2-9a2b-f84afa05a36c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('baa6733f-8aa3-4b6c-a5cd-b2af4ebe24c7', '宁强县', NULL, NULL, 349, '5c4e7f63-9162-47e1-a948-c64ca46ff566', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bac00306-6fcc-4e88-b967-b9e7eea3ecae', '广华', NULL, NULL, 825, '24ad0708-80a9-43b1-8e1c-758f2492d3f6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bac189f3-f240-4e90-b788-13db71e92cce', '鲅鱼圈区', NULL, NULL, 2687, '1c705a6d-5a16-4544-905c-68134716c6cf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bae9f8fb-59ba-4dfc-850d-5c93a4beafd4', '吉木萨尔县', NULL, NULL, 1275, '8db1e665-1af9-4697-8514-7fa18e3a8683', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('baebad8e-a074-40c5-81c7-d5872f37db26', '楚州区', NULL, NULL, 754, '3c9ba44c-7031-4422-b9b7-85d772ee3e08', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('baf90641-aa99-437d-8228-70707b270d00', '利津县', NULL, NULL, 1215, '1de2a515-79f9-47f9-a31f-f6892f97a705', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bb04509b-5147-419b-a4e3-76da751cbfff', '噶尔县', NULL, NULL, 2902, '3a856f9e-a1e5-4657-b81e-cc7d76d14ff5', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bb05773b-e9d0-4c47-8fb0-df7898a8e8fd', '宁江区', NULL, NULL, 4438, 'a632ea02-ee66-43f0-b946-2bce0ba5396a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bb45d8ab-c6f8-480b-9705-7efbbaf145d3', '丹凤县', NULL, NULL, 1392, '332e1b20-ce8a-4065-ab84-b60416060476', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bb50bea7-f547-4f1b-acaa-8add23c762f5', '新盛镇', NULL, NULL, 658, 'd7f44c2a-2728-4633-a8b6-7643136bc99d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bb7cf48e-bb4c-4892-9922-4d4f0f9edebe', '涟源市', NULL, NULL, 3747, 'cff58e36-5b90-4beb-a3b7-e04021d244cb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bb7d9e9b-8642-4e66-af0a-467ada2bda3d', '花桥镇', NULL, NULL, 2660, 'e509a1a5-95da-4fb2-9a2b-f84afa05a36c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bb7ef0e3-77c0-4e16-9e71-3a549cb0cc26', '竹山镇', NULL, NULL, 662, 'd7f44c2a-2728-4633-a8b6-7643136bc99d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bb88846d-6ea1-44b9-9841-8d9be0d50cb7', '东昌区', NULL, NULL, 865, 'def0f6fb-9804-4bed-8554-2115bfca9849', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bb8b7cb7-09c4-41f2-8cef-125eb366a752', '乌尔禾区', NULL, NULL, 1434, '24925ffc-d2fd-4b44-823a-250fcc224503', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bb9b1489-26bb-4fd8-92f0-c7960b85ac0c', '三角镇', NULL, NULL, 2196, 'f2727650-b0d9-4541-acdb-b4eabf894893', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bba0582b-1fc8-4ef4-bdbd-8866f805b72a', '屯城镇', NULL, NULL, 4328, 'e98653ba-264e-4417-b74e-e0798b25e646', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bba5397f-4644-4bb6-94c9-36e73875a494', '潮阳区', NULL, NULL, 1442, '8596baaf-4bfe-4522-a422-f397f3494bcb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bba99664-134d-4002-97ed-7cd4a5b3a8dc', '加乐镇', NULL, NULL, 4086, '5d3b3a34-50c8-4a01-83b7-e3e068d5c9a7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bbb4d492-7b80-4ee1-8669-a8ee3221d45d', '淇县', NULL, NULL, 3439, '2130bd75-b4cf-44af-a13b-2b64109f0cb9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bbc8dd7e-ab3e-4b96-baec-c4fa59a6ae48', '乌鲁木齐县', NULL, NULL, 3236, '8349c2b0-91a2-4e19-b9c7-81b5224fbabe', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bbdb0bce-0ca1-4fe9-97a7-93cb8a0cc82f', '宁晋县', NULL, NULL, 1024, '4d6c5692-82f1-443c-9163-39a3dd77636b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bbf38b48-53ee-4138-a497-bab914cf4b8a', '克井镇', NULL, NULL, 3927, '22f622f8-7eaf-41e9-90ee-2a0cfda1f326', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bc12efa7-6e60-466c-bf06-ad321e03c3ef', '封丘县', NULL, NULL, 2183, '1aabde9d-2b04-4892-a20d-5b4e3efaeedf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bc130da5-c920-4af6-9840-854e8f655f84', '中仓街道', NULL, NULL, 2120, '88d84710-80d6-4837-b889-286c74d7940d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bc1d41dc-af49-4d74-b685-f8e8f78743c9', '建平县', NULL, NULL, 4139, '0c1d1a8a-4eea-4aa0-9a5e-b68ae380a09a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bc26ee57-4526-439a-9408-b50ec882b0df', '玉树县', NULL, NULL, 2070, '27eaf8ae-634a-45eb-bdc9-207c699d16ef', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bc26f76f-25c5-486b-8529-da4cf0f5cd25', '李遂镇', NULL, NULL, 3729, 'd1c1539c-b904-4bcc-a034-96213f63d0ff', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bc4805bd-c148-41aa-bcbf-edd16c517875', '理塘县', NULL, NULL, 3778, 'c262a40d-a147-4930-b33b-574ec51fa884', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bc4cbd03-9dd6-41ba-96ee-de75b48d353a', '经济开发区', NULL, NULL, 753, '3c9ba44c-7031-4422-b9b7-85d772ee3e08', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bc56c969-1b5b-4193-b077-10a65c2ab841', '安居区', NULL, NULL, 3023, '44b40fc1-5bf4-476c-b869-580342d65c02', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bc6c7518-1baa-4026-8566-74738e00b2cd', '港闸区', NULL, NULL, 1744, '7de09763-759b-437b-a3aa-4cb32bd3c6b9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bc83cdfa-5264-4245-8259-df0b6fff8471', '新龙镇', NULL, NULL, 3611, '46073b56-9ab9-4efb-874f-efe112a304a6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bc8e5fe8-0dd7-4f94-b7eb-93a441b3180f', '福寿乡', NULL, NULL, 927, '88260608-a8b9-4b52-a474-1a551465c675', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bca59aae-a179-4f00-b2fe-82be1a88e113', '洞鹿乡', NULL, NULL, 185, '4f867632-2989-4def-9934-a9c5fe0d5ca5', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bcabc58c-b4b3-4bb8-9890-8e316ac7941d', '火炉镇', NULL, NULL, 4447, '4888e1e9-ba45-4254-83e7-87796f338e2d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bcc7dc6e-3f39-4f93-b014-d2be310da4db', '海湾镇', NULL, NULL, 637, 'fa34c22b-c1d8-45b2-bb1b-4ea08298e7f6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bcd9fb47-8a4c-4497-9a04-2daed0be5833', '吴堡县', NULL, NULL, 1302, 'c0c88cbd-87ea-4281-9e8e-94a435ae6590', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bce124be-c221-46fe-8b73-7e52fe7e2824', '狮滩镇', NULL, NULL, 3886, 'a732da28-870c-4d9c-a287-c2c1e3222b59', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bcf1d437-a9f1-4e70-84ce-b933d341a324', '南明区', NULL, NULL, 531, '46abe060-5805-4aaf-9d89-b66bed4b224e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bcfb9767-572c-417c-abb2-d131961f4b4c', '县城内', NULL, NULL, 3590, '27289f06-ca7a-4916-8f25-f6b13d8687ec', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bcfed2f5-1156-4dff-be3d-7cbb5f171dec', '保德县', NULL, NULL, 2842, '18b3c51b-f699-467d-a342-d78bf9cff362', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bcff59cc-2025-4510-abf8-c476e72ee4f1', '通城县', NULL, NULL, 956, '7a5b4813-b095-4a1a-a008-1297fd9aa978', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bd070930-5fb0-4a8f-8e97-37fc57826962', '凌河区', NULL, NULL, 1071, '99f84690-670c-4a0e-ade1-ebcf17b00adb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bd137641-f705-45c3-927f-20ff138edb99', '恭城县', NULL, NULL, 3183, '796bb0e0-6b76-4c1d-801f-2dbcbab74087', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bd14ca9a-6c0c-474f-843e-4920730352a8', '蓬江区', NULL, NULL, 3310, '2a61b8e3-4156-42df-836b-fc855d156f23', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bd3222b5-46b9-4af4-91bf-366074dbadae', '沈河区', NULL, NULL, 1846, '271a8d5d-a9a3-4876-a9a2-ca9bcee4b83f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bd39ac2d-758d-4571-b268-9b214bee70c7', '乌拉特中旗', NULL, NULL, 1684, '753245e5-8705-4940-badd-cd71430a4fdb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bd3fa003-8032-407b-b031-68e91dedcedd', '海林市', NULL, NULL, 1971, '1c2bd9d2-bc08-486e-a5f3-ba5de82c6365', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bd42a03d-b5d1-4c2f-95d1-580d7dc94c0f', '故陵镇', NULL, NULL, 168, '4f867632-2989-4def-9934-a9c5fe0d5ca5', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bd47d412-850c-4582-802e-353320bccd90', '临渭区', NULL, NULL, 3172, '9e5ae65c-206f-4d7b-87f2-c252d5f40b52', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bd599e43-0ece-4c90-bce8-a2cd325f7f34', '白鹤镇', NULL, NULL, 2543, '89a9c37c-487a-4c32-968c-cf9fefad8151', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bd5f8d78-8163-4c7f-ae51-f1adb7c72c36', '永泰县', NULL, NULL, 4253, '71a49c5c-c3c2-4fcb-8f90-aa1d733a19f7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bd61b34f-2abb-4900-b3e5-9b45ca73aa8b', '赵西垸林场', NULL, NULL, 3478, 'ea11feaf-194c-4cec-be59-d17bac402db4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bd68c800-c013-4635-a8ed-2858b99f1e0c', '青龙县', NULL, NULL, 2711, 'f4bc760a-86e0-4fa1-a5e9-cdc21cc7a127', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bd693db2-c6da-4b23-8df7-ef0db6cc7462', '索县', NULL, NULL, 4412, 'fae5ed6b-9b68-4ef9-93fa-221dea13a975', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bd7b3a1e-3f2f-46af-b334-b9bc39945b5f', '单县', NULL, NULL, 1789, 'e04fe06c-7641-47c7-a125-4d35e1800549', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bdad1ae9-1dd7-466f-8507-e108e4782689', '岐山县', NULL, NULL, 1828, '7c3fbad9-df03-4d15-93a4-695924a2f35d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bdb48cc0-ce4d-452e-a8a7-2517e49b5008', '连山县', NULL, NULL, 2955, '8377f1cd-7272-4396-b99b-84bb707dbc2c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bdca7059-eb35-4a3c-bea8-06dc56ba2bd5', '湘桥区', NULL, NULL, 4384, '08acb8e2-e168-4e7b-81ce-918197cf4ecf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bddc86c8-3492-457f-991e-fcd63ce58e29', '土溪乡', NULL, NULL, 937, '88260608-a8b9-4b52-a474-1a551465c675', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bde1a049-72c6-49b8-80bc-d4686e5196d7', '洪安镇', NULL, NULL, 969, 'cc124ed6-091a-42ce-a87a-bb4d0d7357b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bdef0c45-84cb-4032-be34-74a56d8a1690', '铁山坪镇', NULL, NULL, 1716, '86ab4d11-9653-4b0d-8cc1-2e12a4de15d6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bdf97bc3-2825-4955-ba02-c894197d913e', '乡宁县', NULL, NULL, 3705, '1aeeea9e-d028-4a96-94ce-ba84cdd3e69f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bdfc33ed-f7b5-41e3-8e7b-ab918a9c2be7', '竹园镇', NULL, NULL, 1095, '79482cd9-7d51-4c89-94c2-4bcd773b8323', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bdff9875-213f-4eec-8f04-89ff5713bc9a', '岩东乡', NULL, NULL, 1910, '2c8bc8c3-9317-4f36-a0ad-05a8d6b27053', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('be11fe1f-2a33-424a-bbc7-ecfb2829bfcd', '于家务乡', NULL, NULL, 2133, '88d84710-80d6-4837-b889-286c74d7940d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('be1764ff-9173-4045-9764-bdec132b75cc', '温县', NULL, NULL, 4012, 'e95972c4-fd28-45ac-b9da-9aee0057d3d0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('be21b96f-ebbd-46e9-bbbe-f1d9acd1d0f8', '小林乡', NULL, NULL, 3847, 'c33c3107-81df-4ced-8b92-d694df412da3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('be2b7e65-6255-4a1c-953b-a870eacc9126', '双龙乡', NULL, NULL, 1905, '2c8bc8c3-9317-4f36-a0ad-05a8d6b27053', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('be4a5517-d82c-4a17-9364-cdbdf250bbbf', '石门县', NULL, NULL, 4301, 'dd99fcda-6192-4ada-bef5-b04735e7dae8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('be61e61b-97fd-4078-a9f9-dcf6325b61f8', '云龙区', NULL, NULL, 4428, 'e20441c5-c8b4-493a-9738-2327e656fbcb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('be6a8a62-40a0-44da-9d7b-73f9084d6978', '新田县', NULL, NULL, 1734, 'c7d6739c-4d7d-4d8f-bf6e-d6a6a7d38f20', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('be6e4635-71b6-46a5-b925-22a92276e91a', '王下乡', NULL, NULL, 787, 'af6f4f65-b2db-4670-88ca-21de1de477fc', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('be75d393-0987-4c80-a0ab-2102cb3a5e53', '鹤峰县', NULL, NULL, 2357, 'ecba10ba-2c25-4ead-a781-ad16a832226f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('be765836-f763-46f7-9278-e04ab257d9f5', '复兴区', NULL, NULL, 206, '237eff18-fe6c-4842-afb1-acb05027a5c1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('be80eff4-3b3f-4138-a80e-c7caf3d5a55b', '虎峰镇', NULL, NULL, 3843, 'c33c3107-81df-4ced-8b92-d694df412da3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('be8b5726-8186-499c-b890-05dc98f992dd', '维新镇', NULL, NULL, 3833, 'c33c3107-81df-4ced-8b92-d694df412da3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('be8dd2a8-af10-4b53-a970-399a138dfbad', '巴家乡', NULL, NULL, 978, 'cc124ed6-091a-42ce-a87a-bb4d0d7357b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('be9d533a-5a78-461b-b8ba-adbf7db04162', '旧县镇', NULL, NULL, 3842, 'c33c3107-81df-4ced-8b92-d694df412da3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bec7f5ab-d492-4916-9f33-9024004b57e1', '青阳县', NULL, NULL, 2047, '7294fb6c-cbd8-49b7-ad18-f285bc43f1d9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bed97a6d-3c74-476a-9952-28c3de288f61', '昂昂溪区', NULL, NULL, 2729, 'f4e36f9a-e006-44a6-8d77-47971d41810b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bee01ca3-a22e-423d-8d77-bb4d8efb112f', '云龙县', NULL, NULL, 234, 'feece7c8-8eeb-494a-8e84-571b6ebcf0d9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bee579a9-1405-4fc3-be9a-b9818c723349', '科尔沁右翼前旗', NULL, NULL, 2973, '9758648c-eab9-4434-b7ae-318e7e08548e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bf00c4d2-b08e-4509-bcaa-2375a51c6426', '绵竹市', NULL, NULL, 3619, 'b2c794cc-d351-415b-b53c-cf0c454c1165', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bf088901-e9aa-409f-865a-9271d64741f0', '兴仁县', NULL, NULL, 3105, '875ed189-3d32-4466-a24f-7cbac524774e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bf09048a-4fdc-4b4e-bf6b-2f91bb9b5895', '新洲区', NULL, NULL, 425, 'e6e46871-d5a0-4d2b-8243-9d4bd864ab43', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bf0baf5d-ad26-4755-8c9e-9cf2a3d84902', '宜宾县', NULL, NULL, 1817, '18a8dd20-aad4-43cd-ab48-ab6108097d8a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bf0ff363-4f2b-402b-aeac-36c932996bad', '稻城县', NULL, NULL, 3781, 'c262a40d-a147-4930-b33b-574ec51fa884', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bf1074f9-c0b8-4778-af33-b6dc5241cda7', '新源县', NULL, NULL, 2589, 'e6f53877-d5bf-4b42-aded-5ab8960ef034', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bf148b16-a066-46a1-9259-ea2e3a71f8ee', '铜鼓镇', NULL, NULL, 372, '76dd00a1-30a1-4226-ae06-cad845c0528c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bf3dd650-1703-4563-bbc2-e68b4bf55714', '大通县', NULL, NULL, 3865, 'baa2f053-c419-40c1-93fe-68e081b7f229', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bf50907d-0de0-4c76-8a2b-89e2b5f2a020', '三环以内', NULL, NULL, 1699, '576c43af-0a86-47d9-83a7-4989ce3b3dc7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bf58c987-1186-4e7a-b16a-32a15167eab4', '万柏林区', NULL, NULL, 101, 'de59cca6-548c-4009-9776-5daae2b866a6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bf5f94fd-2bb7-42b5-8b24-1c790634c2d6', '四环至五环之间', NULL, NULL, 294, 'd5bceaed-c2c5-4104-a42c-4c9c8114c7c9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bf63efe5-f785-49d6-9e16-6f75d44f0a35', '南圣镇', NULL, NULL, 11, 'c8bf9a67-2bfc-47fe-9580-3f2f2eac1edb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bf6d9d53-b62d-4394-98f4-3591fede212b', '西峡县', NULL, NULL, 730, 'a769a530-0bcf-4e52-a9e5-3a8f5af945d2', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bfa20de7-99b5-4a65-aad9-2d4d8d8c9947', '汉源县', NULL, NULL, 3631, '6af0e8d8-91c9-43be-be32-5ec5c86b14f5', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bfa81716-f71d-4d6b-9f0d-2f54826c378c', '相城区', NULL, NULL, 611, '278acb58-4d2d-40cb-a572-1fc7fb979c77', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bfb06e60-dc16-4c6e-8b78-4b1d06a1c937', '江汉石油管理局', NULL, NULL, 843, '24ad0708-80a9-43b1-8e1c-758f2492d3f6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bfb9486b-b33e-47c1-957c-354e7a595d4e', '黄埔区', NULL, NULL, 1989, '926eaeaf-e8c5-47f2-89ff-6932b52c87d3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bfb9a2d1-4e7c-41de-8f4a-9b7245858aa0', '十月田镇', NULL, NULL, 782, 'af6f4f65-b2db-4670-88ca-21de1de477fc', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bfc81bc6-b0b3-4a83-b07c-1362629745c6', '北塘区', NULL, NULL, 2212, 'e658aec8-1268-4349-a3f5-570b669a4f06', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bfcd798c-d164-4d7d-a407-4589b8083979', '多宝镇', NULL, NULL, 2140, '671275c4-6107-4968-bd8e-96d53e9995b2', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bfda55f7-8206-4b30-89ff-afacba335faf', '亭湖区', NULL, NULL, 4362, 'b85d2a61-b018-431a-9609-2ca0841f5cab', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bfdd9983-32fb-4aea-94f0-5527226b9054', '青松乡', NULL, NULL, 1351, '21bb958f-e5d4-4a71-a350-b5bf2c0e2de0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bfec25c2-315e-46a7-9858-7ebb3fd400d0', '大关县', NULL, NULL, 3686, '31187fc0-8d6e-45f3-9653-b7ce4227ef1d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bfeed022-36ac-4601-85be-c5d49589a289', '华阴市', NULL, NULL, 3163, '9e5ae65c-206f-4d7b-87f2-c252d5f40b52', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bff925cb-761c-44d9-b571-ce9c42022e90', '上思县', NULL, NULL, 269, 'b844b23e-c209-4691-8773-29f9f7f080e6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('bff9b8dc-277e-49c1-9998-a701ed8893bf', '新乡镇', NULL, NULL, 4222, '0ee28cef-8dfc-4a9f-b7c1-330bc11c1bb3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c01cd8e1-bab3-4736-967f-13ae7da1337a', '木鱼镇', NULL, NULL, 3071, '4b20c67b-06ca-4c0b-a947-bc518238537e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c0252684-7844-4680-b39a-b16319f69ab5', '康平县', NULL, NULL, 1842, '271a8d5d-a9a3-4876-a9a2-ca9bcee4b83f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c02763e0-2859-4ab8-8452-d9845b8f1fb3', '古昌镇', NULL, NULL, 2510, 'd998f8bc-c659-47ce-8e5e-a6b29e03ecb3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c031fc81-9afd-48b8-81ae-07b7e816307d', '华龙区', NULL, NULL, 1261, 'e16eafe9-9ca0-4609-8c8c-a1b16b52669f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c037119c-cc35-40e1-8342-f64b590070cb', '阿城区', NULL, NULL, 1528, '349a18f4-4117-490c-b26f-80702a4911bf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c03bbd38-b626-4ca5-9be6-e5d46de482ef', '浔阳区', NULL, NULL, 121, 'bcaf1f36-5459-4e74-81d1-5026680b1a9c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c043561a-e9df-4ea4-8644-b31908e61ca4', '谭家镇', NULL, NULL, 3241, 'a39ced08-b6e9-4de0-a2db-7a230a673d1e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c04843b9-175d-4d0a-8b91-d9fe33b0131d', '分水镇', NULL, NULL, 4205, '0ee28cef-8dfc-4a9f-b7c1-330bc11c1bb3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c05243c6-0e1f-475f-8d50-d8dceb4bd2f6', '佛坪县', NULL, NULL, 343, '5c4e7f63-9162-47e1-a948-c64ca46ff566', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c068c13a-4fe7-4a5d-bc57-9e7f0c4298fa', '永新县', NULL, NULL, 4319, '5f548430-51dc-45ad-82e5-bcd0394d8f6c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c07887ec-e605-473c-94c4-44ead53f1dd0', '富蕴县', NULL, NULL, 3523, '2ca5ebc8-b3f5-49d8-b421-85ae2dc0de35', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c078e03b-9d04-41ca-96b2-a2627ed83fd3', '土默特左旗', NULL, NULL, 1264, '1fdea9c2-419d-4fd5-b725-8d361e4376fb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c0801b13-217a-4f7b-8436-26a8dbd33ee7', '宣州区', NULL, NULL, 1049, 'a489375e-6a4e-410b-be41-f687ba6c52cf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c0910cf8-7a6b-4dda-b217-55033ee705e7', '宁陕县', NULL, NULL, 2981, '55fbb0a6-5436-4d04-9f29-716233f81fd7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c0943341-c992-4abe-9d2f-d70c19334ca3', '绥滨县', NULL, NULL, 3285, '978f3e32-c5e0-48e4-b9ba-4f7f04ed87a1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c0bbab09-d1eb-41ef-9a4e-1371025cb3ae', '万足镇', NULL, NULL, 1883, '2c8bc8c3-9317-4f36-a0ad-05a8d6b27053', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c0c7178c-9df5-4b27-99d4-19d49e375a7a', '点军区', NULL, NULL, 1779, '3760382f-ecb5-4ef6-8bd2-049afe34b574', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c0d80a6b-47e0-47a2-afff-39d755eb0242', '县城内', NULL, NULL, 794, '0f559985-f6fe-4a8f-af80-3d0d64932dbc', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c0eb37b4-aed4-4cee-b871-0d99723c70cf', '依安县', NULL, NULL, 2736, 'f4e36f9a-e006-44a6-8d77-47971d41810b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c0f66ffd-091e-4b90-b79a-f3bf5cb072d8', '施甸县', NULL, NULL, 3145, '3fbd3d32-e8e3-476f-9f4c-319ffaaed527', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c0f726d1-aa6b-4b97-9161-1774b8397833', '江都区', NULL, NULL, 3054, 'f9ca7af3-a2b5-4d1c-a8c5-c4dbe4fe60e1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c0ff100a-7cd1-40a5-8d09-ae5efe723e2f', '庙镇', NULL, NULL, 3979, 'fcc07455-c69c-4c90-82cb-ddb268adb8a9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c1023b27-6f62-42c8-98bc-b95d484a9775', '上蔡县', NULL, NULL, 744, 'a096e337-c439-4751-a014-b49dd13bee26', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c1066b0e-b559-429f-9cc1-5f3ddaf7bbf9', '工农区', NULL, NULL, 3280, '978f3e32-c5e0-48e4-b9ba-4f7f04ed87a1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c110d70e-22ee-4897-a535-a76cf9d96643', '忻府区', NULL, NULL, 2844, '18b3c51b-f699-467d-a342-d78bf9cff362', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c11acf57-a8dc-4bb9-893d-8d03152f7a1b', '高邮市', NULL, NULL, 3053, 'f9ca7af3-a2b5-4d1c-a8c5-c4dbe4fe60e1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c121e516-d437-4339-a881-c9920bb0d95d', '县城内', NULL, NULL, 4443, '4888e1e9-ba45-4254-83e7-87796f338e2d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c1274356-162e-4803-a08a-f80449685d7d', '小南海镇', NULL, NULL, 3359, 'aa2f26e5-9705-4dc0-b54a-a2d7dbb8b511', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c135149e-73b0-4644-88a8-3cd59e04cd16', '沽源县', NULL, NULL, 132, '37614653-bf6c-458f-a844-540790491eb1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c13f8023-330d-4d7c-a0b8-5861c2aea748', '外环外双街镇，河北工大新桥，屈店工业园', NULL, NULL, 4372,
        '74fd7f9a-ddb6-4065-a99c-054987fffdb8', 1, 'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL,
        '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c14b3979-f4ed-43c7-88c7-1077220c2d48', '金牛区', NULL, NULL, 1801, '4f073365-4e02-459f-8b32-cad88dd22637', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c14e859a-55dc-43b0-be9a-6622346ac6ac', '新盛镇', NULL, NULL, 3668, '6581d8db-553e-4417-8c37-91ed47904920', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c15a6b72-edb4-4109-bfbd-7fe9fe554b35', '土场镇', NULL, NULL, 3888, 'a732da28-870c-4d9c-a287-c2c1e3222b59', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c18de407-52d3-4b66-a7d8-7994629de503', '马桥镇', NULL, NULL, 4025, 'f6eb800d-2093-4ce2-8105-3747d69abe97', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c1a61b9f-8c4a-499f-bce7-a3e70c7101e2', '山阴县', NULL, NULL, 2062, '49bad2d2-0c83-48ed-9985-7a709362f3a8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c1b1fef9-f5c0-4584-8659-40f48137c833', '昌都县', NULL, NULL, 2688, 'f7038861-43d2-49c3-a5c9-53fde2c139fa', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c1c0df54-cddd-4bb1-b2a7-5f5d40704498', '开发区', NULL, NULL, 1232, '86f7f02d-658e-44ec-9d36-b14cc3c65aaf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c1c21a47-d75a-4c47-b05f-7c80d049362e', '原阳县', NULL, NULL, 2180, '1aabde9d-2b04-4892-a20d-5b4e3efaeedf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c1cb8ff0-c033-4e9c-82c4-44718d808ac8', '张湾区', NULL, NULL, 3937, 'd795e41b-eb16-4383-b762-ea557481f8e1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c1cc353e-ce76-4f5a-a444-951e9dac2ad2', '育才镇', NULL, NULL, 3060, 'e60d3fe5-6d26-4a3f-b920-8fb6c4986bfb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c1f88307-ce44-4813-9629-66fff4b539bb', '燕山乡', NULL, NULL, 4232, '0ee28cef-8dfc-4a9f-b7c1-330bc11c1bb3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c1fe1dbe-aebe-4155-b43e-9f379ff8c12d', '门源县', NULL, NULL, 3786, '583dc13d-fce3-4f8a-b534-f717ec055405', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c1feb7d3-eb75-429e-8e44-b31313c6d067', '三益乡', NULL, NULL, 819, '0f559985-f6fe-4a8f-af80-3d0d64932dbc', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c208fa9d-8093-4a66-84fe-fa544e3ff33a', '涧西区', NULL, NULL, 1167, 'b5a118ad-786c-4d86-b4e8-5d25a3776a78', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c22520cf-a733-4f3b-ae40-01064f6aeace', '徐水县', NULL, NULL, 2477, '81e22d56-a1c7-4263-be18-81a4af165ae3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c22e9571-7c85-4606-8177-06c8c08e85a2', '榕江县', NULL, NULL, 3086, '6d3a8433-1273-4323-a3eb-d39effecc1d7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c247dc59-0cbe-4fe9-af09-a9a71427a3e1', '金堂县', NULL, NULL, 1815, '4f073365-4e02-459f-8b32-cad88dd22637', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c251d2fe-8cbb-4a6d-bd80-d0d99f867c66', '罗庄区', NULL, NULL, 4349, '56327d0b-ec26-4f34-8ab6-0eba49931c67', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c25437d5-8677-4507-9907-78decb4c7c30', '四方台区', NULL, NULL, 2251, '69696549-d65b-4e13-80ef-05ecaf0f61e3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c25b985e-7ffb-46d4-9ae2-e63fcd0a9cee', '清溪镇', NULL, NULL, 1122, '72d4f69f-2e4c-4bde-9df8-2aadc9168686', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c268e029-8ab5-4c96-aeca-bfdfa91704f9', '魏都区', NULL, NULL, 3563, 'c2e61b39-2188-4b9c-a36f-ef7b600b0188', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c26d7989-7fdf-48b0-8ce7-78af5fba0c8c', '玉桥街道', NULL, NULL, 2122, '88d84710-80d6-4837-b889-286c74d7940d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c2759c31-1b2d-43d6-8202-5822b39d7f79', '雷波县', NULL, NULL, 3520, 'c8f594a3-8acc-48a9-ba2f-e76934de05eb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c27b375a-f889-4231-b248-5c38e9f14f47', '白泉乡', NULL, NULL, 3243, 'a39ced08-b6e9-4de0-a2db-7a230a673d1e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c2bb7a0a-fcc6-4b21-8e91-6d0745e81a24', '李市镇', NULL, NULL, 899, '41f376c0-764f-46b9-af35-e555518fc613', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c2c39091-900c-4eca-8cca-51b557715600', '龙集镇', NULL, NULL, 2519, 'd998f8bc-c659-47ce-8e5e-a6b29e03ecb3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c2d6d04a-c7fc-4403-b2a2-3af0029f41f1', '内环以内', NULL, NULL, 2257, 'd17f8f8e-b3dd-4818-a89d-8b431ff5c555', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c2fc58cb-e29b-45bf-a99d-70ab5fc43cae', '大余县', NULL, NULL, 1618, 'dd4a8577-afbe-449b-ae9b-be374a4c7434', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c30066c8-c61b-4d1b-bb74-57865aebb2d7', '文教镇', NULL, NULL, 3802, '96fec37f-11d5-4d41-aba4-a36d0652744c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c32aa585-e3ec-493d-a783-42e2d8749d56', '米东区', NULL, NULL, 3232, '8349c2b0-91a2-4e19-b9c7-81b5224fbabe', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c337be13-010b-44ba-883d-0a0e7f2a79eb', '两当县', NULL, NULL, 1372, '7c9ca39d-ce8f-469d-899a-09a0a29c1541', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c34df7cb-d72e-4f1c-ba2a-8fab5e681c49', '平乡县', NULL, NULL, 1039, '4d6c5692-82f1-443c-9163-39a3dd77636b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c34f1a66-fc2f-4348-a8c5-1114e149e2d0', '什玲镇', NULL, NULL, 2992, '4b3478d4-3e85-4143-bc6f-ac4a338a9d47', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c36ca899-2834-464b-814b-8cb2c59fae97', '南和县', NULL, NULL, 1042, '4d6c5692-82f1-443c-9163-39a3dd77636b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c37a1758-a48f-416e-8cd7-fcf08e8f37a4', '班戈县', NULL, NULL, 4419, 'fae5ed6b-9b68-4ef9-93fa-221dea13a975', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c393fdd7-8e4a-4893-a931-c2505524180d', '阳山县', NULL, NULL, 2953, '8377f1cd-7272-4396-b99b-84bb707dbc2c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c396dc3d-0c99-4568-978b-1549fa59a843', '诸佛乡', NULL, NULL, 1912, '2c8bc8c3-9317-4f36-a0ad-05a8d6b27053', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c3a9ec96-6baa-4c7b-8e00-0ac079c3dacb', '乐清市', NULL, NULL, 251, '86b77e39-331e-4927-9517-49be7b738b9a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c3ba27a3-6e63-46f2-97f5-2a67ce5ef9c0', '五福乡', NULL, NULL, 2947, '465e9ea2-a2f2-4b42-95dd-b48d91f67105', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c3e91431-7904-4354-a925-f08c1a474748', '南腰界乡', NULL, NULL, 2927, '465e9ea2-a2f2-4b42-95dd-b48d91f67105', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c3ea7b9c-1165-4126-b46b-f57ad5a0831d', '临泽县', NULL, NULL, 689, 'dcdb1184-ab1f-4332-8ca0-f4edfd7cc087', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c3fd6e3c-e5f7-458a-b417-c7ae4bb6652b', '石耶镇', NULL, NULL, 976, 'cc124ed6-091a-42ce-a87a-bb4d0d7357b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c40d8cf3-2e46-4282-a1db-783cfe838539', '安平县', NULL, NULL, 2471, 'b126935b-0423-4bea-b802-d4e6680d1d71', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c415fd0c-2e07-498f-8862-a8323c189c79', '东方华侨农场', NULL, NULL, 3615, '46073b56-9ab9-4efb-874f-efe112a304a6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c41c3f7e-8716-4450-90a6-8283d9ce7031', '武城县', NULL, NULL, 4173, '9c8b6d83-dd06-4238-b7f4-c0ad532e5b6e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c44a45a1-25c0-41d2-8843-777c31e64bc0', '永安市', NULL, NULL, 270, 'cae0a47d-0d79-4fa6-aac9-e8b3b535ee3c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c470376d-5213-4c1c-93f8-0e8ac671e72f', '沅陵县', NULL, NULL, 2027, 'd133a3fc-3db0-426f-8a04-e25b44a5565c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c470f6a7-9125-48e1-93b8-37426a92d9e6', '东至县', NULL, NULL, 2045, '7294fb6c-cbd8-49b7-ad18-f285bc43f1d9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c4b3f522-4a2d-4fb8-8166-370e94d21a72', '云台镇', NULL, NULL, 2084, '4686b935-e3f0-4173-bdfe-ab6a5450d1a8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c4beeb08-2ad8-4e2d-b6dc-abc9c08af685', '鹤山市', NULL, NULL, 3308, '2a61b8e3-4156-42df-836b-fc855d156f23', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c4c268a5-89f5-46f8-ba3c-327565d66c93', '中江县', NULL, NULL, 3620, 'b2c794cc-d351-415b-b53c-cf0c454c1165', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c4c9267c-eb25-47c8-b487-6512ce2e6795', '漠河县', NULL, NULL, 3047, '1b8b9a84-0955-4d1e-8f33-8de97af3bedd', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c4d181cc-aa85-45b8-a9ca-9147dece4227', '信宜市', NULL, NULL, 698, '88bc9baa-b7fd-4bf4-a896-4e049185e0c2', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c4e5c35e-465a-4f95-a7d3-f0bd9d4975d4', '喜德县', NULL, NULL, 3515, 'c8f594a3-8acc-48a9-ba2f-e76934de05eb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c4ed5885-3959-4f0f-ba6c-a7d2cf5b0118', '永嘉县', NULL, NULL, 254, '86b77e39-331e-4927-9517-49be7b738b9a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c4fd4364-f285-48c4-ab1e-8bc905207d5f', '屯留县', NULL, NULL, 3854, '6fc78ef9-e2eb-46bc-bf8e-8b830ad96136', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c4fd8938-d11b-4c8b-ad1b-90c48a8791a1', '美姑县', NULL, NULL, 3519, 'c8f594a3-8acc-48a9-ba2f-e76934de05eb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c5011d0f-75d3-4088-acfb-de4c82862559', '泰兴市', NULL, NULL, 2229, '0541b99e-02a6-415b-8282-4ef9d27cb647', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c50ecce2-7bd3-470f-90af-905980eefc7c', '城区', NULL, NULL, 2699, '0e5598a8-f405-4745-8cd5-a7a4c99f67f9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c5201f1b-2396-46f2-bfaa-d38f6bbf888e', '金平县', NULL, NULL, 3159, '99a9abd1-f107-4dc6-ae43-e9d1120504b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c52558a5-5748-4671-96df-dd4c5bb94e5a', '城区', NULL, NULL, 50, '0863a0a5-7ac5-4a13-80f5-d31e3a1aa459', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c53309be-3980-4ab6-a769-8cfbfa540593', '新密市', NULL, NULL, 4125, '4ff4ef6c-41df-4562-a58f-d8b25b2e3ba4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c53a5723-969d-4f37-8e62-d68b19c86f9a', '县城内', NULL, NULL, 164, '4f867632-2989-4def-9934-a9c5fe0d5ca5', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c54f527b-adbd-4cce-9935-d54380f8cc0f', '城区', NULL, NULL, 3938, 'd7b363e4-0010-4dd0-81d9-387b640a7e42', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c55634a0-4358-43c4-937f-57a827095e26', '临河区', NULL, NULL, 1680, '753245e5-8705-4940-badd-cd71430a4fdb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c55672da-0ff1-4e4d-aaf6-a48a142b6841', '莒县', NULL, NULL, 2424, '552f7151-162b-4453-a9c5-3a9092fce226', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c566b56a-29e3-4eff-a6ca-da78d7a138be', '卫东区', NULL, NULL, 3384, 'f5ebab20-0f47-47e8-b896-6f3d9651c97a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c5712601-d51d-4556-9dbc-c619f80777a9', '城区', NULL, NULL, 4081, '5d3b3a34-50c8-4a01-83b7-e3e068d5c9a7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c576c432-43f5-4adb-a03b-54e10ff06f76', '梨树县', NULL, NULL, 685, 'de003161-c00c-4f8a-ac92-6a2188069e9b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c58b5213-5fda-4404-9012-9d8a92eeff73', '酉酬镇', NULL, NULL, 2926, '465e9ea2-a2f2-4b42-95dd-b48d91f67105', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c5b1f0f5-5504-4623-a5e6-7cfe7431cc31', '南汇新城镇', NULL, NULL, 2636, '4683d3ef-0edf-425a-98d5-2cb231a7d88a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c5b7d002-edaa-4003-bca2-827760702657', '睢阳县', NULL, NULL, 3142, '62aa4f78-f1b9-44d1-9372-21e01c353757', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c5d332ca-64e1-4a56-947a-8dc4cf4b4618', '炎陵县', NULL, NULL, 2612, 'cdeda821-2101-44e1-a986-183436199f05', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c5df859a-d278-4f6b-baaa-2d9edadbf99a', '兴义镇', NULL, NULL, 1930, '442f465d-6566-45e4-9338-50f4395aa6f7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c5e07bfb-7e03-4a59-8c70-e228feb6a7d7', '衡南县', NULL, NULL, 4265, '75dd761e-ce3f-45bb-a86b-d3a1e2c7629a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c5f050f0-3a7a-4f3d-8002-0cc157f9d11b', '栾城区', NULL, NULL, 2773, '334645de-ae54-416a-8978-2dbf9f7bbd09', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c60d62ab-2d9d-48b1-807c-cc237ff400b6', '鄢陵县', NULL, NULL, 3567, 'c2e61b39-2188-4b9c-a36f-ef7b600b0188', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c61abe34-c105-4232-9be1-590c0b961ff9', '蕉岭县', NULL, NULL, 4391, '2aabe025-ea3b-4ce4-885f-9ecf122b3e79', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c622a053-d1a8-43e9-a20b-9f032c413b95', '黑山镇', NULL, NULL, 3675, '6581d8db-553e-4417-8c37-91ed47904920', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c634d3ce-0235-458f-b154-138ab93e1751', '其它地区', NULL, NULL, 4256, '7932fd13-00db-4934-bfc2-79c835527339', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c645f9a9-c970-4715-b1f5-4f64eebd4e28', '长滩镇', NULL, NULL, 4227, '0ee28cef-8dfc-4a9f-b7c1-330bc11c1bb3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c64c3ec5-e4ab-40b6-b76b-f7844e3ac28e', '宁都县', NULL, NULL, 1610, 'dd4a8577-afbe-449b-ae9b-be374a4c7434', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c64ebbbe-b811-42ec-89f8-fc069949038d', '柳林县', NULL, NULL, 3414, '9348509b-6d82-47e7-86d7-f054fb47b7fe', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c652beae-b08b-4d8e-a99c-84d1d34c6425', '巫山镇', NULL, NULL, 3275, 'a39ced08-b6e9-4de0-a2db-7a230a673d1e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c66a94b0-eff3-4da9-abbb-a194d4f87a87', '都昌县', NULL, NULL, 117, 'bcaf1f36-5459-4e74-81d1-5026680b1a9c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c682b803-9a54-4a1d-ba99-dd2b2ee81d9c', '拔山镇', NULL, NULL, 2655, 'e509a1a5-95da-4fb2-9a2b-f84afa05a36c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c6834d76-9352-432a-97d8-a8da7d68698d', '石滩镇', NULL, NULL, 48, '43c813e3-8672-45c5-8d3e-9ee43dbe51c8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c686fc97-80d6-4444-9d10-fa9a7cf95b5e', '宋庄镇', NULL, NULL, 2126, '88d84710-80d6-4837-b889-286c74d7940d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c689e218-193d-4e47-895d-136391a476e4', '中宁县', NULL, NULL, 1753, '5ce65120-7c31-4b33-8e77-7db1c92d085c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c6b979a9-0256-41e0-968e-12c41aa8a353', '正阳县', NULL, NULL, 750, 'a096e337-c439-4751-a014-b49dd13bee26', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c6bbbf5d-1915-43bb-a8fd-032b668f9ff3', '离石区', NULL, NULL, 3406, '9348509b-6d82-47e7-86d7-f054fb47b7fe', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c6d26640-f610-40bb-a6bc-ebe13849216c', '镇安县', NULL, NULL, 1388, '332e1b20-ce8a-4065-ab84-b60416060476', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c6e3c8f7-08d7-4854-bd2d-834e22a891c0', '林甸县', NULL, NULL, 2365, 'c5e2b320-fd7d-448b-9a02-4fb93e1d3302', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c6e9fec7-297d-4e38-899a-0905dc78c50c', '含谷镇', NULL, NULL, 3543, '99107e35-f7d9-4c45-8d21-7a03b9c2f99d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c6fd3f78-1816-47f8-943c-1995cbda7d7e', '麟游县', NULL, NULL, 1832, '7c3fbad9-df03-4d15-93a4-695924a2f35d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c70339d2-4f4d-4ea4-b8e1-b90612765cc8', '龙海市', NULL, NULL, 1198, 'bda1d0f2-1476-4e0d-8fb9-2d1392397cbb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c7387f2c-9e03-4460-b1b3-5afd627a7101', '望奎县', NULL, NULL, 3562, 'fcd4a18f-a57a-47c4-b2f2-504bc8bccb20', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c74a4aa6-a567-47f9-bba8-495b95fd0509', '敦煌市', NULL, NULL, 2431, '42852584-118b-41cf-ba7e-db28102a593a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c7573473-3c6a-4c77-96f1-e3daac569ed9', '寿县', NULL, NULL, 2963, '69508f5e-7304-4092-95a4-73d6a9b68eff', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c75ebe86-7bab-4b34-a8eb-cf0237786566', '易门县', NULL, NULL, 4145, '2b997404-05c1-436b-8004-2d5dfd364db3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c763c9f3-3484-4b8e-a448-c3ae5897ccae', '三环以内', NULL, NULL, 4380, '27537995-4520-4156-95b5-b3d1e368a5dc', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c76421c5-d734-44d8-9f2d-d137a14af994', '北戴河区', NULL, NULL, 2713, 'f4bc760a-86e0-4fa1-a5e9-cdc21cc7a127', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c76c78cf-1c76-48b2-8c86-52fc96b3e830', '临安市', NULL, NULL, 2314, 'f530455e-1c70-47dd-9a80-4bc74a4e2680', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c77a474e-02a0-46c7-b3c4-55d439487d82', '武陵山乡', NULL, NULL, 1131, '72d4f69f-2e4c-4bde-9df8-2aadc9168686', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c7986e39-f898-45f1-b9bc-371cd1e8e7ed', '灌阳县', NULL, NULL, 3194, '796bb0e0-6b76-4c1d-801f-2dbcbab74087', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c79b06c3-d298-4465-95e4-a88dc75be0b8', '丰顺县', NULL, NULL, 4393, '2aabe025-ea3b-4ce4-885f-9ecf122b3e79', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c7a2cae5-c741-4d56-a821-c4bb71cbcaa5', '四团镇', NULL, NULL, 632, 'fa34c22b-c1d8-45b2-bb1b-4ea08298e7f6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c7a36416-d616-4aaa-b7fe-77e607eac2d0', '沙市区', NULL, NULL, 872, '7fe0855f-3ef6-419b-a145-5994fe28cc8f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c8390189-2a87-4ef2-8914-c290f021f8c2', '富拉尔基区', NULL, NULL, 2730, 'f4e36f9a-e006-44a6-8d77-47971d41810b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c83ac5dc-3abc-477c-9159-12460a48f635', '高台县', NULL, NULL, 690, 'dcdb1184-ab1f-4332-8ca0-f4edfd7cc087', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c841ca1b-7c71-423a-8bed-ca55cd5ecf2a', '城区', NULL, NULL, 97, 'ac38b800-4a12-4d41-8c44-a031ebb79365', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c84968ef-9ea8-4dc5-89cb-be14c7bf3c95', '复兴镇', NULL, NULL, 2329, '671d3a34-71bf-42c5-8dda-a813f5ecba22', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c85eaca6-9bda-4602-8a2b-c3f51dd90a74', '双清区', NULL, NULL, 3751, '30ce87bd-09cc-4250-9b5e-1f5916ce4d70', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c86ee8e7-18cf-4ad9-a98e-e991df3a98b2', '细河区', NULL, NULL, 309, 'fca062e6-ca02-4963-9f79-ed8cbfbb11df', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c86fb472-4e02-4dad-a9ff-ec9d2462e44e', '海勃湾区', NULL, NULL, 2207, 'aa1e4355-d9bd-4e6a-8812-0173f4f9815a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c88de07a-8398-4a12-b7f8-75fecc517183', '新巴尔虎右旗', NULL, NULL, 1070, 'c31a65eb-4d77-4b38-8142-9c9e2f54ed46', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c89777d5-8800-4823-9b52-56e672629a82', '衡东县', NULL, NULL, 4264, '75dd761e-ce3f-45bb-a86b-d3a1e2c7629a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c8a2b298-3bbb-412c-a053-91d9622f78d4', '太仓市', NULL, NULL, 610, '278acb58-4d2d-40cb-a572-1fc7fb979c77', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c8adfa0d-017b-415f-86f7-8a510b313f23', '江城县', NULL, NULL, 1712, 'db61cc5b-b13b-417f-a232-7925ffdfa9b2', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c8b30cc1-d96d-4a0d-8c1c-86918de9fe56', '北屯市', NULL, NULL, 3521, '2ca5ebc8-b3f5-49d8-b421-85ae2dc0de35', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c8be8313-4d26-4663-8976-393bbc8696c1', '龙里县', NULL, NULL, 3489, 'ef4b5cd7-d6b5-4839-9963-c010487ba475', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c8cf4b64-c512-420d-8e22-1ae407c74ac0', '金山卫镇', NULL, NULL, 2707, '0e5598a8-f405-4745-8cd5-a7a4c99f67f9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c8ffd230-2375-4746-bf57-66e5f58228da', '乌审旗', NULL, NULL, 3532, 'eb551697-7acc-4bcd-9d21-3d48c16f8258', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c9179991-14cf-47ca-bb3f-42980a61d6f4', '喀喇沁旗', NULL, NULL, 4472, '4b199fdb-3a49-40f7-9843-8bd43f4ea30c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c91d110e-fa51-4e26-b07c-f5cb48d6a93d', '浑南新区', NULL, NULL, 1850, '271a8d5d-a9a3-4876-a9a2-ca9bcee4b83f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c927b809-afc0-4413-9805-2913b8ba4251', '江华县', NULL, NULL, 1732, 'c7d6739c-4d7d-4d8f-bf6e-d6a6a7d38f20', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c93de009-4a39-486c-849d-9a7156b9f702', '普兰店市', NULL, NULL, 4057, 'd83aabcc-3c2e-4b48-962a-c548442bc896', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c943553b-2db1-4046-8edd-9c93feb064c8', '樊城区', NULL, NULL, 1346, '52d3ef0d-d999-4ae8-971b-534a2b25de02', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c9493ae0-3e72-4e0c-a9bc-5e1532442dcf', '鹿寨县', NULL, NULL, 2751, '0f2ba543-1d40-4b41-b700-6b53a9622b5b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c94aadb2-3a32-4f53-a175-5c90aac13406', '赣榆县', NULL, NULL, 1632, 'bea9983e-fee5-44d8-9884-18c75d7d052d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c94d0fce-6ba3-4dfe-a57f-28d2cf53b172', '抚松县', NULL, NULL, 1398, 'baaceb68-ffec-405f-8bcc-9d58ab5a0c1e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c979345b-fd63-446a-956a-60154b599d05', '玉门市', NULL, NULL, 2430, '42852584-118b-41cf-ba7e-db28102a593a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c9c27d96-9090-4a6c-bf04-998d8b1c6e2a', '潭牛镇', NULL, NULL, 3800, '96fec37f-11d5-4d41-aba4-a36d0652744c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c9cb1a7c-e144-48d4-9d49-ee6e2b602cc7', '邻鄂镇', NULL, NULL, 3366, 'aa2f26e5-9705-4dc0-b54a-a2d7dbb8b511', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c9ec4f38-fa62-4fe3-84b6-f9906e48ec89', '高平市', NULL, NULL, 2850, 'ffe07042-807c-4f16-a63c-c1eb8785b06b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c9eca173-983e-4731-84e9-912934e27747', '山城区', NULL, NULL, 3441, '2130bd75-b4cf-44af-a13b-2b64109f0cb9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('c9f84e17-ea82-4881-ac36-8f057fbe8d70', '桑日县', NULL, NULL, 1015, 'f7038861-43d2-49c3-a5c9-53fde2c139fa', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ca1ff2b8-2295-4fc1-b88e-8e7fcb58197d', '泰来县', NULL, NULL, 2740, 'f4e36f9a-e006-44a6-8d77-47971d41810b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ca202435-d3ca-4530-88f2-6184d67aa499', '冷水滩区', NULL, NULL, 1727, 'c7d6739c-4d7d-4d8f-bf6e-d6a6a7d38f20', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ca25c2f2-518f-47b3-b5f0-2714ff348327', '官庄镇', NULL, NULL, 968, 'cc124ed6-091a-42ce-a87a-bb4d0d7357b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ca2e6f95-aa7d-432f-8f78-3eab09fb7024', '四更镇', NULL, NULL, 3610, '46073b56-9ab9-4efb-874f-efe112a304a6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ca45104e-37ec-43aa-9cde-7e8f24313bb5', '夷陵区', NULL, NULL, 1782, '3760382f-ecb5-4ef6-8bd2-049afe34b574', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ca76c5f1-d3f9-4ecc-95c2-2b29b66cf886', '舟白镇', NULL, NULL, 3357, 'aa2f26e5-9705-4dc0-b54a-a2d7dbb8b511', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ca9266fe-6b0f-472c-bc54-e8fe17e60070', '南桥镇', NULL, NULL, 630, 'fa34c22b-c1d8-45b2-bb1b-4ea08298e7f6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ca974ce2-3f42-4cb4-8bc0-069132472d4a', '毛嘴镇', NULL, NULL, 3460, 'ea11feaf-194c-4cec-be59-d17bac402db4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('caaf2e51-032b-4fde-b8c1-50ede51e9a0a', '阳东县', NULL, NULL, 3971, '97a2157a-88ce-46f6-ba0f-e432060024ca', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('cab13f5e-c29c-4b66-8c9a-23316bd156da', '扶风县', NULL, NULL, 1834, '7c3fbad9-df03-4d15-93a4-695924a2f35d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('cac64dc3-4ec7-4583-8451-b766f2fdb0c6', '汉台区', NULL, NULL, 339, '5c4e7f63-9162-47e1-a948-c64ca46ff566', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('cacae270-a083-4cec-b655-8a0428b1b4e9', '青龙湖镇', NULL, NULL, 61, '0863a0a5-7ac5-4a13-80f5-d31e3a1aa459', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('cad00fdb-ad31-4364-8a06-ca24fc865bee', '香坊区', NULL, NULL, 1544, '349a18f4-4117-490c-b26f-80702a4911bf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('cb0d6efa-a281-43bc-876f-441c35b31be2', '响水县', NULL, NULL, 4367, 'b85d2a61-b018-431a-9609-2ca0841f5cab', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('cb24505d-9591-4d13-a64a-c06ead733d2d', '八颗镇', NULL, NULL, 2088, '4686b935-e3f0-4173-bdfe-ab6a5450d1a8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('cb355550-9357-428f-adf4-a4bd3891e975', '桐楼乡', NULL, NULL, 1907, '2c8bc8c3-9317-4f36-a0ad-05a8d6b27053', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('cb4ba6d1-6d33-4e47-b469-16c8aadba1f2', '歌乐山镇', NULL, NULL, 3900, '7fefd2bf-99e0-43f5-bc37-9ab15ee8e8f3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('cb53e36e-c730-4c28-85bd-ea83eee893dd', '嘉祥县', NULL, NULL, 2824, '5c8748b9-cee3-4d8e-956c-0d0e24db8850', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('cb5c7e0d-89eb-4466-ba7d-4ba2adb134b2', '横沥镇', NULL, NULL, 3318, '3bc6861d-0eeb-497e-9257-42f9cd6fd26f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('cb66cac4-b795-44d1-856b-26364632620a', '龙江县', NULL, NULL, 2738, 'f4e36f9a-e006-44a6-8d77-47971d41810b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('cb7bfa84-5a46-41e0-a46a-e2a3c8f4559d', '桥头乡', NULL, NULL, 817, '0f559985-f6fe-4a8f-af80-3d0d64932dbc', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('cb82613a-2759-4a36-a844-97e7ab100c4a', '铅山县', NULL, NULL, 500, '8bf55045-9366-4acb-b884-bca672ff9644', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('cbcee453-e0b8-4cd1-971f-e809111641a1', '红狮镇', NULL, NULL, 169, '4f867632-2989-4def-9934-a9c5fe0d5ca5', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('cbcfb2f1-14a0-4163-8b23-d37cba404cb9', '沿河乡', NULL, NULL, 2400, '0275a9ca-e89b-4217-b3b0-ada824d9e095', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('cbd209f9-5b96-4392-a4f1-89e556a862dc', '阿拉山口市', NULL, NULL, 4269, '4a8f2a43-831a-4413-b4b5-2de877d9b166', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('cbe2fc77-1873-415c-b1b6-379685c90789', '平滩镇', NULL, NULL, 3830, 'c33c3107-81df-4ced-8b92-d694df412da3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('cbf7c055-4210-4f9c-b7c5-6171d70e2caa', '户县', NULL, NULL, 4297, '29595f0b-301d-42da-845d-01afb30a9c18', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('cbfb125c-52e0-4b04-ae1a-3eaefc92901b', '蓬东乡', NULL, NULL, 3374, 'aa2f26e5-9705-4dc0-b54a-a2d7dbb8b511', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('cc033168-a947-45e1-9d1c-1c39d5f1fbdb', '县城内', NULL, NULL, 3824, 'c33c3107-81df-4ced-8b92-d694df412da3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('cc119523-50c5-42a5-99a6-5dd1f44ad709', '阿克苏市', NULL, NULL, 4396, 'b7bc3a10-ad00-4b20-9fa4-cb08ad7492d3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('cc13644b-acdc-4571-ac1c-1bc087ac62fe', '乐平市', NULL, NULL, 2407, 'f02f3013-3723-48cb-9461-451981c81059', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('cc16adcf-92a6-427d-8d67-1f14f44832be', '万城镇', NULL, NULL, 4482, 'f491d9c3-9527-46a4-8954-6795ff079478', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('cc1b0e00-9eb8-47e2-bd4e-b10bdd39e681', '渑池县', NULL, NULL, 3996, 'ba612057-dda4-4e54-9951-f847a74f623e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('cc22387f-780e-497d-b59a-913f41ede5a1', '大冶市', NULL, NULL, 3915, 'b3b5e655-b2df-467e-ad5f-2ab21c2a0aba', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('cc240f9b-8cf0-4d08-8672-16be67aa698c', '蝶山区', NULL, NULL, 3040, '01d0a041-f2c0-4416-b710-9376b2aabcaf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('cc385421-4c8d-448a-ab97-ef98ee963644', '黄石港区', NULL, NULL, 3911, 'b3b5e655-b2df-467e-ad5f-2ab21c2a0aba', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('cc3ab5c8-c1a8-4c3b-857a-cb290e661e85', '天元区', NULL, NULL, 2604, 'cdeda821-2101-44e1-a986-183436199f05', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('cc444d12-be65-4c8d-90f1-f1a3881c871b', '宁远县', NULL, NULL, 1733, 'c7d6739c-4d7d-4d8f-bf6e-d6a6a7d38f20', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('cc61e0ca-bbf0-4686-b686-09f0b46caefa', '内黄县', NULL, NULL, 2576, 'd94ce52b-fe8c-47d7-9b1a-d37da377cbbe', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('cc631083-e052-47aa-abc0-555e7a5ef97d', '潜江经济开发区', NULL, NULL, 844, '24ad0708-80a9-43b1-8e1c-758f2492d3f6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('cc93d482-6944-421f-834e-c03858db3d19', '礼让镇', NULL, NULL, 650, 'd7f44c2a-2728-4633-a8b6-7643136bc99d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ccaf2ac9-7314-422f-85b6-cfd83c5b60b2', '福禄镇', NULL, NULL, 3598, '27289f06-ca7a-4916-8f25-f6b13d8687ec', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ccb66a2e-6a5c-466e-b4cd-e583b86d23eb', '龙山农场', NULL, NULL, 3226, '2e21ea75-c640-4928-8cb4-e5ba4f6e2ffe', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ccd60f05-0a7d-465a-9a54-3832e136966f', '大岭山镇', NULL, NULL, 3317, '3bc6861d-0eeb-497e-9257-42f9cd6fd26f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('cceba8d2-fe5c-496d-8e50-b32a46ccf0e6', '宝山区', NULL, NULL, 2252, '69696549-d65b-4e13-80ef-05ecaf0f61e3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('cd0eb753-ef1c-47ed-8d0d-eec6a7cf0910', '龙桥镇', NULL, NULL, 1117, '72d4f69f-2e4c-4bde-9df8-2aadc9168686', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('cd19796c-f6b7-41f7-ab63-4c27962ce2e4', '珍溪镇', NULL, NULL, 1127, '72d4f69f-2e4c-4bde-9df8-2aadc9168686', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('cd1e7873-d08c-481d-ad19-e7dd2b58ae97', '丁家镇', NULL, NULL, 3593, '27289f06-ca7a-4916-8f25-f6b13d8687ec', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('cd338f52-fc20-4e0b-b23c-bf8877508d75', '襄汾县', NULL, NULL, 3702, '1aeeea9e-d028-4a96-94ce-ba84cdd3e69f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('cd470a24-6cae-464f-9386-2eeacd14103e', '卫辉市', NULL, NULL, 2176, '1aabde9d-2b04-4892-a20d-5b4e3efaeedf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('cd51bde0-362a-40c9-8238-1f95f3409307', '石首市', NULL, NULL, 876, '7fe0855f-3ef6-419b-a145-5994fe28cc8f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('cd537745-ab3c-4f49-b5c3-5e6818fc00cb', '慈云镇', NULL, NULL, 894, '41f376c0-764f-46b9-af35-e555518fc613', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('cd566351-ee94-4b07-91fc-5f39949886da', '望都县', NULL, NULL, 2493, '81e22d56-a1c7-4263-be18-81a4af165ae3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('cd5efe1a-01f6-4d4f-9e37-aeec149935a3', '三乡镇', NULL, NULL, 2189, 'f2727650-b0d9-4541-acdb-b4eabf894893', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('cd657e0b-0f7f-4233-9656-f975e82e0464', '草街镇', NULL, NULL, 3871, 'a732da28-870c-4d9c-a287-c2c1e3222b59', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('cd6cbf11-92b8-4e2e-9037-10c99d9a90e9', '高桥镇', NULL, NULL, 2625, '4683d3ef-0edf-425a-98d5-2cb231a7d88a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('cd76f150-ed24-4f62-8190-63ab62ff5e96', '邵原镇', NULL, NULL, 3924, '22f622f8-7eaf-41e9-90ee-2a0cfda1f326', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('cd7d8eac-dcd4-490d-9ff5-9e4da571269b', '滦南县', NULL, NULL, 2459, '4f4c1ef4-f54d-4ba4-a124-ca2d3d0ddb78', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('cd8e051e-9371-4e83-87b4-281a9c440884', '官坝镇', NULL, NULL, 2659, 'e509a1a5-95da-4fb2-9a2b-f84afa05a36c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('cd8ee549-5d86-4dff-8d8b-558c90ac57d7', '白桥镇', NULL, NULL, 3238, 'a39ced08-b6e9-4de0-a2db-7a230a673d1e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('cddbcf90-7fc3-4692-ad7c-f5161c5f6ee9', '沙田镇', NULL, NULL, 3335, '3bc6861d-0eeb-497e-9257-42f9cd6fd26f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('cde5480b-1374-4685-8dd5-5d7131dcdab5', '华安县', NULL, NULL, 1203, 'bda1d0f2-1476-4e0d-8fb9-2d1392397cbb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('cdfbd587-9542-4282-a1ce-e86e81f52916', '九所镇', NULL, NULL, 2556, 'a1e3332c-7029-4de7-a221-40c041a9a620', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('cdffde7b-278e-4bd5-99c9-5f56df66b45b', '邦溪镇', NULL, NULL, 1360, '21bb958f-e5d4-4a71-a350-b5bf2c0e2de0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ce008380-8303-452a-8bbe-ccf3e248d09a', '明水县', NULL, NULL, 3559, 'fcd4a18f-a57a-47c4-b2f2-504bc8bccb20', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ce0ab3e5-bd50-4861-a808-98375ac11258', '宾县', NULL, NULL, 1533, '349a18f4-4117-490c-b26f-80702a4911bf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ce11a701-6f6a-415d-b10c-b773f9f2ef5a', '翁源县', NULL, NULL, 1524, '754500f9-7ec4-4379-8b1c-9370f50564c0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ce12ec57-01c0-4ad5-9db5-afa124653187', '红花岗区', NULL, NULL, 3423, '69324865-24e8-4abe-a068-a1392c117c0d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ce284f7d-f3c5-4b07-b4a9-c40d0244a59a', '翰林镇', NULL, NULL, 1569, '5f7e2e46-8a4e-4463-907c-5762bcd006a8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ce2f2639-bd80-412e-999f-899e03d6ce22', '永和县', NULL, NULL, 3704, '1aeeea9e-d028-4a96-94ce-ba84cdd3e69f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ce4806f9-d319-4b53-a7ab-fd929df588e4', '西夏区', NULL, NULL, 4285, '2a45fee0-aa22-4471-be1a-0f6edce52b7a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ce4917ce-0472-4fe6-808f-376adf064f67', '虞城县', NULL, NULL, 3137, '62aa4f78-f1b9-44d1-9372-21e01c353757', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ce49bde6-a1f9-4058-929e-f8a3187f0f58', '东河区', NULL, NULL, 2051, 'd4910db5-a704-4273-bd13-a6dc05f468cf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ce50825c-a23f-403b-8aa4-cac0ab382992', '桐柏县', NULL, NULL, 734, 'a769a530-0bcf-4e52-a9e5-3a8f5af945d2', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ce50e86a-a1a3-4780-acd9-dc3feec8abc1', '望江县', NULL, NULL, 3585, '818f3bc6-83b9-4d90-8e68-566cc7c2bb14', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ce527d39-e001-4ce5-b32d-131df078f015', '留坝县', NULL, NULL, 344, '5c4e7f63-9162-47e1-a948-c64ca46ff566', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ce8fcdef-b9f1-49ca-9202-6975bf7f9c4e', '青峰镇', NULL, NULL, 411, '9d7d52af-ec34-48e3-b81d-09ac51e11590', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ce9cb3b0-713e-4d0c-afbd-2150bebc4c64', '微山县', NULL, NULL, 2821, '5c8748b9-cee3-4d8e-956c-0d0e24db8850', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('cea6e4d4-7e35-46fe-9e08-d5acd4440ec5', '养鹿乡', NULL, NULL, 201, '4f867632-2989-4def-9934-a9c5fe0d5ca5', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ceb6b90b-608b-4387-ad13-41ccb850b0fa', '金峰乡', NULL, NULL, 3270, 'a39ced08-b6e9-4de0-a2db-7a230a673d1e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('cee535a3-f844-475a-9e6a-3df615877848', '金桥镇', NULL, NULL, 2631, '4683d3ef-0edf-425a-98d5-2cb231a7d88a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('cee80b79-8529-4813-b168-e47afcf9c4ff', '外环外其它地区', NULL, NULL, 4371, '74fd7f9a-ddb6-4065-a99c-054987fffdb8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('cee9e7a5-efe6-43a9-bf39-108e036bbb6e', '橡胶研究所', NULL, NULL, 3823, '96fec37f-11d5-4d41-aba4-a36d0652744c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('cef5de19-ca58-4939-be6e-d08cc7e40e32', '海陵区', NULL, NULL, 2227, '0541b99e-02a6-415b-8282-4ef9d27cb647', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('cf031894-0fd3-405c-b24e-f9fa74110a40', '克拉玛依区', NULL, NULL, 1432, '24925ffc-d2fd-4b44-823a-250fcc224503', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('cf097c5f-b5d7-4877-8e9e-a7e36bd2fc4c', '孝义市', NULL, NULL, 3407, '9348509b-6d82-47e7-86d7-f054fb47b7fe', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('cf1449fb-f770-4cae-8e6f-783a6ab7d14b', '下沙区', NULL, NULL, 2310, 'f530455e-1c70-47dd-9a80-4bc74a4e2680', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('cf36a577-81b2-4e9d-8016-b57dc6829073', '开原市', NULL, NULL, 2789, 'def78b05-5d2b-430c-b268-442502dc3ca5', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('cf41915c-0b9a-4935-b8d4-f52d1ace842b', '关坝镇', NULL, NULL, 3674, '6581d8db-553e-4417-8c37-91ed47904920', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('cf5412a7-8440-48b9-8873-0060063410f1', '赵县', NULL, NULL, 2777, '334645de-ae54-416a-8978-2dbf9f7bbd09', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('cf57ca1d-cf84-467b-94fe-54e3acdad56e', '曾都区', NULL, NULL, 2274, '5da76347-cb7e-4817-b07a-985010b9c63a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('cf6516ce-3c2a-4cf6-af48-3f69fe2f3b1a', '罗甸县', NULL, NULL, 3486, 'ef4b5cd7-d6b5-4839-9963-c010487ba475', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('cf6ad6da-8d06-4e18-9243-0decc4b6ce58', '容城县', NULL, NULL, 2491, '81e22d56-a1c7-4263-be18-81a4af165ae3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('cf77a7a4-bb45-4e64-ae50-079684b656ea', '阜城县', NULL, NULL, 2470, 'b126935b-0423-4bea-b802-d4e6680d1d71', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('cf7df287-96a8-4df1-bcec-5357ec8a6dde', '东阳市', NULL, NULL, 231, '1721f4b0-56cf-4408-a217-62416951c176', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('cf808945-36bc-4782-b35c-90b5319d2d55', '陶家镇', NULL, NULL, 3546, '99107e35-f7d9-4c45-8d21-7a03b9c2f99d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('cf85f41f-af96-4305-ac1f-9825736a6f69', '城区', NULL, NULL, 3034, '8e6440db-f1b8-4a72-8e20-7cca4fe2039d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('cf9f1779-62a0-4673-8784-a1ed6f924671', '樟树市', NULL, NULL, 4062, 'fa27d3fb-a80f-4b4c-8d0c-bf7d544bb974', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('cfa39703-f723-4b94-980f-b7628d0af387', '保家镇', NULL, NULL, 1875, '2c8bc8c3-9317-4f36-a0ad-05a8d6b27053', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('cfb22059-7809-488d-aab6-d5e799fa76bf', '南丹县', NULL, NULL, 1159, '509d3498-d5ba-4378-8bee-0baf015c2a11', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('cfd3e2d2-0dcf-49a6-b25b-6b144f032bba', '涟水县', NULL, NULL, 761, '3c9ba44c-7031-4422-b9b7-85d772ee3e08', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('cfd54427-5665-422e-ab09-08893189f485', '龙湖镇', NULL, NULL, 1564, '5f7e2e46-8a4e-4463-907c-5762bcd006a8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('cffbde06-0b4d-42be-93fb-c40334edde00', '柘林镇', NULL, NULL, 633, 'fa34c22b-c1d8-45b2-bb1b-4ea08298e7f6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('cffeffca-82c2-4b4d-9ce8-0d85990173b1', '固安县', NULL, NULL, 1233, '86f7f02d-658e-44ec-9d36-b14cc3c65aaf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d003b4f6-13f8-4500-ba74-a78a7d9370a8', '恩阳区', NULL, NULL, 455, '312a1e8d-70a3-4529-bfe8-04a7f21cc881', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d021b91e-b4ef-4953-8cd1-cb34044a3dd1', '瑞丽市', NULL, NULL, 434, '10aecf03-914d-4a26-a6c3-0045748d43b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d03f23c6-f386-4747-b9d1-0f3dcf4782ab', '虎城镇', NULL, NULL, 646, 'd7f44c2a-2728-4633-a8b6-7643136bc99d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d048f2ac-ce34-4ffb-85fc-7f7ca38306a1', '万源市', NULL, NULL, 1006, '6681b8cd-3740-4dbd-b311-143871994e15', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d06f97ec-97f6-4e42-a9af-b010385eefe5', '九台市', NULL, NULL, 314, '096d0f9e-9537-43f8-95f6-8dca9fa4cad4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d0750e29-e0cb-48c1-90ea-5ff9b022978d', '童家溪镇', NULL, NULL, 2322, '671d3a34-71bf-42c5-8dda-a813f5ecba22', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d0790765-f9e2-4b2b-aeda-30df90edc35a', '马尔康县', NULL, NULL, 1191, 'd56c2ee6-b81c-4df8-ba2f-3df7680243c4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d07be883-bdfd-4856-b0c0-dfcb09040091', '仁义乡', NULL, NULL, 1143, '72d4f69f-2e4c-4bde-9df8-2aadc9168686', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d089fdfb-6851-4b50-b8f6-e6eb744fd275', '彭州市', NULL, NULL, 1807, '4f073365-4e02-459f-8b32-cad88dd22637', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d0a61c77-dc64-4f64-84a7-8e666750a946', '普兰县', NULL, NULL, 2903, '3a856f9e-a1e5-4657-b81e-cc7d76d14ff5', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d0ad7894-1abb-431f-97ad-e1f2fd280a65', '水磨沟区', NULL, NULL, 3235, '8349c2b0-91a2-4e19-b9c7-81b5224fbabe', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d0bb0735-6fe0-4e76-9b68-86803343767e', '胶州市', NULL, NULL, 3717, '1e53830d-8cdb-4111-8da6-987131b873ed', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d0c076c2-46e7-457e-aa8e-1e781f85796d', '城区', NULL, NULL, 3355, 'aa2f26e5-9705-4dc0-b54a-a2d7dbb8b511', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d0c3d8cb-6879-4de0-8923-6b8177c7b9f5', '肃宁县', NULL, NULL, 2890, 'a3c44525-9ccb-429d-a2b7-f5f5d52b8a6d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d0d97012-1524-4903-9686-ed3b6ea23423', '雅江镇', NULL, NULL, 977, 'cc124ed6-091a-42ce-a87a-bb4d0d7357b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d0e11c5b-5b81-4ccb-bee6-14cea9462cee', '市南区', NULL, NULL, 3711, '1e53830d-8cdb-4111-8da6-987131b873ed', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d0e6328a-2fbf-4014-87bc-d2447ed431a4', '福山区', NULL, NULL, 589, 'f3717726-7743-4838-852b-3a09f9528a69', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d0e635f2-9d03-4c4b-964d-3817c1c18eee', '全椒县', NULL, NULL, 860, '1a27a18f-784d-4314-bd00-8add932005d6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d0eec44b-1e52-4abb-8fa7-6f2ba9cee21f', '双龙乡', NULL, NULL, 196, '4f867632-2989-4def-9934-a9c5fe0d5ca5', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d1056b51-1b6e-4c91-bb91-9b9367c7bfdf', '长沙镇', NULL, NULL, 3261, 'a39ced08-b6e9-4de0-a2db-7a230a673d1e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d10be835-bcf2-41fb-9a5f-aa69242c51c2', '巴阳镇', NULL, NULL, 165, '4f867632-2989-4def-9934-a9c5fe0d5ca5', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d10ec47e-2062-4f66-bce6-fb28b0753dc6', '二圣镇', NULL, NULL, 44, '43c813e3-8672-45c5-8d3e-9ee43dbe51c8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d1123e92-9e1e-4060-9142-c506b9aac8d9', '河堰镇', NULL, NULL, 3251, 'a39ced08-b6e9-4de0-a2db-7a230a673d1e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d133915b-150b-464e-ad79-490525044c42', '双丰街道', NULL, NULL, 3739, 'd1c1539c-b904-4bcc-a034-96213f63d0ff', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d13a9eee-a39f-4b8c-bfbd-cbc5c6441f3f', '云和县', NULL, NULL, 2375, '982c089d-7fb7-4cdc-a3c2-865e4637006f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d1531438-26c4-48e5-b510-47ef52fdbe95', '南城区', NULL, NULL, 3315, '3bc6861d-0eeb-497e-9257-42f9cd6fd26f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d1552f39-d930-432d-b417-cf5927c43ae7', '江达县', NULL, NULL, 2689, 'b7342349-941d-427d-9ab6-e83a36078088', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d1578df4-926e-400e-8c32-c284a88d5d1c', '英州镇', NULL, NULL, 547, 'b75db043-9782-4bae-aaee-bea49fc286e6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d16771c7-6856-4c0d-b058-005006939344', '叙永县', NULL, NULL, 582, '78000393-73bd-4a54-a688-5db0e578d9cd', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d17b77af-600b-4ac0-aff7-72b357050021', '咸安区', NULL, NULL, 952, '7a5b4813-b095-4a1a-a008-1297fd9aa978', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d17f6190-a1c4-4389-8fea-9ae7249b578f', '塔河县', NULL, NULL, 3046, '1b8b9a84-0955-4d1e-8f33-8de97af3bedd', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d18613c3-6cbc-4b05-8041-f86f66668a55', '番阳镇', NULL, NULL, 13, 'c8bf9a67-2bfc-47fe-9580-3f2f2eac1edb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d1922eb9-66bd-4300-9bd8-3007bb39f000', '望城区', NULL, NULL, 629, 'dccf3d25-c012-444b-94c6-bbcbae7e63d8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d1cc954b-3f88-4562-89ed-131efed63cb6', '梁园区', NULL, NULL, 3143, '62aa4f78-f1b9-44d1-9372-21e01c353757', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d1f0ae95-1b65-438b-8166-5ff706c5ab73', '内环以内', NULL, NULL, 3898, '7fefd2bf-99e0-43f5-bc37-9ab15ee8e8f3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d1f7000b-6794-4a5b-a920-a8f75d018716', '迁安市', NULL, NULL, 2452, '4f4c1ef4-f54d-4ba4-a124-ca2d3d0ddb78', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d21e6704-ffea-46a7-b0bb-447bff9c6ff5', '小厂乡', NULL, NULL, 1908, '2c8bc8c3-9317-4f36-a0ad-05a8d6b27053', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d23358cb-cd97-4c77-a900-b2ceb7b6691b', '白羊镇', NULL, NULL, 3829, 'c33c3107-81df-4ced-8b92-d694df412da3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d24e00e8-0277-48bb-8a7c-057c625d68bf', '商都县', NULL, NULL, 3963, 'a061ae4e-1b4e-4b42-8aa9-cc6bbae9619a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d24e82c6-770e-4bcb-bbad-0ab9810a69f9', '潭门镇', NULL, NULL, 1453, '81aab36f-0e28-4ba3-9827-b7033fce9b24', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d299bae4-c40b-4432-b409-074eeab04ac1', '下冶镇', NULL, NULL, 3920, '22f622f8-7eaf-41e9-90ee-2a0cfda1f326', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d29e881a-3197-49c2-8975-9ef4574d4927', '比如县', NULL, NULL, 4415, 'fae5ed6b-9b68-4ef9-93fa-221dea13a975', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d2a07a59-8ff5-4555-92c6-996596448b59', '金城江区', NULL, NULL, 1165, '509d3498-d5ba-4378-8bee-0baf015c2a11', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d2a91ded-2ee5-4366-8224-3dbaf766001e', '江永县', NULL, NULL, 1731, 'c7d6739c-4d7d-4d8f-bf6e-d6a6a7d38f20', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d2c6f2e7-47a5-4cea-892e-5a2a507c8eb1', '经济技术开发区', NULL, NULL, 325, '096d0f9e-9537-43f8-95f6-8dca9fa4cad4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d2c7ef98-bc06-4121-8f68-3c460b3bd8cb', '罗平县', NULL, NULL, 1334, '9568bdcc-65c2-4b1c-a512-b2ff897db321', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d2d77c93-4626-4989-8b66-6830430c0182', '加钗农场', NULL, NULL, 2280, 'b3792f06-9c78-446e-b6ac-d95d5e9092e8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d2df11cc-cb89-42fe-a993-a341a16d8792', '三坝乡', NULL, NULL, 1943, '442f465d-6566-45e4-9338-50f4395aa6f7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d2fb60a9-34b3-44a8-8414-6b6d2ed64458', '嘉荫县', NULL, NULL, 472, '7ca3412f-b06b-467e-b547-691ab8327b15', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d3000489-7ce0-4731-9def-78051965c814', '其它地区', NULL, NULL, 2985, 'a8cf4e9b-282a-4d0e-af55-7ba949628758', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d3008fc8-5c3b-4341-9bb2-46d1e662d2fc', '藁城区', NULL, NULL, 2759, '334645de-ae54-416a-8978-2dbf9f7bbd09', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d303321e-c8fa-45e6-9050-b039005e278b', '湖口县', NULL, NULL, 115, 'bcaf1f36-5459-4e74-81d1-5026680b1a9c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d3105bfd-42c1-4e8c-89d6-290e73ae0a99', '相山区', NULL, NULL, 2248, '8afb487f-de86-4a5b-9abc-27ae2c07797d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d313100b-1919-4461-8b38-2a8c3b2c45e9', '沙市镇', NULL, NULL, 181, '4f867632-2989-4def-9934-a9c5fe0d5ca5', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d33e2d63-91d1-416b-999d-ca333783e1d8', '青铜峡市', NULL, NULL, 603, '9d872dc5-ad1a-4b3c-86de-debd1a77eb8c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d33ef2b8-d451-4ea2-92cb-b3516c25032f', '开远市', NULL, NULL, 3150, '99a9abd1-f107-4dc6-ae43-e9d1120504b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d34b9d6c-11e2-4db7-90ac-5f62f048c8a8', '坡心镇', NULL, NULL, 4335, 'e98653ba-264e-4417-b74e-e0798b25e646', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d34baf23-287d-428f-9aa0-4a04154eace6', '内环到三环里', NULL, NULL, 3947, '9708d487-997e-4629-ab06-6fd2f1a311af', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d35d387e-a756-411b-b6f7-83451f7ac48d', '全境', NULL, NULL, 2531, '9e7f13f5-3b43-4196-bfc8-ba33014f8034', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d360d9a4-c007-4a8e-99f9-6571c04563fb', '泥溪乡', NULL, NULL, 189, '4f867632-2989-4def-9934-a9c5fe0d5ca5', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d36f50f5-aaf0-4ae8-9b4d-d27009cfe806', '余家镇', NULL, NULL, 4224, '0ee28cef-8dfc-4a9f-b7c1-330bc11c1bb3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d392a31e-43da-4d4b-836f-f574657f3913', '钟山区', NULL, NULL, 3552, 'd80168e9-9b95-4dbe-8977-d2e37c07e946', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d3a9d3a1-ede1-4b33-b90e-da48602148a3', '大榆树镇', NULL, NULL, 1512, 'd5ab951d-20ab-46ff-8838-de5efe06b6b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d3c67501-be7c-4de4-9922-3aca390ed2e3', '马山县', NULL, NULL, 2809, 'b53ced47-2455-44ec-b740-7637148f574c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d3dcf897-5a88-400b-83c6-87658417eb89', '南吕镇', NULL, NULL, 4332, 'e98653ba-264e-4417-b74e-e0798b25e646', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d3e65ff1-ff18-49de-8dd5-67b968723eb7', '西林区', NULL, NULL, 459, '7ca3412f-b06b-467e-b547-691ab8327b15', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d3e8b956-4bf7-4f98-8cac-28a3580e41f0', '科尔沁右翼中旗', NULL, NULL, 2974, '9758648c-eab9-4434-b7ae-318e7e08548e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d3f41304-72cf-4cc8-b5fa-d9681fa789c1', '浮梁县', NULL, NULL, 2408, 'f02f3013-3723-48cb-9461-451981c81059', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d404150f-852a-4dcb-bc48-edac0c48ff04', '凤阳县', NULL, NULL, 864, '1a27a18f-784d-4314-bd00-8add932005d6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d411a3f6-13a1-46a5-b536-9b915825ae2a', '锦屏县', NULL, NULL, 3080, '6d3a8433-1273-4323-a3eb-d39effecc1d7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d415953a-93da-4c6e-bf5b-6d2917303c7c', '曲阜市', NULL, NULL, 2829, '5c8748b9-cee3-4d8e-956c-0d0e24db8850', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d41f10ad-e65d-4a00-a26e-30b6555aa180', '洪雅县', NULL, NULL, 21, 'a24f5cc3-558c-447d-bedc-895b418c750f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d41f2b94-09a1-4494-b342-81ced1fad32b', '桦南县', NULL, NULL, 1402, 'a03ec6c9-8a1e-456b-bab9-164f8015c723', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d422a42a-3e2f-4640-880d-fa14df9ce758', '悦崃镇', NULL, NULL, 806, '0f559985-f6fe-4a8f-af80-3d0d64932dbc', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d438ef73-414e-40dc-b14f-15c6bd954d85', '来凤县', NULL, NULL, 2355, 'ecba10ba-2c25-4ead-a781-ad16a832226f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d43fea09-1d1c-4f91-bb0b-7f288f85d96d', '巴林右旗', NULL, NULL, 4474, '4b199fdb-3a49-40f7-9843-8bd43f4ea30c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d43ff43c-8b2c-430c-97d8-164c65c41110', '城区', NULL, NULL, 3918, '22f622f8-7eaf-41e9-90ee-2a0cfda1f326', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d44bfa5e-1c3f-4ca8-89df-d5d710544789', '邹平县', NULL, NULL, 299, 'be93aa9b-d81f-4e98-a0c0-18f840594a05', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d4523b6b-1ef8-4597-a4d3-8759b98f9eaa', '光坡镇', NULL, NULL, 545, 'b75db043-9782-4bae-aaee-bea49fc286e6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d4582b9d-b812-4e9c-aac3-b59e38b9cc60', '包河区', NULL, NULL, 148, '6ab7dc5a-1064-4090-a81b-79c3a2e8302d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d482fa76-2861-4b6b-be12-dd38eb697b12', '衡阳县', NULL, NULL, 4262, '75dd761e-ce3f-45bb-a86b-d3a1e2c7629a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d48fd9b3-aa08-4807-aa66-d5242b55d93a', '明中乡', NULL, NULL, 2397, '0275a9ca-e89b-4217-b3b0-ada824d9e095', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d493f8ea-c55a-40d1-8fc4-b32d3af1c30c', '若羌县', NULL, NULL, 3179, '0ce20b86-8bea-4d7c-a1e4-09c7519d8b16', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d4966318-a3ff-4fff-a92d-9f59135f8756', '大歇乡', NULL, NULL, 807, '0f559985-f6fe-4a8f-af80-3d0d64932dbc', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d49d6163-2726-41de-8d58-287cb44ea907', '横林镇', NULL, NULL, 2148, '671275c4-6107-4968-bd8e-96d53e9995b2', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d49dafbb-6907-46c6-bdfd-2024f4179731', '马坡地区', NULL, NULL, 3731, 'd1c1539c-b904-4bcc-a034-96213f63d0ff', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d4d76946-d110-47a5-b10c-f9776e38eb4e', '方山县', NULL, NULL, 3413, '9348509b-6d82-47e7-86d7-f054fb47b7fe', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d4e2a1fd-8672-45bb-99ed-4b7c2ce03b43', '惠民县', NULL, NULL, 301, 'be93aa9b-d81f-4e98-a0c0-18f840594a05', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d4e9d07a-0591-4487-8417-eedbe2426be9', '呼玛县', NULL, NULL, 3045, '1b8b9a84-0955-4d1e-8f33-8de97af3bedd', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d545bd28-2a9c-4932-8438-bc4f10f8f9f9', '兖州区', NULL, NULL, 2820, '5c8748b9-cee3-4d8e-956c-0d0e24db8850', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d55552b7-786e-4899-b992-8357429ed0b7', '群英乡', NULL, NULL, 554, 'b75db043-9782-4bae-aaee-bea49fc286e6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d56e2a05-351a-4c5f-9b74-a076dc0d9cd8', '龙江农场', NULL, NULL, 1357, '21bb958f-e5d4-4a71-a350-b5bf2c0e2de0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d56e8179-c74f-4bf1-b219-f4b959777fd4', '三原县', NULL, NULL, 2107, 'e42fbad8-c29e-4f35-878d-95a667b5cc90', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d575d49d-d14e-4ca0-947c-64587e8f39bd', '水江镇', NULL, NULL, 950, '88260608-a8b9-4b52-a474-1a551465c675', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d582768f-694d-4b68-bb6c-4eb8bdac8ec9', '云集镇', NULL, NULL, 2080, '4686b935-e3f0-4173-bdfe-ab6a5450d1a8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d59285ac-2d30-46fd-8f01-c3bb4761eeae', '黎安镇', NULL, NULL, 552, 'b75db043-9782-4bae-aaee-bea49fc286e6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d5ab8ce7-95e0-4b38-b833-05c874681953', '内乡县', NULL, NULL, 740, 'a769a530-0bcf-4e52-a9e5-3a8f5af945d2', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d5bc8aab-09a3-4c9f-a8f0-e90a48fdaf0f', '崇信县', NULL, NULL, 27, '4edd328e-68af-4f0e-bca8-63686e5cad24', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d5c97a0e-a589-4a40-910a-a00b5eaf7165', '承德县', NULL, NULL, 4038, '8db8f645-a1a6-4c39-9c27-2f703951f66d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d5ca1a50-efa7-4123-a831-708e3c6cdaa7', '扬中市', NULL, NULL, 1762, '63f8e070-63c0-4fa1-821f-d1d5a695ce2a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d5d0ea95-1dec-4f6c-b751-e7a52a6d54f4', '张家川县', NULL, NULL, 3117, 'b31f9073-6d76-4083-b00f-cc23550ef59a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d5d9a268-b630-4d08-ad52-456fb5124e2e', '清平镇', NULL, NULL, 3887, 'a732da28-870c-4d9c-a287-c2c1e3222b59', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d5daf18a-b1c8-4613-8937-a3c98b7e7cf6', '海南区', NULL, NULL, 2208, 'aa1e4355-d9bd-4e6a-8812-0173f4f9815a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d5db440b-82b9-4cac-91b7-e0b66255373b', '安亭镇', NULL, NULL, 1323, '99c50aa3-ab40-4b1e-addd-f68662f3c560', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d5e30712-1844-40f2-8b02-ba395f5bc1cd', '中西区', NULL, NULL, 473, 'dfb8b556-10a2-43ab-9fdb-66cde92320ee', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d5e3ef5a-1103-47d7-84e1-5ec5196697e5', '伽师县', NULL, NULL, 2035, 'e6436d79-8045-4185-b2b2-22cd280d22b0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d6073bd5-01b1-43d8-a032-27e3d5c3511c', '沙湾县', NULL, NULL, 2722, 'a419fd83-e078-4430-aa48-ca9aa67e4fff', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d614e977-1d90-4e19-acef-de1ba9582c17', '关面乡', NULL, NULL, 3269, 'a39ced08-b6e9-4de0-a2db-7a230a673d1e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d61a5053-1615-47f6-9400-12fc30deb3e3', '高陵县', NULL, NULL, 4295, '29595f0b-301d-42da-845d-01afb30a9c18', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d63449ee-f58d-4ba9-b545-a39e202e79b3', '南陵县', NULL, NULL, 3944, '5d5b2d25-fb30-4b3b-baac-c5481ccc67e9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d65202b3-4c65-4e8e-abcc-422b7f87b603', '惠来县', NULL, NULL, 1743, '03f84ef3-e7e9-4c0d-a1ab-b4170505bcaf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d664f4ab-9ca2-443c-a5b5-dbf37d9f56f3', '绥中县', NULL, NULL, 960, '1671eb17-f102-4972-9d41-7b1463da334d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d6792788-ff17-4344-bef9-79729ee1e78c', '西林县', NULL, NULL, 1222, 'f56fa64d-ca06-49d2-a9cb-94742a33af21', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d686b75b-9490-4185-b6a6-2e95d0a506da', '天涯镇', NULL, NULL, 3059, 'e60d3fe5-6d26-4a3f-b920-8fb6c4986bfb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d68eb3fc-0d48-4021-b449-de80503e633d', '城子河区', NULL, NULL, 2413, 'f583e1ae-7239-4815-b3c7-c5538eb73da9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d6924efe-92f9-41de-8ce3-40a6ce340b62', '双桂镇', NULL, NULL, 2669, 'e509a1a5-95da-4fb2-9a2b-f84afa05a36c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d6af8648-abca-4540-a939-5bafe2acbe0d', '新田乡', NULL, NULL, 1909, '2c8bc8c3-9317-4f36-a0ad-05a8d6b27053', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d6b06ecb-d9f5-4465-b9c7-9397b2c30f3c', '西三旗', NULL, NULL, 4378, '27537995-4520-4156-95b5-b3d1e368a5dc', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d6ca41dc-f880-4726-bf52-ed99eee5487a', '一品镇', NULL, NULL, 33, '43c813e3-8672-45c5-8d3e-9ee43dbe51c8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d6d53f73-9030-4f44-b6fc-0624655e148f', '祁门县', NULL, NULL, 4278, 'e3fa5765-1e86-4f89-a751-2f63dbe81c99', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d6dffa61-9b36-44a4-abd9-8cb3cb11643f', '七星关区', NULL, NULL, 2613, '55fdf7c7-6698-498a-8aef-b9455ab7926c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d6f5f054-256c-4d22-a1c3-e94c1d24d24d', '嘉平镇', NULL, NULL, 897, '41f376c0-764f-46b9-af35-e555518fc613', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d6fd6c65-d371-46de-b21b-8ce0ded64a52', '铁东区', NULL, NULL, 2009, '48832e11-ddfb-478a-9787-e46c47346d7e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d70549c1-c9d7-43d5-9fab-2721084c6fc1', '西盟县', NULL, NULL, 1711, 'db61cc5b-b13b-417f-a232-7925ffdfa9b2', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d707c430-de7a-4426-9a48-8c4898e5cd6e', '从江县', NULL, NULL, 3079, '6d3a8433-1273-4323-a3eb-d39effecc1d7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d74acbbf-4f8c-4516-bfa1-09ffb6203c7d', '通河县', NULL, NULL, 1536, '349a18f4-4117-490c-b26f-80702a4911bf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d74afec9-2a46-473f-bffc-e74dd3d713bd', '绥阳县', NULL, NULL, 3429, '69324865-24e8-4abe-a068-a1392c117c0d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d74c4954-3c0a-4558-8e9e-9e5866266b91', '象州县', NULL, NULL, 2169, 'f63c9587-7455-4dff-950d-0da6dddd16c1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d751c829-8946-4037-815c-c8a3d29789a2', '顺城区', NULL, NULL, 1379, '6b5fed36-b200-40ca-af0b-11999b4399ef', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d7658af7-aa83-4e4b-a8fc-d91ad2afbb4a', '东昌府区', NULL, NULL, 353, '56b97c58-86a5-4869-9130-c5dc51ea9a26', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d77f1938-51f8-49a7-b0e7-848d9fee23dd', '二连浩特市', NULL, NULL, 2341, '67723aea-a4ef-4eb7-afbf-55cc07806f98', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d79796ad-7136-4f29-b33b-fed3a0050350', '石家镇', NULL, NULL, 3369, 'aa2f26e5-9705-4dc0-b54a-a2d7dbb8b511', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d7a0a211-6400-4685-90f8-e4c9e660a42a', '克东县', NULL, NULL, 2739, 'f4e36f9a-e006-44a6-8d77-47971d41810b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d7b00c98-c468-4a6a-8bec-47722d114d24', '普宁市', NULL, NULL, 1739, '03f84ef3-e7e9-4c0d-a1ab-b4170505bcaf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d7b217a4-b541-458e-9e3c-9e85fecb753f', '尼勒克县', NULL, NULL, 2587, 'e6f53877-d5bf-4b42-aded-5ab8960ef034', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d7b26e8f-e2b7-42ec-8eea-871a66d019dc', '甘泉县', NULL, NULL, 3401, 'f95958de-a678-4371-9710-6bcac3f425fa', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d7bb4cef-fef6-424f-9962-ba724eb19a90', '向化镇', NULL, NULL, 3989, 'fcc07455-c69c-4c90-82cb-ddb268adb8a9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d7de995a-90b4-4f84-9c90-bebe3f03d059', '凉城县', NULL, NULL, 3964, 'a061ae4e-1b4e-4b42-8aa9-cc6bbae9619a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d7e4f44e-fcb9-42da-8c53-1b75eaedabf0', '溧水区', NULL, NULL, 1873, 'adb7aa6e-99a6-453f-a2db-21ecfbc44874', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d7eaf9a2-7e6b-467c-94bb-a5b0cb315a56', '芦台镇、经济开发区、贸易开发区', NULL, NULL, 585,
        'a6c5ceb6-42ea-4d90-bd06-3c0f8cf8bb81', 1, 'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL,
        '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d803ee1e-8803-4d39-ab6c-13bbc5449398', '布尔津县', NULL, NULL, 3526, '2ca5ebc8-b3f5-49d8-b421-85ae2dc0de35', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d8093401-99ec-497a-aaae-cd6bdf120ba8', '隆德县', NULL, NULL, 289, '76330308-a439-44e8-9f63-30f07cae40fe', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d826cd6f-a65f-47ae-82d9-ec31ede3e3b8', '东光县', NULL, NULL, 2892, 'a3c44525-9ccb-429d-a2b7-f5f5d52b8a6d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d8502fdd-8988-439c-8e67-62b11daf389a', '灵丘县', NULL, NULL, 1957, 'c8df6064-e107-46b5-b861-acd5b509b146', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d882240d-3de4-4641-bec4-8c311c4c56c5', '仁布县', NULL, NULL, 3646, '5800fbac-51b0-4bc6-bc2b-34f78067fc28', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d8894d99-589f-456d-82a4-e846d43c08f6', '汉滨区', NULL, NULL, 2975, '55fbb0a6-5436-4d04-9f29-716233f81fd7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d8901558-3faa-4beb-a2f6-ac6112b9f942', '车墩镇', NULL, NULL, 88, '3e082d1b-ecb4-4bf8-8715-54132a9106e1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d8a222e4-6497-457f-b3f1-e1d7409caa4e', '象山县', NULL, NULL, 1678, 'c5cc1924-02da-4927-982d-54f0b9f70ef8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d8a84a93-5ffe-4d02-baf6-8cd074104f16', '甘宁镇', NULL, NULL, 4206, '0ee28cef-8dfc-4a9f-b7c1-330bc11c1bb3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d8b38a11-e613-456b-b50c-de6ff7e04fde', '永春县', NULL, NULL, 1858, '0d3bd52a-74b2-4461-9a57-17c7cce4ac1b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d8bc088f-a539-4a17-9f97-7f6323a85ec6', '洮北区', NULL, NULL, 3102, '7af2dfc0-6d0b-4da1-a6c9-fa505dbc6e9b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d8bd0ed3-5e5c-4adf-b9ff-45f9d5e168e8', '武邑县', NULL, NULL, 2472, 'b126935b-0423-4bea-b802-d4e6680d1d71', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d8c57fcf-17d1-4de5-826c-f006ff1abd9a', '三穗县', NULL, NULL, 3088, '6d3a8433-1273-4323-a3eb-d39effecc1d7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d8ca07c0-52de-4f65-a978-32ab5b3ef003', '向阳区', NULL, NULL, 1405, 'a03ec6c9-8a1e-456b-bab9-164f8015c723', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d8ddef73-9507-4d43-b3af-15c3b10432ea', '沅江市', NULL, NULL, 84, 'c2eab125-e437-4681-9331-695a7b3b1ecf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d8e03618-1aef-44a1-9d81-69f3128b3ffe', '朱杨镇', NULL, NULL, 911, '41f376c0-764f-46b9-af35-e555518fc613', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d8e7c7aa-72d4-4539-a1b6-7862b75443c5', '大塆镇', NULL, NULL, 707, '97942649-3cc7-4e4a-81b4-9a8c82f82ea7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d8ea351c-1e29-4a38-97be-c9c31371fdce', '沐川县', NULL, NULL, 2528, '8f917434-e687-4552-b494-0eab3af61900', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d8f608aa-99a0-4de8-8404-a313978b021e', '瀼渡镇', NULL, NULL, 4229, '0ee28cef-8dfc-4a9f-b7c1-330bc11c1bb3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d90965de-2702-4fcc-b69f-a0df1435d01a', '永嘉镇', NULL, NULL, 3838, 'c33c3107-81df-4ced-8b92-d694df412da3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d91f9bf9-e862-431a-a806-fb372f7bf5a8', '旌阳区', NULL, NULL, 3616, 'b2c794cc-d351-415b-b53c-cf0c454c1165', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d92446af-259a-490f-8837-6c6282ac91df', '涌洞乡', NULL, NULL, 992, 'cc124ed6-091a-42ce-a87a-bb4d0d7357b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d95f0e5b-9dd2-4f8c-93f2-48296eff89f7', '海宁市', NULL, NULL, 4410, '0118b1e4-bae7-4459-94b9-db6947b14aba', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d9653623-6542-4100-a610-e313ec20035b', '怀集县', NULL, NULL, 1473, '2ca74ae0-5e04-4119-84d8-187921fe4056', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d96da390-8267-4ac2-a5b8-c6f26cb46e7a', '徽州区', NULL, NULL, 4273, 'e3fa5765-1e86-4f89-a751-2f63dbe81c99', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d9705eba-8fde-4a9b-900b-e89ad81e438d', '牟定县', NULL, NULL, 2093, '50868d97-8741-48fe-9cba-86e2e118f220', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d98af8df-07e6-4d87-9a27-8f01a6f5a006', '龙南县', NULL, NULL, 1616, 'dd4a8577-afbe-449b-ae9b-be374a4c7434', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d98bad7b-8939-488c-aa3a-be35cbc4acb5', '永济市', NULL, NULL, 4104, 'fc30b5e5-3005-4778-94f7-706b31514bff', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d98f40af-e6cd-404e-a8af-59bc9010ad14', '韩城市', NULL, NULL, 3162, '9e5ae65c-206f-4d7b-87f2-c252d5f40b52', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d99c72d0-6e0f-4688-af04-5f444662b6fc', '芝罘区', NULL, NULL, 587, 'f3717726-7743-4838-852b-3a09f9528a69', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d9aa2c63-09ac-46b2-8609-ace700d5e1d6', '来安县', NULL, NULL, 861, '1a27a18f-784d-4314-bd00-8add932005d6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d9c3060e-f7e6-4d29-8579-4ff990ce9490', '太湖县', NULL, NULL, 3582, '818f3bc6-83b9-4d90-8e68-566cc7c2bb14', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d9dcf986-1c7d-4c64-a310-e31e377ee2dc', '内环以内', NULL, NULL, 3538, '99107e35-f7d9-4c45-8d21-7a03b9c2f99d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d9de977b-1768-4a14-8702-b60f1595ef07', '北仑区', NULL, NULL, 1671, 'c5cc1924-02da-4927-982d-54f0b9f70ef8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d9edc500-5c01-483e-a940-f0d01385668f', '福安市', NULL, NULL, 2434, '8300a2db-b893-4d51-a009-89478871edf1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('d9f59f89-12e6-4013-b6cf-8b58e8baaa22', '顺平县', NULL, NULL, 2497, '81e22d56-a1c7-4263-be18-81a4af165ae3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('da1dd8f0-e99c-421b-a751-af914ce64fa7', '蕉城区', NULL, NULL, 2432, '8300a2db-b893-4d51-a009-89478871edf1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('da213265-2f3d-415a-bbf9-303aae12b3d3', '油溪镇', NULL, NULL, 909, '41f376c0-764f-46b9-af35-e555518fc613', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('da234982-60fe-48b9-8352-157f75ea160c', '枫木镇', NULL, NULL, 4330, 'e98653ba-264e-4417-b74e-e0798b25e646', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('da2acb7a-361b-4c8f-8d7d-11ad81e1ead0', '埇桥区', NULL, NULL, 4097, '94f58cdc-52ca-4a35-a822-4b62ab8bd3d7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('da463d8d-b2a3-4a1e-ac3b-a90cdd20a2a6', '恒山区', NULL, NULL, 2410, 'f583e1ae-7239-4815-b3c7-c5538eb73da9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('da4daee1-77e0-4331-bd94-d977c78ca5fa', '长治县', NULL, NULL, 3850, '6fc78ef9-e2eb-46bc-bf8e-8b830ad96136', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('da56452b-78d9-438a-b76c-19b2180be970', '华新镇', NULL, NULL, 2541, '89a9c37c-487a-4c32-968c-cf9fefad8151', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('da59ac3e-1ff8-4eb7-8cb6-34d896a54ba7', '东坡区', NULL, NULL, 18, 'a24f5cc3-558c-447d-bedc-895b418c750f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('da5cd215-6ce2-4303-9da0-16e1cc2656fb', '红岗区', NULL, NULL, 2363, 'c5e2b320-fd7d-448b-9a02-4fb93e1d3302', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('da60bc98-5927-490b-b435-10ceb5131c5a', '横栏镇', NULL, NULL, 2194, 'f2727650-b0d9-4541-acdb-b4eabf894893', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('da75ef00-6b3d-437e-977f-66d45e4002ba', '沿溪镇', NULL, NULL, 804, '0f559985-f6fe-4a8f-af80-3d0d64932dbc', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('da82c961-a3bb-463c-b5d8-ea00c9f7cfb6', '广水市', NULL, NULL, 2275, '5da76347-cb7e-4817-b07a-985010b9c63a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('da991c3a-452c-485a-86d8-2d811d211c00', '休宁县', NULL, NULL, 4275, 'e3fa5765-1e86-4f89-a751-2f63dbe81c99', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('da9cfc31-6dff-43c9-b1f0-ef62cce8502f', '平凯镇', NULL, NULL, 973, 'cc124ed6-091a-42ce-a87a-bb4d0d7357b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('da9e9ec9-c3ee-48f9-af75-4ff0c4d15ca1', '桐梓镇', NULL, NULL, 4450, '4888e1e9-ba45-4254-83e7-87796f338e2d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('dac4c101-94ee-4f92-8a10-f8aad67afdd8', '杨柳青，中北，精武，大寺镇，环外海泰及外环内', NULL, NULL, 2986,
        'a8cf4e9b-282a-4d0e-af55-7ba949628758', 1, 'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL,
        '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('dacb8f49-2d9b-4418-b748-ef3944c05de9', '弥渡县', NULL, NULL, 233, 'feece7c8-8eeb-494a-8e84-571b6ebcf0d9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('dace44ac-e7b4-4889-a8c6-99d3ec0f2762', '麻柳嘴镇', NULL, NULL, 36, '43c813e3-8672-45c5-8d3e-9ee43dbe51c8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('daef9b12-3820-4c56-8f02-2b919b941847', '南雅镇', NULL, NULL, 3255, 'a39ced08-b6e9-4de0-a2db-7a230a673d1e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('dafed971-f755-45fc-bf8b-26ff01cd1663', '卢龙县', NULL, NULL, 2710, 'f4bc760a-86e0-4fa1-a5e9-cdc21cc7a127', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('db004c31-8d42-4458-b891-53e1e1bdd923', '荫平镇', NULL, NULL, 659, 'd7f44c2a-2728-4633-a8b6-7643136bc99d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('db031a28-850d-4145-9cff-2d2ef475b91b', '巴山镇', NULL, NULL, 2381, '0275a9ca-e89b-4217-b3b0-ada824d9e095', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('db16a28d-17c1-4cad-ad5d-9a87b0ae91a2', '元门乡', NULL, NULL, 1363, '21bb958f-e5d4-4a71-a350-b5bf2c0e2de0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('db2006bc-f535-4f0c-803e-248efd1fc1e8', '九龙山镇', NULL, NULL, 3245, 'a39ced08-b6e9-4de0-a2db-7a230a673d1e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('db31c36e-8153-4749-9e67-f6f1cf607b79', '石门乡', NULL, NULL, 195, '4f867632-2989-4def-9934-a9c5fe0d5ca5', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('db377fc4-d854-4737-8b30-a9d1fb36fec4', '阎村镇', NULL, NULL, 67, '0863a0a5-7ac5-4a13-80f5-d31e3a1aa459', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('db476947-3f20-411c-947e-850b8f3d5c9a', '科尔沁左翼中旗', NULL, NULL, 1558, '1dc7d092-717c-424e-a473-bb2cc8836b5e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('db4c2e53-ca63-43d5-8fa9-267531f0df52', '燕山地区', NULL, NULL, 68, '0863a0a5-7ac5-4a13-80f5-d31e3a1aa459', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('db4c6688-d511-4f11-bc75-55868ce1485a', '沙洋县', NULL, NULL, 777, '060b2327-c9b1-47ef-a56a-d280d1a4297d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('db51878a-d69f-46d2-baec-f5e0bd490e01', '凯里市', NULL, NULL, 3077, '6d3a8433-1273-4323-a3eb-d39effecc1d7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('db6ac607-fc39-4c7c-9d98-b63a3e3e34b2', '秀峰区', NULL, NULL, 3184, '796bb0e0-6b76-4c1d-801f-2dbcbab74087', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('db8830f7-f2c9-4c53-81d7-ee620b1a97cb', '巍山县', NULL, NULL, 240, 'feece7c8-8eeb-494a-8e84-571b6ebcf0d9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('db8e2739-6ba6-4897-97ae-66be12c75f03', '咸宜乡', NULL, NULL, 2399, '0275a9ca-e89b-4217-b3b0-ada824d9e095', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('db9b8af0-7b24-463b-a7cc-e01f8413422e', '邯郸县', NULL, NULL, 210, '237eff18-fe6c-4842-afb1-acb05027a5c1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('dbcc1a20-7dec-48f8-bc7e-59fe3c717d77', '柳北区', NULL, NULL, 2748, '0f2ba543-1d40-4b41-b700-6b53a9622b5b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('dbcd0e32-043a-4300-a2bf-1702d6bff25f', '阳西县', NULL, NULL, 3973, '97a2157a-88ce-46f6-ba0f-e432060024ca', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('dbd8a06b-a439-430b-9405-98fb2af3ccf6', '牡丹区', NULL, NULL, 1788, 'e04fe06c-7641-47c7-a125-4d35e1800549', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('dbf67715-8135-42da-9dd7-320f3d516423', '长兴乡', NULL, NULL, 3993, 'fcc07455-c69c-4c90-82cb-ddb268adb8a9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('dc1608dd-163c-4d04-990c-7955a4d9a4b4', '红岭农场', NULL, NULL, 3227, '2e21ea75-c640-4928-8cb4-e5ba4f6e2ffe', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('dc1c641d-c3ba-4581-84c4-77d13682a807', '鹤游镇', NULL, NULL, 1481, '89e8be16-b810-4c7e-89f0-aa9f24483b98', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('dc2ff08a-16b5-4ab7-8004-c160982391f9', '万祥镇', NULL, NULL, 2645, '4683d3ef-0edf-425a-98d5-2cb231a7d88a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('dc3044c0-fec6-4024-b512-6963b1e8461e', '临翔区', NULL, NULL, 514, '88546360-1a0c-4407-9b25-2cde1db643ee', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('dc330e7a-5738-446c-8c99-128c5ef6e1aa', '安居镇', NULL, NULL, 3828, 'c33c3107-81df-4ced-8b92-d694df412da3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('dc3c035e-9807-467b-a746-cb31268df67e', '梅河口市', NULL, NULL, 866, 'def0f6fb-9804-4bed-8554-2115bfca9849', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('dc486d95-eff3-42a4-96ca-0bc2081503dc', '彭场镇', NULL, NULL, 3468, 'ea11feaf-194c-4cec-be59-d17bac402db4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('dc68eded-9b0e-4732-af1b-4a72b127c070', '侨乡街道开发区', NULL, NULL, 2164, '671275c4-6107-4968-bd8e-96d53e9995b2', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('dc6a7cfd-7a88-4212-a665-645f226567e2', '永顺县', NULL, NULL, 3790, 'b9b94634-b449-4449-9581-c70550dc5099', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('dc719e0c-d546-4ec9-b6f3-28ea20205ee7', '宽城县', NULL, NULL, 4036, '8db8f645-a1a6-4c39-9c27-2f703951f66d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('dc780e50-bb3d-4c4d-b8be-785af8d39af5', '南康市', NULL, NULL, 1605, 'dd4a8577-afbe-449b-ae9b-be374a4c7434', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('dc7eba5c-db10-4490-a919-d61e1618c9e1', '黄州区', NULL, NULL, 995, '63a5fa32-35eb-4eca-ab79-f3887e122564', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('dc8df01d-ce56-4a4e-a8ea-d95ce4e1b8ee', '濮阳县', NULL, NULL, 1256, 'e16eafe9-9ca0-4609-8c8c-a1b16b52669f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('dcca582e-136d-44fb-b6dd-fdf6c21882e7', '白银区', NULL, NULL, 3093, '0fafa17c-1c8a-4cb9-a100-4cfa035e3fed', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('dceaf671-ff3c-450b-9257-b836cc91fac3', '轮台县', NULL, NULL, 3178, '0ce20b86-8bea-4d7c-a1e4-09c7519d8b16', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('dd0256b5-c5ce-4ade-87e6-64e81e88238f', '乐昌市', NULL, NULL, 1521, '754500f9-7ec4-4379-8b1c-9370f50564c0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('dd09c3c0-9286-4b1f-8ce0-50fac99357e2', '义和镇', NULL, NULL, 3260, 'a39ced08-b6e9-4de0-a2db-7a230a673d1e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('dd5945ca-bcf9-42b3-8b19-94db64b867f6', '南皮县', NULL, NULL, 2894, 'a3c44525-9ccb-429d-a2b7-f5f5d52b8a6d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('dd5b704f-9d5e-4749-941a-7537f5d49bf1', '巨鹿县', NULL, NULL, 1040, '4d6c5692-82f1-443c-9163-39a3dd77636b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('dd6a404c-3bb4-4f37-add9-0c40e7903e1f', '顺庆区', NULL, NULL, 1247, '71643995-698f-4bdf-afe9-09fce8a065c0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('dd6e84a5-b692-43e3-8fc1-d8d9a31e0e23', '芒市', NULL, NULL, 433, '10aecf03-914d-4a26-a6c3-0045748d43b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('dd752b14-931d-48d2-af65-9038123aec17', '杨镇地区', NULL, NULL, 3742, 'd1c1539c-b904-4bcc-a034-96213f63d0ff', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('dd84869f-0800-49de-9927-8119432a9269', '界首市', NULL, NULL, 1623, '6de68814-d6ea-430e-88b6-bf98620aa604', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('dd87a9c7-bab1-4c19-8cd4-b6d18432723a', '莒南县', NULL, NULL, 4347, '56327d0b-ec26-4f34-8ab6-0eba49931c67', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('dd9226ae-5bf9-4677-b7bd-368bc4d15e11', '南泉镇', NULL, NULL, 32, '43c813e3-8672-45c5-8d3e-9ee43dbe51c8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('dd9673ad-1f0b-4427-9ac2-2de574a22a2d', '沙河市', NULL, NULL, 1030, '4d6c5692-82f1-443c-9163-39a3dd77636b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ddaaeee8-2d91-4034-bb0f-e4579780cd2a', '永胜县', NULL, NULL, 3303, '533981ab-21f3-46b9-91a4-320129bd0b49', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ddbf09dc-11bc-4b98-98ad-51d4ae97788b', '洛龙区', NULL, NULL, 1169, 'b5a118ad-786c-4d86-b4e8-5d25a3776a78', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ddc736c8-aee6-470b-a2a0-372d08548855', '高阳镇', NULL, NULL, 167, '4f867632-2989-4def-9934-a9c5fe0d5ca5', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ddf8bed6-97e1-4e51-8ab0-be4a5e46e9f7', '合浦县', NULL, NULL, 2030, '93e31709-76d2-4b65-aa0f-7990919a44d0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ddfcc134-422f-4578-9ef9-b529eb9b8291', '东胜区', NULL, NULL, 3529, 'eb551697-7acc-4bcd-9d21-3d48c16f8258', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ddfd1474-113a-4cfd-8c68-cc59b00e19b2', '香营乡', NULL, NULL, 1516, 'd5ab951d-20ab-46ff-8838-de5efe06b6b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ddfe8cdc-a456-4e62-bf26-228c8a3f4889', '龙驹镇', NULL, NULL, 4211, '0ee28cef-8dfc-4a9f-b7c1-330bc11c1bb3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('de1be34a-3843-4f7c-9f0d-2900cf0163d7', '翼城县', NULL, NULL, 3703, '1aeeea9e-d028-4a96-94ce-ba84cdd3e69f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('de206c5c-41c5-4eee-b632-c350312fce58', '会泽县', NULL, NULL, 1331, '9568bdcc-65c2-4b1c-a512-b2ff897db321', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('de27f5e5-9ea8-4dc7-9fbb-72b3d40e29a6', '铁矿乡', NULL, NULL, 4466, '4888e1e9-ba45-4254-83e7-87796f338e2d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('de2be335-b48e-4aac-8d96-ba75e50ffc21', '运粮湖管理区', NULL, NULL, 846, '24ad0708-80a9-43b1-8e1c-758f2492d3f6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('de4d1e1c-3809-4451-baff-ca96002a4534', '盘龙镇', NULL, NULL, 2515, 'd998f8bc-c659-47ce-8e5e-a6b29e03ecb3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('de5b5d13-1c67-40ac-bc23-86135bb83828', '长岛县', NULL, NULL, 598, 'f3717726-7743-4838-852b-3a09f9528a69', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('de5d447f-a586-44ed-bd11-e7dbe05844fb', '印台区', NULL, NULL, 912, '667720b0-8429-42ef-b6a6-582df9b59468', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('de5dd99c-b474-4a69-baf8-341657bd1ca1', '石马镇', NULL, NULL, 1646, 'a560b8db-8db1-4bc8-bb6b-fbbecebcaf10', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('de715eb0-1be1-4487-8c5a-b6b7fa3f3522', '泸溪县', NULL, NULL, 3791, 'b9b94634-b449-4449-9581-c70550dc5099', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('de7453e0-40bf-4a7b-85c8-7ca6d9262ab1', '铁岭县', NULL, NULL, 2790, 'def78b05-5d2b-430c-b268-442502dc3ca5', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('de82a2a3-11f0-44d8-bec6-b031e0d6f7a0', '城区', NULL, NULL, 1503, 'd5ab951d-20ab-46ff-8838-de5efe06b6b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('de867a81-5935-4b08-9b3e-d1b942e776de', '濯水镇', NULL, NULL, 3370, 'aa2f26e5-9705-4dc0-b54a-a2d7dbb8b511', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('de96eee0-3f9a-4d93-8073-320a30d18384', '旧县镇', NULL, NULL, 1507, 'd5ab951d-20ab-46ff-8838-de5efe06b6b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('de9ec6e9-fe86-476b-ad9c-1e5507d29460', '涞水县', NULL, NULL, 2486, '81e22d56-a1c7-4263-be18-81a4af165ae3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('dea33446-b1c1-45c0-98ce-406c33547615', '阜沙镇', NULL, NULL, 2205, 'f2727650-b0d9-4541-acdb-b4eabf894893', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('deb58689-134f-4d93-bd40-abcaa878ac35', '吉县', NULL, NULL, 3696, '1aeeea9e-d028-4a96-94ce-ba84cdd3e69f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('dec1fc56-df05-46c3-9610-0707a8857e38', '平泉县', NULL, NULL, 4032, '8db8f645-a1a6-4c39-9c27-2f703951f66d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ded8ef84-d734-449b-9c45-02f3cfc1f8a0', '荥经县', NULL, NULL, 3630, '6af0e8d8-91c9-43be-be32-5ec5c86b14f5', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('defcef24-fdb1-4a18-aa3c-b2f951635a4b', '石岗乡', NULL, NULL, 1103, '79482cd9-7d51-4c89-94c2-4bcd773b8323', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('df0191a3-a996-4165-a866-e5c260dc5b55', '工业园区', NULL, NULL, 616, '278acb58-4d2d-40cb-a572-1fc7fb979c77', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('df1085de-33d9-446c-beac-2a0530645618', '罗定市', NULL, NULL, 262, '34138fe1-593f-4c44-87ac-1beaee74bafb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('df10d876-882c-454b-be63-a3beae5b7175', '桑坪镇', NULL, NULL, 180, '4f867632-2989-4def-9934-a9c5fe0d5ca5', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('df2c67de-2a17-4bd5-98a5-1be8fd95328f', '长安区', NULL, NULL, 4289, '29595f0b-301d-42da-845d-01afb30a9c18', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('df33fc9e-9eab-409e-b26c-f3d7dc3b8aa4', '铁山港区', NULL, NULL, 2031, '93e31709-76d2-4b65-aa0f-7990919a44d0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('df46d9d5-55f5-42ce-a999-735309b9b861', '南阳农场', NULL, NULL, 3821, '96fec37f-11d5-4d41-aba4-a36d0652744c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('df512928-3533-472f-b8eb-6cb12531426e', '昌洒镇', NULL, NULL, 3805, '96fec37f-11d5-4d41-aba4-a36d0652744c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('df54e0f7-a486-4133-8a08-baae79de6fcd', '榆阳区', NULL, NULL, 1304, 'c0c88cbd-87ea-4281-9e8e-94a435ae6590', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('df5ec9c6-ea28-40b8-a1a7-ed25812a242e', '北安市', NULL, NULL, 1423, 'e27d8c07-338c-4b1a-b45c-cf9cf0a22a0c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('df60003a-c7cf-45ff-86b2-7616e9b8b271', '三星镇', NULL, NULL, 3987, 'fcc07455-c69c-4c90-82cb-ddb268adb8a9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('df697fdb-9c70-4ee1-9464-ff885a556ac0', '永登县', NULL, NULL, 4045, '2d364b6d-2931-4d45-995a-336e4e0f2b55', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('df717d46-ce39-4882-b942-4f0697d22bb4', '壤塘县', NULL, NULL, 1192, 'd56c2ee6-b81c-4df8-ba2f-3df7680243c4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('df7f47be-90af-4028-a1cc-4e270c50e160', '新市区', NULL, NULL, 2479, '81e22d56-a1c7-4263-be18-81a4af165ae3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('df7f7644-242f-48e0-9e68-0b30038bd1a8', '观塘区', NULL, NULL, 476, 'dfb8b556-10a2-43ab-9fdb-66cde92320ee', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('dfa1eec3-96b7-4a94-97fb-a8345e6ff3ee', '滦县', NULL, NULL, 2463, '4f4c1ef4-f54d-4ba4-a124-ca2d3d0ddb78', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('dfa4e69b-c57a-4270-be02-46b2f041abe2', '双龙场乡', NULL, NULL, 1934, '442f465d-6566-45e4-9338-50f4395aa6f7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('dfe5618f-a435-4e3e-a3d4-6f35e951170b', '石子乡', NULL, NULL, 2678, 'e509a1a5-95da-4fb2-9a2b-f84afa05a36c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('dfe5bb65-e6af-4348-b5c3-1ea6833446d9', '勐腊县', NULL, NULL, 2008, '69f08469-ecd2-4a94-a921-da836fbf5838', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('dfeaa640-767d-44b0-bade-5cbd0a9e585c', '武汉经济技术开发区', NULL, NULL, 432, 'e6e46871-d5a0-4d2b-8243-9d4bd864ab43', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('dff374f6-2d51-4403-ae36-3450c16ffdeb', '北票市', NULL, NULL, 4136, '0c1d1a8a-4eea-4aa0-9a5e-b68ae380a09a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e0088f0e-3581-4687-bc60-06d1e057aee6', '建德市', NULL, NULL, 2317, 'f530455e-1c70-47dd-9a80-4bc74a4e2680', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e01759f6-3527-40af-b9a9-372f8bb3485a', '白朗县', NULL, NULL, 3645, '5800fbac-51b0-4bc6-bc2b-34f78067fc28', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e0213ecc-3169-492c-a739-4328d34141f4', '西湖区', NULL, NULL, 1279, 'cf24a0a2-c56e-45df-920c-8247c771d48e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e02ae26d-253f-4f02-a53a-7d8cf5eb25ed', '增福乡', NULL, NULL, 1126, '72d4f69f-2e4c-4bde-9df8-2aadc9168686', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e02c670e-70f8-4715-9dd3-237092d89c13', '碧江区', NULL, NULL, 2869, 'dce7fe20-4766-408d-92be-62ba8fbb7a43', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e04840d7-f964-40ab-ba8d-654011133c57', '广阳镇', NULL, NULL, 2263, 'd17f8f8e-b3dd-4818-a89d-8b431ff5c555', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e05649ae-c9c7-4084-b857-2c0e53c37556', '彭山县', NULL, NULL, 20, 'a24f5cc3-558c-447d-bedc-895b418c750f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e058d575-9f62-4b0b-9f5f-bc11fedefce2', '岱山县', NULL, NULL, 1290, '02033c55-d6b3-4a85-91e0-b68d170d3383', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e05b2532-7877-4eed-bfd5-7a236d222705', '平远县', NULL, NULL, 4395, '2aabe025-ea3b-4ce4-885f-9ecf122b3e79', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e05fd396-88a3-4ce2-a313-a11fd4927290', '清泉乡', NULL, NULL, 2941, '465e9ea2-a2f2-4b42-95dd-b48d91f67105', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e06e78da-51b1-4020-b8ec-02a8525d06e5', '垣曲县', NULL, NULL, 4107, 'fc30b5e5-3005-4778-94f7-706b31514bff', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e08b4074-e32d-4234-8803-762b297c4a4e', '永寿县', NULL, NULL, 2106, 'e42fbad8-c29e-4f35-878d-95a667b5cc90', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e090f0ef-e346-4d5b-afb4-d1f0cc5e26bb', '丹巴县', NULL, NULL, 3767, 'c262a40d-a147-4930-b33b-574ec51fa884', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e0986e0d-9b15-4cde-b76e-6c0f48806256', '矿区', NULL, NULL, 1965, 'c8df6064-e107-46b5-b861-acd5b509b146', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e0989023-2c06-447b-bed8-0b3ce690edc6', '酒店乡', NULL, NULL, 1137, '72d4f69f-2e4c-4bde-9df8-2aadc9168686', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e09b7ba4-81d3-4ce2-81c3-14ac66b798b1', '金湖县', NULL, NULL, 756, '3c9ba44c-7031-4422-b9b7-85d772ee3e08', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e0a0ed9f-e24b-4bb2-a1c4-6690b906705a', '高梁镇', NULL, NULL, 4208, '0ee28cef-8dfc-4a9f-b7c1-330bc11c1bb3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e0b150f5-a1f0-4070-a34b-dc33d4d4e91c', '淄川区', NULL, NULL, 2445, 'c03520db-2a67-4cae-a658-4806d4254996', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e0b6e8c7-346f-4752-8910-aa0f1152280d', '长沙县', NULL, NULL, 627, 'dccf3d25-c012-444b-94c6-bbcbae7e63d8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e0cae816-c693-440a-a1e6-b39b552015cf', '东乌珠穆沁旗', NULL, NULL, 2351, '67723aea-a4ef-4eb7-afbf-55cc07806f98', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e0d67198-6bd0-4fca-8e47-669e1c4b678f', '金汇镇', NULL, NULL, 635, 'fa34c22b-c1d8-45b2-bb1b-4ea08298e7f6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e0e7412e-42c5-4c9e-8635-84f542539274', '堰坪乡', NULL, NULL, 200, '4f867632-2989-4def-9934-a9c5fe0d5ca5', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e0e9680d-559c-4e1e-8aa8-373e6b5580ab', '新青区', NULL, NULL, 461, '7ca3412f-b06b-467e-b547-691ab8327b15', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e0fd88a9-5e2c-443b-9676-5cb171a5b15b', '尼木县', NULL, NULL, 4154, '5a657ab2-3d76-4a46-917c-ddfe22c60d16', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e1011258-ccc5-4f15-9adc-88444f6bbb8f', '枫泾镇', NULL, NULL, 2702, '0e5598a8-f405-4745-8cd5-a7a4c99f67f9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e11bfbba-ca21-4007-a14b-c71e031853e9', '云城区', NULL, NULL, 261, '34138fe1-593f-4c44-87ac-1beaee74bafb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e14a7134-47e1-4b7f-96cd-62e8501ff156', '镇远县', NULL, NULL, 3081, '6d3a8433-1273-4323-a3eb-d39effecc1d7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e14fa809-5774-4ba0-be04-238e1cd27246', '郑场镇', NULL, NULL, 3459, 'ea11feaf-194c-4cec-be59-d17bac402db4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e1725c79-2dd8-464b-85e5-5c157d0e5c30', '石渠县', NULL, NULL, 3776, 'c262a40d-a147-4930-b33b-574ec51fa884', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e1741cde-c203-4dc8-b410-6efcd88280ac', '兴隆台区', NULL, NULL, 2000, '9d95b0ef-0bbc-404d-80d4-2143f433a4c2', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e18a0dc9-35ad-4214-b3cb-11c4bda73da3', '长丰镇', NULL, NULL, 4489, 'f491d9c3-9527-46a4-8954-6795ff079478', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e19b1f21-8250-40e5-9336-30fddc3ab6b3', '临潼区', NULL, NULL, 4293, '29595f0b-301d-42da-845d-01afb30a9c18', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e1a40fa1-d035-48e9-8968-897920097767', '巴林左旗', NULL, NULL, 4477, '4b199fdb-3a49-40f7-9843-8bd43f4ea30c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e1b460ab-d002-48f8-8702-12be6bee7509', '黄岩区', NULL, NULL, 3290, 'de41020d-a8dc-44d0-a2d4-75b6076c0ae8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e1bc9740-fc75-4f17-9ea1-20a62bfb9ceb', '城厢镇', NULL, NULL, 1574, 'ac0e6e50-b6a1-457c-811c-06ac309cd5a3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e1c1c5e2-ec34-40d5-bd13-2c891adf2632', '元宝山区', NULL, NULL, 4478, '4b199fdb-3a49-40f7-9843-8bd43f4ea30c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e1cb5f54-fb71-4bec-87d6-b04c63819284', '吊罗山乡', NULL, NULL, 2277, 'b3792f06-9c78-446e-b6ac-d95d5e9092e8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e1cc7eb1-8c14-4dc3-8a37-c7fc967e39ec', '东兴市', NULL, NULL, 268, 'b844b23e-c209-4691-8773-29f9f7f080e6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e1db3799-6329-4202-aad0-34bb0d092d66', '庆元乡', NULL, NULL, 933, '88260608-a8b9-4b52-a474-1a551465c675', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e1ddeaf1-94c9-422b-aded-897fe8f74831', '沉湖管委会', NULL, NULL, 2163, '671275c4-6107-4968-bd8e-96d53e9995b2', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e1df25eb-68d4-4f37-a33e-ea38ef7bd4ac', '五原县', NULL, NULL, 1681, '753245e5-8705-4940-badd-cd71430a4fdb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e1f099f8-6b3f-40c1-8f50-32d097d8b00b', '向阳区', NULL, NULL, 3279, '978f3e32-c5e0-48e4-b9ba-4f7f04ed87a1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e22df937-d1c7-4656-9f27-0e127857466f', '黄江镇', NULL, NULL, 3332, '3bc6861d-0eeb-497e-9257-42f9cd6fd26f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e23c6a44-f912-41e9-8046-61e55f089738', '温岭市', NULL, NULL, 3293, 'de41020d-a8dc-44d0-a2d4-75b6076c0ae8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e24bea4c-5f5d-4cef-8d37-3522a9610ee0', '阿勒泰市', NULL, NULL, 3522, '2ca5ebc8-b3f5-49d8-b421-85ae2dc0de35', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e24cd7de-ff44-431c-bef2-aaa3d8ddc878', '宜阳县', NULL, NULL, 1176, 'b5a118ad-786c-4d86-b4e8-5d25a3776a78', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e25bcd69-0d31-4840-8022-0855f15f7100', '梓里乡', NULL, NULL, 1133, '72d4f69f-2e4c-4bde-9df8-2aadc9168686', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e264ab86-e180-4564-aee8-2c0b0db7705b', '灵台县', NULL, NULL, 29, '4edd328e-68af-4f0e-bca8-63686e5cad24', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e299cae1-3101-453e-ad62-45875f41a7cb', '高埗镇', NULL, NULL, 3336, '3bc6861d-0eeb-497e-9257-42f9cd6fd26f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e2b0c388-0ad6-4b84-80a9-f0214975e1da', '宁明县', NULL, NULL, 3032, 'c99528d5-bed7-4890-b547-f2159ed13a78', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e2b50ab6-7dfa-4a4a-bafa-198c504862d4', '金溪镇', NULL, NULL, 3364, 'aa2f26e5-9705-4dc0-b54a-a2d7dbb8b511', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e2bc8ad4-b5f7-4fd5-88ab-8885c0780223', '周口店镇', NULL, NULL, 72, '0863a0a5-7ac5-4a13-80f5-d31e3a1aa459', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e2c50fc8-365d-48f3-9b43-76b633a59341', '西畴县', NULL, NULL, 2225, 'fadbb851-aec5-4d3e-be0e-09e7462eaceb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e2ccbe22-9806-42ea-8158-b45ded4705dd', '兰坪县', NULL, NULL, 3976, '141f0b1e-0746-4a59-b91a-6356d1352335', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e2d19982-ebe2-431b-9bd6-c3427e993c14', '西流农场', NULL, NULL, 3224, '2e21ea75-c640-4928-8cb4-e5ba4f6e2ffe', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e2defdeb-3377-43e8-bc94-a34ed048d56e', '万山区', NULL, NULL, 2873, 'dce7fe20-4766-408d-92be-62ba8fbb7a43', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e2e7cb33-8912-4b8b-8c85-a1f4bf3213cf', '湾里区', NULL, NULL, 1288, 'cf24a0a2-c56e-45df-920c-8247c771d48e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e2ed7173-b4b0-4089-8574-81f44e5fb6d4', '三水区', NULL, NULL, 329, 'dbd204cb-29de-4212-8c03-c2286f2ba4f5', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e305f1a9-017d-4328-a45b-10624ab0d78e', '彬县', NULL, NULL, 2108, 'e42fbad8-c29e-4f35-878d-95a667b5cc90', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e31b881c-ebd6-4d34-9d35-a65ba9ea218a', '泸定县', NULL, NULL, 3766, 'c262a40d-a147-4930-b33b-574ec51fa884', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e31ed873-d28e-449b-bb24-40ab50fb4392', '西乡县', NULL, NULL, 346, '5c4e7f63-9162-47e1-a948-c64ca46ff566', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e31fd35f-aba9-4bf0-966b-817ab50e4e56', '资中县', NULL, NULL, 1995, '7e24b0e5-bf57-4e62-880a-e5b6ec159053', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e3586a50-0d4c-4b50-b2a1-39b357d2969a', '雁山区', NULL, NULL, 3187, '796bb0e0-6b76-4c1d-801f-2dbcbab74087', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e358b61f-6c15-4e51-b599-3a4c02a36dc4', '榆社县', NULL, NULL, 529, '84a16421-f7fb-4f99-b2c0-1e0dea97bf0b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e36eb6ba-87a5-4ee9-b08c-a30b485c7cd6', '台江区', NULL, NULL, 4242, '71a49c5c-c3c2-4fcb-8f90-aa1d733a19f7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e3798e16-93a1-449e-adea-788634f930b3', '青原区', NULL, NULL, 4314, '5f548430-51dc-45ad-82e5-bcd0394d8f6c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e379a862-4120-46d0-8b26-0a2d30593ca6', '西大垸管理区', NULL, NULL, 845, '24ad0708-80a9-43b1-8e1c-758f2492d3f6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e38dcc91-8c58-4a97-a4ee-ae737d9cf9fb', '邗江区', NULL, NULL, 3050, 'f9ca7af3-a2b5-4d1c-a8c5-c4dbe4fe60e1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e39720b0-1003-4963-bb49-fb899bd9d9b2', '新化县', NULL, NULL, 3748, 'cff58e36-5b90-4beb-a3b7-e04021d244cb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e3b4801e-73cc-4c62-9bc6-7594741c9e3e', '铁东区', NULL, NULL, 681, 'de003161-c00c-4f8a-ac92-6a2188069e9b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e3ba4834-3ea2-484a-94ef-7253bbb58bcd', '阳信县', NULL, NULL, 303, 'be93aa9b-d81f-4e98-a0c0-18f840594a05', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e3c05fa1-a092-4ad4-b48a-f5c3fb3d070c', '青山区', NULL, NULL, 428, 'e6e46871-d5a0-4d2b-8243-9d4bd864ab43', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e3cb5713-3a7f-4cc7-95e8-926b53897a1e', '会东县', NULL, NULL, 3509, 'c8f594a3-8acc-48a9-ba2f-e76934de05eb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e3cd1b97-fc2b-426f-87a4-17af80d72487', '阿拉尔市', NULL, NULL, 2333, '03761c32-1378-4ae3-b5a5-4be7d38da29b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e3d55cb6-c2f8-4e03-8bb4-ca457eeac3fd', '沙湖镇', NULL, NULL, 3466, 'ea11feaf-194c-4cec-be59-d17bac402db4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e426b20d-56f5-4705-a34b-c5b38ebd374a', '龙华区', NULL, NULL, 2883, 'b899bf86-aa99-4e70-a544-8ebe64da4f24', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e42a60c9-5d71-40ed-a9f1-df4b992f2aa1', '打通镇', NULL, NULL, 3657, '6581d8db-553e-4417-8c37-91ed47904920', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e43286c5-a727-4d45-b4d1-324cb0d7eb7e', '容县', NULL, NULL, 2336, 'ee710091-bfa9-4285-89e3-80ad65ebd912', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e44c134e-173f-410c-8ebd-78db7495dd82', '永年县', NULL, NULL, 209, '237eff18-fe6c-4842-afb1-acb05027a5c1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e4586c6b-d6d9-4ead-99af-abb9138c6bbd', '姚安县', NULL, NULL, 2099, '50868d97-8741-48fe-9cba-86e2e118f220', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e45f6977-bd27-4cad-8ec5-3a56eab53b22', '钱塘镇', NULL, NULL, 3892, 'a732da28-870c-4d9c-a287-c2c1e3222b59', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e4720a6c-afe9-43fd-9ee7-f3f48091a069', '长武县', NULL, NULL, 2110, 'e42fbad8-c29e-4f35-878d-95a667b5cc90', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e475d481-09b0-48c6-a164-c0143af0608e', '民和县', NULL, NULL, 126, '21aca68b-8887-476c-b2b3-fe670c301acc', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e48a0139-1184-49ae-b03a-bb8a5d86724d', '牛栏山地区', NULL, NULL, 3735, 'd1c1539c-b904-4bcc-a034-96213f63d0ff', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e4947d6c-df6f-40f5-a134-f769648b6b98', '康定县', NULL, NULL, 3765, 'c262a40d-a147-4930-b33b-574ec51fa884', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e4a0e24a-4f96-4bd4-b971-1650fac1adde', '太安镇', NULL, NULL, 4215, '0ee28cef-8dfc-4a9f-b7c1-330bc11c1bb3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e4a40466-c33e-49a0-b65b-095aa2de2dc6', '咸丰县', NULL, NULL, 2359, 'ecba10ba-2c25-4ead-a781-ad16a832226f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e4b58887-e0a0-4444-8f0c-bbd14de81f59', '南靖县', NULL, NULL, 1200, 'bda1d0f2-1476-4e0d-8fb9-2d1392397cbb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e4df97a4-6b14-4e07-a2af-a078b1c9d2ee', '通桥镇', NULL, NULL, 1662, 'a560b8db-8db1-4bc8-bb6b-fbbecebcaf10', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e4e9053f-1c9e-42c6-a024-8d798231ea89', '后坪坝乡', NULL, NULL, 2928, '465e9ea2-a2f2-4b42-95dd-b48d91f67105', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e4e95470-a618-4aab-a3a9-dbe7809a309e', '郸城县', NULL, NULL, 2301, 'f3e12d68-f8c5-4d9d-8314-dd1ce7dac2f9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e512169d-fea8-4c5c-b897-c6a80cd51208', '鹿邑县', NULL, NULL, 2297, 'f3e12d68-f8c5-4d9d-8314-dd1ce7dac2f9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e51aeb40-47e8-4551-a522-a622541db4f0', '婺源县', NULL, NULL, 496, '8bf55045-9366-4acb-b884-bca672ff9644', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e51bb610-963c-4aa9-b8aa-fee1c08905b3', '融水县', NULL, NULL, 2744, '0f2ba543-1d40-4b41-b700-6b53a9622b5b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e532c515-1ae2-40e9-943a-2c2168c8d4bc', '黄金镇', NULL, NULL, 2661, 'e509a1a5-95da-4fb2-9a2b-f84afa05a36c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e53e7f4e-cb22-4ae6-bb60-65decf26b1a1', '互助县', NULL, NULL, 127, '21aca68b-8887-476c-b2b3-fe670c301acc', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e54f5429-fb73-423b-bf48-46ec11073c83', '泽库县', NULL, NULL, 2059, 'c9781b3d-f13b-42a5-962f-df7de65d2033', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e55632e0-9a4d-43ab-a783-07682f265798', '兴隆镇', NULL, NULL, 714, '97942649-3cc7-4e4a-81b4-9a8c82f82ea7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e561cbae-6d01-4630-8d62-4a4a7b499928', '莱山区', NULL, NULL, 586, 'f3717726-7743-4838-852b-3a09f9528a69', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e565be19-4b07-4dde-bc4a-bf931f45457e', '垦利区', NULL, NULL, 1216, '1de2a515-79f9-47f9-a31f-f6892f97a705', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e57cbd48-3cff-4be1-a60e-bde661cbae89', '瑞溪镇', NULL, NULL, 4084, '5d3b3a34-50c8-4a01-83b7-e3e068d5c9a7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e584011a-c7c7-4c02-8311-6dae281c5bb3', '余干县', NULL, NULL, 497, '8bf55045-9366-4acb-b884-bca672ff9644', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e5850c66-4c18-4971-ac7d-6a2f896f1c0f', '东平县', NULL, NULL, 1241, '23df07d6-66e4-474e-b42b-258f50d7b0e4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e58aad5a-0e18-489d-aab8-52d68ae84bc2', '崇兴乡', NULL, NULL, 1936, '442f465d-6566-45e4-9338-50f4395aa6f7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e59c4d40-303f-436b-ab0b-ea0a29b6704c', '夏县', NULL, NULL, 4111, 'fc30b5e5-3005-4778-94f7-706b31514bff', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e5a98dd4-08b1-4aaf-b049-098e0727f6e2', '八步区', NULL, NULL, 1463, '6f0d2b72-566f-44e5-969d-2d2ce65ace5c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e5b8d6c4-99ef-4fa5-b88d-749ba9c683bb', '四海镇', NULL, NULL, 1509, 'd5ab951d-20ab-46ff-8838-de5efe06b6b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e5bbc623-dbb9-4d95-b843-64a31fd49978', '图们市', NULL, NULL, 1051, '87e1c9be-7455-45a9-ace5-641efce55e22', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e5c53be8-b3b5-4292-9b77-a99cde7d11af', '窦店镇', NULL, NULL, 53, '0863a0a5-7ac5-4a13-80f5-d31e3a1aa459', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e5c5dd5d-cbf8-4e0b-bf4f-4a96f4783a7a', '郎溪县', NULL, NULL, 1045, 'a489375e-6a4e-410b-be41-f687ba6c52cf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e5f62b52-cec2-45a6-9b92-987405b62e2e', '武胜县', NULL, NULL, 3298, '4bb2fe40-7307-498b-802c-e85e937f95e0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e607d966-a880-4fe6-a32c-d4f35e8eec8b', '彝良县', NULL, NULL, 3688, '31187fc0-8d6e-45f3-9653-b7ce4227ef1d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e619daa7-6b0c-4516-892d-69201ac4c076', '富平县', NULL, NULL, 3171, '9e5ae65c-206f-4d7b-87f2-c252d5f40b52', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e638bd5e-840a-41f5-aaa4-9a999b06dcdf', '碌曲县', NULL, NULL, 3129, '9d7c5001-b115-4bea-abb4-a289a03b5075', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e63c5287-5575-4dc1-889a-e902a98c0274', '双牌县', NULL, NULL, 1729, 'c7d6739c-4d7d-4d8f-bf6e-d6a6a7d38f20', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e65288c8-1060-4d30-97b5-804a352dec93', '昭化区', NULL, NULL, 506, '74a706f1-82bb-4132-8ee4-9abf7bd809cb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e6571c35-a387-46b9-a651-1f2354bc0aea', '扎兰屯市', NULL, NULL, 1061, 'c31a65eb-4d77-4b38-8142-9c9e2f54ed46', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e660102a-9a71-43f3-91c6-ddc6df1d2a51', '可大乡', NULL, NULL, 2933, '465e9ea2-a2f2-4b42-95dd-b48d91f67105', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e6b9afd7-2eb3-4666-8b08-4758b03febf6', '海拉尔区', NULL, NULL, 1058, 'c31a65eb-4d77-4b38-8142-9c9e2f54ed46', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e6c0fb57-a153-4b12-8b9c-08a65794a04a', '城区', NULL, NULL, 699, '97942649-3cc7-4e4a-81b4-9a8c82f82ea7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e6c50c20-f0e0-4827-80bb-47936e0fbde4', '宕昌县', NULL, NULL, 1374, '7c9ca39d-ce8f-469d-899a-09a0a29c1541', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e6c8db29-b314-43f5-bee1-ee7886cdb226', '小昆山镇', NULL, NULL, 96, '3e082d1b-ecb4-4bf8-8715-54132a9106e1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e6dded3d-6264-49ee-8f4d-f55735da425b', '当阳市', NULL, NULL, 1780, '3760382f-ecb5-4ef6-8bd2-049afe34b574', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e6dfd7a2-a544-49be-a790-507634f50ab6', '天和乡', NULL, NULL, 3274, 'a39ced08-b6e9-4de0-a2db-7a230a673d1e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e6e946a5-6b40-4a00-b4e9-5c5521e368da', '南通经济技术开发区', NULL, NULL, 1752, '7de09763-759b-437b-a3aa-4cb32bd3c6b9',
        1, 'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e6ee08e9-179a-40de-abd2-c582eb6fa3a3', '乾县', NULL, NULL, 2111, 'e42fbad8-c29e-4f35-878d-95a667b5cc90', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e6f8f7ea-fd3f-4b81-8a3c-2fc521083a56', '北苑街道', NULL, NULL, 2123, '88d84710-80d6-4837-b889-286c74d7940d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e703822d-ecb9-44ac-b801-15617b399eaf', '宿城区', NULL, NULL, 4187, '2263db14-1626-4430-a8ea-bc9c02268004', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e70b3b22-6c72-4be7-bfd9-e7cb5c050fc3', '玉环县', NULL, NULL, 3294, 'de41020d-a8dc-44d0-a2d4-75b6076c0ae8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e7134b9d-e3fd-4dd7-bf5e-7fdf323504d2', '西流河镇', NULL, NULL, 3465, 'ea11feaf-194c-4cec-be59-d17bac402db4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e717d6ae-80e6-48ba-b94b-2d8662a6b9ac', '曲松县', NULL, NULL, 1017, 'f7038861-43d2-49c3-a5c9-53fde2c139fa', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e71a7511-9624-49c8-baaf-1ed00976372b', '连州市', NULL, NULL, 2951, '8377f1cd-7272-4396-b99b-84bb707dbc2c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e74673f6-7412-4b60-8bca-180150bb0db2', '陈家桥镇', NULL, NULL, 3899, '7fefd2bf-99e0-43f5-bc37-9ab15ee8e8f3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e748c531-6fc2-4d98-82f1-913ec48a65aa', '尤溪县', NULL, NULL, 277, 'cae0a47d-0d79-4fa6-aac9-e8b3b535ee3c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e778669b-85f6-4176-9c9d-eb52ebb5cf67', '丘北县', NULL, NULL, 2226, 'fadbb851-aec5-4d3e-be0e-09e7462eaceb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e77cf137-e1c1-4d3f-98d0-4e3c527298cb', '汪清县', NULL, NULL, 1056, '87e1c9be-7455-45a9-ace5-641efce55e22', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e77d4c3c-b5ae-4557-be6d-cd1e20175c1f', '永康市', NULL, NULL, 230, '1721f4b0-56cf-4408-a217-62416951c176', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e77fb428-c773-4a6e-aa14-84b79b035ca5', '中峰镇', NULL, NULL, 3671, '6581d8db-553e-4417-8c37-91ed47904920', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e792ccea-cdb7-4eba-9690-150e2cf6cf0d', '鹤山县', NULL, NULL, 3440, '2130bd75-b4cf-44af-a13b-2b64109f0cb9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e7ac8368-d00a-4686-af6c-0a5ef0dc9449', '长宁县', NULL, NULL, 1820, '18a8dd20-aad4-43cd-ab48-ab6108097d8a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e7ad6df3-b1b4-409e-8c06-174aad96446a', '博爱县', NULL, NULL, 4014, 'e95972c4-fd28-45ac-b9da-9aee0057d3d0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e7b80046-2a32-422d-862f-a40733357bd3', '陈家镇', NULL, NULL, 3980, 'fcc07455-c69c-4c90-82cb-ddb268adb8a9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e7c3bd9e-d4b2-44cd-af62-220277029af4', '临江镇', NULL, NULL, 406, '9d7d52af-ec34-48e3-b81d-09ac51e11590', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e7d563a0-8ee4-440b-9357-59978eec87ef', '德格县', NULL, NULL, 3774, 'c262a40d-a147-4930-b33b-574ec51fa884', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e7dca550-e8e4-4a0f-9c3b-2a0ec3aca351', '宁厂镇', NULL, NULL, 1579, 'ac0e6e50-b6a1-457c-811c-06ac309cd5a3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e7f01c5b-e304-4222-83a8-3314677cc744', '历城区', NULL, NULL, 4352, 'c6ac73d4-9854-403a-9b61-12c22eeb4903', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e81dd468-2ed3-48ac-89ef-026f45eb58e2', '新津乡', NULL, NULL, 199, '4f867632-2989-4def-9934-a9c5fe0d5ca5', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e8334c71-bb4f-4c7e-af18-e0eb70c9c845', '武陟县', NULL, NULL, 4013, 'e95972c4-fd28-45ac-b9da-9aee0057d3d0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e858ba9f-f4ae-41f5-b12c-4e4e538f16b6', '鸡冠区', NULL, NULL, 2415, 'f583e1ae-7239-4815-b3c7-c5538eb73da9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e866af2f-de18-4d29-92fa-143e66248e03', '德钦县', NULL, NULL, 2847, '931058d3-f668-41c4-94a8-7a763997d1df', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e86c5da5-679b-472c-ac4c-d7d930a0b52e', '青冈县', NULL, NULL, 3560, 'fcd4a18f-a57a-47c4-b2f2-504bc8bccb20', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e8838382-74d7-451e-bb3e-ce9b76b044ad', '东西湖区', NULL, NULL, 431, 'e6e46871-d5a0-4d2b-8243-9d4bd864ab43', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e8847e84-4b7a-49d9-93e9-8748be5e4def', '新田镇', NULL, NULL, 4221, '0ee28cef-8dfc-4a9f-b7c1-330bc11c1bb3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e8af8b85-8903-47c9-8ba9-b097b47c097a', '兴国县', NULL, NULL, 1612, 'dd4a8577-afbe-449b-ae9b-be374a4c7434', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e8e3ef13-5ccb-42f9-8e21-f1f5e16b615a', '桥西区', NULL, NULL, 145, '37614653-bf6c-458f-a844-540790491eb1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e8f31a55-118c-4b44-bf41-56b160d5dd7f', '范县', NULL, NULL, 1260, 'e16eafe9-9ca0-4609-8c8c-a1b16b52669f', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e8f8f81e-1a4e-46e6-b736-34851c734fe2', '城区', NULL, NULL, 4019, 'f6eb800d-2093-4ce2-8105-3747d69abe97', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e91c8456-8822-4063-b1c7-862150ed3bb1', '康巴什新区', NULL, NULL, 3537, 'eb551697-7acc-4bcd-9d21-3d48c16f8258', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e944b164-c8ad-41fa-9edf-aeb351b1c305', '柯城区', NULL, NULL, 2813, 'b2a03fc9-88f2-4734-9af2-7234863d0f87', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e946658a-8d84-4481-a9b7-560e5c96351a', '建华区', NULL, NULL, 2725, 'f4e36f9a-e006-44a6-8d77-47971d41810b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e96aedb6-efb1-4bb6-b807-d3b45a6a75b4', '双河乡', NULL, NULL, 2398, '0275a9ca-e89b-4217-b3b0-ada824d9e095', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e970bed4-39ad-4dea-8d6c-3e32cfc8a179', '颍东区', NULL, NULL, 1630, '6de68814-d6ea-430e-88b6-bf98620aa604', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e972dffe-a2eb-4caf-bd09-b090cf679d40', '东辽县', NULL, NULL, 4, '7845d9d9-ca44-43a0-93d5-602fdb04ef55', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e975b2e7-f16f-4dc2-839f-51d3589758c5', '洛碛镇', NULL, NULL, 710, '97942649-3cc7-4e4a-81b4-9a8c82f82ea7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e97baa8d-8c44-4371-843e-0209c8604ae7', '宜川县', NULL, NULL, 3399, 'f95958de-a678-4371-9710-6bcac3f425fa', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e988a788-e664-4df5-b22d-abd0df7ac068', '囊谦县', NULL, NULL, 2072, '27eaf8ae-634a-45eb-bdc9-207c699d16ef', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e99aeec6-f87c-40d6-b7aa-3fa16d15a717', '郁南县', NULL, NULL, 265, '34138fe1-593f-4c44-87ac-1beaee74bafb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e9b13b1d-fee6-4154-b39f-84afdb74e6d1', '川沙新镇', NULL, NULL, 2622, '4683d3ef-0edf-425a-98d5-2cb231a7d88a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e9c1783e-49a2-4f8b-852a-a9e1bc3c4412', '固阳县', NULL, NULL, 2048, 'd4910db5-a704-4273-bd13-a6dc05f468cf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e9d87b43-5e95-4ba2-9faf-73f3aa4a05a3', '叉河镇', NULL, NULL, 781, 'af6f4f65-b2db-4670-88ca-21de1de477fc', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e9da54d3-f403-464c-a947-70c8cf526a76', '钢城区', NULL, NULL, 1774, '6e4850af-4247-4791-b0c5-d6d55ebc74b2', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e9e894b4-499e-4782-8b53-f98e4a896fe9', '东路农场', NULL, NULL, 3820, '96fec37f-11d5-4d41-aba4-a36d0652744c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e9f7099d-e082-4a47-b0a5-c06740d9ac08', '田家乡', NULL, NULL, 575, '8ae99c85-66b1-406b-8084-9f77cbf73b10', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('e9f777cf-490b-4995-aa22-0c5110b54911', '金川县', NULL, NULL, 1188, 'd56c2ee6-b81c-4df8-ba2f-3df7680243c4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ea1627c3-09fb-46d3-b19b-301b3259bf61', '石龙乡', NULL, NULL, 1146, '72d4f69f-2e4c-4bde-9df8-2aadc9168686', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ea2c8071-df23-4c17-a4af-ab8845819f16', '义安区', NULL, NULL, 2535, '574f476d-e1ab-4240-a84f-b9671a2cb9cc', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ea2e9020-d850-4883-831b-7cc5358315b6', '皂市镇', NULL, NULL, 2157, '671275c4-6107-4968-bd8e-96d53e9995b2', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ea305f75-86e0-4a5a-9d53-9b25b926b45a', '广昌县', NULL, NULL, 3957, '1e0a806c-ad0b-4e9f-a488-8bf9fc903f4d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ea577297-2bc9-4e08-96ca-72d5307ea709', '山阳区', NULL, NULL, 4015, 'e95972c4-fd28-45ac-b9da-9aee0057d3d0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ea729fe5-0b11-4450-9143-f44d9c83eed3', '鄂托克旗', NULL, NULL, 3534, 'eb551697-7acc-4bcd-9d21-3d48c16f8258', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ea7e9e58-c390-4f76-ac3d-22f299b37137', '会昌县', NULL, NULL, 1621, 'dd4a8577-afbe-449b-ae9b-be374a4c7434', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ea9d80c3-ece8-4819-929f-e12b6224efc5', '霸王岭林场', NULL, NULL, 789, 'af6f4f65-b2db-4670-88ca-21de1de477fc', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('eaafaacf-69b5-42be-934f-0aa9a525798c', '新龙县', NULL, NULL, 3773, 'c262a40d-a147-4930-b33b-574ec51fa884', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('eac9f9cf-dacb-4636-ab01-30c9b449b16a', '丁市镇', NULL, NULL, 2916, '465e9ea2-a2f2-4b42-95dd-b48d91f67105', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('eaf2fd3f-4372-428b-9e23-9fa0e938d46b', '溶溪镇', NULL, NULL, 974, 'cc124ed6-091a-42ce-a87a-bb4d0d7357b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('eaf86604-2ff5-4160-a10b-f38d92253da9', '拜城县', NULL, NULL, 4399, 'b7bc3a10-ad00-4b20-9fa4-cb08ad7492d3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('eb0fce4d-7ccf-4086-a0f9-31c9b9c7a000', '东源县', NULL, NULL, 1726, 'a9736c65-aeba-4a39-861f-5edf105d8673', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('eb2e4f64-5bae-4107-99c3-b677be056aed', '南法信地区', NULL, NULL, 3734, 'd1c1539c-b904-4bcc-a034-96213f63d0ff', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('eb52076d-67be-492d-bd01-a16912788efe', '台山市', NULL, NULL, 3306, '2a61b8e3-4156-42df-836b-fc855d156f23', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('eb55c19e-15b8-478c-ab39-503878d54aeb', '新城区', NULL, NULL, 4286, '29595f0b-301d-42da-845d-01afb30a9c18', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('eb5838bf-26bf-4588-8606-5167a0b99378', '葵青区', NULL, NULL, 482, 'dfb8b556-10a2-43ab-9fdb-66cde92320ee', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('eb710315-a821-4b4f-939e-03ed22ace20e', '建湖县', NULL, NULL, 4366, 'b85d2a61-b018-431a-9609-2ca0841f5cab', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('eb7514e0-ef24-4575-b53f-3cb152b94da0', '金湾区', NULL, NULL, 1430, '258231ca-ed61-443c-873c-5d5b85483ac0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('eb7575c4-a7c5-444e-b2aa-6ac60305cf22', '万年县', NULL, NULL, 502, '8bf55045-9366-4acb-b884-bca672ff9644', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('eb7755da-d34f-42a5-9315-87def9db42f0', '榆中县', NULL, NULL, 4046, '2d364b6d-2931-4d45-995a-336e4e0f2b55', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('eb85159d-bd2a-4277-8393-8b9e4573ba7a', '胡市镇', NULL, NULL, 2158, '671275c4-6107-4968-bd8e-96d53e9995b2', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('eb9d591c-ec69-41d9-bb08-64233c527587', '静观镇', NULL, NULL, 2330, '671d3a34-71bf-42c5-8dda-a813f5ecba22', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('eb9e0a7a-b6c5-4c28-b1a4-ef06716cff2b', '县城内', NULL, NULL, 1575, 'ac0e6e50-b6a1-457c-811c-06ac309cd5a3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('eba05e19-7a1e-4ffa-8627-eae36705b787', '河津市', NULL, NULL, 4103, 'fc30b5e5-3005-4778-94f7-706b31514bff', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ebbe2501-c86e-423a-b79d-fdaf558a5d99', '山亭区', NULL, NULL, 1412, '8e4df698-c772-488a-acf8-70e7d4adebd2', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ebbf0596-4d4d-4f92-bd10-0e327028e795', '崇仁县', NULL, NULL, 3955, '1e0a806c-ad0b-4e9f-a488-8bf9fc903f4d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ebc1ff87-6ca1-442c-9166-779e1fd68f89', '贡嘎县', NULL, NULL, 1012, 'f7038861-43d2-49c3-a5c9-53fde2c139fa', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ebc5dba9-c61c-4dc7-971e-07d4028b7f9e', '西乡塘区', NULL, NULL, 2805, 'b53ced47-2455-44ec-b740-7637148f574c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ebc7ad75-449c-4d65-a644-7bd9d9288813', '濉溪县', NULL, NULL, 2247, '8afb487f-de86-4a5b-9abc-27ae2c07797d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ebe66277-346b-4d0b-a09d-f76c13422db3', '丰盛镇', NULL, NULL, 43, '43c813e3-8672-45c5-8d3e-9ee43dbe51c8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ebe79435-6817-4e11-964b-8853b3f08b26', '镶黄旗', NULL, NULL, 2349, '67723aea-a4ef-4eb7-afbf-55cc07806f98', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ebe94376-cc4d-488e-a843-a00063addcf0', '永善县', NULL, NULL, 3685, '31187fc0-8d6e-45f3-9653-b7ce4227ef1d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ebf49675-6a40-431f-99f4-4fd68ff8d7ba', '武义县', NULL, NULL, 226, '1721f4b0-56cf-4408-a217-62416951c176', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ec310928-9bd2-4ae9-9163-7b9231fe4fad', '陈巴尔虎旗', NULL, NULL, 1064, 'c31a65eb-4d77-4b38-8142-9c9e2f54ed46', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ec3ad622-4f6e-4f8a-ba93-fd7bfb796c15', '博厚镇', NULL, NULL, 719, '0be5e1cb-cdb0-48ca-9f82-47f7f4c6dd2e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ec4967d0-ca4e-41f0-9560-41966833e7a6', '黑山县', NULL, NULL, 1077, '99f84690-670c-4a0e-ade1-ebcf17b00adb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ec53a2e6-5751-4e05-bc3e-c8929efbc5c0', '黄鹤乡', NULL, NULL, 810, '0f559985-f6fe-4a8f-af80-3d0d64932dbc', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ec671284-4a7b-4d91-81ba-bc6302d8eeaf', '南部县', NULL, NULL, 1251, '71643995-698f-4bdf-afe9-09fce8a065c0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ec7e304a-d599-4718-9210-95e63e0b0aaa', '乌伊岭区', NULL, NULL, 468, '7ca3412f-b06b-467e-b547-691ab8327b15', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ec9e1488-3916-42ae-9b93-73af47d243fb', '那坡县', NULL, NULL, 1227, 'f56fa64d-ca06-49d2-a9cb-94742a33af21', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ecb3a20e-659d-400b-be05-1c7b9cf0ced7', '集贤县', NULL, NULL, 2253, '69696549-d65b-4e13-80ef-05ecaf0f61e3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ecb3f837-8844-43ea-92c8-b8b40d8a7eb2', '晴隆县', NULL, NULL, 3108, '875ed189-3d32-4466-a24f-7cbac524774e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ecca4c4c-855c-4001-a56a-fcd3b6dc5dc4', '弹子镇', NULL, NULL, 4204, '0ee28cef-8dfc-4a9f-b7c1-330bc11c1bb3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('eccce723-d92e-468b-8bbb-7e42e6ba4520', '清水县', NULL, NULL, 3115, 'b31f9073-6d76-4083-b00f-cc23550ef59a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ecd00250-cce8-419d-90bc-3601c7d46d09', '海盐市', NULL, NULL, 4411, '0118b1e4-bae7-4459-94b9-db6947b14aba', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ecdc2e8f-f6d1-4851-9e74-c5c4eafb7b99', '岭东区', NULL, NULL, 2250, '69696549-d65b-4e13-80ef-05ecaf0f61e3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ecdf1feb-a534-44bf-97bd-e157a1931197', '沧沟乡', NULL, NULL, 4456, '4888e1e9-ba45-4254-83e7-87796f338e2d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ed036e91-5d44-4677-b187-d71b7f62b214', '井口镇', NULL, NULL, 3907, '7fefd2bf-99e0-43f5-bc37-9ab15ee8e8f3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ed066159-12dd-4168-86d3-4fdd52f63a70', '源城区', NULL, NULL, 1725, 'a9736c65-aeba-4a39-861f-5edf105d8673', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ed083643-fcaa-44a0-a09f-bc916d989fe7', '郫县', NULL, NULL, 1814, '4f073365-4e02-459f-8b32-cad88dd22637', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ed123439-1346-429c-9b1c-fbaa292b8924', '华亭镇', NULL, NULL, 1320, '99c50aa3-ab40-4b1e-addd-f68662f3c560', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ed1416ec-25aa-4bc6-bd04-c7d5d4ab1232', '高新区', NULL, NULL, 4350, 'c6ac73d4-9854-403a-9b61-12c22eeb4903', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ed2beec9-bcd7-43e3-85d6-ca0baf91756d', '奈曼旗', NULL, NULL, 1556, '1dc7d092-717c-424e-a473-bb2cc8836b5e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ed2c4f9b-77de-4729-83e4-afec4037c6d0', '江口镇', NULL, NULL, 171, '4f867632-2989-4def-9934-a9c5fe0d5ca5', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ed2f2e06-95a2-4db9-af8a-1794b2567711', '嵊泗县', NULL, NULL, 1291, '02033c55-d6b3-4a85-91e0-b68d170d3383', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ed2f8d08-c132-471e-8a44-a5ff06ad18d9', '许昌县', NULL, NULL, 3566, 'c2e61b39-2188-4b9c-a36f-ef7b600b0188', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ed37b3ad-9202-4494-81d5-cfa748612ebc', '张港镇', NULL, NULL, 2142, '671275c4-6107-4968-bd8e-96d53e9995b2', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('edc8a605-db0d-49b0-b53a-b967ac5995e3', '库车县', NULL, NULL, 4401, 'b7bc3a10-ad00-4b20-9fa4-cb08ad7492d3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('edcd19b7-0742-45db-ab07-bf836b84403c', '下城区', NULL, NULL, 2306, 'f530455e-1c70-47dd-9a80-4bc74a4e2680', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('edcdb238-8f25-4484-8230-e5fae6582eb4', '合江县', NULL, NULL, 581, '78000393-73bd-4a54-a688-5db0e578d9cd', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('edd67969-a754-44a7-a85e-e024af30b3f9', '千山区', NULL, NULL, 2015, '48832e11-ddfb-478a-9787-e46c47346d7e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('edec0eb2-85ef-4b27-915d-1decc68b633a', '石板镇', NULL, NULL, 3545, '99107e35-f7d9-4c45-8d21-7a03b9c2f99d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ee1c2bf7-4e38-483f-86f1-95c5b927f027', '邳州市', NULL, NULL, 4425, 'e20441c5-c8b4-493a-9738-2327e656fbcb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ee285fe1-0864-4f5b-8982-e98414774d15', '石楼县', NULL, NULL, 3418, '9348509b-6d82-47e7-86d7-f054fb47b7fe', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ee34e87c-82b7-4824-97e7-6a1790a023b0', '曲周县', NULL, NULL, 212, '237eff18-fe6c-4842-afb1-acb05027a5c1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ee3a2645-0258-4993-9287-b3a1bde1d50c', '墨脱县', NULL, NULL, 2580, '23ca0ede-0d68-4451-afde-afd774149ec4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ee484a41-58f8-4f27-8b67-67fc38f4d033', '元宝区', NULL, NULL, 2794, 'c0064cbf-ba5c-4dc0-a855-b330e096cd61', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ee48b8e7-0077-46ff-99ce-8b657d26147a', '莎车县', NULL, NULL, 2042, 'e6436d79-8045-4185-b2b2-22cd280d22b0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ee4aa318-5af3-429f-a993-d683b8f4ea8a', '华坪县', NULL, NULL, 3302, '533981ab-21f3-46b9-91a4-320129bd0b49', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ee5583c6-6480-460e-b376-b486bc534846', '头苑镇', NULL, NULL, 3816, '96fec37f-11d5-4d41-aba4-a36d0652744c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ee5b347c-ca80-498c-90ba-5d4c95e7e4f0', '九真镇', NULL, NULL, 2156, '671275c4-6107-4968-bd8e-96d53e9995b2', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ee5f7296-327d-4b33-85ea-b6723df81777', '唐县', NULL, NULL, 2489, '81e22d56-a1c7-4263-be18-81a4af165ae3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ee6da599-f804-43bf-84fd-e9e75ce0d74e', '永修县', NULL, NULL, 113, 'bcaf1f36-5459-4e74-81d1-5026680b1a9c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ee773efa-94d7-4120-9f0a-addefb299aa1', '五龙口镇', NULL, NULL, 3919, '22f622f8-7eaf-41e9-90ee-2a0cfda1f326', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ee7a86a9-779a-4acb-a610-8f8c49aeb9a5', '汪场镇', NULL, NULL, 2144, '671275c4-6107-4968-bd8e-96d53e9995b2', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ee7d26c3-6f8f-4aeb-8e31-695c8f37b75f', '舒兰市', NULL, NULL, 1950, 'a4031322-7fba-466a-ba72-50082ab248c6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ee8d7eb6-6b8d-4cdf-9183-f59ebda0b79d', '明光市', NULL, NULL, 859, '1a27a18f-784d-4314-bd00-8add932005d6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ee9ffac5-6cb9-45fa-8314-1b2d91de60fd', '灌云县', NULL, NULL, 1634, 'bea9983e-fee5-44d8-9884-18c75d7d052d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('eea46d28-f01e-48d9-b879-e41821a84c3d', '德城区', NULL, NULL, 4166, '9c8b6d83-dd06-4238-b7f4-c0ad532e5b6e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('eeae129d-c8b8-4136-914f-5ef20d5cc86c', '南湖区', NULL, NULL, 4408, '0118b1e4-bae7-4459-94b9-db6947b14aba', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('eec49e3a-d6eb-459c-93da-011574b825fa', '浈江区', NULL, NULL, 1519, '754500f9-7ec4-4379-8b1c-9370f50564c0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('eec75d0e-5c1c-496a-ac10-4663bf05e29e', '新盈镇', NULL, NULL, 724, '0be5e1cb-cdb0-48ca-9f82-47f7f4c6dd2e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('eececc3a-f4c2-457a-80b1-97434b936a26', '和乐镇', NULL, NULL, 4484, 'f491d9c3-9527-46a4-8954-6795ff079478', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('eed67e2b-f10c-4409-9ab5-7610109fa75f', '内环以内', NULL, NULL, 1713, '86ab4d11-9653-4b0d-8cc1-2e12a4de15d6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('eee2c506-a16a-4bd0-be0c-7d3b7fbf35fe', '泗水县', NULL, NULL, 2823, '5c8748b9-cee3-4d8e-956c-0d0e24db8850', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ef056dea-8193-411a-8b9f-4cc2af8cf98b', '红河县', NULL, NULL, 3152, '99a9abd1-f107-4dc6-ae43-e9d1120504b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ef14f83d-ace6-4746-a282-0e8d211fd1c8', '灞桥区', NULL, NULL, 4290, '29595f0b-301d-42da-845d-01afb30a9c18', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ef18862e-efec-4edd-bef6-fce91eba880e', '四子王旗', NULL, NULL, 3966, 'a061ae4e-1b4e-4b42-8aa9-cc6bbae9619a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ef1b727b-0563-412f-b90e-c3f146bd0927', '周矶', NULL, NULL, 824, '24ad0708-80a9-43b1-8e1c-758f2492d3f6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ef29e3c4-ea04-4d6e-9bf9-cc92adc838d5', '船山区', NULL, NULL, 3022, '44b40fc1-5bf4-476c-b869-580342d65c02', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ef377192-0829-429b-baf6-68fa85d4e313', '祝桥镇', NULL, NULL, 2623, '4683d3ef-0edf-425a-98d5-2cb231a7d88a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ef3ca36b-f93f-48dd-85ed-bb295deccd7d', '南华县', NULL, NULL, 2092, '50868d97-8741-48fe-9cba-86e2e118f220', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ef4d90ca-5f46-4ac3-83aa-68747e20deac', '霸州市', NULL, NULL, 1240, '86f7f02d-658e-44ec-9d36-b14cc3c65aaf', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ef4e81f4-1020-41d3-8057-ec1d6c9142d5', '易县', NULL, NULL, 2494, '81e22d56-a1c7-4263-be18-81a4af165ae3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ef50acfc-1ff8-4e9c-94c5-756bdea06ef5', '兴化市', NULL, NULL, 2231, '0541b99e-02a6-415b-8282-4ef9d27cb647', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ef54a49b-df94-4b52-8c86-1ff07c4a8f4d', '中站区', NULL, NULL, 4018, 'e95972c4-fd28-45ac-b9da-9aee0057d3d0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ef67e5f3-dffb-4f0b-a6a7-7a2dae80cdc4', '景洪市', NULL, NULL, 2006, '69f08469-ecd2-4a94-a921-da836fbf5838', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ef69960d-544b-4fd2-91f3-46d1c95204d3', '玉田县', NULL, NULL, 2460, '4f4c1ef4-f54d-4ba4-a124-ca2d3d0ddb78', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ef77209d-0e85-424d-a79b-5766a4bea43f', '城区', NULL, NULL, 4200, '0ee28cef-8dfc-4a9f-b7c1-330bc11c1bb3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ef930d7d-6ffe-4708-bdaf-1cb876634497', '环县', NULL, NULL, 1770, '61cc258d-1868-4356-bcbc-2e8b118745ca', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ef95a0c3-1128-4a5d-a7c4-1d5970cb686f', '钟多镇', NULL, NULL, 2912, '465e9ea2-a2f2-4b42-95dd-b48d91f67105', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('ef9ad0bb-7a8c-4069-849c-4796d5ef53be', '城区', NULL, NULL, 2621, '4683d3ef-0edf-425a-98d5-2cb231a7d88a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('efa8f33e-1940-4bba-bc91-44a421d3af0d', '德保县', NULL, NULL, 1224, 'f56fa64d-ca06-49d2-a9cb-94742a33af21', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('efae6048-b91a-4f1a-92c6-8327142bcb0a', '祁县', NULL, NULL, 522, '84a16421-f7fb-4f99-b2c0-1e0dea97bf0b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f0250730-e0e0-41ac-a77e-8f5acb7df820', '新会区', NULL, NULL, 3307, '2a61b8e3-4156-42df-836b-fc855d156f23', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f02f4f5c-8264-45bf-9692-b3d8da9d4e63', '金山屯区', NULL, NULL, 463, '7ca3412f-b06b-467e-b547-691ab8327b15', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f0374a9f-f85a-4ab9-bc04-534c063f112a', '谯城区', NULL, NULL, 1979, '9c7fcb3f-9d15-445a-944f-d2231a75f23d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f0477a5e-e781-4c69-9685-835f3ba91f63', '巩留县', NULL, NULL, 2592, 'e6f53877-d5bf-4b42-aded-5ab8960ef034', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f04fdd92-49d8-4f65-9550-b12699aa8d2b', '昭觉县', NULL, NULL, 3514, 'c8f594a3-8acc-48a9-ba2f-e76934de05eb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f055e188-a60d-440a-a00a-151d5cc1a1a4', '龙泉镇', NULL, NULL, 3570, '5d21af6a-f035-42f4-a0cf-ff1fd3d36f3b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f0655c84-8619-423e-a09b-0418c3b53de5', '水满乡', NULL, NULL, 16, 'c8bf9a67-2bfc-47fe-9580-3f2f2eac1edb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f06d13d8-8fd7-4fdc-a1f1-78953949bb4b', '龙口市', NULL, NULL, 591, 'f3717726-7743-4838-852b-3a09f9528a69', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f073ffe4-5351-4035-a363-355c69af0aa6', '思礼镇', NULL, NULL, 3923, '22f622f8-7eaf-41e9-90ee-2a0cfda1f326', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f080e827-b74c-4c9d-b1db-9cb4c3e5344b', '兰陵县', NULL, NULL, 4338, '56327d0b-ec26-4f34-8ab6-0eba49931c67', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f09a407d-d84f-4bea-b856-72b5411e3771', '安溪县', NULL, NULL, 1856, '0d3bd52a-74b2-4461-9a57-17c7cce4ac1b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f0afd14e-db3d-4f77-82b9-37dc28ae03cf', '成华区', NULL, NULL, 1797, '4f073365-4e02-459f-8b32-cad88dd22637', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f0dee24d-9cfc-409d-adbb-133615ebe6d6', '城区以内', NULL, NULL, 4436, '16769cc8-c7bd-49cd-8e76-bcb74327f133', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f0e4130e-cb7d-43c4-9717-a3683e808a90', '元氏县', NULL, NULL, 2781, '334645de-ae54-416a-8978-2dbf9f7bbd09', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f0f2376d-28e7-40b8-adc0-dcb43dcdf19b', '县城内', NULL, NULL, 2654, 'e509a1a5-95da-4fb2-9a2b-f84afa05a36c', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f12dc83e-9825-4006-b04e-b3c7a1f3e955', '乃东县', NULL, NULL, 1014, 'f7038861-43d2-49c3-a5c9-53fde2c139fa', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f1500c40-d8e8-4171-b8bb-64567bd9bb9e', '左权县', NULL, NULL, 523, '84a16421-f7fb-4f99-b2c0-1e0dea97bf0b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f155359d-a316-4d89-87a6-01a77c64bbcb', '水富县', NULL, NULL, 3689, '31187fc0-8d6e-45f3-9653-b7ce4227ef1d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f1593895-83a4-47dd-b4c0-caf92b6ecbc6', '大丰区', NULL, NULL, 4365, 'b85d2a61-b018-431a-9609-2ca0841f5cab', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f16e9932-06c7-471a-a877-28afd250f44b', '平乐县', NULL, NULL, 3192, '796bb0e0-6b76-4c1d-801f-2dbcbab74087', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f18440dc-b01a-4c0f-a347-2f95339889b5', '三环到四环之间', NULL, NULL, 4381, '27537995-4520-4156-95b5-b3d1e368a5dc', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f18fa8d4-4623-43fb-ab9d-0bf419e9b6e8', '灯塔市', NULL, NULL, 4162, 'f856399f-e403-4734-abb9-b972db76c06b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f19f8350-662b-4e75-879f-44d51d7fb644', '西联农场', NULL, NULL, 3219, '2e21ea75-c640-4928-8cb4-e5ba4f6e2ffe', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f1b44273-44b3-4ce8-b8c5-2b263fa504db', '斋堂镇', NULL, NULL, 3578, '5d21af6a-f035-42f4-a0cf-ff1fd3d36f3b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f1be2cdd-c1f5-4496-87d9-6580491a17b9', '富宁县', NULL, NULL, 2224, 'fadbb851-aec5-4d3e-be0e-09e7462eaceb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f1d2e25f-d699-48d0-88d6-6ca7673f2c68', '孟津县', NULL, NULL, 1172, 'b5a118ad-786c-4d86-b4e8-5d25a3776a78', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f1d44e31-d20e-4fee-bb74-780224c71ad1', '加茂镇', NULL, NULL, 2993, '4b3478d4-3e85-4143-bc6f-ac4a338a9d47', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f1ee4bcc-9ba5-4d19-98ec-3133e82ea66a', '庙垭乡', NULL, NULL, 4463, '4888e1e9-ba45-4254-83e7-87796f338e2d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f207898c-8cf3-45c7-86f5-07253b0b9445', '隆林县', NULL, NULL, 1228, 'f56fa64d-ca06-49d2-a9cb-94742a33af21', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f210b528-3c87-4a91-b88b-531446951a67', '顺昌县', NULL, NULL, 3447, 'dd15d032-477c-4f54-9629-ea782606b468', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f2111980-7f0a-4f26-bb9d-37b869fe375a', '夏河县', NULL, NULL, 3128, '9d7c5001-b115-4bea-abb4-a289a03b5075', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f21142fe-2f76-4049-8e9b-dd2d89a676ec', '平安乡', NULL, NULL, 1896, '2c8bc8c3-9317-4f36-a0ad-05a8d6b27053', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f21a7cc4-4851-4353-b101-82f5764b4b90', '岭门农场', NULL, NULL, 542, 'b75db043-9782-4bae-aaee-bea49fc286e6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f23f3081-f8e8-4f0f-a8d6-12c42d114314', '五环到六环之间', NULL, NULL, 1702, '576c43af-0a86-47d9-83a7-4989ce3b3dc7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f2458c8c-76ac-4a35-9368-e31edc4ed577', '鱼嘴镇', NULL, NULL, 1717, '86ab4d11-9653-4b0d-8cc1-2e12a4de15d6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f2482962-88cf-45f3-abdb-a24447490ded', '东兰县', NULL, NULL, 1160, '509d3498-d5ba-4378-8bee-0baf015c2a11', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f2486dbc-0c07-4a71-a626-4b3ea5a11c7e', '定边县', NULL, NULL, 1303, 'c0c88cbd-87ea-4281-9e8e-94a435ae6590', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f26185d4-330b-4558-ac2b-b3fa01f93bd7', '都督乡', NULL, NULL, 1937, '442f465d-6566-45e4-9338-50f4395aa6f7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f2681f4e-65a5-4614-9905-789f7c6ba2f1', '六连林场', NULL, NULL, 4494, 'f491d9c3-9527-46a4-8954-6795ff079478', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f26c5adc-f8b9-40d5-9d8e-e6b81bf0e3fc', '达孜县', NULL, NULL, 4157, '5a657ab2-3d76-4a46-917c-ddfe22c60d16', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f26d92e4-54ad-4aaf-bf12-85cda13e42b9', '龚滩镇', NULL, NULL, 2918, '465e9ea2-a2f2-4b42-95dd-b48d91f67105', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f26dca8e-fea8-4d03-bbc9-51501104a760', '五间镇', NULL, NULL, 414, '9d7d52af-ec34-48e3-b81d-09ac51e11590', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f281880c-b2b6-4f2e-b144-e76e934bb3bc', '临桂县', NULL, NULL, 3189, '796bb0e0-6b76-4c1d-801f-2dbcbab74087', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f2a6ed4c-c694-4440-a7b7-8d16e06c8430', '西岗区', NULL, NULL, 4051, 'd83aabcc-3c2e-4b48-962a-c548442bc896', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f2a80905-96c5-4c01-b017-7587d0580222', '后安镇', NULL, NULL, 4485, 'f491d9c3-9527-46a4-8954-6795ff079478', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f2aa085d-68e2-41e3-82c0-70baddf1556d', '秀屿区', NULL, NULL, 8, '7acdab30-849a-4c32-b081-8cbdc15f711a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f2c50465-9703-4a4d-aebf-36d6c775833d', '城区', NULL, NULL, 1110, '72d4f69f-2e4c-4bde-9df8-2aadc9168686', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f2c9e869-09d5-49e0-a9f0-98074248ecc1', '遵化市', NULL, NULL, 2456, '4f4c1ef4-f54d-4ba4-a124-ca2d3d0ddb78', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f2cd81ba-b917-4f47-8cc1-5e918f1299b0', '沔城镇', NULL, NULL, 3471, 'ea11feaf-194c-4cec-be59-d17bac402db4', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f2dea3da-bc42-4ad1-99b6-ecdafab09c4d', '东洲区', NULL, NULL, 1377, '6b5fed36-b200-40ca-af0b-11999b4399ef', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f2e64cb2-0ca2-4569-864b-108749d4fea0', '水田乡', NULL, NULL, 3378, 'aa2f26e5-9705-4dc0-b54a-a2d7dbb8b511', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f2fe99a6-f4b5-4c20-935b-dd682c332e3d', '经济技术开发区', NULL, NULL, 2603, '5c5b11a0-6a29-4173-b876-8fdbc543cb2b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f306f68d-37db-4d9c-ad66-ec11f3a95a53', '茶山高教园区', NULL, NULL, 260, '86b77e39-331e-4927-9517-49be7b738b9a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f3078efd-4447-4503-80bd-72b4bd8983cd', '北镇市', NULL, NULL, 1076, '99f84690-670c-4a0e-ade1-ebcf17b00adb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f31eafa4-0049-4ca3-a6f0-73da7fa02ad1', '官渡区', NULL, NULL, 2858, 'd7efec13-7e84-436d-8390-41868af0e359', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f3209842-53e1-490c-84b5-6142ade00c48', '阆中市', NULL, NULL, 1250, '71643995-698f-4bdf-afe9-09fce8a065c0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f3219925-387d-4fe5-ac3c-3525d17249b6', '凤翔县', NULL, NULL, 1830, '7c3fbad9-df03-4d15-93a4-695924a2f35d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f3235c34-711a-4259-a2d5-746c36dbd31d', '怀安县', NULL, NULL, 131, '37614653-bf6c-458f-a844-540790491eb1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f32fa8d7-ca51-4a14-af68-f84670e39cf0', '醴陵市', NULL, NULL, 2608, 'cdeda821-2101-44e1-a986-183436199f05', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f3560103-0d78-4475-936c-06ef02a91a4d', '鄄城县', NULL, NULL, 1796, 'e04fe06c-7641-47c7-a125-4d35e1800549', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f35bcd1a-546e-4918-976b-b92f9205884e', '柘荣县', NULL, NULL, 2438, '8300a2db-b893-4d51-a009-89478871edf1', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f35d8c37-fb40-4404-9b54-1ec874928494', '政和县', NULL, NULL, 3449, 'dd15d032-477c-4f54-9629-ea782606b468', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f3688e87-a3b5-4979-8afa-23966fed184e', '保城镇', NULL, NULL, 2991, '4b3478d4-3e85-4143-bc6f-ac4a338a9d47', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f36cedbc-30c4-468e-88f5-e7e2d06cc637', '大埔县', NULL, NULL, 4392, '2aabe025-ea3b-4ce4-885f-9ecf122b3e79', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f36e6779-6565-4f6d-9971-9cb0e277991f', '临邑县', NULL, NULL, 4167, '9c8b6d83-dd06-4238-b7f4-c0ad532e5b6e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f36fa086-7916-4aee-9a28-af1983ca527f', '三环到四环之间', NULL, NULL, 3002, '1e3ed660-6de7-4b3a-a1d2-3ea7e0778e94', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f382be95-5ab5-4c1b-bbb1-a948897d0055', '奎文区', NULL, NULL, 439, '3e54862f-40e4-4b44-b318-6a64b04a9558', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f3841044-9739-48ba-870b-5cb7aa4b0873', '镇宁布依族苗族自治县', NULL, NULL, 3626, 'a70a258d-7c8f-4726-a9ef-e2aa7c6247f9',
        1, 'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f38acb56-7715-4515-b08d-9a1a13161b51', '北湖区', NULL, NULL, 1315, '50d6a2ea-ba0d-4ff5-8b4c-f9d84e79e381', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f3951b06-121d-4700-ad7c-7586a7121e9c', '莲湖区', NULL, NULL, 4292, '29595f0b-301d-42da-845d-01afb30a9c18', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f3b063a5-3562-4878-9107-2a27f9c16665', '虎林市', NULL, NULL, 2417, 'f583e1ae-7239-4815-b3c7-c5538eb73da9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f3c3b8b7-caa9-420d-ad63-ef23a399cfff', '东宁县', NULL, NULL, 1975, '1c2bd9d2-bc08-486e-a5f3-ba5de82c6365', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f3c6cc1c-7306-4ee7-8a6b-77a3068ba029', '清河区', NULL, NULL, 2788, 'def78b05-5d2b-430c-b268-442502dc3ca5', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f3c7ad17-4a25-4081-bad8-46cf52f44865', '绿华镇', NULL, NULL, 3986, 'fcc07455-c69c-4c90-82cb-ddb268adb8a9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f3d2d7b1-dff1-4a68-94af-72a7ec1d213c', '鹅池镇', NULL, NULL, 3360, 'aa2f26e5-9705-4dc0-b54a-a2d7dbb8b511', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f3d81508-833e-473c-9af8-95813e038509', '湄潭县', NULL, NULL, 3433, '69324865-24e8-4abe-a068-a1392c117c0d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f3dab205-0c7d-4646-95e2-57ab87bc8966', '朱家角镇', NULL, NULL, 2546, '89a9c37c-487a-4c32-968c-cf9fefad8151', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f3fcc1e6-29f1-4568-8b1f-95fc895e5c07', '三汇镇', NULL, NULL, 3890, 'a732da28-870c-4d9c-a287-c2c1e3222b59', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f4070ecb-4912-403f-9436-85696c47568c', '正宁县', NULL, NULL, 1772, '61cc258d-1868-4356-bcbc-2e8b118745ca', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f40d3ad5-644a-4b94-8783-9245f35209db', '提蒙乡', NULL, NULL, 553, 'b75db043-9782-4bae-aaee-bea49fc286e6', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f4242d77-13bb-4a83-84ad-91a0cba324d6', '城东区', NULL, NULL, 3867, 'baa2f053-c419-40c1-93fe-68e081b7f229', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f427e832-3f60-4910-a20e-c6967c669cb5', '乌马河区', NULL, NULL, 465, '7ca3412f-b06b-467e-b547-691ab8327b15', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f4302c71-8027-481e-b0b2-f11aa831cf4d', '费县', NULL, NULL, 4343, '56327d0b-ec26-4f34-8ab6-0eba49931c67', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f441d1ad-33b0-4ac7-81c8-8df8dd3b40ba', '陈仓区', NULL, NULL, 1837, '7c3fbad9-df03-4d15-93a4-695924a2f35d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f4519612-694b-47c5-8d45-362151a302d5', '祥云县', NULL, NULL, 238, 'feece7c8-8eeb-494a-8e84-571b6ebcf0d9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f4627eff-aa87-4365-af23-9b7c8e74f445', '空港街道', NULL, NULL, 3727, 'd1c1539c-b904-4bcc-a034-96213f63d0ff', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f480c2dc-8e6c-4ceb-9120-1f6aa2ed812d', '海伦市', NULL, NULL, 3556, 'fcd4a18f-a57a-47c4-b2f2-504bc8bccb20', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f48658e3-d1e2-47b3-b895-b45515a28f70', '王五镇', NULL, NULL, 3212, '2e21ea75-c640-4928-8cb4-e5ba4f6e2ffe', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f4b56afc-6e57-48ef-832b-6a89bf8f4332', '经开区', NULL, NULL, 398, 'efb72ec7-b29f-48d0-a16c-9a33d3938d49', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f4ca4a2c-6673-44ae-a00d-4a0df231df21', '海曙区', NULL, NULL, 1668, 'c5cc1924-02da-4927-982d-54f0b9f70ef8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f4ccade3-6f66-438b-93e7-275f0a4b9858', '三教镇', NULL, NULL, 401, '9d7d52af-ec34-48e3-b81d-09ac51e11590', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f4d94a19-ea51-40fe-98f8-ff563a7cdecd', '潘集区', NULL, NULL, 2965, '69508f5e-7304-4092-95a4-73d6a9b68eff', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f4e16466-369d-401e-aad6-ea6f246a3248', '黑水镇', NULL, NULL, 2919, '465e9ea2-a2f2-4b42-95dd-b48d91f67105', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f4e8026a-b914-4a90-9649-cb3a8f9e6667', '雨花台区', NULL, NULL, 1871, 'adb7aa6e-99a6-453f-a2db-21ecfbc44874', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f4f3a630-d54e-4d6d-b162-ce6cbb4961bd', '临城镇', NULL, NULL, 716, '0be5e1cb-cdb0-48ca-9f82-47f7f4c6dd2e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f524c1f4-4ad9-4436-8c6a-49816cb29792', '修齐镇', NULL, NULL, 2386, '0275a9ca-e89b-4217-b3b0-ada824d9e095', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f530d986-f8f6-477f-8ee9-838781e85c47', '龙门镇', NULL, NULL, 651, 'd7f44c2a-2728-4633-a8b6-7643136bc99d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f53e452b-d3da-49f6-9439-83729a5569e4', '祁连县', NULL, NULL, 3784, '583dc13d-fce3-4f8a-b534-f717ec055405', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f548e21d-db38-451d-b1dd-4860dae9bea6', '天祝县', NULL, NULL, 337, 'eea322d8-1faf-4a08-a7f9-1d097375a96d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f5628219-7999-4329-a6c3-3c937e35685b', '岳阳楼区', NULL, NULL, 2265, '8369850a-f796-470f-902f-393cfb615571', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:20', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f5a36630-b667-4e44-89f3-210f4f95d106', '高唐县', NULL, NULL, 360, '56b97c58-86a5-4869-9130-c5dc51ea9a26', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f5ad2362-1980-4866-b0e9-cc5f790f56a9', '平潭县', NULL, NULL, 4250, '71a49c5c-c3c2-4fcb-8f90-aa1d733a19f7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:22', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f5c276e4-d60b-4cf1-b39f-f4f3eebb5efd', '个旧市', NULL, NULL, 3149, '99a9abd1-f107-4dc6-ae43-e9d1120504b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f5c288b8-ca84-4c18-a5dc-61cff4a24288', '韩村河镇', NULL, NULL, 55, '0863a0a5-7ac5-4a13-80f5-d31e3a1aa459', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f5cbc86b-9cab-4a86-a3ec-d05e9a282e3b', '永平乡', NULL, NULL, 1500, '89e8be16-b810-4c7e-89f0-aa9f24483b98', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:19', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f5d75251-da48-4dec-91c8-1bc432933b6a', '大石窝镇', NULL, NULL, 52, '0863a0a5-7ac5-4a13-80f5-d31e3a1aa459', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f5e15783-2daa-4376-8134-65ca2354c590', '鸠江区', NULL, NULL, 3945, '5d5b2d25-fb30-4b3b-baac-c5481ccc67e9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:21', NULL, NULL);
INSERT INTO `L_REGION`
VALUES ('f6275dd0-8d14-4d0c-bd6b-557aa67f8105', '高谷镇', NULL, NULL, 187