-- liquibase formatted sql

-- changeset Lang:l-city-1
SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for L_CITY
-- ----------------------------
DROP TABLE IF EXISTS `L_CITY`;
CREATE TABLE `L_CITY`
(
    `KEY`        VARCHAR(36) NOT NULL COMMENT '「key」- 主键',
    `NAME`       VARCHAR(32) NOT NULL COMMENT '「name」- 名称',
    `CODE`       VARCHAR(36) DEFAULT NULL COMMENT '「code」- 编码',
    `METADATA`   TEXT COMMENT '「metadata」- 附加配置',
    `ORDER`      INT(11)     DEFAULT NULL COMMENT '「order」- 排序',
    `STATE_ID`   VARCHAR(36) NOT NULL COMMENT '「stateId」- 省会ID',

    -- 特殊字段
    `ACTIVE`     BIT         DEFAULT NULL COMMENT '「active」- 是否启用',
    `SIGMA`      VARCHAR(32) DEFAULT NULL COMMENT '「sigma」- 统一标识',
    `LANGUAGE`   VARCHAR(8)  DEFAULT NULL COMMENT '「language」- 使用的语言',

    -- Auditor字段
    `CREATED_AT` DATETIME COMMENT '「createdAt」- 创建时间',
    `CREATED_BY` VARCHAR(36) COMMENT '「createdBy」- 创建人',
    `UPDATED_AT` DATETIME COMMENT '「updatedAt」- 更新时间',
    `UPDATED_BY` VARCHAR(36) COMMENT '「updatedBy」- 更新人',
    PRIMARY KEY (`KEY`)
);

-- changeset Lang:l-city-2
ALTER TABLE L_CITY
    ADD UNIQUE (`CODE`, `SIGMA`);

-- changeset Lang:l-city-3
-- ----------------------------
-- Records of L_CITY
-- ----------------------------
BEGIN;
INSERT INTO `L_CITY`
VALUES ('0118b1e4-bae7-4459-94b9-db6947b14aba', '嘉兴市', NULL, NULL, 29, '8379b422-0672-48b5-a879-2a2250e53088', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('01d0a041-f2c0-4416-b710-9376b2aabcaf', '梧州市', NULL, NULL, 158, 'a2630f50-39ed-4f27-bf0c-66c1d3f27df7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('02033c55-d6b3-4a85-91e0-b68d170d3383', '舟山市', NULL, NULL, 26, '8379b422-0672-48b5-a879-2a2250e53088', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('0275a9ca-e89b-4217-b3b0-ada824d9e095', '城口县', NULL, NULL, 207, 'ddd88468-4142-4189-a6c6-f3dfd00515d0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('03761c32-1378-4ae3-b5a5-4be7d38da29b', '阿拉尔市', NULL, NULL, 429, '703913de-6889-4224-b817-077aa75aed29', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('03f84ef3-e7e9-4c0d-a1ab-b4170505bcaf', '揭阳市', NULL, NULL, 330, 'e38eaf87-f8ec-41f1-9540-00d6274220b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('0541b99e-02a6-415b-8282-4ef9d27cb647', '泰州市', NULL, NULL, 80, 'f325b6b1-424e-4a4f-801f-7029191b47ee', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('060b2327-c9b1-47ef-a56a-d280d1a4297d', '荆门市', NULL, NULL, 213, 'e0e5fdc2-1cc8-4743-84d1-2f3f5a88ad3e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('0687423f-e02f-4a66-92aa-f508821059ee', '崇文区', NULL, NULL, 270, 'f819d7b2-0e42-4500-a124-2ce0a2d6e19e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('0863a0a5-7ac5-4a13-80f5-d31e3a1aa459', '房山区', NULL, NULL, 275, 'f819d7b2-0e42-4500-a124-2ce0a2d6e19e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('08acb8e2-e168-4e7b-81ce-918197cf4ecf', '潮州市', NULL, NULL, 342, 'e38eaf87-f8ec-41f1-9540-00d6274220b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('096d0f9e-9537-43f8-95f6-8dca9fa4cad4', '长春市', NULL, NULL, 1, '396fd2ae-3194-4a75-9145-bbd81bee07f2', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('0be5e1cb-cdb0-48ca-9f82-47f7f4c6dd2e', '临高县', NULL, NULL, 412, '1217c9af-748a-4b42-a120-23f89f79bea0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('0c1d1a8a-4eea-4aa0-9a5e-b68ae380a09a', '朝阳市', NULL, NULL, 405, '58f94c9d-5db7-4a98-92da-13b8bdea3e1a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('0ce20b86-8bea-4d7c-a1e4-09c7519d8b16', '巴音郭楞州', NULL, NULL, 440, '703913de-6889-4224-b817-077aa75aed29', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('0d3bd52a-74b2-4461-9a57-17c7cce4ac1b', '泉州市', NULL, NULL, 229, '9160df58-c1dc-4c78-a774-709d4e3c12f7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('0e5598a8-f405-4745-8cd5-a7a4c99f67f9', '金山区', NULL, NULL, 261, '7bb2549c-c713-4012-a420-98ef94687b76', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('0ee28cef-8dfc-4a9f-b7c1-330bc11c1bb3', '万州区', NULL, NULL, 168, 'ddd88468-4142-4189-a6c6-f3dfd00515d0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('0f2ba543-1d40-4b41-b700-6b53a9622b5b', '柳州市', NULL, NULL, 156, 'a2630f50-39ed-4f27-bf0c-66c1d3f27df7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('0f534d39-ac41-4416-8f72-8ca7e6ad951d', '金昌市', NULL, NULL, 318, 'c06e1be0-e0fb-40bf-b39c-9cf01d96007d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('0f559985-f6fe-4a8f-af80-3d0d64932dbc', '石柱县', NULL, NULL, 183, 'ddd88468-4142-4189-a6c6-f3dfd00515d0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('0fafa17c-1c8a-4cb9-a100-4cfa035e3fed', '白银市', NULL, NULL, 319, 'c06e1be0-e0fb-40bf-b39c-9cf01d96007d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('10aecf03-914d-4a26-a6c3-0045748d43b8', '德宏州', NULL, NULL, 152, '26d8b6aa-81ec-4e94-8920-d7a36b63aa0d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('137c8fae-dfaf-499e-93ff-48944e652926', '图木舒克市', NULL, NULL, 430, '703913de-6889-4224-b817-077aa75aed29', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('141f0b1e-0746-4a59-b91a-6356d1352335', '怒江州', NULL, NULL, 153, '26d8b6aa-81ec-4e94-8920-d7a36b63aa0d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('1643aaaf-a1e0-4b6b-8953-28c93dce03e0', '武清区', NULL, NULL, 97, '0e600cd7-eb9b-4f91-8772-96eee4043deb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('1671eb17-f102-4972-9d41-7b1463da334d', '葫芦岛市', NULL, NULL, 400, '58f94c9d-5db7-4a98-92da-13b8bdea3e1a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('16769cc8-c7bd-49cd-8e76-bcb74327f133', '怀柔区', NULL, NULL, 279, 'f819d7b2-0e42-4500-a124-2ce0a2d6e19e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('1721f4b0-56cf-4408-a217-62416951c176', '金华市', NULL, NULL, 32, '8379b422-0672-48b5-a879-2a2250e53088', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('18a8dd20-aad4-43cd-ab48-ab6108097d8a', '宜宾市', NULL, NULL, 366, 'e4da2d14-50b9-4520-9439-c9c8cf1de7e3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('18b3c51b-f699-467d-a342-d78bf9cff362', '忻州市', NULL, NULL, 133, '2faaa422-5236-4d12-a27b-abfbba1ef767', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('18de87f3-b679-462e-93ac-770a72141f3b', '西城区', NULL, NULL, 268, 'f819d7b2-0e42-4500-a124-2ce0a2d6e19e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('1a27a18f-784d-4314-bd00-8add932005d6', '滁州市', NULL, NULL, 51, 'd0722fc6-feb8-45ba-9d1c-f30871f67063', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('1aabde9d-2b04-4892-a20d-5b4e3efaeedf', '新乡市', NULL, NULL, 381, '84d6d546-171d-43cc-92a1-fb35022c3dd9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('1aeeea9e-d028-4a96-94ce-ba84cdd3e69f', '临汾市', NULL, NULL, 135, '2faaa422-5236-4d12-a27b-abfbba1ef767', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('1af0c5e6-6728-445e-9278-f1eaf5c6303a', '张家界市', NULL, NULL, 242, '1d0d0600-479b-418e-be8c-3eb615b39a3d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('1b8b9a84-0955-4d1e-8f33-8de97af3bedd', '大兴安岭地区', NULL, NULL, 126, 'ebff77a5-f7d9-481e-8285-b1bad1af16ee', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('1c2bd9d2-bc08-486e-a5f3-ba5de82c6365', '牡丹江市', NULL, NULL, 119, 'ebff77a5-f7d9-481e-8285-b1bad1af16ee', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('1c705a6d-5a16-4544-905c-68134716c6cf', '营口市', NULL, NULL, 401, '58f94c9d-5db7-4a98-92da-13b8bdea3e1a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('1dc7d092-717c-424e-a473-bb2cc8836b5e', '通辽市', NULL, NULL, 44, '96394a43-eab6-4626-8b1f-040309f8ff0e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('1de2a515-79f9-47f9-a31f-f6892f97a705', '东营市', NULL, NULL, 289, '8e7f4270-162a-4737-941a-f6ef2b6b580b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('1e0a806c-ad0b-4e9f-a488-8bf9fc903f4d', '抚州市', NULL, NULL, 19, '1929cb4b-3475-4a0f-bf80-bb118b0af8b9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('1e3ed660-6de7-4b3a-a1d2-3ea7e0778e94', '丰台区', NULL, NULL, 272, 'f819d7b2-0e42-4500-a124-2ce0a2d6e19e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('1e53830d-8cdb-4111-8da6-987131b873ed', '青岛市', NULL, NULL, 286, '8e7f4270-162a-4737-941a-f6ef2b6b580b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('1fdea9c2-419d-4fd5-b725-8d361e4376fb', '呼和浩特市', NULL, NULL, 33, '96394a43-eab6-4626-8b1f-040309f8ff0e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('20783033-f61b-4dd8-88da-fbd1efe84423', '塘沽区', NULL, NULL, 95, '0e600cd7-eb9b-4f91-8772-96eee4043deb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('20a1443b-429b-4c83-83ca-2c9de2bd67b8', '鹰潭市', NULL, NULL, 16, '1929cb4b-3475-4a0f-bf80-bb118b0af8b9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('20c4f23e-77e7-4763-9ba8-dd00d5216748', '萍乡市', NULL, NULL, 13, '1929cb4b-3475-4a0f-bf80-bb118b0af8b9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('20c90e6f-8e98-40c5-b2f9-f6ae39959a39', '五家渠市', NULL, NULL, 428, '703913de-6889-4224-b817-077aa75aed29', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('2130bd75-b4cf-44af-a13b-2b64109f0cb9', '鹤壁市', NULL, NULL, 380, '84d6d546-171d-43cc-92a1-fb35022c3dd9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('21aca68b-8887-476c-b2b3-fe670c301acc', '海东地区', NULL, NULL, 302, '0b9f22d0-5c63-44aa-ad88-469af891fd96', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('21bb958f-e5d4-4a71-a350-b5bf2c0e2de0', '白沙县', NULL, NULL, 417, '1217c9af-748a-4b42-a120-23f89f79bea0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('2263db14-1626-4430-a8ea-bc9c02268004', '宿迁市', NULL, NULL, 77, 'f325b6b1-424e-4a4f-801f-7029191b47ee', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('22f622f8-7eaf-41e9-90ee-2a0cfda1f326', '济源市', NULL, NULL, 392, '84d6d546-171d-43cc-92a1-fb35022c3dd9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('237eff18-fe6c-4842-afb1-acb05027a5c1', '邯郸市', NULL, NULL, 448, '4aab8599-afb8-4552-82d5-5ff97dc7b780', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('23ca0ede-0d68-4451-afde-afd774149ec4', '林芝地区', NULL, NULL, 67, '40f427b4-ccc4-4967-8ce4-f9b9023d24b7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('23df07d6-66e4-474e-b42b-258f50d7b0e4', '泰安市', NULL, NULL, 300, '8e7f4270-162a-4737-941a-f6ef2b6b580b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('24925ffc-d2fd-4b44-823a-250fcc224503', '克拉玛依市', NULL, NULL, 432, '703913de-6889-4224-b817-077aa75aed29', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('24ad0708-80a9-43b1-8e1c-758f2492d3f6', '潜江市', NULL, NULL, 222, 'e0e5fdc2-1cc8-4743-84d1-2f3f5a88ad3e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('258231ca-ed61-443c-873c-5d5b85483ac0', '珠海市', NULL, NULL, 325, 'e38eaf87-f8ec-41f1-9540-00d6274220b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('271a8d5d-a9a3-4876-a9a2-ca9bcee4b83f', '沈阳市', NULL, NULL, 393, '58f94c9d-5db7-4a98-92da-13b8bdea3e1a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('27289f06-ca7a-4916-8f25-f6b13d8687ec', '璧山县', NULL, NULL, 188, 'ddd88468-4142-4189-a6c6-f3dfd00515d0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('27537995-4520-4156-95b5-b3d1e368a5dc', '海淀区', NULL, NULL, 267, 'f819d7b2-0e42-4500-a124-2ce0a2d6e19e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('278acb58-4d2d-40cb-a572-1fc7fb979c77', '苏州市', NULL, NULL, 85, 'f325b6b1-424e-4a4f-801f-7029191b47ee', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('27eaf8ae-634a-45eb-bdc9-207c699d16ef', '玉树州', NULL, NULL, 307, '0b9f22d0-5c63-44aa-ad88-469af891fd96', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('291193af-b923-45d1-8597-2d00a0f4ad51', '北部新区', NULL, NULL, 206, 'ddd88468-4142-4189-a6c6-f3dfd00515d0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('292d9fec-f1c5-4100-b5be-fe56a5036e70', '果洛州', NULL, NULL, 306, '0b9f22d0-5c63-44aa-ad88-469af891fd96', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('29595f0b-301d-42da-845d-01afb30a9c18', '西安市', NULL, NULL, 109, '2e931610-54aa-4dc4-9f29-9b9a300778c0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('2a45fee0-aa22-4471-be1a-0f6edce52b7a', '银川市', NULL, NULL, 45, '21a4d8bb-76d8-4dcb-b317-00ff122cff6d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('2a61b8e3-4156-42df-836b-fc855d156f23', '江门市', NULL, NULL, 335, 'e38eaf87-f8ec-41f1-9540-00d6274220b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('2aabe025-ea3b-4ce4-885f-9ecf122b3e79', '梅州市', NULL, NULL, 329, 'e38eaf87-f8ec-41f1-9540-00d6274220b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('2b997404-05c1-436b-8004-2d5dfd364db3', '玉溪市', NULL, NULL, 141, '26d8b6aa-81ec-4e94-8920-d7a36b63aa0d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('2ba31d52-f5a5-4186-b924-4049b61f3d18', '和平区', NULL, NULL, 87, '0e600cd7-eb9b-4f91-8772-96eee4043deb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('2c8bc8c3-9317-4f36-a0ad-05a8d6b27053', '彭水县', NULL, NULL, 184, 'ddd88468-4142-4189-a6c6-f3dfd00515d0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('2ca5ebc8-b3f5-49d8-b421-85ae2dc0de35', '阿勒泰地区', NULL, NULL, 445, '703913de-6889-4224-b817-077aa75aed29', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('2ca74ae0-5e04-4119-84d8-187921fe4056', '肇庆市', NULL, NULL, 340, 'e38eaf87-f8ec-41f1-9540-00d6274220b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('2d364b6d-2931-4d45-995a-336e4e0f2b55', '兰州市', NULL, NULL, 317, 'c06e1be0-e0fb-40bf-b39c-9cf01d96007d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('2e21ea75-c640-4928-8cb4-e5ba4f6e2ffe', '儋州市', NULL, NULL, 427, '1217c9af-748a-4b42-a120-23f89f79bea0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('301b83a6-8049-4c5e-805e-2cea20190d97', '黄浦区', NULL, NULL, 265, '7bb2549c-c713-4012-a420-98ef94687b76', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('30ce87bd-09cc-4250-9b5e-1f5916ce4d70', '邵阳市', NULL, NULL, 239, '1d0d0600-479b-418e-be8c-3eb615b39a3d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('310378c8-165d-4f81-a495-67e9b30f000f', '宝坻区', NULL, NULL, 102, '0e600cd7-eb9b-4f91-8772-96eee4043deb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('31187fc0-8d6e-45f3-9653-b7ce4227ef1d', '昭通市', NULL, NULL, 142, '26d8b6aa-81ec-4e94-8920-d7a36b63aa0d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('312a1e8d-70a3-4529-bfe8-04a7f21cc881', '巴中市', NULL, NULL, 370, 'e4da2d14-50b9-4520-9439-c9c8cf1de7e3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('332e1b20-ce8a-4065-ab84-b60416060476', '商洛市', NULL, NULL, 107, '2e931610-54aa-4dc4-9f29-9b9a300778c0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('334645de-ae54-416a-8978-2dbf9f7bbd09', '石家庄市', NULL, NULL, 447, '4aab8599-afb8-4552-82d5-5ff97dc7b780', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('34138fe1-593f-4c44-87ac-1beaee74bafb', '云浮市', NULL, NULL, 343, 'e38eaf87-f8ec-41f1-9540-00d6274220b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('349a18f4-4117-490c-b26f-80702a4911bf', '哈尔滨市', NULL, NULL, 124, 'ebff77a5-f7d9-481e-8285-b1bad1af16ee', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('35efbdcb-33ab-4b9c-b3b7-bfde26a8a33c', '河西区', NULL, NULL, 90, '0e600cd7-eb9b-4f91-8772-96eee4043deb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('3760382f-ecb5-4ef6-8bd2-049afe34b574', '宜昌市', NULL, NULL, 221, 'e0e5fdc2-1cc8-4743-84d1-2f3f5a88ad3e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('37614653-bf6c-458f-a844-540790491eb1', '张家口市', NULL, NULL, 451, '4aab8599-afb8-4552-82d5-5ff97dc7b780', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('381b5351-4075-4ec0-88cd-f3e1da71c110', '龙岩市', NULL, NULL, 232, '9160df58-c1dc-4c78-a774-709d4e3c12f7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('39b19556-caa3-41de-a70f-2d81f23db54d', '自贡市', NULL, NULL, 355, 'e4da2d14-50b9-4520-9439-c9c8cf1de7e3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('3a856f9e-a1e5-4657-b81e-cc7d76d14ff5', '阿里地区', NULL, NULL, 66, '40f427b4-ccc4-4967-8ce4-f9b9023d24b7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('3bc6861d-0eeb-497e-9257-42f9cd6fd26f', '东莞市', NULL, NULL, 333, 'e38eaf87-f8ec-41f1-9540-00d6274220b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('3c9ba44c-7031-4422-b9b7-85d772ee3e08', '淮安市', NULL, NULL, 76, 'f325b6b1-424e-4a4f-801f-7029191b47ee', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('3e082d1b-ecb4-4bf8-8715-54132a9106e1', '松江区', NULL, NULL, 260, '7bb2549c-c713-4012-a420-98ef94687b76', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('3e54862f-40e4-4b44-b318-6a64b04a9558', '潍坊市', NULL, NULL, 290, '8e7f4270-162a-4737-941a-f6ef2b6b580b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('3fbd3d32-e8e3-476f-9f4c-319ffaaed527', '保山市', NULL, NULL, 145, '26d8b6aa-81ec-4e94-8920-d7a36b63aa0d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('40852955-b0b0-4a50-b4b2-201be5c3808b', '湘潭市', NULL, NULL, 236, '1d0d0600-479b-418e-be8c-3eb615b39a3d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('40c54e46-4d4f-4d44-95a2-d38a55d0af7b', '大渡口区', NULL, NULL, 202, 'ddd88468-4142-4189-a6c6-f3dfd00515d0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('41f376c0-764f-46b9-af35-e555518fc613', '江津区', NULL, NULL, 194, 'ddd88468-4142-4189-a6c6-f3dfd00515d0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('42852584-118b-41cf-ba7e-db28102a593a', '酒泉市', NULL, NULL, 313, 'c06e1be0-e0fb-40bf-b39c-9cf01d96007d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('42cd885b-80a2-4098-bd35-be2e606f9ab1', '杨浦区', NULL, NULL, 254, '7bb2549c-c713-4012-a420-98ef94687b76', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('43c813e3-8672-45c5-8d3e-9ee43dbe51c8', '巴南区', NULL, NULL, 192, 'ddd88468-4142-4189-a6c6-f3dfd00515d0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('442f465d-6566-45e4-9338-50f4395aa6f7', '丰都县', NULL, NULL, 176, 'ddd88468-4142-4189-a6c6-f3dfd00515d0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('44b40fc1-5bf4-476c-b869-580342d65c02', '遂宁市', NULL, NULL, 361, 'e4da2d14-50b9-4520-9439-c9c8cf1de7e3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('46073b56-9ab9-4efb-874f-efe112a304a6', '东方市', NULL, NULL, 426, '1217c9af-748a-4b42-a120-23f89f79bea0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('465e9ea2-a2f2-4b42-95dd-b48d91f67105', '酉阳县', NULL, NULL, 186, 'ddd88468-4142-4189-a6c6-f3dfd00515d0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('4683d3ef-0edf-425a-98d5-2cb231a7d88a', '浦东新区', NULL, NULL, 258, '7bb2549c-c713-4012-a420-98ef94687b76', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('4686b935-e3f0-4173-bdfe-ab6a5450d1a8', '长寿区', NULL, NULL, 196, 'ddd88468-4142-4189-a6c6-f3dfd00515d0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('46abe060-5805-4aaf-9d89-b66bed4b224e', '贵阳市', NULL, NULL, 344, '36043ac3-9d21-4010-877d-f47338210b63', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('472589fe-78e1-4c48-8fde-cf3996a778ca', '绍兴市', NULL, NULL, 31, '8379b422-0672-48b5-a879-2a2250e53088', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('48832e11-ddfb-478a-9787-e46c47346d7e', '鞍山市', NULL, NULL, 395, '58f94c9d-5db7-4a98-92da-13b8bdea3e1a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('4888e1e9-ba45-4254-83e7-87796f338e2d', '武隆县', NULL, NULL, 175, 'ddd88468-4142-4189-a6c6-f3dfd00515d0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('49bad2d2-0c83-48ed-9985-7a709362f3a8', '朔州市', NULL, NULL, 131, '2faaa422-5236-4d12-a27b-abfbba1ef767', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('49c42e59-25a9-4152-b9e4-ebfd45252ef5', '河北区', NULL, NULL, 88, '0e600cd7-eb9b-4f91-8772-96eee4043deb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('4a5fccf3-5d70-4b0b-85ef-c2a8e5fdfadc', '常州市', NULL, NULL, 83, 'f325b6b1-424e-4a4f-801f-7029191b47ee', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('4a8f2a43-831a-4413-b4b5-2de877d9b166', '博尔塔拉州', NULL, NULL, 442, '703913de-6889-4224-b817-077aa75aed29', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('4b199fdb-3a49-40f7-9843-8bd43f4ea30c', '赤峰市', NULL, NULL, 36, '96394a43-eab6-4626-8b1f-040309f8ff0e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('4b20c67b-06ca-4c0b-a947-bc518238537e', '神农架林区', NULL, NULL, 215, 'e0e5fdc2-1cc8-4743-84d1-2f3f5a88ad3e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('4b3478d4-3e85-4143-bc6f-ac4a338a9d47', '保亭县', NULL, NULL, 420, '1217c9af-748a-4b42-a120-23f89f79bea0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('4bb2fe40-7307-498b-802c-e85e937f95e0', '广安市', NULL, NULL, 367, 'e4da2d14-50b9-4520-9439-c9c8cf1de7e3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('4c1e2adc-07ac-46ea-b0de-fb35e74a2708', '石河子市', NULL, NULL, 433, '703913de-6889-4224-b817-077aa75aed29', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('4d6c5692-82f1-443c-9163-39a3dd77636b', '邢台市', NULL, NULL, 449, '4aab8599-afb8-4552-82d5-5ff97dc7b780', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('4edd328e-68af-4f0e-bca8-63686e5cad24', '平凉市', NULL, NULL, 322, 'c06e1be0-e0fb-40bf-b39c-9cf01d96007d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('4ee9594e-d779-4cad-a3bc-d766de26628a', '六安市', NULL, NULL, 56, 'd0722fc6-feb8-45ba-9d1c-f30871f67063', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('4f073365-4e02-459f-8b32-cad88dd22637', '成都市', NULL, NULL, 354, 'e4da2d14-50b9-4520-9439-c9c8cf1de7e3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('4f2a5173-2b34-4ed5-974e-a6ab5641b2a8', '克孜勒苏州', NULL, NULL, 439, '703913de-6889-4224-b817-077aa75aed29', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('4f4c1ef4-f54d-4ba4-a124-ca2d3d0ddb78', '唐山市', NULL, NULL, 454, '4aab8599-afb8-4552-82d5-5ff97dc7b780', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('4f867632-2989-4def-9934-a9c5fe0d5ca5', '云阳县', NULL, NULL, 179, 'ddd88468-4142-4189-a6c6-f3dfd00515d0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('4ff4ef6c-41df-4562-a58f-d8b25b2e3ba4', '郑州市', NULL, NULL, 375, '84d6d546-171d-43cc-92a1-fb35022c3dd9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('50868d97-8741-48fe-9cba-86e2e118f220', '楚雄州', NULL, NULL, 150, '26d8b6aa-81ec-4e94-8920-d7a36b63aa0d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('509d3498-d5ba-4378-8bee-0baf015c2a11', '河池市', NULL, NULL, 166, 'a2630f50-39ed-4f27-bf0c-66c1d3f27df7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('50d6a2ea-ba0d-4ff5-8b4c-f9d84e79e381', '郴州市', NULL, NULL, 243, '1d0d0600-479b-418e-be8c-3eb615b39a3d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('52d3ef0d-d999-4ae8-971b-534a2b25de02', '襄阳市', NULL, NULL, 218, 'e0e5fdc2-1cc8-4743-84d1-2f3f5a88ad3e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('533981ab-21f3-46b9-91a4-320129bd0b49', '丽江市', NULL, NULL, 146, '26d8b6aa-81ec-4e94-8920-d7a36b63aa0d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('544dce0d-0bad-4816-9396-22858bdba6ec', '韶山市', NULL, NULL, 237, '1d0d0600-479b-418e-be8c-3eb615b39a3d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('552f7151-162b-4453-a9c5-3a9092fce226', '日照市', NULL, NULL, 299, '8e7f4270-162a-4737-941a-f6ef2b6b580b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('55b0b2d6-58e4-40a1-b278-e63aa372ba29', '漯河市', NULL, NULL, 385, '84d6d546-171d-43cc-92a1-fb35022c3dd9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('55fbb0a6-5436-4d04-9f29-716233f81fd7', '安康市', NULL, NULL, 108, '2e931610-54aa-4dc4-9f29-9b9a300778c0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('55fdf7c7-6698-498a-8aef-b9455ab7926c', '毕节市', NULL, NULL, 348, '36043ac3-9d21-4010-877d-f47338210b63', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('56327d0b-ec26-4f34-8ab6-0eba49931c67', '临沂市', NULL, NULL, 295, '8e7f4270-162a-4737-941a-f6ef2b6b580b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('56b97c58-86a5-4869-9130-c5dc51ea9a26', '聊城市', NULL, NULL, 296, '8e7f4270-162a-4737-941a-f6ef2b6b580b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('574f476d-e1ab-4240-a84f-b9671a2cb9cc', '铜陵市', NULL, NULL, 58, 'd0722fc6-feb8-45ba-9d1c-f30871f67063', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('576c43af-0a86-47d9-83a7-4989ce3b3dc7', '朝阳区', NULL, NULL, 266, 'f819d7b2-0e42-4500-a124-2ce0a2d6e19e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('5800fbac-51b0-4bc6-bc2b-34f78067fc28', '日喀则地区', NULL, NULL, 72, '40f427b4-ccc4-4967-8ce4-f9b9023d24b7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('583dc13d-fce3-4f8a-b534-f717ec055405', '海北州', NULL, NULL, 303, '0b9f22d0-5c63-44aa-ad88-469af891fd96', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('5a1e74c1-6f4c-440f-8ade-ac470f4ada87', '大港区', NULL, NULL, 100, '0e600cd7-eb9b-4f91-8772-96eee4043deb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('5a657ab2-3d76-4a46-917c-ddfe22c60d16', '拉萨市', NULL, NULL, 68, '40f427b4-ccc4-4967-8ce4-f9b9023d24b7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('5c4e7f63-9162-47e1-a948-c64ca46ff566', '汉中市', NULL, NULL, 105, '2e931610-54aa-4dc4-9f29-9b9a300778c0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('5c5b11a0-6a29-4173-b876-8fdbc543cb2b', '湛江市', NULL, NULL, 338, 'e38eaf87-f8ec-41f1-9540-00d6274220b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('5c8748b9-cee3-4d8e-956c-0d0e24db8850', '济宁市', NULL, NULL, 284, '8e7f4270-162a-4737-941a-f6ef2b6b580b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('5ce65120-7c31-4b33-8e77-7db1c92d085c', '中卫市', NULL, NULL, 49, '21a4d8bb-76d8-4dcb-b317-00ff122cff6d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('5d21af6a-f035-42f4-a0cf-ff1fd3d36f3b', '门头沟', NULL, NULL, 274, 'f819d7b2-0e42-4500-a124-2ce0a2d6e19e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('5d2d5d2f-fd44-47ad-8108-b7f838073fbd', '临夏州', NULL, NULL, 315, 'c06e1be0-e0fb-40bf-b39c-9cf01d96007d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('5d3b3a34-50c8-4a01-83b7-e3e068d5c9a7', '澄迈县', NULL, NULL, 413, '1217c9af-748a-4b42-a120-23f89f79bea0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('5d5b2d25-fb30-4b3b-baac-c5481ccc67e9', '芜湖市', NULL, NULL, 65, 'd0722fc6-feb8-45ba-9d1c-f30871f67063', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('5da76347-cb7e-4817-b07a-985010b9c63a', '随州市', NULL, NULL, 214, 'e0e5fdc2-1cc8-4743-84d1-2f3f5a88ad3e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('5f548430-51dc-45ad-82e5-bcd0394d8f6c', '吉安市', NULL, NULL, 20, '1929cb4b-3475-4a0f-bf80-bb118b0af8b9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('5f7e2e46-8a4e-4463-907c-5762bcd006a8', '定安县', NULL, NULL, 414, '1217c9af-748a-4b42-a120-23f89f79bea0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('60e9ec7d-f371-4ea9-ace3-b13c1cd7081c', '和田地区', NULL, NULL, 436, '703913de-6889-4224-b817-077aa75aed29', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('61cc258d-1868-4356-bcbc-2e8b118745ca', '庆阳市', NULL, NULL, 309, 'c06e1be0-e0fb-40bf-b39c-9cf01d96007d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('62aa4f78-f1b9-44d1-9372-21e01c353757', '商丘市', NULL, NULL, 388, '84d6d546-171d-43cc-92a1-fb35022c3dd9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('63a5fa32-35eb-4eca-ab79-f3887e122564', '黄冈市', NULL, NULL, 209, 'e0e5fdc2-1cc8-4743-84d1-2f3f5a88ad3e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('63f8e070-63c0-4fa1-821f-d1d5a695ce2a', '镇江市', NULL, NULL, 82, 'f325b6b1-424e-4a4f-801f-7029191b47ee', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('64cf8b0a-4f50-458a-9aa6-475f368c183f', '河东区', NULL, NULL, 89, '0e600cd7-eb9b-4f91-8772-96eee4043deb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('657fcfcb-2cbe-4a17-8c6f-184169cfeb6f', '鄂州市', NULL, NULL, 212, 'e0e5fdc2-1cc8-4743-84d1-2f3f5a88ad3e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('6581d8db-553e-4417-8c37-91ed47904920', '綦江区', NULL, NULL, 203, 'ddd88468-4142-4189-a6c6-f3dfd00515d0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('66241d25-208b-4800-958a-fa2767754102', '南开区', NULL, NULL, 94, '0e600cd7-eb9b-4f91-8772-96eee4043deb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('667720b0-8429-42ef-b6a6-582df9b59468', '铜川市', NULL, NULL, 110, '2e931610-54aa-4dc4-9f29-9b9a300778c0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('6681b8cd-3740-4dbd-b311-143871994e15', '达州市', NULL, NULL, 368, 'e4da2d14-50b9-4520-9439-c9c8cf1de7e3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('671275c4-6107-4968-bd8e-96d53e9995b2', '天门市', NULL, NULL, 223, 'e0e5fdc2-1cc8-4743-84d1-2f3f5a88ad3e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('671d3a34-71bf-42c5-8dda-a813f5ecba22', '北碚区', NULL, NULL, 193, 'ddd88468-4142-4189-a6c6-f3dfd00515d0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('674106ce-5cae-4104-9851-34997d094c8a', '吐鲁番地区', NULL, NULL, 434, '703913de-6889-4224-b817-077aa75aed29', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('67723aea-a4ef-4eb7-afbf-55cc07806f98', '锡林郭勒盟', NULL, NULL, 38, '96394a43-eab6-4626-8b1f-040309f8ff0e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('691e132f-04a3-4856-a77a-92ed2dc5c246', '澳门特别行政区', NULL, NULL, 408, '85e12347-dc0c-40a3-ba7d-531c718ca98d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('69324865-24e8-4abe-a068-a1392c117c0d', '遵义市', NULL, NULL, 346, '36043ac3-9d21-4010-877d-f47338210b63', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('69508f5e-7304-4092-95a4-73d6a9b68eff', '淮南市', NULL, NULL, 60, 'd0722fc6-feb8-45ba-9d1c-f30871f67063', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('69696549-d65b-4e13-80ef-05ecaf0f61e3', '双鸭山市', NULL, NULL, 115, 'ebff77a5-f7d9-481e-8285-b1bad1af16ee', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('69f08469-ecd2-4a94-a921-da836fbf5838', '西双版纳州', NULL, NULL, 149, '26d8b6aa-81ec-4e94-8920-d7a36b63aa0d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('6ab7dc5a-1064-4090-a81b-79c3a2e8302d', '合肥市', NULL, NULL, 59, 'd0722fc6-feb8-45ba-9d1c-f30871f67063', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('6af0e8d8-91c9-43be-be32-5ec5c86b14f5', '雅安市', NULL, NULL, 369, 'e4da2d14-50b9-4520-9439-c9c8cf1de7e3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('6b5fed36-b200-40ca-af0b-11999b4399ef', '抚顺市', NULL, NULL, 396, '58f94c9d-5db7-4a98-92da-13b8bdea3e1a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('6c067928-5765-4455-9019-74593fd0e11d', '密云区', NULL, NULL, 280, 'f819d7b2-0e42-4500-a124-2ce0a2d6e19e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('6d3a8433-1273-4323-a3eb-d39effecc1d7', '黔东南州', NULL, NULL, 351, '36043ac3-9d21-4010-877d-f47338210b63', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('6de68814-d6ea-430e-88b6-bf98620aa604', '阜阳市', NULL, NULL, 52, 'd0722fc6-feb8-45ba-9d1c-f30871f67063', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('6e4850af-4247-4791-b0c5-d6d55ebc74b2', '莱芜市', NULL, NULL, 293, '8e7f4270-162a-4737-941a-f6ef2b6b580b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('6f0d2b72-566f-44e5-969d-2d2ce65ace5c', '贺州市', NULL, NULL, 164, 'a2630f50-39ed-4f27-bf0c-66c1d3f27df7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('6f153ca7-c91a-454a-809f-ebbc09e9f091', '长宁区', NULL, NULL, 250, '7bb2549c-c713-4012-a420-98ef94687b76', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('6fc78ef9-e2eb-46bc-bf8e-8b830ad96136', '长治市', NULL, NULL, 137, '2faaa422-5236-4d12-a27b-abfbba1ef767', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('71643995-698f-4bdf-afe9-09fce8a065c0', '南充市', NULL, NULL, 364, 'e4da2d14-50b9-4520-9439-c9c8cf1de7e3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('71a49c5c-c3c2-4fcb-8f90-aa1d733a19f7', '福州市', NULL, NULL, 225, '9160df58-c1dc-4c78-a774-709d4e3c12f7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('72738f5c-f5f3-4895-8ada-20327c2d5826', '新余市', NULL, NULL, 14, '1929cb4b-3475-4a0f-bf80-bb118b0af8b9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('727ca4ab-f7fc-49fb-9b2b-569d2fc79aa4', '昌平区', NULL, NULL, 281, 'f819d7b2-0e42-4500-a124-2ce0a2d6e19e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('7294fb6c-cbd8-49b7-ad18-f285bc43f1d9', '池州市', NULL, NULL, 55, 'd0722fc6-feb8-45ba-9d1c-f30871f67063', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('72d4f69f-2e4c-4bde-9df8-2aadc9168686', '涪陵区', NULL, NULL, 169, 'ddd88468-4142-4189-a6c6-f3dfd00515d0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('74a706f1-82bb-4132-8ee4-9abf7bd809cb', '广元市', NULL, NULL, 360, 'e4da2d14-50b9-4520-9439-c9c8cf1de7e3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('74fd7f9a-ddb6-4065-a99c-054987fffdb8', '北辰区', NULL, NULL, 101, '0e600cd7-eb9b-4f91-8772-96eee4043deb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('753245e5-8705-4940-badd-cd71430a4fdb', '巴彦淖尔市', NULL, NULL, 41, '96394a43-eab6-4626-8b1f-040309f8ff0e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('754500f9-7ec4-4379-8b1c-9370f50564c0', '韶关市', NULL, NULL, 327, 'e38eaf87-f8ec-41f1-9540-00d6274220b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('75dd761e-ce3f-45bb-a86b-d3a1e2c7629a', '衡阳市', NULL, NULL, 238, '1d0d0600-479b-418e-be8c-3eb615b39a3d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('76330308-a439-44e8-9f63-30f07cae40fe', '固原市', NULL, NULL, 48, '21a4d8bb-76d8-4dcb-b317-00ff122cff6d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('76dd00a1-30a1-4226-ae06-cad845c0528c', '巫山县', NULL, NULL, 182, 'ddd88468-4142-4189-a6c6-f3dfd00515d0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('78000393-73bd-4a54-a688-5db0e578d9cd', '泸州市', NULL, NULL, 357, 'e4da2d14-50b9-4520-9439-c9c8cf1de7e3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('7845d9d9-ca44-43a0-93d5-602fdb04ef55', '辽源市', NULL, NULL, 4, '396fd2ae-3194-4a75-9145-bbd81bee07f2', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('7932fd13-00db-4934-bfc2-79c835527339', '津南区', NULL, NULL, 98, '0e600cd7-eb9b-4f91-8772-96eee4043deb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('79482cd9-7d51-4c89-94c2-4bcd773b8323', '奉节县', NULL, NULL, 177, 'ddd88468-4142-4189-a6c6-f3dfd00515d0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('796bb0e0-6b76-4c1d-801f-2dbcbab74087', '桂林市', NULL, NULL, 157, 'a2630f50-39ed-4f27-bf0c-66c1d3f27df7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('7a5b4813-b095-4a1a-a008-1297fd9aa978', '咸宁市', NULL, NULL, 210, 'e0e5fdc2-1cc8-4743-84d1-2f3f5a88ad3e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('7acdab30-849a-4c32-b081-8cbdc15f711a', '莆田市', NULL, NULL, 228, '9160df58-c1dc-4c78-a774-709d4e3c12f7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('7af2dfc0-6d0b-4da1-a6c9-fa505dbc6e9b', '白城市', NULL, NULL, 8, '396fd2ae-3194-4a75-9145-bbd81bee07f2', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('7becad81-2a66-497c-9c70-276a85718c91', '本溪市', NULL, NULL, 397, '58f94c9d-5db7-4a98-92da-13b8bdea3e1a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('7c3fbad9-df03-4d15-93a4-695924a2f35d', '宝鸡市', NULL, NULL, 111, '2e931610-54aa-4dc4-9f29-9b9a300778c0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('7c9ca39d-ce8f-469d-899a-09a0a29c1541', '陇南市', NULL, NULL, 310, 'c06e1be0-e0fb-40bf-b39c-9cf01d96007d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('7ca3412f-b06b-467e-b547-691ab8327b15', '伊春市', NULL, NULL, 118, 'ebff77a5-f7d9-481e-8285-b1bad1af16ee', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('7de09763-759b-437b-a3aa-4cb32bd3c6b9', '南通市', NULL, NULL, 81, 'f325b6b1-424e-4a4f-801f-7029191b47ee', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('7e24b0e5-bf57-4e62-880a-e5b6ec159053', '内江市', NULL, NULL, 362, 'e4da2d14-50b9-4520-9439-c9c8cf1de7e3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('7fe0855f-3ef6-419b-a145-5994fe28cc8f', '荆州市', NULL, NULL, 220, 'e0e5fdc2-1cc8-4743-84d1-2f3f5a88ad3e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('7fefd2bf-99e0-43f5-bc37-9ab15ee8e8f3', '沙坪坝区', NULL, NULL, 201, 'ddd88468-4142-4189-a6c6-f3dfd00515d0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('818f3bc6-83b9-4d90-8e68-566cc7c2bb14', '安庆市', NULL, NULL, 64, 'd0722fc6-feb8-45ba-9d1c-f30871f67063', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('81aab36f-0e28-4ba3-9827-b7033fce9b24', '琼海市', NULL, NULL, 424, '1217c9af-748a-4b42-a120-23f89f79bea0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('81e22d56-a1c7-4263-be18-81a4af165ae3', '保定市', NULL, NULL, 450, '4aab8599-afb8-4552-82d5-5ff97dc7b780', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('8300a2db-b893-4d51-a009-89478871edf1', '宁德市', NULL, NULL, 233, '9160df58-c1dc-4c78-a774-709d4e3c12f7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('8349c2b0-91a2-4e19-b9c7-81b5224fbabe', '乌鲁木齐市', NULL, NULL, 431, '703913de-6889-4224-b817-077aa75aed29', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('8369850a-f796-470f-902f-393cfb615571', '岳阳市', NULL, NULL, 240, '1d0d0600-479b-418e-be8c-3eb615b39a3d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('8377f1cd-7272-4396-b99b-84bb707dbc2c', '清远市', NULL, NULL, 341, 'e38eaf87-f8ec-41f1-9540-00d6274220b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('84a16421-f7fb-4f99-b2c0-1e0dea97bf0b', '晋中市', NULL, NULL, 132, '2faaa422-5236-4d12-a27b-abfbba1ef767', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('8596baaf-4bfe-4522-a422-f397f3494bcb', '汕头市', NULL, NULL, 326, 'e38eaf87-f8ec-41f1-9540-00d6274220b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('86ab4d11-9653-4b0d-8cc1-2e12a4de15d6', '江北区', NULL, NULL, 198, 'ddd88468-4142-4189-a6c6-f3dfd00515d0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('86b77e39-331e-4927-9517-49be7b738b9a', '温州市', NULL, NULL, 28, '8379b422-0672-48b5-a879-2a2250e53088', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('86f7f02d-658e-44ec-9d36-b14cc3c65aaf', '廊坊市', NULL, NULL, 456, '4aab8599-afb8-4552-82d5-5ff97dc7b780', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('875ed189-3d32-4466-a24f-7cbac524774e', '黔西南州', NULL, NULL, 350, '36043ac3-9d21-4010-877d-f47338210b63', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('87e1c9be-7455-45a9-ace5-641efce55e22', '延边州', NULL, NULL, 9, '396fd2ae-3194-4a75-9145-bbd81bee07f2', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('88260608-a8b9-4b52-a474-1a551465c675', '南川区', NULL, NULL, 171, 'ddd88468-4142-4189-a6c6-f3dfd00515d0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('88546360-1a0c-4407-9b25-2cde1db643ee', '临沧市', NULL, NULL, 144, '26d8b6aa-81ec-4e94-8920-d7a36b63aa0d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('88bc9baa-b7fd-4bf4-a896-4e049185e0c2', '茂名市', NULL, NULL, 339, 'e38eaf87-f8ec-41f1-9540-00d6274220b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('88d84710-80d6-4837-b889-286c74d7940d', '通州区', NULL, NULL, 276, 'f819d7b2-0e42-4500-a124-2ce0a2d6e19e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('89a9c37c-487a-4c32-968c-cf9fefad8151', '青浦区', NULL, NULL, 259, '7bb2549c-c713-4012-a420-98ef94687b76', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('89e63cc0-6828-4bfd-9e6c-e5752f3cc837', '哈密地区', NULL, NULL, 435, '703913de-6889-4224-b817-077aa75aed29', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('89e8be16-b810-4c7e-89f0-aa9f24483b98', '垫江县', NULL, NULL, 185, 'ddd88468-4142-4189-a6c6-f3dfd00515d0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('8aa8a856-f81b-43f1-9749-14798022b2eb', '石景山区', NULL, NULL, 273, 'f819d7b2-0e42-4500-a124-2ce0a2d6e19e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('8ae99c85-66b1-406b-8084-9f77cbf73b10', '潼南县', NULL, NULL, 172, 'ddd88468-4142-4189-a6c6-f3dfd00515d0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('8afb487f-de86-4a5b-9abc-27ae2c07797d', '淮北市', NULL, NULL, 61, 'd0722fc6-feb8-45ba-9d1c-f30871f67063', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('8bf55045-9366-4acb-b884-bca672ff9644', '上饶市', NULL, NULL, 17, '1929cb4b-3475-4a0f-bf80-bb118b0af8b9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('8db1e665-1af9-4697-8514-7fa18e3a8683', '昌吉州', NULL, NULL, 441, '703913de-6889-4224-b817-077aa75aed29', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('8db8f645-a1a6-4c39-9c27-2f703951f66d', '承德市', NULL, NULL, 452, '4aab8599-afb8-4552-82d5-5ff97dc7b780', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('8e1185d8-66bf-4f53-8ffc-ae9aad60cac2', '攀枝花市', NULL, NULL, 356, 'e4da2d14-50b9-4520-9439-c9c8cf1de7e3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('8e4df698-c772-488a-acf8-70e7d4adebd2', '枣庄市', NULL, NULL, 288, '8e7f4270-162a-4737-941a-f6ef2b6b580b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('8e6440db-f1b8-4a72-8e20-7cca4fe2039d', '虹口区', NULL, NULL, 253, '7bb2549c-c713-4012-a420-98ef94687b76', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('8f917434-e687-4552-b494-0eab3af61900', '乐山市', NULL, NULL, 363, 'e4da2d14-50b9-4520-9439-c9c8cf1de7e3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('9122834d-aef5-4895-974e-82d2f568bcd4', '厦门市', NULL, NULL, 226, '9160df58-c1dc-4c78-a774-709d4e3c12f7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('926eaeaf-e8c5-47f2-89ff-6932b52c87d3', '广州市', NULL, NULL, 323, 'e38eaf87-f8ec-41f1-9540-00d6274220b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('931058d3-f668-41c4-94a8-7a763997d1df', '迪庆州', NULL, NULL, 138, '26d8b6aa-81ec-4e94-8920-d7a36b63aa0d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('9348509b-6d82-47e7-86d7-f054fb47b7fe', '吕梁市', NULL, NULL, 134, '2faaa422-5236-4d12-a27b-abfbba1ef767', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('93e31709-76d2-4b65-aa0f-7990919a44d0', '北海市', NULL, NULL, 159, 'a2630f50-39ed-4f27-bf0c-66c1d3f27df7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('94f58cdc-52ca-4a35-a822-4b62ab8bd3d7', '宿州市', NULL, NULL, 54, 'd0722fc6-feb8-45ba-9d1c-f30871f67063', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('951c8fd2-5d67-4ba4-b9a1-fd13fdcea9f9', '资阳市', NULL, NULL, 371, 'e4da2d14-50b9-4520-9439-c9c8cf1de7e3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('9568bdcc-65c2-4b1c-a512-b2ff897db321', '曲靖市', NULL, NULL, 140, '26d8b6aa-81ec-4e94-8920-d7a36b63aa0d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('9653e91f-7d63-4d36-adcc-4cdbe21dcbea', '七台河市', NULL, NULL, 121, 'ebff77a5-f7d9-481e-8285-b1bad1af16ee', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('96fec37f-11d5-4d41-aba4-a36d0652744c', '文昌市', NULL, NULL, 410, '1217c9af-748a-4b42-a120-23f89f79bea0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('9708d487-997e-4629-ab06-6fd2f1a311af', '宣武区', NULL, NULL, 271, 'f819d7b2-0e42-4500-a124-2ce0a2d6e19e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('9758648c-eab9-4434-b7ae-318e7e08548e', '兴安盟', NULL, NULL, 43, '96394a43-eab6-4626-8b1f-040309f8ff0e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('976170b4-d0f7-4fd9-82ed-6e336c9bf3c0', '信阳市', NULL, NULL, 391, '84d6d546-171d-43cc-92a1-fb35022c3dd9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('978f3e32-c5e0-48e4-b9ba-4f7f04ed87a1', '鹤岗市', NULL, NULL, 114, 'ebff77a5-f7d9-481e-8285-b1bad1af16ee', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('97942649-3cc7-4e4a-81b4-9a8c82f82ea7', '渝北区', NULL, NULL, 195, 'ddd88468-4142-4189-a6c6-f3dfd00515d0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('97a2157a-88ce-46f6-ba0f-e432060024ca', '阳江市', NULL, NULL, 337, 'e38eaf87-f8ec-41f1-9540-00d6274220b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('982c089d-7fb7-4cdc-a3c2-865e4637006f', '丽水市', NULL, NULL, 24, '8379b422-0672-48b5-a879-2a2250e53088', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('99071178-910e-48e6-a6ac-6ddd867677bb', '静海县', NULL, NULL, 93, '0e600cd7-eb9b-4f91-8772-96eee4043deb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('99107e35-f7d9-4c45-8d21-7a03b9c2f99d', '九龙坡区', NULL, NULL, 200, 'ddd88468-4142-4189-a6c6-f3dfd00515d0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('99a9abd1-f107-4dc6-ae43-e9d1120504b8', '红河州', NULL, NULL, 148, '26d8b6aa-81ec-4e94-8920-d7a36b63aa0d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('99c50aa3-ab40-4b1e-addd-f68662f3c560', '嘉定区', NULL, NULL, 257, '7bb2549c-c713-4012-a420-98ef94687b76', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('99f84690-670c-4a0e-ade1-ebcf17b00adb', '锦州市', NULL, NULL, 399, '58f94c9d-5db7-4a98-92da-13b8bdea3e1a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('9c7fcb3f-9d15-445a-944f-d2231a75f23d', '亳州市', NULL, NULL, 53, 'd0722fc6-feb8-45ba-9d1c-f30871f67063', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('9c8b6d83-dd06-4238-b7f4-c0ad532e5b6e', '德州市', NULL, NULL, 294, '8e7f4270-162a-4737-941a-f6ef2b6b580b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('9d7c5001-b115-4bea-abb4-a289a03b5075', '甘南州', NULL, NULL, 314, 'c06e1be0-e0fb-40bf-b39c-9cf01d96007d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('9d7d52af-ec34-48e3-b81d-09ac51e11590', '永川区', NULL, NULL, 197, 'ddd88468-4142-4189-a6c6-f3dfd00515d0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('9d872dc5-ad1a-4b3c-86de-debd1a77eb8c', '吴忠市', NULL, NULL, 47, '21a4d8bb-76d8-4dcb-b317-00ff122cff6d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('9d95b0ef-0bbc-404d-80d4-2143f433a4c2', '盘锦市', NULL, NULL, 402, '58f94c9d-5db7-4a98-92da-13b8bdea3e1a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('9e5ae65c-206f-4d7b-87f2-c252d5f40b52', '渭南市', NULL, NULL, 113, '2e931610-54aa-4dc4-9f29-9b9a300778c0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('9e7f13f5-3b43-4196-bfc8-ba33014f8034', '蓟县', NULL, NULL, 92, '0e600cd7-eb9b-4f91-8772-96eee4043deb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('a03ec6c9-8a1e-456b-bab9-164f8015c723', '佳木斯市', NULL, NULL, 120, 'ebff77a5-f7d9-481e-8285-b1bad1af16ee', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('a061ae4e-1b4e-4b42-8aa9-cc6bbae9619a', '乌兰察布市', NULL, NULL, 37, '96394a43-eab6-4626-8b1f-040309f8ff0e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('a096e337-c439-4751-a014-b49dd13bee26', '驻马店市', NULL, NULL, 390, '84d6d546-171d-43cc-92a1-fb35022c3dd9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('a1e3332c-7029-4de7-a221-40c041a9a620', '乐东县', NULL, NULL, 421, '1217c9af-748a-4b42-a120-23f89f79bea0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('a24f5cc3-558c-447d-bedc-895b418c750f', '眉山市', NULL, NULL, 365, 'e4da2d14-50b9-4520-9439-c9c8cf1de7e3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('a39ced08-b6e9-4de0-a2db-7a230a673d1e', '开县', NULL, NULL, 178, 'ddd88468-4142-4189-a6c6-f3dfd00515d0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('a3c44525-9ccb-429d-a2b7-f5f5d52b8a6d', '沧州市', NULL, NULL, 455, '4aab8599-afb8-4552-82d5-5ff97dc7b780', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('a4031322-7fba-466a-ba72-50082ab248c6', '吉林市', NULL, NULL, 2, '396fd2ae-3194-4a75-9145-bbd81bee07f2', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('a419fd83-e078-4430-aa48-ca9aa67e4fff', '塔城地区', NULL, NULL, 444, '703913de-6889-4224-b817-077aa75aed29', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('a489375e-6a4e-410b-be41-f687ba6c52cf', '宣城市', NULL, NULL, 57, 'd0722fc6-feb8-45ba-9d1c-f30871f67063', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('a560b8db-8db1-4bc8-bb6b-fbbecebcaf10', '大足区', NULL, NULL, 173, 'ddd88468-4142-4189-a6c6-f3dfd00515d0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('a632ea02-ee66-43f0-b946-2bce0ba5396a', '松原市', NULL, NULL, 7, '396fd2ae-3194-4a75-9145-bbd81bee07f2', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('a638060f-a01c-4c77-b905-b46ef8d3e89d', '海西州', NULL, NULL, 308, '0b9f22d0-5c63-44aa-ad88-469af891fd96', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('a6c5ceb6-42ea-4d90-bd06-3c0f8cf8bb81', '宁河县', NULL, NULL, 103, '0e600cd7-eb9b-4f91-8772-96eee4043deb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('a70a258d-7c8f-4726-a9ef-e2aa7c6247f9', '安顺市', NULL, NULL, 349, '36043ac3-9d21-4010-877d-f47338210b63', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('a732da28-870c-4d9c-a287-c2c1e3222b59', '合川区', NULL, NULL, 191, 'ddd88468-4142-4189-a6c6-f3dfd00515d0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('a769a530-0bcf-4e52-a9e5-3a8f5af945d2', '南阳市', NULL, NULL, 387, '84d6d546-171d-43cc-92a1-fb35022c3dd9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('a77a0530-087f-4dab-84ab-e8a9690de27f', '马鞍山市', NULL, NULL, 63, 'd0722fc6-feb8-45ba-9d1c-f30871f67063', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('a8cf4e9b-282a-4d0e-af55-7ba949628758', '西青区', NULL, NULL, 96, '0e600cd7-eb9b-4f91-8772-96eee4043deb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('a9736c65-aeba-4a39-861f-5edf105d8673', '河源市', NULL, NULL, 328, 'e38eaf87-f8ec-41f1-9540-00d6274220b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('aa1e4355-d9bd-4e6a-8812-0173f4f9815a', '乌海市', NULL, NULL, 35, '96394a43-eab6-4626-8b1f-040309f8ff0e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('aa2f26e5-9705-4dc0-b54a-a2d7dbb8b511', '黔江区', NULL, NULL, 174, 'ddd88468-4142-4189-a6c6-f3dfd00515d0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('ac0e6e50-b6a1-457c-811c-06ac309cd5a3', '巫溪县', NULL, NULL, 181, 'ddd88468-4142-4189-a6c6-f3dfd00515d0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('ac38b800-4a12-4d41-8c44-a031ebb79365', '徐汇区', NULL, NULL, 249, '7bb2549c-c713-4012-a420-98ef94687b76', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('adb7aa6e-99a6-453f-a2db-21ecfbc44874', '南京市', NULL, NULL, 73, 'f325b6b1-424e-4a4f-801f-7029191b47ee', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('af4299a6-6902-4c79-bc49-f7b3f3c6f683', '湖州市', NULL, NULL, 30, '8379b422-0672-48b5-a879-2a2250e53088', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('af6f4f65-b2db-4670-88ca-21de1de477fc', '昌江县', NULL, NULL, 416, '1217c9af-748a-4b42-a120-23f89f79bea0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('b126935b-0423-4bea-b802-d4e6680d1d71', '衡水市', NULL, NULL, 457, '4aab8599-afb8-4552-82d5-5ff97dc7b780', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('b2a03fc9-88f2-4734-9af2-7234863d0f87', '衢州市', NULL, NULL, 23, '8379b422-0672-48b5-a879-2a2250e53088', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('b2c794cc-d351-415b-b53c-cf0c454c1165', '德阳市', NULL, NULL, 358, 'e4da2d14-50b9-4520-9439-c9c8cf1de7e3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('b31f9073-6d76-4083-b00f-cc23550ef59a', '天水市', NULL, NULL, 320, 'c06e1be0-e0fb-40bf-b39c-9cf01d96007d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('b3792f06-9c78-446e-b6ac-d95d5e9092e8', '琼中县', NULL, NULL, 418, '1217c9af-748a-4b42-a120-23f89f79bea0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('b3b5e655-b2df-467e-ad5f-2ab21c2a0aba', '黄石市', NULL, NULL, 217, 'e0e5fdc2-1cc8-4743-84d1-2f3f5a88ad3e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('b3b75b0b-7709-48b5-a2ee-34deef5c15b1', '博尔塔拉蒙古自治州阿拉山口口岸', NULL, NULL, 446,
        '703913de-6889-4224-b817-077aa75aed29', 1, 'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL,
        '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('b53ced47-2455-44ec-b740-7637148f574c', '南宁市', NULL, NULL, 155, 'a2630f50-39ed-4f27-bf0c-66c1d3f27df7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('b5a118ad-786c-4d86-b4e8-5d25a3776a78', '洛阳市', NULL, NULL, 377, '84d6d546-171d-43cc-92a1-fb35022c3dd9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('b7342349-941d-427d-9ab6-e83a36078088', '昌都地区', NULL, NULL, 71, '40f427b4-ccc4-4967-8ce4-f9b9023d24b7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('b75db043-9782-4bae-aaee-bea49fc286e6', '陵水县', NULL, NULL, 419, '1217c9af-748a-4b42-a120-23f89f79bea0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('b7bc3a10-ad00-4b20-9fa4-cb08ad7492d3', '阿克苏地区', NULL, NULL, 437, '703913de-6889-4224-b817-077aa75aed29', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('b844b23e-c209-4691-8773-29f9f7f080e6', '防城港市', NULL, NULL, 160, 'a2630f50-39ed-4f27-bf0c-66c1d3f27df7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('b85d2a61-b018-431a-9609-2ca0841f5cab', '盐城市', NULL, NULL, 78, 'f325b6b1-424e-4a4f-801f-7029191b47ee', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('b899bf86-aa99-4e70-a544-8ebe64da4f24', '海口市', NULL, NULL, 423, '1217c9af-748a-4b42-a120-23f89f79bea0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('b9b94634-b449-4449-9581-c70550dc5099', '湘西州', NULL, NULL, 248, '1d0d0600-479b-418e-be8c-3eb615b39a3d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('ba612057-dda4-4e54-9951-f847a74f623e', '三门峡市', NULL, NULL, 386, '84d6d546-171d-43cc-92a1-fb35022c3dd9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('baa2f053-c419-40c1-93fe-68e081b7f229', '西宁市', NULL, NULL, 301, '0b9f22d0-5c63-44aa-ad88-469af891fd96', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('baaceb68-ffec-405f-8bcc-9d58ab5a0c1e', '白山市', NULL, NULL, 6, '396fd2ae-3194-4a75-9145-bbd81bee07f2', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('bcaf1f36-5459-4e74-81d1-5026680b1a9c', '九江市', NULL, NULL, 15, '1929cb4b-3475-4a0f-bf80-bb118b0af8b9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('bda1d0f2-1476-4e0d-8fb9-2d1392397cbb', '漳州市', NULL, NULL, 230, '9160df58-c1dc-4c78-a774-709d4e3c12f7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('be39aa7b-a993-4abd-956c-dcb299cc7bc3', '蚌埠市', NULL, NULL, 62, 'd0722fc6-feb8-45ba-9d1c-f30871f67063', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('be93aa9b-d81f-4e98-a0c0-18f840594a05', '滨州市', NULL, NULL, 297, '8e7f4270-162a-4737-941a-f6ef2b6b580b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('bea9983e-fee5-44d8-9884-18c75d7d052d', '连云港市', NULL, NULL, 75, 'f325b6b1-424e-4a4f-801f-7029191b47ee', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('c0064cbf-ba5c-4dc0-a855-b330e096cd61', '丹东市', NULL, NULL, 398, '58f94c9d-5db7-4a98-92da-13b8bdea3e1a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('c03520db-2a67-4cae-a658-4806d4254996', '淄博市', NULL, NULL, 287, '8e7f4270-162a-4737-941a-f6ef2b6b580b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('c0c88cbd-87ea-4281-9e8e-94a435ae6590', '榆林市', NULL, NULL, 106, '2e931610-54aa-4dc4-9f29-9b9a300778c0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('c262a40d-a147-4930-b33b-574ec51fa884', '甘孜藏族自治州', NULL, NULL, 373, 'e4da2d14-50b9-4520-9439-c9c8cf1de7e3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('c2e61b39-2188-4b9c-a36f-ef7b600b0188', '许昌市', NULL, NULL, 384, '84d6d546-171d-43cc-92a1-fb35022c3dd9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('c2eab125-e437-4681-9331-695a7b3b1ecf', '益阳市', NULL, NULL, 244, '1d0d0600-479b-418e-be8c-3eb615b39a3d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('c31a65eb-4d77-4b38-8142-9c9e2f54ed46', '呼伦贝尔市', NULL, NULL, 39, '96394a43-eab6-4626-8b1f-040309f8ff0e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('c33c3107-81df-4ced-8b92-d694df412da3', '铜梁县', NULL, NULL, 190, 'ddd88468-4142-4189-a6c6-f3dfd00515d0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('c35b997d-64f4-42d2-92c6-a0090291ed08', '平谷区', NULL, NULL, 282, 'f819d7b2-0e42-4500-a124-2ce0a2d6e19e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('c3c4411b-8905-45b4-b38f-09be90102664', '阳泉市', NULL, NULL, 129, '2faaa422-5236-4d12-a27b-abfbba1ef767', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('c470aa47-a334-4df9-a8ea-b90683ddc861', '宝山区', NULL, NULL, 255, '7bb2549c-c713-4012-a420-98ef94687b76', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('c4a03fda-5974-48cb-aa3d-02dc88772bc0', '钓鱼岛', NULL, NULL, 10, 'ed981e82-0939-4732-b6d7-7f586b73a276', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('c5cc1924-02da-4927-982d-54f0b9f70ef8', '宁波市', NULL, NULL, 22, '8379b422-0672-48b5-a879-2a2250e53088', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('c5e2b320-fd7d-448b-9a02-4fb93e1d3302', '大庆市', NULL, NULL, 117, 'ebff77a5-f7d9-481e-8285-b1bad1af16ee', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('c6ac73d4-9854-403a-9b61-12c22eeb4903', '济南市', NULL, NULL, 285, '8e7f4270-162a-4737-941a-f6ef2b6b580b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('c6f12750-ac26-4f30-8705-bd3807488895', '东丽区', NULL, NULL, 86, '0e600cd7-eb9b-4f91-8772-96eee4043deb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('c7a0d698-4738-4ad6-a378-5abea095d54f', '渝中区', NULL, NULL, 204, 'ddd88468-4142-4189-a6c6-f3dfd00515d0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('c7d6739c-4d7d-4d8f-bf6e-d6a6a7d38f20', '永州市', NULL, NULL, 245, '1d0d0600-479b-418e-be8c-3eb615b39a3d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('c8bf9a67-2bfc-47fe-9580-3f2f2eac1edb', '五指山市', NULL, NULL, 411, '1217c9af-748a-4b42-a120-23f89f79bea0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('c8df6064-e107-46b5-b861-acd5b509b146', '大同市', NULL, NULL, 128, '2faaa422-5236-4d12-a27b-abfbba1ef767', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('c8f594a3-8acc-48a9-ba2f-e76934de05eb', '凉山彝族自治州', NULL, NULL, 374, 'e4da2d14-50b9-4520-9439-c9c8cf1de7e3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('c9781b3d-f13b-42a5-962f-df7de65d2033', '黄南州', NULL, NULL, 304, '0b9f22d0-5c63-44aa-ad88-469af891fd96', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('c99528d5-bed7-4890-b547-f2159ed13a78', '崇左市', NULL, NULL, 154, 'a2630f50-39ed-4f27-bf0c-66c1d3f27df7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('caa97f6a-9b5e-4871-968e-42852537e6f0', '孝感市', NULL, NULL, 208, 'e0e5fdc2-1cc8-4743-84d1-2f3f5a88ad3e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('cae0a47d-0d79-4fa6-aac9-e8b3b535ee3c', '三明市', NULL, NULL, 227, '9160df58-c1dc-4c78-a774-709d4e3c12f7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('cc124ed6-091a-42ce-a87a-bb4d0d7357b8', '秀山县', NULL, NULL, 187, 'ddd88468-4142-4189-a6c6-f3dfd00515d0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('cdeda821-2101-44e1-a986-183436199f05', '株洲市', NULL, NULL, 235, '1d0d0600-479b-418e-be8c-3eb615b39a3d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('cf24a0a2-c56e-45df-920c-8247c771d48e', '南昌市', NULL, NULL, 11, '1929cb4b-3475-4a0f-bf80-bb118b0af8b9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('cff58e36-5b90-4beb-a3b7-e04021d244cb', '娄底市', NULL, NULL, 247, '1d0d0600-479b-418e-be8c-3eb615b39a3d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('d133a3fc-3db0-426f-8a04-e25b44a5565c', '怀化市', NULL, NULL, 246, '1d0d0600-479b-418e-be8c-3eb615b39a3d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('d17f8f8e-b3dd-4818-a89d-8b431ff5c555', '南岸区', NULL, NULL, 199, 'ddd88468-4142-4189-a6c6-f3dfd00515d0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('d1c1539c-b904-4bcc-a034-96213f63d0ff', '顺义区', NULL, NULL, 278, 'f819d7b2-0e42-4500-a124-2ce0a2d6e19e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('d4910db5-a704-4273-bd13-a6dc05f468cf', '包头市', NULL, NULL, 34, '96394a43-eab6-4626-8b1f-040309f8ff0e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('d56c2ee6-b81c-4df8-ba2f-3df7680243c4', '阿坝藏族羌族自治州', NULL, NULL, 372, 'e4da2d14-50b9-4520-9439-c9c8cf1de7e3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('d5ab951d-20ab-46ff-8838-de5efe06b6b8', '延庆县', NULL, NULL, 283, 'f819d7b2-0e42-4500-a124-2ce0a2d6e19e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('d5bceaed-c2c5-4104-a42c-4c9c8114c7c9', '大兴区', NULL, NULL, 277, 'f819d7b2-0e42-4500-a124-2ce0a2d6e19e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('d6095cf5-28d0-419b-a799-9a3c87594720', '钦州市', NULL, NULL, 161, 'a2630f50-39ed-4f27-bf0c-66c1d3f27df7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('d795e41b-eb16-4383-b762-ea557481f8e1', '十堰市', NULL, NULL, 219, 'e0e5fdc2-1cc8-4743-84d1-2f3f5a88ad3e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('d7b363e4-0010-4dd0-81d9-387b640a7e42', '静安区', NULL, NULL, 251, '7bb2549c-c713-4012-a420-98ef94687b76', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('d7efec13-7e84-436d-8390-41868af0e359', '昆明市', NULL, NULL, 139, '26d8b6aa-81ec-4e94-8920-d7a36b63aa0d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('d7f44c2a-2728-4633-a8b6-7643136bc99d', '梁平县', NULL, NULL, 170, 'ddd88468-4142-4189-a6c6-f3dfd00515d0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('d80168e9-9b95-4dbe-8977-d2e37c07e946', '六盘水市', NULL, NULL, 345, '36043ac3-9d21-4010-877d-f47338210b63', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('d83aabcc-3c2e-4b48-962a-c548442bc896', '大连市', NULL, NULL, 394, '58f94c9d-5db7-4a98-92da-13b8bdea3e1a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('d94ce52b-fe8c-47d7-9b1a-d37da377cbbe', '安阳市', NULL, NULL, 382, '84d6d546-171d-43cc-92a1-fb35022c3dd9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('d998f8bc-c659-47ce-8e5e-a6b29e03ecb3', '荣昌县', NULL, NULL, 189, 'ddd88468-4142-4189-a6c6-f3dfd00515d0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('db61cc5b-b13b-417f-a232-7925ffdfa9b2', '普洱市', NULL, NULL, 143, '26d8b6aa-81ec-4e94-8920-d7a36b63aa0d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('dbd204cb-29de-4212-8c03-c2286f2ba4f5', '佛山市', NULL, NULL, 336, 'e38eaf87-f8ec-41f1-9540-00d6274220b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('dccf3d25-c012-444b-94c6-bbcbae7e63d8', '长沙市', NULL, NULL, 234, '1d0d0600-479b-418e-be8c-3eb615b39a3d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('dcdb1184-ab1f-4332-8ca0-f4edfd7cc087', '张掖市', NULL, NULL, 312, 'c06e1be0-e0fb-40bf-b39c-9cf01d96007d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('dce7fe20-4766-408d-92be-62ba8fbb7a43', '铜仁市', NULL, NULL, 347, '36043ac3-9d21-4010-877d-f47338210b63', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('dd15d032-477c-4f54-9629-ea782606b468', '南平市', NULL, NULL, 231, '9160df58-c1dc-4c78-a774-709d4e3c12f7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('dd4a8577-afbe-449b-ae9b-be374a4c7434', '赣州市', NULL, NULL, 21, '1929cb4b-3475-4a0f-bf80-bb118b0af8b9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('dd99fcda-6192-4ada-bef5-b04735e7dae8', '常德市', NULL, NULL, 241, '1d0d0600-479b-418e-be8c-3eb615b39a3d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('de003161-c00c-4f8a-ac92-6a2188069e9b', '四平市', NULL, NULL, 3, '396fd2ae-3194-4a75-9145-bbd81bee07f2', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('de41020d-a8dc-44d0-a2d4-75b6076c0ae8', '台州市', NULL, NULL, 25, '8379b422-0672-48b5-a879-2a2250e53088', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('de59cca6-548c-4009-9776-5daae2b866a6', '太原市', NULL, NULL, 127, '2faaa422-5236-4d12-a27b-abfbba1ef767', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('def0f6fb-9804-4bed-8554-2115bfca9849', '通化市', NULL, NULL, 5, '396fd2ae-3194-4a75-9145-bbd81bee07f2', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('def78b05-5d2b-430c-b268-442502dc3ca5', '铁岭市', NULL, NULL, 406, '58f94c9d-5db7-4a98-92da-13b8bdea3e1a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('dfb8b556-10a2-43ab-9fdb-66cde92320ee', '香港特别行政区', NULL, NULL, 407, '85e12347-dc0c-40a3-ba7d-531c718ca98d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('e04fe06c-7641-47c7-a125-4d35e1800549', '菏泽市', NULL, NULL, 298, '8e7f4270-162a-4737-941a-f6ef2b6b580b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('e11c17b6-eb2f-4d32-9de9-48ab1440c8c7', '汕尾市', NULL, NULL, 332, 'e38eaf87-f8ec-41f1-9540-00d6274220b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('e16eafe9-9ca0-4609-8c8c-a1b16b52669f', '濮阳市', NULL, NULL, 383, '84d6d546-171d-43cc-92a1-fb35022c3dd9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('e20441c5-c8b4-493a-9738-2327e656fbcb', '徐州市', NULL, NULL, 74, 'f325b6b1-424e-4a4f-801f-7029191b47ee', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('e27d8c07-338c-4b1a-b45c-cf9cf0a22a0c', '黑河市', NULL, NULL, 122, 'ebff77a5-f7d9-481e-8285-b1bad1af16ee', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('e3fa5765-1e86-4f89-a751-2f63dbe81c99', '黄山市', NULL, NULL, 50, 'd0722fc6-feb8-45ba-9d1c-f30871f67063', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('e42fbad8-c29e-4f35-878d-95a667b5cc90', '咸阳市', NULL, NULL, 112, '2e931610-54aa-4dc4-9f29-9b9a300778c0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('e509a1a5-95da-4fb2-9a2b-f84afa05a36c', '忠县', NULL, NULL, 180, 'ddd88468-4142-4189-a6c6-f3dfd00515d0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('e60d3fe5-6d26-4a3f-b920-8fb6c4986bfb', '三亚市', NULL, NULL, 409, '1217c9af-748a-4b42-a120-23f89f79bea0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('e6436d79-8045-4185-b2b2-22cd280d22b0', '喀什地区', NULL, NULL, 438, '703913de-6889-4224-b817-077aa75aed29', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('e658aec8-1268-4349-a3f5-570b669a4f06', '无锡市', NULL, NULL, 84, 'f325b6b1-424e-4a4f-801f-7029191b47ee', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('e6678936-cb1f-4a28-9b29-fb553d2adf87', '三沙市', NULL, NULL, 422, '1217c9af-748a-4b42-a120-23f89f79bea0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('e6e46871-d5a0-4d2b-8243-9d4bd864ab43', '武汉市', NULL, NULL, 216, 'e0e5fdc2-1cc8-4743-84d1-2f3f5a88ad3e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('e6e5b9bd-f324-448f-8776-8e7eb18ca5d4', '东城区', NULL, NULL, 269, 'f819d7b2-0e42-4500-a124-2ce0a2d6e19e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('e6f53877-d5bf-4b42-aded-5ab8960ef034', '伊犁州', NULL, NULL, 443, '703913de-6889-4224-b817-077aa75aed29', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('e86879a9-9808-4629-8311-39d63744f2fb', '威海市', NULL, NULL, 292, '8e7f4270-162a-4737-941a-f6ef2b6b580b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('e95188c1-3039-4900-8807-ea71ede68871', '汉沽区', NULL, NULL, 99, '0e600cd7-eb9b-4f91-8772-96eee4043deb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('e95972c4-fd28-45ac-b9da-9aee0057d3d0', '焦作市', NULL, NULL, 379, '84d6d546-171d-43cc-92a1-fb35022c3dd9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('e98653ba-264e-4417-b74e-e0798b25e646', '屯昌县', NULL, NULL, 415, '1217c9af-748a-4b42-a120-23f89f79bea0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('ea11feaf-194c-4cec-be59-d17bac402db4', '仙桃市', NULL, NULL, 224, 'e0e5fdc2-1cc8-4743-84d1-2f3f5a88ad3e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('eb4d8886-4710-4809-8f77-b3caa4b4904e', '贵港市', NULL, NULL, 162, 'a2630f50-39ed-4f27-bf0c-66c1d3f27df7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('eb551697-7acc-4bcd-9d21-3d48c16f8258', '鄂尔多斯市', NULL, NULL, 40, '96394a43-eab6-4626-8b1f-040309f8ff0e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('ecba10ba-2c25-4ead-a781-ad16a832226f', '恩施州', NULL, NULL, 211, 'e0e5fdc2-1cc8-4743-84d1-2f3f5a88ad3e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('ed217127-f5a1-4f77-b32d-75d0114bce26', '海南州', NULL, NULL, 305, '0b9f22d0-5c63-44aa-ad88-469af891fd96', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('ee710091-bfa9-4285-89e3-80ad65ebd912', '玉林市', NULL, NULL, 163, 'a2630f50-39ed-4f27-bf0c-66c1d3f27df7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('eea322d8-1faf-4a08-a7f9-1d097375a96d', '武威市', NULL, NULL, 311, 'c06e1be0-e0fb-40bf-b39c-9cf01d96007d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('ef3ce48f-e710-4c8e-9945-8fd849aa8e34', '普陀区', NULL, NULL, 263, '7bb2549c-c713-4012-a420-98ef94687b76', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('ef4b5cd7-d6b5-4839-9963-c010487ba475', '黔南州', NULL, NULL, 352, '36043ac3-9d21-4010-877d-f47338210b63', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('ef951e0d-15d6-4343-901d-8412af9b0b93', '石嘴山市', NULL, NULL, 46, '21a4d8bb-76d8-4dcb-b317-00ff122cff6d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('efb72ec7-b29f-48d0-a16c-9a33d3938d49', '绵阳市', NULL, NULL, 359, 'e4da2d14-50b9-4520-9439-c9c8cf1de7e3', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('eff5ed18-ee14-4201-876c-3c40dd858438', '嘉峪关市', NULL, NULL, 321, 'c06e1be0-e0fb-40bf-b39c-9cf01d96007d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('f02f3013-3723-48cb-9461-451981c81059', '景德镇市', NULL, NULL, 12, '1929cb4b-3475-4a0f-bf80-bb118b0af8b9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('f09dfd05-ae12-4875-8ff6-98901e8e7c28', '闸北区', NULL, NULL, 252, '7bb2549c-c713-4012-a420-98ef94687b76', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('f2727650-b0d9-4541-acdb-b4eabf894893', '中山市', NULL, NULL, 334, 'e38eaf87-f8ec-41f1-9540-00d6274220b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('f3717726-7743-4838-852b-3a09f9528a69', '烟台市', NULL, NULL, 291, '8e7f4270-162a-4737-941a-f6ef2b6b580b', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('f3e12d68-f8c5-4d9d-8314-dd1ce7dac2f9', '周口市', NULL, NULL, 389, '84d6d546-171d-43cc-92a1-fb35022c3dd9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('f476b47a-b7f5-4632-8219-13b93e018735', '红桥区', NULL, NULL, 91, '0e600cd7-eb9b-4f91-8772-96eee4043deb', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('f491d9c3-9527-46a4-8954-6795ff079478', '万宁市', NULL, NULL, 425, '1217c9af-748a-4b42-a120-23f89f79bea0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('f4bc760a-86e0-4fa1-a5e9-cdc21cc7a127', '秦皇岛市', NULL, NULL, 453, '4aab8599-afb8-4552-82d5-5ff97dc7b780', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('f4e36f9a-e006-44a6-8d77-47971d41810b', '齐齐哈尔市', NULL, NULL, 125, 'ebff77a5-f7d9-481e-8285-b1bad1af16ee', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('f530455e-1c70-47dd-9a80-4bc74a4e2680', '杭州市', NULL, NULL, 27, '8379b422-0672-48b5-a879-2a2250e53088', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('f5314eed-cd10-44d2-b656-d62d633c813d', '高新区', NULL, NULL, 205, 'ddd88468-4142-4189-a6c6-f3dfd00515d0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('f56fa64d-ca06-49d2-a9cb-94742a33af21', '百色市', NULL, NULL, 165, 'a2630f50-39ed-4f27-bf0c-66c1d3f27df7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('f583e1ae-7239-4815-b3c7-c5538eb73da9', '鸡西市', NULL, NULL, 116, 'ebff77a5-f7d9-481e-8285-b1bad1af16ee', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('f5ebab20-0f47-47e8-b896-6f3d9651c97a', '平顶山市', NULL, NULL, 378, '84d6d546-171d-43cc-92a1-fb35022c3dd9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('f63c9587-7455-4dff-950d-0da6dddd16c1', '来宾市', NULL, NULL, 167, 'a2630f50-39ed-4f27-bf0c-66c1d3f27df7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('f6eb800d-2093-4ce2-8105-3747d69abe97', '闵行区', NULL, NULL, 256, '7bb2549c-c713-4012-a420-98ef94687b76', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('f7038861-43d2-49c3-a5c9-53fde2c139fa', '山南地区', NULL, NULL, 70, '40f427b4-ccc4-4967-8ce4-f9b9023d24b7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('f83a5a46-d0a9-4094-96cd-369ddab61388', '台湾市', NULL, NULL, 353, '46cdadf4-c40f-4904-9e7a-b5aeb691d627', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('f856399f-e403-4734-abb9-b972db76c06b', '辽阳市', NULL, NULL, 404, '58f94c9d-5db7-4a98-92da-13b8bdea3e1a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('f951b5e7-debd-4c51-9c02-03ebe84ebbfc', '惠州市', NULL, NULL, 331, 'e38eaf87-f8ec-41f1-9540-00d6274220b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('f95958de-a678-4371-9710-6bcac3f425fa', '延安市', NULL, NULL, 104, '2e931610-54aa-4dc4-9f29-9b9a300778c0', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('f9ca7af3-a2b5-4d1c-a8c5-c4dbe4fe60e1', '扬州市', NULL, NULL, 79, 'f325b6b1-424e-4a4f-801f-7029191b47ee', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('fa27d3fb-a80f-4b4c-8d0c-bf7d544bb974', '宜春市', NULL, NULL, 18, '1929cb4b-3475-4a0f-bf80-bb118b0af8b9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('fa34c22b-c1d8-45b2-bb1b-4ea08298e7f6', '奉贤区', NULL, NULL, 262, '7bb2549c-c713-4012-a420-98ef94687b76', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('fadbb851-aec5-4d3e-be0e-09e7462eaceb', '文山州', NULL, NULL, 147, '26d8b6aa-81ec-4e94-8920-d7a36b63aa0d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('fae5ed6b-9b68-4ef9-93fa-221dea13a975', '那曲地区', NULL, NULL, 69, '40f427b4-ccc4-4967-8ce4-f9b9023d24b7', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('fb0dbd60-1d03-4394-a890-ffc2d3ec6a37', '开封市', NULL, NULL, 376, '84d6d546-171d-43cc-92a1-fb35022c3dd9', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('fc26f78a-1b0b-4967-8d26-df9e530e5260', '定西市', NULL, NULL, 316, 'c06e1be0-e0fb-40bf-b39c-9cf01d96007d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('fc30b5e5-3005-4778-94f7-706b31514bff', '运城市', NULL, NULL, 136, '2faaa422-5236-4d12-a27b-abfbba1ef767', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('fca062e6-ca02-4963-9f79-ed8cbfbb11df', '阜新市', NULL, NULL, 403, '58f94c9d-5db7-4a98-92da-13b8bdea3e1a', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('fcc07455-c69c-4c90-82cb-ddb268adb8a9', '崇明县', NULL, NULL, 264, '7bb2549c-c713-4012-a420-98ef94687b76', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('fcd4a18f-a57a-47c4-b2f2-504bc8bccb20', '绥化市', NULL, NULL, 123, 'ebff77a5-f7d9-481e-8285-b1bad1af16ee', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('fd718129-208d-4a94-9e52-7516af8ef013', '深圳市', NULL, NULL, 324, 'e38eaf87-f8ec-41f1-9540-00d6274220b8', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('fe94b712-ef16-4435-a491-7601776344cf', '阿拉善盟', NULL, NULL, 42, '96394a43-eab6-4626-8b1f-040309f8ff0e', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('feece7c8-8eeb-494a-8e84-571b6ebcf0d9', '大理州', NULL, NULL, 151, '26d8b6aa-81ec-4e94-8920-d7a36b63aa0d', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
INSERT INTO `L_CITY`
VALUES ('ffe07042-807c-4f16-a63c-c1eb8785b06b', '晋城市', NULL, NULL, 130, '2faaa422-5236-4d12-a27b-abfbba1ef767', 1,
        'ENhwBAJPZuSgIAE5EDakR6yrIQbOoOPq', 'cn', NULL, '2019-06-17 11:04:18', NULL, NULL);
COMMIT;

SET FOREIGN_KEY_CHECKS = 1;
